/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.resolver.internal.ant;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.maven.resolver.internal.ant.org.apache.maven.model.Model;
import org.apache.maven.resolver.internal.ant.org.eclipse.aether.artifact.Artifact;
import org.apache.maven.resolver.internal.ant.org.eclipse.aether.artifact.DefaultArtifact;
import org.apache.maven.resolver.internal.ant.org.eclipse.aether.repository.WorkspaceReader;
import org.apache.maven.resolver.internal.ant.org.eclipse.aether.repository.WorkspaceRepository;
import org.apache.maven.resolver.internal.ant.org.eclipse.aether.util.artifact.ArtifactIdUtils;
import org.apache.maven.resolver.internal.ant.types.Pom;

public class ProjectWorkspaceReader
implements WorkspaceReader {
    private static volatile ProjectWorkspaceReader instance;
    private static final Object LOCK;
    private Map<String, Artifact> artifacts = new ConcurrentHashMap<String, Artifact>();

    public void addPom(Pom pom) {
        if (pom.getFile() != null) {
            Model model = pom.getModel(pom);
            Artifact aetherArtifact = new DefaultArtifact(model.getGroupId(), model.getArtifactId(), null, "pom", model.getVersion());
            aetherArtifact = aetherArtifact.setFile(pom.getFile());
            String coords = this.coords(aetherArtifact);
            this.artifacts.put(coords, aetherArtifact);
        }
    }

    public void addArtifact(org.apache.maven.resolver.internal.ant.types.Artifact artifact) {
        if (artifact.getPom() != null) {
            Artifact aetherArtifact;
            Pom pom = artifact.getPom();
            if (pom.getFile() != null) {
                Model model = pom.getModel(pom);
                aetherArtifact = new DefaultArtifact(model.getGroupId(), model.getArtifactId(), artifact.getClassifier(), artifact.getType(), model.getVersion());
            } else {
                aetherArtifact = new DefaultArtifact(pom.getGroupId(), pom.getArtifactId(), artifact.getClassifier(), artifact.getType(), pom.getVersion());
            }
            aetherArtifact = aetherArtifact.setFile(artifact.getFile());
            String coords = this.coords(aetherArtifact);
            this.artifacts.put(coords, aetherArtifact);
        }
    }

    private String coords(Artifact artifact) {
        return ArtifactIdUtils.toId(artifact);
    }

    @Override
    public WorkspaceRepository getRepository() {
        return new WorkspaceRepository("ant");
    }

    @Override
    public File findArtifact(Artifact artifact) {
        return (artifact = this.artifacts.get(this.coords(artifact))) != null ? artifact.getFile() : null;
    }

    @Override
    public List<String> findVersions(Artifact artifact) {
        ArrayList<String> versions = new ArrayList<String>();
        for (Artifact art : this.artifacts.values()) {
            if (!ArtifactIdUtils.equalsVersionlessId(artifact, art)) continue;
            versions.add(art.getVersion());
        }
        return versions;
    }

    ProjectWorkspaceReader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProjectWorkspaceReader getInstance() {
        if (instance == null) {
            Object object = LOCK;
            synchronized (object) {
                if (instance == null) {
                    instance = new ProjectWorkspaceReader();
                }
            }
        }
        return instance;
    }

    static void dropInstance() {
        instance = null;
    }

    static {
        LOCK = new Object();
    }
}

