/* ------------------------------------------------------------------------
 *
 * scaler.c
 *
 * Short description:
 *
 * ------------------------------------------------------------------------
 *
 * Copyright (c) 2017, Ericsson Canada Inc
 * All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice, this
 * list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 * Neither the name of the copyright holders nor the names of its
 * contributors may be used to endorse or promote products derived from this
 * software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * ------------------------------------------------------------------------
 */

#include <sys/types.h>
#include <sys/socket.h>
#include <sys/wait.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <sys/param.h>
#include <errno.h>
#include <unistd.h>
#include <netinet/in.h>
#include <tipcc.h>
#include <sys/poll.h>
#include <sys/time.h>
#include <sys/prctl.h>
#include <common.h>

void scaler_main(uint32_t node)
{
	struct tipc_addr memberid = {COMMAND_GROUP, SCALER_ID, node};
	struct tipc_addr sockid;
	struct tipc_addr srcid;
	struct command_hdr hdr;
	struct pollfd pfd = {0, POLLIN, 0};
	char str[60], str2[60];
	int rc, err;

	pfd.fd = tipc_socket(SOCK_RDM);
	if (pfd.fd < 0)
		die("Failed to create scaler member socket\n");
	tipc_join(pfd.fd, &memberid, true, false);
	tipc_ntoa(&memberid, str, sizeof(str));
	tipc_sockaddr(pfd.fd, &sockid);
	tipc_ntoa(&sockid, str2, sizeof(str2));
	dbg1("Scaler: Joined Command Group as %s/%s\n", str, str2);
	printf("Waiting for Commander\n");

	while (1) {
		rc = poll(&pfd, 1, -1);
		if (rc < 0)
			die("Scaler: poll() failed\n");
		rc = tipc_recvfrom(pfd.fd, &hdr, sizeof(hdr),
				   &srcid, &memberid, &err);
		if (memberid.instance != COMMANDER_ID)
			continue;
		if (rc == 0) {
			tipc_ntoa(&memberid, str, sizeof(str));
			tipc_ntoa(&srcid, str2, sizeof(str2));
			printf("%s Commander %s/%s\n",
			       err ? "Lost" : "Discovered", str, str2);
			continue;
		}
		if (rc != sizeof(hdr))
			die("Scaler: received illegal command msg\n");

		hdr.cmd = ntohl(hdr.cmd);
		hdr.memberid = ntohl(hdr.memberid);

		if (hdr.cmd == CREATE_WORKER) {
			dbg2("Scaler: Received Command %s\n", cmdstr(hdr.cmd));
			worker_main(hdr.memberid, false, node);
			continue;
		}
		printf("Scaler: Received %s\n", errstr(hdr.cmd));
	}
}
