/* Copyright 2021 The Chromium OS Authors. All rights reserved.
 * Use of this source code is governed by a BSD-style license that can be
 * found in the LICENSE file.
 */

#ifndef __ZEPHYR_GPIO_MAP_H
#define __ZEPHYR_GPIO_MAP_H

#include <devicetree.h>
#include <gpio_signal.h>

/*
 * Without https://github.com/zephyrproject-rtos/zephyr/pull/29282, we need
 * to manually link GPIO_ defines that platform/ec code expects to the
 * enum gpio_signal values that are generated by device tree bindings.
 *
 * Note we only need to create aliases for GPIOs that are referenced in common
 * platform/ec code.
 */
#define GPIO_TEMP_SENSOR_POWER GPIO_PG_EC_DSW_PWROK

#define EC_CROS_GPIO_INTERRUPTS                                             \
	GPIO_INT(GPIO_AC_PRESENT, GPIO_INT_EDGE_BOTH, extpower_interrupt)   \
	GPIO_INT(GPIO_USB_C0_TCPC_INT_ODL, GPIO_INT_EDGE_FALLING,           \
		 tcpc_alert_event)                                          \
	GPIO_INT(GPIO_USB_C1_TCPC_INT_ODL, GPIO_INT_EDGE_FALLING,           \
		 tcpc_alert_event)                                          \
	GPIO_INT(GPIO_USB_C0_PPC_INT_ODL, GPIO_INT_EDGE_FALLING, ppc_alert) \
	GPIO_INT(GPIO_USB_C1_PPC_INT_ODL, GPIO_INT_EDGE_FALLING, ppc_alert) \
	GPIO_INT(GPIO_SWITCHCAP_PG_INT_L, GPIO_INT_EDGE_FALLING,            \
		 ln9310_interrupt)                                          \

#endif /* __ZEPHYR_GPIO_MAP_H */
