#ifndef H_CDW_MAIN_WINDOW
#define H_CDW_MAIN_WINDOW

#include <stdbool.h>

#include "main.h" /* cdw_rv_t */
#include "cdw_disc.h"
#include "cdw_ncurses.h"



/*
________________________________________________________
|_______________ _____________________________________ |
||             | |                                   | |
||             | |                                   | |
||             | |                                   | |
||             | |                                   | |
|| main menu   | |         files list                | |
||             | |                                   | |
||             | |                                   | |
||             | |                                   | |
||             | |                                   | |
||             | |                                   | |
||             | |                                   | |
||_____________| |___________________________________| |
|_______________ _____________________________________ |
||             | |                                   | |
||  disc info  | |         volume info               | |
||             | |                                   | |
||_____________| |___________________________________| |
|______________________________________________________|

*/



/* be careful with order of fields in this enum - it has to be the same
 * as order of button labels in main menu built in cdw_ui.c */
typedef enum menu_items {
	CDW_MENU_ADD_FILES = 0,
	CDW_MENU_DELETE_FILES,
	CDW_MENU_BURN_FILES,
	CDW_MENU_CREATE_IMAGE,
	CDW_MENU_BURN_IMAGE,
	CDW_MENU_RIP_DISC,
	CDW_MENU_ERASE_DISC,
	CDW_MENU_VERIFY,
	CDW_MENU_CONFIG,
	CDW_MENU_ABOUT,
	CDW_MENU_EXIT_CDW
} cdw_menu_items_t;


/* Volume info area has 4 rows for contents + 2 rows for upper and
   lower border. */
/* Disc info area has the same height: 4 lines of usable space
   (Type?, Empty?, Writable?, Erasable?) + 2 lines for borders */
#define CDW_UI_VOLUME_VIEW_N_ROWS (4 + 2)

/* The very last row in main window. Just one line of text. */
#define CDW_UI_TOOLTIPS_VIEW_N_ROWS (1)


cdw_rv_t cdw_main_window_module_init(void);
void     cdw_main_window_module_clean(void);


void cdw_main_window_wrefresh_part(int n_lines, int n_cols, int begin_y, int begin_x);
void cdw_main_window_wrefresh(void);

void cdw_main_window_disc_info_view_display_data(const cdw_disc_t *disc);

cdw_rv_t cdw_main_window_volume_info_view_update(long long disc_sectors_used, long long disc_sectors_total, bool rescan_selected_files);

cdw_rv_t cdw_main_window_add_to_selected_files(void);
cdw_rv_t cdw_main_window_delete_from_selected_files(void);

void cdw_about(void);
void cdw_main_window_show_license(void);

void cdw_main_window_handle_follow_symlinks_change(bool old_state, bool current_state);

WINDOW *cdw_main_window_get_tooltips_subwindow(void);
WINDOW *cdw_main_window_get_main_window(void);
MENU   *cdw_main_window_get_main_menu(void);

#endif /* H_CDW_MAIN_WINDOW */
