#include "cursor.h"

#include "building/construction.h"
#include "game/system.h"
#include "window/city.h"

static const cursor ARROW[] = {
    {
        0, 0, 13, 21, "Arrow.png",
        "#            "
        "##           "
        "#'#          "
        "#''#         "
        "#'''#        "
        "#''''#       "
        "#'''''#      "
        "#''''''#     "
        "#'''''''#    "
        "#''''''''#   "
        "#'''''''''#  "
        "#''''''''''# "
        "#''''''######"
        "#'''#''#     "
        "#''# #''#    "
        "#'#  #''#    "
        "##    #''#   "
        "#     #''#   "
        "       #''#  "
        "       #''#  "
        "        ##   "
    },
    {
        0, 0, 18, 30, "Arrow_150.png",
        "#                 "
        "##                "
        "#&#               "
        "#'&#              "
        "#''&#             "
        "#'''&#            "
        "#''''&#           "
        "#'''''&#          "
        "#''''''&#         "
        "#'''''''&#        "
        "#''''''''&#       "
        "#'''''''''&#      "
        "#''''''''''&#     "
        "#'''''''''''&#    "
        "#''''''''''''&#   "
        "#'''''''''''''&#  "
        "#''''''''''''''&# "
        "#'''''''''''''''$#"
        "#'''''''&#########"
        "#''''$%''$        "
        "#'''$##&'&#       "
        "#''$#  $''%#      "
        "#&#    #&''#      "
        "##      #''%#     "
        "#       #%''#     "
        "         #''&#    "
        "         #%''$    "
        "          #&'&#   "
        "           $'&#   "
        "           ###    "
    },
    {
        0, 0, 24, 40, "Arrow_200.png",
        "#                       "
        "##                      "
        "#&#                     "
        "#'&#                    "
        "#''&#                   "
        "#'''&#                  "
        "#''''&#                 "
        "#'''''&#                "
        "#''''''&#               "
        "#'''''''&#              "
        "#''''''''&#             "
        "#'''''''''&#            "
        "#''''''''''&#           "
        "#'''''''''''&#          "
        "#''''''''''''&#         "
        "#'''''''''''''&#        "
        "#''''''''''''''&#       "
        "#'''''''''''''''&#      "
        "#''''''''''''''''&#     "
        "#'''''''''''''''''&#    "
        "#''''''''''''''''''&#   "
        "#'''''''''''''''''''&#  "
        "#''''''''''''''''''''&# "
        "#'''''''''''''''''''''&#"
        "#''''''''''&############"
        "#''''''&&'''$           "
        "#'''''&##'''&#          "
        "#''''&# #%'''%#         "
        "#''''#   #''''#         "
        "#'''#    #%'''%#        "
        "#''#      #&'''#        "
        "#'$#       $'''&#       "
        "#$#        #&'''$       "
        "##          #'''&#      "
        "#           #%'''%#     "
        "             #''''#     "
        "             #%'''%#    "
        "              #&'''#    "
        "               $'&$#    "
        "               ###      "
    }
};

static const cursor SWORD[] = {
    {
        0, 0, 22, 22, "Sword.png",
        "#####                 "
        "#'''##                "
        "#''''##               "
        "#'''''##              "
        "##'''''##             "
        " ##'''''##            "
        "  ##'''''##           "
        "   ##'''''##          "
        "    ##'''''##         "
        "     ##'''''##        "
        "      ##'''''##       "
        "       ##'''''##      "
        "        ##'''''#####  "
        "         ##'''''#''#  "
        "          ##'''#'''#  "
        "           ##'#'''##  "
        "            ##'''###  "
        "            #'''##'###"
        "            #''##''''#"
        "            ######'''#"
        "                 #''##"
        "                 #### "
    },
    {
        0, 0, 34, 34, "Sword_150.png",
        "######                            "
        "#%&&&##                           "
        "#&'''&##                          "
        "#&''''&##                         "
        "#&'''''&##                        "
        "##&'''''&##                       "
        " ##&'''''&##                      "
        "  ##&'''''&##                     "
        "   ##&'''''&##                    "
        "    ##&'''''&##                   "
        "     ##&'''''&##                  "
        "      ##&'''''&##                 "
        "       ##&'''''&##                "
        "        ##&'''''&##               "
        "         ##&'''''&##              "
        "          ##&'''''&##             "
        "           ##&'''''&##            "
        "            ##&'''''&##           "
        "             ##&'''''&##          "
        "              ##&'''''&########   "
        "               ##&''''''&##&&$#   "
        "                ##&''''&##&''$#   "
        "                 ##&''&##&''&##   "
        "                  ##%&##&''&###   "
        "                   #&##&''&####   "
        "                   ###&''&#####   "
        "                   ##&''&###%$### "
        "                   #&''&###%'%$$##"
        "                   #&'&###%'''''$#"
        "                   #$$####$%''''$#"
        "                   ########$'''&##"
        "                          #$''&#  "
        "                          ##$$##  "
        "                           ####   "
    },
    {
        0, 0, 46, 44, "Sword_200.png",
        "########                                      "
        "#%%%%%%##                                     "
        "#%'''''&##                                    "
        "#%''''''&##                                   "
        "#%'''''''%##                                  "
        "#%''''''''%##                                 "
        "#%'''''''''%##                                "
        "##%'''''''''%##                               "
        " ##%'''''''''%##                              "
        "  ##%'''''''''%##                             "
        "   ##%'''''''''%##                            "
        "    ##%'''''''''%##                           "
        "     ##%'''''''''%##                          "
        "      ##%'''''''''%##                         "
        "       ##%'''''''''%##                        "
        "        ##%'''''''''%##                       "
        "         ##%'''''''''%##                      "
        "          ##%'''''''''%##                     "
        "           ##%'''''''''%##                    "
        "            ##%'''''''''%##                   "
        "             ##%'''''''''%##                  "
        "              ##%'''''''''%##                 "
        "               ##%'''''''''%##                "
        "                ##%'''''''''%##               "
        "                 ##%'''''''''%##              "
        "                  ##%'''''''''%##########     "
        "                   ##%'''''''''%$$##$$$##     "
        "                    ##%''''''''''%#%'''$#     "
        "                     ##%''''''''%#%''''$#     "
        "                      ##%''''''%#%'''''$#     "
        "                       ##%''''%#%'''''%##     "
        "                        ##%''%#%'''''%###     "
        "                         #$'%#%'''''%####     "
        "                         #$%#%'''''%#####     "
        "                         ###%'''''%###%$#     "
        "                         ##%'''''%###%'$####  "
        "                         #$'''''%###%''%$$$## "
        "                         #$''''%###%'''''''$##"
        "                         #$'''%###%''''''''$##"
        "                         ##$$$####$$%'''''''$#"
        "                         ###########$''''$####"
        "                                   #$'''$&#   "
        "                                    #$''$#    "
        "                                     #####    "
    }
};

static const cursor SHOVEL[] = {
    {
        1, 26, 28, 28, "Shovel.png",
        "                       ##   "
        "                      ####  "
        "                     ##'### "
        "                     #'''###"
        "                     ##'''##"
        "                    ####'## "
        "                   ##'####  "
        "                  ##'##     "
        "                 ##'##      "
        "                ##'##       "
        "               ##'##        "
        "              ##'##         "
        "             ##'##          "
        "       #    ##'##           "
        "      #### ##'##            "
        "     #''####'##             "
        "    #''''##'##              "
        "   #''''##'##               "
        "  #''''#'#####              "
        " #''''#'''#'##              "
        " #'''#'''#'''##             "
        "#'''''''#''''#              "
        "#''''''#''''#               "
        "#''''''''''#                "
        "#'''''''''#                 "
        "#''''''''#                  "
        " #'''''##                   "
        "  #####                     "
    },
    {
        2, 39, 44, 41, "Shovel_150.png",
        "                                   ####     "
        "                                 #######    "
        "                                ##%&#####   "
        "                               ##&''$#####  "
        "                               #$'''''$#### "
        "                               #$''''''$####"
        "                               ##&''''''%## "
        "                              ####&''''$##  "
        "                             ##$''##&&&$#   "
        "                            ##$'''$#####    "
        "                           ##$'''$##        "
        "                          ##$'''$##         "
        "                         ##$'''$##          "
        "                        ##$'''$##           "
        "                       ##$'''$##            "
        "                      ##$'''$##             "
        "                     ##$'''$##              "
        "                    ##$'''$##               "
        "         ###       ##$'''$##                "
        "        ##$##     ##$'''$##                 "
        "       ##%'%##   ##$'''$##                  "
        "      ##%'''%## ##$'''$##                   "
        "     ##%'''''%##%''''$##                    "
        "    ##%''''''%#$''''$##                     "
        "   ##%''''''%#$''''$##                      "
        "  ##%''''''%#$#%''$##                       "
        "  #$''''''%#%'%#$###                        "
        "  #&'''''%#%'''$#%%##                       "
        " ##'''''%#%'''%#%''%##                      "
        " #$''''%#%'''%#%''''%##                     "
        " #&''''%%'''%#%''''''$#                     "
        " #&''''''''%#%''''''%##                     "
        "##''''''''%#%''''''%##                      "
        "#$''''''''%%''''''%##                       "
        "#$'''''''''''''''%##                        "
        "#$''''''''''''''%##                         "
        "#$'''''''''''''%##                          "
        "##'''''''''''&$##                           "
        " #%''''''''&$###                            "
        " ##%&''&%$###                               "
        "  #########                                 "
    },
    {
        3, 52, 58, 55, "Shovel_200.png",
        "                                               ##         "
        "                                             ######       "
        "                                            ###&#####     "
        "                                           ##$''&#####    "
        "                                          ##$''''&#####   "
        "                                         ##$'''''''$####  "
        "                                         ##$''''''''$#### "
        "                                         ##$'''''''''$####"
        "                                         ##$''''''''''$###"
        "                                         ###%'''''''''$## "
        "                                        ##%%#%''''''&##   "
        "                                       ##&''%#%''''&##    "
        "                                      ##&''''%#$$$$##     "
        "                                     ##&''''%#######      "
        "                                    ##&''''&###           "
        "                                   ##&''''&##             "
        "                                  ##&''''&##              "
        "                                 ##&''''&##               "
        "                                ##&''''&##                "
        "                               ##&''''&##                 "
        "                              ##&''''&##                  "
        "                             ##&''''&##                   "
        "                            ##&''''&##                    "
        "                           ##&''''&##                     "
        "             ##           ##&''''&##                      "
        "            ####         ##&''''&##                       "
        "           ##%%##       ##&''''&##                        "
        "          ##%''%##     ##&''''&##                         "
        "         ##%''''%##   ##&''''&##                          "
        "        ##%''''''%## ##%''''&##                           "
        "       ##%''''''''%##%'''''&##                            "
        "      ##%'''''''''%#$'''''&##                             "
        "     ##%'''''''''%#%'''''&##                              "
        "    ##%'''''''''%##%''''%##                               "
        "   ##%'''''''''%#%%#%''$##                                "
        "   #$'''''''''%#%''%#%%###                                "
        "   #&''''''''%#%''''%##%%##                               "
        "  ##''''''''%#%'''''%#%''%##                              "
        "  #%'''''''%#%'''''%#%''''%##                             "
        "  #&''''''%#%'''''%#%''''''%##                            "
        "  #''''''&#%'''''%#%''''''''%##                           "
        " #$'''''''&'''''%#%'''''''''%##                           "
        " #%''''''''''''%#%'''''''''%##                            "
        " #&'''''''''''%#%'''''''''%##                             "
        " #&''''''''''&#%'''''''''%##                              "
        " #''''''''''''&'''''''''%##                               "
        " #'''''''''''''''''''''%##                                "
        "##''''''''''''''''''''%##                                 "
        " #'''''''''''''''''''%##                                  "
        " #&'''''''''''''''''%##                                   "
        " #&'''''''''''''''&$##                                    "
        " #$'''''''''''''&$###                                     "
        "  #%'''''''''&%###                                        "
        "   #$%&&&&%$####                                          "
        "    #########                                             "
    }
};

const cursor *input_cursor_data(cursor_shape cursor_id, cursor_scale scale)
{
    switch (cursor_id) {
        case CURSOR_ARROW: return &ARROW[scale];
        case CURSOR_SHOVEL: return &SHOVEL[scale];
        case CURSOR_SWORD: return &SWORD[scale];
        default: return 0;
    }
}

void input_cursor_update(window_id window)
{
    if (window == WINDOW_CITY_MILITARY && !window_city_military_is_cursor_in_menu()) {
        system_set_cursor(CURSOR_SWORD);
    } else if (window == WINDOW_CITY && building_construction_type() == BUILDING_CLEAR_LAND) {
        system_set_cursor(CURSOR_SHOVEL);
    } else {
        system_set_cursor(CURSOR_ARROW);
    }
}
