/*
  gmorgan - a ryhthm station software
  
    GMorgan.h  -  Main declarations
    Copyright (C) 2003-2004 Josep Andreu (Holborn)
    Author: Josep Andreu
        
   This program is free software; you can redistribute it and/or modify
   it under the terms of version 2 of the GNU General Public License
   as published by the Free Software Foundation.
              
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License (version 2) for more details.
                     
   You should have received a copy of the GNU General Public License (version2)
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
   
*/

#ifndef GMORGAN_H 
#define GMORGAN_H

#include <libintl.h>
#include <stdio.h>
#include <ctype.h>
#include "gettext.h"
#include <iostream>
#include <map>
#include <vector>
#include <string>
#include <alsa/asoundlib.h>
using namespace std;

#define POLY 11
#define TICKS_PER_QUARTER 128
#define TICKS4 896
#define MAGIC_FILE 0x4d546864
#define MAGIC_TRACK 0x4d54726b

extern int Pexitprogram, espera, programa, vum, vumvum, tum, cambialo;
extern int vavi, pr, pr1, count, ulcount, canaledit, notplaying;
extern int veloplus[65];
extern const char *FilePreset;
extern const char *FileDrums;
extern int Edr[62][129];
extern int Ectrl[8][38][129];
extern int actunex, ponfin, ttnp, tocadrum, sde, sdec, paraplay;
extern int TempoSong, SNomi, cambiapat, InvMode;
extern int splash, splashcounter, clicksplash, lastcasdr, cambiacasdr;
extern int lastcascr, cambiacascr;
extern char NombreAcorde[16];
extern char KbChordSymbol[16];
extern char NombreSong[80];

extern struct song
{
  int a;
  int b;
  int c;
  int d;
  int e;
  int f;
  int g;
  int h;
  int fin;
  int pattern;
  char go_to[4];
  int times;
  char go_af[4];
  int atimes;
  char ch1[12];
  char ch2[12];
  char ch3[12];
  char ch4[12];
  int ar8;
  int ar16;
} S[129];

// ********************************************************************************************************
/*
class SONGclass
{
struct savsong
{
  int savsonga;
  int savsongb;
  int savsongc;
  int savsongd;
  int savsonge;
  int savsongf;
  int savsongg;
  int savsongh;
  int savsongfin;
  int savsongpattern;
  char savsonggo_to[4];
  int savsongtimes;
  char savsonggo_af[4];
  int savsongatimes;
  char ssch1[12];
  char ssch2[12];
  char ssch3[12];
  char ssch4[12];
  int ssar8;
  int ssar16;
} measureS[129];
};
*/
// ********************************************************************************************************

class GMO
{

public:

  GMO ();
  ~GMO ();
  void midievents (int i);
  void miramidi ();
  void panico (int data, int canales);
//   void MiraChord();
  void ChangeChord ();
  void enviomidi (int i, int fchout);
  void enviocontrol (int i, int j, int fchout);
  void organo ();
  void accompaniment ();
  void loadpatt (char *filename);
  void savepatt (char *filename);
  void sacaev (int nota, int canal, int velocity, int length);
  void suenaev (int nota, int canal, int velocity);
  void miranota (int i);
  void miranotam2 (int i);
  void miranotam3 (int i);
  void set_tempo ();
  void init_queue ();
  void clear_queue ();
  snd_seq_tick_time_t get_tick ();
  void loadfile (char *filename);
  void loadsound (char *filename);
  void savefile (char *filename);
  void savesoundfile (int soundno, char *filename);
  void loadstyl (char *filename);
  void savestyl (char *filename);
  void savevelo (char *filename);
  void loadvelo (char *filename);
  void loadsong (char *filename);
  void savesong (char *filename);
  void printsong (char *filename);
  int BuscaM (int i);
  void GeneraChord ();
  void BuscaRepes ();
  void newsong ();
  void saveMidiFile (char *filename);
  void generatracks ();
  void saveMidiFile2 (char *filename);
  void generatracks2 ();
  int ImportaMidi ();
  void PonerDatoMidi (int Pista, int Nota, int Velo, int Mposic);
  void PonerControlMidi (int Pista, int Control, int Valor);
  void PonerProgramMidi (int Pista, int Programa);
  int mirasaltos (int nb);
  void parsetracks ();
  void ActuPen ();
  long calculadelta (int value);
  void cambiopat ();
  void PonNotesOff ();
  void PonNotesOff2 ();
  void patternclear (int patron);
  void harmonize (int hm, int voice, int channel, int note, int velo, int dur);
  void loadpreset (char *filename);
  void loaddrumset (char *filename);
  void BuscaSkindir ();
  void PonGraba (int tipo, snd_seq_tick_time_t gtick, int gnota, int gcanal,
		 int gvelocity, int glength, int gcontrol, int gvalue,
		 int gprograma);
  void PonPlay (int tipo, snd_seq_tick_time_t gtick, int gnota, int gcanal,
		int gvelocity, int glength);
  void EPlay ();
  void savesongplay (char *filename);
  void loadsongplay (char *filename);
  int calculaval (int valctrl, int min, int max);
  int leer_bytes (FILE * fp, int n);
  unsigned long leer_delta (FILE * fp);
  void PonControles (int Patron);
  void MiraGuia ();
  void loadgmpl (char *filename);
  void savegmpl (char *filename);
  void grabalib ();
  void BorraControles (int Patron);
  void ControlesPon (int Patron);
  void ActualizaPattern ();
  void make_GHelp ();
  void GrabaSettings ();
  int CalculaBanco (int i);
  void PonCeroDrum ();
  void PonCeroControl ();
  void PonDrumTemp (int i);
  void PonTempDrum (int i);
  void ClearEvDrum (int i);
  void MeteMixerMidi (int i);
  void ChangePattern (int i);
  void MeteMixerMidiProg (int i);
  void UsaTempoTrack ();
  void BorraTiempo (int i);
  void InsertaTiempo (int i);
  void MiraCambioTempoM (int tcompas, int neg);
  void BuscaTempo ();
  void copy1 (int cc);
  void copy2 (int cc, int gg);
  void GetCombiM (int i);


  int v1highMidi;
  int v1lowMidi;
  int v1highVelocity;
  int v1lowVelocity;
  int v2highMidi;
  int v2lowMidi;
  int v2highVelocity;
  int v2lowVelocity;
  int v3highMidi;
  int v3lowMidi;
  int v3highVelocity;
  int v3lowVelocity;
  int v4highMidi;
  int v4lowMidi;
  int v4highVelocity;
  int v4lowVelocity;
  int mdimode;
  int MidiMode;
  int nextbarn;

  int solo[12];
  char Delacorde[16];
  int cambiaacorde;
  int MTempo;
  int TMch[16];
  int cttemp;
  int valorctrl;
  int ctrledit;
  int MTlsb;
  int MTmsb;
  int DataLSB;
  int DataMSB;
  int Hay;
  double MasterVolume;
  int MasterON;
  int StyleSelect;
  int PatternSelect;
  int SoundSelect;
  int AccordionSelect;
  int MutesOnOff;
  unsigned int ultimotick;
  int cs;
  int grabaconta2;
  int grabaconta;
  int reproduccion;
  int grabacion;
  int TresCinco;
  int DosCuatro;
  int VeloMixer;
  char Skindir[80];
  char SkinNombre[30];
  int anticipa;
  int KeybON;
//  int hnotes[116];
  int HMode;
  char HelpFilename[80];
  char SoundsFilename[80];
  char PatternsFilename[80];
  char StylesFilename[80];
  char PresetFilename[80];
  char DrumNoteFilename[80];
  char SkinFilename[80];
  char MidiImportFilename[80];
  char LibStylesFilename[80];
  int cMidiRead;
  int MiNominator;
  int MiBars;
  int MiDrumsMCh;
  int MiBassMCh;
  int MiAcc1MCh;
  int MiAcc2MCh;
  int MiAcc3MCh;
  int MiAcc4MCh;
  int MiAcc5MCh;
  int MiBaseKey;
  int MiStart;
  int Mmodebass;
  int Mmodeacc2;
  int Mmodeacc4;
  int LaUltima;
  int deltarake2;
  int deltarake1;
  int deltaleke2;
  int deltaleke1;
  int deltacc5;
  int deltacc4;
  int deltacc3;
  int deltacc2;
  int deltacc1;
  int deltab;
  int deltad;
  int deltacon;
  int delta;
  int Pendientes;
  char drums[32000];
  int cdrums;
  int stdrums;
  char bass[10000];
  int cbass;
  int stbass;
  char acc1[32000];
  int cacc1;
  int stacc1;
  char acc2[10000];
  int cacc2;
  int stacc2;
  char acc3[32000];
  int cacc3;
  int stacc3;
  char acc4[10000];
  int cacc4;
  int stacc4;
  char acc5[32000];
  int cacc5;
  int stacc5;
  char contr[16000];
  int ccontr;
  int stcontr;
  char leke1[16000];
  int cleke1;
  int stleke1;
  char leke2[16000];
  int cleke2;
  int stleke2;
  char rake1[16000];
  int crake1;
  int strake1;
  char rake2[16000];
  int crake2;
  int strake2;


  char elchardm;
  int dredit;
  int lfundi;
  int linversion;
  int inversion;
  int nb;
  int bplay;
  int BPW;
  int veloW;
  int lastv;
  char elbart[8];
  char elnb[16];
  int elbar;
  int ya;
  int nfundi;
  int finito;
  int mezcla;
  int prime;
  int ulti;
  int kk;
  int newp;
  int nextp;
  int nextpm;
  int Intro;
  int Var1;
  int Var2;
  int Fill1;
  int Fill2;
  int Ending;
  int selcopy;
  int unasolo;
  int selmix;
  int notabajo;
  int sposi;
  int semi;
  int negra;
  int ncompas;
  int chout;
  int pedal;
  int chord;
  int fundi;
  int ulfundi;
  int tercera;
  int quinta;
  int septima;
  int ctipo;
  int note_active[POLY];
  int rnote[POLY];
  int gate[POLY];
  char Name[30];

  int progch[12], volume[12], BankLSB[12], BankMSB[12], pan[12], Pon[12];
  int reverb[12], chorus[12], Ptime[12], OnOff[12], detune[12];
  int octa[12];
  int lowvel[12];
  int hivel[12];
  int lonote[12];
  int hinote[12];	

  int pmidi_in;
  int pmidi_out;
  int queue_id;
  int bpm0;
  int tempo;
  int swing;
  int seq_len;
  int transpose;
  int bpm;
  int stst;
  int sp;
  int sd;
  int ss;
  int st;
  int cdn;
  int sbar;
  snd_seq_tick_time_t tick, atick;
  snd_seq_t *seq_handle;
  int lanota;
  int duracion;
  int di1;
  int di2;
  int di3;
  int di4;
  int pafuera;
  int qcontrol;
  int d1, d2, d3, d4, d5, d6, d7, d8;
  int genwindow;
  int NumVari[20];
  char ElEstilo[32];
  int GUIPlay;
  int WGUIP;
  int ABOW;
  int PFEW;
  int DNNWE;


  struct EventosGrabacion
  {
    int tipo;
    snd_seq_tick_time_t tick;
    int nota;
    int canal;
    int velocity;
    int length;
  } EG[64000], MEG[128000], MEG1[128000];





  struct skinfile
  {
    char Name[32];
    char FileName[80];
  }
  skin[15];



  struct HarmonizeMode
  {
    char Name[16];
    int notes;
    int dist;
    int nnu;
  } HM[10];




  struct Pendingoff
  {
    int canal;
    int nota;
    int delta;
    int estado;

  } PO[80], POAC[80];




  struct lguarro
  {
    char lbE[6];
  } llg[129];

  struct progMixer
  {

    char Nom[30];
    int progch[5];
    int volume[5];
    int BankLSB[5];
    int BankMSB[5];
    int pan[5];
    int Pon[5];
    int reverb[5];
    int chorus[5];
    int Ptime[5];
    int OnOff[5];
    int octa[5];
    int detune[5];
    int lowvel[5];
    int hivel[5];
    int lonote[5];
    int hinote[5];	
    int style;
    int pattern;
    int bpm;
    int transpose;

  } Prog[101];


  struct style
  {
    char Nom[30];
    int Intro;
    int Var1;
    int Var2;
    int Fill1;
    int Fill2;
    int Ending;
    int bpm;
    int startP;
    int programa;

  } Styl[101];

  struct Repetidor
  {
    int times;
  } Repe[129];

  struct Saltador
  {
    int times;
    int pasa;
  } Salta[129];


  struct NotaDrum
  {
    char Nom[24];
    int Note;
  };


  struct ProgDrum
  {
    int ProgD;
    NotaDrum DNN[62];
  } PD[60];


  struct EventoMidCon
  {
    int posicion;
    int pista;
    int controlador;
    int valor;
  };

  struct EventoDr
  {
    int posicion;
    int nota;
    int valor;
  };


  struct Ritmo
  {
    char Nom[30];
    char Nfile[2];
    int bars;
    int blackn;
    int octavate;
    int octavate4;
    int bassstlt;
    int acc1stlt;
    int acc2stlt;
    int acc3stlt;
    int acc4stlt;
    int acc5stlt;
    int acc2mode;
    int acc3mode;
    int acc4mode;
    int acc5mode;
    int terceras;
    int sextas;
    int terceras4;
    int sextas4;
    int swing;
    int dron;
    int drpc;
    int drvol;
    int drpan;
    int drrev;
    int drcho;
    int drocta;
    int drBankM;
    int drpon;
    int drptime;
    int drdetune;
    int basson;
    int basspc;
    int bassvol;
    int basspan;
    int bassrev;
    int basscho;
    int bassocta;
    int bassBankM;
    int basspon;
    int bassptime;
    int bassdetune;
    int acc1on;
    int acc1pc;
    int acc1vol;
    int acc1pan;
    int acc1rev;
    int acc1cho;
    int acc1octa;
    int acc1BankM;
    int acc1pon;
    int acc1ptime;
    int acc1detune;
    int acc2on;
    int acc2pc;
    int acc2vol;
    int acc2pan;
    int acc2rev;
    int acc2cho;
    int acc2octa;
    int acc2BankM;
    int acc2pon;
    int acc2ptime;
    int acc2detune;
    int acc3on;
    int acc3pc;
    int acc3vol;
    int acc3pan;
    int acc3rev;
    int acc3cho;
    int acc3octa;
    int acc3BankM;
    int acc3pon;
    int acc3ptime;
    int acc3detune;
    int acc4on;
    int acc4pc;
    int acc4vol;
    int acc4pan;
    int acc4rev;
    int acc4cho;
    int acc4octa;
    int acc4BankM;
    int acc4pon;
    int acc4ptime;
    int acc4detune;
    int acc5on;
    int acc5pc;
    int acc5vol;
    int acc5pan;
    int acc5rev;
    int acc5cho;
    int acc5octa;
    int acc5BankM;
    int acc5pon;
    int acc5ptime;
    int acc5detune;
    EventoDr EvDr[1000];
    int basn[3][129];
    int acc1n[2][129];
    int acc2n[3][129];
    int acc3n[3][129];
    int acc4n[3][129];
    int acc5n[3][129];
    EventoMidCon EvMidCon[1000];

  } Rt[500];

  struct track
  {
  char Instrument[24];
  int trackchannel;
  int trackvolume;
  int trackpan;
  int trackchorus;
  // track mode can be raw midi or relative. 0 or 1
  int trackmode;
  // track content: duration, pitch, velocity, 
  int trackcontent[3][1024];
  } TrackNo[16];
  
  struct TipoCh
  {
    int ter;
    int qui;
    int sep;
  } TCh[11];

  struct NomChord
  {
    char Nom[3];
  } NC[13];


  struct NomChordExtended
  {
    char Nom[3];
    int note;
  } NCE[20];
/*
  struct Ch3
  {
    int tipo;
    int fund;
    int di1;
    int di2;
    char Nom[10];
    int inv2;
    int inv3;
  } Chord3[12];

  struct Ch4
  {
    int tipo;
    int fund;
    int di1;
    int di2;
    int di3;
    char Nom[10];
    int inv2;
    int inv3;
  } Chord4[48];

  struct Ch5
  {
    int tipo;
    int fund;
    int di1;
    int di2;
    int di3;
    int di4;
    int inv2;
    int inv3;
    char Nom[10];
  } Chord5[11];
*/

  char temporal[8];
  char tempoch[8];

  struct PuertoMidiIn
  {
    int YOIN, SettingsIN;
    char *SMidiIn;
    char pMIDIIN[256];
    char SetMidiIn[40];
    int Ports;
    snd_seq_t *midi_in;
    unsigned char IN[16];
  }
  MidiInPuerto[2];

  struct PuertoMidiOut
  {
    int YOOUT, SettingsOUT;
    char *SMidiOut;
    char SetMidiOut[40];
    int Ports;
    snd_seq_t *midi_out;
    unsigned char OUT[16];
    char pMIDIOUT[256];

  }
  MidiOutPuerto[2];



  struct PMidiOut
  {
    int Client, Port;
    char Nombre[40], Info[40];
    const char *CName, *CInfo;

  } CPOMidiS[50];


  struct PMidiIn
  {
    int Client, Port;
    char Nombre[40], Info[40];
    const char *CName, *CInfo;

  } CPIMidiS[50];

  struct PBList
  {
    int Prog;
    char ProgName[24];
  };

  struct PPList
  {
    int Banco;
    PBList PBanco[129];
  }
  PresetList[129];


  struct Harmonoff
  {
    int estado;
    int nnotas;
    int notas[10];
    int velo;
  } HarOFF[16][120];


  struct GenPat
  {
    char style[24];
    int type;
    int stat;
    int datavar[10][129];

  } Register;

  struct InstNames
  {
    char Name[24];

  } INames[20];


  struct GuidedPlay
  {
    int bar;
    int pattern;

  } GP[200];

  struct MasterTempoData
  {
    int bar;
    int black;
    int tempo;

  } TemT[200];

//rlv *************************
  int globalchannel;
  int MuseScoreExport;
};

#endif
