// Code generated by github.com/fjl/gencodec. DO NOT EDIT.

package core

import (
	"encoding/json"
	"errors"
	"math/big"

	"energi.world/core/gen3/common"
	"energi.world/core/gen3/common/hexutil"
	"energi.world/core/gen3/common/math"
)

var _ = (*genesisXferMarshaling)(nil)

// MarshalJSON marshals as JSON.
func (g GenesisXfer) MarshalJSON() ([]byte, error) {
	type GenesisXfer struct {
		Addr  common.UnprefixedAddress `json:"addr" gencodec:"required"`
		Code  hexutil.Bytes            `json:"code" gencodec:"required"`
		Value *math.HexOrDecimal256    `json:"value,omitempty"`
	}
	var enc GenesisXfer
	enc.Addr = common.UnprefixedAddress(g.Addr)
	enc.Code = g.Code
	enc.Value = (*math.HexOrDecimal256)(g.Value)
	return json.Marshal(&enc)
}

// UnmarshalJSON unmarshals from JSON.
func (g *GenesisXfer) UnmarshalJSON(input []byte) error {
	type GenesisXfer struct {
		Addr  *common.UnprefixedAddress `json:"addr" gencodec:"required"`
		Code  *hexutil.Bytes            `json:"code" gencodec:"required"`
		Value *math.HexOrDecimal256     `json:"value,omitempty"`
	}
	var dec GenesisXfer
	if err := json.Unmarshal(input, &dec); err != nil {
		return err
	}
	if dec.Addr == nil {
		return errors.New("missing required field 'addr' for GenesisXfer")
	}
	g.Addr = common.Address(*dec.Addr)
	if dec.Code == nil {
		return errors.New("missing required field 'code' for GenesisXfer")
	}
	g.Code = *dec.Code
	if dec.Value != nil {
		g.Value = (*big.Int)(dec.Value)
	}
	return nil
}
