/*
 * Decompiled with CFR 0.152.
 */
package com.apple.concurrent;

import com.apple.concurrent.LibDispatchConcurrentQueue;
import com.apple.concurrent.LibDispatchMainQueue;
import com.apple.concurrent.LibDispatchNative;
import com.apple.concurrent.LibDispatchSerialQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;

public final class Dispatch {
    static final Dispatch instance = new Dispatch();
    int queueIndex = 0;
    Executor nonBlockingMainQueue = null;
    Executor blockingMainQueue = null;

    public static Dispatch getInstance() {
        Dispatch.checkSecurity();
        if (!LibDispatchNative.nativeIsDispatchSupported()) {
            return null;
        }
        return instance;
    }

    private static void checkSecurity() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new RuntimePermission("canInvokeInSystemThreadGroup"));
        }
    }

    private Dispatch() {
    }

    public Executor getAsyncExecutor(Priority priority) {
        long l;
        if (priority == null) {
            priority = Priority.NORMAL;
        }
        if ((l = LibDispatchNative.nativeCreateConcurrentQueue(priority.nativePriority)) == 0L) {
            return null;
        }
        return new LibDispatchConcurrentQueue(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecutorService createSerialExecutor(String string) {
        long l;
        if (string == null) {
            string = "";
        }
        if (string.length() > 256) {
            string = string.substring(0, 256);
        }
        String string2 = "com.apple.java.concurrent.";
        if ("".equals(string)) {
            Dispatch dispatch = this;
            synchronized (dispatch) {
                string2 = string2 + this.queueIndex++;
            }
        } else {
            string2 = string2 + string;
        }
        if ((l = LibDispatchNative.nativeCreateSerialQueue(string2)) == 0L) {
            return null;
        }
        return new LibDispatchSerialQueue(l);
    }

    public synchronized Executor getNonBlockingMainQueueExecutor() {
        if (this.nonBlockingMainQueue != null) {
            return this.nonBlockingMainQueue;
        }
        this.nonBlockingMainQueue = new LibDispatchMainQueue.ASync();
        return this.nonBlockingMainQueue;
    }

    public synchronized Executor getBlockingMainQueueExecutor() {
        if (this.blockingMainQueue != null) {
            return this.blockingMainQueue;
        }
        this.blockingMainQueue = new LibDispatchMainQueue.Sync();
        return this.blockingMainQueue;
    }

    public static enum Priority {
        LOW(-2),
        NORMAL(0),
        HIGH(2);

        final int nativePriority;

        private Priority(int n2) {
            this.nativePriority = n2;
        }
    }
}

