import type { TransformOptions } from 'esbuild';
import type { PreprocessorGroup } from 'svelte/types/compiler/preprocess';
export declare type Definitions = {
    [find: string]: string;
};
declare type Allow = Pick<TransformOptions, 'banner' | 'charset' | 'define' | 'footer' | 'keepNames' | 'pure' | 'target' | 'treeShaking' | 'tsconfigRaw'>;
export interface Options extends Allow {
    /** @default 'tsconfig.json' */
    tsconfig?: string;
    /** @default 'error' */
    loglevel?: TransformOptions['logLevel'];
    /** @default true */
    sourcemap?: boolean | 'inline';
    /** @default {} */
    define?: Definitions;
    /** @default 'utf8' */
    charset?: TransformOptions['charset'];
}
/** @note Use `options.define` for replacements */
export declare function typescript(options?: Partial<Options>): PreprocessorGroup;
/** @important Only works with JavaScript! */
export declare function replace(define?: Definitions): PreprocessorGroup;
export {};
