/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
import { XhrFactory as XhrFactory_fromAngularCommon } from '@angular/common';
/**
 * A wrapper around the `XMLHttpRequest` constructor.
 *
 * @publicApi
 * @see `XhrFactory`
 * @deprecated
 * `XhrFactory` has moved, please import `XhrFactory` from `@angular/common` instead.
 */
export const XhrFactory = XhrFactory_fromAngularCommon;
export { HttpBackend, HttpHandler } from './src/backend';
export { HttpClient } from './src/client';
export { HttpContext, HttpContextToken } from './src/context';
export { HttpHeaders } from './src/headers';
export { HTTP_INTERCEPTORS } from './src/interceptor';
export { JsonpClientBackend, JsonpInterceptor } from './src/jsonp';
export { HttpClientJsonpModule, HttpClientModule, HttpClientXsrfModule, HttpInterceptingHandler as ɵHttpInterceptingHandler } from './src/module';
export { HttpParams, HttpUrlEncodingCodec } from './src/params';
export { HttpRequest } from './src/request';
export { HttpErrorResponse, HttpEventType, HttpHeaderResponse, HttpResponse, HttpResponseBase } from './src/response';
export { HttpXhrBackend } from './src/xhr';
export { HttpXsrfTokenExtractor } from './src/xsrf';
//# sourceMappingURL=data:application/json;base64,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