/*
 * STAN -- Stream Analyser -- http://www.roqe.org/stan
 * Copyright (c) 2001-2004 Konrad Rieck <kr@roqe.org> 
 * All rights reserved.
 * ---
 * $Id: treap.h,v 1.8 2003/12/10 20:29:29 kr Exp $
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *    ``This product includes software developed by Konrad Rieck.''
 * 4. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */
#ifndef _TREAP_H 
#define _TREAP_H

typedef struct tnode tnode_t;

struct tnode {
   byte_t *pattern;
   size_t count;
   tnode_t *left, *right, *parent;
};

void init_treap(size_t patlen);
void free_treap(size_t patlen);
tnode_t **tlocate(tnode_t ** tnode, byte_t * pattern, size_t len);
tnode_t **tmin(tnode_t ** tnode);
tnode_t **tmax(tnode_t ** tnode);
size_t tdepth(tnode_t ** tnode);
size_t thigh(tnode_t ** tnode);
tnode_t **tsuccessor(tnode_t ** tnode);
tnode_t **tpredecessor(tnode_t ** tnode);
size_t tsize_tnodes(tnode_t ** tnode);
size_t tsize_total(tnode_t ** tnode);
void tprint(tnode_t * tnode);
void tfree(tnode_t * tnode);
tnode_t **tdelete(tnode_t ** tnode, size_t patlen);
void tinsert(tnode_t ** tnode, byte_t * pattern, size_t patlen);
void ttraverse(tnode_t ** tnode, void (*func) (tnode_t *), int order);
void check_heap(tnode_t * tnode);
void check_tree(tnode_t * tnode, size_t patlen);
void rotate_left(tnode_t ** tnode, size_t patlen);
void rotate_right(tnode_t ** tnode, size_t patlen);

#endif /* _TREAP_H */
