(IN-PACKAGE "RTL")

(INCLUDE-BOOK "rtl/rel11/lib/rac" :DIR :SYSTEM)

(SET-IGNORE-OK T)

(SET-IRRELEVANT-FORMALS-OK T)

(DEFUND
 ANALYZE (OP FMT FZ FLAGS)
 (LET
    ((SIGN 0)
     (EXP 0)
     (MAN 0)
     (MANMSB 0)
     (EXPISMAX 0))
    (MV-LET
         (SIGN EXP EXPISMAX MAN MANMSB)
         (CASE FMT
               (3 (LET ((SIGN (BITN OP 63))
                        (EXP (BITS OP 62 52)))
                       (MV SIGN EXP (LOG= EXP 2047)
                           (BITS OP 51 0)
                           (BITS 2251799813685248 51 0))))
               (2 (LET ((SIGN (BITN OP 31))
                        (EXP (BITS OP 30 23)))
                       (MV SIGN EXP (LOG= EXP 255)
                           (BITS OP 22 0)
                           (BITS 4194304 51 0))))
               (1 (LET ((SIGN (BITN OP 15))
                        (EXP (BITS OP 14 10)))
                       (MV SIGN EXP (LOG= EXP 31)
                           (BITS OP 9 0)
                           (BITS 512 51 0))))
               (T (MV SIGN EXP EXPISMAX MAN MANMSB)))
         (LET ((C 0))
              (MV-LET (FLAGS C)
                      (IF1 EXPISMAX
                           (MV FLAGS
                               (IF1 (LOG= MAN 0)
                                    1 (IF1 (LOGAND MAN MANMSB) 3 2)))
                           (IF1 (LOG= EXP 0)
                                (IF1 (LOG= MAN 0)
                                     (MV FLAGS 0)
                                     (MV-LET (C FLAGS)
                                             (IF1 FZ
                                                  (MV 0
                                                      (IF1 (LOG<> FMT 1)
                                                           (SETBITN FLAGS 8 7 1)
                                                           FLAGS))
                                                  (MV 5 FLAGS))
                                             (MV FLAGS C)))
                                (MV FLAGS 4)))
                      (MV SIGN EXP MAN C FLAGS))))))

(DEFUND
 SPECIALCASE
 (OPA OPB CLASSA CLASSB DN FUSED FLAGS)
 (LET*
  ((D (BITS 0 116 0))
   (ZERO (BITS 0 63 0))
   (ZERO (SETBITN ZERO 64 63
                  (LOGXOR (BITN OPA 63) (BITN OPB 63))))
   (INFINITY (BITS (LOGIOR 9218868437227405312 ZERO)
                   63 0))
   (MANMSB (BITS 2251799813685248 63 0))
   (DEFNAN (BITS 9221120237041090560 63 0))
   (PRODINFZERO (FALSE$)))
  (MV-LET
   (PRODINFZERO D FLAGS)
   (IF1
     (LOG= CLASSA 2)
     (MV PRODINFZERO
         (BITS (IF1 DN DEFNAN
                    (IF1 FUSED OPA (LOGIOR OPA MANMSB)))
               116 0)
         (SETBITN FLAGS 8 0 1))
     (IF1 (LOG= CLASSB 2)
          (MV PRODINFZERO
              (BITS (IF1 DN DEFNAN
                         (IF1 FUSED OPB (LOGIOR OPB MANMSB)))
                    116 0)
              (SETBITN FLAGS 8 0 1))
          (MV-LET (PRODINFZERO FLAGS D)
                  (IF1 (LOG= CLASSA 3)
                       (MV PRODINFZERO
                           FLAGS (BITS (IF1 DN DEFNAN OPA) 116 0))
                       (IF1 (LOG= CLASSB 3)
                            (MV PRODINFZERO
                                FLAGS (BITS (IF1 DN DEFNAN OPB) 116 0))
                            (MV-LET (D PRODINFZERO FLAGS)
                                    (IF1 (LOGIOR1 (LOGAND1 (LOG= CLASSA 1)
                                                           (LOG= CLASSB 0))
                                                  (LOGAND1 (LOG= CLASSB 1)
                                                           (LOG= CLASSA 0)))
                                         (MV DEFNAN (TRUE$)
                                             (SETBITN FLAGS 8 0 1))
                                         (MV (IF1 (LOGIOR1 (LOG= CLASSA 1)
                                                           (LOG= CLASSB 1))
                                                  INFINITY
                                                  (IF1 (LOGIOR1 (LOG= CLASSA 0)
                                                                (LOG= CLASSB 0))
                                                       ZERO D))
                                             PRODINFZERO FLAGS))
                                    (MV PRODINFZERO FLAGS D))))
                  (MV PRODINFZERO D FLAGS))))
   (MV (IF1 FUSED (BITS (ASH D 53) 116 0) D)
       FLAGS PRODINFZERO (TRUE$)
       (FALSE$)))))

(DEFUND CLZ53-LOOP-0 (I N K C Z)
        (DECLARE (XARGS :MEASURE (NFIX (- N I))))
        (IF (AND (INTEGERP I) (INTEGERP N) (< I N))
            (LET* ((C (AS I
                          (BITS (IF1 (AG (+ (* 2 I) 1) Z)
                                     (AG (* 2 I) C)
                                     (AG (+ (* 2 I) 1) C))
                                5 0)
                          C))
                   (C (AS I
                          (SETBITN (AG I C)
                                   6 K (AG (+ (* 2 I) 1) Z))
                          C))
                   (Z (AS I
                          (LOGAND1 (AG (+ (* 2 I) 1) Z)
                                   (AG (* 2 I) Z))
                          Z)))
                  (CLZ53-LOOP-0 (+ I 1) N K C Z))
            (MV C Z)))

(DEFUND CLZ53-LOOP-1 (K N C Z)
        (DECLARE (XARGS :MEASURE (NFIX (- 6 K))))
        (IF (AND (INTEGERP K) (< K 6))
            (LET ((N (FLOOR N 2)))
                 (MV-LET (C Z)
                         (CLZ53-LOOP-0 0 N K C Z)
                         (CLZ53-LOOP-1 (+ K 1) N C Z)))
            (MV N C Z)))

(DEFUND CLZ53-LOOP-2 (I X Z C)
        (DECLARE (XARGS :MEASURE (NFIX (- 64 I))))
        (IF (AND (INTEGERP I) (< I 64))
            (LET ((Z (AS I (LOGNOT1 (BITN X I)) Z))
                  (C (AS I (BITS 0 5 0) C)))
                 (CLZ53-LOOP-2 (+ I 1) X Z C))
            (MV Z C)))

(DEFUND CLZ53 (M)
        (LET* ((X (BITS 0 63 0))
               (X (SETBITS X 64 63 11 M))
               (Z NIL)
               (C NIL))
              (MV-LET (Z C)
                      (CLZ53-LOOP-2 0 X Z C)
                      (LET ((N 64))
                           (MV-LET (N C Z)
                                   (CLZ53-LOOP-1 0 N C Z)
                                   (AG 0 C))))))

(DEFUND COMPRESS (PP IA IB)
        (LET* ((T0FA0INA 0)
               (T0FA0INB 0)
               (T0FA0INC 0)
               (T2PP0S 0)
               (T1PP0C 0)
               (T0FA0INA (AG 0 PP))
               (T0FA0INB (AG 1 PP))
               (T0FA0INC (BITS (ASH (AG 2 PP) 2) 58 0))
               (T2PP0S (LOGXOR (LOGXOR T0FA0INA T0FA0INB)
                               T0FA0INC))
               (T1PP0C (LOGIOR (LOGIOR (LOGAND T0FA0INA T0FA0INB)
                                       (LOGAND T0FA0INA T0FA0INC))
                               (LOGAND T0FA0INB T0FA0INC)))
               (T0FA1INA 0)
               (T0FA1INB 0)
               (T0FA1INC 0)
               (T2PP1S 0)
               (T1PP1C 0)
               (T0FA1INA (AG 3 PP))
               (T0FA1INB (BITS (ASH (AG 4 PP) 2) 60 0))
               (T0FA1INC (BITS (ASH (AG 5 PP) 4) 60 0))
               (T2PP1S (LOGXOR (LOGXOR T0FA1INA T0FA1INB)
                               T0FA1INC))
               (T1PP1C (LOGIOR (LOGIOR (LOGAND T0FA1INA T0FA1INB)
                                       (LOGAND T0FA1INA T0FA1INC))
                               (LOGAND T0FA1INB T0FA1INC)))
               (T0FA2INA 0)
               (T0FA2INB 0)
               (T0FA2INC 0)
               (T2PP2S 0)
               (T1PP2C 0)
               (T0FA2INA (AG 6 PP))
               (T0FA2INB (BITS (ASH (AG 7 PP) 2) 60 0))
               (T0FA2INC (BITS (ASH (AG 8 PP) 4) 60 0))
               (T2PP2S (LOGXOR (LOGXOR T0FA2INA T0FA2INB)
                               T0FA2INC))
               (T1PP2C (LOGIOR (LOGIOR (LOGAND T0FA2INA T0FA2INB)
                                       (LOGAND T0FA2INA T0FA2INC))
                               (LOGAND T0FA2INB T0FA2INC)))
               (T0FA3INA 0)
               (T0FA3INB 0)
               (T0FA3INC 0)
               (T2PP3S 0)
               (T1PP3C 0)
               (T0FA3INA (AG 9 PP))
               (T0FA3INB (BITS (ASH (AG 10 PP) 2) 60 0))
               (T0FA3INC (BITS (ASH (AG 11 PP) 4) 60 0))
               (T2PP3S (LOGXOR (LOGXOR T0FA3INA T0FA3INB)
                               T0FA3INC))
               (T1PP3C (LOGIOR (LOGIOR (LOGAND T0FA3INA T0FA3INB)
                                       (LOGAND T0FA3INA T0FA3INC))
                               (LOGAND T0FA3INB T0FA3INC)))
               (T0FA4INA 0)
               (T0FA4INB 0)
               (T0FA4INC 0)
               (T2PP4S 0)
               (T1PP4C 0)
               (T0FA4INA (AG 12 PP))
               (T0FA4INB (BITS (ASH (AG 13 PP) 2) 60 0))
               (T0FA4INC (BITS (ASH (AG 14 PP) 4) 60 0))
               (T2PP4S (LOGXOR (LOGXOR T0FA4INA T0FA4INB)
                               T0FA4INC))
               (T1PP4C (LOGIOR (LOGIOR (LOGAND T0FA4INA T0FA4INB)
                                       (LOGAND T0FA4INA T0FA4INC))
                               (LOGAND T0FA4INB T0FA4INC)))
               (T0FA5INA 0)
               (T0FA5INB 0)
               (T0FA5INC 0)
               (T2PP5S 0)
               (T1PP5C 0)
               (T0FA5INA (AG 15 PP))
               (T0FA5INB (BITS (ASH (AG 16 PP) 2) 60 0))
               (T0FA5INC (BITS (ASH (AG 17 PP) 4) 60 0))
               (T2PP5S (LOGXOR (LOGXOR T0FA5INA T0FA5INB)
                               T0FA5INC))
               (T1PP5C (LOGIOR (LOGIOR (LOGAND T0FA5INA T0FA5INB)
                                       (LOGAND T0FA5INA T0FA5INC))
                               (LOGAND T0FA5INB T0FA5INC)))
               (T0FA6INA 0)
               (T0FA6INB 0)
               (T0FA6INC 0)
               (T2PP6S 0)
               (T1PP6C 0)
               (T0FA6INA (AG 18 PP))
               (T0FA6INB (BITS (ASH (AG 19 PP) 2) 60 0))
               (T0FA6INC (BITS (ASH (AG 20 PP) 4) 60 0))
               (T2PP6S (LOGXOR (LOGXOR T0FA6INA T0FA6INB)
                               T0FA6INC))
               (T1PP6C (LOGIOR (LOGIOR (LOGAND T0FA6INA T0FA6INB)
                                       (LOGAND T0FA6INA T0FA6INC))
                               (LOGAND T0FA6INB T0FA6INC)))
               (T0FA7INA 0)
               (T0FA7INB 0)
               (T0FA7INC 0)
               (T2PP7S 0)
               (T1PP7C 0)
               (T0FA7INA (AG 21 PP))
               (T0FA7INB (BITS (ASH (AG 22 PP) 2) 60 0))
               (T0FA7INC (BITS (ASH (AG 23 PP) 4) 60 0))
               (T2PP7S (LOGXOR (LOGXOR T0FA7INA T0FA7INB)
                               T0FA7INC))
               (T1PP7C (LOGIOR (LOGIOR (LOGAND T0FA7INA T0FA7INB)
                                       (LOGAND T0FA7INA T0FA7INC))
                               (LOGAND T0FA7INB T0FA7INC)))
               (T0FA8INA 0)
               (T0FA8INB 0)
               (T0FA8INC 0)
               (T2PP8S 0)
               (T1PP8C 0)
               (T0FA8INA (AG 24 PP))
               (T0FA8INB (BITS (ASH (AG 25 PP) 2) 60 0))
               (T0FA8INC (BITS (ASH (AG 26 PP) 4) 60 0))
               (T2PP8S (LOGXOR (LOGXOR T0FA8INA T0FA8INB)
                               T0FA8INC))
               (T1PP8C (LOGIOR (LOGIOR (LOGAND T0FA8INA T0FA8INB)
                                       (LOGAND T0FA8INA T0FA8INC))
                               (LOGAND T0FA8INB T0FA8INC)))
               (T1FA0INA 0)
               (T1FA0INB 0)
               (T1FA0INC 0)
               (T3PP0S 0)
               (T2PP0C 0)
               (T1FA0INA T1PP0C)
               (T1FA0INB (BITS (ASH T1PP1C 4) 70 0))
               (T1FA0INC (BITS (ASH T1PP2C 10) 70 0))
               (T3PP0S (LOGXOR (LOGXOR T1FA0INA T1FA0INB)
                               T1FA0INC))
               (T2PP0C (LOGIOR (LOGIOR (LOGAND T1FA0INA T1FA0INB)
                                       (LOGAND T1FA0INA T1FA0INC))
                               (LOGAND T1FA0INB T1FA0INC)))
               (T1FA1INA 0)
               (T1FA1INB 0)
               (T1FA1INC 0)
               (T3PP1S 0)
               (T2PP1C 0)
               (T1FA1INA T1PP3C)
               (T1FA1INB (BITS (ASH T1PP4C 6) 72 0))
               (T1FA1INC (BITS (ASH T1PP5C 12) 72 0))
               (T3PP1S (LOGXOR (LOGXOR T1FA1INA T1FA1INB)
                               T1FA1INC))
               (T2PP1C (LOGIOR (LOGIOR (LOGAND T1FA1INA T1FA1INB)
                                       (LOGAND T1FA1INA T1FA1INC))
                               (LOGAND T1FA1INB T1FA1INC)))
               (T1FA2INA 0)
               (T1FA2INB 0)
               (T1FA2INC 0)
               (T3PP2S 0)
               (T2PP2C 0)
               (T1FA2INA T1PP6C)
               (T1FA2INB (BITS (ASH T1PP7C 6) 72 0))
               (T1FA2INC (BITS (ASH T1PP8C 12) 72 0))
               (T3PP2S (LOGXOR (LOGXOR T1FA2INA T1FA2INB)
                               T1FA2INC))
               (T2PP2C (LOGIOR (LOGIOR (LOGAND T1FA2INA T1FA2INB)
                                       (LOGAND T1FA2INA T1FA2INC))
                               (LOGAND T1FA2INB T1FA2INC)))
               (T2FA0INA 0)
               (T2FA0INB 0)
               (T2FA0INC 0)
               (T4PP0S 0)
               (T3PP0C 0)
               (T2FA0INA T2PP0S)
               (T2FA0INB (BITS (ASH T2PP1S 4) 70 0))
               (T2FA0INC (BITS (ASH T2PP2S 10) 70 0))
               (T4PP0S (LOGXOR (LOGXOR T2FA0INA T2FA0INB)
                               T2FA0INC))
               (T3PP0C (LOGIOR (LOGIOR (LOGAND T2FA0INA T2FA0INB)
                                       (LOGAND T2FA0INA T2FA0INC))
                               (LOGAND T2FA0INB T2FA0INC)))
               (T2FA1INA 0)
               (T2FA1INB 0)
               (T2FA1INC 0)
               (T4PP1S 0)
               (T3PP1C 0)
               (T2FA1INA T2PP3S)
               (T2FA1INB (BITS (ASH T2PP4S 6) 72 0))
               (T2FA1INC (BITS (ASH T2PP5S 12) 72 0))
               (T4PP1S (LOGXOR (LOGXOR T2FA1INA T2FA1INB)
                               T2FA1INC))
               (T3PP1C (LOGIOR (LOGIOR (LOGAND T2FA1INA T2FA1INB)
                                       (LOGAND T2FA1INA T2FA1INC))
                               (LOGAND T2FA1INB T2FA1INC)))
               (T2FA2INA 0)
               (T2FA2INB 0)
               (T2FA2INC 0)
               (T4PP2S 0)
               (T3PP2C 0)
               (T2FA2INA T2PP6S)
               (T2FA2INB (BITS (ASH T2PP7S 6) 72 0))
               (T2FA2INC (BITS (ASH T2PP8S 12) 72 0))
               (T4PP2S (LOGXOR (LOGXOR T2FA2INA T2FA2INB)
                               T2FA2INC))
               (T3PP2C (LOGIOR (LOGIOR (LOGAND T2FA2INA T2FA2INB)
                                       (LOGAND T2FA2INA T2FA2INC))
                               (LOGAND T2FA2INB T2FA2INC)))
               (T2FA3INA 0)
               (T2FA3INB 0)
               (T2FA3INC 0)
               (T4PP3S 0)
               (T3PP3C 0)
               (T2FA3INA T2PP0C)
               (T2FA3INB (BITS (ASH T2PP1C 16) 106 0))
               (T2FA3INC (BITS (ASH T2PP2C 34) 106 0))
               (T4PP3S (LOGXOR (LOGXOR T2FA3INA T2FA3INB)
                               T2FA3INC))
               (T3PP3C (LOGIOR (LOGIOR (LOGAND T2FA3INA T2FA3INB)
                                       (LOGAND T2FA3INA T2FA3INC))
                               (LOGAND T2FA3INB T2FA3INC)))
               (T3FA0INA 0)
               (T3FA0INB 0)
               (T3FA0INC 0)
               (T5PP0S 0)
               (T4PP0C 0)
               (T3FA0INA T3PP0S)
               (T3FA0INB (BITS (ASH T3PP1S 16) 106 0))
               (T3FA0INC (BITS (ASH T3PP2S 34) 106 0))
               (T5PP0S (LOGXOR (LOGXOR T3FA0INA T3FA0INB)
                               T3FA0INC))
               (T4PP0C (LOGIOR (LOGIOR (LOGAND T3FA0INA T3FA0INB)
                                       (LOGAND T3FA0INA T3FA0INC))
                               (LOGAND T3FA0INB T3FA0INC)))
               (T3FA1INA 0)
               (T3FA1INB 0)
               (T3FA1INC 0)
               (T5PP1S 0)
               (T4PP1C 0)
               (T3FA1INA T3PP0C)
               (T3FA1INB (BITS (ASH T3PP1C 16) 106 0))
               (T3FA1INC (BITS (ASH T3PP2C 34) 106 0))
               (T5PP1S (LOGXOR (LOGXOR T3FA1INA T3FA1INB)
                               T3FA1INC))
               (T4PP1C (LOGIOR (LOGIOR (LOGAND T3FA1INA T3FA1INB)
                                       (LOGAND T3FA1INA T3FA1INC))
                               (LOGAND T3FA1INB T3FA1INC)))
               (T3FA2INA 0)
               (T3FA2INB 0)
               (T3FA2INC 0)
               (T4PP4S 0)
               (T4PP2C 0)
               (T3FA2INA (BITS (ASH IA 49) 106 0))
               (T3FA2INB (BITS (ASH IB 49) 106 0))
               (T3FA2INC T3PP3C)
               (T4PP4S (LOGXOR (LOGXOR T3FA2INA T3FA2INB)
                               T3FA2INC))
               (T4PP2C (LOGIOR (LOGIOR (LOGAND T3FA2INA T3FA2INB)
                                       (LOGAND T3FA2INA T3FA2INC))
                               (LOGAND T3FA2INB T3FA2INC)))
               (T4FA0INA 0)
               (T4FA0INB 0)
               (T4FA0INC 0)
               (T6PP0S 0)
               (T5PP0C 0)
               (T4FA0INA (BITS (ASH T4PP2C 2) 108 0))
               (T4FA0INB T4PP1C)
               (T4FA0INC T4PP0C)
               (T6PP0S (LOGXOR (LOGXOR T4FA0INA T4FA0INB)
                               T4FA0INC))
               (T5PP0C (LOGIOR (LOGIOR (LOGAND T4FA0INA T4FA0INB)
                                       (LOGAND T4FA0INA T4FA0INC))
                               (LOGAND T4FA0INB T4FA0INC)))
               (T4FA1INA 0)
               (T4FA1INB 0)
               (T4FA1INC 0)
               (T6PP1S 0)
               (T5PP1C 0)
               (T4FA1INA (BITS (ASH T4PP4S 3) 109 0))
               (T4FA1INB T4PP0S)
               (T4FA1INC (BITS (ASH T4PP1S 16) 109 0))
               (T6PP1S (LOGXOR (LOGXOR T4FA1INA T4FA1INB)
                               T4FA1INC))
               (T5PP1C (LOGIOR (LOGIOR (LOGAND T4FA1INA T4FA1INB)
                                       (LOGAND T4FA1INA T4FA1INC))
                               (LOGAND T4FA1INB T4FA1INC)))
               (T5FA0INA 0)
               (T5FA0INB 0)
               (T5FA0INC 0)
               (T7PP0S 0)
               (T6PP0C 0)
               (T5FA0INA T5PP0S)
               (T5FA0INB T5PP1S)
               (T5FA0INC (BITS (ASH T5PP0C 2) 110 0))
               (T7PP0S (LOGXOR (LOGXOR T5FA0INA T5FA0INB)
                               T5FA0INC))
               (T6PP0C (LOGIOR (LOGIOR (LOGAND T5FA0INA T5FA0INB)
                                       (LOGAND T5FA0INA T5FA0INC))
                               (LOGAND T5FA0INB T5FA0INC)))
               (T5FA1INA 0)
               (T5FA1INB 0)
               (T5FA1INC 0)
               (T6PP2S 0)
               (T6PP1C 0)
               (T5FA1INA (BITS (ASH T4PP2S 33) 109 0))
               (T5FA1INB (BITS (ASH T4PP3S 1) 109 0))
               (T5FA1INC T5PP1C)
               (T6PP2S (LOGXOR (LOGXOR T5FA1INA T5FA1INB)
                               T5FA1INC))
               (T6PP1C (LOGIOR (LOGIOR (LOGAND T5FA1INA T5FA1INB)
                                       (LOGAND T5FA1INA T5FA1INC))
                               (LOGAND T5FA1INB T5FA1INC)))
               (T6FA0INA 0)
               (T6FA0INB 0)
               (T6FA0INC 0)
               (T8PP0S 0)
               (T7PP0C 0)
               (T6FA0INA (BITS (ASH T6PP0S 2) 110 0))
               (T6FA0INB T6PP1S)
               (T6FA0INC (BITS (ASH T6PP2S 1) 110 0))
               (T8PP0S (LOGXOR (LOGXOR T6FA0INA T6FA0INB)
                               T6FA0INC))
               (T7PP0C (LOGIOR (LOGIOR (LOGAND T6FA0INA T6FA0INB)
                                       (LOGAND T6FA0INA T6FA0INC))
                               (LOGAND T6FA0INB T6FA0INC)))
               (T7FA0INA 0)
               (T7FA0INB 0)
               (T7FA0INC 0)
               (T9PP0S 0)
               (T7PP1C 0)
               (T7FA0INA T7PP0S)
               (T7FA0INB T7PP0C)
               (T7FA0INC (BITS (ASH T6PP0C 1) 111 0))
               (T9PP0S (LOGXOR (LOGXOR T7FA0INA T7FA0INB)
                               T7FA0INC))
               (T7PP1C (LOGIOR (LOGIOR (LOGAND T7FA0INA T7FA0INB)
                                       (LOGAND T7FA0INA T7FA0INC))
                               (LOGAND T7FA0INB T7FA0INC)))
               (T8FA1INA 0)
               (T8FA1INB 0)
               (T8FA1INC 0)
               (T9PP1S 0)
               (T9PP0C 0)
               (T8FA1INA (BITS (ASH T7PP1C 2) 113 0))
               (T8FA1INB (BITS (ASH T6PP1C 2) 113 0))
               (T8FA1INC T8PP0S)
               (T9PP1S (LOGXOR (LOGXOR T8FA1INA T8FA1INB)
                               T8FA1INC))
               (T9PP0C (LOGIOR (LOGIOR (LOGAND T8FA1INA T8FA1INB)
                                       (LOGAND T8FA1INA T8FA1INC))
                               (LOGAND T8FA1INB T8FA1INC)))
               (T9FA1INA 0)
               (T9FA1INB 0)
               (T9FA1INC 0)
               (T11PP0S 0)
               (T10PP0C 0)
               (T9FA1INA (BITS (ASH T9PP0S 1) 114 0))
               (T9FA1INB T9PP1S)
               (T9FA1INC (BITS (ASH T9PP0C 1) 114 0)))
              (MV (BITS (LOGXOR (LOGXOR T9FA1INA T9FA1INB)
                                T9FA1INC)
                        105 0)
                  (BITS (BITS (ASH (LOGIOR (LOGIOR (LOGAND T9FA1INA T9FA1INB)
                                                   (LOGAND T9FA1INA T9FA1INC))
                                           (LOGAND T9FA1INB T9FA1INC))
                                   1)
                              115 0)
                        105 0))))

(DEFUND
     COMPUTEPRODUCT-LOOP-0
     (I MULTIPLIER MANA PP)
     (DECLARE (XARGS :MEASURE (NFIX (- 27 I))))
     (IF (AND (INTEGERP I) (< I 27))
         (LET* ((SLICE (BITS MULTIPLIER (+ (* 2 I) 2) (* 2 I)))
                (SIGN (BITN SLICE 2))
                (SIGNLAST (BITN SLICE 0))
                (ENC (- (+ (BITN SLICE 0) (BITN SLICE 1))
                        (* 2 (BITN SLICE 2))))
                (MUX 0)
                (MUX (CASE ENC (0 (BITS 0 52 0))
                           ((1 -1) MANA)
                           ((2 -2) (BITS (ASH MANA 1) 52 0))
                           (T MUX)))
                (MUX (IF1 SIGN (BITS (LOGNOT MUX) 52 0) MUX))
                (PP (IF1 (LOG= I 0)
                         (LET* ((PP (AS I (SETBITS (AG I PP) 57 52 0 MUX)
                                        PP))
                                (PP (AS I (SETBITN (AG I PP) 57 53 SIGN)
                                        PP))
                                (PP (AS I (SETBITN (AG I PP) 57 54 SIGN)
                                        PP))
                                (PP (AS I
                                        (SETBITN (AG I PP) 57 55 (LOGNOT1 SIGN))
                                        PP)))
                               (AS I (SETBITN (AG I PP) 57 56 0) PP))
                         (LET* ((PP (AS I (SETBITN (AG I PP) 57 0 SIGNLAST)
                                        PP))
                                (PP (AS I (SETBITN (AG I PP) 57 1 0) PP))
                                (PP (AS I (SETBITS (AG I PP) 57 54 2 MUX)
                                        PP))
                                (PP (AS I
                                        (SETBITN (AG I PP) 57 55 (LOGNOT1 SIGN))
                                        PP)))
                               (AS I (SETBITN (AG I PP) 57 56 (LOG< I 26))
                                   PP)))))
               (COMPUTEPRODUCT-LOOP-0 (+ I 1)
                                      MULTIPLIER MANA PP))
         PP))

(DEFUND COMPUTEPRODUCT
        (MANA MANB EXPAZERO EXPBZERO)
        (LET* ((PP NIL)
               (MULTIPLIER MANB)
               (MULTIPLIER (BITS (ASH MULTIPLIER 1) 54 0))
               (PP (COMPUTEPRODUCT-LOOP-0 0 MULTIPLIER MANA PP))
               (IA (BITS (IF1 EXPAZERO 0 MANB) 51 0))
               (IB (BITS (IF1 EXPBZERO 0 MANA) 52 0))
               (IB (SETBITN IB 53 52
                            (LOGAND1 (LOGNOT1 EXPAZERO)
                                     (LOGNOT1 EXPBZERO))))
               (PPA 0)
               (PPB 0))
              (MV-LET (PPA PPB)
                      (COMPRESS PP IA IB)
                      (BITS (+ PPA PPB) 105 0))))

(DEFUND RIGHTSHFT-LOOP-0 (I SHIFT STKSHFTMASK)
        (DECLARE (XARGS :MEASURE (NFIX (- SHIFT I))))
        (IF (AND (INTEGERP I)
                 (INTEGERP SHIFT)
                 (< I SHIFT))
            (LET ((STKSHFTMASK (SETBITN STKSHFTMASK 63 I 1)))
                 (RIGHTSHFT-LOOP-0 (+ I 1)
                                   SHIFT STKSHFTMASK))
            STKSHFTMASK))

(DEFUND RIGHTSHFT (EXPBIASED HUGENEGSCALE PROD)
        (LET* ((EXPDEFICIT (BITS (- 1 (SI EXPBIASED 14)) 13 0))
               (SHIFT (BITS EXPDEFICIT 5 0))
               (SHIFT (IF1 (LOGIOR1 HUGENEGSCALE
                                    (LOG<> (BITS EXPDEFICIT 13 6) 0))
                           (SETBITS SHIFT 6 5 1 31)
                           SHIFT))
               (PROD0 (BITS 0 106 0))
               (PROD0 (SETBITS PROD0 107 106 1 PROD))
               (PRODSHFT (BITS (ASH PROD0 (- SHIFT)) 105 0))
               (FRAC105 (BITS PRODSHFT 104 0))
               (EXPSHFT (BITS 0 12 0))
               (EXPINC (LOGAND1 (BITN PROD 105)
                                (LOG= SHIFT 1)))
               (STKSHFTMASK (BITS 0 62 0))
               (STKSHFTMASK (RIGHTSHFT-LOOP-0 0 SHIFT STKSHFTMASK))
               (STKSHFT (LOG<> (LOGAND PROD (ASH STKSHFTMASK (- 1)))
                               0))
               (STKMASK (BITS 4503599627370495 106 0))
               (STKMASK (SETBITS STKMASK
                                 107 106 52 (BITS STKSHFTMASK 54 0)))
               (STK (LOG<> (LOGAND PROD (BITS STKMASK 106 1))
                           0))
               (GRDMASK (BITS (LOGAND (LOGNOT (BITS STKMASK 106 52))
                                      (BITS STKMASK 105 51))
                              54 0)))
              (MV EXPSHFT EXPINC FRAC105 STKSHFT
                  (LOG<> (LOGAND (BITS GRDMASK 53 0)
                                 (BITS PROD 105 52))
                         0)
                  (LOG<> (LOGAND GRDMASK (BITS PROD 105 51))
                         0)
                  STK)))

(DEFUND LEFTSHFT (EXPBIASED PROD CLZ)
        (LET* ((EXPDIFF (BITS (- (SI EXPBIASED 14) CLZ) 13 0))
               (SHIFT (BITS (IF1 (LOG= (SI EXPDIFF 14) 0)
                                 (- CLZ 1)
                                 (IF1 (LOG> (SI EXPDIFF 14) 0)
                                      CLZ (- (SI EXPBIASED 14) 1)))
                            5 0))
               (PRODSHFT (BITS (ASH PROD SHIFT) 105 0))
               (EXPSHFT (BITS (IF1 (LOG> (SI EXPDIFF 14) 0)
                                   (SI EXPDIFF 14)
                                   0)
                              12 0))
               (OVFMASK (BITS (ASH 9223372036854775808 (- SHIFT))
                              63 0))
               (MULOVF (LOG<> (LOGAND OVFMASK (BITS PROD 105 42))
                              0))
               (SUB2NORM (LOG<> (LOGAND (ASH OVFMASK (- 1))
                                        (BITS PROD 104 42))
                                0))
               (FRAC105 (BITS PRODSHFT 104 0))
               (FRAC105 (IF1 (LOGNOT1 MULOVF)
                             (BITS (ASH FRAC105 1) 104 0)
                             FRAC105))
               (EXPINC (LOGIOR1 MULOVF
                                (LOGAND1 (LOG= (SI EXPDIFF 14) 0)
                                         SUB2NORM)))
               (STKMASK (BITS (ASH 4503599627370495 (- SHIFT))
                              51 0))
               (STK (IF1 MULOVF (LOG<> (LOGAND STKMASK PROD) 0)
                         (LOG<> (LOGAND (ASH STKMASK (- 1)) PROD)
                                0)))
               (GRDMASK (BITS OVFMASK 63 11))
               (GRD (IF1 MULOVF (LOG<> (LOGAND GRDMASK PROD) 0)
                         (LOG<> (LOGAND (ASH GRDMASK (- 1)) PROD)
                                0)))
               (LSBMASK (BITS OVFMASK 63 10)))
              (MV EXPSHFT EXPINC FRAC105 0
                  (IF1 MULOVF (LOG<> (LOGAND LSBMASK PROD) 0)
                       (LOG<> (LOGAND (ASH LSBMASK (- 1)) PROD)
                              0))
                  GRD STK)))

(DEFUND
 FMUL64
 (OPA OPB SCALE FZ DN RMODE FUSED FSCALE)
 (LET
  ((SIGNA 0)
   (SIGNB 0)
   (EXPA 0)
   (EXPB 0)
   (MANA 0)
   (MANB 0)
   (CLASSA 0)
   (CLASSB 0)
   (FLAGS (BITS 0 7 0)))
  (MV-LET
   (SIGNA EXPA MANA CLASSA FLAGS)
   (ANALYZE OPA 3 FZ FLAGS)
   (MV-LET
    (SIGNB EXPB MANB CLASSB FLAGS)
    (ANALYZE OPB 3 FZ FLAGS)
    (IF1
     (LOGIOR1
          (LOGIOR1 (LOGIOR1 (LOGIOR1 (LOGIOR1 (LOGIOR1 (LOGIOR1 (LOG= CLASSA 0)
                                                                (LOG= CLASSA 1))
                                                       (LOG= CLASSA 2))
                                              (LOG= CLASSA 3))
                                     (LOG= CLASSB 0))
                            (LOG= CLASSB 1))
                   (LOG= CLASSB 2))
          (LOG= CLASSB 3))
     (SPECIALCASE OPA OPB CLASSA CLASSB DN FUSED FLAGS)
     (LET*
      ((PROD (COMPUTEPRODUCT MANA MANB (LOG= EXPA 0)
                             (LOG= EXPB 0)))
       (HUGEPOSSCALE (LOGAND1 FSCALE (LOG>= (SI SCALE 64) 4096)))
       (HUGENEGSCALE (LOGAND1 FSCALE (LOG< (SI SCALE 64) (- 4096))))
       (EXPBUNBIASED (BITS (IF1 FSCALE (SI SCALE 64)
                                (IF1 (LOG= EXPB 0)
                                     (- 1022)
                                     (- EXPB 1023)))
                           13 0))
       (EXPABIASED (BITS (IF1 (LOG= EXPA 0) 1 EXPA) 13 0))
       (EXPBIASED (BITS (+ (SI EXPABIASED 14)
                           (SI EXPBUNBIASED 14))
                        13 0))
       (EXPSHFT 0)
       (EXPINC 0)
       (FRAC105 0)
       (STKSHFT 0)
       (LSB 0)
       (GRD 0)
       (STK 0))
      (MV-LET
       (EXPSHFT EXPINC FRAC105 STKSHFT LSB GRD STK)
       (IF1 (LOGIOR1 (LOG<= (SI EXPBIASED 14) 0)
                     HUGENEGSCALE)
            (RIGHTSHFT EXPBIASED HUGENEGSCALE PROD)
            (LET* ((CLZ (BITS 0 5 0))
                   (CLZ (IF1 (LOG= EXPA 0)
                             (LOGIOR CLZ (CLZ53 MANA))
                             CLZ))
                   (CLZ (IF1 (LOG= EXPB 0)
                             (LOGIOR CLZ (CLZ53 MANB))
                             CLZ)))
                  (LEFTSHFT EXPBIASED PROD CLZ)))
       (LET
        ((EXPZERO (LOG= EXPSHFT 0))
         (EXPMAX (LOG= EXPSHFT 2046))
         (EXPINF (LOG= EXPSHFT 2047))
         (EXPGTINF (LOGIOR1 (LOG> EXPSHFT 2047)
                            HUGEPOSSCALE))
         (EXP11 (BITS EXPSHFT 10 0))
         (SIGN (LOGXOR SIGNA SIGNB)))
        (IF1
         FUSED
         (LET* ((D 0) (D (SETBITN D 117 116 SIGN)))
               (MV (SETBITS (IF1 (LOGAND1 EXPINC (LOGNOT1 EXPINF))
                                 (SETBITS D 117 115 105 (+ EXP11 1))
                                 (SETBITS D 117 115 105 EXP11))
                            117 104 0 FRAC105)
                   (SETBITN FLAGS 8 4 STKSHFT)
                   (FALSE$)
                   (FALSE$)
                   (LOGIOR1 EXPGTINF (LOGAND1 EXPINF EXPINC))))
         (LET*
          ((D (BITS 0 63 0))
           (D (SETBITN D 64 63 SIGN))
           (RNDUP
              (LOGIOR1 (LOGIOR1 (LOGAND1 (LOGAND1 (LOG= RMODE 0) GRD)
                                         (LOGIOR1 LSB STK))
                                (LOGAND1 (LOGAND1 (LOG= RMODE 1) (LOGNOT1 SIGN))
                                         (LOGIOR1 GRD STK)))
                       (LOGAND1 (LOGAND1 (LOG= RMODE 2) SIGN)
                                (LOGIOR1 GRD STK))))
           (FRACUNRND (BITS FRAC105 104 53))
           (FRACP1 (BITS (+ FRACUNRND 1) 52 0))
           (FRACRND (BITS (IF1 RNDUP (BITS FRACP1 51 0) FRACUNRND)
                          51 0))
           (EXPRNDINC (LOGAND1 RNDUP (BITN FRACP1 52)))
           (EXPRND (BITS (IF1 (LOGIOR1 EXPINC EXPRNDINC)
                              (+ EXP11 1)
                              EXP11)
                         10 0))
           (UNDERFLOW (LOGAND1 EXPZERO (LOGNOT1 EXPINC)))
           (OVERFLOW (LOGIOR1 (LOGIOR1 EXPINF EXPGTINF)
                              (LOGAND1 EXPMAX (LOGIOR1 EXPINC EXPRNDINC)))))
          (MV-LET
           (FLAGS D)
           (IF1
             OVERFLOW
             (MV (SETBITN (SETBITN FLAGS 8 4 1) 8 2 1)
                 (IF1 (LOGIOR1 (LOGIOR1 (LOGAND1 (LOG= RMODE 1) SIGN)
                                        (LOGAND1 (LOG= RMODE 2) (LOGNOT1 SIGN)))
                               (LOG= RMODE 3))
                      (SETBITS D 64 62 0 9218868437227405311)
                      (SETBITS D 64 62 0 9218868437227405312)))
             (MV-LET (D FLAGS)
                     (IF1 UNDERFLOW
                          (IF1 FZ (MV D (SETBITN FLAGS 8 3 1))
                               (MV (SETBITS (SETBITS D 64 51 0 FRACRND)
                                            64 62 52 EXPRND)
                                   (IF1 (LOGIOR1 GRD STK)
                                        (LET ((FLAGS (SETBITN FLAGS 8 3 1)))
                                             (SETBITN FLAGS 8 4 1))
                                        FLAGS)))
                          (MV (SETBITS (SETBITS D 64 51 0 FRACRND)
                                       64 62 52 EXPRND)
                              (IF1 (LOGIOR1 GRD STK)
                                   (SETBITN FLAGS 8 4 1)
                                   FLAGS)))
                     (MV FLAGS D)))
           (MV D FLAGS (FALSE$)
               (FALSE$)
               (FALSE$)))))))))))))

