// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package log_target

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// CreateLogTargetDefaultsCreatedCode is the HTTP code returned for type CreateLogTargetDefaultsCreated
const CreateLogTargetDefaultsCreatedCode int = 201

/*
CreateLogTargetDefaultsCreated Log Target created

swagger:response createLogTargetDefaultsCreated
*/
type CreateLogTargetDefaultsCreated struct {

	/*
	  In: Body
	*/
	Payload *models.LogTarget `json:"body,omitempty"`
}

// NewCreateLogTargetDefaultsCreated creates CreateLogTargetDefaultsCreated with default headers values
func NewCreateLogTargetDefaultsCreated() *CreateLogTargetDefaultsCreated {

	return &CreateLogTargetDefaultsCreated{}
}

// WithPayload adds the payload to the create log target defaults created response
func (o *CreateLogTargetDefaultsCreated) WithPayload(payload *models.LogTarget) *CreateLogTargetDefaultsCreated {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create log target defaults created response
func (o *CreateLogTargetDefaultsCreated) SetPayload(payload *models.LogTarget) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateLogTargetDefaultsCreated) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(201)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// CreateLogTargetDefaultsAcceptedCode is the HTTP code returned for type CreateLogTargetDefaultsAccepted
const CreateLogTargetDefaultsAcceptedCode int = 202

/*
CreateLogTargetDefaultsAccepted Configuration change accepted and reload requested

swagger:response createLogTargetDefaultsAccepted
*/
type CreateLogTargetDefaultsAccepted struct {
	/*ID of the requested reload

	 */
	ReloadID string `json:"Reload-ID"`

	/*
	  In: Body
	*/
	Payload *models.LogTarget `json:"body,omitempty"`
}

// NewCreateLogTargetDefaultsAccepted creates CreateLogTargetDefaultsAccepted with default headers values
func NewCreateLogTargetDefaultsAccepted() *CreateLogTargetDefaultsAccepted {

	return &CreateLogTargetDefaultsAccepted{}
}

// WithReloadID adds the reloadId to the create log target defaults accepted response
func (o *CreateLogTargetDefaultsAccepted) WithReloadID(reloadID string) *CreateLogTargetDefaultsAccepted {
	o.ReloadID = reloadID
	return o
}

// SetReloadID sets the reloadId to the create log target defaults accepted response
func (o *CreateLogTargetDefaultsAccepted) SetReloadID(reloadID string) {
	o.ReloadID = reloadID
}

// WithPayload adds the payload to the create log target defaults accepted response
func (o *CreateLogTargetDefaultsAccepted) WithPayload(payload *models.LogTarget) *CreateLogTargetDefaultsAccepted {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create log target defaults accepted response
func (o *CreateLogTargetDefaultsAccepted) SetPayload(payload *models.LogTarget) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateLogTargetDefaultsAccepted) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Reload-ID

	reloadID := o.ReloadID
	if reloadID != "" {
		rw.Header().Set("Reload-ID", reloadID)
	}

	rw.WriteHeader(202)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// CreateLogTargetDefaultsBadRequestCode is the HTTP code returned for type CreateLogTargetDefaultsBadRequest
const CreateLogTargetDefaultsBadRequestCode int = 400

/*
CreateLogTargetDefaultsBadRequest Bad request

swagger:response createLogTargetDefaultsBadRequest
*/
type CreateLogTargetDefaultsBadRequest struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewCreateLogTargetDefaultsBadRequest creates CreateLogTargetDefaultsBadRequest with default headers values
func NewCreateLogTargetDefaultsBadRequest() *CreateLogTargetDefaultsBadRequest {

	return &CreateLogTargetDefaultsBadRequest{}
}

// WithConfigurationVersion adds the configurationVersion to the create log target defaults bad request response
func (o *CreateLogTargetDefaultsBadRequest) WithConfigurationVersion(configurationVersion string) *CreateLogTargetDefaultsBadRequest {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the create log target defaults bad request response
func (o *CreateLogTargetDefaultsBadRequest) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the create log target defaults bad request response
func (o *CreateLogTargetDefaultsBadRequest) WithPayload(payload *models.Error) *CreateLogTargetDefaultsBadRequest {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create log target defaults bad request response
func (o *CreateLogTargetDefaultsBadRequest) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateLogTargetDefaultsBadRequest) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(400)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// CreateLogTargetDefaultsConflictCode is the HTTP code returned for type CreateLogTargetDefaultsConflict
const CreateLogTargetDefaultsConflictCode int = 409

/*
CreateLogTargetDefaultsConflict The specified resource already exists

swagger:response createLogTargetDefaultsConflict
*/
type CreateLogTargetDefaultsConflict struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewCreateLogTargetDefaultsConflict creates CreateLogTargetDefaultsConflict with default headers values
func NewCreateLogTargetDefaultsConflict() *CreateLogTargetDefaultsConflict {

	return &CreateLogTargetDefaultsConflict{}
}

// WithConfigurationVersion adds the configurationVersion to the create log target defaults conflict response
func (o *CreateLogTargetDefaultsConflict) WithConfigurationVersion(configurationVersion string) *CreateLogTargetDefaultsConflict {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the create log target defaults conflict response
func (o *CreateLogTargetDefaultsConflict) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the create log target defaults conflict response
func (o *CreateLogTargetDefaultsConflict) WithPayload(payload *models.Error) *CreateLogTargetDefaultsConflict {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create log target defaults conflict response
func (o *CreateLogTargetDefaultsConflict) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateLogTargetDefaultsConflict) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(409)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
CreateLogTargetDefaultsDefault General Error

swagger:response createLogTargetDefaultsDefault
*/
type CreateLogTargetDefaultsDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewCreateLogTargetDefaultsDefault creates CreateLogTargetDefaultsDefault with default headers values
func NewCreateLogTargetDefaultsDefault(code int) *CreateLogTargetDefaultsDefault {
	if code <= 0 {
		code = 500
	}

	return &CreateLogTargetDefaultsDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the create log target defaults default response
func (o *CreateLogTargetDefaultsDefault) WithStatusCode(code int) *CreateLogTargetDefaultsDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the create log target defaults default response
func (o *CreateLogTargetDefaultsDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the create log target defaults default response
func (o *CreateLogTargetDefaultsDefault) WithConfigurationVersion(configurationVersion string) *CreateLogTargetDefaultsDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the create log target defaults default response
func (o *CreateLogTargetDefaultsDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the create log target defaults default response
func (o *CreateLogTargetDefaultsDefault) WithPayload(payload *models.Error) *CreateLogTargetDefaultsDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the create log target defaults default response
func (o *CreateLogTargetDefaultsDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *CreateLogTargetDefaultsDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
