//    SPDX-License-Identifier: LGPL-3.0-or-later
/*
   This file is part of FlexiBLAS, a BLAS/LAPACK interface wrapper library.
   Copyright (C) 2013-2025 Martin Koehler

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 3 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/ 

#ifndef FLEXIBLAS_HOOKS_STRUCTURE_H
#define FLEXIBLAS_HOOKS_STRUCTURE_H

#include <stdint.h>

/* Complex type (single precision) */

#ifndef lapack_complex_float
#ifndef __cplusplus
#include <complex.h>
#else
#include <complex>
#endif
#define lapack_complex_float    float _Complex
#endif

#ifndef blas_complex_float
#ifndef __cplusplus
#include <complex.h>
#else
#include <complex>
#endif
#define blas_complex_float    float _Complex
#endif


/* Complex type (double precision) */
#ifndef lapack_complex_double
#ifndef __cplusplus
#include <complex.h>
#else
#include <complex>
#endif
#define lapack_complex_double   double _Complex
#endif

#ifndef blas_complex_double
#ifndef __cplusplus
#include <complex.h>
#else
#include <complex>
#endif
#define blas_complex_double   double _Complex
#endif


#ifdef __cplusplus
extern "C" {
#endif

#include "flexiblas_config.h"
#include "flexiblas_fortran_char_len.h"
#include "flexiblas_fortran_mangle.h"


    #define FLEXIBLAS_MAX_HOOKS 256
    struct flexiblas_hook_fn {
        void *hook_function[FLEXIBLAS_MAX_HOOKS];
        uint16_t nhook;
    };
    
    typedef struct _flexiblas_hook_backend {
        void *handles[FLEXIBLAS_MAX_HOOKS];
        int  hooks_loaded;
        int  initialized;
        flexiblas_init_function_t hook_init[FLEXIBLAS_MAX_HOOKS];
        flexiblas_exit_function_t hook_exit[FLEXIBLAS_MAX_HOOKS];
        struct flexiblas_hook_fn caxpby;
    struct flexiblas_hook_fn caxpy;
    struct flexiblas_hook_fn ccopy;
    struct flexiblas_hook_fn cdotc;
    struct flexiblas_hook_fn cdotc_sub;
    struct flexiblas_hook_fn cdotu;
    struct flexiblas_hook_fn cdotu_sub;
    struct flexiblas_hook_fn cgbmv;
    struct flexiblas_hook_fn cgeadd;
    struct flexiblas_hook_fn cgemm;
    struct flexiblas_hook_fn cgemmtr;
    struct flexiblas_hook_fn cgemv;
    struct flexiblas_hook_fn cgerc;
    struct flexiblas_hook_fn cgeru;
    struct flexiblas_hook_fn chbmv;
    struct flexiblas_hook_fn chemm;
    struct flexiblas_hook_fn chemv;
    struct flexiblas_hook_fn cher;
    struct flexiblas_hook_fn cher2;
    struct flexiblas_hook_fn cher2k;
    struct flexiblas_hook_fn cherk;
    struct flexiblas_hook_fn chpmv;
    struct flexiblas_hook_fn chpr;
    struct flexiblas_hook_fn chpr2;
    struct flexiblas_hook_fn cimatcopy;
    struct flexiblas_hook_fn comatcopy;
    struct flexiblas_hook_fn crotg;
    struct flexiblas_hook_fn cscal;
    struct flexiblas_hook_fn csrot;
    struct flexiblas_hook_fn csscal;
    struct flexiblas_hook_fn cswap;
    struct flexiblas_hook_fn csymm;
    struct flexiblas_hook_fn csyr2k;
    struct flexiblas_hook_fn csyrk;
    struct flexiblas_hook_fn ctbmv;
    struct flexiblas_hook_fn ctbsv;
    struct flexiblas_hook_fn ctpmv;
    struct flexiblas_hook_fn ctpsv;
    struct flexiblas_hook_fn ctrmm;
    struct flexiblas_hook_fn ctrmv;
    struct flexiblas_hook_fn ctrsm;
    struct flexiblas_hook_fn ctrsv;
    struct flexiblas_hook_fn dasum;
    struct flexiblas_hook_fn daxpby;
    struct flexiblas_hook_fn daxpy;
    struct flexiblas_hook_fn dcopy;
    struct flexiblas_hook_fn ddot;
    struct flexiblas_hook_fn dgbmv;
    struct flexiblas_hook_fn dgeadd;
    struct flexiblas_hook_fn dgemm;
    struct flexiblas_hook_fn dgemmtr;
    struct flexiblas_hook_fn dgemv;
    struct flexiblas_hook_fn dger;
    struct flexiblas_hook_fn dimatcopy;
    struct flexiblas_hook_fn dnrm2;
    struct flexiblas_hook_fn domatcopy;
    struct flexiblas_hook_fn drot;
    struct flexiblas_hook_fn drotg;
    struct flexiblas_hook_fn drotm;
    struct flexiblas_hook_fn drotmg;
    struct flexiblas_hook_fn dsbmv;
    struct flexiblas_hook_fn dscal;
    struct flexiblas_hook_fn dsdot;
    struct flexiblas_hook_fn dspmv;
    struct flexiblas_hook_fn dspr;
    struct flexiblas_hook_fn dspr2;
    struct flexiblas_hook_fn dswap;
    struct flexiblas_hook_fn dsymm;
    struct flexiblas_hook_fn dsymv;
    struct flexiblas_hook_fn dsyr;
    struct flexiblas_hook_fn dsyr2;
    struct flexiblas_hook_fn dsyr2k;
    struct flexiblas_hook_fn dsyrk;
    struct flexiblas_hook_fn dtbmv;
    struct flexiblas_hook_fn dtbsv;
    struct flexiblas_hook_fn dtpmv;
    struct flexiblas_hook_fn dtpsv;
    struct flexiblas_hook_fn dtrmm;
    struct flexiblas_hook_fn dtrmv;
    struct flexiblas_hook_fn dtrsm;
    struct flexiblas_hook_fn dtrsv;
    struct flexiblas_hook_fn dzasum;
    struct flexiblas_hook_fn dznrm2;
    struct flexiblas_hook_fn icamax;
    struct flexiblas_hook_fn idamax;
    struct flexiblas_hook_fn isamax;
    struct flexiblas_hook_fn izamax;
    struct flexiblas_hook_fn sasum;
    struct flexiblas_hook_fn saxpby;
    struct flexiblas_hook_fn saxpy;
    struct flexiblas_hook_fn scasum;
    struct flexiblas_hook_fn scnrm2;
    struct flexiblas_hook_fn scopy;
    struct flexiblas_hook_fn sdot;
    struct flexiblas_hook_fn sdsdot;
    struct flexiblas_hook_fn sgbmv;
    struct flexiblas_hook_fn sgeadd;
    struct flexiblas_hook_fn sgemm;
    struct flexiblas_hook_fn sgemmtr;
    struct flexiblas_hook_fn sgemv;
    struct flexiblas_hook_fn sger;
    struct flexiblas_hook_fn simatcopy;
    struct flexiblas_hook_fn snrm2;
    struct flexiblas_hook_fn somatcopy;
    struct flexiblas_hook_fn srot;
    struct flexiblas_hook_fn srotg;
    struct flexiblas_hook_fn srotm;
    struct flexiblas_hook_fn srotmg;
    struct flexiblas_hook_fn ssbmv;
    struct flexiblas_hook_fn sscal;
    struct flexiblas_hook_fn sspmv;
    struct flexiblas_hook_fn sspr;
    struct flexiblas_hook_fn sspr2;
    struct flexiblas_hook_fn sswap;
    struct flexiblas_hook_fn ssymm;
    struct flexiblas_hook_fn ssymv;
    struct flexiblas_hook_fn ssyr;
    struct flexiblas_hook_fn ssyr2;
    struct flexiblas_hook_fn ssyr2k;
    struct flexiblas_hook_fn ssyrk;
    struct flexiblas_hook_fn stbmv;
    struct flexiblas_hook_fn stbsv;
    struct flexiblas_hook_fn stpmv;
    struct flexiblas_hook_fn stpsv;
    struct flexiblas_hook_fn strmm;
    struct flexiblas_hook_fn strmv;
    struct flexiblas_hook_fn strsm;
    struct flexiblas_hook_fn strsv;
    struct flexiblas_hook_fn zaxpby;
    struct flexiblas_hook_fn zaxpy;
    struct flexiblas_hook_fn zcopy;
    struct flexiblas_hook_fn zdotc;
    struct flexiblas_hook_fn zdotc_sub;
    struct flexiblas_hook_fn zdotu;
    struct flexiblas_hook_fn zdotu_sub;
    struct flexiblas_hook_fn zdrot;
    struct flexiblas_hook_fn zdscal;
    struct flexiblas_hook_fn zgbmv;
    struct flexiblas_hook_fn zgeadd;
    struct flexiblas_hook_fn zgemm;
    struct flexiblas_hook_fn zgemmtr;
    struct flexiblas_hook_fn zgemv;
    struct flexiblas_hook_fn zgerc;
    struct flexiblas_hook_fn zgeru;
    struct flexiblas_hook_fn zhbmv;
    struct flexiblas_hook_fn zhemm;
    struct flexiblas_hook_fn zhemv;
    struct flexiblas_hook_fn zher;
    struct flexiblas_hook_fn zher2;
    struct flexiblas_hook_fn zher2k;
    struct flexiblas_hook_fn zherk;
    struct flexiblas_hook_fn zhpmv;
    struct flexiblas_hook_fn zhpr;
    struct flexiblas_hook_fn zhpr2;
    struct flexiblas_hook_fn zimatcopy;
    struct flexiblas_hook_fn zomatcopy;
    struct flexiblas_hook_fn zrotg;
    struct flexiblas_hook_fn zscal;
    struct flexiblas_hook_fn zswap;
    struct flexiblas_hook_fn zsymm;
    struct flexiblas_hook_fn zsyr2k;
    struct flexiblas_hook_fn zsyrk;
    struct flexiblas_hook_fn ztbmv;
    struct flexiblas_hook_fn ztbsv;
    struct flexiblas_hook_fn ztpmv;
    struct flexiblas_hook_fn ztpsv;
    struct flexiblas_hook_fn ztrmm;
    struct flexiblas_hook_fn ztrmv;
    struct flexiblas_hook_fn ztrsm;
    struct flexiblas_hook_fn ztrsv;
    /* CBLAS */
    struct flexiblas_hook_fn cblas_caxpby;
    struct flexiblas_hook_fn cblas_caxpy;
    struct flexiblas_hook_fn cblas_ccopy;
    struct flexiblas_hook_fn cblas_cdotc_sub;
    struct flexiblas_hook_fn cblas_cdotu_sub;
    struct flexiblas_hook_fn cblas_cgbmv;
    struct flexiblas_hook_fn cblas_cgeadd;
    struct flexiblas_hook_fn cblas_cgemm;
    struct flexiblas_hook_fn cblas_cgemmtr;
    struct flexiblas_hook_fn cblas_cgemv;
    struct flexiblas_hook_fn cblas_cgerc;
    struct flexiblas_hook_fn cblas_cgeru;
    struct flexiblas_hook_fn cblas_chbmv;
    struct flexiblas_hook_fn cblas_chemm;
    struct flexiblas_hook_fn cblas_chemv;
    struct flexiblas_hook_fn cblas_cher;
    struct flexiblas_hook_fn cblas_cher2;
    struct flexiblas_hook_fn cblas_cher2k;
    struct flexiblas_hook_fn cblas_cherk;
    struct flexiblas_hook_fn cblas_chpmv;
    struct flexiblas_hook_fn cblas_chpr;
    struct flexiblas_hook_fn cblas_chpr2;
    struct flexiblas_hook_fn cblas_cimatcopy;
    struct flexiblas_hook_fn cblas_comatcopy;
    struct flexiblas_hook_fn cblas_crotg;
    struct flexiblas_hook_fn cblas_cscal;
    struct flexiblas_hook_fn cblas_csrot;
    struct flexiblas_hook_fn cblas_csscal;
    struct flexiblas_hook_fn cblas_cswap;
    struct flexiblas_hook_fn cblas_csymm;
    struct flexiblas_hook_fn cblas_csyr2k;
    struct flexiblas_hook_fn cblas_csyrk;
    struct flexiblas_hook_fn cblas_ctbmv;
    struct flexiblas_hook_fn cblas_ctbsv;
    struct flexiblas_hook_fn cblas_ctpmv;
    struct flexiblas_hook_fn cblas_ctpsv;
    struct flexiblas_hook_fn cblas_ctrmm;
    struct flexiblas_hook_fn cblas_ctrmv;
    struct flexiblas_hook_fn cblas_ctrsm;
    struct flexiblas_hook_fn cblas_ctrsv;
    struct flexiblas_hook_fn cblas_dasum;
    struct flexiblas_hook_fn cblas_daxpby;
    struct flexiblas_hook_fn cblas_daxpy;
    struct flexiblas_hook_fn cblas_dcabs1;
    struct flexiblas_hook_fn cblas_dcopy;
    struct flexiblas_hook_fn cblas_ddot;
    struct flexiblas_hook_fn cblas_dgbmv;
    struct flexiblas_hook_fn cblas_dgeadd;
    struct flexiblas_hook_fn cblas_dgemm;
    struct flexiblas_hook_fn cblas_dgemmtr;
    struct flexiblas_hook_fn cblas_dgemv;
    struct flexiblas_hook_fn cblas_dger;
    struct flexiblas_hook_fn cblas_dimatcopy;
    struct flexiblas_hook_fn cblas_dnrm2;
    struct flexiblas_hook_fn cblas_domatcopy;
    struct flexiblas_hook_fn cblas_drot;
    struct flexiblas_hook_fn cblas_drotg;
    struct flexiblas_hook_fn cblas_drotm;
    struct flexiblas_hook_fn cblas_drotmg;
    struct flexiblas_hook_fn cblas_dsbmv;
    struct flexiblas_hook_fn cblas_dscal;
    struct flexiblas_hook_fn cblas_dsdot;
    struct flexiblas_hook_fn cblas_dspmv;
    struct flexiblas_hook_fn cblas_dspr;
    struct flexiblas_hook_fn cblas_dspr2;
    struct flexiblas_hook_fn cblas_dswap;
    struct flexiblas_hook_fn cblas_dsymm;
    struct flexiblas_hook_fn cblas_dsymv;
    struct flexiblas_hook_fn cblas_dsyr;
    struct flexiblas_hook_fn cblas_dsyr2;
    struct flexiblas_hook_fn cblas_dsyr2k;
    struct flexiblas_hook_fn cblas_dsyrk;
    struct flexiblas_hook_fn cblas_dtbmv;
    struct flexiblas_hook_fn cblas_dtbsv;
    struct flexiblas_hook_fn cblas_dtpmv;
    struct flexiblas_hook_fn cblas_dtpsv;
    struct flexiblas_hook_fn cblas_dtrmm;
    struct flexiblas_hook_fn cblas_dtrmv;
    struct flexiblas_hook_fn cblas_dtrsm;
    struct flexiblas_hook_fn cblas_dtrsv;
    struct flexiblas_hook_fn cblas_dzasum;
    struct flexiblas_hook_fn cblas_dznrm2;
    struct flexiblas_hook_fn cblas_icamax;
    struct flexiblas_hook_fn cblas_idamax;
    struct flexiblas_hook_fn cblas_isamax;
    struct flexiblas_hook_fn cblas_izamax;
    struct flexiblas_hook_fn cblas_sasum;
    struct flexiblas_hook_fn cblas_saxpby;
    struct flexiblas_hook_fn cblas_saxpy;
    struct flexiblas_hook_fn cblas_scabs1;
    struct flexiblas_hook_fn cblas_scasum;
    struct flexiblas_hook_fn cblas_scnrm2;
    struct flexiblas_hook_fn cblas_scopy;
    struct flexiblas_hook_fn cblas_sdot;
    struct flexiblas_hook_fn cblas_sdsdot;
    struct flexiblas_hook_fn cblas_sgbmv;
    struct flexiblas_hook_fn cblas_sgeadd;
    struct flexiblas_hook_fn cblas_sgemm;
    struct flexiblas_hook_fn cblas_sgemmtr;
    struct flexiblas_hook_fn cblas_sgemv;
    struct flexiblas_hook_fn cblas_sger;
    struct flexiblas_hook_fn cblas_simatcopy;
    struct flexiblas_hook_fn cblas_snrm2;
    struct flexiblas_hook_fn cblas_somatcopy;
    struct flexiblas_hook_fn cblas_srot;
    struct flexiblas_hook_fn cblas_srotg;
    struct flexiblas_hook_fn cblas_srotm;
    struct flexiblas_hook_fn cblas_srotmg;
    struct flexiblas_hook_fn cblas_ssbmv;
    struct flexiblas_hook_fn cblas_sscal;
    struct flexiblas_hook_fn cblas_sspmv;
    struct flexiblas_hook_fn cblas_sspr;
    struct flexiblas_hook_fn cblas_sspr2;
    struct flexiblas_hook_fn cblas_sswap;
    struct flexiblas_hook_fn cblas_ssymm;
    struct flexiblas_hook_fn cblas_ssymv;
    struct flexiblas_hook_fn cblas_ssyr;
    struct flexiblas_hook_fn cblas_ssyr2;
    struct flexiblas_hook_fn cblas_ssyr2k;
    struct flexiblas_hook_fn cblas_ssyrk;
    struct flexiblas_hook_fn cblas_stbmv;
    struct flexiblas_hook_fn cblas_stbsv;
    struct flexiblas_hook_fn cblas_stpmv;
    struct flexiblas_hook_fn cblas_stpsv;
    struct flexiblas_hook_fn cblas_strmm;
    struct flexiblas_hook_fn cblas_strmv;
    struct flexiblas_hook_fn cblas_strsm;
    struct flexiblas_hook_fn cblas_strsv;
    struct flexiblas_hook_fn cblas_zaxpby;
    struct flexiblas_hook_fn cblas_zaxpy;
    struct flexiblas_hook_fn cblas_zcopy;
    struct flexiblas_hook_fn cblas_zdotc_sub;
    struct flexiblas_hook_fn cblas_zdotu_sub;
    struct flexiblas_hook_fn cblas_zdrot;
    struct flexiblas_hook_fn cblas_zdscal;
    struct flexiblas_hook_fn cblas_zgbmv;
    struct flexiblas_hook_fn cblas_zgeadd;
    struct flexiblas_hook_fn cblas_zgemm;
    struct flexiblas_hook_fn cblas_zgemmtr;
    struct flexiblas_hook_fn cblas_zgemv;
    struct flexiblas_hook_fn cblas_zgerc;
    struct flexiblas_hook_fn cblas_zgeru;
    struct flexiblas_hook_fn cblas_zhbmv;
    struct flexiblas_hook_fn cblas_zhemm;
    struct flexiblas_hook_fn cblas_zhemv;
    struct flexiblas_hook_fn cblas_zher;
    struct flexiblas_hook_fn cblas_zher2;
    struct flexiblas_hook_fn cblas_zher2k;
    struct flexiblas_hook_fn cblas_zherk;
    struct flexiblas_hook_fn cblas_zhpmv;
    struct flexiblas_hook_fn cblas_zhpr;
    struct flexiblas_hook_fn cblas_zhpr2;
    struct flexiblas_hook_fn cblas_zimatcopy;
    struct flexiblas_hook_fn cblas_zomatcopy;
    struct flexiblas_hook_fn cblas_zrotg;
    struct flexiblas_hook_fn cblas_zscal;
    struct flexiblas_hook_fn cblas_zswap;
    struct flexiblas_hook_fn cblas_zsymm;
    struct flexiblas_hook_fn cblas_zsyr2k;
    struct flexiblas_hook_fn cblas_zsyrk;
    struct flexiblas_hook_fn cblas_ztbmv;
    struct flexiblas_hook_fn cblas_ztbsv;
    struct flexiblas_hook_fn cblas_ztpmv;
    struct flexiblas_hook_fn cblas_ztpsv;
    struct flexiblas_hook_fn cblas_ztrmm;
    struct flexiblas_hook_fn cblas_ztrmv;
    struct flexiblas_hook_fn cblas_ztrsm;
    struct flexiblas_hook_fn cblas_ztrsv;
    /* LAPACK */
    struct flexiblas_hook_fn cbbcsd;
    struct flexiblas_hook_fn cbdsqr;
    struct flexiblas_hook_fn cgbbrd;
    struct flexiblas_hook_fn cgbcon;
    struct flexiblas_hook_fn cgbequ;
    struct flexiblas_hook_fn cgbequb;
    struct flexiblas_hook_fn cgbrfs;
    struct flexiblas_hook_fn cgbrfsx;
    struct flexiblas_hook_fn cgbsv;
    struct flexiblas_hook_fn cgbsvx;
    struct flexiblas_hook_fn cgbsvxx;
    struct flexiblas_hook_fn cgbtf2;
    struct flexiblas_hook_fn cgbtrf;
    struct flexiblas_hook_fn cgbtrs;
    struct flexiblas_hook_fn cgebak;
    struct flexiblas_hook_fn cgebal;
    struct flexiblas_hook_fn cgebd2;
    struct flexiblas_hook_fn cgebrd;
    struct flexiblas_hook_fn cgecon;
    struct flexiblas_hook_fn cgedmd;
    struct flexiblas_hook_fn cgedmdq;
    struct flexiblas_hook_fn cgeequ;
    struct flexiblas_hook_fn cgeequb;
    struct flexiblas_hook_fn cgees;
    struct flexiblas_hook_fn cgeesx;
    struct flexiblas_hook_fn cgeev;
    struct flexiblas_hook_fn cgeevx;
    struct flexiblas_hook_fn cgegs;
    struct flexiblas_hook_fn cgegv;
    struct flexiblas_hook_fn cgehd2;
    struct flexiblas_hook_fn cgehrd;
    struct flexiblas_hook_fn cgejsv;
    struct flexiblas_hook_fn cgelq;
    struct flexiblas_hook_fn cgelq2;
    struct flexiblas_hook_fn cgelqf;
    struct flexiblas_hook_fn cgelqs;
    struct flexiblas_hook_fn cgelqt;
    struct flexiblas_hook_fn cgelqt3;
    struct flexiblas_hook_fn cgels;
    struct flexiblas_hook_fn cgelsd;
    struct flexiblas_hook_fn cgelss;
    struct flexiblas_hook_fn cgelst;
    struct flexiblas_hook_fn cgelsx;
    struct flexiblas_hook_fn cgelsy;
    struct flexiblas_hook_fn cgemlq;
    struct flexiblas_hook_fn cgemlqt;
    struct flexiblas_hook_fn cgemqr;
    struct flexiblas_hook_fn cgemqrt;
    struct flexiblas_hook_fn cgeql2;
    struct flexiblas_hook_fn cgeqlf;
    struct flexiblas_hook_fn cgeqp3;
    struct flexiblas_hook_fn cgeqp3rk;
    struct flexiblas_hook_fn cgeqpf;
    struct flexiblas_hook_fn cgeqr;
    struct flexiblas_hook_fn cgeqr2;
    struct flexiblas_hook_fn cgeqr2p;
    struct flexiblas_hook_fn cgeqrf;
    struct flexiblas_hook_fn cgeqrfp;
    struct flexiblas_hook_fn cgeqrs;
    struct flexiblas_hook_fn cgeqrt;
    struct flexiblas_hook_fn cgeqrt2;
    struct flexiblas_hook_fn cgeqrt3;
    struct flexiblas_hook_fn cgerfs;
    struct flexiblas_hook_fn cgerfsx;
    struct flexiblas_hook_fn cgerq2;
    struct flexiblas_hook_fn cgerqf;
    struct flexiblas_hook_fn cgesc2;
    struct flexiblas_hook_fn cgesdd;
    struct flexiblas_hook_fn cgesv;
    struct flexiblas_hook_fn cgesvd;
    struct flexiblas_hook_fn cgesvdq;
    struct flexiblas_hook_fn cgesvdx;
    struct flexiblas_hook_fn cgesvj;
    struct flexiblas_hook_fn cgesvx;
    struct flexiblas_hook_fn cgesvxx;
    struct flexiblas_hook_fn cgetc2;
    struct flexiblas_hook_fn cgetf2;
    struct flexiblas_hook_fn cgetrf;
    struct flexiblas_hook_fn cgetrf2;
    struct flexiblas_hook_fn cgetri;
    struct flexiblas_hook_fn cgetrs;
    struct flexiblas_hook_fn cgetsls;
    struct flexiblas_hook_fn cgetsqrhrt;
    struct flexiblas_hook_fn cggbak;
    struct flexiblas_hook_fn cggbal;
    struct flexiblas_hook_fn cgges;
    struct flexiblas_hook_fn cgges3;
    struct flexiblas_hook_fn cggesx;
    struct flexiblas_hook_fn cggev;
    struct flexiblas_hook_fn cggev3;
    struct flexiblas_hook_fn cggevx;
    struct flexiblas_hook_fn cggglm;
    struct flexiblas_hook_fn cgghd3;
    struct flexiblas_hook_fn cgghrd;
    struct flexiblas_hook_fn cgglse;
    struct flexiblas_hook_fn cggqrf;
    struct flexiblas_hook_fn cggrqf;
    struct flexiblas_hook_fn cggsvd;
    struct flexiblas_hook_fn cggsvd3;
    struct flexiblas_hook_fn cggsvp;
    struct flexiblas_hook_fn cggsvp3;
    struct flexiblas_hook_fn cgsvj0;
    struct flexiblas_hook_fn cgsvj1;
    struct flexiblas_hook_fn cgtcon;
    struct flexiblas_hook_fn cgtrfs;
    struct flexiblas_hook_fn cgtsv;
    struct flexiblas_hook_fn cgtsvx;
    struct flexiblas_hook_fn cgttrf;
    struct flexiblas_hook_fn cgttrs;
    struct flexiblas_hook_fn cgtts2;
    struct flexiblas_hook_fn chb2st_kernels;
    struct flexiblas_hook_fn chbev;
    struct flexiblas_hook_fn chbev_2stage;
    struct flexiblas_hook_fn chbevd;
    struct flexiblas_hook_fn chbevd_2stage;
    struct flexiblas_hook_fn chbevx;
    struct flexiblas_hook_fn chbevx_2stage;
    struct flexiblas_hook_fn chbgst;
    struct flexiblas_hook_fn chbgv;
    struct flexiblas_hook_fn chbgvd;
    struct flexiblas_hook_fn chbgvx;
    struct flexiblas_hook_fn chbtrd;
    struct flexiblas_hook_fn checon;
    struct flexiblas_hook_fn checon_3;
    struct flexiblas_hook_fn checon_rook;
    struct flexiblas_hook_fn cheequb;
    struct flexiblas_hook_fn cheev;
    struct flexiblas_hook_fn cheev_2stage;
    struct flexiblas_hook_fn cheevd;
    struct flexiblas_hook_fn cheevd_2stage;
    struct flexiblas_hook_fn cheevr;
    struct flexiblas_hook_fn cheevr_2stage;
    struct flexiblas_hook_fn cheevx;
    struct flexiblas_hook_fn cheevx_2stage;
    struct flexiblas_hook_fn chegs2;
    struct flexiblas_hook_fn chegst;
    struct flexiblas_hook_fn chegv;
    struct flexiblas_hook_fn chegv_2stage;
    struct flexiblas_hook_fn chegvd;
    struct flexiblas_hook_fn chegvx;
    struct flexiblas_hook_fn cherfs;
    struct flexiblas_hook_fn cherfsx;
    struct flexiblas_hook_fn chesv;
    struct flexiblas_hook_fn chesv_aa;
    struct flexiblas_hook_fn chesv_aa_2stage;
    struct flexiblas_hook_fn chesv_rk;
    struct flexiblas_hook_fn chesv_rook;
    struct flexiblas_hook_fn chesvx;
    struct flexiblas_hook_fn chesvxx;
    struct flexiblas_hook_fn cheswapr;
    struct flexiblas_hook_fn chetd2;
    struct flexiblas_hook_fn chetf2;
    struct flexiblas_hook_fn chetf2_rk;
    struct flexiblas_hook_fn chetf2_rook;
    struct flexiblas_hook_fn chetrd;
    struct flexiblas_hook_fn chetrd_2stage;
    struct flexiblas_hook_fn chetrd_hb2st;
    struct flexiblas_hook_fn chetrd_he2hb;
    struct flexiblas_hook_fn chetrf;
    struct flexiblas_hook_fn chetrf_aa;
    struct flexiblas_hook_fn chetrf_aa_2stage;
    struct flexiblas_hook_fn chetrf_rk;
    struct flexiblas_hook_fn chetrf_rook;
    struct flexiblas_hook_fn chetri;
    struct flexiblas_hook_fn chetri2;
    struct flexiblas_hook_fn chetri2x;
    struct flexiblas_hook_fn chetri_3;
    struct flexiblas_hook_fn chetri_3x;
    struct flexiblas_hook_fn chetri_rook;
    struct flexiblas_hook_fn chetrs;
    struct flexiblas_hook_fn chetrs2;
    struct flexiblas_hook_fn chetrs_3;
    struct flexiblas_hook_fn chetrs_aa;
    struct flexiblas_hook_fn chetrs_aa_2stage;
    struct flexiblas_hook_fn chetrs_rook;
    struct flexiblas_hook_fn chfrk;
    struct flexiblas_hook_fn chgeqz;
    struct flexiblas_hook_fn chla_transtype;
    struct flexiblas_hook_fn chpcon;
    struct flexiblas_hook_fn chpev;
    struct flexiblas_hook_fn chpevd;
    struct flexiblas_hook_fn chpevx;
    struct flexiblas_hook_fn chpgst;
    struct flexiblas_hook_fn chpgv;
    struct flexiblas_hook_fn chpgvd;
    struct flexiblas_hook_fn chpgvx;
    struct flexiblas_hook_fn chprfs;
    struct flexiblas_hook_fn chpsv;
    struct flexiblas_hook_fn chpsvx;
    struct flexiblas_hook_fn chptrd;
    struct flexiblas_hook_fn chptrf;
    struct flexiblas_hook_fn chptri;
    struct flexiblas_hook_fn chptrs;
    struct flexiblas_hook_fn chsein;
    struct flexiblas_hook_fn chseqr;
    struct flexiblas_hook_fn cla_gbamv;
    struct flexiblas_hook_fn cla_gbrcond_c;
    struct flexiblas_hook_fn cla_gbrcond_x;
    struct flexiblas_hook_fn cla_gbrfsx_extended;
    struct flexiblas_hook_fn cla_gbrpvgrw;
    struct flexiblas_hook_fn cla_geamv;
    struct flexiblas_hook_fn cla_gercond_c;
    struct flexiblas_hook_fn cla_gercond_x;
    struct flexiblas_hook_fn cla_gerfsx_extended;
    struct flexiblas_hook_fn cla_gerpvgrw;
    struct flexiblas_hook_fn cla_heamv;
    struct flexiblas_hook_fn cla_hercond_c;
    struct flexiblas_hook_fn cla_hercond_x;
    struct flexiblas_hook_fn cla_herfsx_extended;
    struct flexiblas_hook_fn cla_herpvgrw;
    struct flexiblas_hook_fn cla_lin_berr;
    struct flexiblas_hook_fn cla_porcond_c;
    struct flexiblas_hook_fn cla_porcond_x;
    struct flexiblas_hook_fn cla_porfsx_extended;
    struct flexiblas_hook_fn cla_porpvgrw;
    struct flexiblas_hook_fn cla_rpvgrw;
    struct flexiblas_hook_fn cla_syamv;
    struct flexiblas_hook_fn cla_syrcond_c;
    struct flexiblas_hook_fn cla_syrcond_x;
    struct flexiblas_hook_fn cla_syrfsx_extended;
    struct flexiblas_hook_fn cla_syrpvgrw;
    struct flexiblas_hook_fn cla_wwaddw;
    struct flexiblas_hook_fn clabrd;
    struct flexiblas_hook_fn clacgv;
    struct flexiblas_hook_fn clacn2;
    struct flexiblas_hook_fn clacon;
    struct flexiblas_hook_fn clacp2;
    struct flexiblas_hook_fn clacpy;
    struct flexiblas_hook_fn clacrm;
    struct flexiblas_hook_fn clacrt;
    struct flexiblas_hook_fn cladiv;
    struct flexiblas_hook_fn claed0;
    struct flexiblas_hook_fn claed7;
    struct flexiblas_hook_fn claed8;
    struct flexiblas_hook_fn claein;
    struct flexiblas_hook_fn claesy;
    struct flexiblas_hook_fn claev2;
    struct flexiblas_hook_fn clag2z;
    struct flexiblas_hook_fn clags2;
    struct flexiblas_hook_fn clagtm;
    struct flexiblas_hook_fn clahef;
    struct flexiblas_hook_fn clahef_aa;
    struct flexiblas_hook_fn clahef_rk;
    struct flexiblas_hook_fn clahef_rook;
    struct flexiblas_hook_fn clahqr;
    struct flexiblas_hook_fn clahr2;
    struct flexiblas_hook_fn clahrd;
    struct flexiblas_hook_fn claic1;
    struct flexiblas_hook_fn clals0;
    struct flexiblas_hook_fn clalsa;
    struct flexiblas_hook_fn clalsd;
    struct flexiblas_hook_fn clamswlq;
    struct flexiblas_hook_fn clamtsqr;
    struct flexiblas_hook_fn clangb;
    struct flexiblas_hook_fn clange;
    struct flexiblas_hook_fn clangt;
    struct flexiblas_hook_fn clanhb;
    struct flexiblas_hook_fn clanhe;
    struct flexiblas_hook_fn clanhf;
    struct flexiblas_hook_fn clanhp;
    struct flexiblas_hook_fn clanhs;
    struct flexiblas_hook_fn clanht;
    struct flexiblas_hook_fn clansb;
    struct flexiblas_hook_fn clansp;
    struct flexiblas_hook_fn clansy;
    struct flexiblas_hook_fn clantb;
    struct flexiblas_hook_fn clantp;
    struct flexiblas_hook_fn clantr;
    struct flexiblas_hook_fn clapll;
    struct flexiblas_hook_fn clapmr;
    struct flexiblas_hook_fn clapmt;
    struct flexiblas_hook_fn claqgb;
    struct flexiblas_hook_fn claqge;
    struct flexiblas_hook_fn claqhb;
    struct flexiblas_hook_fn claqhe;
    struct flexiblas_hook_fn claqhp;
    struct flexiblas_hook_fn claqp2;
    struct flexiblas_hook_fn claqp2rk;
    struct flexiblas_hook_fn claqp3rk;
    struct flexiblas_hook_fn claqps;
    struct flexiblas_hook_fn claqr0;
    struct flexiblas_hook_fn claqr1;
    struct flexiblas_hook_fn claqr2;
    struct flexiblas_hook_fn claqr3;
    struct flexiblas_hook_fn claqr4;
    struct flexiblas_hook_fn claqr5;
    struct flexiblas_hook_fn claqsb;
    struct flexiblas_hook_fn claqsp;
    struct flexiblas_hook_fn claqsy;
    struct flexiblas_hook_fn claqz0;
    struct flexiblas_hook_fn claqz1;
    struct flexiblas_hook_fn claqz2;
    struct flexiblas_hook_fn claqz3;
    struct flexiblas_hook_fn clar1v;
    struct flexiblas_hook_fn clar2v;
    struct flexiblas_hook_fn clarcm;
    struct flexiblas_hook_fn clarf;
    struct flexiblas_hook_fn clarf1f;
    struct flexiblas_hook_fn clarf1l;
    struct flexiblas_hook_fn clarfb;
    struct flexiblas_hook_fn clarfb_gett;
    struct flexiblas_hook_fn clarfg;
    struct flexiblas_hook_fn clarfgp;
    struct flexiblas_hook_fn clarft;
    struct flexiblas_hook_fn clarfx;
    struct flexiblas_hook_fn clarfy;
    struct flexiblas_hook_fn clargv;
    struct flexiblas_hook_fn clarnv;
    struct flexiblas_hook_fn clarrv;
    struct flexiblas_hook_fn clarscl2;
    struct flexiblas_hook_fn clartg;
    struct flexiblas_hook_fn clartv;
    struct flexiblas_hook_fn clarz;
    struct flexiblas_hook_fn clarzb;
    struct flexiblas_hook_fn clarzt;
    struct flexiblas_hook_fn clascl;
    struct flexiblas_hook_fn clascl2;
    struct flexiblas_hook_fn claset;
    struct flexiblas_hook_fn clasr;
    struct flexiblas_hook_fn classq;
    struct flexiblas_hook_fn claswlq;
    struct flexiblas_hook_fn claswp;
    struct flexiblas_hook_fn clasyf;
    struct flexiblas_hook_fn clasyf_aa;
    struct flexiblas_hook_fn clasyf_rk;
    struct flexiblas_hook_fn clasyf_rook;
    struct flexiblas_hook_fn clatbs;
    struct flexiblas_hook_fn clatdf;
    struct flexiblas_hook_fn clatps;
    struct flexiblas_hook_fn clatrd;
    struct flexiblas_hook_fn clatrs;
    struct flexiblas_hook_fn clatrs3;
    struct flexiblas_hook_fn clatrz;
    struct flexiblas_hook_fn clatsqr;
    struct flexiblas_hook_fn clatzm;
    struct flexiblas_hook_fn claunhr_col_getrfnp;
    struct flexiblas_hook_fn claunhr_col_getrfnp2;
    struct flexiblas_hook_fn clauu2;
    struct flexiblas_hook_fn clauum;
    struct flexiblas_hook_fn cpbcon;
    struct flexiblas_hook_fn cpbequ;
    struct flexiblas_hook_fn cpbrfs;
    struct flexiblas_hook_fn cpbstf;
    struct flexiblas_hook_fn cpbsv;
    struct flexiblas_hook_fn cpbsvx;
    struct flexiblas_hook_fn cpbtf2;
    struct flexiblas_hook_fn cpbtrf;
    struct flexiblas_hook_fn cpbtrs;
    struct flexiblas_hook_fn cpftrf;
    struct flexiblas_hook_fn cpftri;
    struct flexiblas_hook_fn cpftrs;
    struct flexiblas_hook_fn cpocon;
    struct flexiblas_hook_fn cpoequ;
    struct flexiblas_hook_fn cpoequb;
    struct flexiblas_hook_fn cporfs;
    struct flexiblas_hook_fn cporfsx;
    struct flexiblas_hook_fn cposv;
    struct flexiblas_hook_fn cposvx;
    struct flexiblas_hook_fn cposvxx;
    struct flexiblas_hook_fn cpotf2;
    struct flexiblas_hook_fn cpotrf;
    struct flexiblas_hook_fn cpotrf2;
    struct flexiblas_hook_fn cpotri;
    struct flexiblas_hook_fn cpotrs;
    struct flexiblas_hook_fn cppcon;
    struct flexiblas_hook_fn cppequ;
    struct flexiblas_hook_fn cpprfs;
    struct flexiblas_hook_fn cppsv;
    struct flexiblas_hook_fn cppsvx;
    struct flexiblas_hook_fn cpptrf;
    struct flexiblas_hook_fn cpptri;
    struct flexiblas_hook_fn cpptrs;
    struct flexiblas_hook_fn cpstf2;
    struct flexiblas_hook_fn cpstrf;
    struct flexiblas_hook_fn cptcon;
    struct flexiblas_hook_fn cpteqr;
    struct flexiblas_hook_fn cptrfs;
    struct flexiblas_hook_fn cptsv;
    struct flexiblas_hook_fn cptsvx;
    struct flexiblas_hook_fn cpttrf;
    struct flexiblas_hook_fn cpttrs;
    struct flexiblas_hook_fn cptts2;
    struct flexiblas_hook_fn crot;
    struct flexiblas_hook_fn crscl;
    struct flexiblas_hook_fn cspcon;
    struct flexiblas_hook_fn cspmv;
    struct flexiblas_hook_fn cspr;
    struct flexiblas_hook_fn csprfs;
    struct flexiblas_hook_fn cspsv;
    struct flexiblas_hook_fn cspsvx;
    struct flexiblas_hook_fn csptrf;
    struct flexiblas_hook_fn csptri;
    struct flexiblas_hook_fn csptrs;
    struct flexiblas_hook_fn csrscl;
    struct flexiblas_hook_fn cstedc;
    struct flexiblas_hook_fn cstegr;
    struct flexiblas_hook_fn cstein;
    struct flexiblas_hook_fn cstemr;
    struct flexiblas_hook_fn csteqr;
    struct flexiblas_hook_fn csycon;
    struct flexiblas_hook_fn csycon_3;
    struct flexiblas_hook_fn csycon_rook;
    struct flexiblas_hook_fn csyconv;
    struct flexiblas_hook_fn csyconvf;
    struct flexiblas_hook_fn csyconvf_rook;
    struct flexiblas_hook_fn csyequb;
    struct flexiblas_hook_fn csymv;
    struct flexiblas_hook_fn csyr;
    struct flexiblas_hook_fn csyrfs;
    struct flexiblas_hook_fn csyrfsx;
    struct flexiblas_hook_fn csysv;
    struct flexiblas_hook_fn csysv_aa;
    struct flexiblas_hook_fn csysv_aa_2stage;
    struct flexiblas_hook_fn csysv_rk;
    struct flexiblas_hook_fn csysv_rook;
    struct flexiblas_hook_fn csysvx;
    struct flexiblas_hook_fn csysvxx;
    struct flexiblas_hook_fn csyswapr;
    struct flexiblas_hook_fn csytf2;
    struct flexiblas_hook_fn csytf2_rk;
    struct flexiblas_hook_fn csytf2_rook;
    struct flexiblas_hook_fn csytrf;
    struct flexiblas_hook_fn csytrf_aa;
    struct flexiblas_hook_fn csytrf_aa_2stage;
    struct flexiblas_hook_fn csytrf_rk;
    struct flexiblas_hook_fn csytrf_rook;
    struct flexiblas_hook_fn csytri;
    struct flexiblas_hook_fn csytri2;
    struct flexiblas_hook_fn csytri2x;
    struct flexiblas_hook_fn csytri_3;
    struct flexiblas_hook_fn csytri_3x;
    struct flexiblas_hook_fn csytri_rook;
    struct flexiblas_hook_fn csytrs;
    struct flexiblas_hook_fn csytrs2;
    struct flexiblas_hook_fn csytrs_3;
    struct flexiblas_hook_fn csytrs_aa;
    struct flexiblas_hook_fn csytrs_aa_2stage;
    struct flexiblas_hook_fn csytrs_rook;
    struct flexiblas_hook_fn ctbcon;
    struct flexiblas_hook_fn ctbrfs;
    struct flexiblas_hook_fn ctbtrs;
    struct flexiblas_hook_fn ctfsm;
    struct flexiblas_hook_fn ctftri;
    struct flexiblas_hook_fn ctfttp;
    struct flexiblas_hook_fn ctfttr;
    struct flexiblas_hook_fn ctgevc;
    struct flexiblas_hook_fn ctgex2;
    struct flexiblas_hook_fn ctgexc;
    struct flexiblas_hook_fn ctgsen;
    struct flexiblas_hook_fn ctgsja;
    struct flexiblas_hook_fn ctgsna;
    struct flexiblas_hook_fn ctgsy2;
    struct flexiblas_hook_fn ctgsyl;
    struct flexiblas_hook_fn ctpcon;
    struct flexiblas_hook_fn ctplqt;
    struct flexiblas_hook_fn ctplqt2;
    struct flexiblas_hook_fn ctpmlqt;
    struct flexiblas_hook_fn ctpmqrt;
    struct flexiblas_hook_fn ctpqrt;
    struct flexiblas_hook_fn ctpqrt2;
    struct flexiblas_hook_fn ctprfb;
    struct flexiblas_hook_fn ctprfs;
    struct flexiblas_hook_fn ctptri;
    struct flexiblas_hook_fn ctptrs;
    struct flexiblas_hook_fn ctpttf;
    struct flexiblas_hook_fn ctpttr;
    struct flexiblas_hook_fn ctrcon;
    struct flexiblas_hook_fn ctrevc;
    struct flexiblas_hook_fn ctrevc3;
    struct flexiblas_hook_fn ctrexc;
    struct flexiblas_hook_fn ctrrfs;
    struct flexiblas_hook_fn ctrsen;
    struct flexiblas_hook_fn ctrsna;
    struct flexiblas_hook_fn ctrsyl;
    struct flexiblas_hook_fn ctrsyl3;
    struct flexiblas_hook_fn ctrti2;
    struct flexiblas_hook_fn ctrtri;
    struct flexiblas_hook_fn ctrtrs;
    struct flexiblas_hook_fn ctrttf;
    struct flexiblas_hook_fn ctrttp;
    struct flexiblas_hook_fn ctzrqf;
    struct flexiblas_hook_fn ctzrzf;
    struct flexiblas_hook_fn cunbdb;
    struct flexiblas_hook_fn cunbdb1;
    struct flexiblas_hook_fn cunbdb2;
    struct flexiblas_hook_fn cunbdb3;
    struct flexiblas_hook_fn cunbdb4;
    struct flexiblas_hook_fn cunbdb5;
    struct flexiblas_hook_fn cunbdb6;
    struct flexiblas_hook_fn cuncsd;
    struct flexiblas_hook_fn cuncsd2by1;
    struct flexiblas_hook_fn cung2l;
    struct flexiblas_hook_fn cung2r;
    struct flexiblas_hook_fn cungbr;
    struct flexiblas_hook_fn cunghr;
    struct flexiblas_hook_fn cungl2;
    struct flexiblas_hook_fn cunglq;
    struct flexiblas_hook_fn cungql;
    struct flexiblas_hook_fn cungqr;
    struct flexiblas_hook_fn cungr2;
    struct flexiblas_hook_fn cungrq;
    struct flexiblas_hook_fn cungtr;
    struct flexiblas_hook_fn cungtsqr;
    struct flexiblas_hook_fn cungtsqr_row;
    struct flexiblas_hook_fn cunhr_col;
    struct flexiblas_hook_fn cunm22;
    struct flexiblas_hook_fn cunm2l;
    struct flexiblas_hook_fn cunm2r;
    struct flexiblas_hook_fn cunmbr;
    struct flexiblas_hook_fn cunmhr;
    struct flexiblas_hook_fn cunml2;
    struct flexiblas_hook_fn cunmlq;
    struct flexiblas_hook_fn cunmql;
    struct flexiblas_hook_fn cunmqr;
    struct flexiblas_hook_fn cunmr2;
    struct flexiblas_hook_fn cunmr3;
    struct flexiblas_hook_fn cunmrq;
    struct flexiblas_hook_fn cunmrz;
    struct flexiblas_hook_fn cunmtr;
    struct flexiblas_hook_fn cupgtr;
    struct flexiblas_hook_fn cupmtr;
    struct flexiblas_hook_fn dbbcsd;
    struct flexiblas_hook_fn dbdsdc;
    struct flexiblas_hook_fn dbdsqr;
    struct flexiblas_hook_fn dbdsvdx;
    struct flexiblas_hook_fn dcombssq;
    struct flexiblas_hook_fn ddisna;
    struct flexiblas_hook_fn dgbbrd;
    struct flexiblas_hook_fn dgbcon;
    struct flexiblas_hook_fn dgbequ;
    struct flexiblas_hook_fn dgbequb;
    struct flexiblas_hook_fn dgbrfs;
    struct flexiblas_hook_fn dgbrfsx;
    struct flexiblas_hook_fn dgbsv;
    struct flexiblas_hook_fn dgbsvx;
    struct flexiblas_hook_fn dgbsvxx;
    struct flexiblas_hook_fn dgbtf2;
    struct flexiblas_hook_fn dgbtrf;
    struct flexiblas_hook_fn dgbtrs;
    struct flexiblas_hook_fn dgebak;
    struct flexiblas_hook_fn dgebal;
    struct flexiblas_hook_fn dgebd2;
    struct flexiblas_hook_fn dgebrd;
    struct flexiblas_hook_fn dgecon;
    struct flexiblas_hook_fn dgedmd;
    struct flexiblas_hook_fn dgedmdq;
    struct flexiblas_hook_fn dgeequ;
    struct flexiblas_hook_fn dgeequb;
    struct flexiblas_hook_fn dgees;
    struct flexiblas_hook_fn dgeesx;
    struct flexiblas_hook_fn dgeev;
    struct flexiblas_hook_fn dgeevx;
    struct flexiblas_hook_fn dgegs;
    struct flexiblas_hook_fn dgegv;
    struct flexiblas_hook_fn dgehd2;
    struct flexiblas_hook_fn dgehrd;
    struct flexiblas_hook_fn dgejsv;
    struct flexiblas_hook_fn dgelq;
    struct flexiblas_hook_fn dgelq2;
    struct flexiblas_hook_fn dgelqf;
    struct flexiblas_hook_fn dgelqs;
    struct flexiblas_hook_fn dgelqt;
    struct flexiblas_hook_fn dgelqt3;
    struct flexiblas_hook_fn dgels;
    struct flexiblas_hook_fn dgelsd;
    struct flexiblas_hook_fn dgelss;
    struct flexiblas_hook_fn dgelst;
    struct flexiblas_hook_fn dgelsx;
    struct flexiblas_hook_fn dgelsy;
    struct flexiblas_hook_fn dgemlq;
    struct flexiblas_hook_fn dgemlqt;
    struct flexiblas_hook_fn dgemqr;
    struct flexiblas_hook_fn dgemqrt;
    struct flexiblas_hook_fn dgeql2;
    struct flexiblas_hook_fn dgeqlf;
    struct flexiblas_hook_fn dgeqp3;
    struct flexiblas_hook_fn dgeqp3rk;
    struct flexiblas_hook_fn dgeqpf;
    struct flexiblas_hook_fn dgeqr;
    struct flexiblas_hook_fn dgeqr2;
    struct flexiblas_hook_fn dgeqr2p;
    struct flexiblas_hook_fn dgeqrf;
    struct flexiblas_hook_fn dgeqrfp;
    struct flexiblas_hook_fn dgeqrs;
    struct flexiblas_hook_fn dgeqrt;
    struct flexiblas_hook_fn dgeqrt2;
    struct flexiblas_hook_fn dgeqrt3;
    struct flexiblas_hook_fn dgerfs;
    struct flexiblas_hook_fn dgerfsx;
    struct flexiblas_hook_fn dgerq2;
    struct flexiblas_hook_fn dgerqf;
    struct flexiblas_hook_fn dgesc2;
    struct flexiblas_hook_fn dgesdd;
    struct flexiblas_hook_fn dgesv;
    struct flexiblas_hook_fn dgesvd;
    struct flexiblas_hook_fn dgesvdq;
    struct flexiblas_hook_fn dgesvdx;
    struct flexiblas_hook_fn dgesvj;
    struct flexiblas_hook_fn dgesvx;
    struct flexiblas_hook_fn dgesvxx;
    struct flexiblas_hook_fn dgetc2;
    struct flexiblas_hook_fn dgetf2;
    struct flexiblas_hook_fn dgetrf;
    struct flexiblas_hook_fn dgetrf2;
    struct flexiblas_hook_fn dgetri;
    struct flexiblas_hook_fn dgetrs;
    struct flexiblas_hook_fn dgetsls;
    struct flexiblas_hook_fn dgetsqrhrt;
    struct flexiblas_hook_fn dggbak;
    struct flexiblas_hook_fn dggbal;
    struct flexiblas_hook_fn dgges;
    struct flexiblas_hook_fn dgges3;
    struct flexiblas_hook_fn dggesx;
    struct flexiblas_hook_fn dggev;
    struct flexiblas_hook_fn dggev3;
    struct flexiblas_hook_fn dggevx;
    struct flexiblas_hook_fn dggglm;
    struct flexiblas_hook_fn dgghd3;
    struct flexiblas_hook_fn dgghrd;
    struct flexiblas_hook_fn dgglse;
    struct flexiblas_hook_fn dggqrf;
    struct flexiblas_hook_fn dggrqf;
    struct flexiblas_hook_fn dggsvd;
    struct flexiblas_hook_fn dggsvd3;
    struct flexiblas_hook_fn dggsvp;
    struct flexiblas_hook_fn dggsvp3;
    struct flexiblas_hook_fn dgsvj0;
    struct flexiblas_hook_fn dgsvj1;
    struct flexiblas_hook_fn dgtcon;
    struct flexiblas_hook_fn dgtrfs;
    struct flexiblas_hook_fn dgtsv;
    struct flexiblas_hook_fn dgtsvx;
    struct flexiblas_hook_fn dgttrf;
    struct flexiblas_hook_fn dgttrs;
    struct flexiblas_hook_fn dgtts2;
    struct flexiblas_hook_fn dhgeqz;
    struct flexiblas_hook_fn dhsein;
    struct flexiblas_hook_fn dhseqr;
    struct flexiblas_hook_fn disnan;
    struct flexiblas_hook_fn dla_gbamv;
    struct flexiblas_hook_fn dla_gbrcond;
    struct flexiblas_hook_fn dla_gbrfsx_extended;
    struct flexiblas_hook_fn dla_gbrpvgrw;
    struct flexiblas_hook_fn dla_geamv;
    struct flexiblas_hook_fn dla_gercond;
    struct flexiblas_hook_fn dla_gerfsx_extended;
    struct flexiblas_hook_fn dla_gerpvgrw;
    struct flexiblas_hook_fn dla_lin_berr;
    struct flexiblas_hook_fn dla_porcond;
    struct flexiblas_hook_fn dla_porfsx_extended;
    struct flexiblas_hook_fn dla_porpvgrw;
    struct flexiblas_hook_fn dla_rpvgrw;
    struct flexiblas_hook_fn dla_syamv;
    struct flexiblas_hook_fn dla_syrcond;
    struct flexiblas_hook_fn dla_syrfsx_extended;
    struct flexiblas_hook_fn dla_syrpvgrw;
    struct flexiblas_hook_fn dla_wwaddw;
    struct flexiblas_hook_fn dlabad;
    struct flexiblas_hook_fn dlabrd;
    struct flexiblas_hook_fn dlacn2;
    struct flexiblas_hook_fn dlacon;
    struct flexiblas_hook_fn dlacpy;
    struct flexiblas_hook_fn dladiv;
    struct flexiblas_hook_fn dladiv1;
    struct flexiblas_hook_fn dladiv2;
    struct flexiblas_hook_fn dlae2;
    struct flexiblas_hook_fn dlaebz;
    struct flexiblas_hook_fn dlaed0;
    struct flexiblas_hook_fn dlaed1;
    struct flexiblas_hook_fn dlaed2;
    struct flexiblas_hook_fn dlaed3;
    struct flexiblas_hook_fn dlaed4;
    struct flexiblas_hook_fn dlaed5;
    struct flexiblas_hook_fn dlaed6;
    struct flexiblas_hook_fn dlaed7;
    struct flexiblas_hook_fn dlaed8;
    struct flexiblas_hook_fn dlaed9;
    struct flexiblas_hook_fn dlaeda;
    struct flexiblas_hook_fn dlaein;
    struct flexiblas_hook_fn dlaev2;
    struct flexiblas_hook_fn dlaexc;
    struct flexiblas_hook_fn dlag2;
    struct flexiblas_hook_fn dlag2s;
    struct flexiblas_hook_fn dlags2;
    struct flexiblas_hook_fn dlagtf;
    struct flexiblas_hook_fn dlagtm;
    struct flexiblas_hook_fn dlagts;
    struct flexiblas_hook_fn dlagv2;
    struct flexiblas_hook_fn dlahqr;
    struct flexiblas_hook_fn dlahr2;
    struct flexiblas_hook_fn dlahrd;
    struct flexiblas_hook_fn dlaic1;
    struct flexiblas_hook_fn dlaisnan;
    struct flexiblas_hook_fn dlaln2;
    struct flexiblas_hook_fn dlals0;
    struct flexiblas_hook_fn dlalsa;
    struct flexiblas_hook_fn dlalsd;
    struct flexiblas_hook_fn dlamc3;
    struct flexiblas_hook_fn dlamch;
    struct flexiblas_hook_fn dlamrg;
    struct flexiblas_hook_fn dlamswlq;
    struct flexiblas_hook_fn dlamtsqr;
    struct flexiblas_hook_fn dlaneg;
    struct flexiblas_hook_fn dlangb;
    struct flexiblas_hook_fn dlange;
    struct flexiblas_hook_fn dlangt;
    struct flexiblas_hook_fn dlanhs;
    struct flexiblas_hook_fn dlansb;
    struct flexiblas_hook_fn dlansf;
    struct flexiblas_hook_fn dlansp;
    struct flexiblas_hook_fn dlanst;
    struct flexiblas_hook_fn dlansy;
    struct flexiblas_hook_fn dlantb;
    struct flexiblas_hook_fn dlantp;
    struct flexiblas_hook_fn dlantr;
    struct flexiblas_hook_fn dlanv2;
    struct flexiblas_hook_fn dlaorhr_col_getrfnp;
    struct flexiblas_hook_fn dlaorhr_col_getrfnp2;
    struct flexiblas_hook_fn dlapll;
    struct flexiblas_hook_fn dlapmr;
    struct flexiblas_hook_fn dlapmt;
    struct flexiblas_hook_fn dlapy2;
    struct flexiblas_hook_fn dlapy3;
    struct flexiblas_hook_fn dlaqgb;
    struct flexiblas_hook_fn dlaqge;
    struct flexiblas_hook_fn dlaqp2;
    struct flexiblas_hook_fn dlaqp2rk;
    struct flexiblas_hook_fn dlaqp3rk;
    struct flexiblas_hook_fn dlaqps;
    struct flexiblas_hook_fn dlaqr0;
    struct flexiblas_hook_fn dlaqr1;
    struct flexiblas_hook_fn dlaqr2;
    struct flexiblas_hook_fn dlaqr3;
    struct flexiblas_hook_fn dlaqr4;
    struct flexiblas_hook_fn dlaqr5;
    struct flexiblas_hook_fn dlaqsb;
    struct flexiblas_hook_fn dlaqsp;
    struct flexiblas_hook_fn dlaqsy;
    struct flexiblas_hook_fn dlaqtr;
    struct flexiblas_hook_fn dlaqz0;
    struct flexiblas_hook_fn dlaqz1;
    struct flexiblas_hook_fn dlaqz2;
    struct flexiblas_hook_fn dlaqz3;
    struct flexiblas_hook_fn dlaqz4;
    struct flexiblas_hook_fn dlar1v;
    struct flexiblas_hook_fn dlar2v;
    struct flexiblas_hook_fn dlarf;
    struct flexiblas_hook_fn dlarf1f;
    struct flexiblas_hook_fn dlarf1l;
    struct flexiblas_hook_fn dlarfb;
    struct flexiblas_hook_fn dlarfb_gett;
    struct flexiblas_hook_fn dlarfg;
    struct flexiblas_hook_fn dlarfgp;
    struct flexiblas_hook_fn dlarft;
    struct flexiblas_hook_fn dlarfx;
    struct flexiblas_hook_fn dlarfy;
    struct flexiblas_hook_fn dlargv;
    struct flexiblas_hook_fn dlarmm;
    struct flexiblas_hook_fn dlarnv;
    struct flexiblas_hook_fn dlarra;
    struct flexiblas_hook_fn dlarrb;
    struct flexiblas_hook_fn dlarrc;
    struct flexiblas_hook_fn dlarrd;
    struct flexiblas_hook_fn dlarre;
    struct flexiblas_hook_fn dlarrf;
    struct flexiblas_hook_fn dlarrj;
    struct flexiblas_hook_fn dlarrk;
    struct flexiblas_hook_fn dlarrr;
    struct flexiblas_hook_fn dlarrv;
    struct flexiblas_hook_fn dlarscl2;
    struct flexiblas_hook_fn dlartg;
    struct flexiblas_hook_fn dlartgp;
    struct flexiblas_hook_fn dlartgs;
    struct flexiblas_hook_fn dlartv;
    struct flexiblas_hook_fn dlaruv;
    struct flexiblas_hook_fn dlarz;
    struct flexiblas_hook_fn dlarzb;
    struct flexiblas_hook_fn dlarzt;
    struct flexiblas_hook_fn dlas2;
    struct flexiblas_hook_fn dlascl;
    struct flexiblas_hook_fn dlascl2;
    struct flexiblas_hook_fn dlasd0;
    struct flexiblas_hook_fn dlasd1;
    struct flexiblas_hook_fn dlasd2;
    struct flexiblas_hook_fn dlasd3;
    struct flexiblas_hook_fn dlasd4;
    struct flexiblas_hook_fn dlasd5;
    struct flexiblas_hook_fn dlasd6;
    struct flexiblas_hook_fn dlasd7;
    struct flexiblas_hook_fn dlasd8;
    struct flexiblas_hook_fn dlasda;
    struct flexiblas_hook_fn dlasdq;
    struct flexiblas_hook_fn dlasdt;
    struct flexiblas_hook_fn dlaset;
    struct flexiblas_hook_fn dlasq1;
    struct flexiblas_hook_fn dlasq2;
    struct flexiblas_hook_fn dlasq3;
    struct flexiblas_hook_fn dlasq4;
    struct flexiblas_hook_fn dlasq5;
    struct flexiblas_hook_fn dlasq6;
    struct flexiblas_hook_fn dlasr;
    struct flexiblas_hook_fn dlasrt;
    struct flexiblas_hook_fn dlassq;
    struct flexiblas_hook_fn dlasv2;
    struct flexiblas_hook_fn dlaswlq;
    struct flexiblas_hook_fn dlaswp;
    struct flexiblas_hook_fn dlasy2;
    struct flexiblas_hook_fn dlasyf;
    struct flexiblas_hook_fn dlasyf_aa;
    struct flexiblas_hook_fn dlasyf_rk;
    struct flexiblas_hook_fn dlasyf_rook;
    struct flexiblas_hook_fn dlat2s;
    struct flexiblas_hook_fn dlatbs;
    struct flexiblas_hook_fn dlatdf;
    struct flexiblas_hook_fn dlatps;
    struct flexiblas_hook_fn dlatrd;
    struct flexiblas_hook_fn dlatrs;
    struct flexiblas_hook_fn dlatrs3;
    struct flexiblas_hook_fn dlatrz;
    struct flexiblas_hook_fn dlatsqr;
    struct flexiblas_hook_fn dlatzm;
    struct flexiblas_hook_fn dlauu2;
    struct flexiblas_hook_fn dlauum;
    struct flexiblas_hook_fn dopgtr;
    struct flexiblas_hook_fn dopmtr;
    struct flexiblas_hook_fn dorbdb;
    struct flexiblas_hook_fn dorbdb1;
    struct flexiblas_hook_fn dorbdb2;
    struct flexiblas_hook_fn dorbdb3;
    struct flexiblas_hook_fn dorbdb4;
    struct flexiblas_hook_fn dorbdb5;
    struct flexiblas_hook_fn dorbdb6;
    struct flexiblas_hook_fn dorcsd;
    struct flexiblas_hook_fn dorcsd2by1;
    struct flexiblas_hook_fn dorg2l;
    struct flexiblas_hook_fn dorg2r;
    struct flexiblas_hook_fn dorgbr;
    struct flexiblas_hook_fn dorghr;
    struct flexiblas_hook_fn dorgl2;
    struct flexiblas_hook_fn dorglq;
    struct flexiblas_hook_fn dorgql;
    struct flexiblas_hook_fn dorgqr;
    struct flexiblas_hook_fn dorgr2;
    struct flexiblas_hook_fn dorgrq;
    struct flexiblas_hook_fn dorgtr;
    struct flexiblas_hook_fn dorgtsqr;
    struct flexiblas_hook_fn dorgtsqr_row;
    struct flexiblas_hook_fn dorhr_col;
    struct flexiblas_hook_fn dorm22;
    struct flexiblas_hook_fn dorm2l;
    struct flexiblas_hook_fn dorm2r;
    struct flexiblas_hook_fn dormbr;
    struct flexiblas_hook_fn dormhr;
    struct flexiblas_hook_fn dorml2;
    struct flexiblas_hook_fn dormlq;
    struct flexiblas_hook_fn dormql;
    struct flexiblas_hook_fn dormqr;
    struct flexiblas_hook_fn dormr2;
    struct flexiblas_hook_fn dormr3;
    struct flexiblas_hook_fn dormrq;
    struct flexiblas_hook_fn dormrz;
    struct flexiblas_hook_fn dormtr;
    struct flexiblas_hook_fn dpbcon;
    struct flexiblas_hook_fn dpbequ;
    struct flexiblas_hook_fn dpbrfs;
    struct flexiblas_hook_fn dpbstf;
    struct flexiblas_hook_fn dpbsv;
    struct flexiblas_hook_fn dpbsvx;
    struct flexiblas_hook_fn dpbtf2;
    struct flexiblas_hook_fn dpbtrf;
    struct flexiblas_hook_fn dpbtrs;
    struct flexiblas_hook_fn dpftrf;
    struct flexiblas_hook_fn dpftri;
    struct flexiblas_hook_fn dpftrs;
    struct flexiblas_hook_fn dpocon;
    struct flexiblas_hook_fn dpoequ;
    struct flexiblas_hook_fn dpoequb;
    struct flexiblas_hook_fn dporfs;
    struct flexiblas_hook_fn dporfsx;
    struct flexiblas_hook_fn dposv;
    struct flexiblas_hook_fn dposvx;
    struct flexiblas_hook_fn dposvxx;
    struct flexiblas_hook_fn dpotf2;
    struct flexiblas_hook_fn dpotrf;
    struct flexiblas_hook_fn dpotrf2;
    struct flexiblas_hook_fn dpotri;
    struct flexiblas_hook_fn dpotrs;
    struct flexiblas_hook_fn dppcon;
    struct flexiblas_hook_fn dppequ;
    struct flexiblas_hook_fn dpprfs;
    struct flexiblas_hook_fn dppsv;
    struct flexiblas_hook_fn dppsvx;
    struct flexiblas_hook_fn dpptrf;
    struct flexiblas_hook_fn dpptri;
    struct flexiblas_hook_fn dpptrs;
    struct flexiblas_hook_fn dpstf2;
    struct flexiblas_hook_fn dpstrf;
    struct flexiblas_hook_fn dptcon;
    struct flexiblas_hook_fn dpteqr;
    struct flexiblas_hook_fn dptrfs;
    struct flexiblas_hook_fn dptsv;
    struct flexiblas_hook_fn dptsvx;
    struct flexiblas_hook_fn dpttrf;
    struct flexiblas_hook_fn dpttrs;
    struct flexiblas_hook_fn dptts2;
    struct flexiblas_hook_fn droundup_lwork;
    struct flexiblas_hook_fn drscl;
    struct flexiblas_hook_fn dsb2st_kernels;
    struct flexiblas_hook_fn dsbev;
    struct flexiblas_hook_fn dsbev_2stage;
    struct flexiblas_hook_fn dsbevd;
    struct flexiblas_hook_fn dsbevd_2stage;
    struct flexiblas_hook_fn dsbevx;
    struct flexiblas_hook_fn dsbevx_2stage;
    struct flexiblas_hook_fn dsbgst;
    struct flexiblas_hook_fn dsbgv;
    struct flexiblas_hook_fn dsbgvd;
    struct flexiblas_hook_fn dsbgvx;
    struct flexiblas_hook_fn dsbtrd;
    struct flexiblas_hook_fn dsecnd;
    struct flexiblas_hook_fn dsfrk;
    struct flexiblas_hook_fn dsgesv;
    struct flexiblas_hook_fn dspcon;
    struct flexiblas_hook_fn dspev;
    struct flexiblas_hook_fn dspevd;
    struct flexiblas_hook_fn dspevx;
    struct flexiblas_hook_fn dspgst;
    struct flexiblas_hook_fn dspgv;
    struct flexiblas_hook_fn dspgvd;
    struct flexiblas_hook_fn dspgvx;
    struct flexiblas_hook_fn dsposv;
    struct flexiblas_hook_fn dsprfs;
    struct flexiblas_hook_fn dspsv;
    struct flexiblas_hook_fn dspsvx;
    struct flexiblas_hook_fn dsptrd;
    struct flexiblas_hook_fn dsptrf;
    struct flexiblas_hook_fn dsptri;
    struct flexiblas_hook_fn dsptrs;
    struct flexiblas_hook_fn dstebz;
    struct flexiblas_hook_fn dstedc;
    struct flexiblas_hook_fn dstegr;
    struct flexiblas_hook_fn dstein;
    struct flexiblas_hook_fn dstemr;
    struct flexiblas_hook_fn dsteqr;
    struct flexiblas_hook_fn dsterf;
    struct flexiblas_hook_fn dstev;
    struct flexiblas_hook_fn dstevd;
    struct flexiblas_hook_fn dstevr;
    struct flexiblas_hook_fn dstevx;
    struct flexiblas_hook_fn dsycon;
    struct flexiblas_hook_fn dsycon_3;
    struct flexiblas_hook_fn dsycon_rook;
    struct flexiblas_hook_fn dsyconv;
    struct flexiblas_hook_fn dsyconvf;
    struct flexiblas_hook_fn dsyconvf_rook;
    struct flexiblas_hook_fn dsyequb;
    struct flexiblas_hook_fn dsyev;
    struct flexiblas_hook_fn dsyev_2stage;
    struct flexiblas_hook_fn dsyevd;
    struct flexiblas_hook_fn dsyevd_2stage;
    struct flexiblas_hook_fn dsyevr;
    struct flexiblas_hook_fn dsyevr_2stage;
    struct flexiblas_hook_fn dsyevx;
    struct flexiblas_hook_fn dsyevx_2stage;
    struct flexiblas_hook_fn dsygs2;
    struct flexiblas_hook_fn dsygst;
    struct flexiblas_hook_fn dsygv;
    struct flexiblas_hook_fn dsygv_2stage;
    struct flexiblas_hook_fn dsygvd;
    struct flexiblas_hook_fn dsygvx;
    struct flexiblas_hook_fn dsyrfs;
    struct flexiblas_hook_fn dsyrfsx;
    struct flexiblas_hook_fn dsysv;
    struct flexiblas_hook_fn dsysv_aa;
    struct flexiblas_hook_fn dsysv_aa_2stage;
    struct flexiblas_hook_fn dsysv_rk;
    struct flexiblas_hook_fn dsysv_rook;
    struct flexiblas_hook_fn dsysvx;
    struct flexiblas_hook_fn dsysvxx;
    struct flexiblas_hook_fn dsyswapr;
    struct flexiblas_hook_fn dsytd2;
    struct flexiblas_hook_fn dsytf2;
    struct flexiblas_hook_fn dsytf2_rk;
    struct flexiblas_hook_fn dsytf2_rook;
    struct flexiblas_hook_fn dsytrd;
    struct flexiblas_hook_fn dsytrd_2stage;
    struct flexiblas_hook_fn dsytrd_sb2st;
    struct flexiblas_hook_fn dsytrd_sy2sb;
    struct flexiblas_hook_fn dsytrf;
    struct flexiblas_hook_fn dsytrf_aa;
    struct flexiblas_hook_fn dsytrf_aa_2stage;
    struct flexiblas_hook_fn dsytrf_rk;
    struct flexiblas_hook_fn dsytrf_rook;
    struct flexiblas_hook_fn dsytri;
    struct flexiblas_hook_fn dsytri2;
    struct flexiblas_hook_fn dsytri2x;
    struct flexiblas_hook_fn dsytri_3;
    struct flexiblas_hook_fn dsytri_3x;
    struct flexiblas_hook_fn dsytri_rook;
    struct flexiblas_hook_fn dsytrs;
    struct flexiblas_hook_fn dsytrs2;
    struct flexiblas_hook_fn dsytrs_3;
    struct flexiblas_hook_fn dsytrs_aa;
    struct flexiblas_hook_fn dsytrs_aa_2stage;
    struct flexiblas_hook_fn dsytrs_rook;
    struct flexiblas_hook_fn dtbcon;
    struct flexiblas_hook_fn dtbrfs;
    struct flexiblas_hook_fn dtbtrs;
    struct flexiblas_hook_fn dtfsm;
    struct flexiblas_hook_fn dtftri;
    struct flexiblas_hook_fn dtfttp;
    struct flexiblas_hook_fn dtfttr;
    struct flexiblas_hook_fn dtgevc;
    struct flexiblas_hook_fn dtgex2;
    struct flexiblas_hook_fn dtgexc;
    struct flexiblas_hook_fn dtgsen;
    struct flexiblas_hook_fn dtgsja;
    struct flexiblas_hook_fn dtgsna;
    struct flexiblas_hook_fn dtgsy2;
    struct flexiblas_hook_fn dtgsyl;
    struct flexiblas_hook_fn dtpcon;
    struct flexiblas_hook_fn dtplqt;
    struct flexiblas_hook_fn dtplqt2;
    struct flexiblas_hook_fn dtpmlqt;
    struct flexiblas_hook_fn dtpmqrt;
    struct flexiblas_hook_fn dtpqrt;
    struct flexiblas_hook_fn dtpqrt2;
    struct flexiblas_hook_fn dtprfb;
    struct flexiblas_hook_fn dtprfs;
    struct flexiblas_hook_fn dtptri;
    struct flexiblas_hook_fn dtptrs;
    struct flexiblas_hook_fn dtpttf;
    struct flexiblas_hook_fn dtpttr;
    struct flexiblas_hook_fn dtrcon;
    struct flexiblas_hook_fn dtrevc;
    struct flexiblas_hook_fn dtrevc3;
    struct flexiblas_hook_fn dtrexc;
    struct flexiblas_hook_fn dtrrfs;
    struct flexiblas_hook_fn dtrsen;
    struct flexiblas_hook_fn dtrsna;
    struct flexiblas_hook_fn dtrsyl;
    struct flexiblas_hook_fn dtrsyl3;
    struct flexiblas_hook_fn dtrti2;
    struct flexiblas_hook_fn dtrtri;
    struct flexiblas_hook_fn dtrtrs;
    struct flexiblas_hook_fn dtrttf;
    struct flexiblas_hook_fn dtrttp;
    struct flexiblas_hook_fn dtzrqf;
    struct flexiblas_hook_fn dtzrzf;
    struct flexiblas_hook_fn dzsum1;
    struct flexiblas_hook_fn icmax1;
    struct flexiblas_hook_fn ieeeck;
    struct flexiblas_hook_fn ilaclc;
    struct flexiblas_hook_fn ilaclr;
    struct flexiblas_hook_fn iladiag;
    struct flexiblas_hook_fn iladlc;
    struct flexiblas_hook_fn iladlr;
    struct flexiblas_hook_fn ilaenv;
    struct flexiblas_hook_fn ilaenv2stage;
    struct flexiblas_hook_fn ilaprec;
    struct flexiblas_hook_fn ilaslc;
    struct flexiblas_hook_fn ilaslr;
    struct flexiblas_hook_fn ilatrans;
    struct flexiblas_hook_fn ilauplo;
    struct flexiblas_hook_fn ilazlc;
    struct flexiblas_hook_fn ilazlr;
    struct flexiblas_hook_fn iparam2stage;
    struct flexiblas_hook_fn iparmq;
    struct flexiblas_hook_fn izmax1;
    struct flexiblas_hook_fn sbbcsd;
    struct flexiblas_hook_fn sbdsdc;
    struct flexiblas_hook_fn sbdsqr;
    struct flexiblas_hook_fn sbdsvdx;
    struct flexiblas_hook_fn scombssq;
    struct flexiblas_hook_fn scsum1;
    struct flexiblas_hook_fn sdisna;
    struct flexiblas_hook_fn second;
    struct flexiblas_hook_fn sgbbrd;
    struct flexiblas_hook_fn sgbcon;
    struct flexiblas_hook_fn sgbequ;
    struct flexiblas_hook_fn sgbequb;
    struct flexiblas_hook_fn sgbrfs;
    struct flexiblas_hook_fn sgbrfsx;
    struct flexiblas_hook_fn sgbsv;
    struct flexiblas_hook_fn sgbsvx;
    struct flexiblas_hook_fn sgbsvxx;
    struct flexiblas_hook_fn sgbtf2;
    struct flexiblas_hook_fn sgbtrf;
    struct flexiblas_hook_fn sgbtrs;
    struct flexiblas_hook_fn sgebak;
    struct flexiblas_hook_fn sgebal;
    struct flexiblas_hook_fn sgebd2;
    struct flexiblas_hook_fn sgebrd;
    struct flexiblas_hook_fn sgecon;
    struct flexiblas_hook_fn sgedmd;
    struct flexiblas_hook_fn sgedmdq;
    struct flexiblas_hook_fn sgeequ;
    struct flexiblas_hook_fn sgeequb;
    struct flexiblas_hook_fn sgees;
    struct flexiblas_hook_fn sgeesx;
    struct flexiblas_hook_fn sgeev;
    struct flexiblas_hook_fn sgeevx;
    struct flexiblas_hook_fn sgegs;
    struct flexiblas_hook_fn sgegv;
    struct flexiblas_hook_fn sgehd2;
    struct flexiblas_hook_fn sgehrd;
    struct flexiblas_hook_fn sgejsv;
    struct flexiblas_hook_fn sgelq;
    struct flexiblas_hook_fn sgelq2;
    struct flexiblas_hook_fn sgelqf;
    struct flexiblas_hook_fn sgelqs;
    struct flexiblas_hook_fn sgelqt;
    struct flexiblas_hook_fn sgelqt3;
    struct flexiblas_hook_fn sgels;
    struct flexiblas_hook_fn sgelsd;
    struct flexiblas_hook_fn sgelss;
    struct flexiblas_hook_fn sgelst;
    struct flexiblas_hook_fn sgelsx;
    struct flexiblas_hook_fn sgelsy;
    struct flexiblas_hook_fn sgemlq;
    struct flexiblas_hook_fn sgemlqt;
    struct flexiblas_hook_fn sgemqr;
    struct flexiblas_hook_fn sgemqrt;
    struct flexiblas_hook_fn sgeql2;
    struct flexiblas_hook_fn sgeqlf;
    struct flexiblas_hook_fn sgeqp3;
    struct flexiblas_hook_fn sgeqp3rk;
    struct flexiblas_hook_fn sgeqpf;
    struct flexiblas_hook_fn sgeqr;
    struct flexiblas_hook_fn sgeqr2;
    struct flexiblas_hook_fn sgeqr2p;
    struct flexiblas_hook_fn sgeqrf;
    struct flexiblas_hook_fn sgeqrfp;
    struct flexiblas_hook_fn sgeqrs;
    struct flexiblas_hook_fn sgeqrt;
    struct flexiblas_hook_fn sgeqrt2;
    struct flexiblas_hook_fn sgeqrt3;
    struct flexiblas_hook_fn sgerfs;
    struct flexiblas_hook_fn sgerfsx;
    struct flexiblas_hook_fn sgerq2;
    struct flexiblas_hook_fn sgerqf;
    struct flexiblas_hook_fn sgesc2;
    struct flexiblas_hook_fn sgesdd;
    struct flexiblas_hook_fn sgesv;
    struct flexiblas_hook_fn sgesvd;
    struct flexiblas_hook_fn sgesvdq;
    struct flexiblas_hook_fn sgesvdx;
    struct flexiblas_hook_fn sgesvj;
    struct flexiblas_hook_fn sgesvx;
    struct flexiblas_hook_fn sgesvxx;
    struct flexiblas_hook_fn sgetc2;
    struct flexiblas_hook_fn sgetf2;
    struct flexiblas_hook_fn sgetrf;
    struct flexiblas_hook_fn sgetrf2;
    struct flexiblas_hook_fn sgetri;
    struct flexiblas_hook_fn sgetrs;
    struct flexiblas_hook_fn sgetsls;
    struct flexiblas_hook_fn sgetsqrhrt;
    struct flexiblas_hook_fn sggbak;
    struct flexiblas_hook_fn sggbal;
    struct flexiblas_hook_fn sgges;
    struct flexiblas_hook_fn sgges3;
    struct flexiblas_hook_fn sggesx;
    struct flexiblas_hook_fn sggev;
    struct flexiblas_hook_fn sggev3;
    struct flexiblas_hook_fn sggevx;
    struct flexiblas_hook_fn sggglm;
    struct flexiblas_hook_fn sgghd3;
    struct flexiblas_hook_fn sgghrd;
    struct flexiblas_hook_fn sgglse;
    struct flexiblas_hook_fn sggqrf;
    struct flexiblas_hook_fn sggrqf;
    struct flexiblas_hook_fn sggsvd;
    struct flexiblas_hook_fn sggsvd3;
    struct flexiblas_hook_fn sggsvp;
    struct flexiblas_hook_fn sggsvp3;
    struct flexiblas_hook_fn sgsvj0;
    struct flexiblas_hook_fn sgsvj1;
    struct flexiblas_hook_fn sgtcon;
    struct flexiblas_hook_fn sgtrfs;
    struct flexiblas_hook_fn sgtsv;
    struct flexiblas_hook_fn sgtsvx;
    struct flexiblas_hook_fn sgttrf;
    struct flexiblas_hook_fn sgttrs;
    struct flexiblas_hook_fn sgtts2;
    struct flexiblas_hook_fn shgeqz;
    struct flexiblas_hook_fn shsein;
    struct flexiblas_hook_fn shseqr;
    struct flexiblas_hook_fn sisnan;
    struct flexiblas_hook_fn sla_gbamv;
    struct flexiblas_hook_fn sla_gbrcond;
    struct flexiblas_hook_fn sla_gbrfsx_extended;
    struct flexiblas_hook_fn sla_gbrpvgrw;
    struct flexiblas_hook_fn sla_geamv;
    struct flexiblas_hook_fn sla_gercond;
    struct flexiblas_hook_fn sla_gerfsx_extended;
    struct flexiblas_hook_fn sla_gerpvgrw;
    struct flexiblas_hook_fn sla_lin_berr;
    struct flexiblas_hook_fn sla_porcond;
    struct flexiblas_hook_fn sla_porfsx_extended;
    struct flexiblas_hook_fn sla_porpvgrw;
    struct flexiblas_hook_fn sla_rpvgrw;
    struct flexiblas_hook_fn sla_syamv;
    struct flexiblas_hook_fn sla_syrcond;
    struct flexiblas_hook_fn sla_syrfsx_extended;
    struct flexiblas_hook_fn sla_syrpvgrw;
    struct flexiblas_hook_fn sla_wwaddw;
    struct flexiblas_hook_fn slabad;
    struct flexiblas_hook_fn slabrd;
    struct flexiblas_hook_fn slacn2;
    struct flexiblas_hook_fn slacon;
    struct flexiblas_hook_fn slacpy;
    struct flexiblas_hook_fn sladiv;
    struct flexiblas_hook_fn sladiv1;
    struct flexiblas_hook_fn sladiv2;
    struct flexiblas_hook_fn slae2;
    struct flexiblas_hook_fn slaebz;
    struct flexiblas_hook_fn slaed0;
    struct flexiblas_hook_fn slaed1;
    struct flexiblas_hook_fn slaed2;
    struct flexiblas_hook_fn slaed3;
    struct flexiblas_hook_fn slaed4;
    struct flexiblas_hook_fn slaed5;
    struct flexiblas_hook_fn slaed6;
    struct flexiblas_hook_fn slaed7;
    struct flexiblas_hook_fn slaed8;
    struct flexiblas_hook_fn slaed9;
    struct flexiblas_hook_fn slaeda;
    struct flexiblas_hook_fn slaein;
    struct flexiblas_hook_fn slaev2;
    struct flexiblas_hook_fn slaexc;
    struct flexiblas_hook_fn slag2;
    struct flexiblas_hook_fn slag2d;
    struct flexiblas_hook_fn slags2;
    struct flexiblas_hook_fn slagtf;
    struct flexiblas_hook_fn slagtm;
    struct flexiblas_hook_fn slagts;
    struct flexiblas_hook_fn slagv2;
    struct flexiblas_hook_fn slahqr;
    struct flexiblas_hook_fn slahr2;
    struct flexiblas_hook_fn slahrd;
    struct flexiblas_hook_fn slaic1;
    struct flexiblas_hook_fn slaisnan;
    struct flexiblas_hook_fn slaln2;
    struct flexiblas_hook_fn slals0;
    struct flexiblas_hook_fn slalsa;
    struct flexiblas_hook_fn slalsd;
    struct flexiblas_hook_fn slamc3;
    struct flexiblas_hook_fn slamch;
    struct flexiblas_hook_fn slamrg;
    struct flexiblas_hook_fn slamswlq;
    struct flexiblas_hook_fn slamtsqr;
    struct flexiblas_hook_fn slaneg;
    struct flexiblas_hook_fn slangb;
    struct flexiblas_hook_fn slange;
    struct flexiblas_hook_fn slangt;
    struct flexiblas_hook_fn slanhs;
    struct flexiblas_hook_fn slansb;
    struct flexiblas_hook_fn slansf;
    struct flexiblas_hook_fn slansp;
    struct flexiblas_hook_fn slanst;
    struct flexiblas_hook_fn slansy;
    struct flexiblas_hook_fn slantb;
    struct flexiblas_hook_fn slantp;
    struct flexiblas_hook_fn slantr;
    struct flexiblas_hook_fn slanv2;
    struct flexiblas_hook_fn slaorhr_col_getrfnp;
    struct flexiblas_hook_fn slaorhr_col_getrfnp2;
    struct flexiblas_hook_fn slapll;
    struct flexiblas_hook_fn slapmr;
    struct flexiblas_hook_fn slapmt;
    struct flexiblas_hook_fn slapy2;
    struct flexiblas_hook_fn slapy3;
    struct flexiblas_hook_fn slaqgb;
    struct flexiblas_hook_fn slaqge;
    struct flexiblas_hook_fn slaqp2;
    struct flexiblas_hook_fn slaqp2rk;
    struct flexiblas_hook_fn slaqp3rk;
    struct flexiblas_hook_fn slaqps;
    struct flexiblas_hook_fn slaqr0;
    struct flexiblas_hook_fn slaqr1;
    struct flexiblas_hook_fn slaqr2;
    struct flexiblas_hook_fn slaqr3;
    struct flexiblas_hook_fn slaqr4;
    struct flexiblas_hook_fn slaqr5;
    struct flexiblas_hook_fn slaqsb;
    struct flexiblas_hook_fn slaqsp;
    struct flexiblas_hook_fn slaqsy;
    struct flexiblas_hook_fn slaqtr;
    struct flexiblas_hook_fn slaqz0;
    struct flexiblas_hook_fn slaqz1;
    struct flexiblas_hook_fn slaqz2;
    struct flexiblas_hook_fn slaqz3;
    struct flexiblas_hook_fn slaqz4;
    struct flexiblas_hook_fn slar1v;
    struct flexiblas_hook_fn slar2v;
    struct flexiblas_hook_fn slarf;
    struct flexiblas_hook_fn slarf1f;
    struct flexiblas_hook_fn slarf1l;
    struct flexiblas_hook_fn slarfb;
    struct flexiblas_hook_fn slarfb_gett;
    struct flexiblas_hook_fn slarfg;
    struct flexiblas_hook_fn slarfgp;
    struct flexiblas_hook_fn slarft;
    struct flexiblas_hook_fn slarfx;
    struct flexiblas_hook_fn slarfy;
    struct flexiblas_hook_fn slargv;
    struct flexiblas_hook_fn slarmm;
    struct flexiblas_hook_fn slarnv;
    struct flexiblas_hook_fn slarra;
    struct flexiblas_hook_fn slarrb;
    struct flexiblas_hook_fn slarrc;
    struct flexiblas_hook_fn slarrd;
    struct flexiblas_hook_fn slarre;
    struct flexiblas_hook_fn slarrf;
    struct flexiblas_hook_fn slarrj;
    struct flexiblas_hook_fn slarrk;
    struct flexiblas_hook_fn slarrr;
    struct flexiblas_hook_fn slarrv;
    struct flexiblas_hook_fn slarscl2;
    struct flexiblas_hook_fn slartg;
    struct flexiblas_hook_fn slartgp;
    struct flexiblas_hook_fn slartgs;
    struct flexiblas_hook_fn slartv;
    struct flexiblas_hook_fn slaruv;
    struct flexiblas_hook_fn slarz;
    struct flexiblas_hook_fn slarzb;
    struct flexiblas_hook_fn slarzt;
    struct flexiblas_hook_fn slas2;
    struct flexiblas_hook_fn slascl;
    struct flexiblas_hook_fn slascl2;
    struct flexiblas_hook_fn slasd0;
    struct flexiblas_hook_fn slasd1;
    struct flexiblas_hook_fn slasd2;
    struct flexiblas_hook_fn slasd3;
    struct flexiblas_hook_fn slasd4;
    struct flexiblas_hook_fn slasd5;
    struct flexiblas_hook_fn slasd6;
    struct flexiblas_hook_fn slasd7;
    struct flexiblas_hook_fn slasd8;
    struct flexiblas_hook_fn slasda;
    struct flexiblas_hook_fn slasdq;
    struct flexiblas_hook_fn slasdt;
    struct flexiblas_hook_fn slaset;
    struct flexiblas_hook_fn slasq1;
    struct flexiblas_hook_fn slasq2;
    struct flexiblas_hook_fn slasq3;
    struct flexiblas_hook_fn slasq4;
    struct flexiblas_hook_fn slasq5;
    struct flexiblas_hook_fn slasq6;
    struct flexiblas_hook_fn slasr;
    struct flexiblas_hook_fn slasrt;
    struct flexiblas_hook_fn slassq;
    struct flexiblas_hook_fn slasv2;
    struct flexiblas_hook_fn slaswlq;
    struct flexiblas_hook_fn slaswp;
    struct flexiblas_hook_fn slasy2;
    struct flexiblas_hook_fn slasyf;
    struct flexiblas_hook_fn slasyf_aa;
    struct flexiblas_hook_fn slasyf_rk;
    struct flexiblas_hook_fn slasyf_rook;
    struct flexiblas_hook_fn slatbs;
    struct flexiblas_hook_fn slatdf;
    struct flexiblas_hook_fn slatps;
    struct flexiblas_hook_fn slatrd;
    struct flexiblas_hook_fn slatrs;
    struct flexiblas_hook_fn slatrs3;
    struct flexiblas_hook_fn slatrz;
    struct flexiblas_hook_fn slatsqr;
    struct flexiblas_hook_fn slatzm;
    struct flexiblas_hook_fn slauu2;
    struct flexiblas_hook_fn slauum;
    struct flexiblas_hook_fn sopgtr;
    struct flexiblas_hook_fn sopmtr;
    struct flexiblas_hook_fn sorbdb;
    struct flexiblas_hook_fn sorbdb1;
    struct flexiblas_hook_fn sorbdb2;
    struct flexiblas_hook_fn sorbdb3;
    struct flexiblas_hook_fn sorbdb4;
    struct flexiblas_hook_fn sorbdb5;
    struct flexiblas_hook_fn sorbdb6;
    struct flexiblas_hook_fn sorcsd;
    struct flexiblas_hook_fn sorcsd2by1;
    struct flexiblas_hook_fn sorg2l;
    struct flexiblas_hook_fn sorg2r;
    struct flexiblas_hook_fn sorgbr;
    struct flexiblas_hook_fn sorghr;
    struct flexiblas_hook_fn sorgl2;
    struct flexiblas_hook_fn sorglq;
    struct flexiblas_hook_fn sorgql;
    struct flexiblas_hook_fn sorgqr;
    struct flexiblas_hook_fn sorgr2;
    struct flexiblas_hook_fn sorgrq;
    struct flexiblas_hook_fn sorgtr;
    struct flexiblas_hook_fn sorgtsqr;
    struct flexiblas_hook_fn sorgtsqr_row;
    struct flexiblas_hook_fn sorhr_col;
    struct flexiblas_hook_fn sorm22;
    struct flexiblas_hook_fn sorm2l;
    struct flexiblas_hook_fn sorm2r;
    struct flexiblas_hook_fn sormbr;
    struct flexiblas_hook_fn sormhr;
    struct flexiblas_hook_fn sorml2;
    struct flexiblas_hook_fn sormlq;
    struct flexiblas_hook_fn sormql;
    struct flexiblas_hook_fn sormqr;
    struct flexiblas_hook_fn sormr2;
    struct flexiblas_hook_fn sormr3;
    struct flexiblas_hook_fn sormrq;
    struct flexiblas_hook_fn sormrz;
    struct flexiblas_hook_fn sormtr;
    struct flexiblas_hook_fn spbcon;
    struct flexiblas_hook_fn spbequ;
    struct flexiblas_hook_fn spbrfs;
    struct flexiblas_hook_fn spbstf;
    struct flexiblas_hook_fn spbsv;
    struct flexiblas_hook_fn spbsvx;
    struct flexiblas_hook_fn spbtf2;
    struct flexiblas_hook_fn spbtrf;
    struct flexiblas_hook_fn spbtrs;
    struct flexiblas_hook_fn spftrf;
    struct flexiblas_hook_fn spftri;
    struct flexiblas_hook_fn spftrs;
    struct flexiblas_hook_fn spocon;
    struct flexiblas_hook_fn spoequ;
    struct flexiblas_hook_fn spoequb;
    struct flexiblas_hook_fn sporfs;
    struct flexiblas_hook_fn sporfsx;
    struct flexiblas_hook_fn sposv;
    struct flexiblas_hook_fn sposvx;
    struct flexiblas_hook_fn sposvxx;
    struct flexiblas_hook_fn spotf2;
    struct flexiblas_hook_fn spotrf;
    struct flexiblas_hook_fn spotrf2;
    struct flexiblas_hook_fn spotri;
    struct flexiblas_hook_fn spotrs;
    struct flexiblas_hook_fn sppcon;
    struct flexiblas_hook_fn sppequ;
    struct flexiblas_hook_fn spprfs;
    struct flexiblas_hook_fn sppsv;
    struct flexiblas_hook_fn sppsvx;
    struct flexiblas_hook_fn spptrf;
    struct flexiblas_hook_fn spptri;
    struct flexiblas_hook_fn spptrs;
    struct flexiblas_hook_fn spstf2;
    struct flexiblas_hook_fn spstrf;
    struct flexiblas_hook_fn sptcon;
    struct flexiblas_hook_fn spteqr;
    struct flexiblas_hook_fn sptrfs;
    struct flexiblas_hook_fn sptsv;
    struct flexiblas_hook_fn sptsvx;
    struct flexiblas_hook_fn spttrf;
    struct flexiblas_hook_fn spttrs;
    struct flexiblas_hook_fn sptts2;
    struct flexiblas_hook_fn sroundup_lwork;
    struct flexiblas_hook_fn srscl;
    struct flexiblas_hook_fn ssb2st_kernels;
    struct flexiblas_hook_fn ssbev;
    struct flexiblas_hook_fn ssbev_2stage;
    struct flexiblas_hook_fn ssbevd;
    struct flexiblas_hook_fn ssbevd_2stage;
    struct flexiblas_hook_fn ssbevx;
    struct flexiblas_hook_fn ssbevx_2stage;
    struct flexiblas_hook_fn ssbgst;
    struct flexiblas_hook_fn ssbgv;
    struct flexiblas_hook_fn ssbgvd;
    struct flexiblas_hook_fn ssbgvx;
    struct flexiblas_hook_fn ssbtrd;
    struct flexiblas_hook_fn ssfrk;
    struct flexiblas_hook_fn sspcon;
    struct flexiblas_hook_fn sspev;
    struct flexiblas_hook_fn sspevd;
    struct flexiblas_hook_fn sspevx;
    struct flexiblas_hook_fn sspgst;
    struct flexiblas_hook_fn sspgv;
    struct flexiblas_hook_fn sspgvd;
    struct flexiblas_hook_fn sspgvx;
    struct flexiblas_hook_fn ssprfs;
    struct flexiblas_hook_fn sspsv;
    struct flexiblas_hook_fn sspsvx;
    struct flexiblas_hook_fn ssptrd;
    struct flexiblas_hook_fn ssptrf;
    struct flexiblas_hook_fn ssptri;
    struct flexiblas_hook_fn ssptrs;
    struct flexiblas_hook_fn sstebz;
    struct flexiblas_hook_fn sstedc;
    struct flexiblas_hook_fn sstegr;
    struct flexiblas_hook_fn sstein;
    struct flexiblas_hook_fn sstemr;
    struct flexiblas_hook_fn ssteqr;
    struct flexiblas_hook_fn ssterf;
    struct flexiblas_hook_fn sstev;
    struct flexiblas_hook_fn sstevd;
    struct flexiblas_hook_fn sstevr;
    struct flexiblas_hook_fn sstevx;
    struct flexiblas_hook_fn ssycon;
    struct flexiblas_hook_fn ssycon_3;
    struct flexiblas_hook_fn ssycon_rook;
    struct flexiblas_hook_fn ssyconv;
    struct flexiblas_hook_fn ssyconvf;
    struct flexiblas_hook_fn ssyconvf_rook;
    struct flexiblas_hook_fn ssyequb;
    struct flexiblas_hook_fn ssyev;
    struct flexiblas_hook_fn ssyev_2stage;
    struct flexiblas_hook_fn ssyevd;
    struct flexiblas_hook_fn ssyevd_2stage;
    struct flexiblas_hook_fn ssyevr;
    struct flexiblas_hook_fn ssyevr_2stage;
    struct flexiblas_hook_fn ssyevx;
    struct flexiblas_hook_fn ssyevx_2stage;
    struct flexiblas_hook_fn ssygs2;
    struct flexiblas_hook_fn ssygst;
    struct flexiblas_hook_fn ssygv;
    struct flexiblas_hook_fn ssygv_2stage;
    struct flexiblas_hook_fn ssygvd;
    struct flexiblas_hook_fn ssygvx;
    struct flexiblas_hook_fn ssyrfs;
    struct flexiblas_hook_fn ssyrfsx;
    struct flexiblas_hook_fn ssysv;
    struct flexiblas_hook_fn ssysv_aa;
    struct flexiblas_hook_fn ssysv_aa_2stage;
    struct flexiblas_hook_fn ssysv_rk;
    struct flexiblas_hook_fn ssysv_rook;
    struct flexiblas_hook_fn ssysvx;
    struct flexiblas_hook_fn ssysvxx;
    struct flexiblas_hook_fn ssyswapr;
    struct flexiblas_hook_fn ssytd2;
    struct flexiblas_hook_fn ssytf2;
    struct flexiblas_hook_fn ssytf2_rk;
    struct flexiblas_hook_fn ssytf2_rook;
    struct flexiblas_hook_fn ssytrd;
    struct flexiblas_hook_fn ssytrd_2stage;
    struct flexiblas_hook_fn ssytrd_sb2st;
    struct flexiblas_hook_fn ssytrd_sy2sb;
    struct flexiblas_hook_fn ssytrf;
    struct flexiblas_hook_fn ssytrf_aa;
    struct flexiblas_hook_fn ssytrf_aa_2stage;
    struct flexiblas_hook_fn ssytrf_rk;
    struct flexiblas_hook_fn ssytrf_rook;
    struct flexiblas_hook_fn ssytri;
    struct flexiblas_hook_fn ssytri2;
    struct flexiblas_hook_fn ssytri2x;
    struct flexiblas_hook_fn ssytri_3;
    struct flexiblas_hook_fn ssytri_3x;
    struct flexiblas_hook_fn ssytri_rook;
    struct flexiblas_hook_fn ssytrs;
    struct flexiblas_hook_fn ssytrs2;
    struct flexiblas_hook_fn ssytrs_3;
    struct flexiblas_hook_fn ssytrs_aa;
    struct flexiblas_hook_fn ssytrs_aa_2stage;
    struct flexiblas_hook_fn ssytrs_rook;
    struct flexiblas_hook_fn stbcon;
    struct flexiblas_hook_fn stbrfs;
    struct flexiblas_hook_fn stbtrs;
    struct flexiblas_hook_fn stfsm;
    struct flexiblas_hook_fn stftri;
    struct flexiblas_hook_fn stfttp;
    struct flexiblas_hook_fn stfttr;
    struct flexiblas_hook_fn stgevc;
    struct flexiblas_hook_fn stgex2;
    struct flexiblas_hook_fn stgexc;
    struct flexiblas_hook_fn stgsen;
    struct flexiblas_hook_fn stgsja;
    struct flexiblas_hook_fn stgsna;
    struct flexiblas_hook_fn stgsy2;
    struct flexiblas_hook_fn stgsyl;
    struct flexiblas_hook_fn stpcon;
    struct flexiblas_hook_fn stplqt;
    struct flexiblas_hook_fn stplqt2;
    struct flexiblas_hook_fn stpmlqt;
    struct flexiblas_hook_fn stpmqrt;
    struct flexiblas_hook_fn stpqrt;
    struct flexiblas_hook_fn stpqrt2;
    struct flexiblas_hook_fn stprfb;
    struct flexiblas_hook_fn stprfs;
    struct flexiblas_hook_fn stptri;
    struct flexiblas_hook_fn stptrs;
    struct flexiblas_hook_fn stpttf;
    struct flexiblas_hook_fn stpttr;
    struct flexiblas_hook_fn strcon;
    struct flexiblas_hook_fn strevc;
    struct flexiblas_hook_fn strevc3;
    struct flexiblas_hook_fn strexc;
    struct flexiblas_hook_fn strrfs;
    struct flexiblas_hook_fn strsen;
    struct flexiblas_hook_fn strsna;
    struct flexiblas_hook_fn strsyl;
    struct flexiblas_hook_fn strsyl3;
    struct flexiblas_hook_fn strti2;
    struct flexiblas_hook_fn strtri;
    struct flexiblas_hook_fn strtrs;
    struct flexiblas_hook_fn strttf;
    struct flexiblas_hook_fn strttp;
    struct flexiblas_hook_fn stzrqf;
    struct flexiblas_hook_fn stzrzf;
    struct flexiblas_hook_fn zbbcsd;
    struct flexiblas_hook_fn zbdsqr;
    struct flexiblas_hook_fn zcgesv;
    struct flexiblas_hook_fn zcposv;
    struct flexiblas_hook_fn zdrscl;
    struct flexiblas_hook_fn zgbbrd;
    struct flexiblas_hook_fn zgbcon;
    struct flexiblas_hook_fn zgbequ;
    struct flexiblas_hook_fn zgbequb;
    struct flexiblas_hook_fn zgbrfs;
    struct flexiblas_hook_fn zgbrfsx;
    struct flexiblas_hook_fn zgbsv;
    struct flexiblas_hook_fn zgbsvx;
    struct flexiblas_hook_fn zgbsvxx;
    struct flexiblas_hook_fn zgbtf2;
    struct flexiblas_hook_fn zgbtrf;
    struct flexiblas_hook_fn zgbtrs;
    struct flexiblas_hook_fn zgebak;
    struct flexiblas_hook_fn zgebal;
    struct flexiblas_hook_fn zgebd2;
    struct flexiblas_hook_fn zgebrd;
    struct flexiblas_hook_fn zgecon;
    struct flexiblas_hook_fn zgedmd;
    struct flexiblas_hook_fn zgedmdq;
    struct flexiblas_hook_fn zgeequ;
    struct flexiblas_hook_fn zgeequb;
    struct flexiblas_hook_fn zgees;
    struct flexiblas_hook_fn zgeesx;
    struct flexiblas_hook_fn zgeev;
    struct flexiblas_hook_fn zgeevx;
    struct flexiblas_hook_fn zgegs;
    struct flexiblas_hook_fn zgegv;
    struct flexiblas_hook_fn zgehd2;
    struct flexiblas_hook_fn zgehrd;
    struct flexiblas_hook_fn zgejsv;
    struct flexiblas_hook_fn zgelq;
    struct flexiblas_hook_fn zgelq2;
    struct flexiblas_hook_fn zgelqf;
    struct flexiblas_hook_fn zgelqs;
    struct flexiblas_hook_fn zgelqt;
    struct flexiblas_hook_fn zgelqt3;
    struct flexiblas_hook_fn zgels;
    struct flexiblas_hook_fn zgelsd;
    struct flexiblas_hook_fn zgelss;
    struct flexiblas_hook_fn zgelst;
    struct flexiblas_hook_fn zgelsx;
    struct flexiblas_hook_fn zgelsy;
    struct flexiblas_hook_fn zgemlq;
    struct flexiblas_hook_fn zgemlqt;
    struct flexiblas_hook_fn zgemqr;
    struct flexiblas_hook_fn zgemqrt;
    struct flexiblas_hook_fn zgeql2;
    struct flexiblas_hook_fn zgeqlf;
    struct flexiblas_hook_fn zgeqp3;
    struct flexiblas_hook_fn zgeqp3rk;
    struct flexiblas_hook_fn zgeqpf;
    struct flexiblas_hook_fn zgeqr;
    struct flexiblas_hook_fn zgeqr2;
    struct flexiblas_hook_fn zgeqr2p;
    struct flexiblas_hook_fn zgeqrf;
    struct flexiblas_hook_fn zgeqrfp;
    struct flexiblas_hook_fn zgeqrs;
    struct flexiblas_hook_fn zgeqrt;
    struct flexiblas_hook_fn zgeqrt2;
    struct flexiblas_hook_fn zgeqrt3;
    struct flexiblas_hook_fn zgerfs;
    struct flexiblas_hook_fn zgerfsx;
    struct flexiblas_hook_fn zgerq2;
    struct flexiblas_hook_fn zgerqf;
    struct flexiblas_hook_fn zgesc2;
    struct flexiblas_hook_fn zgesdd;
    struct flexiblas_hook_fn zgesv;
    struct flexiblas_hook_fn zgesvd;
    struct flexiblas_hook_fn zgesvdq;
    struct flexiblas_hook_fn zgesvdx;
    struct flexiblas_hook_fn zgesvj;
    struct flexiblas_hook_fn zgesvx;
    struct flexiblas_hook_fn zgesvxx;
    struct flexiblas_hook_fn zgetc2;
    struct flexiblas_hook_fn zgetf2;
    struct flexiblas_hook_fn zgetrf;
    struct flexiblas_hook_fn zgetrf2;
    struct flexiblas_hook_fn zgetri;
    struct flexiblas_hook_fn zgetrs;
    struct flexiblas_hook_fn zgetsls;
    struct flexiblas_hook_fn zgetsqrhrt;
    struct flexiblas_hook_fn zggbak;
    struct flexiblas_hook_fn zggbal;
    struct flexiblas_hook_fn zgges;
    struct flexiblas_hook_fn zgges3;
    struct flexiblas_hook_fn zggesx;
    struct flexiblas_hook_fn zggev;
    struct flexiblas_hook_fn zggev3;
    struct flexiblas_hook_fn zggevx;
    struct flexiblas_hook_fn zggglm;
    struct flexiblas_hook_fn zgghd3;
    struct flexiblas_hook_fn zgghrd;
    struct flexiblas_hook_fn zgglse;
    struct flexiblas_hook_fn zggqrf;
    struct flexiblas_hook_fn zggrqf;
    struct flexiblas_hook_fn zggsvd;
    struct flexiblas_hook_fn zggsvd3;
    struct flexiblas_hook_fn zggsvp;
    struct flexiblas_hook_fn zggsvp3;
    struct flexiblas_hook_fn zgsvj0;
    struct flexiblas_hook_fn zgsvj1;
    struct flexiblas_hook_fn zgtcon;
    struct flexiblas_hook_fn zgtrfs;
    struct flexiblas_hook_fn zgtsv;
    struct flexiblas_hook_fn zgtsvx;
    struct flexiblas_hook_fn zgttrf;
    struct flexiblas_hook_fn zgttrs;
    struct flexiblas_hook_fn zgtts2;
    struct flexiblas_hook_fn zhb2st_kernels;
    struct flexiblas_hook_fn zhbev;
    struct flexiblas_hook_fn zhbev_2stage;
    struct flexiblas_hook_fn zhbevd;
    struct flexiblas_hook_fn zhbevd_2stage;
    struct flexiblas_hook_fn zhbevx;
    struct flexiblas_hook_fn zhbevx_2stage;
    struct flexiblas_hook_fn zhbgst;
    struct flexiblas_hook_fn zhbgv;
    struct flexiblas_hook_fn zhbgvd;
    struct flexiblas_hook_fn zhbgvx;
    struct flexiblas_hook_fn zhbtrd;
    struct flexiblas_hook_fn zhecon;
    struct flexiblas_hook_fn zhecon_3;
    struct flexiblas_hook_fn zhecon_rook;
    struct flexiblas_hook_fn zheequb;
    struct flexiblas_hook_fn zheev;
    struct flexiblas_hook_fn zheev_2stage;
    struct flexiblas_hook_fn zheevd;
    struct flexiblas_hook_fn zheevd_2stage;
    struct flexiblas_hook_fn zheevr;
    struct flexiblas_hook_fn zheevr_2stage;
    struct flexiblas_hook_fn zheevx;
    struct flexiblas_hook_fn zheevx_2stage;
    struct flexiblas_hook_fn zhegs2;
    struct flexiblas_hook_fn zhegst;
    struct flexiblas_hook_fn zhegv;
    struct flexiblas_hook_fn zhegv_2stage;
    struct flexiblas_hook_fn zhegvd;
    struct flexiblas_hook_fn zhegvx;
    struct flexiblas_hook_fn zherfs;
    struct flexiblas_hook_fn zherfsx;
    struct flexiblas_hook_fn zhesv;
    struct flexiblas_hook_fn zhesv_aa;
    struct flexiblas_hook_fn zhesv_aa_2stage;
    struct flexiblas_hook_fn zhesv_rk;
    struct flexiblas_hook_fn zhesv_rook;
    struct flexiblas_hook_fn zhesvx;
    struct flexiblas_hook_fn zhesvxx;
    struct flexiblas_hook_fn zheswapr;
    struct flexiblas_hook_fn zhetd2;
    struct flexiblas_hook_fn zhetf2;
    struct flexiblas_hook_fn zhetf2_rk;
    struct flexiblas_hook_fn zhetf2_rook;
    struct flexiblas_hook_fn zhetrd;
    struct flexiblas_hook_fn zhetrd_2stage;
    struct flexiblas_hook_fn zhetrd_hb2st;
    struct flexiblas_hook_fn zhetrd_he2hb;
    struct flexiblas_hook_fn zhetrf;
    struct flexiblas_hook_fn zhetrf_aa;
    struct flexiblas_hook_fn zhetrf_aa_2stage;
    struct flexiblas_hook_fn zhetrf_rk;
    struct flexiblas_hook_fn zhetrf_rook;
    struct flexiblas_hook_fn zhetri;
    struct flexiblas_hook_fn zhetri2;
    struct flexiblas_hook_fn zhetri2x;
    struct flexiblas_hook_fn zhetri_3;
    struct flexiblas_hook_fn zhetri_3x;
    struct flexiblas_hook_fn zhetri_rook;
    struct flexiblas_hook_fn zhetrs;
    struct flexiblas_hook_fn zhetrs2;
    struct flexiblas_hook_fn zhetrs_3;
    struct flexiblas_hook_fn zhetrs_aa;
    struct flexiblas_hook_fn zhetrs_aa_2stage;
    struct flexiblas_hook_fn zhetrs_rook;
    struct flexiblas_hook_fn zhfrk;
    struct flexiblas_hook_fn zhgeqz;
    struct flexiblas_hook_fn zhpcon;
    struct flexiblas_hook_fn zhpev;
    struct flexiblas_hook_fn zhpevd;
    struct flexiblas_hook_fn zhpevx;
    struct flexiblas_hook_fn zhpgst;
    struct flexiblas_hook_fn zhpgv;
    struct flexiblas_hook_fn zhpgvd;
    struct flexiblas_hook_fn zhpgvx;
    struct flexiblas_hook_fn zhprfs;
    struct flexiblas_hook_fn zhpsv;
    struct flexiblas_hook_fn zhpsvx;
    struct flexiblas_hook_fn zhptrd;
    struct flexiblas_hook_fn zhptrf;
    struct flexiblas_hook_fn zhptri;
    struct flexiblas_hook_fn zhptrs;
    struct flexiblas_hook_fn zhsein;
    struct flexiblas_hook_fn zhseqr;
    struct flexiblas_hook_fn zla_gbamv;
    struct flexiblas_hook_fn zla_gbrcond_c;
    struct flexiblas_hook_fn zla_gbrcond_x;
    struct flexiblas_hook_fn zla_gbrfsx_extended;
    struct flexiblas_hook_fn zla_gbrpvgrw;
    struct flexiblas_hook_fn zla_geamv;
    struct flexiblas_hook_fn zla_gercond_c;
    struct flexiblas_hook_fn zla_gercond_x;
    struct flexiblas_hook_fn zla_gerfsx_extended;
    struct flexiblas_hook_fn zla_gerpvgrw;
    struct flexiblas_hook_fn zla_heamv;
    struct flexiblas_hook_fn zla_hercond_c;
    struct flexiblas_hook_fn zla_hercond_x;
    struct flexiblas_hook_fn zla_herfsx_extended;
    struct flexiblas_hook_fn zla_herpvgrw;
    struct flexiblas_hook_fn zla_lin_berr;
    struct flexiblas_hook_fn zla_porcond_c;
    struct flexiblas_hook_fn zla_porcond_x;
    struct flexiblas_hook_fn zla_porfsx_extended;
    struct flexiblas_hook_fn zla_porpvgrw;
    struct flexiblas_hook_fn zla_rpvgrw;
    struct flexiblas_hook_fn zla_syamv;
    struct flexiblas_hook_fn zla_syrcond_c;
    struct flexiblas_hook_fn zla_syrcond_x;
    struct flexiblas_hook_fn zla_syrfsx_extended;
    struct flexiblas_hook_fn zla_syrpvgrw;
    struct flexiblas_hook_fn zla_wwaddw;
    struct flexiblas_hook_fn zlabrd;
    struct flexiblas_hook_fn zlacgv;
    struct flexiblas_hook_fn zlacn2;
    struct flexiblas_hook_fn zlacon;
    struct flexiblas_hook_fn zlacp2;
    struct flexiblas_hook_fn zlacpy;
    struct flexiblas_hook_fn zlacrm;
    struct flexiblas_hook_fn zlacrt;
    struct flexiblas_hook_fn zladiv;
    struct flexiblas_hook_fn zlaed0;
    struct flexiblas_hook_fn zlaed7;
    struct flexiblas_hook_fn zlaed8;
    struct flexiblas_hook_fn zlaein;
    struct flexiblas_hook_fn zlaesy;
    struct flexiblas_hook_fn zlaev2;
    struct flexiblas_hook_fn zlag2c;
    struct flexiblas_hook_fn zlags2;
    struct flexiblas_hook_fn zlagtm;
    struct flexiblas_hook_fn zlahef;
    struct flexiblas_hook_fn zlahef_aa;
    struct flexiblas_hook_fn zlahef_rk;
    struct flexiblas_hook_fn zlahef_rook;
    struct flexiblas_hook_fn zlahqr;
    struct flexiblas_hook_fn zlahr2;
    struct flexiblas_hook_fn zlahrd;
    struct flexiblas_hook_fn zlaic1;
    struct flexiblas_hook_fn zlals0;
    struct flexiblas_hook_fn zlalsa;
    struct flexiblas_hook_fn zlalsd;
    struct flexiblas_hook_fn zlamswlq;
    struct flexiblas_hook_fn zlamtsqr;
    struct flexiblas_hook_fn zlangb;
    struct flexiblas_hook_fn zlange;
    struct flexiblas_hook_fn zlangt;
    struct flexiblas_hook_fn zlanhb;
    struct flexiblas_hook_fn zlanhe;
    struct flexiblas_hook_fn zlanhf;
    struct flexiblas_hook_fn zlanhp;
    struct flexiblas_hook_fn zlanhs;
    struct flexiblas_hook_fn zlanht;
    struct flexiblas_hook_fn zlansb;
    struct flexiblas_hook_fn zlansp;
    struct flexiblas_hook_fn zlansy;
    struct flexiblas_hook_fn zlantb;
    struct flexiblas_hook_fn zlantp;
    struct flexiblas_hook_fn zlantr;
    struct flexiblas_hook_fn zlapll;
    struct flexiblas_hook_fn zlapmr;
    struct flexiblas_hook_fn zlapmt;
    struct flexiblas_hook_fn zlaqgb;
    struct flexiblas_hook_fn zlaqge;
    struct flexiblas_hook_fn zlaqhb;
    struct flexiblas_hook_fn zlaqhe;
    struct flexiblas_hook_fn zlaqhp;
    struct flexiblas_hook_fn zlaqp2;
    struct flexiblas_hook_fn zlaqp2rk;
    struct flexiblas_hook_fn zlaqp3rk;
    struct flexiblas_hook_fn zlaqps;
    struct flexiblas_hook_fn zlaqr0;
    struct flexiblas_hook_fn zlaqr1;
    struct flexiblas_hook_fn zlaqr2;
    struct flexiblas_hook_fn zlaqr3;
    struct flexiblas_hook_fn zlaqr4;
    struct flexiblas_hook_fn zlaqr5;
    struct flexiblas_hook_fn zlaqsb;
    struct flexiblas_hook_fn zlaqsp;
    struct flexiblas_hook_fn zlaqsy;
    struct flexiblas_hook_fn zlaqz0;
    struct flexiblas_hook_fn zlaqz1;
    struct flexiblas_hook_fn zlaqz2;
    struct flexiblas_hook_fn zlaqz3;
    struct flexiblas_hook_fn zlar1v;
    struct flexiblas_hook_fn zlar2v;
    struct flexiblas_hook_fn zlarcm;
    struct flexiblas_hook_fn zlarf;
    struct flexiblas_hook_fn zlarf1f;
    struct flexiblas_hook_fn zlarf1l;
    struct flexiblas_hook_fn zlarfb;
    struct flexiblas_hook_fn zlarfb_gett;
    struct flexiblas_hook_fn zlarfg;
    struct flexiblas_hook_fn zlarfgp;
    struct flexiblas_hook_fn zlarft;
    struct flexiblas_hook_fn zlarfx;
    struct flexiblas_hook_fn zlarfy;
    struct flexiblas_hook_fn zlargv;
    struct flexiblas_hook_fn zlarnv;
    struct flexiblas_hook_fn zlarrv;
    struct flexiblas_hook_fn zlarscl2;
    struct flexiblas_hook_fn zlartg;
    struct flexiblas_hook_fn zlartv;
    struct flexiblas_hook_fn zlarz;
    struct flexiblas_hook_fn zlarzb;
    struct flexiblas_hook_fn zlarzt;
    struct flexiblas_hook_fn zlascl;
    struct flexiblas_hook_fn zlascl2;
    struct flexiblas_hook_fn zlaset;
    struct flexiblas_hook_fn zlasr;
    struct flexiblas_hook_fn zlassq;
    struct flexiblas_hook_fn zlaswlq;
    struct flexiblas_hook_fn zlaswp;
    struct flexiblas_hook_fn zlasyf;
    struct flexiblas_hook_fn zlasyf_aa;
    struct flexiblas_hook_fn zlasyf_rk;
    struct flexiblas_hook_fn zlasyf_rook;
    struct flexiblas_hook_fn zlat2c;
    struct flexiblas_hook_fn zlatbs;
    struct flexiblas_hook_fn zlatdf;
    struct flexiblas_hook_fn zlatps;
    struct flexiblas_hook_fn zlatrd;
    struct flexiblas_hook_fn zlatrs;
    struct flexiblas_hook_fn zlatrs3;
    struct flexiblas_hook_fn zlatrz;
    struct flexiblas_hook_fn zlatsqr;
    struct flexiblas_hook_fn zlatzm;
    struct flexiblas_hook_fn zlaunhr_col_getrfnp;
    struct flexiblas_hook_fn zlaunhr_col_getrfnp2;
    struct flexiblas_hook_fn zlauu2;
    struct flexiblas_hook_fn zlauum;
    struct flexiblas_hook_fn zpbcon;
    struct flexiblas_hook_fn zpbequ;
    struct flexiblas_hook_fn zpbrfs;
    struct flexiblas_hook_fn zpbstf;
    struct flexiblas_hook_fn zpbsv;
    struct flexiblas_hook_fn zpbsvx;
    struct flexiblas_hook_fn zpbtf2;
    struct flexiblas_hook_fn zpbtrf;
    struct flexiblas_hook_fn zpbtrs;
    struct flexiblas_hook_fn zpftrf;
    struct flexiblas_hook_fn zpftri;
    struct flexiblas_hook_fn zpftrs;
    struct flexiblas_hook_fn zpocon;
    struct flexiblas_hook_fn zpoequ;
    struct flexiblas_hook_fn zpoequb;
    struct flexiblas_hook_fn zporfs;
    struct flexiblas_hook_fn zporfsx;
    struct flexiblas_hook_fn zposv;
    struct flexiblas_hook_fn zposvx;
    struct flexiblas_hook_fn zposvxx;
    struct flexiblas_hook_fn zpotf2;
    struct flexiblas_hook_fn zpotrf;
    struct flexiblas_hook_fn zpotrf2;
    struct flexiblas_hook_fn zpotri;
    struct flexiblas_hook_fn zpotrs;
    struct flexiblas_hook_fn zppcon;
    struct flexiblas_hook_fn zppequ;
    struct flexiblas_hook_fn zpprfs;
    struct flexiblas_hook_fn zppsv;
    struct flexiblas_hook_fn zppsvx;
    struct flexiblas_hook_fn zpptrf;
    struct flexiblas_hook_fn zpptri;
    struct flexiblas_hook_fn zpptrs;
    struct flexiblas_hook_fn zpstf2;
    struct flexiblas_hook_fn zpstrf;
    struct flexiblas_hook_fn zptcon;
    struct flexiblas_hook_fn zpteqr;
    struct flexiblas_hook_fn zptrfs;
    struct flexiblas_hook_fn zptsv;
    struct flexiblas_hook_fn zptsvx;
    struct flexiblas_hook_fn zpttrf;
    struct flexiblas_hook_fn zpttrs;
    struct flexiblas_hook_fn zptts2;
    struct flexiblas_hook_fn zrot;
    struct flexiblas_hook_fn zrscl;
    struct flexiblas_hook_fn zspcon;
    struct flexiblas_hook_fn zspmv;
    struct flexiblas_hook_fn zspr;
    struct flexiblas_hook_fn zsprfs;
    struct flexiblas_hook_fn zspsv;
    struct flexiblas_hook_fn zspsvx;
    struct flexiblas_hook_fn zsptrf;
    struct flexiblas_hook_fn zsptri;
    struct flexiblas_hook_fn zsptrs;
    struct flexiblas_hook_fn zstedc;
    struct flexiblas_hook_fn zstegr;
    struct flexiblas_hook_fn zstein;
    struct flexiblas_hook_fn zstemr;
    struct flexiblas_hook_fn zsteqr;
    struct flexiblas_hook_fn zsycon;
    struct flexiblas_hook_fn zsycon_3;
    struct flexiblas_hook_fn zsycon_rook;
    struct flexiblas_hook_fn zsyconv;
    struct flexiblas_hook_fn zsyconvf;
    struct flexiblas_hook_fn zsyconvf_rook;
    struct flexiblas_hook_fn zsyequb;
    struct flexiblas_hook_fn zsymv;
    struct flexiblas_hook_fn zsyr;
    struct flexiblas_hook_fn zsyrfs;
    struct flexiblas_hook_fn zsyrfsx;
    struct flexiblas_hook_fn zsysv;
    struct flexiblas_hook_fn zsysv_aa;
    struct flexiblas_hook_fn zsysv_aa_2stage;
    struct flexiblas_hook_fn zsysv_rk;
    struct flexiblas_hook_fn zsysv_rook;
    struct flexiblas_hook_fn zsysvx;
    struct flexiblas_hook_fn zsysvxx;
    struct flexiblas_hook_fn zsyswapr;
    struct flexiblas_hook_fn zsytf2;
    struct flexiblas_hook_fn zsytf2_rk;
    struct flexiblas_hook_fn zsytf2_rook;
    struct flexiblas_hook_fn zsytrf;
    struct flexiblas_hook_fn zsytrf_aa;
    struct flexiblas_hook_fn zsytrf_aa_2stage;
    struct flexiblas_hook_fn zsytrf_rk;
    struct flexiblas_hook_fn zsytrf_rook;
    struct flexiblas_hook_fn zsytri;
    struct flexiblas_hook_fn zsytri2;
    struct flexiblas_hook_fn zsytri2x;
    struct flexiblas_hook_fn zsytri_3;
    struct flexiblas_hook_fn zsytri_3x;
    struct flexiblas_hook_fn zsytri_rook;
    struct flexiblas_hook_fn zsytrs;
    struct flexiblas_hook_fn zsytrs2;
    struct flexiblas_hook_fn zsytrs_3;
    struct flexiblas_hook_fn zsytrs_aa;
    struct flexiblas_hook_fn zsytrs_aa_2stage;
    struct flexiblas_hook_fn zsytrs_rook;
    struct flexiblas_hook_fn ztbcon;
    struct flexiblas_hook_fn ztbrfs;
    struct flexiblas_hook_fn ztbtrs;
    struct flexiblas_hook_fn ztfsm;
    struct flexiblas_hook_fn ztftri;
    struct flexiblas_hook_fn ztfttp;
    struct flexiblas_hook_fn ztfttr;
    struct flexiblas_hook_fn ztgevc;
    struct flexiblas_hook_fn ztgex2;
    struct flexiblas_hook_fn ztgexc;
    struct flexiblas_hook_fn ztgsen;
    struct flexiblas_hook_fn ztgsja;
    struct flexiblas_hook_fn ztgsna;
    struct flexiblas_hook_fn ztgsy2;
    struct flexiblas_hook_fn ztgsyl;
    struct flexiblas_hook_fn ztpcon;
    struct flexiblas_hook_fn ztplqt;
    struct flexiblas_hook_fn ztplqt2;
    struct flexiblas_hook_fn ztpmlqt;
    struct flexiblas_hook_fn ztpmqrt;
    struct flexiblas_hook_fn ztpqrt;
    struct flexiblas_hook_fn ztpqrt2;
    struct flexiblas_hook_fn ztprfb;
    struct flexiblas_hook_fn ztprfs;
    struct flexiblas_hook_fn ztptri;
    struct flexiblas_hook_fn ztptrs;
    struct flexiblas_hook_fn ztpttf;
    struct flexiblas_hook_fn ztpttr;
    struct flexiblas_hook_fn ztrcon;
    struct flexiblas_hook_fn ztrevc;
    struct flexiblas_hook_fn ztrevc3;
    struct flexiblas_hook_fn ztrexc;
    struct flexiblas_hook_fn ztrrfs;
    struct flexiblas_hook_fn ztrsen;
    struct flexiblas_hook_fn ztrsna;
    struct flexiblas_hook_fn ztrsyl;
    struct flexiblas_hook_fn ztrsyl3;
    struct flexiblas_hook_fn ztrti2;
    struct flexiblas_hook_fn ztrtri;
    struct flexiblas_hook_fn ztrtrs;
    struct flexiblas_hook_fn ztrttf;
    struct flexiblas_hook_fn ztrttp;
    struct flexiblas_hook_fn ztzrqf;
    struct flexiblas_hook_fn ztzrzf;
    struct flexiblas_hook_fn zunbdb;
    struct flexiblas_hook_fn zunbdb1;
    struct flexiblas_hook_fn zunbdb2;
    struct flexiblas_hook_fn zunbdb3;
    struct flexiblas_hook_fn zunbdb4;
    struct flexiblas_hook_fn zunbdb5;
    struct flexiblas_hook_fn zunbdb6;
    struct flexiblas_hook_fn zuncsd;
    struct flexiblas_hook_fn zuncsd2by1;
    struct flexiblas_hook_fn zung2l;
    struct flexiblas_hook_fn zung2r;
    struct flexiblas_hook_fn zungbr;
    struct flexiblas_hook_fn zunghr;
    struct flexiblas_hook_fn zungl2;
    struct flexiblas_hook_fn zunglq;
    struct flexiblas_hook_fn zungql;
    struct flexiblas_hook_fn zungqr;
    struct flexiblas_hook_fn zungr2;
    struct flexiblas_hook_fn zungrq;
    struct flexiblas_hook_fn zungtr;
    struct flexiblas_hook_fn zungtsqr;
    struct flexiblas_hook_fn zungtsqr_row;
    struct flexiblas_hook_fn zunhr_col;
    struct flexiblas_hook_fn zunm22;
    struct flexiblas_hook_fn zunm2l;
    struct flexiblas_hook_fn zunm2r;
    struct flexiblas_hook_fn zunmbr;
    struct flexiblas_hook_fn zunmhr;
    struct flexiblas_hook_fn zunml2;
    struct flexiblas_hook_fn zunmlq;
    struct flexiblas_hook_fn zunmql;
    struct flexiblas_hook_fn zunmqr;
    struct flexiblas_hook_fn zunmr2;
    struct flexiblas_hook_fn zunmr3;
    struct flexiblas_hook_fn zunmrq;
    struct flexiblas_hook_fn zunmrz;
    struct flexiblas_hook_fn zunmtr;
    struct flexiblas_hook_fn zupgtr;
    struct flexiblas_hook_fn zupmtr;
    /* LAPACKE */
    struct flexiblas_hook_fn LAPACKE_cbbcsd;
    struct flexiblas_hook_fn LAPACKE_cbbcsd_work;
    struct flexiblas_hook_fn LAPACKE_cbdsqr;
    struct flexiblas_hook_fn LAPACKE_cbdsqr_work;
    struct flexiblas_hook_fn LAPACKE_cgbbrd;
    struct flexiblas_hook_fn LAPACKE_cgbbrd_work;
    struct flexiblas_hook_fn LAPACKE_cgbcon;
    struct flexiblas_hook_fn LAPACKE_cgbcon_work;
    struct flexiblas_hook_fn LAPACKE_cgbequ;
    struct flexiblas_hook_fn LAPACKE_cgbequ_work;
    struct flexiblas_hook_fn LAPACKE_cgbequb;
    struct flexiblas_hook_fn LAPACKE_cgbequb_work;
    struct flexiblas_hook_fn LAPACKE_cgbrfs;
    struct flexiblas_hook_fn LAPACKE_cgbrfs_work;
    struct flexiblas_hook_fn LAPACKE_cgbrfsx;
    struct flexiblas_hook_fn LAPACKE_cgbrfsx_work;
    struct flexiblas_hook_fn LAPACKE_cgbsv;
    struct flexiblas_hook_fn LAPACKE_cgbsv_work;
    struct flexiblas_hook_fn LAPACKE_cgbsvx;
    struct flexiblas_hook_fn LAPACKE_cgbsvx_work;
    struct flexiblas_hook_fn LAPACKE_cgbsvxx;
    struct flexiblas_hook_fn LAPACKE_cgbsvxx_work;
    struct flexiblas_hook_fn LAPACKE_cgbtrf;
    struct flexiblas_hook_fn LAPACKE_cgbtrf_work;
    struct flexiblas_hook_fn LAPACKE_cgbtrs;
    struct flexiblas_hook_fn LAPACKE_cgbtrs_work;
    struct flexiblas_hook_fn LAPACKE_cgebak;
    struct flexiblas_hook_fn LAPACKE_cgebak_work;
    struct flexiblas_hook_fn LAPACKE_cgebal;
    struct flexiblas_hook_fn LAPACKE_cgebal_work;
    struct flexiblas_hook_fn LAPACKE_cgebrd;
    struct flexiblas_hook_fn LAPACKE_cgebrd_work;
    struct flexiblas_hook_fn LAPACKE_cgecon;
    struct flexiblas_hook_fn LAPACKE_cgecon_work;
    struct flexiblas_hook_fn LAPACKE_cgedmd_work;
    struct flexiblas_hook_fn LAPACKE_cgedmdq_work;
    struct flexiblas_hook_fn LAPACKE_cgeequ;
    struct flexiblas_hook_fn LAPACKE_cgeequ_work;
    struct flexiblas_hook_fn LAPACKE_cgeequb;
    struct flexiblas_hook_fn LAPACKE_cgeequb_work;
    struct flexiblas_hook_fn LAPACKE_cgees;
    struct flexiblas_hook_fn LAPACKE_cgees_work;
    struct flexiblas_hook_fn LAPACKE_cgeesx;
    struct flexiblas_hook_fn LAPACKE_cgeesx_work;
    struct flexiblas_hook_fn LAPACKE_cgeev;
    struct flexiblas_hook_fn LAPACKE_cgeev_work;
    struct flexiblas_hook_fn LAPACKE_cgeevx;
    struct flexiblas_hook_fn LAPACKE_cgeevx_work;
    struct flexiblas_hook_fn LAPACKE_cgehrd;
    struct flexiblas_hook_fn LAPACKE_cgehrd_work;
    struct flexiblas_hook_fn LAPACKE_cgejsv;
    struct flexiblas_hook_fn LAPACKE_cgejsv_work;
    struct flexiblas_hook_fn LAPACKE_cgelq;
    struct flexiblas_hook_fn LAPACKE_cgelq2;
    struct flexiblas_hook_fn LAPACKE_cgelq2_work;
    struct flexiblas_hook_fn LAPACKE_cgelq_work;
    struct flexiblas_hook_fn LAPACKE_cgelqf;
    struct flexiblas_hook_fn LAPACKE_cgelqf_work;
    struct flexiblas_hook_fn LAPACKE_cgels;
    struct flexiblas_hook_fn LAPACKE_cgels_work;
    struct flexiblas_hook_fn LAPACKE_cgelsd;
    struct flexiblas_hook_fn LAPACKE_cgelsd_work;
    struct flexiblas_hook_fn LAPACKE_cgelss;
    struct flexiblas_hook_fn LAPACKE_cgelss_work;
    struct flexiblas_hook_fn LAPACKE_cgelsy;
    struct flexiblas_hook_fn LAPACKE_cgelsy_work;
    struct flexiblas_hook_fn LAPACKE_cgemlq;
    struct flexiblas_hook_fn LAPACKE_cgemlq_work;
    struct flexiblas_hook_fn LAPACKE_cgemqr;
    struct flexiblas_hook_fn LAPACKE_cgemqr_work;
    struct flexiblas_hook_fn LAPACKE_cgemqrt;
    struct flexiblas_hook_fn LAPACKE_cgemqrt_work;
    struct flexiblas_hook_fn LAPACKE_cgeqlf;
    struct flexiblas_hook_fn LAPACKE_cgeqlf_work;
    struct flexiblas_hook_fn LAPACKE_cgeqp3;
    struct flexiblas_hook_fn LAPACKE_cgeqp3_work;
    struct flexiblas_hook_fn LAPACKE_cgeqpf;
    struct flexiblas_hook_fn LAPACKE_cgeqpf_work;
    struct flexiblas_hook_fn LAPACKE_cgeqr;
    struct flexiblas_hook_fn LAPACKE_cgeqr2;
    struct flexiblas_hook_fn LAPACKE_cgeqr2_work;
    struct flexiblas_hook_fn LAPACKE_cgeqr_work;
    struct flexiblas_hook_fn LAPACKE_cgeqrf;
    struct flexiblas_hook_fn LAPACKE_cgeqrf_work;
    struct flexiblas_hook_fn LAPACKE_cgeqrfp;
    struct flexiblas_hook_fn LAPACKE_cgeqrfp_work;
    struct flexiblas_hook_fn LAPACKE_cgeqrt;
    struct flexiblas_hook_fn LAPACKE_cgeqrt2;
    struct flexiblas_hook_fn LAPACKE_cgeqrt2_work;
    struct flexiblas_hook_fn LAPACKE_cgeqrt3;
    struct flexiblas_hook_fn LAPACKE_cgeqrt3_work;
    struct flexiblas_hook_fn LAPACKE_cgeqrt_work;
    struct flexiblas_hook_fn LAPACKE_cgerfs;
    struct flexiblas_hook_fn LAPACKE_cgerfs_work;
    struct flexiblas_hook_fn LAPACKE_cgerfsx;
    struct flexiblas_hook_fn LAPACKE_cgerfsx_work;
    struct flexiblas_hook_fn LAPACKE_cgerqf;
    struct flexiblas_hook_fn LAPACKE_cgerqf_work;
    struct flexiblas_hook_fn LAPACKE_cgesdd;
    struct flexiblas_hook_fn LAPACKE_cgesdd_work;
    struct flexiblas_hook_fn LAPACKE_cgesv;
    struct flexiblas_hook_fn LAPACKE_cgesv_work;
    struct flexiblas_hook_fn LAPACKE_cgesvd;
    struct flexiblas_hook_fn LAPACKE_cgesvd_work;
    struct flexiblas_hook_fn LAPACKE_cgesvdq;
    struct flexiblas_hook_fn LAPACKE_cgesvdq_work;
    struct flexiblas_hook_fn LAPACKE_cgesvdx;
    struct flexiblas_hook_fn LAPACKE_cgesvdx_work;
    struct flexiblas_hook_fn LAPACKE_cgesvj;
    struct flexiblas_hook_fn LAPACKE_cgesvj_work;
    struct flexiblas_hook_fn LAPACKE_cgesvx;
    struct flexiblas_hook_fn LAPACKE_cgesvx_work;
    struct flexiblas_hook_fn LAPACKE_cgesvxx;
    struct flexiblas_hook_fn LAPACKE_cgesvxx_work;
    struct flexiblas_hook_fn LAPACKE_cgetf2;
    struct flexiblas_hook_fn LAPACKE_cgetf2_work;
    struct flexiblas_hook_fn LAPACKE_cgetrf;
    struct flexiblas_hook_fn LAPACKE_cgetrf2;
    struct flexiblas_hook_fn LAPACKE_cgetrf2_work;
    struct flexiblas_hook_fn LAPACKE_cgetrf_work;
    struct flexiblas_hook_fn LAPACKE_cgetri;
    struct flexiblas_hook_fn LAPACKE_cgetri_work;
    struct flexiblas_hook_fn LAPACKE_cgetrs;
    struct flexiblas_hook_fn LAPACKE_cgetrs_work;
    struct flexiblas_hook_fn LAPACKE_cgetsls;
    struct flexiblas_hook_fn LAPACKE_cgetsls_work;
    struct flexiblas_hook_fn LAPACKE_cgetsqrhrt;
    struct flexiblas_hook_fn LAPACKE_cgetsqrhrt_work;
    struct flexiblas_hook_fn LAPACKE_cggbak;
    struct flexiblas_hook_fn LAPACKE_cggbak_work;
    struct flexiblas_hook_fn LAPACKE_cggbal;
    struct flexiblas_hook_fn LAPACKE_cggbal_work;
    struct flexiblas_hook_fn LAPACKE_cgges;
    struct flexiblas_hook_fn LAPACKE_cgges3;
    struct flexiblas_hook_fn LAPACKE_cgges3_work;
    struct flexiblas_hook_fn LAPACKE_cgges_work;
    struct flexiblas_hook_fn LAPACKE_cggesx;
    struct flexiblas_hook_fn LAPACKE_cggesx_work;
    struct flexiblas_hook_fn LAPACKE_cggev;
    struct flexiblas_hook_fn LAPACKE_cggev3;
    struct flexiblas_hook_fn LAPACKE_cggev3_work;
    struct flexiblas_hook_fn LAPACKE_cggev_work;
    struct flexiblas_hook_fn LAPACKE_cggevx;
    struct flexiblas_hook_fn LAPACKE_cggevx_work;
    struct flexiblas_hook_fn LAPACKE_cggglm;
    struct flexiblas_hook_fn LAPACKE_cggglm_work;
    struct flexiblas_hook_fn LAPACKE_cgghd3;
    struct flexiblas_hook_fn LAPACKE_cgghd3_work;
    struct flexiblas_hook_fn LAPACKE_cgghrd;
    struct flexiblas_hook_fn LAPACKE_cgghrd_work;
    struct flexiblas_hook_fn LAPACKE_cgglse;
    struct flexiblas_hook_fn LAPACKE_cgglse_work;
    struct flexiblas_hook_fn LAPACKE_cggqrf;
    struct flexiblas_hook_fn LAPACKE_cggqrf_work;
    struct flexiblas_hook_fn LAPACKE_cggrqf;
    struct flexiblas_hook_fn LAPACKE_cggrqf_work;
    struct flexiblas_hook_fn LAPACKE_cggsvd;
    struct flexiblas_hook_fn LAPACKE_cggsvd3;
    struct flexiblas_hook_fn LAPACKE_cggsvd3_work;
    struct flexiblas_hook_fn LAPACKE_cggsvd_work;
    struct flexiblas_hook_fn LAPACKE_cggsvp;
    struct flexiblas_hook_fn LAPACKE_cggsvp3;
    struct flexiblas_hook_fn LAPACKE_cggsvp3_work;
    struct flexiblas_hook_fn LAPACKE_cggsvp_work;
    struct flexiblas_hook_fn LAPACKE_cgtcon;
    struct flexiblas_hook_fn LAPACKE_cgtcon_work;
    struct flexiblas_hook_fn LAPACKE_cgtrfs;
    struct flexiblas_hook_fn LAPACKE_cgtrfs_work;
    struct flexiblas_hook_fn LAPACKE_cgtsv;
    struct flexiblas_hook_fn LAPACKE_cgtsv_work;
    struct flexiblas_hook_fn LAPACKE_cgtsvx;
    struct flexiblas_hook_fn LAPACKE_cgtsvx_work;
    struct flexiblas_hook_fn LAPACKE_cgttrf;
    struct flexiblas_hook_fn LAPACKE_cgttrf_work;
    struct flexiblas_hook_fn LAPACKE_cgttrs;
    struct flexiblas_hook_fn LAPACKE_cgttrs_work;
    struct flexiblas_hook_fn LAPACKE_chbev;
    struct flexiblas_hook_fn LAPACKE_chbev_2stage;
    struct flexiblas_hook_fn LAPACKE_chbev_2stage_work;
    struct flexiblas_hook_fn LAPACKE_chbev_work;
    struct flexiblas_hook_fn LAPACKE_chbevd;
    struct flexiblas_hook_fn LAPACKE_chbevd_2stage;
    struct flexiblas_hook_fn LAPACKE_chbevd_2stage_work;
    struct flexiblas_hook_fn LAPACKE_chbevd_work;
    struct flexiblas_hook_fn LAPACKE_chbevx;
    struct flexiblas_hook_fn LAPACKE_chbevx_2stage;
    struct flexiblas_hook_fn LAPACKE_chbevx_2stage_work;
    struct flexiblas_hook_fn LAPACKE_chbevx_work;
    struct flexiblas_hook_fn LAPACKE_chbgst;
    struct flexiblas_hook_fn LAPACKE_chbgst_work;
    struct flexiblas_hook_fn LAPACKE_chbgv;
    struct flexiblas_hook_fn LAPACKE_chbgv_work;
    struct flexiblas_hook_fn LAPACKE_chbgvd;
    struct flexiblas_hook_fn LAPACKE_chbgvd_work;
    struct flexiblas_hook_fn LAPACKE_chbgvx;
    struct flexiblas_hook_fn LAPACKE_chbgvx_work;
    struct flexiblas_hook_fn LAPACKE_chbtrd;
    struct flexiblas_hook_fn LAPACKE_chbtrd_work;
    struct flexiblas_hook_fn LAPACKE_checon;
    struct flexiblas_hook_fn LAPACKE_checon_3;
    struct flexiblas_hook_fn LAPACKE_checon_3_work;
    struct flexiblas_hook_fn LAPACKE_checon_work;
    struct flexiblas_hook_fn LAPACKE_cheequb;
    struct flexiblas_hook_fn LAPACKE_cheequb_work;
    struct flexiblas_hook_fn LAPACKE_cheev;
    struct flexiblas_hook_fn LAPACKE_cheev_2stage;
    struct flexiblas_hook_fn LAPACKE_cheev_2stage_work;
    struct flexiblas_hook_fn LAPACKE_cheev_work;
    struct flexiblas_hook_fn LAPACKE_cheevd;
    struct flexiblas_hook_fn LAPACKE_cheevd_2stage;
    struct flexiblas_hook_fn LAPACKE_cheevd_2stage_work;
    struct flexiblas_hook_fn LAPACKE_cheevd_work;
    struct flexiblas_hook_fn LAPACKE_cheevr;
    struct flexiblas_hook_fn LAPACKE_cheevr_2stage;
    struct flexiblas_hook_fn LAPACKE_cheevr_2stage_work;
    struct flexiblas_hook_fn LAPACKE_cheevr_work;
    struct flexiblas_hook_fn LAPACKE_cheevx;
    struct flexiblas_hook_fn LAPACKE_cheevx_2stage;
    struct flexiblas_hook_fn LAPACKE_cheevx_2stage_work;
    struct flexiblas_hook_fn LAPACKE_cheevx_work;
    struct flexiblas_hook_fn LAPACKE_chegst;
    struct flexiblas_hook_fn LAPACKE_chegst_work;
    struct flexiblas_hook_fn LAPACKE_chegv;
    struct flexiblas_hook_fn LAPACKE_chegv_2stage;
    struct flexiblas_hook_fn LAPACKE_chegv_2stage_work;
    struct flexiblas_hook_fn LAPACKE_chegv_work;
    struct flexiblas_hook_fn LAPACKE_chegvd;
    struct flexiblas_hook_fn LAPACKE_chegvd_work;
    struct flexiblas_hook_fn LAPACKE_chegvx;
    struct flexiblas_hook_fn LAPACKE_chegvx_work;
    struct flexiblas_hook_fn LAPACKE_cherfs;
    struct flexiblas_hook_fn LAPACKE_cherfs_work;
    struct flexiblas_hook_fn LAPACKE_cherfsx;
    struct flexiblas_hook_fn LAPACKE_cherfsx_work;
    struct flexiblas_hook_fn LAPACKE_chesv;
    struct flexiblas_hook_fn LAPACKE_chesv_aa;
    struct flexiblas_hook_fn LAPACKE_chesv_aa_2stage;
    struct flexiblas_hook_fn LAPACKE_chesv_aa_2stage_work;
    struct flexiblas_hook_fn LAPACKE_chesv_aa_work;
    struct flexiblas_hook_fn LAPACKE_chesv_rk;
    struct flexiblas_hook_fn LAPACKE_chesv_rk_work;
    struct flexiblas_hook_fn LAPACKE_chesv_work;
    struct flexiblas_hook_fn LAPACKE_chesvx;
    struct flexiblas_hook_fn LAPACKE_chesvx_work;
    struct flexiblas_hook_fn LAPACKE_chesvxx;
    struct flexiblas_hook_fn LAPACKE_chesvxx_work;
    struct flexiblas_hook_fn LAPACKE_cheswapr;
    struct flexiblas_hook_fn LAPACKE_cheswapr_work;
    struct flexiblas_hook_fn LAPACKE_chetrd;
    struct flexiblas_hook_fn LAPACKE_chetrd_work;
    struct flexiblas_hook_fn LAPACKE_chetrf;
    struct flexiblas_hook_fn LAPACKE_chetrf_aa;
    struct flexiblas_hook_fn LAPACKE_chetrf_aa_2stage;
    struct flexiblas_hook_fn LAPACKE_chetrf_aa_2stage_work;
    struct flexiblas_hook_fn LAPACKE_chetrf_aa_work;
    struct flexiblas_hook_fn LAPACKE_chetrf_rk;
    struct flexiblas_hook_fn LAPACKE_chetrf_rk_work;
    struct flexiblas_hook_fn LAPACKE_chetrf_rook;
    struct flexiblas_hook_fn LAPACKE_chetrf_rook_work;
    struct flexiblas_hook_fn LAPACKE_chetrf_work;
    struct flexiblas_hook_fn LAPACKE_chetri;
    struct flexiblas_hook_fn LAPACKE_chetri2;
    struct flexiblas_hook_fn LAPACKE_chetri2_work;
    struct flexiblas_hook_fn LAPACKE_chetri2x;
    struct flexiblas_hook_fn LAPACKE_chetri2x_work;
    struct flexiblas_hook_fn LAPACKE_chetri_3;
    struct flexiblas_hook_fn LAPACKE_chetri_3_work;
    struct flexiblas_hook_fn LAPACKE_chetri_work;
    struct flexiblas_hook_fn LAPACKE_chetrs;
    struct flexiblas_hook_fn LAPACKE_chetrs2;
    struct flexiblas_hook_fn LAPACKE_chetrs2_work;
    struct flexiblas_hook_fn LAPACKE_chetrs_3;
    struct flexiblas_hook_fn LAPACKE_chetrs_3_work;
    struct flexiblas_hook_fn LAPACKE_chetrs_aa;
    struct flexiblas_hook_fn LAPACKE_chetrs_aa_2stage;
    struct flexiblas_hook_fn LAPACKE_chetrs_aa_2stage_work;
    struct flexiblas_hook_fn LAPACKE_chetrs_aa_work;
    struct flexiblas_hook_fn LAPACKE_chetrs_rook;
    struct flexiblas_hook_fn LAPACKE_chetrs_rook_work;
    struct flexiblas_hook_fn LAPACKE_chetrs_work;
    struct flexiblas_hook_fn LAPACKE_chfrk;
    struct flexiblas_hook_fn LAPACKE_chfrk_work;
    struct flexiblas_hook_fn LAPACKE_chgeqz;
    struct flexiblas_hook_fn LAPACKE_chgeqz_work;
    struct flexiblas_hook_fn LAPACKE_chpcon;
    struct flexiblas_hook_fn LAPACKE_chpcon_work;
    struct flexiblas_hook_fn LAPACKE_chpev;
    struct flexiblas_hook_fn LAPACKE_chpev_work;
    struct flexiblas_hook_fn LAPACKE_chpevd;
    struct flexiblas_hook_fn LAPACKE_chpevd_work;
    struct flexiblas_hook_fn LAPACKE_chpevx;
    struct flexiblas_hook_fn LAPACKE_chpevx_work;
    struct flexiblas_hook_fn LAPACKE_chpgst;
    struct flexiblas_hook_fn LAPACKE_chpgst_work;
    struct flexiblas_hook_fn LAPACKE_chpgv;
    struct flexiblas_hook_fn LAPACKE_chpgv_work;
    struct flexiblas_hook_fn LAPACKE_chpgvd;
    struct flexiblas_hook_fn LAPACKE_chpgvd_work;
    struct flexiblas_hook_fn LAPACKE_chpgvx;
    struct flexiblas_hook_fn LAPACKE_chpgvx_work;
    struct flexiblas_hook_fn LAPACKE_chprfs;
    struct flexiblas_hook_fn LAPACKE_chprfs_work;
    struct flexiblas_hook_fn LAPACKE_chpsv;
    struct flexiblas_hook_fn LAPACKE_chpsv_work;
    struct flexiblas_hook_fn LAPACKE_chpsvx;
    struct flexiblas_hook_fn LAPACKE_chpsvx_work;
    struct flexiblas_hook_fn LAPACKE_chptrd;
    struct flexiblas_hook_fn LAPACKE_chptrd_work;
    struct flexiblas_hook_fn LAPACKE_chptrf;
    struct flexiblas_hook_fn LAPACKE_chptrf_work;
    struct flexiblas_hook_fn LAPACKE_chptri;
    struct flexiblas_hook_fn LAPACKE_chptri_work;
    struct flexiblas_hook_fn LAPACKE_chptrs;
    struct flexiblas_hook_fn LAPACKE_chptrs_work;
    struct flexiblas_hook_fn LAPACKE_chsein;
    struct flexiblas_hook_fn LAPACKE_chsein_work;
    struct flexiblas_hook_fn LAPACKE_chseqr;
    struct flexiblas_hook_fn LAPACKE_chseqr_work;
    struct flexiblas_hook_fn LAPACKE_clacgv;
    struct flexiblas_hook_fn LAPACKE_clacgv_work;
    struct flexiblas_hook_fn LAPACKE_clacn2;
    struct flexiblas_hook_fn LAPACKE_clacn2_work;
    struct flexiblas_hook_fn LAPACKE_clacp2;
    struct flexiblas_hook_fn LAPACKE_clacp2_work;
    struct flexiblas_hook_fn LAPACKE_clacpy;
    struct flexiblas_hook_fn LAPACKE_clacpy_work;
    struct flexiblas_hook_fn LAPACKE_clacrm;
    struct flexiblas_hook_fn LAPACKE_clacrm_work;
    struct flexiblas_hook_fn LAPACKE_clag2z;
    struct flexiblas_hook_fn LAPACKE_clag2z_work;
    struct flexiblas_hook_fn LAPACKE_clagge;
    struct flexiblas_hook_fn LAPACKE_clagge_work;
    struct flexiblas_hook_fn LAPACKE_claghe;
    struct flexiblas_hook_fn LAPACKE_claghe_work;
    struct flexiblas_hook_fn LAPACKE_clagsy;
    struct flexiblas_hook_fn LAPACKE_clagsy_work;
    struct flexiblas_hook_fn LAPACKE_clangb;
    struct flexiblas_hook_fn LAPACKE_clangb_work;
    struct flexiblas_hook_fn LAPACKE_clange;
    struct flexiblas_hook_fn LAPACKE_clange_work;
    struct flexiblas_hook_fn LAPACKE_clanhe;
    struct flexiblas_hook_fn LAPACKE_clanhe_work;
    struct flexiblas_hook_fn LAPACKE_clansy;
    struct flexiblas_hook_fn LAPACKE_clansy_work;
    struct flexiblas_hook_fn LAPACKE_clantr;
    struct flexiblas_hook_fn LAPACKE_clantr_work;
    struct flexiblas_hook_fn LAPACKE_clapmr;
    struct flexiblas_hook_fn LAPACKE_clapmr_work;
    struct flexiblas_hook_fn LAPACKE_clapmt;
    struct flexiblas_hook_fn LAPACKE_clapmt_work;
    struct flexiblas_hook_fn LAPACKE_clarcm;
    struct flexiblas_hook_fn LAPACKE_clarcm_work;
    struct flexiblas_hook_fn LAPACKE_clarfb;
    struct flexiblas_hook_fn LAPACKE_clarfb_work;
    struct flexiblas_hook_fn LAPACKE_clarfg;
    struct flexiblas_hook_fn LAPACKE_clarfg_work;
    struct flexiblas_hook_fn LAPACKE_clarft;
    struct flexiblas_hook_fn LAPACKE_clarft_work;
    struct flexiblas_hook_fn LAPACKE_clarfx;
    struct flexiblas_hook_fn LAPACKE_clarfx_work;
    struct flexiblas_hook_fn LAPACKE_clarnv;
    struct flexiblas_hook_fn LAPACKE_clarnv_work;
    struct flexiblas_hook_fn LAPACKE_clascl;
    struct flexiblas_hook_fn LAPACKE_clascl_work;
    struct flexiblas_hook_fn LAPACKE_claset;
    struct flexiblas_hook_fn LAPACKE_claset_work;
    struct flexiblas_hook_fn LAPACKE_classq;
    struct flexiblas_hook_fn LAPACKE_classq_work;
    struct flexiblas_hook_fn LAPACKE_claswp;
    struct flexiblas_hook_fn LAPACKE_claswp_work;
    struct flexiblas_hook_fn LAPACKE_clatms;
    struct flexiblas_hook_fn LAPACKE_clatms_work;
    struct flexiblas_hook_fn LAPACKE_clauum;
    struct flexiblas_hook_fn LAPACKE_clauum_work;
    struct flexiblas_hook_fn LAPACKE_cpbcon;
    struct flexiblas_hook_fn LAPACKE_cpbcon_work;
    struct flexiblas_hook_fn LAPACKE_cpbequ;
    struct flexiblas_hook_fn LAPACKE_cpbequ_work;
    struct flexiblas_hook_fn LAPACKE_cpbrfs;
    struct flexiblas_hook_fn LAPACKE_cpbrfs_work;
    struct flexiblas_hook_fn LAPACKE_cpbstf;
    struct flexiblas_hook_fn LAPACKE_cpbstf_work;
    struct flexiblas_hook_fn LAPACKE_cpbsv;
    struct flexiblas_hook_fn LAPACKE_cpbsv_work;
    struct flexiblas_hook_fn LAPACKE_cpbsvx;
    struct flexiblas_hook_fn LAPACKE_cpbsvx_work;
    struct flexiblas_hook_fn LAPACKE_cpbtrf;
    struct flexiblas_hook_fn LAPACKE_cpbtrf_work;
    struct flexiblas_hook_fn LAPACKE_cpbtrs;
    struct flexiblas_hook_fn LAPACKE_cpbtrs_work;
    struct flexiblas_hook_fn LAPACKE_cpftrf;
    struct flexiblas_hook_fn LAPACKE_cpftrf_work;
    struct flexiblas_hook_fn LAPACKE_cpftri;
    struct flexiblas_hook_fn LAPACKE_cpftri_work;
    struct flexiblas_hook_fn LAPACKE_cpftrs;
    struct flexiblas_hook_fn LAPACKE_cpftrs_work;
    struct flexiblas_hook_fn LAPACKE_cpocon;
    struct flexiblas_hook_fn LAPACKE_cpocon_work;
    struct flexiblas_hook_fn LAPACKE_cpoequ;
    struct flexiblas_hook_fn LAPACKE_cpoequ_work;
    struct flexiblas_hook_fn LAPACKE_cpoequb;
    struct flexiblas_hook_fn LAPACKE_cpoequb_work;
    struct flexiblas_hook_fn LAPACKE_cporfs;
    struct flexiblas_hook_fn LAPACKE_cporfs_work;
    struct flexiblas_hook_fn LAPACKE_cporfsx;
    struct flexiblas_hook_fn LAPACKE_cporfsx_work;
    struct flexiblas_hook_fn LAPACKE_cposv;
    struct flexiblas_hook_fn LAPACKE_cposv_work;
    struct flexiblas_hook_fn LAPACKE_cposvx;
    struct flexiblas_hook_fn LAPACKE_cposvx_work;
    struct flexiblas_hook_fn LAPACKE_cposvxx;
    struct flexiblas_hook_fn LAPACKE_cposvxx_work;
    struct flexiblas_hook_fn LAPACKE_cpotrf;
    struct flexiblas_hook_fn LAPACKE_cpotrf2;
    struct flexiblas_hook_fn LAPACKE_cpotrf2_work;
    struct flexiblas_hook_fn LAPACKE_cpotrf_work;
    struct flexiblas_hook_fn LAPACKE_cpotri;
    struct flexiblas_hook_fn LAPACKE_cpotri_work;
    struct flexiblas_hook_fn LAPACKE_cpotrs;
    struct flexiblas_hook_fn LAPACKE_cpotrs_work;
    struct flexiblas_hook_fn LAPACKE_cppcon;
    struct flexiblas_hook_fn LAPACKE_cppcon_work;
    struct flexiblas_hook_fn LAPACKE_cppequ;
    struct flexiblas_hook_fn LAPACKE_cppequ_work;
    struct flexiblas_hook_fn LAPACKE_cpprfs;
    struct flexiblas_hook_fn LAPACKE_cpprfs_work;
    struct flexiblas_hook_fn LAPACKE_cppsv;
    struct flexiblas_hook_fn LAPACKE_cppsv_work;
    struct flexiblas_hook_fn LAPACKE_cppsvx;
    struct flexiblas_hook_fn LAPACKE_cppsvx_work;
    struct flexiblas_hook_fn LAPACKE_cpptrf;
    struct flexiblas_hook_fn LAPACKE_cpptrf_work;
    struct flexiblas_hook_fn LAPACKE_cpptri;
    struct flexiblas_hook_fn LAPACKE_cpptri_work;
    struct flexiblas_hook_fn LAPACKE_cpptrs;
    struct flexiblas_hook_fn LAPACKE_cpptrs_work;
    struct flexiblas_hook_fn LAPACKE_cpstrf;
    struct flexiblas_hook_fn LAPACKE_cpstrf_work;
    struct flexiblas_hook_fn LAPACKE_cptcon;
    struct flexiblas_hook_fn LAPACKE_cptcon_work;
    struct flexiblas_hook_fn LAPACKE_cpteqr;
    struct flexiblas_hook_fn LAPACKE_cpteqr_work;
    struct flexiblas_hook_fn LAPACKE_cptrfs;
    struct flexiblas_hook_fn LAPACKE_cptrfs_work;
    struct flexiblas_hook_fn LAPACKE_cptsv;
    struct flexiblas_hook_fn LAPACKE_cptsv_work;
    struct flexiblas_hook_fn LAPACKE_cptsvx;
    struct flexiblas_hook_fn LAPACKE_cptsvx_work;
    struct flexiblas_hook_fn LAPACKE_cpttrf;
    struct flexiblas_hook_fn LAPACKE_cpttrf_work;
    struct flexiblas_hook_fn LAPACKE_cpttrs;
    struct flexiblas_hook_fn LAPACKE_cpttrs_work;
    struct flexiblas_hook_fn LAPACKE_cspcon;
    struct flexiblas_hook_fn LAPACKE_cspcon_work;
    struct flexiblas_hook_fn LAPACKE_csprfs;
    struct flexiblas_hook_fn LAPACKE_csprfs_work;
    struct flexiblas_hook_fn LAPACKE_cspsv;
    struct flexiblas_hook_fn LAPACKE_cspsv_work;
    struct flexiblas_hook_fn LAPACKE_cspsvx;
    struct flexiblas_hook_fn LAPACKE_cspsvx_work;
    struct flexiblas_hook_fn LAPACKE_csptrf;
    struct flexiblas_hook_fn LAPACKE_csptrf_work;
    struct flexiblas_hook_fn LAPACKE_csptri;
    struct flexiblas_hook_fn LAPACKE_csptri_work;
    struct flexiblas_hook_fn LAPACKE_csptrs;
    struct flexiblas_hook_fn LAPACKE_csptrs_work;
    struct flexiblas_hook_fn LAPACKE_cstedc;
    struct flexiblas_hook_fn LAPACKE_cstedc_work;
    struct flexiblas_hook_fn LAPACKE_cstegr;
    struct flexiblas_hook_fn LAPACKE_cstegr_work;
    struct flexiblas_hook_fn LAPACKE_cstein;
    struct flexiblas_hook_fn LAPACKE_cstein_work;
    struct flexiblas_hook_fn LAPACKE_cstemr;
    struct flexiblas_hook_fn LAPACKE_cstemr_work;
    struct flexiblas_hook_fn LAPACKE_csteqr;
    struct flexiblas_hook_fn LAPACKE_csteqr_work;
    struct flexiblas_hook_fn LAPACKE_csycon;
    struct flexiblas_hook_fn LAPACKE_csycon_3;
    struct flexiblas_hook_fn LAPACKE_csycon_3_work;
    struct flexiblas_hook_fn LAPACKE_csycon_work;
    struct flexiblas_hook_fn LAPACKE_csyconv;
    struct flexiblas_hook_fn LAPACKE_csyconv_work;
    struct flexiblas_hook_fn LAPACKE_csyequb;
    struct flexiblas_hook_fn LAPACKE_csyequb_work;
    struct flexiblas_hook_fn LAPACKE_csyr;
    struct flexiblas_hook_fn LAPACKE_csyr_work;
    struct flexiblas_hook_fn LAPACKE_csyrfs;
    struct flexiblas_hook_fn LAPACKE_csyrfs_work;
    struct flexiblas_hook_fn LAPACKE_csyrfsx;
    struct flexiblas_hook_fn LAPACKE_csyrfsx_work;
    struct flexiblas_hook_fn LAPACKE_csysv;
    struct flexiblas_hook_fn LAPACKE_csysv_aa;
    struct flexiblas_hook_fn LAPACKE_csysv_aa_2stage;
    struct flexiblas_hook_fn LAPACKE_csysv_aa_2stage_work;
    struct flexiblas_hook_fn LAPACKE_csysv_aa_work;
    struct flexiblas_hook_fn LAPACKE_csysv_rk;
    struct flexiblas_hook_fn LAPACKE_csysv_rk_work;
    struct flexiblas_hook_fn LAPACKE_csysv_rook;
    struct flexiblas_hook_fn LAPACKE_csysv_rook_work;
    struct flexiblas_hook_fn LAPACKE_csysv_work;
    struct flexiblas_hook_fn LAPACKE_csysvx;
    struct flexiblas_hook_fn LAPACKE_csysvx_work;
    struct flexiblas_hook_fn LAPACKE_csysvxx;
    struct flexiblas_hook_fn LAPACKE_csysvxx_work;
    struct flexiblas_hook_fn LAPACKE_csyswapr;
    struct flexiblas_hook_fn LAPACKE_csyswapr_work;
    struct flexiblas_hook_fn LAPACKE_csytrf;
    struct flexiblas_hook_fn LAPACKE_csytrf_aa;
    struct flexiblas_hook_fn LAPACKE_csytrf_aa_2stage;
    struct flexiblas_hook_fn LAPACKE_csytrf_aa_2stage_work;
    struct flexiblas_hook_fn LAPACKE_csytrf_aa_work;
    struct flexiblas_hook_fn LAPACKE_csytrf_rk;
    struct flexiblas_hook_fn LAPACKE_csytrf_rk_work;
    struct flexiblas_hook_fn LAPACKE_csytrf_rook;
    struct flexiblas_hook_fn LAPACKE_csytrf_rook_work;
    struct flexiblas_hook_fn LAPACKE_csytrf_work;
    struct flexiblas_hook_fn LAPACKE_csytri;
    struct flexiblas_hook_fn LAPACKE_csytri2;
    struct flexiblas_hook_fn LAPACKE_csytri2_work;
    struct flexiblas_hook_fn LAPACKE_csytri2x;
    struct flexiblas_hook_fn LAPACKE_csytri2x_work;
    struct flexiblas_hook_fn LAPACKE_csytri_3;
    struct flexiblas_hook_fn LAPACKE_csytri_3_work;
    struct flexiblas_hook_fn LAPACKE_csytri_work;
    struct flexiblas_hook_fn LAPACKE_csytrs;
    struct flexiblas_hook_fn LAPACKE_csytrs2;
    struct flexiblas_hook_fn LAPACKE_csytrs2_work;
    struct flexiblas_hook_fn LAPACKE_csytrs_3;
    struct flexiblas_hook_fn LAPACKE_csytrs_3_work;
    struct flexiblas_hook_fn LAPACKE_csytrs_aa;
    struct flexiblas_hook_fn LAPACKE_csytrs_aa_2stage;
    struct flexiblas_hook_fn LAPACKE_csytrs_aa_2stage_work;
    struct flexiblas_hook_fn LAPACKE_csytrs_aa_work;
    struct flexiblas_hook_fn LAPACKE_csytrs_rook;
    struct flexiblas_hook_fn LAPACKE_csytrs_rook_work;
    struct flexiblas_hook_fn LAPACKE_csytrs_work;
    struct flexiblas_hook_fn LAPACKE_ctbcon;
    struct flexiblas_hook_fn LAPACKE_ctbcon_work;
    struct flexiblas_hook_fn LAPACKE_ctbrfs;
    struct flexiblas_hook_fn LAPACKE_ctbrfs_work;
    struct flexiblas_hook_fn LAPACKE_ctbtrs;
    struct flexiblas_hook_fn LAPACKE_ctbtrs_work;
    struct flexiblas_hook_fn LAPACKE_ctfsm;
    struct flexiblas_hook_fn LAPACKE_ctfsm_work;
    struct flexiblas_hook_fn LAPACKE_ctftri;
    struct flexiblas_hook_fn LAPACKE_ctftri_work;
    struct flexiblas_hook_fn LAPACKE_ctfttp;
    struct flexiblas_hook_fn LAPACKE_ctfttp_work;
    struct flexiblas_hook_fn LAPACKE_ctfttr;
    struct flexiblas_hook_fn LAPACKE_ctfttr_work;
    struct flexiblas_hook_fn LAPACKE_ctgevc;
    struct flexiblas_hook_fn LAPACKE_ctgevc_work;
    struct flexiblas_hook_fn LAPACKE_ctgexc;
    struct flexiblas_hook_fn LAPACKE_ctgexc_work;
    struct flexiblas_hook_fn LAPACKE_ctgsen;
    struct flexiblas_hook_fn LAPACKE_ctgsen_work;
    struct flexiblas_hook_fn LAPACKE_ctgsja;
    struct flexiblas_hook_fn LAPACKE_ctgsja_work;
    struct flexiblas_hook_fn LAPACKE_ctgsna;
    struct flexiblas_hook_fn LAPACKE_ctgsna_work;
    struct flexiblas_hook_fn LAPACKE_ctgsyl;
    struct flexiblas_hook_fn LAPACKE_ctgsyl_work;
    struct flexiblas_hook_fn LAPACKE_ctpcon;
    struct flexiblas_hook_fn LAPACKE_ctpcon_work;
    struct flexiblas_hook_fn LAPACKE_ctpmqrt;
    struct flexiblas_hook_fn LAPACKE_ctpmqrt_work;
    struct flexiblas_hook_fn LAPACKE_ctpqrt;
    struct flexiblas_hook_fn LAPACKE_ctpqrt2;
    struct flexiblas_hook_fn LAPACKE_ctpqrt2_work;
    struct flexiblas_hook_fn LAPACKE_ctpqrt_work;
    struct flexiblas_hook_fn LAPACKE_ctprfb;
    struct flexiblas_hook_fn LAPACKE_ctprfb_work;
    struct flexiblas_hook_fn LAPACKE_ctprfs;
    struct flexiblas_hook_fn LAPACKE_ctprfs_work;
    struct flexiblas_hook_fn LAPACKE_ctptri;
    struct flexiblas_hook_fn LAPACKE_ctptri_work;
    struct flexiblas_hook_fn LAPACKE_ctptrs;
    struct flexiblas_hook_fn LAPACKE_ctptrs_work;
    struct flexiblas_hook_fn LAPACKE_ctpttf;
    struct flexiblas_hook_fn LAPACKE_ctpttf_work;
    struct flexiblas_hook_fn LAPACKE_ctpttr;
    struct flexiblas_hook_fn LAPACKE_ctpttr_work;
    struct flexiblas_hook_fn LAPACKE_ctrcon;
    struct flexiblas_hook_fn LAPACKE_ctrcon_work;
    struct flexiblas_hook_fn LAPACKE_ctrevc;
    struct flexiblas_hook_fn LAPACKE_ctrevc_work;
    struct flexiblas_hook_fn LAPACKE_ctrexc;
    struct flexiblas_hook_fn LAPACKE_ctrexc_work;
    struct flexiblas_hook_fn LAPACKE_ctrrfs;
    struct flexiblas_hook_fn LAPACKE_ctrrfs_work;
    struct flexiblas_hook_fn LAPACKE_ctrsen;
    struct flexiblas_hook_fn LAPACKE_ctrsen_work;
    struct flexiblas_hook_fn LAPACKE_ctrsna;
    struct flexiblas_hook_fn LAPACKE_ctrsna_work;
    struct flexiblas_hook_fn LAPACKE_ctrsyl;
    struct flexiblas_hook_fn LAPACKE_ctrsyl3_work;
    struct flexiblas_hook_fn LAPACKE_ctrsyl_work;
    struct flexiblas_hook_fn LAPACKE_ctrtri;
    struct flexiblas_hook_fn LAPACKE_ctrtri_work;
    struct flexiblas_hook_fn LAPACKE_ctrtrs;
    struct flexiblas_hook_fn LAPACKE_ctrtrs_work;
    struct flexiblas_hook_fn LAPACKE_ctrttf;
    struct flexiblas_hook_fn LAPACKE_ctrttf_work;
    struct flexiblas_hook_fn LAPACKE_ctrttp;
    struct flexiblas_hook_fn LAPACKE_ctrttp_work;
    struct flexiblas_hook_fn LAPACKE_ctzrzf;
    struct flexiblas_hook_fn LAPACKE_ctzrzf_work;
    struct flexiblas_hook_fn LAPACKE_cunbdb;
    struct flexiblas_hook_fn LAPACKE_cunbdb_work;
    struct flexiblas_hook_fn LAPACKE_cuncsd;
    struct flexiblas_hook_fn LAPACKE_cuncsd2by1;
    struct flexiblas_hook_fn LAPACKE_cuncsd2by1_work;
    struct flexiblas_hook_fn LAPACKE_cuncsd_work;
    struct flexiblas_hook_fn LAPACKE_cungbr;
    struct flexiblas_hook_fn LAPACKE_cungbr_work;
    struct flexiblas_hook_fn LAPACKE_cunghr;
    struct flexiblas_hook_fn LAPACKE_cunghr_work;
    struct flexiblas_hook_fn LAPACKE_cunglq;
    struct flexiblas_hook_fn LAPACKE_cunglq_work;
    struct flexiblas_hook_fn LAPACKE_cungql;
    struct flexiblas_hook_fn LAPACKE_cungql_work;
    struct flexiblas_hook_fn LAPACKE_cungqr;
    struct flexiblas_hook_fn LAPACKE_cungqr_work;
    struct flexiblas_hook_fn LAPACKE_cungrq;
    struct flexiblas_hook_fn LAPACKE_cungrq_work;
    struct flexiblas_hook_fn LAPACKE_cungtr;
    struct flexiblas_hook_fn LAPACKE_cungtr_work;
    struct flexiblas_hook_fn LAPACKE_cungtsqr_row;
    struct flexiblas_hook_fn LAPACKE_cungtsqr_row_work;
    struct flexiblas_hook_fn LAPACKE_cunhr_col;
    struct flexiblas_hook_fn LAPACKE_cunhr_col_work;
    struct flexiblas_hook_fn LAPACKE_cunmbr;
    struct flexiblas_hook_fn LAPACKE_cunmbr_work;
    struct flexiblas_hook_fn LAPACKE_cunmhr;
    struct flexiblas_hook_fn LAPACKE_cunmhr_work;
    struct flexiblas_hook_fn LAPACKE_cunmlq;
    struct flexiblas_hook_fn LAPACKE_cunmlq_work;
    struct flexiblas_hook_fn LAPACKE_cunmql;
    struct flexiblas_hook_fn LAPACKE_cunmql_work;
    struct flexiblas_hook_fn LAPACKE_cunmqr;
    struct flexiblas_hook_fn LAPACKE_cunmqr_work;
    struct flexiblas_hook_fn LAPACKE_cunmrq;
    struct flexiblas_hook_fn LAPACKE_cunmrq_work;
    struct flexiblas_hook_fn LAPACKE_cunmrz;
    struct flexiblas_hook_fn LAPACKE_cunmrz_work;
    struct flexiblas_hook_fn LAPACKE_cunmtr;
    struct flexiblas_hook_fn LAPACKE_cunmtr_work;
    struct flexiblas_hook_fn LAPACKE_cupgtr;
    struct flexiblas_hook_fn LAPACKE_cupgtr_work;
    struct flexiblas_hook_fn LAPACKE_cupmtr;
    struct flexiblas_hook_fn LAPACKE_cupmtr_work;
    struct flexiblas_hook_fn LAPACKE_dbbcsd;
    struct flexiblas_hook_fn LAPACKE_dbbcsd_work;
    struct flexiblas_hook_fn LAPACKE_dbdsdc;
    struct flexiblas_hook_fn LAPACKE_dbdsdc_work;
    struct flexiblas_hook_fn LAPACKE_dbdsqr;
    struct flexiblas_hook_fn LAPACKE_dbdsqr_work;
    struct flexiblas_hook_fn LAPACKE_dbdsvdx;
    struct flexiblas_hook_fn LAPACKE_dbdsvdx_work;
    struct flexiblas_hook_fn LAPACKE_ddisna;
    struct flexiblas_hook_fn LAPACKE_ddisna_work;
    struct flexiblas_hook_fn LAPACKE_dgbbrd;
    struct flexiblas_hook_fn LAPACKE_dgbbrd_work;
    struct flexiblas_hook_fn LAPACKE_dgbcon;
    struct flexiblas_hook_fn LAPACKE_dgbcon_work;
    struct flexiblas_hook_fn LAPACKE_dgbequ;
    struct flexiblas_hook_fn LAPACKE_dgbequ_work;
    struct flexiblas_hook_fn LAPACKE_dgbequb;
    struct flexiblas_hook_fn LAPACKE_dgbequb_work;
    struct flexiblas_hook_fn LAPACKE_dgbrfs;
    struct flexiblas_hook_fn LAPACKE_dgbrfs_work;
    struct flexiblas_hook_fn LAPACKE_dgbrfsx;
    struct flexiblas_hook_fn LAPACKE_dgbrfsx_work;
    struct flexiblas_hook_fn LAPACKE_dgbsv;
    struct flexiblas_hook_fn LAPACKE_dgbsv_work;
    struct flexiblas_hook_fn LAPACKE_dgbsvx;
    struct flexiblas_hook_fn LAPACKE_dgbsvx_work;
    struct flexiblas_hook_fn LAPACKE_dgbsvxx;
    struct flexiblas_hook_fn LAPACKE_dgbsvxx_work;
    struct flexiblas_hook_fn LAPACKE_dgbtrf;
    struct flexiblas_hook_fn LAPACKE_dgbtrf_work;
    struct flexiblas_hook_fn LAPACKE_dgbtrs;
    struct flexiblas_hook_fn LAPACKE_dgbtrs_work;
    struct flexiblas_hook_fn LAPACKE_dgebak;
    struct flexiblas_hook_fn LAPACKE_dgebak_work;
    struct flexiblas_hook_fn LAPACKE_dgebal;
    struct flexiblas_hook_fn LAPACKE_dgebal_work;
    struct flexiblas_hook_fn LAPACKE_dgebrd;
    struct flexiblas_hook_fn LAPACKE_dgebrd_work;
    struct flexiblas_hook_fn LAPACKE_dgecon;
    struct flexiblas_hook_fn LAPACKE_dgecon_work;
    struct flexiblas_hook_fn LAPACKE_dgedmd_work;
    struct flexiblas_hook_fn LAPACKE_dgedmdq_work;
    struct flexiblas_hook_fn LAPACKE_dgeequ;
    struct flexiblas_hook_fn LAPACKE_dgeequ_work;
    struct flexiblas_hook_fn LAPACKE_dgeequb;
    struct flexiblas_hook_fn LAPACKE_dgeequb_work;
    struct flexiblas_hook_fn LAPACKE_dgees;
    struct flexiblas_hook_fn LAPACKE_dgees_work;
    struct flexiblas_hook_fn LAPACKE_dgeesx;
    struct flexiblas_hook_fn LAPACKE_dgeesx_work;
    struct flexiblas_hook_fn LAPACKE_dgeev;
    struct flexiblas_hook_fn LAPACKE_dgeev_work;
    struct flexiblas_hook_fn LAPACKE_dgeevx;
    struct flexiblas_hook_fn LAPACKE_dgeevx_work;
    struct flexiblas_hook_fn LAPACKE_dgehrd;
    struct flexiblas_hook_fn LAPACKE_dgehrd_work;
    struct flexiblas_hook_fn LAPACKE_dgejsv;
    struct flexiblas_hook_fn LAPACKE_dgejsv_work;
    struct flexiblas_hook_fn LAPACKE_dgelq;
    struct flexiblas_hook_fn LAPACKE_dgelq2;
    struct flexiblas_hook_fn LAPACKE_dgelq2_work;
    struct flexiblas_hook_fn LAPACKE_dgelq_work;
    struct flexiblas_hook_fn LAPACKE_dgelqf;
    struct flexiblas_hook_fn LAPACKE_dgelqf_work;
    struct flexiblas_hook_fn LAPACKE_dgels;
    struct flexiblas_hook_fn LAPACKE_dgels_work;
    struct flexiblas_hook_fn LAPACKE_dgelsd;
    struct flexiblas_hook_fn LAPACKE_dgelsd_work;
    struct flexiblas_hook_fn LAPACKE_dgelss;
    struct flexiblas_hook_fn LAPACKE_dgelss_work;
    struct flexiblas_hook_fn LAPACKE_dgelsy;
    struct flexiblas_hook_fn LAPACKE_dgelsy_work;
    struct flexiblas_hook_fn LAPACKE_dgemlq;
    struct flexiblas_hook_fn LAPACKE_dgemlq_work;
    struct flexiblas_hook_fn LAPACKE_dgemqr;
    struct flexiblas_hook_fn LAPACKE_dgemqr_work;
    struct flexiblas_hook_fn LAPACKE_dgemqrt;
    struct flexiblas_hook_fn LAPACKE_dgemqrt_work;
    struct flexiblas_hook_fn LAPACKE_dgeqlf;
    struct flexiblas_hook_fn LAPACKE_dgeqlf_work;
    struct flexiblas_hook_fn LAPACKE_dgeqp3;
    struct flexiblas_hook_fn LAPACKE_dgeqp3_work;
    struct flexiblas_hook_fn LAPACKE_dgeqpf;
    struct flexiblas_hook_fn LAPACKE_dgeqpf_work;
    struct flexiblas_hook_fn LAPACKE_dgeqr;
    struct flexiblas_hook_fn LAPACKE_dgeqr2;
    struct flexiblas_hook_fn LAPACKE_dgeqr2_work;
    struct flexiblas_hook_fn LAPACKE_dgeqr_work;
    struct flexiblas_hook_fn LAPACKE_dgeqrf;
    struct flexiblas_hook_fn LAPACKE_dgeqrf_work;
    struct flexiblas_hook_fn LAPACKE_dgeqrfp;
    struct flexiblas_hook_fn LAPACKE_dgeqrfp_work;
    struct flexiblas_hook_fn LAPACKE_dgeqrt;
    struct flexiblas_hook_fn LAPACKE_dgeqrt2;
    struct flexiblas_hook_fn LAPACKE_dgeqrt2_work;
    struct flexiblas_hook_fn LAPACKE_dgeqrt3;
    struct flexiblas_hook_fn LAPACKE_dgeqrt3_work;
    struct flexiblas_hook_fn LAPACKE_dgeqrt_work;
    struct flexiblas_hook_fn LAPACKE_dgerfs;
    struct flexiblas_hook_fn LAPACKE_dgerfs_work;
    struct flexiblas_hook_fn LAPACKE_dgerfsx;
    struct flexiblas_hook_fn LAPACKE_dgerfsx_work;
    struct flexiblas_hook_fn LAPACKE_dgerqf;
    struct flexiblas_hook_fn LAPACKE_dgerqf_work;
    struct flexiblas_hook_fn LAPACKE_dgesdd;
    struct flexiblas_hook_fn LAPACKE_dgesdd_work;
    struct flexiblas_hook_fn LAPACKE_dgesv;
    struct flexiblas_hook_fn LAPACKE_dgesv_work;
    struct flexiblas_hook_fn LAPACKE_dgesvd;
    struct flexiblas_hook_fn LAPACKE_dgesvd_work;
    struct flexiblas_hook_fn LAPACKE_dgesvdq;
    struct flexiblas_hook_fn LAPACKE_dgesvdq_work;
    struct flexiblas_hook_fn LAPACKE_dgesvdx;
    struct flexiblas_hook_fn LAPACKE_dgesvdx_work;
    struct flexiblas_hook_fn LAPACKE_dgesvj;
    struct flexiblas_hook_fn LAPACKE_dgesvj_work;
    struct flexiblas_hook_fn LAPACKE_dgesvx;
    struct flexiblas_hook_fn LAPACKE_dgesvx_work;
    struct flexiblas_hook_fn LAPACKE_dgesvxx;
    struct flexiblas_hook_fn LAPACKE_dgesvxx_work;
    struct flexiblas_hook_fn LAPACKE_dgetf2;
    struct flexiblas_hook_fn LAPACKE_dgetf2_work;
    struct flexiblas_hook_fn LAPACKE_dgetrf;
    struct flexiblas_hook_fn LAPACKE_dgetrf2;
    struct flexiblas_hook_fn LAPACKE_dgetrf2_work;
    struct flexiblas_hook_fn LAPACKE_dgetrf_work;
    struct flexiblas_hook_fn LAPACKE_dgetri;
    struct flexiblas_hook_fn LAPACKE_dgetri_work;
    struct flexiblas_hook_fn LAPACKE_dgetrs;
    struct flexiblas_hook_fn LAPACKE_dgetrs_work;
    struct flexiblas_hook_fn LAPACKE_dgetsls;
    struct flexiblas_hook_fn LAPACKE_dgetsls_work;
    struct flexiblas_hook_fn LAPACKE_dgetsqrhrt;
    struct flexiblas_hook_fn LAPACKE_dgetsqrhrt_work;
    struct flexiblas_hook_fn LAPACKE_dggbak;
    struct flexiblas_hook_fn LAPACKE_dggbak_work;
    struct flexiblas_hook_fn LAPACKE_dggbal;
    struct flexiblas_hook_fn LAPACKE_dggbal_work;
    struct flexiblas_hook_fn LAPACKE_dgges;
    struct flexiblas_hook_fn LAPACKE_dgges3;
    struct flexiblas_hook_fn LAPACKE_dgges3_work;
    struct flexiblas_hook_fn LAPACKE_dgges_work;
    struct flexiblas_hook_fn LAPACKE_dggesx;
    struct flexiblas_hook_fn LAPACKE_dggesx_work;
    struct flexiblas_hook_fn LAPACKE_dggev;
    struct flexiblas_hook_fn LAPACKE_dggev3;
    struct flexiblas_hook_fn LAPACKE_dggev3_work;
    struct flexiblas_hook_fn LAPACKE_dggev_work;
    struct flexiblas_hook_fn LAPACKE_dggevx;
    struct flexiblas_hook_fn LAPACKE_dggevx_work;
    struct flexiblas_hook_fn LAPACKE_dggglm;
    struct flexiblas_hook_fn LAPACKE_dggglm_work;
    struct flexiblas_hook_fn LAPACKE_dgghd3;
    struct flexiblas_hook_fn LAPACKE_dgghd3_work;
    struct flexiblas_hook_fn LAPACKE_dgghrd;
    struct flexiblas_hook_fn LAPACKE_dgghrd_work;
    struct flexiblas_hook_fn LAPACKE_dgglse;
    struct flexiblas_hook_fn LAPACKE_dgglse_work;
    struct flexiblas_hook_fn LAPACKE_dggqrf;
    struct flexiblas_hook_fn LAPACKE_dggqrf_work;
    struct flexiblas_hook_fn LAPACKE_dggrqf;
    struct flexiblas_hook_fn LAPACKE_dggrqf_work;
    struct flexiblas_hook_fn LAPACKE_dggsvd;
    struct flexiblas_hook_fn LAPACKE_dggsvd3;
    struct flexiblas_hook_fn LAPACKE_dggsvd3_work;
    struct flexiblas_hook_fn LAPACKE_dggsvd_work;
    struct flexiblas_hook_fn LAPACKE_dggsvp;
    struct flexiblas_hook_fn LAPACKE_dggsvp3;
    struct flexiblas_hook_fn LAPACKE_dggsvp3_work;
    struct flexiblas_hook_fn LAPACKE_dggsvp_work;
    struct flexiblas_hook_fn LAPACKE_dgtcon;
    struct flexiblas_hook_fn LAPACKE_dgtcon_work;
    struct flexiblas_hook_fn LAPACKE_dgtrfs;
    struct flexiblas_hook_fn LAPACKE_dgtrfs_work;
    struct flexiblas_hook_fn LAPACKE_dgtsv;
    struct flexiblas_hook_fn LAPACKE_dgtsv_work;
    struct flexiblas_hook_fn LAPACKE_dgtsvx;
    struct flexiblas_hook_fn LAPACKE_dgtsvx_work;
    struct flexiblas_hook_fn LAPACKE_dgttrf;
    struct flexiblas_hook_fn LAPACKE_dgttrf_work;
    struct flexiblas_hook_fn LAPACKE_dgttrs;
    struct flexiblas_hook_fn LAPACKE_dgttrs_work;
    struct flexiblas_hook_fn LAPACKE_dhgeqz;
    struct flexiblas_hook_fn LAPACKE_dhgeqz_work;
    struct flexiblas_hook_fn LAPACKE_dhsein;
    struct flexiblas_hook_fn LAPACKE_dhsein_work;
    struct flexiblas_hook_fn LAPACKE_dhseqr;
    struct flexiblas_hook_fn LAPACKE_dhseqr_work;
    struct flexiblas_hook_fn LAPACKE_dlacn2;
    struct flexiblas_hook_fn LAPACKE_dlacn2_work;
    struct flexiblas_hook_fn LAPACKE_dlacpy;
    struct flexiblas_hook_fn LAPACKE_dlacpy_work;
    struct flexiblas_hook_fn LAPACKE_dlag2s;
    struct flexiblas_hook_fn LAPACKE_dlag2s_work;
    struct flexiblas_hook_fn LAPACKE_dlagge;
    struct flexiblas_hook_fn LAPACKE_dlagge_work;
    struct flexiblas_hook_fn LAPACKE_dlagsy;
    struct flexiblas_hook_fn LAPACKE_dlagsy_work;
    struct flexiblas_hook_fn LAPACKE_dlamch;
    struct flexiblas_hook_fn LAPACKE_dlamch_work;
    struct flexiblas_hook_fn LAPACKE_dlangb;
    struct flexiblas_hook_fn LAPACKE_dlangb_work;
    struct flexiblas_hook_fn LAPACKE_dlange;
    struct flexiblas_hook_fn LAPACKE_dlange_work;
    struct flexiblas_hook_fn LAPACKE_dlansy;
    struct flexiblas_hook_fn LAPACKE_dlansy_work;
    struct flexiblas_hook_fn LAPACKE_dlantr;
    struct flexiblas_hook_fn LAPACKE_dlantr_work;
    struct flexiblas_hook_fn LAPACKE_dlapmr;
    struct flexiblas_hook_fn LAPACKE_dlapmr_work;
    struct flexiblas_hook_fn LAPACKE_dlapmt;
    struct flexiblas_hook_fn LAPACKE_dlapmt_work;
    struct flexiblas_hook_fn LAPACKE_dlapy2;
    struct flexiblas_hook_fn LAPACKE_dlapy2_work;
    struct flexiblas_hook_fn LAPACKE_dlapy3;
    struct flexiblas_hook_fn LAPACKE_dlapy3_work;
    struct flexiblas_hook_fn LAPACKE_dlarfb;
    struct flexiblas_hook_fn LAPACKE_dlarfb_work;
    struct flexiblas_hook_fn LAPACKE_dlarfg;
    struct flexiblas_hook_fn LAPACKE_dlarfg_work;
    struct flexiblas_hook_fn LAPACKE_dlarft;
    struct flexiblas_hook_fn LAPACKE_dlarft_work;
    struct flexiblas_hook_fn LAPACKE_dlarfx;
    struct flexiblas_hook_fn LAPACKE_dlarfx_work;
    struct flexiblas_hook_fn LAPACKE_dlarnv;
    struct flexiblas_hook_fn LAPACKE_dlarnv_work;
    struct flexiblas_hook_fn LAPACKE_dlartgp;
    struct flexiblas_hook_fn LAPACKE_dlartgp_work;
    struct flexiblas_hook_fn LAPACKE_dlartgs;
    struct flexiblas_hook_fn LAPACKE_dlartgs_work;
    struct flexiblas_hook_fn LAPACKE_dlascl;
    struct flexiblas_hook_fn LAPACKE_dlascl_work;
    struct flexiblas_hook_fn LAPACKE_dlaset;
    struct flexiblas_hook_fn LAPACKE_dlaset_work;
    struct flexiblas_hook_fn LAPACKE_dlasrt;
    struct flexiblas_hook_fn LAPACKE_dlasrt_work;
    struct flexiblas_hook_fn LAPACKE_dlassq;
    struct flexiblas_hook_fn LAPACKE_dlassq_work;
    struct flexiblas_hook_fn LAPACKE_dlaswp;
    struct flexiblas_hook_fn LAPACKE_dlaswp_work;
    struct flexiblas_hook_fn LAPACKE_dlatms;
    struct flexiblas_hook_fn LAPACKE_dlatms_work;
    struct flexiblas_hook_fn LAPACKE_dlauum;
    struct flexiblas_hook_fn LAPACKE_dlauum_work;
    struct flexiblas_hook_fn LAPACKE_dopgtr;
    struct flexiblas_hook_fn LAPACKE_dopgtr_work;
    struct flexiblas_hook_fn LAPACKE_dopmtr;
    struct flexiblas_hook_fn LAPACKE_dopmtr_work;
    struct flexiblas_hook_fn LAPACKE_dorbdb;
    struct flexiblas_hook_fn LAPACKE_dorbdb_work;
    struct flexiblas_hook_fn LAPACKE_dorcsd;
    struct flexiblas_hook_fn LAPACKE_dorcsd2by1;
    struct flexiblas_hook_fn LAPACKE_dorcsd2by1_work;
    struct flexiblas_hook_fn LAPACKE_dorcsd_work;
    struct flexiblas_hook_fn LAPACKE_dorgbr;
    struct flexiblas_hook_fn LAPACKE_dorgbr_work;
    struct flexiblas_hook_fn LAPACKE_dorghr;
    struct flexiblas_hook_fn LAPACKE_dorghr_work;
    struct flexiblas_hook_fn LAPACKE_dorglq;
    struct flexiblas_hook_fn LAPACKE_dorglq_work;
    struct flexiblas_hook_fn LAPACKE_dorgql;
    struct flexiblas_hook_fn LAPACKE_dorgql_work;
    struct flexiblas_hook_fn LAPACKE_dorgqr;
    struct flexiblas_hook_fn LAPACKE_dorgqr_work;
    struct flexiblas_hook_fn LAPACKE_dorgrq;
    struct flexiblas_hook_fn LAPACKE_dorgrq_work;
    struct flexiblas_hook_fn LAPACKE_dorgtr;
    struct flexiblas_hook_fn LAPACKE_dorgtr_work;
    struct flexiblas_hook_fn LAPACKE_dorgtsqr_row;
    struct flexiblas_hook_fn LAPACKE_dorgtsqr_row_work;
    struct flexiblas_hook_fn LAPACKE_dorhr_col;
    struct flexiblas_hook_fn LAPACKE_dorhr_col_work;
    struct flexiblas_hook_fn LAPACKE_dormbr;
    struct flexiblas_hook_fn LAPACKE_dormbr_work;
    struct flexiblas_hook_fn LAPACKE_dormhr;
    struct flexiblas_hook_fn LAPACKE_dormhr_work;
    struct flexiblas_hook_fn LAPACKE_dormlq;
    struct flexiblas_hook_fn LAPACKE_dormlq_work;
    struct flexiblas_hook_fn LAPACKE_dormql;
    struct flexiblas_hook_fn LAPACKE_dormql_work;
    struct flexiblas_hook_fn LAPACKE_dormqr;
    struct flexiblas_hook_fn LAPACKE_dormqr_work;
    struct flexiblas_hook_fn LAPACKE_dormrq;
    struct flexiblas_hook_fn LAPACKE_dormrq_work;
    struct flexiblas_hook_fn LAPACKE_dormrz;
    struct flexiblas_hook_fn LAPACKE_dormrz_work;
    struct flexiblas_hook_fn LAPACKE_dormtr;
    struct flexiblas_hook_fn LAPACKE_dormtr_work;
    struct flexiblas_hook_fn LAPACKE_dpbcon;
    struct flexiblas_hook_fn LAPACKE_dpbcon_work;
    struct flexiblas_hook_fn LAPACKE_dpbequ;
    struct flexiblas_hook_fn LAPACKE_dpbequ_work;
    struct flexiblas_hook_fn LAPACKE_dpbrfs;
    struct flexiblas_hook_fn LAPACKE_dpbrfs_work;
    struct flexiblas_hook_fn LAPACKE_dpbstf;
    struct flexiblas_hook_fn LAPACKE_dpbstf_work;
    struct flexiblas_hook_fn LAPACKE_dpbsv;
    struct flexiblas_hook_fn LAPACKE_dpbsv_work;
    struct flexiblas_hook_fn LAPACKE_dpbsvx;
    struct flexiblas_hook_fn LAPACKE_dpbsvx_work;
    struct flexiblas_hook_fn LAPACKE_dpbtrf;
    struct flexiblas_hook_fn LAPACKE_dpbtrf_work;
    struct flexiblas_hook_fn LAPACKE_dpbtrs;
    struct flexiblas_hook_fn LAPACKE_dpbtrs_work;
    struct flexiblas_hook_fn LAPACKE_dpftrf;
    struct flexiblas_hook_fn LAPACKE_dpftrf_work;
    struct flexiblas_hook_fn LAPACKE_dpftri;
    struct flexiblas_hook_fn LAPACKE_dpftri_work;
    struct flexiblas_hook_fn LAPACKE_dpftrs;
    struct flexiblas_hook_fn LAPACKE_dpftrs_work;
    struct flexiblas_hook_fn LAPACKE_dpocon;
    struct flexiblas_hook_fn LAPACKE_dpocon_work;
    struct flexiblas_hook_fn LAPACKE_dpoequ;
    struct flexiblas_hook_fn LAPACKE_dpoequ_work;
    struct flexiblas_hook_fn LAPACKE_dpoequb;
    struct flexiblas_hook_fn LAPACKE_dpoequb_work;
    struct flexiblas_hook_fn LAPACKE_dporfs;
    struct flexiblas_hook_fn LAPACKE_dporfs_work;
    struct flexiblas_hook_fn LAPACKE_dporfsx;
    struct flexiblas_hook_fn LAPACKE_dporfsx_work;
    struct flexiblas_hook_fn LAPACKE_dposv;
    struct flexiblas_hook_fn LAPACKE_dposv_work;
    struct flexiblas_hook_fn LAPACKE_dposvx;
    struct flexiblas_hook_fn LAPACKE_dposvx_work;
    struct flexiblas_hook_fn LAPACKE_dposvxx;
    struct flexiblas_hook_fn LAPACKE_dposvxx_work;
    struct flexiblas_hook_fn LAPACKE_dpotrf;
    struct flexiblas_hook_fn LAPACKE_dpotrf2;
    struct flexiblas_hook_fn LAPACKE_dpotrf2_work;
    struct flexiblas_hook_fn LAPACKE_dpotrf_work;
    struct flexiblas_hook_fn LAPACKE_dpotri;
    struct flexiblas_hook_fn LAPACKE_dpotri_work;
    struct flexiblas_hook_fn LAPACKE_dpotrs;
    struct flexiblas_hook_fn LAPACKE_dpotrs_work;
    struct flexiblas_hook_fn LAPACKE_dppcon;
    struct flexiblas_hook_fn LAPACKE_dppcon_work;
    struct flexiblas_hook_fn LAPACKE_dppequ;
    struct flexiblas_hook_fn LAPACKE_dppequ_work;
    struct flexiblas_hook_fn LAPACKE_dpprfs;
    struct flexiblas_hook_fn LAPACKE_dpprfs_work;
    struct flexiblas_hook_fn LAPACKE_dppsv;
    struct flexiblas_hook_fn LAPACKE_dppsv_work;
    struct flexiblas_hook_fn LAPACKE_dppsvx;
    struct flexiblas_hook_fn LAPACKE_dppsvx_work;
    struct flexiblas_hook_fn LAPACKE_dpptrf;
    struct flexiblas_hook_fn LAPACKE_dpptrf_work;
    struct flexiblas_hook_fn LAPACKE_dpptri;
    struct flexiblas_hook_fn LAPACKE_dpptri_work;
    struct flexiblas_hook_fn LAPACKE_dpptrs;
    struct flexiblas_hook_fn LAPACKE_dpptrs_work;
    struct flexiblas_hook_fn LAPACKE_dpstrf;
    struct flexiblas_hook_fn LAPACKE_dpstrf_work;
    struct flexiblas_hook_fn LAPACKE_dptcon;
    struct flexiblas_hook_fn LAPACKE_dptcon_work;
    struct flexiblas_hook_fn LAPACKE_dpteqr;
    struct flexiblas_hook_fn LAPACKE_dpteqr_work;
    struct flexiblas_hook_fn LAPACKE_dptrfs;
    struct flexiblas_hook_fn LAPACKE_dptrfs_work;
    struct flexiblas_hook_fn LAPACKE_dptsv;
    struct flexiblas_hook_fn LAPACKE_dptsv_work;
    struct flexiblas_hook_fn LAPACKE_dptsvx;
    struct flexiblas_hook_fn LAPACKE_dptsvx_work;
    struct flexiblas_hook_fn LAPACKE_dpttrf;
    struct flexiblas_hook_fn LAPACKE_dpttrf_work;
    struct flexiblas_hook_fn LAPACKE_dpttrs;
    struct flexiblas_hook_fn LAPACKE_dpttrs_work;
    struct flexiblas_hook_fn LAPACKE_dsbev;
    struct flexiblas_hook_fn LAPACKE_dsbev_2stage;
    struct flexiblas_hook_fn LAPACKE_dsbev_2stage_work;
    struct flexiblas_hook_fn LAPACKE_dsbev_work;
    struct flexiblas_hook_fn LAPACKE_dsbevd;
    struct flexiblas_hook_fn LAPACKE_dsbevd_2stage;
    struct flexiblas_hook_fn LAPACKE_dsbevd_2stage_work;
    struct flexiblas_hook_fn LAPACKE_dsbevd_work;
    struct flexiblas_hook_fn LAPACKE_dsbevx;
    struct flexiblas_hook_fn LAPACKE_dsbevx_2stage;
    struct flexiblas_hook_fn LAPACKE_dsbevx_2stage_work;
    struct flexiblas_hook_fn LAPACKE_dsbevx_work;
    struct flexiblas_hook_fn LAPACKE_dsbgst;
    struct flexiblas_hook_fn LAPACKE_dsbgst_work;
    struct flexiblas_hook_fn LAPACKE_dsbgv;
    struct flexiblas_hook_fn LAPACKE_dsbgv_work;
    struct flexiblas_hook_fn LAPACKE_dsbgvd;
    struct flexiblas_hook_fn LAPACKE_dsbgvd_work;
    struct flexiblas_hook_fn LAPACKE_dsbgvx;
    struct flexiblas_hook_fn LAPACKE_dsbgvx_work;
    struct flexiblas_hook_fn LAPACKE_dsbtrd;
    struct flexiblas_hook_fn LAPACKE_dsbtrd_work;
    struct flexiblas_hook_fn LAPACKE_dsfrk;
    struct flexiblas_hook_fn LAPACKE_dsfrk_work;
    struct flexiblas_hook_fn LAPACKE_dsgesv;
    struct flexiblas_hook_fn LAPACKE_dsgesv_work;
    struct flexiblas_hook_fn LAPACKE_dspcon;
    struct flexiblas_hook_fn LAPACKE_dspcon_work;
    struct flexiblas_hook_fn LAPACKE_dspev;
    struct flexiblas_hook_fn LAPACKE_dspev_work;
    struct flexiblas_hook_fn LAPACKE_dspevd;
    struct flexiblas_hook_fn LAPACKE_dspevd_work;
    struct flexiblas_hook_fn LAPACKE_dspevx;
    struct flexiblas_hook_fn LAPACKE_dspevx_work;
    struct flexiblas_hook_fn LAPACKE_dspgst;
    struct flexiblas_hook_fn LAPACKE_dspgst_work;
    struct flexiblas_hook_fn LAPACKE_dspgv;
    struct flexiblas_hook_fn LAPACKE_dspgv_work;
    struct flexiblas_hook_fn LAPACKE_dspgvd;
    struct flexiblas_hook_fn LAPACKE_dspgvd_work;
    struct flexiblas_hook_fn LAPACKE_dspgvx;
    struct flexiblas_hook_fn LAPACKE_dspgvx_work;
    struct flexiblas_hook_fn LAPACKE_dsposv;
    struct flexiblas_hook_fn LAPACKE_dsposv_work;
    struct flexiblas_hook_fn LAPACKE_dsprfs;
    struct flexiblas_hook_fn LAPACKE_dsprfs_work;
    struct flexiblas_hook_fn LAPACKE_dspsv;
    struct flexiblas_hook_fn LAPACKE_dspsv_work;
    struct flexiblas_hook_fn LAPACKE_dspsvx;
    struct flexiblas_hook_fn LAPACKE_dspsvx_work;
    struct flexiblas_hook_fn LAPACKE_dsptrd;
    struct flexiblas_hook_fn LAPACKE_dsptrd_work;
    struct flexiblas_hook_fn LAPACKE_dsptrf;
    struct flexiblas_hook_fn LAPACKE_dsptrf_work;
    struct flexiblas_hook_fn LAPACKE_dsptri;
    struct flexiblas_hook_fn LAPACKE_dsptri_work;
    struct flexiblas_hook_fn LAPACKE_dsptrs;
    struct flexiblas_hook_fn LAPACKE_dsptrs_work;
    struct flexiblas_hook_fn LAPACKE_dstebz;
    struct flexiblas_hook_fn LAPACKE_dstebz_work;
    struct flexiblas_hook_fn LAPACKE_dstedc;
    struct flexiblas_hook_fn LAPACKE_dstedc_work;
    struct flexiblas_hook_fn LAPACKE_dstegr;
    struct flexiblas_hook_fn LAPACKE_dstegr_work;
    struct flexiblas_hook_fn LAPACKE_dstein;
    struct flexiblas_hook_fn LAPACKE_dstein_work;
    struct flexiblas_hook_fn LAPACKE_dstemr;
    struct flexiblas_hook_fn LAPACKE_dstemr_work;
    struct flexiblas_hook_fn LAPACKE_dsteqr;
    struct flexiblas_hook_fn LAPACKE_dsteqr_work;
    struct flexiblas_hook_fn LAPACKE_dsterf;
    struct flexiblas_hook_fn LAPACKE_dsterf_work;
    struct flexiblas_hook_fn LAPACKE_dstev;
    struct flexiblas_hook_fn LAPACKE_dstev_work;
    struct flexiblas_hook_fn LAPACKE_dstevd;
    struct flexiblas_hook_fn LAPACKE_dstevd_work;
    struct flexiblas_hook_fn LAPACKE_dstevr;
    struct flexiblas_hook_fn LAPACKE_dstevr_work;
    struct flexiblas_hook_fn LAPACKE_dstevx;
    struct flexiblas_hook_fn LAPACKE_dstevx_work;
    struct flexiblas_hook_fn LAPACKE_dsycon;
    struct flexiblas_hook_fn LAPACKE_dsycon_3;
    struct flexiblas_hook_fn LAPACKE_dsycon_3_work;
    struct flexiblas_hook_fn LAPACKE_dsycon_work;
    struct flexiblas_hook_fn LAPACKE_dsyconv;
    struct flexiblas_hook_fn LAPACKE_dsyconv_work;
    struct flexiblas_hook_fn LAPACKE_dsyequb;
    struct flexiblas_hook_fn LAPACKE_dsyequb_work;
    struct flexiblas_hook_fn LAPACKE_dsyev;
    struct flexiblas_hook_fn LAPACKE_dsyev_2stage;
    struct flexiblas_hook_fn LAPACKE_dsyev_2stage_work;
    struct flexiblas_hook_fn LAPACKE_dsyev_work;
    struct flexiblas_hook_fn LAPACKE_dsyevd;
    struct flexiblas_hook_fn LAPACKE_dsyevd_2stage;
    struct flexiblas_hook_fn LAPACKE_dsyevd_2stage_work;
    struct flexiblas_hook_fn LAPACKE_dsyevd_work;
    struct flexiblas_hook_fn LAPACKE_dsyevr;
    struct flexiblas_hook_fn LAPACKE_dsyevr_2stage;
    struct flexiblas_hook_fn LAPACKE_dsyevr_2stage_work;
    struct flexiblas_hook_fn LAPACKE_dsyevr_work;
    struct flexiblas_hook_fn LAPACKE_dsyevx;
    struct flexiblas_hook_fn LAPACKE_dsyevx_2stage;
    struct flexiblas_hook_fn LAPACKE_dsyevx_2stage_work;
    struct flexiblas_hook_fn LAPACKE_dsyevx_work;
    struct flexiblas_hook_fn LAPACKE_dsygst;
    struct flexiblas_hook_fn LAPACKE_dsygst_work;
    struct flexiblas_hook_fn LAPACKE_dsygv;
    struct flexiblas_hook_fn LAPACKE_dsygv_2stage;
    struct flexiblas_hook_fn LAPACKE_dsygv_2stage_work;
    struct flexiblas_hook_fn LAPACKE_dsygv_work;
    struct flexiblas_hook_fn LAPACKE_dsygvd;
    struct flexiblas_hook_fn LAPACKE_dsygvd_work;
    struct flexiblas_hook_fn LAPACKE_dsygvx;
    struct flexiblas_hook_fn LAPACKE_dsygvx_work;
    struct flexiblas_hook_fn LAPACKE_dsyrfs;
    struct flexiblas_hook_fn LAPACKE_dsyrfs_work;
    struct flexiblas_hook_fn LAPACKE_dsyrfsx;
    struct flexiblas_hook_fn LAPACKE_dsyrfsx_work;
    struct flexiblas_hook_fn LAPACKE_dsysv;
    struct flexiblas_hook_fn LAPACKE_dsysv_aa;
    struct flexiblas_hook_fn LAPACKE_dsysv_aa_2stage;
    struct flexiblas_hook_fn LAPACKE_dsysv_aa_2stage_work;
    struct flexiblas_hook_fn LAPACKE_dsysv_aa_work;
    struct flexiblas_hook_fn LAPACKE_dsysv_rk;
    struct flexiblas_hook_fn LAPACKE_dsysv_rk_work;
    struct flexiblas_hook_fn LAPACKE_dsysv_rook;
    struct flexiblas_hook_fn LAPACKE_dsysv_rook_work;
    struct flexiblas_hook_fn LAPACKE_dsysv_work;
    struct flexiblas_hook_fn LAPACKE_dsysvx;
    struct flexiblas_hook_fn LAPACKE_dsysvx_work;
    struct flexiblas_hook_fn LAPACKE_dsysvxx;
    struct flexiblas_hook_fn LAPACKE_dsysvxx_work;
    struct flexiblas_hook_fn LAPACKE_dsyswapr;
    struct flexiblas_hook_fn LAPACKE_dsyswapr_work;
    struct flexiblas_hook_fn LAPACKE_dsytrd;
    struct flexiblas_hook_fn LAPACKE_dsytrd_work;
    struct flexiblas_hook_fn LAPACKE_dsytrf;
    struct flexiblas_hook_fn LAPACKE_dsytrf_aa;
    struct flexiblas_hook_fn LAPACKE_dsytrf_aa_2stage;
    struct flexiblas_hook_fn LAPACKE_dsytrf_aa_2stage_work;
    struct flexiblas_hook_fn LAPACKE_dsytrf_aa_work;
    struct flexiblas_hook_fn LAPACKE_dsytrf_rk;
    struct flexiblas_hook_fn LAPACKE_dsytrf_rk_work;
    struct flexiblas_hook_fn LAPACKE_dsytrf_rook;
    struct flexiblas_hook_fn LAPACKE_dsytrf_rook_work;
    struct flexiblas_hook_fn LAPACKE_dsytrf_work;
    struct flexiblas_hook_fn LAPACKE_dsytri;
    struct flexiblas_hook_fn LAPACKE_dsytri2;
    struct flexiblas_hook_fn LAPACKE_dsytri2_work;
    struct flexiblas_hook_fn LAPACKE_dsytri2x;
    struct flexiblas_hook_fn LAPACKE_dsytri2x_work;
    struct flexiblas_hook_fn LAPACKE_dsytri_3;
    struct flexiblas_hook_fn LAPACKE_dsytri_3_work;
    struct flexiblas_hook_fn LAPACKE_dsytri_work;
    struct flexiblas_hook_fn LAPACKE_dsytrs;
    struct flexiblas_hook_fn LAPACKE_dsytrs2;
    struct flexiblas_hook_fn LAPACKE_dsytrs2_work;
    struct flexiblas_hook_fn LAPACKE_dsytrs_3;
    struct flexiblas_hook_fn LAPACKE_dsytrs_3_work;
    struct flexiblas_hook_fn LAPACKE_dsytrs_aa;
    struct flexiblas_hook_fn LAPACKE_dsytrs_aa_2stage;
    struct flexiblas_hook_fn LAPACKE_dsytrs_aa_2stage_work;
    struct flexiblas_hook_fn LAPACKE_dsytrs_aa_work;
    struct flexiblas_hook_fn LAPACKE_dsytrs_rook;
    struct flexiblas_hook_fn LAPACKE_dsytrs_rook_work;
    struct flexiblas_hook_fn LAPACKE_dsytrs_work;
    struct flexiblas_hook_fn LAPACKE_dtbcon;
    struct flexiblas_hook_fn LAPACKE_dtbcon_work;
    struct flexiblas_hook_fn LAPACKE_dtbrfs;
    struct flexiblas_hook_fn LAPACKE_dtbrfs_work;
    struct flexiblas_hook_fn LAPACKE_dtbtrs;
    struct flexiblas_hook_fn LAPACKE_dtbtrs_work;
    struct flexiblas_hook_fn LAPACKE_dtfsm;
    struct flexiblas_hook_fn LAPACKE_dtfsm_work;
    struct flexiblas_hook_fn LAPACKE_dtftri;
    struct flexiblas_hook_fn LAPACKE_dtftri_work;
    struct flexiblas_hook_fn LAPACKE_dtfttp;
    struct flexiblas_hook_fn LAPACKE_dtfttp_work;
    struct flexiblas_hook_fn LAPACKE_dtfttr;
    struct flexiblas_hook_fn LAPACKE_dtfttr_work;
    struct flexiblas_hook_fn LAPACKE_dtgevc;
    struct flexiblas_hook_fn LAPACKE_dtgevc_work;
    struct flexiblas_hook_fn LAPACKE_dtgexc;
    struct flexiblas_hook_fn LAPACKE_dtgexc_work;
    struct flexiblas_hook_fn LAPACKE_dtgsen;
    struct flexiblas_hook_fn LAPACKE_dtgsen_work;
    struct flexiblas_hook_fn LAPACKE_dtgsja;
    struct flexiblas_hook_fn LAPACKE_dtgsja_work;
    struct flexiblas_hook_fn LAPACKE_dtgsna;
    struct flexiblas_hook_fn LAPACKE_dtgsna_work;
    struct flexiblas_hook_fn LAPACKE_dtgsyl;
    struct flexiblas_hook_fn LAPACKE_dtgsyl_work;
    struct flexiblas_hook_fn LAPACKE_dtpcon;
    struct flexiblas_hook_fn LAPACKE_dtpcon_work;
    struct flexiblas_hook_fn LAPACKE_dtpmqrt;
    struct flexiblas_hook_fn LAPACKE_dtpmqrt_work;
    struct flexiblas_hook_fn LAPACKE_dtpqrt;
    struct flexiblas_hook_fn LAPACKE_dtpqrt2;
    struct flexiblas_hook_fn LAPACKE_dtpqrt2_work;
    struct flexiblas_hook_fn LAPACKE_dtpqrt_work;
    struct flexiblas_hook_fn LAPACKE_dtprfb;
    struct flexiblas_hook_fn LAPACKE_dtprfb_work;
    struct flexiblas_hook_fn LAPACKE_dtprfs;
    struct flexiblas_hook_fn LAPACKE_dtprfs_work;
    struct flexiblas_hook_fn LAPACKE_dtptri;
    struct flexiblas_hook_fn LAPACKE_dtptri_work;
    struct flexiblas_hook_fn LAPACKE_dtptrs;
    struct flexiblas_hook_fn LAPACKE_dtptrs_work;
    struct flexiblas_hook_fn LAPACKE_dtpttf;
    struct flexiblas_hook_fn LAPACKE_dtpttf_work;
    struct flexiblas_hook_fn LAPACKE_dtpttr;
    struct flexiblas_hook_fn LAPACKE_dtpttr_work;
    struct flexiblas_hook_fn LAPACKE_dtrcon;
    struct flexiblas_hook_fn LAPACKE_dtrcon_work;
    struct flexiblas_hook_fn LAPACKE_dtrevc;
    struct flexiblas_hook_fn LAPACKE_dtrevc_work;
    struct flexiblas_hook_fn LAPACKE_dtrexc;
    struct flexiblas_hook_fn LAPACKE_dtrexc_work;
    struct flexiblas_hook_fn LAPACKE_dtrrfs;
    struct flexiblas_hook_fn LAPACKE_dtrrfs_work;
    struct flexiblas_hook_fn LAPACKE_dtrsen;
    struct flexiblas_hook_fn LAPACKE_dtrsen_work;
    struct flexiblas_hook_fn LAPACKE_dtrsna;
    struct flexiblas_hook_fn LAPACKE_dtrsna_work;
    struct flexiblas_hook_fn LAPACKE_dtrsyl;
    struct flexiblas_hook_fn LAPACKE_dtrsyl3;
    struct flexiblas_hook_fn LAPACKE_dtrsyl3_work;
    struct flexiblas_hook_fn LAPACKE_dtrsyl_work;
    struct flexiblas_hook_fn LAPACKE_dtrtri;
    struct flexiblas_hook_fn LAPACKE_dtrtri_work;
    struct flexiblas_hook_fn LAPACKE_dtrtrs;
    struct flexiblas_hook_fn LAPACKE_dtrtrs_work;
    struct flexiblas_hook_fn LAPACKE_dtrttf;
    struct flexiblas_hook_fn LAPACKE_dtrttf_work;
    struct flexiblas_hook_fn LAPACKE_dtrttp;
    struct flexiblas_hook_fn LAPACKE_dtrttp_work;
    struct flexiblas_hook_fn LAPACKE_dtzrzf;
    struct flexiblas_hook_fn LAPACKE_dtzrzf_work;
    struct flexiblas_hook_fn LAPACKE_get_nancheck;
    struct flexiblas_hook_fn LAPACKE_ilaver;
    struct flexiblas_hook_fn LAPACKE_sbbcsd;
    struct flexiblas_hook_fn LAPACKE_sbbcsd_work;
    struct flexiblas_hook_fn LAPACKE_sbdsdc;
    struct flexiblas_hook_fn LAPACKE_sbdsdc_work;
    struct flexiblas_hook_fn LAPACKE_sbdsqr;
    struct flexiblas_hook_fn LAPACKE_sbdsqr_work;
    struct flexiblas_hook_fn LAPACKE_sbdsvdx;
    struct flexiblas_hook_fn LAPACKE_sbdsvdx_work;
    struct flexiblas_hook_fn LAPACKE_sdisna;
    struct flexiblas_hook_fn LAPACKE_sdisna_work;
    struct flexiblas_hook_fn LAPACKE_set_nancheck;
    struct flexiblas_hook_fn LAPACKE_sgbbrd;
    struct flexiblas_hook_fn LAPACKE_sgbbrd_work;
    struct flexiblas_hook_fn LAPACKE_sgbcon;
    struct flexiblas_hook_fn LAPACKE_sgbcon_work;
    struct flexiblas_hook_fn LAPACKE_sgbequ;
    struct flexiblas_hook_fn LAPACKE_sgbequ_work;
    struct flexiblas_hook_fn LAPACKE_sgbequb;
    struct flexiblas_hook_fn LAPACKE_sgbequb_work;
    struct flexiblas_hook_fn LAPACKE_sgbrfs;
    struct flexiblas_hook_fn LAPACKE_sgbrfs_work;
    struct flexiblas_hook_fn LAPACKE_sgbrfsx;
    struct flexiblas_hook_fn LAPACKE_sgbrfsx_work;
    struct flexiblas_hook_fn LAPACKE_sgbsv;
    struct flexiblas_hook_fn LAPACKE_sgbsv_work;
    struct flexiblas_hook_fn LAPACKE_sgbsvx;
    struct flexiblas_hook_fn LAPACKE_sgbsvx_work;
    struct flexiblas_hook_fn LAPACKE_sgbsvxx;
    struct flexiblas_hook_fn LAPACKE_sgbsvxx_work;
    struct flexiblas_hook_fn LAPACKE_sgbtrf;
    struct flexiblas_hook_fn LAPACKE_sgbtrf_work;
    struct flexiblas_hook_fn LAPACKE_sgbtrs;
    struct flexiblas_hook_fn LAPACKE_sgbtrs_work;
    struct flexiblas_hook_fn LAPACKE_sgebak;
    struct flexiblas_hook_fn LAPACKE_sgebak_work;
    struct flexiblas_hook_fn LAPACKE_sgebal;
    struct flexiblas_hook_fn LAPACKE_sgebal_work;
    struct flexiblas_hook_fn LAPACKE_sgebrd;
    struct flexiblas_hook_fn LAPACKE_sgebrd_work;
    struct flexiblas_hook_fn LAPACKE_sgecon;
    struct flexiblas_hook_fn LAPACKE_sgecon_work;
    struct flexiblas_hook_fn LAPACKE_sgedmd_work;
    struct flexiblas_hook_fn LAPACKE_sgedmdq_work;
    struct flexiblas_hook_fn LAPACKE_sgeequ;
    struct flexiblas_hook_fn LAPACKE_sgeequ_work;
    struct flexiblas_hook_fn LAPACKE_sgeequb;
    struct flexiblas_hook_fn LAPACKE_sgeequb_work;
    struct flexiblas_hook_fn LAPACKE_sgees;
    struct flexiblas_hook_fn LAPACKE_sgees_work;
    struct flexiblas_hook_fn LAPACKE_sgeesx;
    struct flexiblas_hook_fn LAPACKE_sgeesx_work;
    struct flexiblas_hook_fn LAPACKE_sgeev;
    struct flexiblas_hook_fn LAPACKE_sgeev_work;
    struct flexiblas_hook_fn LAPACKE_sgeevx;
    struct flexiblas_hook_fn LAPACKE_sgeevx_work;
    struct flexiblas_hook_fn LAPACKE_sgehrd;
    struct flexiblas_hook_fn LAPACKE_sgehrd_work;
    struct flexiblas_hook_fn LAPACKE_sgejsv;
    struct flexiblas_hook_fn LAPACKE_sgejsv_work;
    struct flexiblas_hook_fn LAPACKE_sgelq;
    struct flexiblas_hook_fn LAPACKE_sgelq2;
    struct flexiblas_hook_fn LAPACKE_sgelq2_work;
    struct flexiblas_hook_fn LAPACKE_sgelq_work;
    struct flexiblas_hook_fn LAPACKE_sgelqf;
    struct flexiblas_hook_fn LAPACKE_sgelqf_work;
    struct flexiblas_hook_fn LAPACKE_sgels;
    struct flexiblas_hook_fn LAPACKE_sgels_work;
    struct flexiblas_hook_fn LAPACKE_sgelsd;
    struct flexiblas_hook_fn LAPACKE_sgelsd_work;
    struct flexiblas_hook_fn LAPACKE_sgelss;
    struct flexiblas_hook_fn LAPACKE_sgelss_work;
    struct flexiblas_hook_fn LAPACKE_sgelsy;
    struct flexiblas_hook_fn LAPACKE_sgelsy_work;
    struct flexiblas_hook_fn LAPACKE_sgemlq;
    struct flexiblas_hook_fn LAPACKE_sgemlq_work;
    struct flexiblas_hook_fn LAPACKE_sgemqr;
    struct flexiblas_hook_fn LAPACKE_sgemqr_work;
    struct flexiblas_hook_fn LAPACKE_sgemqrt;
    struct flexiblas_hook_fn LAPACKE_sgemqrt_work;
    struct flexiblas_hook_fn LAPACKE_sgeqlf;
    struct flexiblas_hook_fn LAPACKE_sgeqlf_work;
    struct flexiblas_hook_fn LAPACKE_sgeqp3;
    struct flexiblas_hook_fn LAPACKE_sgeqp3_work;
    struct flexiblas_hook_fn LAPACKE_sgeqpf;
    struct flexiblas_hook_fn LAPACKE_sgeqpf_work;
    struct flexiblas_hook_fn LAPACKE_sgeqr;
    struct flexiblas_hook_fn LAPACKE_sgeqr2;
    struct flexiblas_hook_fn LAPACKE_sgeqr2_work;
    struct flexiblas_hook_fn LAPACKE_sgeqr_work;
    struct flexiblas_hook_fn LAPACKE_sgeqrf;
    struct flexiblas_hook_fn LAPACKE_sgeqrf_work;
    struct flexiblas_hook_fn LAPACKE_sgeqrfp;
    struct flexiblas_hook_fn LAPACKE_sgeqrfp_work;
    struct flexiblas_hook_fn LAPACKE_sgeqrt;
    struct flexiblas_hook_fn LAPACKE_sgeqrt2;
    struct flexiblas_hook_fn LAPACKE_sgeqrt2_work;
    struct flexiblas_hook_fn LAPACKE_sgeqrt3;
    struct flexiblas_hook_fn LAPACKE_sgeqrt3_work;
    struct flexiblas_hook_fn LAPACKE_sgeqrt_work;
    struct flexiblas_hook_fn LAPACKE_sgerfs;
    struct flexiblas_hook_fn LAPACKE_sgerfs_work;
    struct flexiblas_hook_fn LAPACKE_sgerfsx;
    struct flexiblas_hook_fn LAPACKE_sgerfsx_work;
    struct flexiblas_hook_fn LAPACKE_sgerqf;
    struct flexiblas_hook_fn LAPACKE_sgerqf_work;
    struct flexiblas_hook_fn LAPACKE_sgesdd;
    struct flexiblas_hook_fn LAPACKE_sgesdd_work;
    struct flexiblas_hook_fn LAPACKE_sgesv;
    struct flexiblas_hook_fn LAPACKE_sgesv_work;
    struct flexiblas_hook_fn LAPACKE_sgesvd;
    struct flexiblas_hook_fn LAPACKE_sgesvd_work;
    struct flexiblas_hook_fn LAPACKE_sgesvdq;
    struct flexiblas_hook_fn LAPACKE_sgesvdq_work;
    struct flexiblas_hook_fn LAPACKE_sgesvdx;
    struct flexiblas_hook_fn LAPACKE_sgesvdx_work;
    struct flexiblas_hook_fn LAPACKE_sgesvj;
    struct flexiblas_hook_fn LAPACKE_sgesvj_work;
    struct flexiblas_hook_fn LAPACKE_sgesvx;
    struct flexiblas_hook_fn LAPACKE_sgesvx_work;
    struct flexiblas_hook_fn LAPACKE_sgesvxx;
    struct flexiblas_hook_fn LAPACKE_sgesvxx_work;
    struct flexiblas_hook_fn LAPACKE_sgetf2;
    struct flexiblas_hook_fn LAPACKE_sgetf2_work;
    struct flexiblas_hook_fn LAPACKE_sgetrf;
    struct flexiblas_hook_fn LAPACKE_sgetrf2;
    struct flexiblas_hook_fn LAPACKE_sgetrf2_work;
    struct flexiblas_hook_fn LAPACKE_sgetrf_work;
    struct flexiblas_hook_fn LAPACKE_sgetri;
    struct flexiblas_hook_fn LAPACKE_sgetri_work;
    struct flexiblas_hook_fn LAPACKE_sgetrs;
    struct flexiblas_hook_fn LAPACKE_sgetrs_work;
    struct flexiblas_hook_fn LAPACKE_sgetsls;
    struct flexiblas_hook_fn LAPACKE_sgetsls_work;
    struct flexiblas_hook_fn LAPACKE_sgetsqrhrt;
    struct flexiblas_hook_fn LAPACKE_sgetsqrhrt_work;
    struct flexiblas_hook_fn LAPACKE_sggbak;
    struct flexiblas_hook_fn LAPACKE_sggbak_work;
    struct flexiblas_hook_fn LAPACKE_sggbal;
    struct flexiblas_hook_fn LAPACKE_sggbal_work;
    struct flexiblas_hook_fn LAPACKE_sgges;
    struct flexiblas_hook_fn LAPACKE_sgges3;
    struct flexiblas_hook_fn LAPACKE_sgges3_work;
    struct flexiblas_hook_fn LAPACKE_sgges_work;
    struct flexiblas_hook_fn LAPACKE_sggesx;
    struct flexiblas_hook_fn LAPACKE_sggesx_work;
    struct flexiblas_hook_fn LAPACKE_sggev;
    struct flexiblas_hook_fn LAPACKE_sggev3;
    struct flexiblas_hook_fn LAPACKE_sggev3_work;
    struct flexiblas_hook_fn LAPACKE_sggev_work;
    struct flexiblas_hook_fn LAPACKE_sggevx;
    struct flexiblas_hook_fn LAPACKE_sggevx_work;
    struct flexiblas_hook_fn LAPACKE_sggglm;
    struct flexiblas_hook_fn LAPACKE_sggglm_work;
    struct flexiblas_hook_fn LAPACKE_sgghd3;
    struct flexiblas_hook_fn LAPACKE_sgghd3_work;
    struct flexiblas_hook_fn LAPACKE_sgghrd;
    struct flexiblas_hook_fn LAPACKE_sgghrd_work;
    struct flexiblas_hook_fn LAPACKE_sgglse;
    struct flexiblas_hook_fn LAPACKE_sgglse_work;
    struct flexiblas_hook_fn LAPACKE_sggqrf;
    struct flexiblas_hook_fn LAPACKE_sggqrf_work;
    struct flexiblas_hook_fn LAPACKE_sggrqf;
    struct flexiblas_hook_fn LAPACKE_sggrqf_work;
    struct flexiblas_hook_fn LAPACKE_sggsvd;
    struct flexiblas_hook_fn LAPACKE_sggsvd3;
    struct flexiblas_hook_fn LAPACKE_sggsvd3_work;
    struct flexiblas_hook_fn LAPACKE_sggsvd_work;
    struct flexiblas_hook_fn LAPACKE_sggsvp;
    struct flexiblas_hook_fn LAPACKE_sggsvp3;
    struct flexiblas_hook_fn LAPACKE_sggsvp3_work;
    struct flexiblas_hook_fn LAPACKE_sggsvp_work;
    struct flexiblas_hook_fn LAPACKE_sgtcon;
    struct flexiblas_hook_fn LAPACKE_sgtcon_work;
    struct flexiblas_hook_fn LAPACKE_sgtrfs;
    struct flexiblas_hook_fn LAPACKE_sgtrfs_work;
    struct flexiblas_hook_fn LAPACKE_sgtsv;
    struct flexiblas_hook_fn LAPACKE_sgtsv_work;
    struct flexiblas_hook_fn LAPACKE_sgtsvx;
    struct flexiblas_hook_fn LAPACKE_sgtsvx_work;
    struct flexiblas_hook_fn LAPACKE_sgttrf;
    struct flexiblas_hook_fn LAPACKE_sgttrf_work;
    struct flexiblas_hook_fn LAPACKE_sgttrs;
    struct flexiblas_hook_fn LAPACKE_sgttrs_work;
    struct flexiblas_hook_fn LAPACKE_shgeqz;
    struct flexiblas_hook_fn LAPACKE_shgeqz_work;
    struct flexiblas_hook_fn LAPACKE_shsein;
    struct flexiblas_hook_fn LAPACKE_shsein_work;
    struct flexiblas_hook_fn LAPACKE_shseqr;
    struct flexiblas_hook_fn LAPACKE_shseqr_work;
    struct flexiblas_hook_fn LAPACKE_slacn2;
    struct flexiblas_hook_fn LAPACKE_slacn2_work;
    struct flexiblas_hook_fn LAPACKE_slacpy;
    struct flexiblas_hook_fn LAPACKE_slacpy_work;
    struct flexiblas_hook_fn LAPACKE_slag2d;
    struct flexiblas_hook_fn LAPACKE_slag2d_work;
    struct flexiblas_hook_fn LAPACKE_slagge;
    struct flexiblas_hook_fn LAPACKE_slagge_work;
    struct flexiblas_hook_fn LAPACKE_slagsy;
    struct flexiblas_hook_fn LAPACKE_slagsy_work;
    struct flexiblas_hook_fn LAPACKE_slamch;
    struct flexiblas_hook_fn LAPACKE_slamch_work;
    struct flexiblas_hook_fn LAPACKE_slangb;
    struct flexiblas_hook_fn LAPACKE_slangb_work;
    struct flexiblas_hook_fn LAPACKE_slange;
    struct flexiblas_hook_fn LAPACKE_slange_work;
    struct flexiblas_hook_fn LAPACKE_slansy;
    struct flexiblas_hook_fn LAPACKE_slansy_work;
    struct flexiblas_hook_fn LAPACKE_slantr;
    struct flexiblas_hook_fn LAPACKE_slantr_work;
    struct flexiblas_hook_fn LAPACKE_slapmr;
    struct flexiblas_hook_fn LAPACKE_slapmr_work;
    struct flexiblas_hook_fn LAPACKE_slapmt;
    struct flexiblas_hook_fn LAPACKE_slapmt_work;
    struct flexiblas_hook_fn LAPACKE_slapy2;
    struct flexiblas_hook_fn LAPACKE_slapy2_work;
    struct flexiblas_hook_fn LAPACKE_slapy3;
    struct flexiblas_hook_fn LAPACKE_slapy3_work;
    struct flexiblas_hook_fn LAPACKE_slarfb;
    struct flexiblas_hook_fn LAPACKE_slarfb_work;
    struct flexiblas_hook_fn LAPACKE_slarfg;
    struct flexiblas_hook_fn LAPACKE_slarfg_work;
    struct flexiblas_hook_fn LAPACKE_slarft;
    struct flexiblas_hook_fn LAPACKE_slarft_work;
    struct flexiblas_hook_fn LAPACKE_slarfx;
    struct flexiblas_hook_fn LAPACKE_slarfx_work;
    struct flexiblas_hook_fn LAPACKE_slarnv;
    struct flexiblas_hook_fn LAPACKE_slarnv_work;
    struct flexiblas_hook_fn LAPACKE_slartgp;
    struct flexiblas_hook_fn LAPACKE_slartgp_work;
    struct flexiblas_hook_fn LAPACKE_slartgs;
    struct flexiblas_hook_fn LAPACKE_slartgs_work;
    struct flexiblas_hook_fn LAPACKE_slascl;
    struct flexiblas_hook_fn LAPACKE_slascl_work;
    struct flexiblas_hook_fn LAPACKE_slaset;
    struct flexiblas_hook_fn LAPACKE_slaset_work;
    struct flexiblas_hook_fn LAPACKE_slasrt;
    struct flexiblas_hook_fn LAPACKE_slasrt_work;
    struct flexiblas_hook_fn LAPACKE_slassq;
    struct flexiblas_hook_fn LAPACKE_slassq_work;
    struct flexiblas_hook_fn LAPACKE_slaswp;
    struct flexiblas_hook_fn LAPACKE_slaswp_work;
    struct flexiblas_hook_fn LAPACKE_slatms;
    struct flexiblas_hook_fn LAPACKE_slatms_work;
    struct flexiblas_hook_fn LAPACKE_slauum;
    struct flexiblas_hook_fn LAPACKE_slauum_work;
    struct flexiblas_hook_fn LAPACKE_sopgtr;
    struct flexiblas_hook_fn LAPACKE_sopgtr_work;
    struct flexiblas_hook_fn LAPACKE_sopmtr;
    struct flexiblas_hook_fn LAPACKE_sopmtr_work;
    struct flexiblas_hook_fn LAPACKE_sorbdb;
    struct flexiblas_hook_fn LAPACKE_sorbdb_work;
    struct flexiblas_hook_fn LAPACKE_sorcsd;
    struct flexiblas_hook_fn LAPACKE_sorcsd2by1;
    struct flexiblas_hook_fn LAPACKE_sorcsd2by1_work;
    struct flexiblas_hook_fn LAPACKE_sorcsd_work;
    struct flexiblas_hook_fn LAPACKE_sorgbr;
    struct flexiblas_hook_fn LAPACKE_sorgbr_work;
    struct flexiblas_hook_fn LAPACKE_sorghr;
    struct flexiblas_hook_fn LAPACKE_sorghr_work;
    struct flexiblas_hook_fn LAPACKE_sorglq;
    struct flexiblas_hook_fn LAPACKE_sorglq_work;
    struct flexiblas_hook_fn LAPACKE_sorgql;
    struct flexiblas_hook_fn LAPACKE_sorgql_work;
    struct flexiblas_hook_fn LAPACKE_sorgqr;
    struct flexiblas_hook_fn LAPACKE_sorgqr_work;
    struct flexiblas_hook_fn LAPACKE_sorgrq;
    struct flexiblas_hook_fn LAPACKE_sorgrq_work;
    struct flexiblas_hook_fn LAPACKE_sorgtr;
    struct flexiblas_hook_fn LAPACKE_sorgtr_work;
    struct flexiblas_hook_fn LAPACKE_sorgtsqr_row;
    struct flexiblas_hook_fn LAPACKE_sorgtsqr_row_work;
    struct flexiblas_hook_fn LAPACKE_sorhr_col;
    struct flexiblas_hook_fn LAPACKE_sorhr_col_work;
    struct flexiblas_hook_fn LAPACKE_sormbr;
    struct flexiblas_hook_fn LAPACKE_sormbr_work;
    struct flexiblas_hook_fn LAPACKE_sormhr;
    struct flexiblas_hook_fn LAPACKE_sormhr_work;
    struct flexiblas_hook_fn LAPACKE_sormlq;
    struct flexiblas_hook_fn LAPACKE_sormlq_work;
    struct flexiblas_hook_fn LAPACKE_sormql;
    struct flexiblas_hook_fn LAPACKE_sormql_work;
    struct flexiblas_hook_fn LAPACKE_sormqr;
    struct flexiblas_hook_fn LAPACKE_sormqr_work;
    struct flexiblas_hook_fn LAPACKE_sormrq;
    struct flexiblas_hook_fn LAPACKE_sormrq_work;
    struct flexiblas_hook_fn LAPACKE_sormrz;
    struct flexiblas_hook_fn LAPACKE_sormrz_work;
    struct flexiblas_hook_fn LAPACKE_sormtr;
    struct flexiblas_hook_fn LAPACKE_sormtr_work;
    struct flexiblas_hook_fn LAPACKE_spbcon;
    struct flexiblas_hook_fn LAPACKE_spbcon_work;
    struct flexiblas_hook_fn LAPACKE_spbequ;
    struct flexiblas_hook_fn LAPACKE_spbequ_work;
    struct flexiblas_hook_fn LAPACKE_spbrfs;
    struct flexiblas_hook_fn LAPACKE_spbrfs_work;
    struct flexiblas_hook_fn LAPACKE_spbstf;
    struct flexiblas_hook_fn LAPACKE_spbstf_work;
    struct flexiblas_hook_fn LAPACKE_spbsv;
    struct flexiblas_hook_fn LAPACKE_spbsv_work;
    struct flexiblas_hook_fn LAPACKE_spbsvx;
    struct flexiblas_hook_fn LAPACKE_spbsvx_work;
    struct flexiblas_hook_fn LAPACKE_spbtrf;
    struct flexiblas_hook_fn LAPACKE_spbtrf_work;
    struct flexiblas_hook_fn LAPACKE_spbtrs;
    struct flexiblas_hook_fn LAPACKE_spbtrs_work;
    struct flexiblas_hook_fn LAPACKE_spftrf;
    struct flexiblas_hook_fn LAPACKE_spftrf_work;
    struct flexiblas_hook_fn LAPACKE_spftri;
    struct flexiblas_hook_fn LAPACKE_spftri_work;
    struct flexiblas_hook_fn LAPACKE_spftrs;
    struct flexiblas_hook_fn LAPACKE_spftrs_work;
    struct flexiblas_hook_fn LAPACKE_spocon;
    struct flexiblas_hook_fn LAPACKE_spocon_work;
    struct flexiblas_hook_fn LAPACKE_spoequ;
    struct flexiblas_hook_fn LAPACKE_spoequ_work;
    struct flexiblas_hook_fn LAPACKE_spoequb;
    struct flexiblas_hook_fn LAPACKE_spoequb_work;
    struct flexiblas_hook_fn LAPACKE_sporfs;
    struct flexiblas_hook_fn LAPACKE_sporfs_work;
    struct flexiblas_hook_fn LAPACKE_sporfsx;
    struct flexiblas_hook_fn LAPACKE_sporfsx_work;
    struct flexiblas_hook_fn LAPACKE_sposv;
    struct flexiblas_hook_fn LAPACKE_sposv_work;
    struct flexiblas_hook_fn LAPACKE_sposvx;
    struct flexiblas_hook_fn LAPACKE_sposvx_work;
    struct flexiblas_hook_fn LAPACKE_sposvxx;
    struct flexiblas_hook_fn LAPACKE_sposvxx_work;
    struct flexiblas_hook_fn LAPACKE_spotrf;
    struct flexiblas_hook_fn LAPACKE_spotrf2;
    struct flexiblas_hook_fn LAPACKE_spotrf2_work;
    struct flexiblas_hook_fn LAPACKE_spotrf_work;
    struct flexiblas_hook_fn LAPACKE_spotri;
    struct flexiblas_hook_fn LAPACKE_spotri_work;
    struct flexiblas_hook_fn LAPACKE_spotrs;
    struct flexiblas_hook_fn LAPACKE_spotrs_work;
    struct flexiblas_hook_fn LAPACKE_sppcon;
    struct flexiblas_hook_fn LAPACKE_sppcon_work;
    struct flexiblas_hook_fn LAPACKE_sppequ;
    struct flexiblas_hook_fn LAPACKE_sppequ_work;
    struct flexiblas_hook_fn LAPACKE_spprfs;
    struct flexiblas_hook_fn LAPACKE_spprfs_work;
    struct flexiblas_hook_fn LAPACKE_sppsv;
    struct flexiblas_hook_fn LAPACKE_sppsv_work;
    struct flexiblas_hook_fn LAPACKE_sppsvx;
    struct flexiblas_hook_fn LAPACKE_sppsvx_work;
    struct flexiblas_hook_fn LAPACKE_spptrf;
    struct flexiblas_hook_fn LAPACKE_spptrf_work;
    struct flexiblas_hook_fn LAPACKE_spptri;
    struct flexiblas_hook_fn LAPACKE_spptri_work;
    struct flexiblas_hook_fn LAPACKE_spptrs;
    struct flexiblas_hook_fn LAPACKE_spptrs_work;
    struct flexiblas_hook_fn LAPACKE_spstrf;
    struct flexiblas_hook_fn LAPACKE_spstrf_work;
    struct flexiblas_hook_fn LAPACKE_sptcon;
    struct flexiblas_hook_fn LAPACKE_sptcon_work;
    struct flexiblas_hook_fn LAPACKE_spteqr;
    struct flexiblas_hook_fn LAPACKE_spteqr_work;
    struct flexiblas_hook_fn LAPACKE_sptrfs;
    struct flexiblas_hook_fn LAPACKE_sptrfs_work;
    struct flexiblas_hook_fn LAPACKE_sptsv;
    struct flexiblas_hook_fn LAPACKE_sptsv_work;
    struct flexiblas_hook_fn LAPACKE_sptsvx;
    struct flexiblas_hook_fn LAPACKE_sptsvx_work;
    struct flexiblas_hook_fn LAPACKE_spttrf;
    struct flexiblas_hook_fn LAPACKE_spttrf_work;
    struct flexiblas_hook_fn LAPACKE_spttrs;
    struct flexiblas_hook_fn LAPACKE_spttrs_work;
    struct flexiblas_hook_fn LAPACKE_ssbev;
    struct flexiblas_hook_fn LAPACKE_ssbev_2stage;
    struct flexiblas_hook_fn LAPACKE_ssbev_2stage_work;
    struct flexiblas_hook_fn LAPACKE_ssbev_work;
    struct flexiblas_hook_fn LAPACKE_ssbevd;
    struct flexiblas_hook_fn LAPACKE_ssbevd_2stage;
    struct flexiblas_hook_fn LAPACKE_ssbevd_2stage_work;
    struct flexiblas_hook_fn LAPACKE_ssbevd_work;
    struct flexiblas_hook_fn LAPACKE_ssbevx;
    struct flexiblas_hook_fn LAPACKE_ssbevx_2stage;
    struct flexiblas_hook_fn LAPACKE_ssbevx_2stage_work;
    struct flexiblas_hook_fn LAPACKE_ssbevx_work;
    struct flexiblas_hook_fn LAPACKE_ssbgst;
    struct flexiblas_hook_fn LAPACKE_ssbgst_work;
    struct flexiblas_hook_fn LAPACKE_ssbgv;
    struct flexiblas_hook_fn LAPACKE_ssbgv_work;
    struct flexiblas_hook_fn LAPACKE_ssbgvd;
    struct flexiblas_hook_fn LAPACKE_ssbgvd_work;
    struct flexiblas_hook_fn LAPACKE_ssbgvx;
    struct flexiblas_hook_fn LAPACKE_ssbgvx_work;
    struct flexiblas_hook_fn LAPACKE_ssbtrd;
    struct flexiblas_hook_fn LAPACKE_ssbtrd_work;
    struct flexiblas_hook_fn LAPACKE_ssfrk;
    struct flexiblas_hook_fn LAPACKE_ssfrk_work;
    struct flexiblas_hook_fn LAPACKE_sspcon;
    struct flexiblas_hook_fn LAPACKE_sspcon_work;
    struct flexiblas_hook_fn LAPACKE_sspev;
    struct flexiblas_hook_fn LAPACKE_sspev_work;
    struct flexiblas_hook_fn LAPACKE_sspevd;
    struct flexiblas_hook_fn LAPACKE_sspevd_work;
    struct flexiblas_hook_fn LAPACKE_sspevx;
    struct flexiblas_hook_fn LAPACKE_sspevx_work;
    struct flexiblas_hook_fn LAPACKE_sspgst;
    struct flexiblas_hook_fn LAPACKE_sspgst_work;
    struct flexiblas_hook_fn LAPACKE_sspgv;
    struct flexiblas_hook_fn LAPACKE_sspgv_work;
    struct flexiblas_hook_fn LAPACKE_sspgvd;
    struct flexiblas_hook_fn LAPACKE_sspgvd_work;
    struct flexiblas_hook_fn LAPACKE_sspgvx;
    struct flexiblas_hook_fn LAPACKE_sspgvx_work;
    struct flexiblas_hook_fn LAPACKE_ssprfs;
    struct flexiblas_hook_fn LAPACKE_ssprfs_work;
    struct flexiblas_hook_fn LAPACKE_sspsv;
    struct flexiblas_hook_fn LAPACKE_sspsv_work;
    struct flexiblas_hook_fn LAPACKE_sspsvx;
    struct flexiblas_hook_fn LAPACKE_sspsvx_work;
    struct flexiblas_hook_fn LAPACKE_ssptrd;
    struct flexiblas_hook_fn LAPACKE_ssptrd_work;
    struct flexiblas_hook_fn LAPACKE_ssptrf;
    struct flexiblas_hook_fn LAPACKE_ssptrf_work;
    struct flexiblas_hook_fn LAPACKE_ssptri;
    struct flexiblas_hook_fn LAPACKE_ssptri_work;
    struct flexiblas_hook_fn LAPACKE_ssptrs;
    struct flexiblas_hook_fn LAPACKE_ssptrs_work;
    struct flexiblas_hook_fn LAPACKE_sstebz;
    struct flexiblas_hook_fn LAPACKE_sstebz_work;
    struct flexiblas_hook_fn LAPACKE_sstedc;
    struct flexiblas_hook_fn LAPACKE_sstedc_work;
    struct flexiblas_hook_fn LAPACKE_sstegr;
    struct flexiblas_hook_fn LAPACKE_sstegr_work;
    struct flexiblas_hook_fn LAPACKE_sstein;
    struct flexiblas_hook_fn LAPACKE_sstein_work;
    struct flexiblas_hook_fn LAPACKE_sstemr;
    struct flexiblas_hook_fn LAPACKE_sstemr_work;
    struct flexiblas_hook_fn LAPACKE_ssteqr;
    struct flexiblas_hook_fn LAPACKE_ssteqr_work;
    struct flexiblas_hook_fn LAPACKE_ssterf;
    struct flexiblas_hook_fn LAPACKE_ssterf_work;
    struct flexiblas_hook_fn LAPACKE_sstev;
    struct flexiblas_hook_fn LAPACKE_sstev_work;
    struct flexiblas_hook_fn LAPACKE_sstevd;
    struct flexiblas_hook_fn LAPACKE_sstevd_work;
    struct flexiblas_hook_fn LAPACKE_sstevr;
    struct flexiblas_hook_fn LAPACKE_sstevr_work;
    struct flexiblas_hook_fn LAPACKE_sstevx;
    struct flexiblas_hook_fn LAPACKE_sstevx_work;
    struct flexiblas_hook_fn LAPACKE_ssycon;
    struct flexiblas_hook_fn LAPACKE_ssycon_3;
    struct flexiblas_hook_fn LAPACKE_ssycon_3_work;
    struct flexiblas_hook_fn LAPACKE_ssycon_work;
    struct flexiblas_hook_fn LAPACKE_ssyconv;
    struct flexiblas_hook_fn LAPACKE_ssyconv_work;
    struct flexiblas_hook_fn LAPACKE_ssyequb;
    struct flexiblas_hook_fn LAPACKE_ssyequb_work;
    struct flexiblas_hook_fn LAPACKE_ssyev;
    struct flexiblas_hook_fn LAPACKE_ssyev_2stage;
    struct flexiblas_hook_fn LAPACKE_ssyev_2stage_work;
    struct flexiblas_hook_fn LAPACKE_ssyev_work;
    struct flexiblas_hook_fn LAPACKE_ssyevd;
    struct flexiblas_hook_fn LAPACKE_ssyevd_2stage;
    struct flexiblas_hook_fn LAPACKE_ssyevd_2stage_work;
    struct flexiblas_hook_fn LAPACKE_ssyevd_work;
    struct flexiblas_hook_fn LAPACKE_ssyevr;
    struct flexiblas_hook_fn LAPACKE_ssyevr_2stage;
    struct flexiblas_hook_fn LAPACKE_ssyevr_2stage_work;
    struct flexiblas_hook_fn LAPACKE_ssyevr_work;
    struct flexiblas_hook_fn LAPACKE_ssyevx;
    struct flexiblas_hook_fn LAPACKE_ssyevx_2stage;
    struct flexiblas_hook_fn LAPACKE_ssyevx_2stage_work;
    struct flexiblas_hook_fn LAPACKE_ssyevx_work;
    struct flexiblas_hook_fn LAPACKE_ssygst;
    struct flexiblas_hook_fn LAPACKE_ssygst_work;
    struct flexiblas_hook_fn LAPACKE_ssygv;
    struct flexiblas_hook_fn LAPACKE_ssygv_2stage;
    struct flexiblas_hook_fn LAPACKE_ssygv_2stage_work;
    struct flexiblas_hook_fn LAPACKE_ssygv_work;
    struct flexiblas_hook_fn LAPACKE_ssygvd;
    struct flexiblas_hook_fn LAPACKE_ssygvd_work;
    struct flexiblas_hook_fn LAPACKE_ssygvx;
    struct flexiblas_hook_fn LAPACKE_ssygvx_work;
    struct flexiblas_hook_fn LAPACKE_ssyrfs;
    struct flexiblas_hook_fn LAPACKE_ssyrfs_work;
    struct flexiblas_hook_fn LAPACKE_ssyrfsx;
    struct flexiblas_hook_fn LAPACKE_ssyrfsx_work;
    struct flexiblas_hook_fn LAPACKE_ssysv;
    struct flexiblas_hook_fn LAPACKE_ssysv_aa;
    struct flexiblas_hook_fn LAPACKE_ssysv_aa_2stage;
    struct flexiblas_hook_fn LAPACKE_ssysv_aa_2stage_work;
    struct flexiblas_hook_fn LAPACKE_ssysv_aa_work;
    struct flexiblas_hook_fn LAPACKE_ssysv_rk;
    struct flexiblas_hook_fn LAPACKE_ssysv_rk_work;
    struct flexiblas_hook_fn LAPACKE_ssysv_rook;
    struct flexiblas_hook_fn LAPACKE_ssysv_rook_work;
    struct flexiblas_hook_fn LAPACKE_ssysv_work;
    struct flexiblas_hook_fn LAPACKE_ssysvx;
    struct flexiblas_hook_fn LAPACKE_ssysvx_work;
    struct flexiblas_hook_fn LAPACKE_ssysvxx;
    struct flexiblas_hook_fn LAPACKE_ssysvxx_work;
    struct flexiblas_hook_fn LAPACKE_ssyswapr;
    struct flexiblas_hook_fn LAPACKE_ssyswapr_work;
    struct flexiblas_hook_fn LAPACKE_ssytrd;
    struct flexiblas_hook_fn LAPACKE_ssytrd_work;
    struct flexiblas_hook_fn LAPACKE_ssytrf;
    struct flexiblas_hook_fn LAPACKE_ssytrf_aa;
    struct flexiblas_hook_fn LAPACKE_ssytrf_aa_2stage;
    struct flexiblas_hook_fn LAPACKE_ssytrf_aa_2stage_work;
    struct flexiblas_hook_fn LAPACKE_ssytrf_aa_work;
    struct flexiblas_hook_fn LAPACKE_ssytrf_rk;
    struct flexiblas_hook_fn LAPACKE_ssytrf_rk_work;
    struct flexiblas_hook_fn LAPACKE_ssytrf_rook;
    struct flexiblas_hook_fn LAPACKE_ssytrf_rook_work;
    struct flexiblas_hook_fn LAPACKE_ssytrf_work;
    struct flexiblas_hook_fn LAPACKE_ssytri;
    struct flexiblas_hook_fn LAPACKE_ssytri2;
    struct flexiblas_hook_fn LAPACKE_ssytri2_work;
    struct flexiblas_hook_fn LAPACKE_ssytri2x;
    struct flexiblas_hook_fn LAPACKE_ssytri2x_work;
    struct flexiblas_hook_fn LAPACKE_ssytri_3;
    struct flexiblas_hook_fn LAPACKE_ssytri_3_work;
    struct flexiblas_hook_fn LAPACKE_ssytri_work;
    struct flexiblas_hook_fn LAPACKE_ssytrs;
    struct flexiblas_hook_fn LAPACKE_ssytrs2;
    struct flexiblas_hook_fn LAPACKE_ssytrs2_work;
    struct flexiblas_hook_fn LAPACKE_ssytrs_3;
    struct flexiblas_hook_fn LAPACKE_ssytrs_3_work;
    struct flexiblas_hook_fn LAPACKE_ssytrs_aa;
    struct flexiblas_hook_fn LAPACKE_ssytrs_aa_2stage;
    struct flexiblas_hook_fn LAPACKE_ssytrs_aa_2stage_work;
    struct flexiblas_hook_fn LAPACKE_ssytrs_aa_work;
    struct flexiblas_hook_fn LAPACKE_ssytrs_rook;
    struct flexiblas_hook_fn LAPACKE_ssytrs_rook_work;
    struct flexiblas_hook_fn LAPACKE_ssytrs_work;
    struct flexiblas_hook_fn LAPACKE_stbcon;
    struct flexiblas_hook_fn LAPACKE_stbcon_work;
    struct flexiblas_hook_fn LAPACKE_stbrfs;
    struct flexiblas_hook_fn LAPACKE_stbrfs_work;
    struct flexiblas_hook_fn LAPACKE_stbtrs;
    struct flexiblas_hook_fn LAPACKE_stbtrs_work;
    struct flexiblas_hook_fn LAPACKE_stfsm;
    struct flexiblas_hook_fn LAPACKE_stfsm_work;
    struct flexiblas_hook_fn LAPACKE_stftri;
    struct flexiblas_hook_fn LAPACKE_stftri_work;
    struct flexiblas_hook_fn LAPACKE_stfttp;
    struct flexiblas_hook_fn LAPACKE_stfttp_work;
    struct flexiblas_hook_fn LAPACKE_stfttr;
    struct flexiblas_hook_fn LAPACKE_stfttr_work;
    struct flexiblas_hook_fn LAPACKE_stgevc;
    struct flexiblas_hook_fn LAPACKE_stgevc_work;
    struct flexiblas_hook_fn LAPACKE_stgexc;
    struct flexiblas_hook_fn LAPACKE_stgexc_work;
    struct flexiblas_hook_fn LAPACKE_stgsen;
    struct flexiblas_hook_fn LAPACKE_stgsen_work;
    struct flexiblas_hook_fn LAPACKE_stgsja;
    struct flexiblas_hook_fn LAPACKE_stgsja_work;
    struct flexiblas_hook_fn LAPACKE_stgsna;
    struct flexiblas_hook_fn LAPACKE_stgsna_work;
    struct flexiblas_hook_fn LAPACKE_stgsyl;
    struct flexiblas_hook_fn LAPACKE_stgsyl_work;
    struct flexiblas_hook_fn LAPACKE_stpcon;
    struct flexiblas_hook_fn LAPACKE_stpcon_work;
    struct flexiblas_hook_fn LAPACKE_stpmqrt;
    struct flexiblas_hook_fn LAPACKE_stpmqrt_work;
    struct flexiblas_hook_fn LAPACKE_stpqrt;
    struct flexiblas_hook_fn LAPACKE_stpqrt2;
    struct flexiblas_hook_fn LAPACKE_stpqrt2_work;
    struct flexiblas_hook_fn LAPACKE_stpqrt_work;
    struct flexiblas_hook_fn LAPACKE_stprfb;
    struct flexiblas_hook_fn LAPACKE_stprfb_work;
    struct flexiblas_hook_fn LAPACKE_stprfs;
    struct flexiblas_hook_fn LAPACKE_stprfs_work;
    struct flexiblas_hook_fn LAPACKE_stptri;
    struct flexiblas_hook_fn LAPACKE_stptri_work;
    struct flexiblas_hook_fn LAPACKE_stptrs;
    struct flexiblas_hook_fn LAPACKE_stptrs_work;
    struct flexiblas_hook_fn LAPACKE_stpttf;
    struct flexiblas_hook_fn LAPACKE_stpttf_work;
    struct flexiblas_hook_fn LAPACKE_stpttr;
    struct flexiblas_hook_fn LAPACKE_stpttr_work;
    struct flexiblas_hook_fn LAPACKE_strcon;
    struct flexiblas_hook_fn LAPACKE_strcon_work;
    struct flexiblas_hook_fn LAPACKE_strevc;
    struct flexiblas_hook_fn LAPACKE_strevc_work;
    struct flexiblas_hook_fn LAPACKE_strexc;
    struct flexiblas_hook_fn LAPACKE_strexc_work;
    struct flexiblas_hook_fn LAPACKE_strrfs;
    struct flexiblas_hook_fn LAPACKE_strrfs_work;
    struct flexiblas_hook_fn LAPACKE_strsen;
    struct flexiblas_hook_fn LAPACKE_strsen_work;
    struct flexiblas_hook_fn LAPACKE_strsna;
    struct flexiblas_hook_fn LAPACKE_strsna_work;
    struct flexiblas_hook_fn LAPACKE_strsyl;
    struct flexiblas_hook_fn LAPACKE_strsyl3;
    struct flexiblas_hook_fn LAPACKE_strsyl3_work;
    struct flexiblas_hook_fn LAPACKE_strsyl_work;
    struct flexiblas_hook_fn LAPACKE_strtri;
    struct flexiblas_hook_fn LAPACKE_strtri_work;
    struct flexiblas_hook_fn LAPACKE_strtrs;
    struct flexiblas_hook_fn LAPACKE_strtrs_work;
    struct flexiblas_hook_fn LAPACKE_strttf;
    struct flexiblas_hook_fn LAPACKE_strttf_work;
    struct flexiblas_hook_fn LAPACKE_strttp;
    struct flexiblas_hook_fn LAPACKE_strttp_work;
    struct flexiblas_hook_fn LAPACKE_stzrzf;
    struct flexiblas_hook_fn LAPACKE_stzrzf_work;
    struct flexiblas_hook_fn LAPACKE_zbbcsd;
    struct flexiblas_hook_fn LAPACKE_zbbcsd_work;
    struct flexiblas_hook_fn LAPACKE_zbdsqr;
    struct flexiblas_hook_fn LAPACKE_zbdsqr_work;
    struct flexiblas_hook_fn LAPACKE_zcgesv;
    struct flexiblas_hook_fn LAPACKE_zcgesv_work;
    struct flexiblas_hook_fn LAPACKE_zcposv;
    struct flexiblas_hook_fn LAPACKE_zcposv_work;
    struct flexiblas_hook_fn LAPACKE_zgbbrd;
    struct flexiblas_hook_fn LAPACKE_zgbbrd_work;
    struct flexiblas_hook_fn LAPACKE_zgbcon;
    struct flexiblas_hook_fn LAPACKE_zgbcon_work;
    struct flexiblas_hook_fn LAPACKE_zgbequ;
    struct flexiblas_hook_fn LAPACKE_zgbequ_work;
    struct flexiblas_hook_fn LAPACKE_zgbequb;
    struct flexiblas_hook_fn LAPACKE_zgbequb_work;
    struct flexiblas_hook_fn LAPACKE_zgbrfs;
    struct flexiblas_hook_fn LAPACKE_zgbrfs_work;
    struct flexiblas_hook_fn LAPACKE_zgbrfsx;
    struct flexiblas_hook_fn LAPACKE_zgbrfsx_work;
    struct flexiblas_hook_fn LAPACKE_zgbsv;
    struct flexiblas_hook_fn LAPACKE_zgbsv_work;
    struct flexiblas_hook_fn LAPACKE_zgbsvx;
    struct flexiblas_hook_fn LAPACKE_zgbsvx_work;
    struct flexiblas_hook_fn LAPACKE_zgbsvxx;
    struct flexiblas_hook_fn LAPACKE_zgbsvxx_work;
    struct flexiblas_hook_fn LAPACKE_zgbtrf;
    struct flexiblas_hook_fn LAPACKE_zgbtrf_work;
    struct flexiblas_hook_fn LAPACKE_zgbtrs;
    struct flexiblas_hook_fn LAPACKE_zgbtrs_work;
    struct flexiblas_hook_fn LAPACKE_zgebak;
    struct flexiblas_hook_fn LAPACKE_zgebak_work;
    struct flexiblas_hook_fn LAPACKE_zgebal;
    struct flexiblas_hook_fn LAPACKE_zgebal_work;
    struct flexiblas_hook_fn LAPACKE_zgebrd;
    struct flexiblas_hook_fn LAPACKE_zgebrd_work;
    struct flexiblas_hook_fn LAPACKE_zgecon;
    struct flexiblas_hook_fn LAPACKE_zgecon_work;
    struct flexiblas_hook_fn LAPACKE_zgedmd_work;
    struct flexiblas_hook_fn LAPACKE_zgedmdq_work;
    struct flexiblas_hook_fn LAPACKE_zgeequ;
    struct flexiblas_hook_fn LAPACKE_zgeequ_work;
    struct flexiblas_hook_fn LAPACKE_zgeequb;
    struct flexiblas_hook_fn LAPACKE_zgeequb_work;
    struct flexiblas_hook_fn LAPACKE_zgees;
    struct flexiblas_hook_fn LAPACKE_zgees_work;
    struct flexiblas_hook_fn LAPACKE_zgeesx;
    struct flexiblas_hook_fn LAPACKE_zgeesx_work;
    struct flexiblas_hook_fn LAPACKE_zgeev;
    struct flexiblas_hook_fn LAPACKE_zgeev_work;
    struct flexiblas_hook_fn LAPACKE_zgeevx;
    struct flexiblas_hook_fn LAPACKE_zgeevx_work;
    struct flexiblas_hook_fn LAPACKE_zgehrd;
    struct flexiblas_hook_fn LAPACKE_zgehrd_work;
    struct flexiblas_hook_fn LAPACKE_zgejsv;
    struct flexiblas_hook_fn LAPACKE_zgejsv_work;
    struct flexiblas_hook_fn LAPACKE_zgelq;
    struct flexiblas_hook_fn LAPACKE_zgelq2;
    struct flexiblas_hook_fn LAPACKE_zgelq2_work;
    struct flexiblas_hook_fn LAPACKE_zgelq_work;
    struct flexiblas_hook_fn LAPACKE_zgelqf;
    struct flexiblas_hook_fn LAPACKE_zgelqf_work;
    struct flexiblas_hook_fn LAPACKE_zgels;
    struct flexiblas_hook_fn LAPACKE_zgels_work;
    struct flexiblas_hook_fn LAPACKE_zgelsd;
    struct flexiblas_hook_fn LAPACKE_zgelsd_work;
    struct flexiblas_hook_fn LAPACKE_zgelss;
    struct flexiblas_hook_fn LAPACKE_zgelss_work;
    struct flexiblas_hook_fn LAPACKE_zgelsy;
    struct flexiblas_hook_fn LAPACKE_zgelsy_work;
    struct flexiblas_hook_fn LAPACKE_zgemlq;
    struct flexiblas_hook_fn LAPACKE_zgemlq_work;
    struct flexiblas_hook_fn LAPACKE_zgemqr;
    struct flexiblas_hook_fn LAPACKE_zgemqr_work;
    struct flexiblas_hook_fn LAPACKE_zgemqrt;
    struct flexiblas_hook_fn LAPACKE_zgemqrt_work;
    struct flexiblas_hook_fn LAPACKE_zgeqlf;
    struct flexiblas_hook_fn LAPACKE_zgeqlf_work;
    struct flexiblas_hook_fn LAPACKE_zgeqp3;
    struct flexiblas_hook_fn LAPACKE_zgeqp3_work;
    struct flexiblas_hook_fn LAPACKE_zgeqpf;
    struct flexiblas_hook_fn LAPACKE_zgeqpf_work;
    struct flexiblas_hook_fn LAPACKE_zgeqr;
    struct flexiblas_hook_fn LAPACKE_zgeqr2;
    struct flexiblas_hook_fn LAPACKE_zgeqr2_work;
    struct flexiblas_hook_fn LAPACKE_zgeqr_work;
    struct flexiblas_hook_fn LAPACKE_zgeqrf;
    struct flexiblas_hook_fn LAPACKE_zgeqrf_work;
    struct flexiblas_hook_fn LAPACKE_zgeqrfp;
    struct flexiblas_hook_fn LAPACKE_zgeqrfp_work;
    struct flexiblas_hook_fn LAPACKE_zgeqrt;
    struct flexiblas_hook_fn LAPACKE_zgeqrt2;
    struct flexiblas_hook_fn LAPACKE_zgeqrt2_work;
    struct flexiblas_hook_fn LAPACKE_zgeqrt3;
    struct flexiblas_hook_fn LAPACKE_zgeqrt3_work;
    struct flexiblas_hook_fn LAPACKE_zgeqrt_work;
    struct flexiblas_hook_fn LAPACKE_zgerfs;
    struct flexiblas_hook_fn LAPACKE_zgerfs_work;
    struct flexiblas_hook_fn LAPACKE_zgerfsx;
    struct flexiblas_hook_fn LAPACKE_zgerfsx_work;
    struct flexiblas_hook_fn LAPACKE_zgerqf;
    struct flexiblas_hook_fn LAPACKE_zgerqf_work;
    struct flexiblas_hook_fn LAPACKE_zgesdd;
    struct flexiblas_hook_fn LAPACKE_zgesdd_work;
    struct flexiblas_hook_fn LAPACKE_zgesv;
    struct flexiblas_hook_fn LAPACKE_zgesv_work;
    struct flexiblas_hook_fn LAPACKE_zgesvd;
    struct flexiblas_hook_fn LAPACKE_zgesvd_work;
    struct flexiblas_hook_fn LAPACKE_zgesvdq;
    struct flexiblas_hook_fn LAPACKE_zgesvdq_work;
    struct flexiblas_hook_fn LAPACKE_zgesvdx;
    struct flexiblas_hook_fn LAPACKE_zgesvdx_work;
    struct flexiblas_hook_fn LAPACKE_zgesvj;
    struct flexiblas_hook_fn LAPACKE_zgesvj_work;
    struct flexiblas_hook_fn LAPACKE_zgesvx;
    struct flexiblas_hook_fn LAPACKE_zgesvx_work;
    struct flexiblas_hook_fn LAPACKE_zgesvxx;
    struct flexiblas_hook_fn LAPACKE_zgesvxx_work;
    struct flexiblas_hook_fn LAPACKE_zgetf2;
    struct flexiblas_hook_fn LAPACKE_zgetf2_work;
    struct flexiblas_hook_fn LAPACKE_zgetrf;
    struct flexiblas_hook_fn LAPACKE_zgetrf2;
    struct flexiblas_hook_fn LAPACKE_zgetrf2_work;
    struct flexiblas_hook_fn LAPACKE_zgetrf_work;
    struct flexiblas_hook_fn LAPACKE_zgetri;
    struct flexiblas_hook_fn LAPACKE_zgetri_work;
    struct flexiblas_hook_fn LAPACKE_zgetrs;
    struct flexiblas_hook_fn LAPACKE_zgetrs_work;
    struct flexiblas_hook_fn LAPACKE_zgetsls;
    struct flexiblas_hook_fn LAPACKE_zgetsls_work;
    struct flexiblas_hook_fn LAPACKE_zgetsqrhrt;
    struct flexiblas_hook_fn LAPACKE_zgetsqrhrt_work;
    struct flexiblas_hook_fn LAPACKE_zggbak;
    struct flexiblas_hook_fn LAPACKE_zggbak_work;
    struct flexiblas_hook_fn LAPACKE_zggbal;
    struct flexiblas_hook_fn LAPACKE_zggbal_work;
    struct flexiblas_hook_fn LAPACKE_zgges;
    struct flexiblas_hook_fn LAPACKE_zgges3;
    struct flexiblas_hook_fn LAPACKE_zgges3_work;
    struct flexiblas_hook_fn LAPACKE_zgges_work;
    struct flexiblas_hook_fn LAPACKE_zggesx;
    struct flexiblas_hook_fn LAPACKE_zggesx_work;
    struct flexiblas_hook_fn LAPACKE_zggev;
    struct flexiblas_hook_fn LAPACKE_zggev3;
    struct flexiblas_hook_fn LAPACKE_zggev3_work;
    struct flexiblas_hook_fn LAPACKE_zggev_work;
    struct flexiblas_hook_fn LAPACKE_zggevx;
    struct flexiblas_hook_fn LAPACKE_zggevx_work;
    struct flexiblas_hook_fn LAPACKE_zggglm;
    struct flexiblas_hook_fn LAPACKE_zggglm_work;
    struct flexiblas_hook_fn LAPACKE_zgghd3;
    struct flexiblas_hook_fn LAPACKE_zgghd3_work;
    struct flexiblas_hook_fn LAPACKE_zgghrd;
    struct flexiblas_hook_fn LAPACKE_zgghrd_work;
    struct flexiblas_hook_fn LAPACKE_zgglse;
    struct flexiblas_hook_fn LAPACKE_zgglse_work;
    struct flexiblas_hook_fn LAPACKE_zggqrf;
    struct flexiblas_hook_fn LAPACKE_zggqrf_work;
    struct flexiblas_hook_fn LAPACKE_zggrqf;
    struct flexiblas_hook_fn LAPACKE_zggrqf_work;
    struct flexiblas_hook_fn LAPACKE_zggsvd;
    struct flexiblas_hook_fn LAPACKE_zggsvd3;
    struct flexiblas_hook_fn LAPACKE_zggsvd3_work;
    struct flexiblas_hook_fn LAPACKE_zggsvd_work;
    struct flexiblas_hook_fn LAPACKE_zggsvp;
    struct flexiblas_hook_fn LAPACKE_zggsvp3;
    struct flexiblas_hook_fn LAPACKE_zggsvp3_work;
    struct flexiblas_hook_fn LAPACKE_zggsvp_work;
    struct flexiblas_hook_fn LAPACKE_zgtcon;
    struct flexiblas_hook_fn LAPACKE_zgtcon_work;
    struct flexiblas_hook_fn LAPACKE_zgtrfs;
    struct flexiblas_hook_fn LAPACKE_zgtrfs_work;
    struct flexiblas_hook_fn LAPACKE_zgtsv;
    struct flexiblas_hook_fn LAPACKE_zgtsv_work;
    struct flexiblas_hook_fn LAPACKE_zgtsvx;
    struct flexiblas_hook_fn LAPACKE_zgtsvx_work;
    struct flexiblas_hook_fn LAPACKE_zgttrf;
    struct flexiblas_hook_fn LAPACKE_zgttrf_work;
    struct flexiblas_hook_fn LAPACKE_zgttrs;
    struct flexiblas_hook_fn LAPACKE_zgttrs_work;
    struct flexiblas_hook_fn LAPACKE_zhbev;
    struct flexiblas_hook_fn LAPACKE_zhbev_2stage;
    struct flexiblas_hook_fn LAPACKE_zhbev_2stage_work;
    struct flexiblas_hook_fn LAPACKE_zhbev_work;
    struct flexiblas_hook_fn LAPACKE_zhbevd;
    struct flexiblas_hook_fn LAPACKE_zhbevd_2stage;
    struct flexiblas_hook_fn LAPACKE_zhbevd_2stage_work;
    struct flexiblas_hook_fn LAPACKE_zhbevd_work;
    struct flexiblas_hook_fn LAPACKE_zhbevx;
    struct flexiblas_hook_fn LAPACKE_zhbevx_2stage;
    struct flexiblas_hook_fn LAPACKE_zhbevx_2stage_work;
    struct flexiblas_hook_fn LAPACKE_zhbevx_work;
    struct flexiblas_hook_fn LAPACKE_zhbgst;
    struct flexiblas_hook_fn LAPACKE_zhbgst_work;
    struct flexiblas_hook_fn LAPACKE_zhbgv;
    struct flexiblas_hook_fn LAPACKE_zhbgv_work;
    struct flexiblas_hook_fn LAPACKE_zhbgvd;
    struct flexiblas_hook_fn LAPACKE_zhbgvd_work;
    struct flexiblas_hook_fn LAPACKE_zhbgvx;
    struct flexiblas_hook_fn LAPACKE_zhbgvx_work;
    struct flexiblas_hook_fn LAPACKE_zhbtrd;
    struct flexiblas_hook_fn LAPACKE_zhbtrd_work;
    struct flexiblas_hook_fn LAPACKE_zhecon;
    struct flexiblas_hook_fn LAPACKE_zhecon_3;
    struct flexiblas_hook_fn LAPACKE_zhecon_3_work;
    struct flexiblas_hook_fn LAPACKE_zhecon_work;
    struct flexiblas_hook_fn LAPACKE_zheequb;
    struct flexiblas_hook_fn LAPACKE_zheequb_work;
    struct flexiblas_hook_fn LAPACKE_zheev;
    struct flexiblas_hook_fn LAPACKE_zheev_2stage;
    struct flexiblas_hook_fn LAPACKE_zheev_2stage_work;
    struct flexiblas_hook_fn LAPACKE_zheev_work;
    struct flexiblas_hook_fn LAPACKE_zheevd;
    struct flexiblas_hook_fn LAPACKE_zheevd_2stage;
    struct flexiblas_hook_fn LAPACKE_zheevd_2stage_work;
    struct flexiblas_hook_fn LAPACKE_zheevd_work;
    struct flexiblas_hook_fn LAPACKE_zheevr;
    struct flexiblas_hook_fn LAPACKE_zheevr_2stage;
    struct flexiblas_hook_fn LAPACKE_zheevr_2stage_work;
    struct flexiblas_hook_fn LAPACKE_zheevr_work;
    struct flexiblas_hook_fn LAPACKE_zheevx;
    struct flexiblas_hook_fn LAPACKE_zheevx_2stage;
    struct flexiblas_hook_fn LAPACKE_zheevx_2stage_work;
    struct flexiblas_hook_fn LAPACKE_zheevx_work;
    struct flexiblas_hook_fn LAPACKE_zhegst;
    struct flexiblas_hook_fn LAPACKE_zhegst_work;
    struct flexiblas_hook_fn LAPACKE_zhegv;
    struct flexiblas_hook_fn LAPACKE_zhegv_2stage;
    struct flexiblas_hook_fn LAPACKE_zhegv_2stage_work;
    struct flexiblas_hook_fn LAPACKE_zhegv_work;
    struct flexiblas_hook_fn LAPACKE_zhegvd;
    struct flexiblas_hook_fn LAPACKE_zhegvd_work;
    struct flexiblas_hook_fn LAPACKE_zhegvx;
    struct flexiblas_hook_fn LAPACKE_zhegvx_work;
    struct flexiblas_hook_fn LAPACKE_zherfs;
    struct flexiblas_hook_fn LAPACKE_zherfs_work;
    struct flexiblas_hook_fn LAPACKE_zherfsx;
    struct flexiblas_hook_fn LAPACKE_zherfsx_work;
    struct flexiblas_hook_fn LAPACKE_zhesv;
    struct flexiblas_hook_fn LAPACKE_zhesv_aa;
    struct flexiblas_hook_fn LAPACKE_zhesv_aa_2stage;
    struct flexiblas_hook_fn LAPACKE_zhesv_aa_2stage_work;
    struct flexiblas_hook_fn LAPACKE_zhesv_aa_work;
    struct flexiblas_hook_fn LAPACKE_zhesv_rk;
    struct flexiblas_hook_fn LAPACKE_zhesv_rk_work;
    struct flexiblas_hook_fn LAPACKE_zhesv_work;
    struct flexiblas_hook_fn LAPACKE_zhesvx;
    struct flexiblas_hook_fn LAPACKE_zhesvx_work;
    struct flexiblas_hook_fn LAPACKE_zhesvxx;
    struct flexiblas_hook_fn LAPACKE_zhesvxx_work;
    struct flexiblas_hook_fn LAPACKE_zheswapr;
    struct flexiblas_hook_fn LAPACKE_zheswapr_work;
    struct flexiblas_hook_fn LAPACKE_zhetrd;
    struct flexiblas_hook_fn LAPACKE_zhetrd_work;
    struct flexiblas_hook_fn LAPACKE_zhetrf;
    struct flexiblas_hook_fn LAPACKE_zhetrf_aa;
    struct flexiblas_hook_fn LAPACKE_zhetrf_aa_2stage;
    struct flexiblas_hook_fn LAPACKE_zhetrf_aa_2stage_work;
    struct flexiblas_hook_fn LAPACKE_zhetrf_aa_work;
    struct flexiblas_hook_fn LAPACKE_zhetrf_rk;
    struct flexiblas_hook_fn LAPACKE_zhetrf_rk_work;
    struct flexiblas_hook_fn LAPACKE_zhetrf_rook;
    struct flexiblas_hook_fn LAPACKE_zhetrf_rook_work;
    struct flexiblas_hook_fn LAPACKE_zhetrf_work;
    struct flexiblas_hook_fn LAPACKE_zhetri;
    struct flexiblas_hook_fn LAPACKE_zhetri2;
    struct flexiblas_hook_fn LAPACKE_zhetri2_work;
    struct flexiblas_hook_fn LAPACKE_zhetri2x;
    struct flexiblas_hook_fn LAPACKE_zhetri2x_work;
    struct flexiblas_hook_fn LAPACKE_zhetri_3;
    struct flexiblas_hook_fn LAPACKE_zhetri_3_work;
    struct flexiblas_hook_fn LAPACKE_zhetri_work;
    struct flexiblas_hook_fn LAPACKE_zhetrs;
    struct flexiblas_hook_fn LAPACKE_zhetrs2;
    struct flexiblas_hook_fn LAPACKE_zhetrs2_work;
    struct flexiblas_hook_fn LAPACKE_zhetrs_3;
    struct flexiblas_hook_fn LAPACKE_zhetrs_3_work;
    struct flexiblas_hook_fn LAPACKE_zhetrs_aa;
    struct flexiblas_hook_fn LAPACKE_zhetrs_aa_2stage;
    struct flexiblas_hook_fn LAPACKE_zhetrs_aa_2stage_work;
    struct flexiblas_hook_fn LAPACKE_zhetrs_aa_work;
    struct flexiblas_hook_fn LAPACKE_zhetrs_rook;
    struct flexiblas_hook_fn LAPACKE_zhetrs_rook_work;
    struct flexiblas_hook_fn LAPACKE_zhetrs_work;
    struct flexiblas_hook_fn LAPACKE_zhfrk;
    struct flexiblas_hook_fn LAPACKE_zhfrk_work;
    struct flexiblas_hook_fn LAPACKE_zhgeqz;
    struct flexiblas_hook_fn LAPACKE_zhgeqz_work;
    struct flexiblas_hook_fn LAPACKE_zhpcon;
    struct flexiblas_hook_fn LAPACKE_zhpcon_work;
    struct flexiblas_hook_fn LAPACKE_zhpev;
    struct flexiblas_hook_fn LAPACKE_zhpev_work;
    struct flexiblas_hook_fn LAPACKE_zhpevd;
    struct flexiblas_hook_fn LAPACKE_zhpevd_work;
    struct flexiblas_hook_fn LAPACKE_zhpevx;
    struct flexiblas_hook_fn LAPACKE_zhpevx_work;
    struct flexiblas_hook_fn LAPACKE_zhpgst;
    struct flexiblas_hook_fn LAPACKE_zhpgst_work;
    struct flexiblas_hook_fn LAPACKE_zhpgv;
    struct flexiblas_hook_fn LAPACKE_zhpgv_work;
    struct flexiblas_hook_fn LAPACKE_zhpgvd;
    struct flexiblas_hook_fn LAPACKE_zhpgvd_work;
    struct flexiblas_hook_fn LAPACKE_zhpgvx;
    struct flexiblas_hook_fn LAPACKE_zhpgvx_work;
    struct flexiblas_hook_fn LAPACKE_zhprfs;
    struct flexiblas_hook_fn LAPACKE_zhprfs_work;
    struct flexiblas_hook_fn LAPACKE_zhpsv;
    struct flexiblas_hook_fn LAPACKE_zhpsv_work;
    struct flexiblas_hook_fn LAPACKE_zhpsvx;
    struct flexiblas_hook_fn LAPACKE_zhpsvx_work;
    struct flexiblas_hook_fn LAPACKE_zhptrd;
    struct flexiblas_hook_fn LAPACKE_zhptrd_work;
    struct flexiblas_hook_fn LAPACKE_zhptrf;
    struct flexiblas_hook_fn LAPACKE_zhptrf_work;
    struct flexiblas_hook_fn LAPACKE_zhptri;
    struct flexiblas_hook_fn LAPACKE_zhptri_work;
    struct flexiblas_hook_fn LAPACKE_zhptrs;
    struct flexiblas_hook_fn LAPACKE_zhptrs_work;
    struct flexiblas_hook_fn LAPACKE_zhsein;
    struct flexiblas_hook_fn LAPACKE_zhsein_work;
    struct flexiblas_hook_fn LAPACKE_zhseqr;
    struct flexiblas_hook_fn LAPACKE_zhseqr_work;
    struct flexiblas_hook_fn LAPACKE_zlacgv;
    struct flexiblas_hook_fn LAPACKE_zlacgv_work;
    struct flexiblas_hook_fn LAPACKE_zlacn2;
    struct flexiblas_hook_fn LAPACKE_zlacn2_work;
    struct flexiblas_hook_fn LAPACKE_zlacp2;
    struct flexiblas_hook_fn LAPACKE_zlacp2_work;
    struct flexiblas_hook_fn LAPACKE_zlacpy;
    struct flexiblas_hook_fn LAPACKE_zlacpy_work;
    struct flexiblas_hook_fn LAPACKE_zlacrm;
    struct flexiblas_hook_fn LAPACKE_zlacrm_work;
    struct flexiblas_hook_fn LAPACKE_zlag2c;
    struct flexiblas_hook_fn LAPACKE_zlag2c_work;
    struct flexiblas_hook_fn LAPACKE_zlagge;
    struct flexiblas_hook_fn LAPACKE_zlagge_work;
    struct flexiblas_hook_fn LAPACKE_zlaghe;
    struct flexiblas_hook_fn LAPACKE_zlaghe_work;
    struct flexiblas_hook_fn LAPACKE_zlagsy;
    struct flexiblas_hook_fn LAPACKE_zlagsy_work;
    struct flexiblas_hook_fn LAPACKE_zlangb;
    struct flexiblas_hook_fn LAPACKE_zlangb_work;
    struct flexiblas_hook_fn LAPACKE_zlange;
    struct flexiblas_hook_fn LAPACKE_zlange_work;
    struct flexiblas_hook_fn LAPACKE_zlanhe;
    struct flexiblas_hook_fn LAPACKE_zlanhe_work;
    struct flexiblas_hook_fn LAPACKE_zlansy;
    struct flexiblas_hook_fn LAPACKE_zlansy_work;
    struct flexiblas_hook_fn LAPACKE_zlantr;
    struct flexiblas_hook_fn LAPACKE_zlantr_work;
    struct flexiblas_hook_fn LAPACKE_zlapmr;
    struct flexiblas_hook_fn LAPACKE_zlapmr_work;
    struct flexiblas_hook_fn LAPACKE_zlapmt;
    struct flexiblas_hook_fn LAPACKE_zlapmt_work;
    struct flexiblas_hook_fn LAPACKE_zlarcm;
    struct flexiblas_hook_fn LAPACKE_zlarcm_work;
    struct flexiblas_hook_fn LAPACKE_zlarfb;
    struct flexiblas_hook_fn LAPACKE_zlarfb_work;
    struct flexiblas_hook_fn LAPACKE_zlarfg;
    struct flexiblas_hook_fn LAPACKE_zlarfg_work;
    struct flexiblas_hook_fn LAPACKE_zlarft;
    struct flexiblas_hook_fn LAPACKE_zlarft_work;
    struct flexiblas_hook_fn LAPACKE_zlarfx;
    struct flexiblas_hook_fn LAPACKE_zlarfx_work;
    struct flexiblas_hook_fn LAPACKE_zlarnv;
    struct flexiblas_hook_fn LAPACKE_zlarnv_work;
    struct flexiblas_hook_fn LAPACKE_zlascl;
    struct flexiblas_hook_fn LAPACKE_zlascl_work;
    struct flexiblas_hook_fn LAPACKE_zlaset;
    struct flexiblas_hook_fn LAPACKE_zlaset_work;
    struct flexiblas_hook_fn LAPACKE_zlassq;
    struct flexiblas_hook_fn LAPACKE_zlassq_work;
    struct flexiblas_hook_fn LAPACKE_zlaswp;
    struct flexiblas_hook_fn LAPACKE_zlaswp_work;
    struct flexiblas_hook_fn LAPACKE_zlatms;
    struct flexiblas_hook_fn LAPACKE_zlatms_work;
    struct flexiblas_hook_fn LAPACKE_zlauum;
    struct flexiblas_hook_fn LAPACKE_zlauum_work;
    struct flexiblas_hook_fn LAPACKE_zpbcon;
    struct flexiblas_hook_fn LAPACKE_zpbcon_work;
    struct flexiblas_hook_fn LAPACKE_zpbequ;
    struct flexiblas_hook_fn LAPACKE_zpbequ_work;
    struct flexiblas_hook_fn LAPACKE_zpbrfs;
    struct flexiblas_hook_fn LAPACKE_zpbrfs_work;
    struct flexiblas_hook_fn LAPACKE_zpbstf;
    struct flexiblas_hook_fn LAPACKE_zpbstf_work;
    struct flexiblas_hook_fn LAPACKE_zpbsv;
    struct flexiblas_hook_fn LAPACKE_zpbsv_work;
    struct flexiblas_hook_fn LAPACKE_zpbsvx;
    struct flexiblas_hook_fn LAPACKE_zpbsvx_work;
    struct flexiblas_hook_fn LAPACKE_zpbtrf;
    struct flexiblas_hook_fn LAPACKE_zpbtrf_work;
    struct flexiblas_hook_fn LAPACKE_zpbtrs;
    struct flexiblas_hook_fn LAPACKE_zpbtrs_work;
    struct flexiblas_hook_fn LAPACKE_zpftrf;
    struct flexiblas_hook_fn LAPACKE_zpftrf_work;
    struct flexiblas_hook_fn LAPACKE_zpftri;
    struct flexiblas_hook_fn LAPACKE_zpftri_work;
    struct flexiblas_hook_fn LAPACKE_zpftrs;
    struct flexiblas_hook_fn LAPACKE_zpftrs_work;
    struct flexiblas_hook_fn LAPACKE_zpocon;
    struct flexiblas_hook_fn LAPACKE_zpocon_work;
    struct flexiblas_hook_fn LAPACKE_zpoequ;
    struct flexiblas_hook_fn LAPACKE_zpoequ_work;
    struct flexiblas_hook_fn LAPACKE_zpoequb;
    struct flexiblas_hook_fn LAPACKE_zpoequb_work;
    struct flexiblas_hook_fn LAPACKE_zporfs;
    struct flexiblas_hook_fn LAPACKE_zporfs_work;
    struct flexiblas_hook_fn LAPACKE_zporfsx;
    struct flexiblas_hook_fn LAPACKE_zporfsx_work;
    struct flexiblas_hook_fn LAPACKE_zposv;
    struct flexiblas_hook_fn LAPACKE_zposv_work;
    struct flexiblas_hook_fn LAPACKE_zposvx;
    struct flexiblas_hook_fn LAPACKE_zposvx_work;
    struct flexiblas_hook_fn LAPACKE_zposvxx;
    struct flexiblas_hook_fn LAPACKE_zposvxx_work;
    struct flexiblas_hook_fn LAPACKE_zpotrf;
    struct flexiblas_hook_fn LAPACKE_zpotrf2;
    struct flexiblas_hook_fn LAPACKE_zpotrf2_work;
    struct flexiblas_hook_fn LAPACKE_zpotrf_work;
    struct flexiblas_hook_fn LAPACKE_zpotri;
    struct flexiblas_hook_fn LAPACKE_zpotri_work;
    struct flexiblas_hook_fn LAPACKE_zpotrs;
    struct flexiblas_hook_fn LAPACKE_zpotrs_work;
    struct flexiblas_hook_fn LAPACKE_zppcon;
    struct flexiblas_hook_fn LAPACKE_zppcon_work;
    struct flexiblas_hook_fn LAPACKE_zppequ;
    struct flexiblas_hook_fn LAPACKE_zppequ_work;
    struct flexiblas_hook_fn LAPACKE_zpprfs;
    struct flexiblas_hook_fn LAPACKE_zpprfs_work;
    struct flexiblas_hook_fn LAPACKE_zppsv;
    struct flexiblas_hook_fn LAPACKE_zppsv_work;
    struct flexiblas_hook_fn LAPACKE_zppsvx;
    struct flexiblas_hook_fn LAPACKE_zppsvx_work;
    struct flexiblas_hook_fn LAPACKE_zpptrf;
    struct flexiblas_hook_fn LAPACKE_zpptrf_work;
    struct flexiblas_hook_fn LAPACKE_zpptri;
    struct flexiblas_hook_fn LAPACKE_zpptri_work;
    struct flexiblas_hook_fn LAPACKE_zpptrs;
    struct flexiblas_hook_fn LAPACKE_zpptrs_work;
    struct flexiblas_hook_fn LAPACKE_zpstrf;
    struct flexiblas_hook_fn LAPACKE_zpstrf_work;
    struct flexiblas_hook_fn LAPACKE_zptcon;
    struct flexiblas_hook_fn LAPACKE_zptcon_work;
    struct flexiblas_hook_fn LAPACKE_zpteqr;
    struct flexiblas_hook_fn LAPACKE_zpteqr_work;
    struct flexiblas_hook_fn LAPACKE_zptrfs;
    struct flexiblas_hook_fn LAPACKE_zptrfs_work;
    struct flexiblas_hook_fn LAPACKE_zptsv;
    struct flexiblas_hook_fn LAPACKE_zptsv_work;
    struct flexiblas_hook_fn LAPACKE_zptsvx;
    struct flexiblas_hook_fn LAPACKE_zptsvx_work;
    struct flexiblas_hook_fn LAPACKE_zpttrf;
    struct flexiblas_hook_fn LAPACKE_zpttrf_work;
    struct flexiblas_hook_fn LAPACKE_zpttrs;
    struct flexiblas_hook_fn LAPACKE_zpttrs_work;
    struct flexiblas_hook_fn LAPACKE_zspcon;
    struct flexiblas_hook_fn LAPACKE_zspcon_work;
    struct flexiblas_hook_fn LAPACKE_zsprfs;
    struct flexiblas_hook_fn LAPACKE_zsprfs_work;
    struct flexiblas_hook_fn LAPACKE_zspsv;
    struct flexiblas_hook_fn LAPACKE_zspsv_work;
    struct flexiblas_hook_fn LAPACKE_zspsvx;
    struct flexiblas_hook_fn LAPACKE_zspsvx_work;
    struct flexiblas_hook_fn LAPACKE_zsptrf;
    struct flexiblas_hook_fn LAPACKE_zsptrf_work;
    struct flexiblas_hook_fn LAPACKE_zsptri;
    struct flexiblas_hook_fn LAPACKE_zsptri_work;
    struct flexiblas_hook_fn LAPACKE_zsptrs;
    struct flexiblas_hook_fn LAPACKE_zsptrs_work;
    struct flexiblas_hook_fn LAPACKE_zstedc;
    struct flexiblas_hook_fn LAPACKE_zstedc_work;
    struct flexiblas_hook_fn LAPACKE_zstegr;
    struct flexiblas_hook_fn LAPACKE_zstegr_work;
    struct flexiblas_hook_fn LAPACKE_zstein;
    struct flexiblas_hook_fn LAPACKE_zstein_work;
    struct flexiblas_hook_fn LAPACKE_zstemr;
    struct flexiblas_hook_fn LAPACKE_zstemr_work;
    struct flexiblas_hook_fn LAPACKE_zsteqr;
    struct flexiblas_hook_fn LAPACKE_zsteqr_work;
    struct flexiblas_hook_fn LAPACKE_zsycon;
    struct flexiblas_hook_fn LAPACKE_zsycon_3;
    struct flexiblas_hook_fn LAPACKE_zsycon_3_work;
    struct flexiblas_hook_fn LAPACKE_zsycon_work;
    struct flexiblas_hook_fn LAPACKE_zsyconv;
    struct flexiblas_hook_fn LAPACKE_zsyconv_work;
    struct flexiblas_hook_fn LAPACKE_zsyequb;
    struct flexiblas_hook_fn LAPACKE_zsyequb_work;
    struct flexiblas_hook_fn LAPACKE_zsyr;
    struct flexiblas_hook_fn LAPACKE_zsyr_work;
    struct flexiblas_hook_fn LAPACKE_zsyrfs;
    struct flexiblas_hook_fn LAPACKE_zsyrfs_work;
    struct flexiblas_hook_fn LAPACKE_zsyrfsx;
    struct flexiblas_hook_fn LAPACKE_zsyrfsx_work;
    struct flexiblas_hook_fn LAPACKE_zsysv;
    struct flexiblas_hook_fn LAPACKE_zsysv_aa;
    struct flexiblas_hook_fn LAPACKE_zsysv_aa_2stage;
    struct flexiblas_hook_fn LAPACKE_zsysv_aa_2stage_work;
    struct flexiblas_hook_fn LAPACKE_zsysv_aa_work;
    struct flexiblas_hook_fn LAPACKE_zsysv_rk;
    struct flexiblas_hook_fn LAPACKE_zsysv_rk_work;
    struct flexiblas_hook_fn LAPACKE_zsysv_rook;
    struct flexiblas_hook_fn LAPACKE_zsysv_rook_work;
    struct flexiblas_hook_fn LAPACKE_zsysv_work;
    struct flexiblas_hook_fn LAPACKE_zsysvx;
    struct flexiblas_hook_fn LAPACKE_zsysvx_work;
    struct flexiblas_hook_fn LAPACKE_zsysvxx;
    struct flexiblas_hook_fn LAPACKE_zsysvxx_work;
    struct flexiblas_hook_fn LAPACKE_zsyswapr;
    struct flexiblas_hook_fn LAPACKE_zsyswapr_work;
    struct flexiblas_hook_fn LAPACKE_zsytrf;
    struct flexiblas_hook_fn LAPACKE_zsytrf_aa;
    struct flexiblas_hook_fn LAPACKE_zsytrf_aa_2stage;
    struct flexiblas_hook_fn LAPACKE_zsytrf_aa_2stage_work;
    struct flexiblas_hook_fn LAPACKE_zsytrf_aa_work;
    struct flexiblas_hook_fn LAPACKE_zsytrf_rk;
    struct flexiblas_hook_fn LAPACKE_zsytrf_rk_work;
    struct flexiblas_hook_fn LAPACKE_zsytrf_rook;
    struct flexiblas_hook_fn LAPACKE_zsytrf_rook_work;
    struct flexiblas_hook_fn LAPACKE_zsytrf_work;
    struct flexiblas_hook_fn LAPACKE_zsytri;
    struct flexiblas_hook_fn LAPACKE_zsytri2;
    struct flexiblas_hook_fn LAPACKE_zsytri2_work;
    struct flexiblas_hook_fn LAPACKE_zsytri2x;
    struct flexiblas_hook_fn LAPACKE_zsytri2x_work;
    struct flexiblas_hook_fn LAPACKE_zsytri_3;
    struct flexiblas_hook_fn LAPACKE_zsytri_3_work;
    struct flexiblas_hook_fn LAPACKE_zsytri_work;
    struct flexiblas_hook_fn LAPACKE_zsytrs;
    struct flexiblas_hook_fn LAPACKE_zsytrs2;
    struct flexiblas_hook_fn LAPACKE_zsytrs2_work;
    struct flexiblas_hook_fn LAPACKE_zsytrs_3;
    struct flexiblas_hook_fn LAPACKE_zsytrs_3_work;
    struct flexiblas_hook_fn LAPACKE_zsytrs_aa;
    struct flexiblas_hook_fn LAPACKE_zsytrs_aa_2stage;
    struct flexiblas_hook_fn LAPACKE_zsytrs_aa_2stage_work;
    struct flexiblas_hook_fn LAPACKE_zsytrs_aa_work;
    struct flexiblas_hook_fn LAPACKE_zsytrs_rook;
    struct flexiblas_hook_fn LAPACKE_zsytrs_rook_work;
    struct flexiblas_hook_fn LAPACKE_zsytrs_work;
    struct flexiblas_hook_fn LAPACKE_ztbcon;
    struct flexiblas_hook_fn LAPACKE_ztbcon_work;
    struct flexiblas_hook_fn LAPACKE_ztbrfs;
    struct flexiblas_hook_fn LAPACKE_ztbrfs_work;
    struct flexiblas_hook_fn LAPACKE_ztbtrs;
    struct flexiblas_hook_fn LAPACKE_ztbtrs_work;
    struct flexiblas_hook_fn LAPACKE_ztfsm;
    struct flexiblas_hook_fn LAPACKE_ztfsm_work;
    struct flexiblas_hook_fn LAPACKE_ztftri;
    struct flexiblas_hook_fn LAPACKE_ztftri_work;
    struct flexiblas_hook_fn LAPACKE_ztfttp;
    struct flexiblas_hook_fn LAPACKE_ztfttp_work;
    struct flexiblas_hook_fn LAPACKE_ztfttr;
    struct flexiblas_hook_fn LAPACKE_ztfttr_work;
    struct flexiblas_hook_fn LAPACKE_ztgevc;
    struct flexiblas_hook_fn LAPACKE_ztgevc_work;
    struct flexiblas_hook_fn LAPACKE_ztgexc;
    struct flexiblas_hook_fn LAPACKE_ztgexc_work;
    struct flexiblas_hook_fn LAPACKE_ztgsen;
    struct flexiblas_hook_fn LAPACKE_ztgsen_work;
    struct flexiblas_hook_fn LAPACKE_ztgsja;
    struct flexiblas_hook_fn LAPACKE_ztgsja_work;
    struct flexiblas_hook_fn LAPACKE_ztgsna;
    struct flexiblas_hook_fn LAPACKE_ztgsna_work;
    struct flexiblas_hook_fn LAPACKE_ztgsyl;
    struct flexiblas_hook_fn LAPACKE_ztgsyl_work;
    struct flexiblas_hook_fn LAPACKE_ztpcon;
    struct flexiblas_hook_fn LAPACKE_ztpcon_work;
    struct flexiblas_hook_fn LAPACKE_ztpmqrt;
    struct flexiblas_hook_fn LAPACKE_ztpmqrt_work;
    struct flexiblas_hook_fn LAPACKE_ztpqrt;
    struct flexiblas_hook_fn LAPACKE_ztpqrt2;
    struct flexiblas_hook_fn LAPACKE_ztpqrt2_work;
    struct flexiblas_hook_fn LAPACKE_ztpqrt_work;
    struct flexiblas_hook_fn LAPACKE_ztprfb;
    struct flexiblas_hook_fn LAPACKE_ztprfb_work;
    struct flexiblas_hook_fn LAPACKE_ztprfs;
    struct flexiblas_hook_fn LAPACKE_ztprfs_work;
    struct flexiblas_hook_fn LAPACKE_ztptri;
    struct flexiblas_hook_fn LAPACKE_ztptri_work;
    struct flexiblas_hook_fn LAPACKE_ztptrs;
    struct flexiblas_hook_fn LAPACKE_ztptrs_work;
    struct flexiblas_hook_fn LAPACKE_ztpttf;
    struct flexiblas_hook_fn LAPACKE_ztpttf_work;
    struct flexiblas_hook_fn LAPACKE_ztpttr;
    struct flexiblas_hook_fn LAPACKE_ztpttr_work;
    struct flexiblas_hook_fn LAPACKE_ztrcon;
    struct flexiblas_hook_fn LAPACKE_ztrcon_work;
    struct flexiblas_hook_fn LAPACKE_ztrevc;
    struct flexiblas_hook_fn LAPACKE_ztrevc_work;
    struct flexiblas_hook_fn LAPACKE_ztrexc;
    struct flexiblas_hook_fn LAPACKE_ztrexc_work;
    struct flexiblas_hook_fn LAPACKE_ztrrfs;
    struct flexiblas_hook_fn LAPACKE_ztrrfs_work;
    struct flexiblas_hook_fn LAPACKE_ztrsen;
    struct flexiblas_hook_fn LAPACKE_ztrsen_work;
    struct flexiblas_hook_fn LAPACKE_ztrsna;
    struct flexiblas_hook_fn LAPACKE_ztrsna_work;
    struct flexiblas_hook_fn LAPACKE_ztrsyl;
    struct flexiblas_hook_fn LAPACKE_ztrsyl3;
    struct flexiblas_hook_fn LAPACKE_ztrsyl3_work;
    struct flexiblas_hook_fn LAPACKE_ztrsyl_work;
    struct flexiblas_hook_fn LAPACKE_ztrtri;
    struct flexiblas_hook_fn LAPACKE_ztrtri_work;
    struct flexiblas_hook_fn LAPACKE_ztrtrs;
    struct flexiblas_hook_fn LAPACKE_ztrtrs_work;
    struct flexiblas_hook_fn LAPACKE_ztrttf;
    struct flexiblas_hook_fn LAPACKE_ztrttf_work;
    struct flexiblas_hook_fn LAPACKE_ztrttp;
    struct flexiblas_hook_fn LAPACKE_ztrttp_work;
    struct flexiblas_hook_fn LAPACKE_ztzrzf;
    struct flexiblas_hook_fn LAPACKE_ztzrzf_work;
    struct flexiblas_hook_fn LAPACKE_zunbdb;
    struct flexiblas_hook_fn LAPACKE_zunbdb_work;
    struct flexiblas_hook_fn LAPACKE_zuncsd;
    struct flexiblas_hook_fn LAPACKE_zuncsd2by1;
    struct flexiblas_hook_fn LAPACKE_zuncsd2by1_work;
    struct flexiblas_hook_fn LAPACKE_zuncsd_work;
    struct flexiblas_hook_fn LAPACKE_zungbr;
    struct flexiblas_hook_fn LAPACKE_zungbr_work;
    struct flexiblas_hook_fn LAPACKE_zunghr;
    struct flexiblas_hook_fn LAPACKE_zunghr_work;
    struct flexiblas_hook_fn LAPACKE_zunglq;
    struct flexiblas_hook_fn LAPACKE_zunglq_work;
    struct flexiblas_hook_fn LAPACKE_zungql;
    struct flexiblas_hook_fn LAPACKE_zungql_work;
    struct flexiblas_hook_fn LAPACKE_zungqr;
    struct flexiblas_hook_fn LAPACKE_zungqr_work;
    struct flexiblas_hook_fn LAPACKE_zungrq;
    struct flexiblas_hook_fn LAPACKE_zungrq_work;
    struct flexiblas_hook_fn LAPACKE_zungtr;
    struct flexiblas_hook_fn LAPACKE_zungtr_work;
    struct flexiblas_hook_fn LAPACKE_zungtsqr_row;
    struct flexiblas_hook_fn LAPACKE_zungtsqr_row_work;
    struct flexiblas_hook_fn LAPACKE_zunhr_col;
    struct flexiblas_hook_fn LAPACKE_zunhr_col_work;
    struct flexiblas_hook_fn LAPACKE_zunmbr;
    struct flexiblas_hook_fn LAPACKE_zunmbr_work;
    struct flexiblas_hook_fn LAPACKE_zunmhr;
    struct flexiblas_hook_fn LAPACKE_zunmhr_work;
    struct flexiblas_hook_fn LAPACKE_zunmlq;
    struct flexiblas_hook_fn LAPACKE_zunmlq_work;
    struct flexiblas_hook_fn LAPACKE_zunmql;
    struct flexiblas_hook_fn LAPACKE_zunmql_work;
    struct flexiblas_hook_fn LAPACKE_zunmqr;
    struct flexiblas_hook_fn LAPACKE_zunmqr_work;
    struct flexiblas_hook_fn LAPACKE_zunmrq;
    struct flexiblas_hook_fn LAPACKE_zunmrq_work;
    struct flexiblas_hook_fn LAPACKE_zunmrz;
    struct flexiblas_hook_fn LAPACKE_zunmrz_work;
    struct flexiblas_hook_fn LAPACKE_zunmtr;
    struct flexiblas_hook_fn LAPACKE_zunmtr_work;
    struct flexiblas_hook_fn LAPACKE_zupgtr;
    struct flexiblas_hook_fn LAPACKE_zupgtr_work;
    struct flexiblas_hook_fn LAPACKE_zupmtr;
    struct flexiblas_hook_fn LAPACKE_zupmtr_work;
} flexiblas_hook_t;

#ifdef __cplusplus
}
#endif
#endif
