// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package kendraranking

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opCreateRescoreExecutionPlan = "CreateRescoreExecutionPlan"

// CreateRescoreExecutionPlanRequest generates a "aws/request.Request" representing the
// client's request for the CreateRescoreExecutionPlan operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateRescoreExecutionPlan for more information on using the CreateRescoreExecutionPlan
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateRescoreExecutionPlanRequest method.
//	req, resp := client.CreateRescoreExecutionPlanRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kendra-ranking-2022-10-19/CreateRescoreExecutionPlan
func (c *KendraRanking) CreateRescoreExecutionPlanRequest(input *CreateRescoreExecutionPlanInput) (req *request.Request, output *CreateRescoreExecutionPlanOutput) {
	op := &request.Operation{
		Name:       opCreateRescoreExecutionPlan,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateRescoreExecutionPlanInput{}
	}

	output = &CreateRescoreExecutionPlanOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateRescoreExecutionPlan API operation for Amazon Kendra Intelligent Ranking.
//
// Creates a rescore execution plan. A rescore execution plan is an Amazon Kendra
// Intelligent Ranking resource used for provisioning the Rescore API. You set
// the number of capacity units that you require for Amazon Kendra Intelligent
// Ranking to rescore or re-rank a search service's results.
//
// For an example of using the CreateRescoreExecutionPlan API, including using
// the Python and Java SDKs, see Semantically ranking a search service's results
// (https://docs.aws.amazon.com/kendra/latest/dg/search-service-rerank.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Kendra Intelligent Ranking's
// API operation CreateRescoreExecutionPlan for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don’t have sufficient access to perform this action. Please ensure
//     you have the required permission policies and user accounts and try again.
//
//   - ConflictException
//     A conflict occurred with the request. Please fix any inconsistencies with
//     your resources and try again.
//
//   - ServiceQuotaExceededException
//     You have exceeded the set limits for your Amazon Kendra Intelligent Ranking
//     service. Please see Quotas (https://docs.aws.amazon.com/kendra/latest/dg/quotas.html)
//     for more information, or contact Support (http://aws.amazon.com/contact-us/)
//     to inquire about an increase of limits.
//
//   - ThrottlingException
//     The request was denied due to request throttling. Please reduce the number
//     of requests and try again.
//
//   - ValidationException
//     The input fails to satisfy the constraints set by the Amazon Kendra Intelligent
//     Ranking service. Please provide the correct input and try again.
//
//   - InternalServerException
//     An issue occurred with the internal server used for your Amazon Kendra Intelligent
//     Ranking service. Please wait a few minutes and try again, or contact Support
//     (http://aws.amazon.com/contact-us/) for help.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kendra-ranking-2022-10-19/CreateRescoreExecutionPlan
func (c *KendraRanking) CreateRescoreExecutionPlan(input *CreateRescoreExecutionPlanInput) (*CreateRescoreExecutionPlanOutput, error) {
	req, out := c.CreateRescoreExecutionPlanRequest(input)
	return out, req.Send()
}

// CreateRescoreExecutionPlanWithContext is the same as CreateRescoreExecutionPlan with the addition of
// the ability to pass a context and additional request options.
//
// See CreateRescoreExecutionPlan for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KendraRanking) CreateRescoreExecutionPlanWithContext(ctx aws.Context, input *CreateRescoreExecutionPlanInput, opts ...request.Option) (*CreateRescoreExecutionPlanOutput, error) {
	req, out := c.CreateRescoreExecutionPlanRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteRescoreExecutionPlan = "DeleteRescoreExecutionPlan"

// DeleteRescoreExecutionPlanRequest generates a "aws/request.Request" representing the
// client's request for the DeleteRescoreExecutionPlan operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteRescoreExecutionPlan for more information on using the DeleteRescoreExecutionPlan
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteRescoreExecutionPlanRequest method.
//	req, resp := client.DeleteRescoreExecutionPlanRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kendra-ranking-2022-10-19/DeleteRescoreExecutionPlan
func (c *KendraRanking) DeleteRescoreExecutionPlanRequest(input *DeleteRescoreExecutionPlanInput) (req *request.Request, output *DeleteRescoreExecutionPlanOutput) {
	op := &request.Operation{
		Name:       opDeleteRescoreExecutionPlan,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteRescoreExecutionPlanInput{}
	}

	output = &DeleteRescoreExecutionPlanOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteRescoreExecutionPlan API operation for Amazon Kendra Intelligent Ranking.
//
// Deletes a rescore execution plan. A rescore execution plan is an Amazon Kendra
// Intelligent Ranking resource used for provisioning the Rescore API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Kendra Intelligent Ranking's
// API operation DeleteRescoreExecutionPlan for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You don’t have sufficient access to perform this action. Please ensure
//     you have the required permission policies and user accounts and try again.
//
//   - ValidationException
//     The input fails to satisfy the constraints set by the Amazon Kendra Intelligent
//     Ranking service. Please provide the correct input and try again.
//
//   - ConflictException
//     A conflict occurred with the request. Please fix any inconsistencies with
//     your resources and try again.
//
//   - ResourceNotFoundException
//     The resource you want to use doesn't exist. Please check you have provided
//     the correct resource and try again.
//
//   - ThrottlingException
//     The request was denied due to request throttling. Please reduce the number
//     of requests and try again.
//
//   - InternalServerException
//     An issue occurred with the internal server used for your Amazon Kendra Intelligent
//     Ranking service. Please wait a few minutes and try again, or contact Support
//     (http://aws.amazon.com/contact-us/) for help.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kendra-ranking-2022-10-19/DeleteRescoreExecutionPlan
func (c *KendraRanking) DeleteRescoreExecutionPlan(input *DeleteRescoreExecutionPlanInput) (*DeleteRescoreExecutionPlanOutput, error) {
	req, out := c.DeleteRescoreExecutionPlanRequest(input)
	return out, req.Send()
}

// DeleteRescoreExecutionPlanWithContext is the same as DeleteRescoreExecutionPlan with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteRescoreExecutionPlan for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KendraRanking) DeleteRescoreExecutionPlanWithContext(ctx aws.Context, input *DeleteRescoreExecutionPlanInput, opts ...request.Option) (*DeleteRescoreExecutionPlanOutput, error) {
	req, out := c.DeleteRescoreExecutionPlanRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeRescoreExecutionPlan = "DescribeRescoreExecutionPlan"

// DescribeRescoreExecutionPlanRequest generates a "aws/request.Request" representing the
// client's request for the DescribeRescoreExecutionPlan operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeRescoreExecutionPlan for more information on using the DescribeRescoreExecutionPlan
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeRescoreExecutionPlanRequest method.
//	req, resp := client.DescribeRescoreExecutionPlanRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kendra-ranking-2022-10-19/DescribeRescoreExecutionPlan
func (c *KendraRanking) DescribeRescoreExecutionPlanRequest(input *DescribeRescoreExecutionPlanInput) (req *request.Request, output *DescribeRescoreExecutionPlanOutput) {
	op := &request.Operation{
		Name:       opDescribeRescoreExecutionPlan,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeRescoreExecutionPlanInput{}
	}

	output = &DescribeRescoreExecutionPlanOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeRescoreExecutionPlan API operation for Amazon Kendra Intelligent Ranking.
//
// Gets information about a rescore execution plan. A rescore execution plan
// is an Amazon Kendra Intelligent Ranking resource used for provisioning the
// Rescore API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Kendra Intelligent Ranking's
// API operation DescribeRescoreExecutionPlan for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input fails to satisfy the constraints set by the Amazon Kendra Intelligent
//     Ranking service. Please provide the correct input and try again.
//
//   - ResourceNotFoundException
//     The resource you want to use doesn't exist. Please check you have provided
//     the correct resource and try again.
//
//   - ThrottlingException
//     The request was denied due to request throttling. Please reduce the number
//     of requests and try again.
//
//   - AccessDeniedException
//     You don’t have sufficient access to perform this action. Please ensure
//     you have the required permission policies and user accounts and try again.
//
//   - InternalServerException
//     An issue occurred with the internal server used for your Amazon Kendra Intelligent
//     Ranking service. Please wait a few minutes and try again, or contact Support
//     (http://aws.amazon.com/contact-us/) for help.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kendra-ranking-2022-10-19/DescribeRescoreExecutionPlan
func (c *KendraRanking) DescribeRescoreExecutionPlan(input *DescribeRescoreExecutionPlanInput) (*DescribeRescoreExecutionPlanOutput, error) {
	req, out := c.DescribeRescoreExecutionPlanRequest(input)
	return out, req.Send()
}

// DescribeRescoreExecutionPlanWithContext is the same as DescribeRescoreExecutionPlan with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeRescoreExecutionPlan for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KendraRanking) DescribeRescoreExecutionPlanWithContext(ctx aws.Context, input *DescribeRescoreExecutionPlanInput, opts ...request.Option) (*DescribeRescoreExecutionPlanOutput, error) {
	req, out := c.DescribeRescoreExecutionPlanRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListRescoreExecutionPlans = "ListRescoreExecutionPlans"

// ListRescoreExecutionPlansRequest generates a "aws/request.Request" representing the
// client's request for the ListRescoreExecutionPlans operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListRescoreExecutionPlans for more information on using the ListRescoreExecutionPlans
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListRescoreExecutionPlansRequest method.
//	req, resp := client.ListRescoreExecutionPlansRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kendra-ranking-2022-10-19/ListRescoreExecutionPlans
func (c *KendraRanking) ListRescoreExecutionPlansRequest(input *ListRescoreExecutionPlansInput) (req *request.Request, output *ListRescoreExecutionPlansOutput) {
	op := &request.Operation{
		Name:       opListRescoreExecutionPlans,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListRescoreExecutionPlansInput{}
	}

	output = &ListRescoreExecutionPlansOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListRescoreExecutionPlans API operation for Amazon Kendra Intelligent Ranking.
//
// Lists your rescore execution plans. A rescore execution plan is an Amazon
// Kendra Intelligent Ranking resource used for provisioning the Rescore API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Kendra Intelligent Ranking's
// API operation ListRescoreExecutionPlans for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input fails to satisfy the constraints set by the Amazon Kendra Intelligent
//     Ranking service. Please provide the correct input and try again.
//
//   - AccessDeniedException
//     You don’t have sufficient access to perform this action. Please ensure
//     you have the required permission policies and user accounts and try again.
//
//   - ThrottlingException
//     The request was denied due to request throttling. Please reduce the number
//     of requests and try again.
//
//   - InternalServerException
//     An issue occurred with the internal server used for your Amazon Kendra Intelligent
//     Ranking service. Please wait a few minutes and try again, or contact Support
//     (http://aws.amazon.com/contact-us/) for help.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kendra-ranking-2022-10-19/ListRescoreExecutionPlans
func (c *KendraRanking) ListRescoreExecutionPlans(input *ListRescoreExecutionPlansInput) (*ListRescoreExecutionPlansOutput, error) {
	req, out := c.ListRescoreExecutionPlansRequest(input)
	return out, req.Send()
}

// ListRescoreExecutionPlansWithContext is the same as ListRescoreExecutionPlans with the addition of
// the ability to pass a context and additional request options.
//
// See ListRescoreExecutionPlans for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KendraRanking) ListRescoreExecutionPlansWithContext(ctx aws.Context, input *ListRescoreExecutionPlansInput, opts ...request.Option) (*ListRescoreExecutionPlansOutput, error) {
	req, out := c.ListRescoreExecutionPlansRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListRescoreExecutionPlansPages iterates over the pages of a ListRescoreExecutionPlans operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListRescoreExecutionPlans method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListRescoreExecutionPlans operation.
//	pageNum := 0
//	err := client.ListRescoreExecutionPlansPages(params,
//	    func(page *kendraranking.ListRescoreExecutionPlansOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *KendraRanking) ListRescoreExecutionPlansPages(input *ListRescoreExecutionPlansInput, fn func(*ListRescoreExecutionPlansOutput, bool) bool) error {
	return c.ListRescoreExecutionPlansPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListRescoreExecutionPlansPagesWithContext same as ListRescoreExecutionPlansPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KendraRanking) ListRescoreExecutionPlansPagesWithContext(ctx aws.Context, input *ListRescoreExecutionPlansInput, fn func(*ListRescoreExecutionPlansOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListRescoreExecutionPlansInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListRescoreExecutionPlansRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListRescoreExecutionPlansOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTagsForResourceRequest method.
//	req, resp := client.ListTagsForResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kendra-ranking-2022-10-19/ListTagsForResource
func (c *KendraRanking) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for Amazon Kendra Intelligent Ranking.
//
// Gets a list of tags associated with a specified resource. A rescore execution
// plan is an example of a resource that can have tags associated with it.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Kendra Intelligent Ranking's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input fails to satisfy the constraints set by the Amazon Kendra Intelligent
//     Ranking service. Please provide the correct input and try again.
//
//   - ResourceUnavailableException
//     The resource you want to use is unavailable. Please check you have provided
//     the correct resource information and try again.
//
//   - ThrottlingException
//     The request was denied due to request throttling. Please reduce the number
//     of requests and try again.
//
//   - AccessDeniedException
//     You don’t have sufficient access to perform this action. Please ensure
//     you have the required permission policies and user accounts and try again.
//
//   - InternalServerException
//     An issue occurred with the internal server used for your Amazon Kendra Intelligent
//     Ranking service. Please wait a few minutes and try again, or contact Support
//     (http://aws.amazon.com/contact-us/) for help.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kendra-ranking-2022-10-19/ListTagsForResource
func (c *KendraRanking) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KendraRanking) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRescore = "Rescore"

// RescoreRequest generates a "aws/request.Request" representing the
// client's request for the Rescore operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See Rescore for more information on using the Rescore
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the RescoreRequest method.
//	req, resp := client.RescoreRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kendra-ranking-2022-10-19/Rescore
func (c *KendraRanking) RescoreRequest(input *RescoreInput) (req *request.Request, output *RescoreOutput) {
	op := &request.Operation{
		Name:       opRescore,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RescoreInput{}
	}

	output = &RescoreOutput{}
	req = c.newRequest(op, input, output)
	return
}

// Rescore API operation for Amazon Kendra Intelligent Ranking.
//
// Rescores or re-ranks search results from a search service such as OpenSearch
// (self managed). You use the semantic search capabilities of Amazon Kendra
// Intelligent Ranking to improve the search service's results.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Kendra Intelligent Ranking's
// API operation Rescore for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input fails to satisfy the constraints set by the Amazon Kendra Intelligent
//     Ranking service. Please provide the correct input and try again.
//
//   - ConflictException
//     A conflict occurred with the request. Please fix any inconsistencies with
//     your resources and try again.
//
//   - AccessDeniedException
//     You don’t have sufficient access to perform this action. Please ensure
//     you have the required permission policies and user accounts and try again.
//
//   - ResourceNotFoundException
//     The resource you want to use doesn't exist. Please check you have provided
//     the correct resource and try again.
//
//   - ThrottlingException
//     The request was denied due to request throttling. Please reduce the number
//     of requests and try again.
//
//   - InternalServerException
//     An issue occurred with the internal server used for your Amazon Kendra Intelligent
//     Ranking service. Please wait a few minutes and try again, or contact Support
//     (http://aws.amazon.com/contact-us/) for help.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kendra-ranking-2022-10-19/Rescore
func (c *KendraRanking) Rescore(input *RescoreInput) (*RescoreOutput, error) {
	req, out := c.RescoreRequest(input)
	return out, req.Send()
}

// RescoreWithContext is the same as Rescore with the addition of
// the ability to pass a context and additional request options.
//
// See Rescore for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KendraRanking) RescoreWithContext(ctx aws.Context, input *RescoreInput, opts ...request.Option) (*RescoreOutput, error) {
	req, out := c.RescoreRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TagResourceRequest method.
//	req, resp := client.TagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kendra-ranking-2022-10-19/TagResource
func (c *KendraRanking) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for Amazon Kendra Intelligent Ranking.
//
// Adds a specified tag to a specified rescore execution plan. A rescore execution
// plan is an Amazon Kendra Intelligent Ranking resource used for provisioning
// the Rescore API. If the tag already exists, the existing value is replaced
// with the new value.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Kendra Intelligent Ranking's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input fails to satisfy the constraints set by the Amazon Kendra Intelligent
//     Ranking service. Please provide the correct input and try again.
//
//   - ResourceUnavailableException
//     The resource you want to use is unavailable. Please check you have provided
//     the correct resource information and try again.
//
//   - ThrottlingException
//     The request was denied due to request throttling. Please reduce the number
//     of requests and try again.
//
//   - AccessDeniedException
//     You don’t have sufficient access to perform this action. Please ensure
//     you have the required permission policies and user accounts and try again.
//
//   - InternalServerException
//     An issue occurred with the internal server used for your Amazon Kendra Intelligent
//     Ranking service. Please wait a few minutes and try again, or contact Support
//     (http://aws.amazon.com/contact-us/) for help.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kendra-ranking-2022-10-19/TagResource
func (c *KendraRanking) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KendraRanking) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UntagResourceRequest method.
//	req, resp := client.UntagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kendra-ranking-2022-10-19/UntagResource
func (c *KendraRanking) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for Amazon Kendra Intelligent Ranking.
//
// Removes a tag from a rescore execution plan. A rescore execution plan is
// an Amazon Kendra Intelligent Ranking resource used for provisioning the Rescore
// operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Kendra Intelligent Ranking's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input fails to satisfy the constraints set by the Amazon Kendra Intelligent
//     Ranking service. Please provide the correct input and try again.
//
//   - ResourceUnavailableException
//     The resource you want to use is unavailable. Please check you have provided
//     the correct resource information and try again.
//
//   - ThrottlingException
//     The request was denied due to request throttling. Please reduce the number
//     of requests and try again.
//
//   - AccessDeniedException
//     You don’t have sufficient access to perform this action. Please ensure
//     you have the required permission policies and user accounts and try again.
//
//   - InternalServerException
//     An issue occurred with the internal server used for your Amazon Kendra Intelligent
//     Ranking service. Please wait a few minutes and try again, or contact Support
//     (http://aws.amazon.com/contact-us/) for help.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kendra-ranking-2022-10-19/UntagResource
func (c *KendraRanking) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KendraRanking) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateRescoreExecutionPlan = "UpdateRescoreExecutionPlan"

// UpdateRescoreExecutionPlanRequest generates a "aws/request.Request" representing the
// client's request for the UpdateRescoreExecutionPlan operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateRescoreExecutionPlan for more information on using the UpdateRescoreExecutionPlan
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateRescoreExecutionPlanRequest method.
//	req, resp := client.UpdateRescoreExecutionPlanRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kendra-ranking-2022-10-19/UpdateRescoreExecutionPlan
func (c *KendraRanking) UpdateRescoreExecutionPlanRequest(input *UpdateRescoreExecutionPlanInput) (req *request.Request, output *UpdateRescoreExecutionPlanOutput) {
	op := &request.Operation{
		Name:       opUpdateRescoreExecutionPlan,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateRescoreExecutionPlanInput{}
	}

	output = &UpdateRescoreExecutionPlanOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateRescoreExecutionPlan API operation for Amazon Kendra Intelligent Ranking.
//
// Updates a rescore execution plan. A rescore execution plan is an Amazon Kendra
// Intelligent Ranking resource used for provisioning the Rescore API. You can
// update the number of capacity units you require for Amazon Kendra Intelligent
// Ranking to rescore or re-rank a search service's results.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Kendra Intelligent Ranking's
// API operation UpdateRescoreExecutionPlan for usage and error information.
//
// Returned Error Types:
//
//   - ValidationException
//     The input fails to satisfy the constraints set by the Amazon Kendra Intelligent
//     Ranking service. Please provide the correct input and try again.
//
//   - ResourceNotFoundException
//     The resource you want to use doesn't exist. Please check you have provided
//     the correct resource and try again.
//
//   - ThrottlingException
//     The request was denied due to request throttling. Please reduce the number
//     of requests and try again.
//
//   - AccessDeniedException
//     You don’t have sufficient access to perform this action. Please ensure
//     you have the required permission policies and user accounts and try again.
//
//   - ServiceQuotaExceededException
//     You have exceeded the set limits for your Amazon Kendra Intelligent Ranking
//     service. Please see Quotas (https://docs.aws.amazon.com/kendra/latest/dg/quotas.html)
//     for more information, or contact Support (http://aws.amazon.com/contact-us/)
//     to inquire about an increase of limits.
//
//   - ConflictException
//     A conflict occurred with the request. Please fix any inconsistencies with
//     your resources and try again.
//
//   - InternalServerException
//     An issue occurred with the internal server used for your Amazon Kendra Intelligent
//     Ranking service. Please wait a few minutes and try again, or contact Support
//     (http://aws.amazon.com/contact-us/) for help.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/kendra-ranking-2022-10-19/UpdateRescoreExecutionPlan
func (c *KendraRanking) UpdateRescoreExecutionPlan(input *UpdateRescoreExecutionPlanInput) (*UpdateRescoreExecutionPlanOutput, error) {
	req, out := c.UpdateRescoreExecutionPlanRequest(input)
	return out, req.Send()
}

// UpdateRescoreExecutionPlanWithContext is the same as UpdateRescoreExecutionPlan with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateRescoreExecutionPlan for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KendraRanking) UpdateRescoreExecutionPlanWithContext(ctx aws.Context, input *UpdateRescoreExecutionPlanInput, opts ...request.Option) (*UpdateRescoreExecutionPlanOutput, error) {
	req, out := c.UpdateRescoreExecutionPlanRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// You don’t have sufficient access to perform this action. Please ensure
// you have the required permission policies and user accounts and try again.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Sets additional capacity units configured for your rescore execution plan.
// A rescore execution plan is an Amazon Kendra Intelligent Ranking resource
// used for provisioning the Rescore API. You can add and remove capacity units
// to fit your usage requirements.
type CapacityUnitsConfiguration struct {
	_ struct{} `type:"structure"`

	// The amount of extra capacity for your rescore execution plan.
	//
	// A single extra capacity unit for a rescore execution plan provides 0.01 rescore
	// requests per second. You can add up to 1000 extra capacity units.
	//
	// RescoreCapacityUnits is a required field
	RescoreCapacityUnits *int64 `type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CapacityUnitsConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CapacityUnitsConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CapacityUnitsConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CapacityUnitsConfiguration"}
	if s.RescoreCapacityUnits == nil {
		invalidParams.Add(request.NewErrParamRequired("RescoreCapacityUnits"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRescoreCapacityUnits sets the RescoreCapacityUnits field's value.
func (s *CapacityUnitsConfiguration) SetRescoreCapacityUnits(v int64) *CapacityUnitsConfiguration {
	s.RescoreCapacityUnits = &v
	return s
}

// A conflict occurred with the request. Please fix any inconsistencies with
// your resources and try again.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

type CreateRescoreExecutionPlanInput struct {
	_ struct{} `type:"structure"`

	// You can set additional capacity units to meet the needs of your rescore execution
	// plan. You are given a single capacity unit by default. If you want to use
	// the default capacity, you don't set additional capacity units. For more information
	// on the default capacity and additional capacity units, see Adjusting capacity
	// (https://docs.aws.amazon.com/kendra/latest/dg/adjusting-capacity.html).
	CapacityUnits *CapacityUnitsConfiguration `type:"structure"`

	// A token that you provide to identify the request to create a rescore execution
	// plan. Multiple calls to the CreateRescoreExecutionPlanRequest API with the
	// same client token will create only one rescore execution plan.
	ClientToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// A description for the rescore execution plan.
	Description *string `type:"string"`

	// A name for the rescore execution plan.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// A list of key-value pairs that identify or categorize your rescore execution
	// plan. You can also use tags to help control access to the rescore execution
	// plan. Tag keys and values can consist of Unicode letters, digits, white space,
	// and any of the following symbols: _ . : / = + - @.
	Tags []*Tag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRescoreExecutionPlanInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRescoreExecutionPlanInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateRescoreExecutionPlanInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateRescoreExecutionPlanInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.CapacityUnits != nil {
		if err := s.CapacityUnits.Validate(); err != nil {
			invalidParams.AddNested("CapacityUnits", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCapacityUnits sets the CapacityUnits field's value.
func (s *CreateRescoreExecutionPlanInput) SetCapacityUnits(v *CapacityUnitsConfiguration) *CreateRescoreExecutionPlanInput {
	s.CapacityUnits = v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateRescoreExecutionPlanInput) SetClientToken(v string) *CreateRescoreExecutionPlanInput {
	s.ClientToken = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateRescoreExecutionPlanInput) SetDescription(v string) *CreateRescoreExecutionPlanInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateRescoreExecutionPlanInput) SetName(v string) *CreateRescoreExecutionPlanInput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateRescoreExecutionPlanInput) SetTags(v []*Tag) *CreateRescoreExecutionPlanInput {
	s.Tags = v
	return s
}

type CreateRescoreExecutionPlanOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the rescore execution plan.
	//
	// Arn is a required field
	Arn *string `type:"string" required:"true"`

	// The identifier of the rescore execution plan.
	//
	// Id is a required field
	Id *string `min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRescoreExecutionPlanOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRescoreExecutionPlanOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateRescoreExecutionPlanOutput) SetArn(v string) *CreateRescoreExecutionPlanOutput {
	s.Arn = &v
	return s
}

// SetId sets the Id field's value.
func (s *CreateRescoreExecutionPlanOutput) SetId(v string) *CreateRescoreExecutionPlanOutput {
	s.Id = &v
	return s
}

type DeleteRescoreExecutionPlanInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the rescore execution plan that you want to delete.
	//
	// Id is a required field
	Id *string `min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRescoreExecutionPlanInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRescoreExecutionPlanInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteRescoreExecutionPlanInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteRescoreExecutionPlanInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *DeleteRescoreExecutionPlanInput) SetId(v string) *DeleteRescoreExecutionPlanInput {
	s.Id = &v
	return s
}

type DeleteRescoreExecutionPlanOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRescoreExecutionPlanOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRescoreExecutionPlanOutput) GoString() string {
	return s.String()
}

type DescribeRescoreExecutionPlanInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the rescore execution plan that you want to get information
	// on.
	//
	// Id is a required field
	Id *string `min:"36" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeRescoreExecutionPlanInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeRescoreExecutionPlanInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeRescoreExecutionPlanInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeRescoreExecutionPlanInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 36))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *DescribeRescoreExecutionPlanInput) SetId(v string) *DescribeRescoreExecutionPlanInput {
	s.Id = &v
	return s
}

type DescribeRescoreExecutionPlanOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the rescore execution plan.
	Arn *string `type:"string"`

	// The capacity units set for the rescore execution plan. A capacity of zero
	// indicates that the rescore execution plan is using the default capacity.
	// For more information on the default capacity and additional capacity units,
	// see Adjusting capacity (https://docs.aws.amazon.com/kendra/latest/dg/adjusting-capacity.html).
	CapacityUnits *CapacityUnitsConfiguration `type:"structure"`

	// The Unix timestamp of when the rescore execution plan was created.
	CreatedAt *time.Time `type:"timestamp"`

	// The description for the rescore execution plan.
	Description *string `type:"string"`

	// When the Status field value is FAILED, the ErrorMessage field contains a
	// message that explains why.
	ErrorMessage *string `min:"1" type:"string"`

	// The identifier of the rescore execution plan.
	Id *string `min:"36" type:"string"`

	// The name for the rescore execution plan.
	Name *string `min:"1" type:"string"`

	// The current status of the rescore execution plan. When the value is ACTIVE,
	// the rescore execution plan is ready for use. If the Status field value is
	// FAILED, the ErrorMessage field contains a message that explains why.
	Status *string `type:"string" enum:"RescoreExecutionPlanStatus"`

	// The Unix timestamp of when the rescore execution plan was last updated.
	UpdatedAt *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeRescoreExecutionPlanOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeRescoreExecutionPlanOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *DescribeRescoreExecutionPlanOutput) SetArn(v string) *DescribeRescoreExecutionPlanOutput {
	s.Arn = &v
	return s
}

// SetCapacityUnits sets the CapacityUnits field's value.
func (s *DescribeRescoreExecutionPlanOutput) SetCapacityUnits(v *CapacityUnitsConfiguration) *DescribeRescoreExecutionPlanOutput {
	s.CapacityUnits = v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *DescribeRescoreExecutionPlanOutput) SetCreatedAt(v time.Time) *DescribeRescoreExecutionPlanOutput {
	s.CreatedAt = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *DescribeRescoreExecutionPlanOutput) SetDescription(v string) *DescribeRescoreExecutionPlanOutput {
	s.Description = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *DescribeRescoreExecutionPlanOutput) SetErrorMessage(v string) *DescribeRescoreExecutionPlanOutput {
	s.ErrorMessage = &v
	return s
}

// SetId sets the Id field's value.
func (s *DescribeRescoreExecutionPlanOutput) SetId(v string) *DescribeRescoreExecutionPlanOutput {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *DescribeRescoreExecutionPlanOutput) SetName(v string) *DescribeRescoreExecutionPlanOutput {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DescribeRescoreExecutionPlanOutput) SetStatus(v string) *DescribeRescoreExecutionPlanOutput {
	s.Status = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *DescribeRescoreExecutionPlanOutput) SetUpdatedAt(v time.Time) *DescribeRescoreExecutionPlanOutput {
	s.UpdatedAt = &v
	return s
}

// Information about a document from a search service such as OpenSearch (self
// managed). Amazon Kendra Intelligent Ranking uses this information to rank
// and score on.
type Document struct {
	_ struct{} `type:"structure"`

	// The body text of the search service's document.
	Body *string `min:"1" type:"string"`

	// The optional group identifier of the document from the search service. Documents
	// with the same group identifier are grouped together and processed as one
	// document within the service.
	GroupId *string `min:"1" type:"string"`

	// The identifier of the document from the search service.
	//
	// Id is a required field
	Id *string `min:"1" type:"string" required:"true"`

	// The original document score or rank from the search service. Amazon Kendra
	// Intelligent Ranking gives the document a new score or rank based on its intelligent
	// search algorithms.
	//
	// OriginalScore is a required field
	OriginalScore *float64 `type:"float" required:"true"`

	// The title of the search service's document.
	Title *string `min:"1" type:"string"`

	// The body text of the search service's document represented as a list of tokens
	// or words. You must choose to provide Body or TokenizedBody. You cannot provide
	// both.
	TokenizedBody []*string `min:"1" type:"list"`

	// The title of the search service's document represented as a list of tokens
	// or words. You must choose to provide Title or TokenizedTitle. You cannot
	// provide both.
	TokenizedTitle []*string `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Document) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Document) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Document) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Document"}
	if s.Body != nil && len(*s.Body) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Body", 1))
	}
	if s.GroupId != nil && len(*s.GroupId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GroupId", 1))
	}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}
	if s.OriginalScore == nil {
		invalidParams.Add(request.NewErrParamRequired("OriginalScore"))
	}
	if s.OriginalScore != nil && *s.OriginalScore < -100000 {
		invalidParams.Add(request.NewErrParamMinValue("OriginalScore", -100000))
	}
	if s.Title != nil && len(*s.Title) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Title", 1))
	}
	if s.TokenizedBody != nil && len(s.TokenizedBody) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TokenizedBody", 1))
	}
	if s.TokenizedTitle != nil && len(s.TokenizedTitle) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TokenizedTitle", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBody sets the Body field's value.
func (s *Document) SetBody(v string) *Document {
	s.Body = &v
	return s
}

// SetGroupId sets the GroupId field's value.
func (s *Document) SetGroupId(v string) *Document {
	s.GroupId = &v
	return s
}

// SetId sets the Id field's value.
func (s *Document) SetId(v string) *Document {
	s.Id = &v
	return s
}

// SetOriginalScore sets the OriginalScore field's value.
func (s *Document) SetOriginalScore(v float64) *Document {
	s.OriginalScore = &v
	return s
}

// SetTitle sets the Title field's value.
func (s *Document) SetTitle(v string) *Document {
	s.Title = &v
	return s
}

// SetTokenizedBody sets the TokenizedBody field's value.
func (s *Document) SetTokenizedBody(v []*string) *Document {
	s.TokenizedBody = v
	return s
}

// SetTokenizedTitle sets the TokenizedTitle field's value.
func (s *Document) SetTokenizedTitle(v []*string) *Document {
	s.TokenizedTitle = v
	return s
}

// An issue occurred with the internal server used for your Amazon Kendra Intelligent
// Ranking service. Please wait a few minutes and try again, or contact Support
// (http://aws.amazon.com/contact-us/) for help.
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListRescoreExecutionPlansInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of rescore execution plans to return.
	MaxResults *int64 `min:"1" type:"integer"`

	// If the response is truncated, Amazon Kendra Intelligent Ranking returns a
	// pagination token in the response. You can use this pagination token to retrieve
	// the next set of rescore execution plans.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRescoreExecutionPlansInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRescoreExecutionPlansInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListRescoreExecutionPlansInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListRescoreExecutionPlansInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListRescoreExecutionPlansInput) SetMaxResults(v int64) *ListRescoreExecutionPlansInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListRescoreExecutionPlansInput) SetNextToken(v string) *ListRescoreExecutionPlansInput {
	s.NextToken = &v
	return s
}

type ListRescoreExecutionPlansOutput struct {
	_ struct{} `type:"structure"`

	// If the response is truncated, Amazon Kendra Intelligent Ranking returns a
	// pagination token in the response.
	NextToken *string `min:"1" type:"string"`

	// An array of summary information for one or more rescore execution plans.
	SummaryItems []*RescoreExecutionPlanSummary `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRescoreExecutionPlansOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRescoreExecutionPlansOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListRescoreExecutionPlansOutput) SetNextToken(v string) *ListRescoreExecutionPlansOutput {
	s.NextToken = &v
	return s
}

// SetSummaryItems sets the SummaryItems field's value.
func (s *ListRescoreExecutionPlansOutput) SetSummaryItems(v []*RescoreExecutionPlanSummary) *ListRescoreExecutionPlansOutput {
	s.SummaryItems = v
	return s
}

// The request information for listing tags associated with a rescore execution
// plan. A rescore execution plan is an Amazon Kendra Intelligent Ranking resource
// used for provisioning the Rescore API.
type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the rescore execution plan to get a list
	// of tags for.
	//
	// ResourceARN is a required field
	ResourceARN *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARN", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceARN sets the ResourceARN field's value.
func (s *ListTagsForResourceInput) SetResourceARN(v string) *ListTagsForResourceInput {
	s.ResourceARN = &v
	return s
}

// If the action is successful, the service sends back an HTTP 200 response.
type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// A list of tags associated with the rescore execution plan.
	Tags []*Tag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v []*Tag) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

// Summary information for a rescore execution plan. A rescore execution plan
// is an Amazon Kendra Intelligent Ranking resource used for provisioning the
// Rescore API.
type RescoreExecutionPlanSummary struct {
	_ struct{} `type:"structure"`

	// The Unix timestamp when the rescore execution plan was created.
	CreatedAt *time.Time `type:"timestamp"`

	// The identifier of the rescore execution plan.
	Id *string `min:"36" type:"string"`

	// The name of the rescore execution plan.
	Name *string `min:"1" type:"string"`

	// The current status of the rescore execution plan. When the value is ACTIVE,
	// the rescore execution plan is ready for use.
	Status *string `type:"string" enum:"RescoreExecutionPlanStatus"`

	// The Unix timestamp when the rescore execution plan was last updated.
	UpdatedAt *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RescoreExecutionPlanSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RescoreExecutionPlanSummary) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *RescoreExecutionPlanSummary) SetCreatedAt(v time.Time) *RescoreExecutionPlanSummary {
	s.CreatedAt = &v
	return s
}

// SetId sets the Id field's value.
func (s *RescoreExecutionPlanSummary) SetId(v string) *RescoreExecutionPlanSummary {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *RescoreExecutionPlanSummary) SetName(v string) *RescoreExecutionPlanSummary {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *RescoreExecutionPlanSummary) SetStatus(v string) *RescoreExecutionPlanSummary {
	s.Status = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *RescoreExecutionPlanSummary) SetUpdatedAt(v time.Time) *RescoreExecutionPlanSummary {
	s.UpdatedAt = &v
	return s
}

type RescoreInput struct {
	_ struct{} `type:"structure"`

	// The list of documents for Amazon Kendra Intelligent Ranking to rescore or
	// rank on.
	//
	// Documents is a required field
	Documents []*Document `min:"1" type:"list" required:"true"`

	// The identifier of the rescore execution plan. A rescore execution plan is
	// an Amazon Kendra Intelligent Ranking resource used for provisioning the Rescore
	// API.
	//
	// RescoreExecutionPlanId is a required field
	RescoreExecutionPlanId *string `min:"36" type:"string" required:"true"`

	// The input query from the search service.
	//
	// SearchQuery is a required field
	SearchQuery *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RescoreInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RescoreInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RescoreInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RescoreInput"}
	if s.Documents == nil {
		invalidParams.Add(request.NewErrParamRequired("Documents"))
	}
	if s.Documents != nil && len(s.Documents) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Documents", 1))
	}
	if s.RescoreExecutionPlanId == nil {
		invalidParams.Add(request.NewErrParamRequired("RescoreExecutionPlanId"))
	}
	if s.RescoreExecutionPlanId != nil && len(*s.RescoreExecutionPlanId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("RescoreExecutionPlanId", 36))
	}
	if s.SearchQuery == nil {
		invalidParams.Add(request.NewErrParamRequired("SearchQuery"))
	}
	if s.SearchQuery != nil && len(*s.SearchQuery) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SearchQuery", 1))
	}
	if s.Documents != nil {
		for i, v := range s.Documents {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Documents", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDocuments sets the Documents field's value.
func (s *RescoreInput) SetDocuments(v []*Document) *RescoreInput {
	s.Documents = v
	return s
}

// SetRescoreExecutionPlanId sets the RescoreExecutionPlanId field's value.
func (s *RescoreInput) SetRescoreExecutionPlanId(v string) *RescoreInput {
	s.RescoreExecutionPlanId = &v
	return s
}

// SetSearchQuery sets the SearchQuery field's value.
func (s *RescoreInput) SetSearchQuery(v string) *RescoreInput {
	s.SearchQuery = &v
	return s
}

type RescoreOutput struct {
	_ struct{} `type:"structure"`

	// The identifier associated with the scores that Amazon Kendra Intelligent
	// Ranking gives to the results. Amazon Kendra Intelligent Ranking rescores
	// or re-ranks the results for the search service.
	RescoreId *string `min:"1" type:"string"`

	// A list of result items for documents with new relevancy scores. The results
	// are in descending order.
	ResultItems []*RescoreResultItem `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RescoreOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RescoreOutput) GoString() string {
	return s.String()
}

// SetRescoreId sets the RescoreId field's value.
func (s *RescoreOutput) SetRescoreId(v string) *RescoreOutput {
	s.RescoreId = &v
	return s
}

// SetResultItems sets the ResultItems field's value.
func (s *RescoreOutput) SetResultItems(v []*RescoreResultItem) *RescoreOutput {
	s.ResultItems = v
	return s
}

// A result item for a document with a new relevancy score.
type RescoreResultItem struct {
	_ struct{} `type:"structure"`

	// The identifier of the document from the search service.
	DocumentId *string `min:"1" type:"string"`

	// The relevancy score or rank that Amazon Kendra Intelligent Ranking gives
	// to the result.
	Score *float64 `type:"float"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RescoreResultItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RescoreResultItem) GoString() string {
	return s.String()
}

// SetDocumentId sets the DocumentId field's value.
func (s *RescoreResultItem) SetDocumentId(v string) *RescoreResultItem {
	s.DocumentId = &v
	return s
}

// SetScore sets the Score field's value.
func (s *RescoreResultItem) SetScore(v float64) *RescoreResultItem {
	s.Score = &v
	return s
}

// The resource you want to use doesn't exist. Please check you have provided
// the correct resource and try again.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The resource you want to use is unavailable. Please check you have provided
// the correct resource information and try again.
type ResourceUnavailableException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceUnavailableException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceUnavailableException) GoString() string {
	return s.String()
}

func newErrorResourceUnavailableException(v protocol.ResponseMetadata) error {
	return &ResourceUnavailableException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceUnavailableException) Code() string {
	return "ResourceUnavailableException"
}

// Message returns the exception's message.
func (s *ResourceUnavailableException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceUnavailableException) OrigErr() error {
	return nil
}

func (s *ResourceUnavailableException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceUnavailableException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceUnavailableException) RequestID() string {
	return s.RespMetadata.RequestID
}

// You have exceeded the set limits for your Amazon Kendra Intelligent Ranking
// service. Please see Quotas (https://docs.aws.amazon.com/kendra/latest/dg/quotas.html)
// for more information, or contact Support (http://aws.amazon.com/contact-us/)
// to inquire about an increase of limits.
type ServiceQuotaExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) GoString() string {
	return s.String()
}

func newErrorServiceQuotaExceededException(v protocol.ResponseMetadata) error {
	return &ServiceQuotaExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceQuotaExceededException) Code() string {
	return "ServiceQuotaExceededException"
}

// Message returns the exception's message.
func (s *ServiceQuotaExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceQuotaExceededException) OrigErr() error {
	return nil
}

func (s *ServiceQuotaExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceQuotaExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceQuotaExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A key-value pair that identifies or categorizes a rescore execution plan.
// A rescore execution plan is an Amazon Kendra Intelligent Ranking resource
// used for provisioning the Rescore API. You can also use a tag to help control
// access to a rescore execution plan. A tag key and value can consist of Unicode
// letters, digits, white space, and any of the following symbols: _ . : / =
// + - @.
type Tag struct {
	_ struct{} `type:"structure"`

	// The key for the tag. Keys are not case sensitive and must be unique.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// The value associated with the tag. The value can be an empty string but it
	// can't be null.
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

// The request information for tagging a rescore execution plan. A rescore execution
// plan is an Amazon Kendra Intelligent Ranking resource used for provisioning
// the Rescore API.
type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the rescore execution plan to tag.
	//
	// ResourceARN is a required field
	ResourceARN *string `min:"1" type:"string" required:"true"`

	// A list of tag keys to add to a rescore execution plan. If a tag already exists,
	// the existing value is replaced with the new value.
	//
	// Tags is a required field
	Tags []*Tag `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARN", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceARN sets the ResourceARN field's value.
func (s *TagResourceInput) SetResourceARN(v string) *TagResourceInput {
	s.ResourceARN = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v []*Tag) *TagResourceInput {
	s.Tags = v
	return s
}

// If the action is successful, the service sends back an HTTP 200 response
// with an empty HTTP body.
type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// The request was denied due to request throttling. Please reduce the number
// of requests and try again.
type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The request information to remove a tag from a rescore execution plan. A
// rescore execution plan is an Amazon Kendra Intelligent Ranking resource used
// for provisioning the Rescore API.
type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the rescore execution plan to remove the
	// tag.
	//
	// ResourceARN is a required field
	ResourceARN *string `min:"1" type:"string" required:"true"`

	// A list of tag keys to remove from the rescore execution plan. If a tag key
	// does not exist on the resource, it is ignored.
	//
	// TagKeys is a required field
	TagKeys []*string `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARN", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceARN sets the ResourceARN field's value.
func (s *UntagResourceInput) SetResourceARN(v string) *UntagResourceInput {
	s.ResourceARN = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

// If the action is successful, the service sends back an HTTP 200 response
// with an empty HTTP body.
type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateRescoreExecutionPlanInput struct {
	_ struct{} `type:"structure"`

	// You can set additional capacity units to meet the needs of your rescore execution
	// plan. You are given a single capacity unit by default. If you want to use
	// the default capacity, you don't set additional capacity units. For more information
	// on the default capacity and additional capacity units, see Adjusting capacity
	// (https://docs.aws.amazon.com/kendra/latest/dg/adjusting-capacity.html).
	CapacityUnits *CapacityUnitsConfiguration `type:"structure"`

	// A new description for the rescore execution plan.
	Description *string `type:"string"`

	// The identifier of the rescore execution plan that you want to update.
	//
	// Id is a required field
	Id *string `min:"36" type:"string" required:"true"`

	// A new name for the rescore execution plan.
	Name *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateRescoreExecutionPlanInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateRescoreExecutionPlanInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateRescoreExecutionPlanInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateRescoreExecutionPlanInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 36))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.CapacityUnits != nil {
		if err := s.CapacityUnits.Validate(); err != nil {
			invalidParams.AddNested("CapacityUnits", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCapacityUnits sets the CapacityUnits field's value.
func (s *UpdateRescoreExecutionPlanInput) SetCapacityUnits(v *CapacityUnitsConfiguration) *UpdateRescoreExecutionPlanInput {
	s.CapacityUnits = v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateRescoreExecutionPlanInput) SetDescription(v string) *UpdateRescoreExecutionPlanInput {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *UpdateRescoreExecutionPlanInput) SetId(v string) *UpdateRescoreExecutionPlanInput {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateRescoreExecutionPlanInput) SetName(v string) *UpdateRescoreExecutionPlanInput {
	s.Name = &v
	return s
}

type UpdateRescoreExecutionPlanOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateRescoreExecutionPlanOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateRescoreExecutionPlanOutput) GoString() string {
	return s.String()
}

// The input fails to satisfy the constraints set by the Amazon Kendra Intelligent
// Ranking service. Please provide the correct input and try again.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

const (
	// RescoreExecutionPlanStatusCreating is a RescoreExecutionPlanStatus enum value
	RescoreExecutionPlanStatusCreating = "CREATING"

	// RescoreExecutionPlanStatusUpdating is a RescoreExecutionPlanStatus enum value
	RescoreExecutionPlanStatusUpdating = "UPDATING"

	// RescoreExecutionPlanStatusActive is a RescoreExecutionPlanStatus enum value
	RescoreExecutionPlanStatusActive = "ACTIVE"

	// RescoreExecutionPlanStatusDeleting is a RescoreExecutionPlanStatus enum value
	RescoreExecutionPlanStatusDeleting = "DELETING"

	// RescoreExecutionPlanStatusFailed is a RescoreExecutionPlanStatus enum value
	RescoreExecutionPlanStatusFailed = "FAILED"
)

// RescoreExecutionPlanStatus_Values returns all elements of the RescoreExecutionPlanStatus enum
func RescoreExecutionPlanStatus_Values() []string {
	return []string{
		RescoreExecutionPlanStatusCreating,
		RescoreExecutionPlanStatusUpdating,
		RescoreExecutionPlanStatusActive,
		RescoreExecutionPlanStatusDeleting,
		RescoreExecutionPlanStatusFailed,
	}
}
