package datacollection

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/validation"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// RuleAssociationsClient is the monitor Management Client
type RuleAssociationsClient struct {
	BaseClient
}

// NewRuleAssociationsClient creates an instance of the RuleAssociationsClient client.
func NewRuleAssociationsClient(subscriptionID string) RuleAssociationsClient {
	return NewRuleAssociationsClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewRuleAssociationsClientWithBaseURI creates an instance of the RuleAssociationsClient client using a custom
// endpoint.  Use this when interacting with an Azure cloud that uses a non-standard base URI (sovereign clouds, Azure
// stack).
func NewRuleAssociationsClientWithBaseURI(baseURI string, subscriptionID string) RuleAssociationsClient {
	return RuleAssociationsClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// Create sends the create request.
// Parameters:
// resourceURI - the identifier of the resource.
// associationName - the name of the association. The name is case insensitive.
// body - the payload
func (client RuleAssociationsClient) Create(ctx context.Context, resourceURI string, associationName string, body *RuleAssociationProxyOnlyResource) (result RuleAssociationProxyOnlyResource, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RuleAssociationsClient.Create")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceURI,
			Constraints: []validation.Constraint{{Target: "resourceURI", Name: validation.MinLength, Rule: 1, Chain: nil}}}}); err != nil {
		return result, validation.NewError("datacollection.RuleAssociationsClient", "Create", err.Error())
	}

	req, err := client.CreatePreparer(ctx, resourceURI, associationName, body)
	if err != nil {
		err = autorest.NewErrorWithError(err, "datacollection.RuleAssociationsClient", "Create", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "datacollection.RuleAssociationsClient", "Create", resp, "Failure sending request")
		return
	}

	result, err = client.CreateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "datacollection.RuleAssociationsClient", "Create", resp, "Failure responding to request")
		return
	}

	return
}

// CreatePreparer prepares the Create request.
func (client RuleAssociationsClient) CreatePreparer(ctx context.Context, resourceURI string, associationName string, body *RuleAssociationProxyOnlyResource) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"associationName": autorest.Encode("path", associationName),
		"resourceUri":     resourceURI,
	}

	const APIVersion = "2021-09-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	body.ID = nil
	body.Name = nil
	body.Type = nil
	body.Etag = nil
	body.SystemData = nil
	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/{resourceUri}/providers/Microsoft.Insights/dataCollectionRuleAssociations/{associationName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	if body != nil {
		preparer = autorest.DecoratePreparer(preparer,
			autorest.WithJSON(body))
	}
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateSender sends the Create request. The method will close the
// http.Response Body if it receives an error.
func (client RuleAssociationsClient) CreateSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// CreateResponder handles the response to the Create request. The method always
// closes the http.Response Body.
func (client RuleAssociationsClient) CreateResponder(resp *http.Response) (result RuleAssociationProxyOnlyResource, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Delete sends the delete request.
// Parameters:
// resourceURI - the identifier of the resource.
// associationName - the name of the association. The name is case insensitive.
func (client RuleAssociationsClient) Delete(ctx context.Context, resourceURI string, associationName string) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RuleAssociationsClient.Delete")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceURI,
			Constraints: []validation.Constraint{{Target: "resourceURI", Name: validation.MinLength, Rule: 1, Chain: nil}}}}); err != nil {
		return result, validation.NewError("datacollection.RuleAssociationsClient", "Delete", err.Error())
	}

	req, err := client.DeletePreparer(ctx, resourceURI, associationName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "datacollection.RuleAssociationsClient", "Delete", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "datacollection.RuleAssociationsClient", "Delete", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "datacollection.RuleAssociationsClient", "Delete", resp, "Failure responding to request")
		return
	}

	return
}

// DeletePreparer prepares the Delete request.
func (client RuleAssociationsClient) DeletePreparer(ctx context.Context, resourceURI string, associationName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"associationName": autorest.Encode("path", associationName),
		"resourceUri":     resourceURI,
	}

	const APIVersion = "2021-09-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/{resourceUri}/providers/Microsoft.Insights/dataCollectionRuleAssociations/{associationName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteSender sends the Delete request. The method will close the
// http.Response Body if it receives an error.
func (client RuleAssociationsClient) DeleteSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// DeleteResponder handles the response to the Delete request. The method always
// closes the http.Response Body.
func (client RuleAssociationsClient) DeleteResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// Get sends the get request.
// Parameters:
// resourceURI - the identifier of the resource.
// associationName - the name of the association. The name is case insensitive.
func (client RuleAssociationsClient) Get(ctx context.Context, resourceURI string, associationName string) (result RuleAssociationProxyOnlyResource, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RuleAssociationsClient.Get")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceURI,
			Constraints: []validation.Constraint{{Target: "resourceURI", Name: validation.MinLength, Rule: 1, Chain: nil}}}}); err != nil {
		return result, validation.NewError("datacollection.RuleAssociationsClient", "Get", err.Error())
	}

	req, err := client.GetPreparer(ctx, resourceURI, associationName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "datacollection.RuleAssociationsClient", "Get", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "datacollection.RuleAssociationsClient", "Get", resp, "Failure sending request")
		return
	}

	result, err = client.GetResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "datacollection.RuleAssociationsClient", "Get", resp, "Failure responding to request")
		return
	}

	return
}

// GetPreparer prepares the Get request.
func (client RuleAssociationsClient) GetPreparer(ctx context.Context, resourceURI string, associationName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"associationName": autorest.Encode("path", associationName),
		"resourceUri":     resourceURI,
	}

	const APIVersion = "2021-09-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/{resourceUri}/providers/Microsoft.Insights/dataCollectionRuleAssociations/{associationName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSender sends the Get request. The method will close the
// http.Response Body if it receives an error.
func (client RuleAssociationsClient) GetSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetResponder handles the response to the Get request. The method always
// closes the http.Response Body.
func (client RuleAssociationsClient) GetResponder(resp *http.Response) (result RuleAssociationProxyOnlyResource, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListByDataCollectionEndpoint sends the list by data collection endpoint request.
// Parameters:
// resourceGroupName - the name of the resource group. The name is case insensitive.
// dataCollectionEndpointName - the name of the data collection endpoint. The name is case insensitive.
func (client RuleAssociationsClient) ListByDataCollectionEndpoint(ctx context.Context, resourceGroupName string, dataCollectionEndpointName string) (result RuleAssociationProxyOnlyResourceListResultPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RuleAssociationsClient.ListByDataCollectionEndpoint")
		defer func() {
			sc := -1
			if result.raporlr.Response.Response != nil {
				sc = result.raporlr.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil}}}}); err != nil {
		return result, validation.NewError("datacollection.RuleAssociationsClient", "ListByDataCollectionEndpoint", err.Error())
	}

	result.fn = client.listByDataCollectionEndpointNextResults
	req, err := client.ListByDataCollectionEndpointPreparer(ctx, resourceGroupName, dataCollectionEndpointName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "datacollection.RuleAssociationsClient", "ListByDataCollectionEndpoint", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListByDataCollectionEndpointSender(req)
	if err != nil {
		result.raporlr.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "datacollection.RuleAssociationsClient", "ListByDataCollectionEndpoint", resp, "Failure sending request")
		return
	}

	result.raporlr, err = client.ListByDataCollectionEndpointResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "datacollection.RuleAssociationsClient", "ListByDataCollectionEndpoint", resp, "Failure responding to request")
		return
	}
	if result.raporlr.hasNextLink() && result.raporlr.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListByDataCollectionEndpointPreparer prepares the ListByDataCollectionEndpoint request.
func (client RuleAssociationsClient) ListByDataCollectionEndpointPreparer(ctx context.Context, resourceGroupName string, dataCollectionEndpointName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"dataCollectionEndpointName": autorest.Encode("path", dataCollectionEndpointName),
		"resourceGroupName":          autorest.Encode("path", resourceGroupName),
		"subscriptionId":             autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-09-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/dataCollectionEndpoints/{dataCollectionEndpointName}/associations", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListByDataCollectionEndpointSender sends the ListByDataCollectionEndpoint request. The method will close the
// http.Response Body if it receives an error.
func (client RuleAssociationsClient) ListByDataCollectionEndpointSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListByDataCollectionEndpointResponder handles the response to the ListByDataCollectionEndpoint request. The method always
// closes the http.Response Body.
func (client RuleAssociationsClient) ListByDataCollectionEndpointResponder(resp *http.Response) (result RuleAssociationProxyOnlyResourceListResult, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listByDataCollectionEndpointNextResults retrieves the next set of results, if any.
func (client RuleAssociationsClient) listByDataCollectionEndpointNextResults(ctx context.Context, lastResults RuleAssociationProxyOnlyResourceListResult) (result RuleAssociationProxyOnlyResourceListResult, err error) {
	req, err := lastResults.ruleAssociationProxyOnlyResourceListResultPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "datacollection.RuleAssociationsClient", "listByDataCollectionEndpointNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListByDataCollectionEndpointSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "datacollection.RuleAssociationsClient", "listByDataCollectionEndpointNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListByDataCollectionEndpointResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "datacollection.RuleAssociationsClient", "listByDataCollectionEndpointNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListByDataCollectionEndpointComplete enumerates all values, automatically crossing page boundaries as required.
func (client RuleAssociationsClient) ListByDataCollectionEndpointComplete(ctx context.Context, resourceGroupName string, dataCollectionEndpointName string) (result RuleAssociationProxyOnlyResourceListResultIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RuleAssociationsClient.ListByDataCollectionEndpoint")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListByDataCollectionEndpoint(ctx, resourceGroupName, dataCollectionEndpointName)
	return
}

// ListByResource sends the list by resource request.
// Parameters:
// resourceURI - the identifier of the resource.
func (client RuleAssociationsClient) ListByResource(ctx context.Context, resourceURI string) (result RuleAssociationProxyOnlyResourceListResultPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RuleAssociationsClient.ListByResource")
		defer func() {
			sc := -1
			if result.raporlr.Response.Response != nil {
				sc = result.raporlr.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceURI,
			Constraints: []validation.Constraint{{Target: "resourceURI", Name: validation.MinLength, Rule: 1, Chain: nil}}}}); err != nil {
		return result, validation.NewError("datacollection.RuleAssociationsClient", "ListByResource", err.Error())
	}

	result.fn = client.listByResourceNextResults
	req, err := client.ListByResourcePreparer(ctx, resourceURI)
	if err != nil {
		err = autorest.NewErrorWithError(err, "datacollection.RuleAssociationsClient", "ListByResource", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListByResourceSender(req)
	if err != nil {
		result.raporlr.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "datacollection.RuleAssociationsClient", "ListByResource", resp, "Failure sending request")
		return
	}

	result.raporlr, err = client.ListByResourceResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "datacollection.RuleAssociationsClient", "ListByResource", resp, "Failure responding to request")
		return
	}
	if result.raporlr.hasNextLink() && result.raporlr.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListByResourcePreparer prepares the ListByResource request.
func (client RuleAssociationsClient) ListByResourcePreparer(ctx context.Context, resourceURI string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceUri": resourceURI,
	}

	const APIVersion = "2021-09-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/{resourceUri}/providers/Microsoft.Insights/dataCollectionRuleAssociations", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListByResourceSender sends the ListByResource request. The method will close the
// http.Response Body if it receives an error.
func (client RuleAssociationsClient) ListByResourceSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// ListByResourceResponder handles the response to the ListByResource request. The method always
// closes the http.Response Body.
func (client RuleAssociationsClient) ListByResourceResponder(resp *http.Response) (result RuleAssociationProxyOnlyResourceListResult, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listByResourceNextResults retrieves the next set of results, if any.
func (client RuleAssociationsClient) listByResourceNextResults(ctx context.Context, lastResults RuleAssociationProxyOnlyResourceListResult) (result RuleAssociationProxyOnlyResourceListResult, err error) {
	req, err := lastResults.ruleAssociationProxyOnlyResourceListResultPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "datacollection.RuleAssociationsClient", "listByResourceNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListByResourceSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "datacollection.RuleAssociationsClient", "listByResourceNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListByResourceResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "datacollection.RuleAssociationsClient", "listByResourceNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListByResourceComplete enumerates all values, automatically crossing page boundaries as required.
func (client RuleAssociationsClient) ListByResourceComplete(ctx context.Context, resourceURI string) (result RuleAssociationProxyOnlyResourceListResultIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RuleAssociationsClient.ListByResource")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListByResource(ctx, resourceURI)
	return
}

// ListByRule sends the list by rule request.
// Parameters:
// resourceGroupName - the name of the resource group. The name is case insensitive.
// dataCollectionRuleName - the name of the data collection rule. The name is case insensitive.
func (client RuleAssociationsClient) ListByRule(ctx context.Context, resourceGroupName string, dataCollectionRuleName string) (result RuleAssociationProxyOnlyResourceListResultPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RuleAssociationsClient.ListByRule")
		defer func() {
			sc := -1
			if result.raporlr.Response.Response != nil {
				sc = result.raporlr.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil}}}}); err != nil {
		return result, validation.NewError("datacollection.RuleAssociationsClient", "ListByRule", err.Error())
	}

	result.fn = client.listByRuleNextResults
	req, err := client.ListByRulePreparer(ctx, resourceGroupName, dataCollectionRuleName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "datacollection.RuleAssociationsClient", "ListByRule", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListByRuleSender(req)
	if err != nil {
		result.raporlr.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "datacollection.RuleAssociationsClient", "ListByRule", resp, "Failure sending request")
		return
	}

	result.raporlr, err = client.ListByRuleResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "datacollection.RuleAssociationsClient", "ListByRule", resp, "Failure responding to request")
		return
	}
	if result.raporlr.hasNextLink() && result.raporlr.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListByRulePreparer prepares the ListByRule request.
func (client RuleAssociationsClient) ListByRulePreparer(ctx context.Context, resourceGroupName string, dataCollectionRuleName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"dataCollectionRuleName": autorest.Encode("path", dataCollectionRuleName),
		"resourceGroupName":      autorest.Encode("path", resourceGroupName),
		"subscriptionId":         autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-09-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Insights/dataCollectionRules/{dataCollectionRuleName}/associations", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListByRuleSender sends the ListByRule request. The method will close the
// http.Response Body if it receives an error.
func (client RuleAssociationsClient) ListByRuleSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListByRuleResponder handles the response to the ListByRule request. The method always
// closes the http.Response Body.
func (client RuleAssociationsClient) ListByRuleResponder(resp *http.Response) (result RuleAssociationProxyOnlyResourceListResult, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listByRuleNextResults retrieves the next set of results, if any.
func (client RuleAssociationsClient) listByRuleNextResults(ctx context.Context, lastResults RuleAssociationProxyOnlyResourceListResult) (result RuleAssociationProxyOnlyResourceListResult, err error) {
	req, err := lastResults.ruleAssociationProxyOnlyResourceListResultPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "datacollection.RuleAssociationsClient", "listByRuleNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListByRuleSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "datacollection.RuleAssociationsClient", "listByRuleNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListByRuleResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "datacollection.RuleAssociationsClient", "listByRuleNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListByRuleComplete enumerates all values, automatically crossing page boundaries as required.
func (client RuleAssociationsClient) ListByRuleComplete(ctx context.Context, resourceGroupName string, dataCollectionRuleName string) (result RuleAssociationProxyOnlyResourceListResultIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RuleAssociationsClient.ListByRule")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListByRule(ctx, resourceGroupName, dataCollectionRuleName)
	return
}
