package keyvault

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// AccessPolicyUpdateKind enumerates the values for access policy update kind.
type AccessPolicyUpdateKind string

const (
	// Add ...
	Add AccessPolicyUpdateKind = "add"
	// Remove ...
	Remove AccessPolicyUpdateKind = "remove"
	// Replace ...
	Replace AccessPolicyUpdateKind = "replace"
)

// PossibleAccessPolicyUpdateKindValues returns an array of possible values for the AccessPolicyUpdateKind const type.
func PossibleAccessPolicyUpdateKindValues() []AccessPolicyUpdateKind {
	return []AccessPolicyUpdateKind{Add, Remove, Replace}
}

// ActionsRequired enumerates the values for actions required.
type ActionsRequired string

const (
	// None ...
	None ActionsRequired = "None"
)

// PossibleActionsRequiredValues returns an array of possible values for the ActionsRequired const type.
func PossibleActionsRequiredValues() []ActionsRequired {
	return []ActionsRequired{None}
}

// ActivationStatus enumerates the values for activation status.
type ActivationStatus string

const (
	// Active The managed HSM Pool is active.
	Active ActivationStatus = "Active"
	// Failed Failed to activate managed hsm.
	Failed ActivationStatus = "Failed"
	// NotActivated The managed HSM Pool is not yet activated.
	NotActivated ActivationStatus = "NotActivated"
	// Unknown An unknown error occurred while activating managed hsm.
	Unknown ActivationStatus = "Unknown"
)

// PossibleActivationStatusValues returns an array of possible values for the ActivationStatus const type.
func PossibleActivationStatusValues() []ActivationStatus {
	return []ActivationStatus{Active, Failed, NotActivated, Unknown}
}

// CertificatePermissions enumerates the values for certificate permissions.
type CertificatePermissions string

const (
	// All ...
	All CertificatePermissions = "all"
	// Backup ...
	Backup CertificatePermissions = "backup"
	// Create ...
	Create CertificatePermissions = "create"
	// Delete ...
	Delete CertificatePermissions = "delete"
	// Deleteissuers ...
	Deleteissuers CertificatePermissions = "deleteissuers"
	// Get ...
	Get CertificatePermissions = "get"
	// Getissuers ...
	Getissuers CertificatePermissions = "getissuers"
	// Import ...
	Import CertificatePermissions = "import"
	// List ...
	List CertificatePermissions = "list"
	// Listissuers ...
	Listissuers CertificatePermissions = "listissuers"
	// Managecontacts ...
	Managecontacts CertificatePermissions = "managecontacts"
	// Manageissuers ...
	Manageissuers CertificatePermissions = "manageissuers"
	// Purge ...
	Purge CertificatePermissions = "purge"
	// Recover ...
	Recover CertificatePermissions = "recover"
	// Restore ...
	Restore CertificatePermissions = "restore"
	// Setissuers ...
	Setissuers CertificatePermissions = "setissuers"
	// Update ...
	Update CertificatePermissions = "update"
)

// PossibleCertificatePermissionsValues returns an array of possible values for the CertificatePermissions const type.
func PossibleCertificatePermissionsValues() []CertificatePermissions {
	return []CertificatePermissions{All, Backup, Create, Delete, Deleteissuers, Get, Getissuers, Import, List, Listissuers, Managecontacts, Manageissuers, Purge, Recover, Restore, Setissuers, Update}
}

// CreateMode enumerates the values for create mode.
type CreateMode string

const (
	// CreateModeDefault ...
	CreateModeDefault CreateMode = "default"
	// CreateModeRecover ...
	CreateModeRecover CreateMode = "recover"
)

// PossibleCreateModeValues returns an array of possible values for the CreateMode const type.
func PossibleCreateModeValues() []CreateMode {
	return []CreateMode{CreateModeDefault, CreateModeRecover}
}

// DeletionRecoveryLevel enumerates the values for deletion recovery level.
type DeletionRecoveryLevel string

const (
	// Purgeable ...
	Purgeable DeletionRecoveryLevel = "Purgeable"
	// Recoverable ...
	Recoverable DeletionRecoveryLevel = "Recoverable"
	// RecoverableProtectedSubscription ...
	RecoverableProtectedSubscription DeletionRecoveryLevel = "Recoverable+ProtectedSubscription"
	// RecoverablePurgeable ...
	RecoverablePurgeable DeletionRecoveryLevel = "Recoverable+Purgeable"
)

// PossibleDeletionRecoveryLevelValues returns an array of possible values for the DeletionRecoveryLevel const type.
func PossibleDeletionRecoveryLevelValues() []DeletionRecoveryLevel {
	return []DeletionRecoveryLevel{Purgeable, Recoverable, RecoverableProtectedSubscription, RecoverablePurgeable}
}

// IdentityType enumerates the values for identity type.
type IdentityType string

const (
	// IdentityTypeApplication ...
	IdentityTypeApplication IdentityType = "Application"
	// IdentityTypeKey ...
	IdentityTypeKey IdentityType = "Key"
	// IdentityTypeManagedIdentity ...
	IdentityTypeManagedIdentity IdentityType = "ManagedIdentity"
	// IdentityTypeUser ...
	IdentityTypeUser IdentityType = "User"
)

// PossibleIdentityTypeValues returns an array of possible values for the IdentityType const type.
func PossibleIdentityTypeValues() []IdentityType {
	return []IdentityType{IdentityTypeApplication, IdentityTypeKey, IdentityTypeManagedIdentity, IdentityTypeUser}
}

// JSONWebKeyCurveName enumerates the values for json web key curve name.
type JSONWebKeyCurveName string

const (
	// P256 ...
	P256 JSONWebKeyCurveName = "P-256"
	// P256K ...
	P256K JSONWebKeyCurveName = "P-256K"
	// P384 ...
	P384 JSONWebKeyCurveName = "P-384"
	// P521 ...
	P521 JSONWebKeyCurveName = "P-521"
)

// PossibleJSONWebKeyCurveNameValues returns an array of possible values for the JSONWebKeyCurveName const type.
func PossibleJSONWebKeyCurveNameValues() []JSONWebKeyCurveName {
	return []JSONWebKeyCurveName{P256, P256K, P384, P521}
}

// JSONWebKeyOperation enumerates the values for json web key operation.
type JSONWebKeyOperation string

const (
	// JSONWebKeyOperationDecrypt ...
	JSONWebKeyOperationDecrypt JSONWebKeyOperation = "decrypt"
	// JSONWebKeyOperationEncrypt ...
	JSONWebKeyOperationEncrypt JSONWebKeyOperation = "encrypt"
	// JSONWebKeyOperationImport ...
	JSONWebKeyOperationImport JSONWebKeyOperation = "import"
	// JSONWebKeyOperationRelease ...
	JSONWebKeyOperationRelease JSONWebKeyOperation = "release"
	// JSONWebKeyOperationSign ...
	JSONWebKeyOperationSign JSONWebKeyOperation = "sign"
	// JSONWebKeyOperationUnwrapKey ...
	JSONWebKeyOperationUnwrapKey JSONWebKeyOperation = "unwrapKey"
	// JSONWebKeyOperationVerify ...
	JSONWebKeyOperationVerify JSONWebKeyOperation = "verify"
	// JSONWebKeyOperationWrapKey ...
	JSONWebKeyOperationWrapKey JSONWebKeyOperation = "wrapKey"
)

// PossibleJSONWebKeyOperationValues returns an array of possible values for the JSONWebKeyOperation const type.
func PossibleJSONWebKeyOperationValues() []JSONWebKeyOperation {
	return []JSONWebKeyOperation{JSONWebKeyOperationDecrypt, JSONWebKeyOperationEncrypt, JSONWebKeyOperationImport, JSONWebKeyOperationRelease, JSONWebKeyOperationSign, JSONWebKeyOperationUnwrapKey, JSONWebKeyOperationVerify, JSONWebKeyOperationWrapKey}
}

// JSONWebKeyType enumerates the values for json web key type.
type JSONWebKeyType string

const (
	// EC ...
	EC JSONWebKeyType = "EC"
	// ECHSM ...
	ECHSM JSONWebKeyType = "EC-HSM"
	// RSA ...
	RSA JSONWebKeyType = "RSA"
	// RSAHSM ...
	RSAHSM JSONWebKeyType = "RSA-HSM"
)

// PossibleJSONWebKeyTypeValues returns an array of possible values for the JSONWebKeyType const type.
func PossibleJSONWebKeyTypeValues() []JSONWebKeyType {
	return []JSONWebKeyType{EC, ECHSM, RSA, RSAHSM}
}

// KeyPermissions enumerates the values for key permissions.
type KeyPermissions string

const (
	// KeyPermissionsAll ...
	KeyPermissionsAll KeyPermissions = "all"
	// KeyPermissionsBackup ...
	KeyPermissionsBackup KeyPermissions = "backup"
	// KeyPermissionsCreate ...
	KeyPermissionsCreate KeyPermissions = "create"
	// KeyPermissionsDecrypt ...
	KeyPermissionsDecrypt KeyPermissions = "decrypt"
	// KeyPermissionsDelete ...
	KeyPermissionsDelete KeyPermissions = "delete"
	// KeyPermissionsEncrypt ...
	KeyPermissionsEncrypt KeyPermissions = "encrypt"
	// KeyPermissionsGet ...
	KeyPermissionsGet KeyPermissions = "get"
	// KeyPermissionsGetrotationpolicy ...
	KeyPermissionsGetrotationpolicy KeyPermissions = "getrotationpolicy"
	// KeyPermissionsImport ...
	KeyPermissionsImport KeyPermissions = "import"
	// KeyPermissionsList ...
	KeyPermissionsList KeyPermissions = "list"
	// KeyPermissionsPurge ...
	KeyPermissionsPurge KeyPermissions = "purge"
	// KeyPermissionsRecover ...
	KeyPermissionsRecover KeyPermissions = "recover"
	// KeyPermissionsRelease ...
	KeyPermissionsRelease KeyPermissions = "release"
	// KeyPermissionsRestore ...
	KeyPermissionsRestore KeyPermissions = "restore"
	// KeyPermissionsRotate ...
	KeyPermissionsRotate KeyPermissions = "rotate"
	// KeyPermissionsSetrotationpolicy ...
	KeyPermissionsSetrotationpolicy KeyPermissions = "setrotationpolicy"
	// KeyPermissionsSign ...
	KeyPermissionsSign KeyPermissions = "sign"
	// KeyPermissionsUnwrapKey ...
	KeyPermissionsUnwrapKey KeyPermissions = "unwrapKey"
	// KeyPermissionsUpdate ...
	KeyPermissionsUpdate KeyPermissions = "update"
	// KeyPermissionsVerify ...
	KeyPermissionsVerify KeyPermissions = "verify"
	// KeyPermissionsWrapKey ...
	KeyPermissionsWrapKey KeyPermissions = "wrapKey"
)

// PossibleKeyPermissionsValues returns an array of possible values for the KeyPermissions const type.
func PossibleKeyPermissionsValues() []KeyPermissions {
	return []KeyPermissions{KeyPermissionsAll, KeyPermissionsBackup, KeyPermissionsCreate, KeyPermissionsDecrypt, KeyPermissionsDelete, KeyPermissionsEncrypt, KeyPermissionsGet, KeyPermissionsGetrotationpolicy, KeyPermissionsImport, KeyPermissionsList, KeyPermissionsPurge, KeyPermissionsRecover, KeyPermissionsRelease, KeyPermissionsRestore, KeyPermissionsRotate, KeyPermissionsSetrotationpolicy, KeyPermissionsSign, KeyPermissionsUnwrapKey, KeyPermissionsUpdate, KeyPermissionsVerify, KeyPermissionsWrapKey}
}

// KeyRotationPolicyActionType enumerates the values for key rotation policy action type.
type KeyRotationPolicyActionType string

const (
	// Notify ...
	Notify KeyRotationPolicyActionType = "notify"
	// Rotate ...
	Rotate KeyRotationPolicyActionType = "rotate"
)

// PossibleKeyRotationPolicyActionTypeValues returns an array of possible values for the KeyRotationPolicyActionType const type.
func PossibleKeyRotationPolicyActionTypeValues() []KeyRotationPolicyActionType {
	return []KeyRotationPolicyActionType{Notify, Rotate}
}

// ManagedHsmSkuName enumerates the values for managed hsm sku name.
type ManagedHsmSkuName string

const (
	// CustomB32 ...
	CustomB32 ManagedHsmSkuName = "Custom_B32"
	// StandardB1 ...
	StandardB1 ManagedHsmSkuName = "Standard_B1"
)

// PossibleManagedHsmSkuNameValues returns an array of possible values for the ManagedHsmSkuName const type.
func PossibleManagedHsmSkuNameValues() []ManagedHsmSkuName {
	return []ManagedHsmSkuName{CustomB32, StandardB1}
}

// NetworkRuleAction enumerates the values for network rule action.
type NetworkRuleAction string

const (
	// Allow ...
	Allow NetworkRuleAction = "Allow"
	// Deny ...
	Deny NetworkRuleAction = "Deny"
)

// PossibleNetworkRuleActionValues returns an array of possible values for the NetworkRuleAction const type.
func PossibleNetworkRuleActionValues() []NetworkRuleAction {
	return []NetworkRuleAction{Allow, Deny}
}

// NetworkRuleBypassOptions enumerates the values for network rule bypass options.
type NetworkRuleBypassOptions string

const (
	// NetworkRuleBypassOptionsAzureServices ...
	NetworkRuleBypassOptionsAzureServices NetworkRuleBypassOptions = "AzureServices"
	// NetworkRuleBypassOptionsNone ...
	NetworkRuleBypassOptionsNone NetworkRuleBypassOptions = "None"
)

// PossibleNetworkRuleBypassOptionsValues returns an array of possible values for the NetworkRuleBypassOptions const type.
func PossibleNetworkRuleBypassOptionsValues() []NetworkRuleBypassOptions {
	return []NetworkRuleBypassOptions{NetworkRuleBypassOptionsAzureServices, NetworkRuleBypassOptionsNone}
}

// PrivateEndpointConnectionProvisioningState enumerates the values for private endpoint connection
// provisioning state.
type PrivateEndpointConnectionProvisioningState string

const (
	// PrivateEndpointConnectionProvisioningStateCreating ...
	PrivateEndpointConnectionProvisioningStateCreating PrivateEndpointConnectionProvisioningState = "Creating"
	// PrivateEndpointConnectionProvisioningStateDeleting ...
	PrivateEndpointConnectionProvisioningStateDeleting PrivateEndpointConnectionProvisioningState = "Deleting"
	// PrivateEndpointConnectionProvisioningStateDisconnected ...
	PrivateEndpointConnectionProvisioningStateDisconnected PrivateEndpointConnectionProvisioningState = "Disconnected"
	// PrivateEndpointConnectionProvisioningStateFailed ...
	PrivateEndpointConnectionProvisioningStateFailed PrivateEndpointConnectionProvisioningState = "Failed"
	// PrivateEndpointConnectionProvisioningStateSucceeded ...
	PrivateEndpointConnectionProvisioningStateSucceeded PrivateEndpointConnectionProvisioningState = "Succeeded"
	// PrivateEndpointConnectionProvisioningStateUpdating ...
	PrivateEndpointConnectionProvisioningStateUpdating PrivateEndpointConnectionProvisioningState = "Updating"
)

// PossiblePrivateEndpointConnectionProvisioningStateValues returns an array of possible values for the PrivateEndpointConnectionProvisioningState const type.
func PossiblePrivateEndpointConnectionProvisioningStateValues() []PrivateEndpointConnectionProvisioningState {
	return []PrivateEndpointConnectionProvisioningState{PrivateEndpointConnectionProvisioningStateCreating, PrivateEndpointConnectionProvisioningStateDeleting, PrivateEndpointConnectionProvisioningStateDisconnected, PrivateEndpointConnectionProvisioningStateFailed, PrivateEndpointConnectionProvisioningStateSucceeded, PrivateEndpointConnectionProvisioningStateUpdating}
}

// PrivateEndpointServiceConnectionStatus enumerates the values for private endpoint service connection status.
type PrivateEndpointServiceConnectionStatus string

const (
	// Approved ...
	Approved PrivateEndpointServiceConnectionStatus = "Approved"
	// Disconnected ...
	Disconnected PrivateEndpointServiceConnectionStatus = "Disconnected"
	// Pending ...
	Pending PrivateEndpointServiceConnectionStatus = "Pending"
	// Rejected ...
	Rejected PrivateEndpointServiceConnectionStatus = "Rejected"
)

// PossiblePrivateEndpointServiceConnectionStatusValues returns an array of possible values for the PrivateEndpointServiceConnectionStatus const type.
func PossiblePrivateEndpointServiceConnectionStatusValues() []PrivateEndpointServiceConnectionStatus {
	return []PrivateEndpointServiceConnectionStatus{Approved, Disconnected, Pending, Rejected}
}

// ProvisioningState enumerates the values for provisioning state.
type ProvisioningState string

const (
	// ProvisioningStateActivated The managed HSM pool is ready for normal use.
	ProvisioningStateActivated ProvisioningState = "Activated"
	// ProvisioningStateDeleting The managed HSM Pool is currently being deleted.
	ProvisioningStateDeleting ProvisioningState = "Deleting"
	// ProvisioningStateFailed Provisioning of the managed HSM Pool has failed.
	ProvisioningStateFailed ProvisioningState = "Failed"
	// ProvisioningStateProvisioning The managed HSM Pool is currently being provisioned.
	ProvisioningStateProvisioning ProvisioningState = "Provisioning"
	// ProvisioningStateRestoring The managed HSM pool is being restored from full HSM backup.
	ProvisioningStateRestoring ProvisioningState = "Restoring"
	// ProvisioningStateSecurityDomainRestore The managed HSM pool is waiting for a security domain restore
	// action.
	ProvisioningStateSecurityDomainRestore ProvisioningState = "SecurityDomainRestore"
	// ProvisioningStateSucceeded The managed HSM Pool has been full provisioned.
	ProvisioningStateSucceeded ProvisioningState = "Succeeded"
	// ProvisioningStateUpdating The managed HSM Pool is currently being updated.
	ProvisioningStateUpdating ProvisioningState = "Updating"
)

// PossibleProvisioningStateValues returns an array of possible values for the ProvisioningState const type.
func PossibleProvisioningStateValues() []ProvisioningState {
	return []ProvisioningState{ProvisioningStateActivated, ProvisioningStateDeleting, ProvisioningStateFailed, ProvisioningStateProvisioning, ProvisioningStateRestoring, ProvisioningStateSecurityDomainRestore, ProvisioningStateSucceeded, ProvisioningStateUpdating}
}

// PublicNetworkAccess enumerates the values for public network access.
type PublicNetworkAccess string

const (
	// Disabled ...
	Disabled PublicNetworkAccess = "Disabled"
	// Enabled ...
	Enabled PublicNetworkAccess = "Enabled"
)

// PossiblePublicNetworkAccessValues returns an array of possible values for the PublicNetworkAccess const type.
func PossiblePublicNetworkAccessValues() []PublicNetworkAccess {
	return []PublicNetworkAccess{Disabled, Enabled}
}

// ReasonForKeyVault enumerates the values for reason for key vault.
type ReasonForKeyVault string

const (
	// AccountNameInvalid ...
	AccountNameInvalid ReasonForKeyVault = "AccountNameInvalid"
	// AlreadyExists ...
	AlreadyExists ReasonForKeyVault = "AlreadyExists"
)

// PossibleReasonForKeyVaultValues returns an array of possible values for the ReasonForKeyVault const type.
func PossibleReasonForKeyVaultValues() []ReasonForKeyVault {
	return []ReasonForKeyVault{AccountNameInvalid, AlreadyExists}
}

// ReasonForManagedHsm enumerates the values for reason for managed hsm.
type ReasonForManagedHsm string

const (
	// ReasonForManagedHsmAccountNameInvalid ...
	ReasonForManagedHsmAccountNameInvalid ReasonForManagedHsm = "AccountNameInvalid"
	// ReasonForManagedHsmAlreadyExists ...
	ReasonForManagedHsmAlreadyExists ReasonForManagedHsm = "AlreadyExists"
)

// PossibleReasonForManagedHsmValues returns an array of possible values for the ReasonForManagedHsm const type.
func PossibleReasonForManagedHsmValues() []ReasonForManagedHsm {
	return []ReasonForManagedHsm{ReasonForManagedHsmAccountNameInvalid, ReasonForManagedHsmAlreadyExists}
}

// SecretPermissions enumerates the values for secret permissions.
type SecretPermissions string

const (
	// SecretPermissionsAll ...
	SecretPermissionsAll SecretPermissions = "all"
	// SecretPermissionsBackup ...
	SecretPermissionsBackup SecretPermissions = "backup"
	// SecretPermissionsDelete ...
	SecretPermissionsDelete SecretPermissions = "delete"
	// SecretPermissionsGet ...
	SecretPermissionsGet SecretPermissions = "get"
	// SecretPermissionsList ...
	SecretPermissionsList SecretPermissions = "list"
	// SecretPermissionsPurge ...
	SecretPermissionsPurge SecretPermissions = "purge"
	// SecretPermissionsRecover ...
	SecretPermissionsRecover SecretPermissions = "recover"
	// SecretPermissionsRestore ...
	SecretPermissionsRestore SecretPermissions = "restore"
	// SecretPermissionsSet ...
	SecretPermissionsSet SecretPermissions = "set"
)

// PossibleSecretPermissionsValues returns an array of possible values for the SecretPermissions const type.
func PossibleSecretPermissionsValues() []SecretPermissions {
	return []SecretPermissions{SecretPermissionsAll, SecretPermissionsBackup, SecretPermissionsDelete, SecretPermissionsGet, SecretPermissionsList, SecretPermissionsPurge, SecretPermissionsRecover, SecretPermissionsRestore, SecretPermissionsSet}
}

// SkuName enumerates the values for sku name.
type SkuName string

const (
	// Premium ...
	Premium SkuName = "premium"
	// Standard ...
	Standard SkuName = "standard"
)

// PossibleSkuNameValues returns an array of possible values for the SkuName const type.
func PossibleSkuNameValues() []SkuName {
	return []SkuName{Premium, Standard}
}

// StoragePermissions enumerates the values for storage permissions.
type StoragePermissions string

const (
	// StoragePermissionsAll ...
	StoragePermissionsAll StoragePermissions = "all"
	// StoragePermissionsBackup ...
	StoragePermissionsBackup StoragePermissions = "backup"
	// StoragePermissionsDelete ...
	StoragePermissionsDelete StoragePermissions = "delete"
	// StoragePermissionsDeletesas ...
	StoragePermissionsDeletesas StoragePermissions = "deletesas"
	// StoragePermissionsGet ...
	StoragePermissionsGet StoragePermissions = "get"
	// StoragePermissionsGetsas ...
	StoragePermissionsGetsas StoragePermissions = "getsas"
	// StoragePermissionsList ...
	StoragePermissionsList StoragePermissions = "list"
	// StoragePermissionsListsas ...
	StoragePermissionsListsas StoragePermissions = "listsas"
	// StoragePermissionsPurge ...
	StoragePermissionsPurge StoragePermissions = "purge"
	// StoragePermissionsRecover ...
	StoragePermissionsRecover StoragePermissions = "recover"
	// StoragePermissionsRegeneratekey ...
	StoragePermissionsRegeneratekey StoragePermissions = "regeneratekey"
	// StoragePermissionsRestore ...
	StoragePermissionsRestore StoragePermissions = "restore"
	// StoragePermissionsSet ...
	StoragePermissionsSet StoragePermissions = "set"
	// StoragePermissionsSetsas ...
	StoragePermissionsSetsas StoragePermissions = "setsas"
	// StoragePermissionsUpdate ...
	StoragePermissionsUpdate StoragePermissions = "update"
)

// PossibleStoragePermissionsValues returns an array of possible values for the StoragePermissions const type.
func PossibleStoragePermissionsValues() []StoragePermissions {
	return []StoragePermissions{StoragePermissionsAll, StoragePermissionsBackup, StoragePermissionsDelete, StoragePermissionsDeletesas, StoragePermissionsGet, StoragePermissionsGetsas, StoragePermissionsList, StoragePermissionsListsas, StoragePermissionsPurge, StoragePermissionsRecover, StoragePermissionsRegeneratekey, StoragePermissionsRestore, StoragePermissionsSet, StoragePermissionsSetsas, StoragePermissionsUpdate}
}

// VaultProvisioningState enumerates the values for vault provisioning state.
type VaultProvisioningState string

const (
	// RegisteringDNS ...
	RegisteringDNS VaultProvisioningState = "RegisteringDns"
	// Succeeded ...
	Succeeded VaultProvisioningState = "Succeeded"
)

// PossibleVaultProvisioningStateValues returns an array of possible values for the VaultProvisioningState const type.
func PossibleVaultProvisioningStateValues() []VaultProvisioningState {
	return []VaultProvisioningState{RegisteringDNS, Succeeded}
}
