	T((A1 "Hello, %s\n", "World"), "Hello, World\n")
	T((A1 ""), "")
	T((A1 "%%%!"), "%!")

	/*
	 * Test shorts
	 */
	sprintf(expect, "<%hd>", (short)SHRT_MIN);
	T((A1 "<%hd>", (short)SHRT_MIN), expect)
	sprintf(expect, "<%hd>", (short)SHRT_MAX);
	T((A1 "<%hd>", (short)SHRT_MAX), expect)
	sprintf(expect, "<%hu>", (ushort)0);
	T((A1 "<%hud>", (ushort)0), expect)
	sprintf(expect, "<%hu>", (ushort)SHRT_MAX);
	T((A1 "<%hud>", (ushort)SHRT_MAX), expect)
	sprintf(expect, "<%hu>", (ushort)USHRT_MAX);
	T((A1 "<%hud>", (ushort)USHRT_MAX), expect)

	/* printf's octal format is unsigned */
	sprintf(expect, "<-%ho>", (short)SHRT_MIN);
	T((A1 "<%ho>", (short)SHRT_MIN), expect)
	sprintf(expect, "<%ho>", (short)SHRT_MAX);
	T((A1 "<%ho>", (short)SHRT_MAX), expect)
	sprintf(expect, "<%ho>", (ushort)0);
	T((A1 "<%huo>", (ushort)0), expect)
	sprintf(expect, "<%ho>", (ushort)SHRT_MAX);
	T((A1 "<%huo>", (ushort)SHRT_MAX), expect)
	sprintf(expect, "<%ho>", (ushort)USHRT_MAX);
	T((A1 "<%huo>", (ushort)USHRT_MAX), expect)

	/* printf's hexadecimal format is unsigned */
	sprintf(expect, "<-%hx>", (short)SHRT_MIN);
	T((A1 "<%hx>", (short)SHRT_MIN), expect)
	sprintf(expect, "<%hx>", (short)SHRT_MAX);
	T((A1 "<%hx>", (short)SHRT_MAX), expect)
	sprintf(expect, "<%hx>", (ushort)0);
	T((A1 "<%hux>", (ushort)0), expect)
	sprintf(expect, "<%hx>", (ushort)SHRT_MAX);
	T((A1 "<%hux>", (ushort)SHRT_MAX), expect)
	sprintf(expect, "<%hx>", (ushort)USHRT_MAX);
	T((A1 "<%hux>", (ushort)USHRT_MAX), expect)

	/* printf's hexadecimal format is unsigned */
	sprintf(expect, "<-%hX>", (short)SHRT_MIN);
	T((A1 "<%hX>", (short)SHRT_MIN), expect)
	sprintf(expect, "<%hX>", (short)SHRT_MAX);
	T((A1 "<%hX>", (short)SHRT_MAX), expect)
	sprintf(expect, "<%hX>", (ushort)0);
	T((A1 "<%huX>", (ushort)0), expect)
	sprintf(expect, "<%hX>", (ushort)SHRT_MAX);
	T((A1 "<%huX>", (ushort)SHRT_MAX), expect)
	sprintf(expect, "<%hX>", (ushort)USHRT_MAX);
	T((A1 "<%huX>", (ushort)USHRT_MAX), expect)

	/*
	 * Test ints
	 */
	sprintf(expect, "<%d>", INT_MIN);
	T((A1 "<%d>", INT_MIN), expect)
	sprintf(expect, "<%d>", INT_MAX);
	T((A1 "<%d>", INT_MAX), expect)
	sprintf(expect, "<%u>", (uint)0);
	T((A1 "<%ud>", (uint)0), expect)
	sprintf(expect, "<%u>", (uint)INT_MAX);
	T((A1 "<%ud>", (uint)INT_MAX), expect)
	sprintf(expect, "<%u>", (uint)UINT_MAX);
	T((A1 "<%ud>", (uint)UINT_MAX), expect)

	/* printf's octal format is unsigned */
	sprintf(expect, "<-%o>", INT_MIN);
	T((A1 "<%o>", INT_MIN), expect)
	sprintf(expect, "<%o>", INT_MAX);
	T((A1 "<%o>", INT_MAX), expect)
	sprintf(expect, "<%o>", (uint)0);
	T((A1 "<%uo>", (uint)0), expect)
	sprintf(expect, "<%o>", (uint)INT_MAX);
	T((A1 "<%uo>", (uint)INT_MAX), expect)
	sprintf(expect, "<%o>", (uint)UINT_MAX);
	T((A1 "<%uo>", (uint)UINT_MAX), expect)

	/* printf's hexadecimal format is unsigned */
	sprintf(expect, "<-%x>", INT_MIN);
	T((A1 "<%x>", INT_MIN), expect)
	sprintf(expect, "<%x>", INT_MAX);
	T((A1 "<%x>", INT_MAX), expect)
	sprintf(expect, "<%x>", (uint)0);
	T((A1 "<%ux>", (uint)0), expect)
	sprintf(expect, "<%x>", (uint)INT_MAX);
	T((A1 "<%ux>", (uint)INT_MAX), expect)
	sprintf(expect, "<%x>", (uint)UINT_MAX);
	T((A1 "<%ux>", (uint)UINT_MAX), expect)

	/* printf's hexadecimal format is unsigned */
	sprintf(expect, "<-%X>", INT_MIN);
	T((A1 "<%X>", INT_MIN), expect)
	sprintf(expect, "<%X>", INT_MAX);
	T((A1 "<%X>", INT_MAX), expect)
	sprintf(expect, "<%X>", (uint)0);
	T((A1 "<%uX>", (uint)0), expect)
	sprintf(expect, "<%X>", (uint)INT_MAX);
	T((A1 "<%uX>", (uint)INT_MAX), expect)
	sprintf(expect, "<%X>", (uint)UINT_MAX);
	T((A1 "<%uX>", (uint)UINT_MAX), expect)

	/*
	 * Test longs
	 */
	sprintf(expect, "<%ld>", LONG_MIN);
	T((A1 "<%ld>", LONG_MIN), expect)
	sprintf(expect, "<%ld>", LONG_MAX);
	T((A1 "<%ld>", LONG_MAX), expect)
	sprintf(expect, "<%lu>", (ulong)0);
	T((A1 "<%lud>", (ulong)0), expect)
	sprintf(expect, "<%lu>", (ulong)LONG_MAX);
	T((A1 "<%lud>", (ulong)LONG_MAX), expect)
	sprintf(expect, "<%lu>", (ulong)ULONG_MAX);
	T((A1 "<%lud>", (ulong)ULONG_MAX), expect)

	/* printf's octal format is unsigned */
	sprintf(expect, "<-%lo>", LONG_MIN);
	T((A1 "<%lo>", LONG_MIN), expect)
	sprintf(expect, "<%lo>", LONG_MAX);
	T((A1 "<%lo>", LONG_MAX), expect)
	sprintf(expect, "<%lo>", (ulong)0);
	T((A1 "<%luo>", (ulong)0), expect)
	sprintf(expect, "<%lo>", (ulong)LONG_MAX);
	T((A1 "<%luo>", (ulong)LONG_MAX), expect)
	sprintf(expect, "<%lo>", (ulong)ULONG_MAX);
	T((A1 "<%luo>", (ulong)ULONG_MAX), expect)

	/* printf's hexadecimal format is unsigned */
	sprintf(expect, "<-%lx>", LONG_MIN);
	T((A1 "<%lx>", LONG_MIN), expect)
	sprintf(expect, "<%lx>", LONG_MAX);
	T((A1 "<%lx>", LONG_MAX), expect)
	sprintf(expect, "<%lx>", (ulong)0);
	T((A1 "<%lux>", (ulong)0), expect)
	sprintf(expect, "<%lx>", (ulong)LONG_MAX);
	T((A1 "<%lux>", (ulong)LONG_MAX), expect)
	sprintf(expect, "<%lx>", (ulong)ULONG_MAX);
	T((A1 "<%lux>", (ulong)ULONG_MAX), expect)

	/* printf's hexadecimal format is unsigned */
	sprintf(expect, "<-%lX>", LONG_MIN);
	T((A1 "<%lX>", LONG_MIN), expect)
	sprintf(expect, "<%lX>", LONG_MAX);
	T((A1 "<%lX>", LONG_MAX), expect)
	sprintf(expect, "<%lX>", (ulong)0);
	T((A1 "<%luX>", (ulong)0), expect)
	sprintf(expect, "<%lX>", (ulong)LONG_MAX);
	T((A1 "<%luX>", (ulong)LONG_MAX), expect)
	sprintf(expect, "<%lX>", (ulong)ULONG_MAX);
	T((A1 "<%luX>", (ulong)ULONG_MAX), expect)

	/*
	 * Test Rune conversion.
	 */
	{
		struct latin *l;

		for (l = latintab; l->l != 0; ++l) {
			int b = runetochar(expect, &l->l);
			expect[b] = 0;
			T((A1 "%C", l->l), expect)
		}
		l = latintab;
		while (l->l != 0) {
			Rune runebuf[11];
			char *out = expect;
			int runes = l->l%10+1;
			int i;
			for (i = 0; i < runes && l->l != 0; ++i) {
				out += runetochar(out, &l->l);
				runebuf[i] = l->l;
				++l;
			}
			*out++ = 0;
			runebuf[i] = 0;
			T((A1 "%S", runebuf), expect)
		}
	}

	/*
	 * Test user defined format routines.
	 */
	p.x = 55; p.y = 100;
	T((A1 "<%P>", &p), "<(55,100)>")
	r.min = p;
	r.max.x = r.min.x+25;
	r.max.y = r.min.y+25;
	T((A1 "<%R>", &r), "<((55,100),(80,125))>")
