;;; geiser-data.ss -- autodoc and manuals data

;; Copyright (c) 2022 Jose A Ortega Ruiz

;; This program is free software; you can redistribute it and/or
;; modify it under the terms of the Modified BSD License. You should
;; have received a copy of the license along with this program. If
;; not, see <http://www.xfree86.org/3.3.6/COPYRIGHT2.html#5>.

;; Start date: Thu Oct 13, 2022 03:14

;; The data in this file is a slightly modified version of the one provided by
;; Travis Hinkelman in his chez-docs project over at
;; https://github.com/hinkelman/chez-docs.  Most probably, we should automate
;; the process by using chez-docs directly; this is a quick hack for
;; expediency (yeah, famous last words).

(library (geiser-data)

  (export symbol-signatures symbol-labels)
  (import (chezscheme))

  (define (make-hash d)
    (let ((h (make-hashtable symbol-hash eq?)))
      (for-each (lambda (x)
                  (let ((id (car x))
                        (sgs (let* ((s (format "(~a)" (cadr x)))
                                    (as (with-input-from-string s read)))
                               (and (list? (car as)) (map cdr (remove '~ as))))))
                    (symbol-hashtable-set! h id (cons id (cons sgs (cddr x))))))
                d)
      h))

  (define (symbol-signatures s)
    (let ((x (or (symbol-hashtable-ref csug-data s #f)
                 (symbol-hashtable-ref tspl-data s #f))))
      (and x (list? (cadr x)) (cadr x))))

  (define (symbol-labels s)
    (define (label t)
      (let ((e (symbol-hashtable-ref t s #f)))
        (and e (caddr e))))
    (list (cons 'csug (label csug-data)) (cons 'tspl (label tspl-data))))

  (define tspl-alist '((=> "=>" "control.html#./control:s16") (_ "_" "syntax.html#./syntax:s26") (... "..." "syntax.html#./syntax:s26") (&assertion "&assertion" "exceptions.html#./exceptions:s21") (&condition "&condition" "exceptions.html#./exceptions:s13") (&error "&error" "exceptions.html#./exceptions:s22") (&i/o "&i/o" "exceptions.html#./exceptions:s32") (&i/o-decoding "&i/o-decoding" "exceptions.html#./exceptions:s42") (&i/o-encoding "&i/o-encoding" "exceptions.html#./exceptions:s43") (&i/o-file-already-exists "&i/o-file-already-exists" "exceptions.html#./exceptions:s39") (&i/o-file-does-not-exist "&i/o-file-does-not-exist" "exceptions.html#./exceptions:s40") (&i/o-file-is-read-only "&i/o-file-is-read-only" "exceptions.html#./exceptions:s38") (&i/o-file-protection "&i/o-file-protection" "exceptions.html#./exceptions:s37") (&i/o-filename "&i/o-filename" "exceptions.html#./exceptions:s36") (&i/o-invalid-position "&i/o-invalid-position" "exceptions.html#./exceptions:s35") (&i/o-port "&i/o-port" "exceptions.html#./exceptions:s41") (&i/o-read "&i/o-read" "exceptions.html#./exceptions:s33") (&i/o-write "&i/o-write" "exceptions.html#./exceptions:s34") (&implementation-restriction "&implementation-restriction" "exceptions.html#./exceptions:s28") (&irritants "&irritants" "exceptions.html#./exceptions:s25") (&lexical "&lexical" "exceptions.html#./exceptions:s29") (&message "&message" "exceptions.html#./exceptions:s24") (&no-infinities "&no-infinities" "exceptions.html#./exceptions:s44") (&no-nans "&no-nans" "exceptions.html#./exceptions:s45") (&non-continuable "&non-continuable" "exceptions.html#./exceptions:s27") (&serious "&serious" "exceptions.html#./exceptions:s19") (&syntax "&syntax" "exceptions.html#./exceptions:s30") (&undefined "&undefined" "exceptions.html#./exceptions:s31") (&violation "&violation" "exceptions.html#./exceptions:s20") (&warning "&warning" "exceptions.html#./exceptions:s23") (&who "&who" "exceptions.html#./exceptions:s26") (* "(* num ...)" "objects.html#./objects:s91") (+ "(+ num ...)" "objects.html#./objects:s89") (- "(- num)~(- num1 num2 num3 ...)" "objects.html#./objects:s90") (/ "(/ num)~(/ num1 num2 num3 ...)" "objects.html#./objects:s92") (< "(< real1 real2 real3 ...)" "objects.html#./objects:s88") (<= "(<= real1 real2 real3 ...)" "objects.html#./objects:s88") (= "(= num1 num2 num3 ...)" "objects.html#./objects:s88") (> "(> real1 real2 real3 ...)" "objects.html#./objects:s88") (>= "(>= real1 real2 real3 ...)" "objects.html#./objects:s88") (abs "(abs real)" "objects.html#./objects:s105") (acos "(acos num)" "objects.html#./objects:s132") (and "(and expr ...)" "control.html#./control:s11") (angle "(angle num)" "objects.html#./objects:s124") (append "(append)~(append list ... obj)" "objects.html#./objects:s49") (apply "(apply procedure obj ... list)" "control.html#./control:s3") (asin "(asin num)" "objects.html#./objects:s132") (assert "(assert expression)" "exceptions.html#./exceptions:s5") (assertion-violation "(assertion-violation who msg irritant ...)" "exceptions.html#./exceptions:s4") (assertion-violation? "(assertion-violation? obj)" "exceptions.html#./exceptions:s21") (assoc "(assoc obj alist)" "objects.html#./objects:s58") (assp "(assp procedure alist)" "objects.html#./objects:s60") (assq "(assq obj alist)" "objects.html#./objects:s58") (assv "(assv obj alist)" "objects.html#./objects:s58") (atan "(atan num)~(atan real1 real2)" "objects.html#./objects:s133") (begin "(begin expr1 expr2 ...)" "control.html#./control:s4") (binary-port? "(binary-port? obj)" "io.html#./io:s45") (bitwise-and "(bitwise-and exint ...)" "objects.html#./objects:s134") (bitwise-arithmetic-shift "(bitwise-arithmetic-shift exint1 exint2)" "objects.html#./objects:s144") (bitwise-arithmetic-shift-left "(bitwise-arithmetic-shift-left exint1 exint2)" "objects.html#./objects:s143") (bitwise-arithmetic-shift-right "(bitwise-arithmetic-shift-right exint1 exint2)" "objects.html#./objects:s143") (bitwise-bit-count "(bitwise-bit-count exint)" "objects.html#./objects:s136") (bitwise-bit-field "(bitwise-bit-field exint1 exint2 exint3)" "objects.html#./objects:s141") (bitwise-bit-set? "(bitwise-bit-set? exint1 exint2)" "objects.html#./objects:s139") (bitwise-copy-bit "(bitwise-copy-bit exint1 exint2 exint3)" "objects.html#./objects:s140") (bitwise-copy-bit-field "(bitwise-copy-bit-field exint1 exint2 exint3 exint4)" "objects.html#./objects:s142") (bitwise-first-bit-set "(bitwise-first-bit-set exint)" "objects.html#./objects:s138") (bitwise-if "(bitwise-if exint1 exint2 exint3)" "objects.html#./objects:s135") (bitwise-ior "(bitwise-ior exint ...)" "objects.html#./objects:s134") (bitwise-length "(bitwise-length exint)" "objects.html#./objects:s137") (bitwise-not "(bitwise-not exint)" "objects.html#./objects:s134") (bitwise-reverse-bit-field "(bitwise-reverse-bit-field exint1 exint2 exint3)" "objects.html#./objects:s146") (bitwise-rotate-bit-field "(bitwise-rotate-bit-field exint1 exint2 exint3 exint4)" "objects.html#./objects:s145") (bitwise-xor "(bitwise-xor exint ...)" "objects.html#./objects:s134") (boolean=? "(boolean=? boolean1 boolean2)" "objects.html#./objects:s271") (boolean? "(boolean? obj)" "objects.html#./objects:s14") (bound-identifier=? "(bound-identifier=? identifier1 identifier2)" "syntax.html#./syntax:s37") (buffer-mode "(buffer-mode symbol)" "io.html#./io:s27") (buffer-mode? "(buffer-mode? obj)" "io.html#./io:s28") (bytevector->sint-list "(bytevector->sint-list bytevector eness size)" "objects.html#./objects:s260") (bytevector->string "(bytevector->string bytevector transcoder)" "io.html#./io:s91") (bytevector->u8-list "(bytevector->u8-list bytevector)" "objects.html#./objects:s252") (bytevector->uint-list "(bytevector->uint-list bytevector eness size)" "objects.html#./objects:s260") (bytevector-copy "(bytevector-copy bytevector)" "objects.html#./objects:s246") (bytevector-copy! "(bytevector-copy! src src-start dst dst-start n)" "objects.html#./objects:s247") (bytevector-fill! "(bytevector-fill! bytevector fill)" "objects.html#./objects:s245") (bytevector-ieee-double-native-ref "(bytevector-ieee-double-native-ref bytevector n)" "objects.html#./objects:s262") (bytevector-ieee-double-native-set! "(bytevector-ieee-double-native-set! bytevector n x)" "objects.html#./objects:s263") (bytevector-ieee-double-ref "(bytevector-ieee-double-ref bytevector n eness)" "objects.html#./objects:s264") (bytevector-ieee-double-set! "(bytevector-ieee-double-set! bytevector n x eness)" "objects.html#./objects:s265") (bytevector-ieee-single-native-ref "(bytevector-ieee-single-native-ref bytevector n)" "objects.html#./objects:s262") (bytevector-ieee-single-native-set! "(bytevector-ieee-single-native-set! bytevector n x)" "objects.html#./objects:s263") (bytevector-ieee-single-ref "(bytevector-ieee-single-ref bytevector n eness)" "objects.html#./objects:s264") (bytevector-ieee-single-set! "(bytevector-ieee-single-set! bytevector n x eness)" "objects.html#./objects:s265") (bytevector-length "(bytevector-length bytevector)" "objects.html#./objects:s243") (bytevector-s16-native-ref "(bytevector-s16-native-ref bytevector n)" "objects.html#./objects:s254") (bytevector-s16-native-set! "(bytevector-s16-native-set! bytevector n s16)" "objects.html#./objects:s255") (bytevector-s16-ref "(bytevector-s16-ref bytevector n eness)" "objects.html#./objects:s256") (bytevector-s16-set! "(bytevector-s16-set! bytevector n s16 eness)" "objects.html#./objects:s257") (bytevector-s32-native-ref "(bytevector-s32-native-ref bytevector n)" "objects.html#./objects:s254") (bytevector-s32-native-set! "(bytevector-s32-native-set! bytevector n s32)" "objects.html#./objects:s255") (bytevector-s32-ref "(bytevector-s32-ref bytevector n eness)" "objects.html#./objects:s256") (bytevector-s32-set! "(bytevector-s32-set! bytevector n s32 eness)" "objects.html#./objects:s257") (bytevector-s64-native-ref "(bytevector-s64-native-ref bytevector n)" "objects.html#./objects:s254") (bytevector-s64-native-set! "(bytevector-s64-native-set! bytevector n s64)" "objects.html#./objects:s255") (bytevector-s64-ref "(bytevector-s64-ref bytevector n eness)" "objects.html#./objects:s256") (bytevector-s64-set! "(bytevector-s64-set! bytevector n s64 eness)" "objects.html#./objects:s257") (bytevector-s8-ref "(bytevector-s8-ref bytevector n)" "objects.html#./objects:s249") (bytevector-s8-set! "(bytevector-s8-set! bytevector n s8)" "objects.html#./objects:s251") (bytevector-sint-ref "(bytevector-sint-ref bytevector n eness size)" "objects.html#./objects:s258") (bytevector-sint-set! "(bytevector-sint-set! bytevector n sint eness size)" "objects.html#./objects:s259") (bytevector-u16-native-ref "(bytevector-u16-native-ref bytevector n)" "objects.html#./objects:s254") (bytevector-u16-native-set! "(bytevector-u16-native-set! bytevector n u16)" "objects.html#./objects:s255") (bytevector-u16-ref "(bytevector-u16-ref bytevector n eness)" "objects.html#./objects:s256") (bytevector-u16-set! "(bytevector-u16-set! bytevector n u16 eness)" "objects.html#./objects:s257") (bytevector-u32-native-ref "(bytevector-u32-native-ref bytevector n)" "objects.html#./objects:s254") (bytevector-u32-native-set! "(bytevector-u32-native-set! bytevector n u32)" "objects.html#./objects:s255") (bytevector-u32-ref "(bytevector-u32-ref bytevector n eness)" "objects.html#./objects:s256") (bytevector-u32-set! "(bytevector-u32-set! bytevector n u32 eness)" "objects.html#./objects:s257") (bytevector-u64-native-ref "(bytevector-u64-native-ref bytevector n)" "objects.html#./objects:s254") (bytevector-u64-native-set! "(bytevector-u64-native-set! bytevector n u64)" "objects.html#./objects:s255") (bytevector-u64-ref "(bytevector-u64-ref bytevector n eness)" "objects.html#./objects:s256") (bytevector-u64-set! "(bytevector-u64-set! bytevector n u64 eness)" "objects.html#./objects:s257") (bytevector-u8-ref "(bytevector-u8-ref bytevector n)" "objects.html#./objects:s248") (bytevector-u8-set! "(bytevector-u8-set! bytevector n u8)" "objects.html#./objects:s250") (bytevector-uint-ref "(bytevector-uint-ref bytevector n eness size)" "objects.html#./objects:s258") (bytevector-uint-set! "(bytevector-uint-set! bytevector n uint eness size)" "objects.html#./objects:s259") (bytevector=? "(bytevector=? bytevector1 bytevector2)" "objects.html#./objects:s244") (bytevector? "(bytevector? obj)" "objects.html#./objects:s24") (caaaar "(caaaar pair)" "objects.html#./objects:s42") (caaadr "(caaadr pair)" "objects.html#./objects:s42") (caaar "(caaar pair)" "objects.html#./objects:s42") (caadar "(caadar pair)" "objects.html#./objects:s42") (caaddr "(caaddr pair)" "objects.html#./objects:s42") (caadr "(caadr pair)" "objects.html#./objects:s42") (caar "(caar pair)" "objects.html#./objects:s42") (cadaar "(cadaar pair)" "objects.html#./objects:s42") (cadadr "(cadadr pair)" "objects.html#./objects:s42") (cadar "(cadar pair)" "objects.html#./objects:s42") (caddar "(caddar pair)" "objects.html#./objects:s42") (cadddr "(cadddr pair)" "objects.html#./objects:s42") (caddr "(caddr pair)" "objects.html#./objects:s42") (cadr "(cadr pair)" "objects.html#./objects:s42") (call-with-bytevector-output-port "(call-with-bytevector-output-port procedure)~(call-with-bytevector-output-port procedure ?transcoder)" "io.html#./io:s38") (call-with-current-continuation "(call-with-current-continuation procedure)" "control.html#./control:s54") (call-with-input-file "(call-with-input-file path procedure)" "io.html#./io:s77") (call-with-output-file "(call-with-output-file path procedure)" "io.html#./io:s78") (call-with-port "(call-with-port port procedure)" "io.html#./io:s51") (call-with-string-output-port "(call-with-string-output-port procedure)" "io.html#./io:s39") (call-with-values "(call-with-values producer consumer)" "control.html#./control:s71") (call/cc "(call/cc procedure)" "control.html#./control:s54") (car "(car pair)" "objects.html#./objects:s38") (case "(case expr0 clause1 clause2 ...)" "control.html#./control:s18") (case-lambda "(case-lambda clause ...)" "binding.html#./binding:s13") (cdaaar "(cdaaar pair)" "objects.html#./objects:s42") (cdaadr "(cdaadr pair)" "objects.html#./objects:s42") (cdaar "(cdaar pair)" "objects.html#./objects:s42") (cdadar "(cdadar pair)" "objects.html#./objects:s42") (cdaddr "(cdaddr pair)" "objects.html#./objects:s42") (cdadr "(cdadr pair)" "objects.html#./objects:s42") (cdar "(cdar pair)" "objects.html#./objects:s42") (cddaar "(cddaar pair)" "objects.html#./objects:s42") (cddadr "(cddadr pair)" "objects.html#./objects:s42") (cddar "(cddar pair)" "objects.html#./objects:s42") (cdddar "(cdddar pair)" "objects.html#./objects:s42") (cddddr "(cddddr pair)" "objects.html#./objects:s42") (cdddr "(cdddr pair)" "objects.html#./objects:s42") (cddr "(cddr pair)" "objects.html#./objects:s42") (cdr "(cdr pair)" "objects.html#./objects:s39") (ceiling "(ceiling real)" "objects.html#./objects:s103") (char->integer "(char->integer char)" "objects.html#./objects:s210") (char-alphabetic? "(char-alphabetic? char)" "objects.html#./objects:s203") (char-ci<=? "(char-ci<=? char1 char2 char3 ...)" "objects.html#./objects:s202") (char-ci<? "(char-ci<? char1 char2 char3 ...)" "objects.html#./objects:s202") (char-ci=? "(char-ci=? char1 char2 char3 ...)" "objects.html#./objects:s202") (char-ci>=? "(char-ci>=? char1 char2 char3 ...)" "objects.html#./objects:s202") (char-ci>? "(char-ci>? char1 char2 char3 ...)" "objects.html#./objects:s202") (char-downcase "(char-downcase char)" "objects.html#./objects:s207") (char-foldcase "(char-foldcase char)" "objects.html#./objects:s209") (char-general-category "(char-general-category char)" "objects.html#./objects:s205") (char-lower-case? "(char-lower-case? char)" "objects.html#./objects:s204") (char-numeric? "(char-numeric? char)" "objects.html#./objects:s203") (char-title-case? "(char-title-case? char)" "objects.html#./objects:s204") (char-titlecase "(char-titlecase char)" "objects.html#./objects:s208") (char-upcase "(char-upcase char)" "objects.html#./objects:s206") (char-upper-case? "(char-upper-case? char)" "objects.html#./objects:s204") (char-whitespace? "(char-whitespace? char)" "objects.html#./objects:s203") (char<=? "(char<=? char1 char2 char3 ...)" "objects.html#./objects:s201") (char<? "(char<? char1 char2 char3 ...)" "objects.html#./objects:s201") (char=? "(char=? char1 char2 char3 ...)" "objects.html#./objects:s201") (char>=? "(char>=? char1 char2 char3 ...)" "objects.html#./objects:s201") (char>? "(char>? char1 char2 char3 ...)" "objects.html#./objects:s201") (char? "(char? obj)" "objects.html#./objects:s19") (close-input-port "(close-input-port input-port)" "io.html#./io:s88") (close-output-port "(close-output-port output-port)" "io.html#./io:s88") (close-port "(close-port port)" "io.html#./io:s46") (command-line "(command-line)" "libraries.html#./libraries:s17") (complex? "(complex? obj)" "objects.html#./objects:s17") (cond "(cond clause1 clause2 ...)" "control.html#./control:s13") (condition "(condition condition ...)" "exceptions.html#./exceptions:s15") (condition-accessor "(condition-accessor rtd procedure)" "exceptions.html#./exceptions:s18") (condition-irritants "(condition-irritants condition)" "exceptions.html#./exceptions:s25") (condition-message "(condition-message condition)" "exceptions.html#./exceptions:s24") (condition-predicate "(condition-predicate rtd)" "exceptions.html#./exceptions:s18") (condition-who "(condition-who condition)" "exceptions.html#./exceptions:s26") (condition? "(condition? obj)" "exceptions.html#./exceptions:s14") (cons "(cons obj1 obj2)" "objects.html#./objects:s37") (cons* "(cons* obj ... final-obj)" "objects.html#./objects:s44") (constant "constant" "objects.html#./objects:s1") (cos "(cos num)" "objects.html#./objects:s131") (current-error-port "(current-error-port)" "io.html#./io:s32") (current-input-port "(current-input-port)" "io.html#./io:s32") (current-output-port "(current-output-port)" "io.html#./io:s32") (datum->syntax "(datum->syntax template-identifier obj)" "syntax.html#./syntax:s45") (define "(define var expr)~(define var)~(define (var0 var1 ...) body1 body2 ...)~(define (var0 . varr) body1 body2 ...)~(define (var0 var1 var2 ... . varr) body1 body2 ...)" "binding.html#./binding:s24") (define-condition-type "(define-condition-type name parent constructor pred field ...)" "exceptions.html#./exceptions:s17") (define-enumeration "(define-enumeration name (symbol ...) constructor)" "objects.html#./objects:s290") (define-record-type "(define-record-type record-name clause ...)~(define-record-type (record-name constructor pred) clause ...)" "records.html#./records:s13") (define-syntax "(define-syntax keyword expr)" "syntax.html#./syntax:s12") (delay "(delay expr)" "control.html#./control:s65") (delete-file "(delete-file path)" "io.html#./io:s90") (denominator "(denominator rat)" "objects.html#./objects:s119") (display "(display obj)~(display obj textual-output-port)" "io.html#./io:s85") (div "(div x1 x2)" "objects.html#./objects:s99") (div-and-mod "(div-and-mod x1 x2)" "objects.html#./objects:s99") (div0 "(div0 x1 x2)" "objects.html#./objects:s100") (div0-and-mod0 "(div0-and-mod0 x1 x2)" "objects.html#./objects:s100") (do "(do ((var init update) ...) (test result ...) expr ...)" "control.html#./control:s25") (dynamic-wind "(dynamic-wind in body out)" "control.html#./control:s56") (else "else" "control.html#./control:s16") (endianness "(endianness symbol)" "objects.html#./objects:s240") (enum-set->list "(enum-set->list enum-set)" "objects.html#./objects:s294") (enum-set-complement "(enum-set-complement enum-set)" "objects.html#./objects:s299") (enum-set-constructor "(enum-set-constructor enum-set)" "objects.html#./objects:s292") (enum-set-difference "(enum-set-difference enum-set1 enum-set2)" "objects.html#./objects:s298") (enum-set-indexer "(enum-set-indexer enum-set)" "objects.html#./objects:s301") (enum-set-intersection "(enum-set-intersection enum-set1 enum-set2)" "objects.html#./objects:s298") (enum-set-member? "(enum-set-member? symbol enum-set)" "objects.html#./objects:s297") (enum-set-projection "(enum-set-projection enum-set1 enum-set2)" "objects.html#./objects:s300") (enum-set-subset? "(enum-set-subset? enum-set1 enum-set2)" "objects.html#./objects:s295") (enum-set-union "(enum-set-union enum-set1 enum-set2)" "objects.html#./objects:s298") (enum-set-universe "(enum-set-universe enum-set)" "objects.html#./objects:s293") (enum-set=? "(enum-set=? enum-set1 enum-set2)" "objects.html#./objects:s296") (environment "(environment import-spec ...)" "control.html#./control:s81") (eof-object "(eof-object)" "io.html#./io:s54") (eof-object? "(eof-object? obj)" "io.html#./io:s53") (eol-style "(eol-style symbol)" "io.html#./io:s23") (eq? "(eq? obj1 obj2)" "objects.html#./objects:s10") (equal-hash "(equal-hash obj)" "objects.html#./objects:s279") (equal? "(equal? obj1 obj2)" "objects.html#./objects:s13") (eqv? "(eqv? obj1 obj2)" "objects.html#./objects:s12") (error "(error who msg irritant ...)" "exceptions.html#./exceptions:s4") (error-handling-mode "(error-handling-mode symbol)" "io.html#./io:s25") (error? "(error? obj)" "exceptions.html#./exceptions:s22") (eval "(eval obj environment)" "control.html#./control:s80") (even? "(even? int)" "objects.html#./objects:s96") (exact "(exact num)" "objects.html#./objects:s114") (exact->inexact "(exact->inexact num)" "objects.html#./objects:s116") (exact-integer-sqrt "(exact-integer-sqrt n)" "objects.html#./objects:s128") (exact? "(exact? num)" "objects.html#./objects:s86") (exists "(exists procedure list1 list2 ...)" "control.html#./control:s36") (exit "(exit)~(exit obj)" "libraries.html#./libraries:s18") (exp "(exp num)" "objects.html#./objects:s129") (expt "(expt num1 num2)" "objects.html#./objects:s111") (fields "fields" "records.html#./records:s16") (file-exists? "(file-exists? path)" "io.html#./io:s89") (file-options "(file-options symbol ...)" "io.html#./io:s26") (filter "(filter procedure list)" "objects.html#./objects:s55") (find "(find procedure list)" "objects.html#./objects:s57") (finite? "(finite? real)" "objects.html#./objects:s97") (fixnum->flonum "(fixnum->flonum fx)" "objects.html#./objects:s198") (fixnum-width "(fixnum-width)" "objects.html#./objects:s152") (fixnum? "(fixnum? obj)" "objects.html#./objects:s150") (fl* "(fl* fl ...)" "objects.html#./objects:s186") (fl+ "(fl+ fl ...)" "objects.html#./objects:s184") (fl- "(fl- fl)~(fl- fl1 fl2 fl3 ...)" "objects.html#./objects:s185") (fl/ "(fl/ fl)~(fl/ fl1 fl2 fl3 ...)" "objects.html#./objects:s187") (fl<=? "(fl<=? fl1 fl2 fl3 ...)" "objects.html#./objects:s178") (fl<? "(fl<? fl1 fl2 fl3 ...)" "objects.html#./objects:s178") (fl=? "(fl=? fl1 fl2 fl3 ...)" "objects.html#./objects:s178") (fl>=? "(fl>=? fl1 fl2 fl3 ...)" "objects.html#./objects:s178") (fl>? "(fl>? fl1 fl2 fl3 ...)" "objects.html#./objects:s178") (flabs "(flabs fl)" "objects.html#./objects:s192") (flacos "(flacos fl)" "objects.html#./objects:s195") (flasin "(flasin fl)" "objects.html#./objects:s195") (flatan "(flatan fl)~(flatan fl1 fl2)" "objects.html#./objects:s195") (flceiling "(flceiling fl)" "objects.html#./objects:s190") (flcos "(flcos fl)" "objects.html#./objects:s194") (fldenominator "(fldenominator fl)" "objects.html#./objects:s191") (fldiv "(fldiv fl1 fl2)" "objects.html#./objects:s188") (fldiv-and-mod "(fldiv-and-mod fl1 fl2)" "objects.html#./objects:s188") (fldiv0 "(fldiv0 fl1 fl2)" "objects.html#./objects:s189") (fldiv0-and-mod0 "(fldiv0-and-mod0 fl1 fl2)" "objects.html#./objects:s189") (fleven? "(fleven? fl-int)" "objects.html#./objects:s182") (flexp "(flexp fl)" "objects.html#./objects:s193") (flexpt "(flexpt fl1 fl2)" "objects.html#./objects:s197") (flfinite? "(flfinite? fl)" "objects.html#./objects:s181") (flfloor "(flfloor fl)" "objects.html#./objects:s190") (flinfinite? "(flinfinite? fl)" "objects.html#./objects:s181") (flinteger? "(flinteger? fl)" "objects.html#./objects:s180") (fllog "(fllog fl)~(fllog fl1 fl2)" "objects.html#./objects:s193") (flmax "(flmax fl1 fl2 ...)" "objects.html#./objects:s183") (flmin "(flmin fl1 fl2 ...)" "objects.html#./objects:s183") (flmod "(flmod fl1 fl2)" "objects.html#./objects:s188") (flmod0 "(flmod0 fl1 fl2)" "objects.html#./objects:s189") (flnan? "(flnan? fl)" "objects.html#./objects:s181") (flnegative? "(flnegative? fl)" "objects.html#./objects:s179") (flnumerator "(flnumerator fl)" "objects.html#./objects:s191") (flodd? "(flodd? fl-int)" "objects.html#./objects:s182") (flonum? "(flonum? obj)" "objects.html#./objects:s177") (floor "(floor real)" "objects.html#./objects:s102") (flpositive? "(flpositive? fl)" "objects.html#./objects:s179") (flround "(flround fl)" "objects.html#./objects:s190") (flsin "(flsin fl)" "objects.html#./objects:s194") (flsqrt "(flsqrt fl)" "objects.html#./objects:s196") (fltan "(fltan fl)" "objects.html#./objects:s194") (fltruncate "(fltruncate fl)" "objects.html#./objects:s190") (flush-output-port "(flush-output-port output-port)" "io.html#./io:s74") (flzero? "(flzero? fl)" "objects.html#./objects:s179") (fold-left "(fold-left procedure obj list1 list2 ...)" "control.html#./control:s38") (fold-right "(fold-right procedure obj list1 list2 ...)" "control.html#./control:s41") (for-all "(for-all procedure list1 list2 ...)" "control.html#./control:s37") (for-each "(for-each procedure list1 list2 ...)" "control.html#./control:s33") (force "(force promise)" "control.html#./control:s65") (free-identifier=? "(free-identifier=? identifier1 identifier2)" "syntax.html#./syntax:s37") (fx* "(fx* fx1 fx2)" "objects.html#./objects:s159") (fx*/carry "(fx*/carry fx1 fx2 fx3)" "objects.html#./objects:s162") (fx+ "(fx+ fx1 fx2)" "objects.html#./objects:s157") (fx+/carry "(fx+/carry fx1 fx2 fx3)" "objects.html#./objects:s162") (fx- "(fx- fx)~(fx- fx1 fx2)" "objects.html#./objects:s158") (fx-/carry "(fx-/carry fx1 fx2 fx3)" "objects.html#./objects:s162") (fx<=? "(fx<=? fx1 fx2 fx3 ...)" "objects.html#./objects:s153") (fx<? "(fx<? fx1 fx2 fx3 ...)" "objects.html#./objects:s153") (fx=? "(fx=? fx1 fx2 fx3 ...)" "objects.html#./objects:s153") (fx>=? "(fx>=? fx1 fx2 fx3 ...)" "objects.html#./objects:s153") (fx>? "(fx>? fx1 fx2 fx3 ...)" "objects.html#./objects:s153") (fxand "(fxand fx ...)" "objects.html#./objects:s163") (fxarithmetic-shift "(fxarithmetic-shift fx1 fx2)" "objects.html#./objects:s173") (fxarithmetic-shift-left "(fxarithmetic-shift-left fx1 fx2)" "objects.html#./objects:s172") (fxarithmetic-shift-right "(fxarithmetic-shift-right fx1 fx2)" "objects.html#./objects:s172") (fxbit-count "(fxbit-count fx)" "objects.html#./objects:s165") (fxbit-field "(fxbit-field fx1 fx2 fx3)" "objects.html#./objects:s170") (fxbit-set? "(fxbit-set? fx1 fx2)" "objects.html#./objects:s168") (fxcopy-bit "(fxcopy-bit fx1 fx2 fx3)" "objects.html#./objects:s169") (fxcopy-bit-field "(fxcopy-bit-field fx1 fx2 fx3 fx4)" "objects.html#./objects:s171") (fxdiv "(fxdiv fx1 fx2)" "objects.html#./objects:s160") (fxdiv-and-mod "(fxdiv-and-mod fx1 fx2)" "objects.html#./objects:s160") (fxdiv0 "(fxdiv0 fx1 fx2)" "objects.html#./objects:s161") (fxdiv0-and-mod0 "(fxdiv0-and-mod0 fx1 fx2)" "objects.html#./objects:s161") (fxeven? "(fxeven? fx)" "objects.html#./objects:s155") (fxfirst-bit-set "(fxfirst-bit-set fx)" "objects.html#./objects:s167") (fxif "(fxif fx1 fx2 fx3)" "objects.html#./objects:s164") (fxior "(fxior fx ...)" "objects.html#./objects:s163") (fxlength "(fxlength fx)" "objects.html#./objects:s166") (fxmax "(fxmax fx1 fx2 ...)" "objects.html#./objects:s156") (fxmin "(fxmin fx1 fx2 ...)" "objects.html#./objects:s156") (fxmod "(fxmod fx1 fx2)" "objects.html#./objects:s160") (fxmod0 "(fxmod0 fx1 fx2)" "objects.html#./objects:s161") (fxnegative? "(fxnegative? fx)" "objects.html#./objects:s154") (fxnot "(fxnot fx)" "objects.html#./objects:s163") (fxodd? "(fxodd? fx)" "objects.html#./objects:s155") (fxpositive? "(fxpositive? fx)" "objects.html#./objects:s154") (fxreverse-bit-field "(fxreverse-bit-field fx1 fx2 fx3)" "objects.html#./objects:s175") (fxrotate-bit-field "(fxrotate-bit-field fx1 fx2 fx3 fx4)" "objects.html#./objects:s174") (fxxor "(fxxor fx ...)" "objects.html#./objects:s163") (fxzero? "(fxzero? fx)" "objects.html#./objects:s154") (gcd "(gcd int ...)" "objects.html#./objects:s109") (generate-temporaries "(generate-temporaries list)" "syntax.html#./syntax:s49") (get-bytevector-all "(get-bytevector-all binary-input-port)" "io.html#./io:s60") (get-bytevector-n "(get-bytevector-n binary-input-port n)" "io.html#./io:s57") (get-bytevector-n! "(get-bytevector-n! binary-input-port bytevector start n)" "io.html#./io:s58") (get-bytevector-some "(get-bytevector-some binary-input-port)" "io.html#./io:s59") (get-char "(get-char textual-input-port)" "io.html#./io:s61") (get-datum "(get-datum textual-input-port)" "io.html#./io:s67") (get-line "(get-line textual-input-port)" "io.html#./io:s66") (get-string-all "(get-string-all textual-input-port)" "io.html#./io:s65") (get-string-n "(get-string-n textual-input-port n)" "io.html#./io:s63") (get-string-n! "(get-string-n! textual-input-port string start n)" "io.html#./io:s64") (get-u8 "(get-u8 binary-input-port)" "io.html#./io:s55") (greatest-fixnum "(greatest-fixnum)" "objects.html#./objects:s151") (guard "(guard (var clause1 clause2 ...) b1 b2 ...)" "exceptions.html#./exceptions:s8") (hashtable-clear! "(hashtable-clear! hashtable)~(hashtable-clear! hashtable size)" "objects.html#./objects:s287") (hashtable-contains? "(hashtable-contains? hashtable key)" "objects.html#./objects:s282") (hashtable-copy "(hashtable-copy hashtable)~(hashtable-copy hashtable mutable?)" "objects.html#./objects:s286") (hashtable-delete! "(hashtable-delete! hashtable key)" "objects.html#./objects:s284") (hashtable-entries "(hashtable-entries hashtable)" "objects.html#./objects:s289") (hashtable-equivalence-function "(hashtable-equivalence-function hashtable)" "objects.html#./objects:s278") (hashtable-hash-function "(hashtable-hash-function hashtable)" "objects.html#./objects:s278") (hashtable-keys "(hashtable-keys hashtable)" "objects.html#./objects:s288") (hashtable-mutable? "(hashtable-mutable? hashtable)" "objects.html#./objects:s277") (hashtable-ref "(hashtable-ref hashtable key default)" "objects.html#./objects:s281") (hashtable-set! "(hashtable-set! hashtable key obj)" "objects.html#./objects:s280") (hashtable-size "(hashtable-size hashtable)" "objects.html#./objects:s285") (hashtable-update! "(hashtable-update! hashtable key procedure default)" "objects.html#./objects:s283") (hashtable? "(hashtable? obj)" "objects.html#./objects:s25") (i/o-decoding-error? "(i/o-decoding-error? obj)" "exceptions.html#./exceptions:s42") (i/o-encoding-error-char "(i/o-encoding-error-char condition)" "exceptions.html#./exceptions:s43") (i/o-encoding-error? "(i/o-encoding-error? obj)" "exceptions.html#./exceptions:s43") (i/o-error-filename "(i/o-error-filename condition)" "exceptions.html#./exceptions:s36") (i/o-error-port "(i/o-error-port condition)" "exceptions.html#./exceptions:s41") (i/o-error-position "(i/o-error-position condition)" "exceptions.html#./exceptions:s35") (i/o-error? "(i/o-error? obj)" "exceptions.html#./exceptions:s32") (i/o-file-already-exists-error? "(i/o-file-already-exists-error? obj)" "exceptions.html#./exceptions:s39") (i/o-file-does-not-exist-error? "(i/o-file-does-not-exist-error? obj)" "exceptions.html#./exceptions:s40") (i/o-file-is-read-only-error? "(i/o-file-is-read-only-error? obj)" "exceptions.html#./exceptions:s38") (i/o-file-protection-error? "(i/o-file-protection-error? obj)" "exceptions.html#./exceptions:s37") (i/o-filename-error? "(i/o-filename-error? obj)" "exceptions.html#./exceptions:s36") (i/o-invalid-position-error? "(i/o-invalid-position-error? obj)" "exceptions.html#./exceptions:s35") (i/o-port-error? "(i/o-port-error? obj)" "exceptions.html#./exceptions:s41") (i/o-read-error? "(i/o-read-error? obj)" "exceptions.html#./exceptions:s33") (i/o-write-error? "(i/o-write-error? obj)" "exceptions.html#./exceptions:s34") (identifier-syntax "(identifier-syntax tmpl)~(identifier-syntax (id1 tmpl1) ((set! id2 e2) tmpl2))" "syntax.html#./syntax:s27") (identifier? "(identifier? obj)" "syntax.html#./syntax:s35") (if "(if test consequent alternative)~(if test consequent)" "control.html#./control:s8") (imag-part "(imag-part num)" "objects.html#./objects:s121") (immutable "immutable" "records.html#./records:s16") (implementation-restriction-violation? "(implementation-restriction-violation? obj)" "exceptions.html#./exceptions:s28") (inexact "(inexact num)" "objects.html#./objects:s112") (inexact->exact "(inexact->exact num)" "objects.html#./objects:s116") (inexact? "(inexact? num)" "objects.html#./objects:s87") (infinite? "(infinite? real)" "objects.html#./objects:s97") (input-port? "(input-port? obj)" "io.html#./io:s44") (integer->char "(integer->char n)" "objects.html#./objects:s211") (integer-valued? "(integer-valued? obj)" "objects.html#./objects:s18") (integer? "(integer? obj)" "objects.html#./objects:s17") (irritants-condition? "(irritants-condition? obj)" "exceptions.html#./exceptions:s25") (lambda "(lambda formals body1 body2 ...)" "binding.html#./binding:s3") (latin-1-codec "(latin-1-codec)" "io.html#./io:s22") (lcm "(lcm int ...)" "objects.html#./objects:s110") (least-fixnum "(least-fixnum)" "objects.html#./objects:s151") (length "(length list)" "objects.html#./objects:s46") (let* "(let* ((var expr) ...) body1 body2 ...)" "binding.html#./binding:s18") (let*-values "(let*-values ((formals expr) ...) body1 body2 ...)" "binding.html#./binding:s23") (let-syntax "(let-syntax ((keyword expr) ...) form1 form2 ...)" "syntax.html#./syntax:s13") (let-values "(let-values ((formals expr) ...) body1 body2 ...)" "binding.html#./binding:s23") (letrec "(letrec ((var expr) ...) body1 body2 ...)" "binding.html#./binding:s20") (letrec* "(letrec* ((var expr) ...) body1 body2 ...)" "binding.html#./binding:s22") (letrec-syntax "(letrec-syntax ((keyword expr) ...) form1 form2 ...)" "syntax.html#./syntax:s13") (lexical-violation? "(lexical-violation? obj)" "exceptions.html#./exceptions:s29") (list "(list obj ...)" "objects.html#./objects:s43") (list->string "(list->string list)" "objects.html#./objects:s229") (list->vector "(list->vector list)" "objects.html#./objects:s238") (list-ref "(list-ref list n)" "objects.html#./objects:s47") (list-sort "(list-sort predicate list)" "objects.html#./objects:s62") (list-tail "(list-tail list n)" "objects.html#./objects:s48") (list? "(list? obj)" "objects.html#./objects:s45") (log "(log num)~(log num1 num2)" "objects.html#./objects:s130") (lookahead-char "(lookahead-char textual-input-port)" "io.html#./io:s62") (lookahead-u8 "(lookahead-u8 binary-input-port)" "io.html#./io:s56") (magnitude "(magnitude num)" "objects.html#./objects:s125") (make-assertion-violation "(make-assertion-violation)" "exceptions.html#./exceptions:s21") (make-bytevector "(make-bytevector n)~(make-bytevector n fill)" "objects.html#./objects:s242") (make-custom-binary-input-port "(make-custom-binary-input-port id r! gp sp! close)" "io.html#./io:s41") (make-custom-binary-input/output-port "(make-custom-binary-input/output-port id r! w! gp sp! close)" "io.html#./io:s41") (make-custom-binary-output-port "(make-custom-binary-output-port id w! gp sp! close)" "io.html#./io:s41") (make-custom-textual-input-port "(make-custom-textual-input-port id r! gp sp! close)" "io.html#./io:s42") (make-custom-textual-input/output-port "(make-custom-textual-input/output-port id r! w! gp sp! close)" "io.html#./io:s42") (make-custom-textual-output-port "(make-custom-textual-output-port id w! gp sp! close)" "io.html#./io:s42") (make-enumeration "(make-enumeration symbol-list)" "objects.html#./objects:s291") (make-eq-hashtable "(make-eq-hashtable)~(make-eq-hashtable size)" "objects.html#./objects:s274") (make-eqv-hashtable "(make-eqv-hashtable)~(make-eqv-hashtable size)" "objects.html#./objects:s275") (make-error "(make-error)" "exceptions.html#./exceptions:s22") (make-hashtable "(make-hashtable hash equiv?)~(make-hashtable hash equiv? size)" "objects.html#./objects:s276") (make-i/o-decoding-error "(make-i/o-decoding-error pobj)" "exceptions.html#./exceptions:s42") (make-i/o-encoding-error "(make-i/o-encoding-error pobj cobj)" "exceptions.html#./exceptions:s43") (make-i/o-error "(make-i/o-error)" "exceptions.html#./exceptions:s32") (make-i/o-file-already-exists-error "(make-i/o-file-already-exists-error filename)" "exceptions.html#./exceptions:s39") (make-i/o-file-does-not-exist-error "(make-i/o-file-does-not-exist-error filename)" "exceptions.html#./exceptions:s40") (make-i/o-file-is-read-only-error "(make-i/o-file-is-read-only-error filename)" "exceptions.html#./exceptions:s38") (make-i/o-file-protection-error "(make-i/o-file-protection-error filename)" "exceptions.html#./exceptions:s37") (make-i/o-filename-error "(make-i/o-filename-error filename)" "exceptions.html#./exceptions:s36") (make-i/o-invalid-position-error "(make-i/o-invalid-position-error position)" "exceptions.html#./exceptions:s35") (make-i/o-port-error "(make-i/o-port-error pobj)" "exceptions.html#./exceptions:s41") (make-i/o-read-error "(make-i/o-read-error)" "exceptions.html#./exceptions:s33") (make-i/o-write-error "(make-i/o-write-error)" "exceptions.html#./exceptions:s34") (make-implementation-restriction-violation "(make-implementation-restriction-violation)" "exceptions.html#./exceptions:s28") (make-irritants-condition "(make-irritants-condition irritants)" "exceptions.html#./exceptions:s25") (make-lexical-violation "(make-lexical-violation)" "exceptions.html#./exceptions:s29") (make-message-condition "(make-message-condition message)" "exceptions.html#./exceptions:s24") (make-no-infinities-violation "(make-no-infinities-violation)" "exceptions.html#./exceptions:s44") (make-no-nans-violation "(make-no-nans-violation)" "exceptions.html#./exceptions:s45") (make-non-continuable-violation "(make-non-continuable-violation)" "exceptions.html#./exceptions:s27") (make-polar "(make-polar real1 real2)" "objects.html#./objects:s123") (make-record-constructor-descriptor "(make-record-constructor-descriptor rtd parent-rcd protocol)" "records.html#./records:s24") (make-record-type-descriptor "(make-record-type-descriptor name parent uid s? o? fields)" "records.html#./records:s20") (make-rectangular "(make-rectangular real1 real2)" "objects.html#./objects:s122") (make-serious-condition "(make-serious-condition)" "exceptions.html#./exceptions:s19") (make-string "(make-string n)~(make-string n char)" "objects.html#./objects:s218") (make-syntax-violation "(make-syntax-violation form subform)" "exceptions.html#./exceptions:s30") (make-transcoder "(make-transcoder codec)~(make-transcoder codec eol-style)~(make-transcoder codec eol-style error-handling-mode)" "io.html#./io:s19") (make-undefined-violation "(make-undefined-violation)" "exceptions.html#./exceptions:s31") (make-variable-transformer "(make-variable-transformer procedure)" "syntax.html#./syntax:s42") (make-vector "(make-vector n)~(make-vector n obj)" "objects.html#./objects:s232") (make-violation "(make-violation)" "exceptions.html#./exceptions:s20") (make-warning "(make-warning)" "exceptions.html#./exceptions:s23") (make-who-condition "(make-who-condition who)" "exceptions.html#./exceptions:s26") (map "(map procedure list1 list2 ...)" "control.html#./control:s30") (max "(max real1 real2 ...)" "objects.html#./objects:s107") (member "(member obj list)" "objects.html#./objects:s51") (memp "(memp procedure list)" "objects.html#./objects:s52") (memq "(memq obj list)" "objects.html#./objects:s51") (memv "(memv obj list)" "objects.html#./objects:s51") (message-condition? "(message-condition? obj)" "exceptions.html#./exceptions:s24") (min "(min real1 real2 ...)" "objects.html#./objects:s108") (mod "(mod x1 x2)" "objects.html#./objects:s99") (mod0 "(mod0 x1 x2)" "objects.html#./objects:s100") (modulo "(modulo int1 int2)" "objects.html#./objects:s98") (mutable "mutable" "records.html#./records:s16") (nan? "(nan? real)" "objects.html#./objects:s97") (native-endianness "(native-endianness)" "objects.html#./objects:s241") (native-eol-style "(native-eol-style)" "io.html#./io:s24") (native-transcoder "(native-transcoder)" "io.html#./io:s21") (negative? "(negative? real)" "objects.html#./objects:s95") (newline "(newline)~(newline textual-output-port)" "io.html#./io:s87") (no-infinities-violation? "(no-infinities-violation? obj)" "exceptions.html#./exceptions:s44") (no-nans-violation? "(no-nans-violation? obj)" "exceptions.html#./exceptions:s45") (non-continuable-violation? "(non-continuable-violation? obj)" "exceptions.html#./exceptions:s27") (nongenerative "nongenerative" "records.html#./records:s16") (not "(not obj)" "control.html#./control:s10") (null-environment "(null-environment version)" "control.html#./control:s82") (null? "(null? obj)" "objects.html#./objects:s15") (number->string "(number->string num)~(number->string num radix)~(number->string num radix precision)" "objects.html#./objects:s148") (number? "(number? obj)" "objects.html#./objects:s17") (numerator "(numerator rat)" "objects.html#./objects:s118") (odd? "(odd? int)" "objects.html#./objects:s96") (opaque "opaque" "records.html#./records:s16") (open-bytevector-input-port "(open-bytevector-input-port bytevector)~(open-bytevector-input-port bytevector ?transcoder)" "io.html#./io:s34") (open-bytevector-output-port "(open-bytevector-output-port)~(open-bytevector-output-port ?transcoder)" "io.html#./io:s36") (open-file-input-port "(open-file-input-port path)~(open-file-input-port path options)~(open-file-input-port path options b-mode)~(open-file-input-port path options b-mode ?transcoder)" "io.html#./io:s29") (open-file-input/output-port "(open-file-input/output-port path)~(open-file-input/output-port path options)~(open-file-input/output-port path options b-mode)~(open-file-input/output-port path options b-mode ?transcoder)" "io.html#./io:s31") (open-file-output-port "(open-file-output-port path)~(open-file-output-port path options)~(open-file-output-port path options b-mode)~(open-file-output-port path options b-mode ?transcoder)" "io.html#./io:s30") (open-input-file "(open-input-file path)" "io.html#./io:s75") (open-output-file "(open-output-file path)" "io.html#./io:s76") (open-string-input-port "(open-string-input-port string)" "io.html#./io:s35") (open-string-output-port "(open-string-output-port)" "io.html#./io:s37") (or "(or expr ...)" "control.html#./control:s12") (output-port-buffer-mode "(output-port-buffer-mode port)" "io.html#./io:s52") (output-port? "(output-port? obj)" "io.html#./io:s44") (pair? "(pair? obj)" "objects.html#./objects:s16") (parent "parent" "records.html#./records:s16") (parent-rtd "parent-rtd" "records.html#./records:s16") (partition "(partition procedure list)" "objects.html#./objects:s56") (peek-char "(peek-char)~(peek-char textual-input-port)" "io.html#./io:s83") (port-eof? "(port-eof? input-port)" "io.html#./io:s68") (port-has-port-position? "(port-has-port-position? port)" "io.html#./io:s49") (port-has-set-port-position!? "(port-has-set-port-position!? port)" "io.html#./io:s50") (port-position "(port-position port)" "io.html#./io:s49") (port-transcoder "(port-transcoder port)" "io.html#./io:s48") (port? "(port? obj)" "io.html#./io:s43") (positive? "(positive? real)" "objects.html#./objects:s94") (expr0 "(expr0 expr1 ...)" "control.html#./control:s1") (procedure? "(procedure? obj)" "objects.html#./objects:s23") (protocol "protocol" "records.html#./records:s16") (put-bytevector "(put-bytevector binary-output-port bytevector)~(put-bytevector binary-output-port bytevector start)~(put-bytevector binary-output-port bytevector start n)" "io.html#./io:s70") (put-char "(put-char textual-output-port char)" "io.html#./io:s71") (put-datum "(put-datum textual-output-port obj)" "io.html#./io:s73") (put-string "(put-string textual-output-port string)~(put-string textual-output-port string start)~(put-string textual-output-port string start n)" "io.html#./io:s72") (put-u8 "(put-u8 binary-output-port octet)" "io.html#./io:s69") (quasiquote "(quasiquote obj ...)" "objects.html#./objects:s5") (quasisyntax "(quasisyntax template ...)" "syntax.html#./syntax:s40") (quote "(quote obj)" "objects.html#./objects:s2") (quotient "(quotient int1 int2)" "objects.html#./objects:s98") (raise "(raise obj)" "exceptions.html#./exceptions:s3") (raise-continuable "(raise-continuable obj)" "exceptions.html#./exceptions:s3") (rational-valued? "(rational-valued? obj)" "objects.html#./objects:s18") (rational? "(rational? obj)" "objects.html#./objects:s17") (rationalize "(rationalize real1 real2)" "objects.html#./objects:s117") (read "(read)~(read textual-input-port)" "io.html#./io:s81") (read-char "(read-char)~(read-char textual-input-port)" "io.html#./io:s82") (real->flonum "(real->flonum real)" "objects.html#./objects:s198") (real-part "(real-part num)" "objects.html#./objects:s120") (real-valued? "(real-valued? obj)" "objects.html#./objects:s18") (real? "(real? obj)" "objects.html#./objects:s17") (record-accessor "(record-accessor rtd idx)" "records.html#./records:s31") (record-constructor "(record-constructor rcd)" "records.html#./records:s29") (record-constructor-descriptor "(record-constructor-descriptor record-name)" "records.html#./records:s28") (record-field-mutable? "(record-field-mutable? rtd idx)" "records.html#./records:s39") (record-mutator "(record-mutator rtd idx)" "records.html#./records:s32") (record-predicate "(record-predicate rtd)" "records.html#./records:s30") (record-rtd "(record-rtd record)" "records.html#./records:s41") (record-type-descriptor "(record-type-descriptor record-name)" "records.html#./records:s28") (record-type-descriptor? "(record-type-descriptor? obj)" "records.html#./records:s23") (record-type-field-names "(record-type-field-names rtd)" "records.html#./records:s38") (record-type-generative? "(record-type-generative? rtd)" "records.html#./records:s37") (record-type-name "(record-type-name rtd)" "records.html#./records:s34") (record-type-opaque? "(record-type-opaque? rtd)" "records.html#./records:s37") (record-type-parent "(record-type-parent rtd)" "records.html#./records:s35") (record-type-sealed? "(record-type-sealed? rtd)" "records.html#./records:s37") (record-type-uid "(record-type-uid rtd)" "records.html#./records:s36") (record? "(record? obj)" "records.html#./records:s40") (remainder "(remainder int1 int2)" "objects.html#./objects:s98") (remove "(remove obj list)" "objects.html#./objects:s53") (remp "(remp procedure list)" "objects.html#./objects:s54") (remq "(remq obj list)" "objects.html#./objects:s53") (remv "(remv obj list)" "objects.html#./objects:s53") (reverse "(reverse list)" "objects.html#./objects:s50") (round "(round real)" "objects.html#./objects:s104") (scheme-report-environment "(scheme-report-environment version)" "control.html#./control:s82") (sealed "sealed" "records.html#./records:s16") (serious-condition? "(serious-condition? obj)" "exceptions.html#./exceptions:s19") (set! "(set! var expr)" "binding.html#./binding:s28") (set-car! "(set-car! pair obj)" "objects.html#./objects:s40") (set-cdr! "(set-cdr! pair obj)" "objects.html#./objects:s41") (set-port-position! "(set-port-position! port pos)" "io.html#./io:s50") (simple-conditions "(simple-conditions condition)" "exceptions.html#./exceptions:s16") (sin "(sin num)" "objects.html#./objects:s131") (sint-list->bytevector "(sint-list->bytevector list eness size)" "objects.html#./objects:s261") (sqrt "(sqrt num)" "objects.html#./objects:s127") (standard-error-port "(standard-error-port)" "io.html#./io:s33") (standard-input-port "(standard-input-port)" "io.html#./io:s33") (standard-output-port "(standard-output-port)" "io.html#./io:s33") (string "(string char ...)" "objects.html#./objects:s217") (string->bytevector "(string->bytevector string transcoder)" "io.html#./io:s92") (string->list "(string->list string)" "objects.html#./objects:s228") (string->number "(string->number string)~(string->number string radix)" "objects.html#./objects:s147") (string->symbol "(string->symbol string)" "objects.html#./objects:s269") (string->utf16 "(string->utf16 string)~(string->utf16 string endianness)" "io.html#./io:s94") (string->utf32 "(string->utf32 string)~(string->utf32 string endianness)" "io.html#./io:s94") (string->utf8 "(string->utf8 string)" "io.html#./io:s93") (string-append "(string-append string ...)" "objects.html#./objects:s223") (string-ci-hash "(string-ci-hash string)" "objects.html#./objects:s279") (string-ci<=? "(string-ci<=? string1 string2 string3 ...)" "objects.html#./objects:s216") (string-ci<? "(string-ci<? string1 string2 string3 ...)" "objects.html#./objects:s216") (string-ci=? "(string-ci=? string1 string2 string3 ...)" "objects.html#./objects:s216") (string-ci>=? "(string-ci>=? string1 string2 string3 ...)" "objects.html#./objects:s216") (string-ci>? "(string-ci>? string1 string2 string3 ...)" "objects.html#./objects:s216") (string-copy "(string-copy string)" "objects.html#./objects:s222") (string-downcase "(string-downcase string)" "objects.html#./objects:s226") (string-fill! "(string-fill! string char)" "objects.html#./objects:s225") (string-foldcase "(string-foldcase string)" "objects.html#./objects:s226") (string-for-each "(string-for-each procedure string1 string2 ...)" "control.html#./control:s50") (string-hash "(string-hash string)" "objects.html#./objects:s279") (string-length "(string-length string)" "objects.html#./objects:s219") (string-normalize-nfc "(string-normalize-nfc string)" "objects.html#./objects:s227") (string-normalize-nfd "(string-normalize-nfd string)" "objects.html#./objects:s227") (string-normalize-nfkc "(string-normalize-nfkc string)" "objects.html#./objects:s227") (string-normalize-nfkd "(string-normalize-nfkd string)" "objects.html#./objects:s227") (string-ref "(string-ref string n)" "objects.html#./objects:s220") (string-set! "(string-set! string n char)" "objects.html#./objects:s221") (string-titlecase "(string-titlecase string)" "objects.html#./objects:s226") (string-upcase "(string-upcase string)" "objects.html#./objects:s226") (string<=? "(string<=? string1 string2 string3 ...)" "objects.html#./objects:s215") (string<? "(string<? string1 string2 string3 ...)" "objects.html#./objects:s215") (string=? "(string=? string1 string2 string3 ...)" "objects.html#./objects:s215") (string>=? "(string>=? string1 string2 string3 ...)" "objects.html#./objects:s215") (string>? "(string>? string1 string2 string3 ...)" "objects.html#./objects:s215") (string? "(string? obj)" "objects.html#./objects:s20") (substring "(substring string start end)" "objects.html#./objects:s224") (symbol->string "(symbol->string symbol)" "objects.html#./objects:s270") (symbol-hash "(symbol-hash symbol)" "objects.html#./objects:s279") (symbol=? "(symbol=? symbol1 symbol2)" "objects.html#./objects:s268") (symbol? "(symbol? obj)" "objects.html#./objects:s22") (syntax "(syntax template)" "syntax.html#./syntax:s33") (syntax->datum "(syntax->datum obj)" "syntax.html#./syntax:s44") (syntax-case "(syntax-case expr (literal ...) clause ...)" "syntax.html#./syntax:s30") (syntax-rules "(syntax-rules (literal ...) clause ...)" "syntax.html#./syntax:s14") (syntax-violation "(syntax-violation who msg form)~(syntax-violation who msg form subform)" "exceptions.html#./exceptions:s6") (syntax-violation-form "(syntax-violation-form condition)" "exceptions.html#./exceptions:s30") (syntax-violation-subform "(syntax-violation-subform condition)" "exceptions.html#./exceptions:s30") (syntax-violation? "(syntax-violation? obj)" "exceptions.html#./exceptions:s30") (tan "(tan num)" "objects.html#./objects:s131") (textual-port? "(textual-port? obj)" "io.html#./io:s45") (transcoded-port "(transcoded-port binary-port transcoder)" "io.html#./io:s47") (transcoder-codec "(transcoder-codec transcoder)" "io.html#./io:s20") (transcoder-eol-style "(transcoder-eol-style transcoder)" "io.html#./io:s20") (transcoder-error-handling-mode "(transcoder-error-handling-mode transcoder)" "io.html#./io:s20") (truncate "(truncate real)" "objects.html#./objects:s101") (u8-list->bytevector "(u8-list->bytevector list)" "objects.html#./objects:s253") (uint-list->bytevector "(uint-list->bytevector list eness size)" "objects.html#./objects:s261") (undefined-violation? "(undefined-violation? obj)" "exceptions.html#./exceptions:s31") (unless "(unless test-expr expr1 expr2 ...)" "control.html#./control:s17") (unquote "(unquote obj ...)" "objects.html#./objects:s5") (unquote-splicing "(unquote-splicing obj ...)" "objects.html#./objects:s5") (unsyntax "(unsyntax template ...)" "syntax.html#./syntax:s40") (unsyntax-splicing "(unsyntax-splicing template ...)" "syntax.html#./syntax:s40") (utf-16-codec "(utf-16-codec)" "io.html#./io:s22") (utf-8-codec "(utf-8-codec)" "io.html#./io:s22") (utf16->string "(utf16->string bytevector endianness)~(utf16->string bytevector endianness endianness-mandatory?)" "io.html#./io:s96") (utf32->string "(utf32->string bytevector endianness)~(utf32->string bytevector endianness endianness-mandatory?)" "io.html#./io:s96") (utf8->string "(utf8->string bytevector)" "io.html#./io:s95") (values "(values obj ...)" "control.html#./control:s70") (variable "variable" "binding.html#./binding:s2") (vector "(vector obj ...)" "objects.html#./objects:s231") (vector->list "(vector->list vector)" "objects.html#./objects:s237") (vector-fill! "(vector-fill! vector obj)" "objects.html#./objects:s236") (vector-for-each "(vector-for-each procedure vector1 vector2 ...)" "control.html#./control:s47") (vector-length "(vector-length vector)" "objects.html#./objects:s233") (vector-map "(vector-map procedure vector1 vector1 ...)" "control.html#./control:s44") (vector-ref "(vector-ref vector n)" "objects.html#./objects:s234") (vector-set! "(vector-set! vector n obj)" "objects.html#./objects:s235") (vector-sort "(vector-sort predicate vector)" "objects.html#./objects:s239") (vector-sort! "(vector-sort! predicate vector)" "objects.html#./objects:s239") (vector? "(vector? obj)" "objects.html#./objects:s21") (violation? "(violation? obj)" "exceptions.html#./exceptions:s20") (warning? "(warning? obj)" "exceptions.html#./exceptions:s23") (when "(when test-expr expr1 expr2 ...)" "control.html#./control:s17") (who-condition? "(who-condition? obj)" "exceptions.html#./exceptions:s26") (with-exception-handler "(with-exception-handler procedure thunk)" "exceptions.html#./exceptions:s7") (with-input-from-file "(with-input-from-file path thunk)" "io.html#./io:s79") (with-output-to-file "(with-output-to-file path thunk)" "io.html#./io:s80") (with-syntax "(with-syntax ((pattern expr) ...) body1 body2 ...)" "syntax.html#./syntax:s38") (write "(write obj)~(write obj textual-output-port)" "io.html#./io:s84") (write-char "(write-char char)~(write-char char textual-output-port)" "io.html#./io:s86") (zero? "(zero? num)" "objects.html#./objects:s93")))

  (define csug-alist '(($system "$system" "syntax.html#./syntax:s35") (&continuation "&continuation" "system.html#./system:s6") (&format "&format" "system.html#./system:s4") (&source "&source" "system.html#./system:s5") (< "(< real1 real2 real3 ...)" "numeric.html#./numeric:s67") (<= "(<= real1 real2 real3 ...)" "numeric.html#./numeric:s67") (= "(= num1 num2 num3 ...)" "numeric.html#./numeric:s67") (> "(> real1 real2 real3 ...)" "numeric.html#./numeric:s67") (>= "(>= real1 real2 real3 ...)" "numeric.html#./numeric:s67") (abort "(abort)~(abort obj)" "system.html#./system:s182") (abort-handler "abort-handler" "system.html#./system:s183") (acosh "(acosh num)" "numeric.html#./numeric:s77") (add-duration "(add-duration time timed)" "system.html#./system:s209") (add-duration! "(add-duration! time timed)" "system.html#./system:s209") (add-prefix "add-prefix" "syntax.html#./syntax:s22") (add1 "(add1 num)" "numeric.html#./numeric:s68") (andmap "(andmap procedure list1 list2 ...)" "control.html#./control:s8") (annotation-expression "(annotation-expression annotation)" "syntax.html#./syntax:s51") (annotation-option-set "(annotation-option-set symbol ...)" "syntax.html#./syntax:s68") (annotation-options "(annotation-options annotation)" "syntax.html#./syntax:s54") (annotation-source "(annotation-source annotation)" "syntax.html#./syntax:s52") (annotation-stripped "(annotation-stripped annotation)" "syntax.html#./syntax:s53") (annotation? "(annotation? obj)" "syntax.html#./syntax:s50") (append! "(append! list ...)" "objects.html#./objects:s13") (apropos "(apropos s)~(apropos s env)" "system.html#./system:s37") (apropos-list "(apropos-list s)~(apropos-list s env)" "system.html#./system:s36") (ash "(ash int count)" "numeric.html#./numeric:s52") (asinh "(asinh num)" "numeric.html#./numeric:s77") (assertion-violationf "(assertion-violationf who msg irritant ...)" "system.html#./system:s2") (atanh "(atanh num)" "numeric.html#./numeric:s77") (atom? "(atom? obj)" "objects.html#./objects:s2") (base-exception-handler "base-exception-handler" "system.html#./system:s12") (bignum? "(bignum? obj)" "numeric.html#./numeric:s11") (binary-port-input-buffer "(binary-port-input-buffer binary-input-port)" "io.html#./io:s16") (binary-port-input-count "(binary-port-input-count binary-input-port)" "io.html#./io:s18") (binary-port-input-index "(binary-port-input-index binary-input-port)" "io.html#./io:s16") (binary-port-input-size "(binary-port-input-size binary-input-port)" "io.html#./io:s16") (binary-port-output-buffer "(binary-port-output-buffer output-port)" "io.html#./io:s20") (binary-port-output-count "(binary-port-output-count binary-output-port)" "io.html#./io:s22") (binary-port-output-index "(binary-port-output-index output-port)" "io.html#./io:s20") (binary-port-output-size "(binary-port-output-size output-port)" "io.html#./io:s20") (block-read "(block-read textual-input-port string)~(block-read textual-input-port string count)" "io.html#./io:s69") (block-write "(block-write textual-output-port string)~(block-write textual-output-port string count)" "io.html#./io:s86") (box "(box obj)" "objects.html#./objects:s82") (box-cas! "(box-cas! box old-obj new-obj)" "objects.html#./objects:s85") (box-immutable "(box-immutable obj)" "objects.html#./objects:s87") (box? "(box? obj)" "objects.html#./objects:s81") (break "(break who msg irritant ...)~(break who)~(break)" "system.html#./system:s17") (break-handler "break-handler" "system.html#./system:s19") (bwp-object? "(bwp-object? obj)" "smgmt.html#./smgmt:s28") (bytes-allocated "(bytes-allocated)~(bytes-allocated g)" "system.html#./system:s223") (bytes-deallocated "(bytes-deallocated)" "system.html#./system:s225") (bytevector "(bytevector fill ...)" "objects.html#./objects:s59") (bytevector->immutable-bytevector "(bytevector->immutable-bytevector bytevector)" "objects.html#./objects:s66") (bytevector->s8-list "(bytevector->s8-list bytevector)" "objects.html#./objects:s60") (bytevector-compress "(bytevector-compress bytevector)" "objects.html#./objects:s69") (bytevector-s24-ref "(bytevector-s24-ref bytevector n eness)" "objects.html#./objects:s63") (bytevector-s24-set! "(bytevector-s24-set! bytevector n s24 eness)" "objects.html#./objects:s64") (bytevector-s40-ref "(bytevector-s40-ref bytevector n eness)" "objects.html#./objects:s63") (bytevector-s40-set! "(bytevector-s40-set! bytevector n s40 eness)" "objects.html#./objects:s64") (bytevector-s48-ref "(bytevector-s48-ref bytevector n eness)" "objects.html#./objects:s63") (bytevector-s48-set! "(bytevector-s48-set! bytevector n s48 eness)" "objects.html#./objects:s64") (bytevector-s56-ref "(bytevector-s56-ref bytevector n eness)" "objects.html#./objects:s63") (bytevector-s56-set! "(bytevector-s56-set! bytevector n s56 eness)" "objects.html#./objects:s64") (bytevector-truncate! "(bytevector-truncate! bytevector n)" "objects.html#./objects:s62") (bytevector-u24-ref "(bytevector-u24-ref bytevector n eness)" "objects.html#./objects:s63") (bytevector-u24-set! "(bytevector-u24-set! bytevector n u24 eness)" "objects.html#./objects:s64") (bytevector-u40-ref "(bytevector-u40-ref bytevector n eness)" "objects.html#./objects:s63") (bytevector-u40-set! "(bytevector-u40-set! bytevector n u40 eness)" "objects.html#./objects:s64") (bytevector-u48-ref "(bytevector-u48-ref bytevector n eness)" "objects.html#./objects:s63") (bytevector-u48-set! "(bytevector-u48-set! bytevector n u48 eness)" "objects.html#./objects:s64") (bytevector-u56-ref "(bytevector-u56-ref bytevector n eness)" "objects.html#./objects:s63") (bytevector-u56-set! "(bytevector-u56-set! bytevector n u56 eness)" "objects.html#./objects:s64") (bytevector-uncompress "(bytevector-uncompress bytevector)" "objects.html#./objects:s72") (call-with-input-file "(call-with-input-file path procedure)~(call-with-input-file path procedure options)" "io.html#./io:s58") (call-with-output-file "(call-with-output-file path procedure)~(call-with-output-file path procedure options)" "io.html#./io:s78") (call/1cc "(call/1cc procedure)" "control.html#./control:s9") (case "(case expr0 clause1 clause2 ...)" "control.html#./control:s1") (case-sensitive "case-sensitive" "io.html#./io:s109") (cd "cd" "io.html#./io:s139") (cfl* "(cfl* cflonum ...)" "numeric.html#./numeric:s38") (cfl+ "(cfl+ cflonum ...)" "numeric.html#./numeric:s38") (cfl- "(cfl- cflonum1 cflonum2 ...)" "numeric.html#./numeric:s38") (cfl-conjugate "(cfl-conjugate cflonum)" "numeric.html#./numeric:s39") (cfl-imag-part "(cfl-imag-part cflonum)" "numeric.html#./numeric:s36") (cfl-magnitude-squared "(cfl-magnitude-squared cflonum)" "numeric.html#./numeric:s41") (cfl-real-part "(cfl-real-part cflonum)" "numeric.html#./numeric:s36") (cfl/ "(cfl/ cflonum1 cflonum2 ...)" "numeric.html#./numeric:s38") (cfl= "(cfl= cflonum ...)" "numeric.html#./numeric:s37") (cflonum? "(cflonum? obj)" "numeric.html#./numeric:s13") (char- "(char- char1 char2)" "objects.html#./objects:s16") (char-ci<=? "(char-ci<=? char1 char2 ...)" "objects.html#./objects:s15") (char-ci<? "(char-ci<? char1 char2 ...)" "objects.html#./objects:s15") (char-ci=? "(char-ci=? char1 char2 ...)" "objects.html#./objects:s15") (char-ci>=? "(char-ci>=? char1 char2 ...)" "objects.html#./objects:s15") (char-ci>? "(char-ci>? char1 char2 ...)" "objects.html#./objects:s15") (char-name "(char-name obj)~(char-name name char)" "io.html#./io:s107") (char-ready? "(char-ready?)~(char-ready? textual-input-port)" "io.html#./io:s68") (char<=? "(char<=? char1 char2 ...)" "objects.html#./objects:s15") (char<? "(char<? char1 char2 ...)" "objects.html#./objects:s15") (char=? "(char=? char1 char2 ...)" "objects.html#./objects:s15") (char>=? "(char>=? char1 char2 ...)" "objects.html#./objects:s15") (char>? "(char>? char1 char2 ...)" "objects.html#./objects:s15") (chmod "(chmod path mode)" "io.html#./io:s150") (clear-input-port "(clear-input-port)~(clear-input-port input-port)" "io.html#./io:s36") (clear-output-port "(clear-output-port)~(clear-output-port output-port)" "io.html#./io:s37") (collect "(collect)~(collect cg)~(collect cg max-tg)~(collect cg min-tg max-tg)" "smgmt.html#./smgmt:s9") (collect-generation-radix "collect-generation-radix" "smgmt.html#./smgmt:s15") (collect-maximum-generation "collect-maximum-generation" "smgmt.html#./smgmt:s16") (collect-notify "collect-notify" "smgmt.html#./smgmt:s11") (collect-rendezvous "(collect-rendezvous)" "smgmt.html#./smgmt:s10") (collect-request-handler "collect-request-handler" "smgmt.html#./smgmt:s17") (collect-trip-bytes "collect-trip-bytes" "smgmt.html#./smgmt:s12") (collections "(collections)" "system.html#./system:s229") (command-line "command-line" "system.html#./system:s193") (command-line-arguments "command-line-arguments" "system.html#./system:s195") (commonization-level "commonization-level" "system.html#./system:s122") (compile "(compile obj)~(compile obj env)" "system.html#./system:s43") (compile-file "(compile-file input-filename)~(compile-file input-filename output-filename)" "system.html#./system:s63") (compile-file-message "compile-file-message" "system.html#./system:s119") (compile-imported-libraries "compile-imported-libraries" "libraries.html#./libraries:s26") (compile-interpret-simple "compile-interpret-simple" "system.html#./system:s112") (compile-library "(compile-library input-filename)~(compile-library input-filename output-filename)" "system.html#./system:s68") (compile-library-handler "compile-library-handler" "system.html#./system:s72") (compile-port "(compile-port input-port output-port)~(compile-port input-port output-port sfd)~(compile-port input-port output-port sfd wpo-port)~(compile-port input-port output-port sfd wpo-port covop)" "system.html#./system:s79") (compile-profile "compile-profile" "system.html#./system:s140") (compile-program "(compile-program input-filename)~(compile-program input-filename output-filename)" "system.html#./system:s69") (compile-program-handler "compile-program-handler" "system.html#./system:s74") (compile-script "(compile-script input-filename)~(compile-script input-filename output-filename)" "system.html#./system:s66") (compile-time-value-value "(compile-time-value-value ctv)" "syntax.html#./syntax:s17") (compile-time-value? "(compile-time-value? obj)" "syntax.html#./syntax:s16") (compile-to-file "(compile-to-file obj-list output-file)~(compile-to-file obj-list output-file sfd)" "system.html#./system:s81") (compile-to-port "(compile-to-port obj-list output-port)~(compile-to-port obj-list output-port sfd)~(compile-to-port obj-list output-port sfd wpo-port)~(compile-to-port obj-list output-port sfd wpo-port covop)" "system.html#./system:s80") (compile-whole-library "(compile-whole-library input-filename output-filename)" "system.html#./system:s78") (compile-whole-program "(compile-whole-program input-filename output-filename)~(compile-whole-program input-filename output-filename libs-visible?)" "system.html#./system:s76") (compress-format "compress-format" "io.html#./io:s42") (compress-level "compress-level" "io.html#./io:s43") (compute-composition "(compute-composition object)~(compute-composition object generation)" "debug.html#./debug:s31") (compute-size "(compute-size object)~(compute-size object generation)" "debug.html#./debug:s30") (concatenate-object-files "(concatenate-object-files out-file in-file1 in-file2 ...)" "system.html#./system:s82") (condition-broadcast "(condition-broadcast cond)" "threads.html#./threads:s16") (condition-continuation "(condition-continuation condition)" "system.html#./system:s6") (condition-name "(condition-name condition)" "threads.html#./threads:s17") (condition-signal "(condition-signal cond)" "threads.html#./threads:s15") (condition-wait "(condition-wait cond mutex)~(condition-wait cond mutex timeout)" "threads.html#./threads:s14") (conjugate "(conjugate num)" "numeric.html#./numeric:s74") (console-error-port "console-error-port" "io.html#./io:s73") (console-input-port "console-input-port" "io.html#./io:s55") (console-output-port "console-output-port" "io.html#./io:s71") (constructor "constructor" "objects.html#./objects:s176") (continuation-condition? "(continuation-condition? obj)" "system.html#./system:s6") (copy-environment "(copy-environment env)~(copy-environment env mutable?)~(copy-environment env mutable? syms)" "system.html#./system:s34") (copy-time "(copy-time time)" "system.html#./system:s208") (cosh "(cosh num)" "numeric.html#./numeric:s76") (cost-center-allocation-count "(cost-center-allocation-count cost-center)" "system.html#./system:s245") (cost-center-instruction-count "(cost-center-instruction-count cost-center)" "system.html#./system:s244") (cost-center-time "(cost-center-time cost-center)" "system.html#./system:s246") (cost-center? "(cost-center? obj)" "system.html#./system:s242") (cp0-effort-limit "cp0-effort-limit" "system.html#./system:s120") (cp0-outer-unroll-limit "cp0-outer-unroll-limit" "system.html#./system:s120") (cp0-score-limit "cp0-score-limit" "system.html#./system:s120") (cpu-time "(cpu-time)" "system.html#./system:s221") (create-exception-state "(create-exception-state)~(create-exception-state procedure)" "system.html#./system:s15") (critical-section "(critical-section body1 body2 ...)" "system.html#./system:s27") (current-date "(current-date)~(current-date offset)" "system.html#./system:s210") (current-directory "current-directory" "io.html#./io:s139") (current-error-port "current-error-port" "io.html#./io:s74") (current-eval "current-eval" "system.html#./system:s39") (current-exception-state "current-exception-state" "system.html#./system:s14") (current-expand "current-expand" "system.html#./system:s92") (current-input-port "current-input-port" "io.html#./io:s56") (current-locate-source-object-source "current-locate-source-object-source" "syntax.html#./syntax:s74") (current-make-source-object "current-make-source-object" "syntax.html#./syntax:s62") (current-memory-bytes "(current-memory-bytes)" "system.html#./system:s226") (current-output-port "current-output-port" "io.html#./io:s72") (current-time "(current-time)~(current-time time-type)" "system.html#./system:s202") (current-transcoder "current-transcoder" "io.html#./io:s11") (custom-port-buffer-size "custom-port-buffer-size" "io.html#./io:s54") (date->time-utc "(date->time-utc date)" "system.html#./system:s216") (date-and-time "(date-and-time)~(date-and-time date)" "system.html#./system:s217") (date-day "(date-day date)" "system.html#./system:s213") (date-dst? "(date-dst? date)" "system.html#./system:s215") (date-hour "(date-hour date)" "system.html#./system:s213") (date-minute "(date-minute date)" "system.html#./system:s213") (date-month "(date-month date)" "system.html#./system:s213") (date-nanosecond "(date-nanosecond date)" "system.html#./system:s213") (date-second "(date-second date)" "system.html#./system:s213") (date-week-day "(date-week-day date)" "system.html#./system:s214") (date-year "(date-year date)" "system.html#./system:s213") (date-year-day "(date-year-day date)" "system.html#./system:s214") (date-zone-name "(date-zone-name date)" "system.html#./system:s215") (date-zone-offset "(date-zone-offset date)" "system.html#./system:s213") (date? "(date? obj)" "system.html#./system:s212") (datum "(datum template)" "syntax.html#./syntax:s9") (datum->syntax-object "(datum->syntax-object template-identifier obj)" "syntax.html#./syntax:s10") (debug "(debug)" "debug.html#./debug:s16") (debug-condition "debug-condition" "system.html#./system:s13") (debug-level "debug-level" "system.html#./system:s110") (debug-on-exception "debug-on-exception" "system.html#./system:s10") (decode-float "(decode-float x)" "numeric.html#./numeric:s30") (default-exception-handler "(default-exception-handler obj)" "system.html#./system:s8") (default-library-search-handler "(default-library-search-handler who library directories extensions)" "libraries.html#./libraries:s31") (default-prompt-and-read "(default-prompt-and-read level)" "system.html#./system:s176") (default-record-equal-procedure "default-record-equal-procedure" "objects.html#./objects:s160") (default-record-hash-procedure "default-record-hash-procedure" "objects.html#./objects:s161") (define-ftype "(define-ftype ftype-name ftype)~(define-ftype (ftype-name ftype) ...)" "foreign.html#./foreign:s137") (define-property "(define-property id key expr)" "syntax.html#./syntax:s18") (define-record "(define-record name (fld1 ...) ((fld2 init) ...) (opt ...))~(define-record name parent (fld1 ...) ((fld2 init) ...) (opt ...))" "objects.html#./objects:s172") (define-structure "(define-structure (name id1 ...) ((id2 expr) ...))" "compat.html#./compat:s25") (define-top-level-syntax "(define-top-level-syntax symbol obj)~(define-top-level-syntax symbol obj env)" "binding.html#./binding:s32") (define-top-level-value "(define-top-level-value symbol obj)~(define-top-level-value symbol obj env)" "binding.html#./binding:s24") (define-values "(define-values formals expr)" "binding.html#./binding:s16") (delete-directory "(delete-directory path)~(delete-directory path error?)" "io.html#./io:s148") (delete-file "(delete-file path)~(delete-file path error?)" "io.html#./io:s147") (directory-list "(directory-list path)" "io.html#./io:s140") (directory-separator "(directory-separator)" "io.html#./io:s153") (directory-separator? "(directory-separator? char)" "io.html#./io:s152") (disable-interrupts "(disable-interrupts)" "system.html#./system:s26") (display-condition "(display-condition obj)~(display-condition obj textual-output-port)" "system.html#./system:s7") (display-statistics "(display-statistics)~(display-statistics textual-output-port)" "system.html#./system:s220") (display-string "(display-string string)~(display-string string textual-output-port)" "io.html#./io:s85") (drop-prefix "drop-prefix" "syntax.html#./syntax:s22") (dynamic-wind "(dynamic-wind in body out)~(dynamic-wind critical? in body out)" "control.html#./control:s11") (ee-auto-indent "ee-auto-indent" "expeditor.html#./expeditor:s1") (ee-auto-paren-balance "ee-auto-paren-balance" "expeditor.html#./expeditor:s3") (ee-bind-key "(ee-bind-key key procedure)" "expeditor.html#./expeditor:s10") (ee-common-identifiers "ee-common-identifiers" "expeditor.html#./expeditor:s9") (ee-compose "(ee-compose ecmd ...)" "expeditor.html#./expeditor:s78") (ee-default-repeat "ee-default-repeat" "expeditor.html#./expeditor:s6") (ee-flash-parens "ee-flash-parens" "expeditor.html#./expeditor:s4") (ee-history-limit "ee-history-limit" "expeditor.html#./expeditor:s8") (ee-noisy "ee-noisy" "expeditor.html#./expeditor:s7") (ee-paren-flash-delay "ee-paren-flash-delay" "expeditor.html#./expeditor:s5") (ee-standard-indent "ee-standard-indent" "expeditor.html#./expeditor:s2") (ee-string-macro "(ee-string-macro string)" "expeditor.html#./expeditor:s77") (enable-cross-library-optimization "enable-cross-library-optimization" "system.html#./system:s116") (enable-interrupts "(enable-interrupts)" "system.html#./system:s26") (enable-object-counts "enable-object-counts" "system.html#./system:s237") (engine-block "(engine-block)" "control.html#./control:s27") (engine-return "(engine-return obj ...)" "control.html#./control:s28") (enum-set? "(enum-set? obj)" "objects.html#./objects:s0") (enumerate "(enumerate ls)" "objects.html#./objects:s9") (environment-mutable? "(environment-mutable? env)" "system.html#./system:s30") (environment-symbols "(environment-symbols env)" "system.html#./system:s35") (environment? "(environment? obj)" "system.html#./system:s29") (ephemeron-cons "(ephemeron-cons obj1 obj2)" "smgmt.html#./smgmt:s26") (ephemeron-pair? "(ephemeron-pair? obj)" "smgmt.html#./smgmt:s27") (eq-hashtable-cell "(eq-hashtable-cell hashtable key default)" "objects.html#./objects:s131") (eq-hashtable-contains? "(eq-hashtable-contains? hashtable key)" "objects.html#./objects:s129") (eq-hashtable-delete! "(eq-hashtable-delete! hashtable key)" "objects.html#./objects:s132") (eq-hashtable-ephemeron? "(eq-hashtable-ephemeron? hashtable)" "objects.html#./objects:s126") (eq-hashtable-ref "(eq-hashtable-ref hashtable key default)" "objects.html#./objects:s128") (eq-hashtable-set! "(eq-hashtable-set! hashtable key value)" "objects.html#./objects:s127") (eq-hashtable-update! "(eq-hashtable-update! hashtable key procedure default)" "objects.html#./objects:s130") (eq-hashtable-weak? "(eq-hashtable-weak? hashtable)" "objects.html#./objects:s125") (eq-hashtable? "(eq-hashtable? obj)" "objects.html#./objects:s124") (errorf "(errorf who msg irritant ...)" "system.html#./system:s2") (eval "(eval obj)~(eval obj env)" "system.html#./system:s38") (eval-syntax-expanders-when "eval-syntax-expanders-when" "system.html#./system:s101") (eval-when "(eval-when situations form1 form2 ...)" "system.html#./system:s98") (except "except" "syntax.html#./syntax:s22") (exclusive-cond "(exclusive-cond clause1 clause2 ...)" "control.html#./control:s0") (exit "(exit obj ...)" "system.html#./system:s180") (exit-handler "exit-handler" "system.html#./system:s181") (expand "(expand obj)~(expand obj env)" "system.html#./system:s90") (expand-output "expand-output" "system.html#./system:s124") (expand/optimize "(expand/optimize obj)~(expand/optimize obj env)" "system.html#./system:s96") (expand/optimize-output "expand/optimize-output" "system.html#./system:s124") (export "(export export-spec ...)" "libraries.html#./libraries:s17") (expression-editor "expression-editor" "expeditor.html#./expeditor:s0") (expt-mod "(expt-mod int1 int2 int3)" "numeric.html#./numeric:s69") (extend-syntax "(extend-syntax (name key ...) (pat fender template) ...)" "compat.html#./compat:s8") (fasl-compressed "fasl-compressed" "io.html#./io:s135") (fasl-file "(fasl-file ifn ofn)" "io.html#./io:s138") (fasl-read "(fasl-read binary-input-port)~(fasl-read binary-input-port situation)" "io.html#./io:s134") (fasl-strip-options "(fasl-strip-options symbol ...)" "system.html#./system:s88") (fasl-write "(fasl-write obj binary-output-port)" "io.html#./io:s133") (file-access-time "(file-access-time path/port)~(file-access-time path/port follow?)" "io.html#./io:s145") (file-buffer-size "file-buffer-size" "io.html#./io:s51") (file-change-time "(file-change-time path/port)~(file-change-time path/port follow?)" "io.html#./io:s145") (file-directory? "(file-directory? path)~(file-directory? path follow?)" "io.html#./io:s143") (file-exists? "(file-exists? path)~(file-exists? path follow?)" "io.html#./io:s141") (file-length "(file-length port)" "io.html#./io:s31") (file-modification-time "(file-modification-time path/port)~(file-modification-time path/port follow?)" "io.html#./io:s145") (file-port? "(file-port? port)" "io.html#./io:s52") (file-position "(file-position port)~(file-position port pos)" "io.html#./io:s35") (file-regular? "(file-regular? path)~(file-regular? path follow?)" "io.html#./io:s142") (file-symbolic-link? "(file-symbolic-link? path)" "io.html#./io:s144") (fl-make-rectangular "(fl-make-rectangular flonum1 flonum2)" "numeric.html#./numeric:s35") (fl< "(fl< flonum1 flonum2 ...)" "numeric.html#./numeric:s28") (fl<= "(fl<= flonum1 flonum2 ...)" "numeric.html#./numeric:s28") (fl= "(fl= flonum1 flonum2 ...)" "numeric.html#./numeric:s28") (fl> "(fl> flonum1 flonum2 ...)" "numeric.html#./numeric:s28") (fl>= "(fl>= flonum1 flonum2 ...)" "numeric.html#./numeric:s28") (fllp "(fllp flonum)" "numeric.html#./numeric:s31") (flnonnegative? "(flnonnegative? fl)" "numeric.html#./numeric:s29") (flnonpositive? "(flnonpositive? fl)" "numeric.html#./numeric:s29") (flonum->fixnum "(flonum->fixnum flonum)" "numeric.html#./numeric:s26") (fluid-let "(fluid-let ((var expr) ...) body1 body2 ...)" "binding.html#./binding:s19") (fluid-let-syntax "(fluid-let-syntax ((keyword expr) ...) form1 form2 ...)" "syntax.html#./syntax:s0") (flush-output-port "(flush-output-port)~(flush-output-port output-port)" "io.html#./io:s38") (foreign-address-name "(foreign-address-name address)" "foreign.html#./foreign:s159") (foreign-alloc "(foreign-alloc n)" "foreign.html#./foreign:s132") (foreign-callable "(foreign-callable conv ... proc-exp (param-type ...) res-type)" "foreign.html#./foreign:s127") (foreign-callable-code-object "(foreign-callable-code-object address)" "foreign.html#./foreign:s131") (foreign-callable-entry-point "(foreign-callable-entry-point code)" "foreign.html#./foreign:s130") (foreign-entry "(foreign-entry entry-name)" "foreign.html#./foreign:s158") (foreign-entry? "(foreign-entry? entry-name)" "foreign.html#./foreign:s157") (foreign-free "(foreign-free address)" "foreign.html#./foreign:s133") (foreign-procedure "(foreign-procedure conv ... entry-exp (param-type ...) res-type)" "foreign.html#./foreign:s10") (foreign-ref "(foreign-ref type address offset)" "foreign.html#./foreign:s134") (foreign-set! "(foreign-set! type address offset value)" "foreign.html#./foreign:s135") (foreign-sizeof "(foreign-sizeof type)" "foreign.html#./foreign:s136") (fork-thread "(fork-thread thunk)" "threads.html#./threads:s2") (format "(format format-string obj ...)~(format #f format-string obj ...)~(format #t format-string obj ...)~(format textual-output-port format-string obj ...)" "io.html#./io:s104") (format-condition? "(format-condition? obj)" "system.html#./system:s4") (fprintf "(fprintf textual-output-port format-string obj ...)" "io.html#./io:s106") (fresh-line "(fresh-line)~(fresh-line textual-output-port)" "io.html#./io:s88") (ftype-&ref "(ftype-&ref ftype-name (a ...) fptr-expr)~(ftype-&ref ftype-name (a ...) fptr-expr index)" "foreign.html#./foreign:s151") (ftype-guardian "(ftype-guardian ftype-name)" "threads.html#./threads:s25") (ftype-init-lock! "(ftype-init-lock! ftype-name (a ...) fptr-expr)~(ftype-init-lock! ftype-name (a ...) fptr-expr index)" "threads.html#./threads:s19") (ftype-lock! "(ftype-lock! ftype-name (a ...) fptr-expr)~(ftype-lock! ftype-name (a ...) fptr-expr index)" "threads.html#./threads:s19") (ftype-locked-decr! "(ftype-locked-decr! ftype-name (a ...) fptr-expr)~(ftype-locked-decr! ftype-name (a ...) fptr-expr index)" "threads.html#./threads:s20") (ftype-locked-incr! "(ftype-locked-incr! ftype-name (a ...) fptr-expr)~(ftype-locked-incr! ftype-name (a ...) fptr-expr index)" "threads.html#./threads:s20") (ftype-pointer->sexpr "(ftype-pointer->sexpr fptr)" "foreign.html#./foreign:s156") (ftype-pointer-address "(ftype-pointer-address fptr)" "foreign.html#./foreign:s148") (ftype-pointer-ftype "(ftype-pointer-ftype fptr)" "foreign.html#./foreign:s155") (ftype-pointer-null? "(ftype-pointer-null? fptr)" "foreign.html#./foreign:s150") (ftype-pointer=? "(ftype-pointer=? fptr1 fptr2)" "foreign.html#./foreign:s149") (ftype-pointer? "(ftype-pointer? obj)~(ftype-pointer? ftype-name obj)" "foreign.html#./foreign:s147") (ftype-ref "(ftype-ref ftype-name (a ...) fptr-expr)~(ftype-ref ftype-name (a ...) fptr-expr index)" "foreign.html#./foreign:s152") (ftype-set! "(ftype-set! ftype-name (a ...) fptr-expr val-expr)~(ftype-set! ftype-name (a ...) fptr-expr index val-expr)" "foreign.html#./foreign:s152") (ftype-sizeof "(ftype-sizeof ftype-name)" "foreign.html#./foreign:s142") (ftype-spin-lock! "(ftype-spin-lock! ftype-name (a ...) fptr-expr)~(ftype-spin-lock! ftype-name (a ...) fptr-expr index)" "threads.html#./threads:s19") (ftype-unlock! "(ftype-unlock! ftype-name (a ...) fptr-expr)~(ftype-unlock! ftype-name (a ...) fptr-expr index)" "threads.html#./threads:s19") (fx* "(fx* fixnum ...)" "numeric.html#./numeric:s19") (fx+ "(fx+ fixnum ...)" "numeric.html#./numeric:s17") (fx- "(fx- fixnum1 fixnum2 ...)" "numeric.html#./numeric:s18") (fx/ "(fx/ fixnum1 fixnum2 ...)" "numeric.html#./numeric:s20") (fx1+ "(fx1+ fixnum)" "numeric.html#./numeric:s21") (fx1- "(fx1- fixnum)" "numeric.html#./numeric:s21") (fx< "(fx< fixnum1 fixnum2 ...)" "numeric.html#./numeric:s15") (fx<= "(fx<= fixnum1 fixnum2 ...)" "numeric.html#./numeric:s15") (fx= "(fx= fixnum1 fixnum2 ...)" "numeric.html#./numeric:s15") (fx> "(fx> fixnum1 fixnum2 ...)" "numeric.html#./numeric:s15") (fx>= "(fx>= fixnum1 fixnum2 ...)" "numeric.html#./numeric:s15") (fxabs "(fxabs fixnum)" "numeric.html#./numeric:s25") (fxlogand "(fxlogand fixnum ...)" "numeric.html#./numeric:s53") (fxlogbit0 "(fxlogbit0 index fixnum)" "numeric.html#./numeric:s59") (fxlogbit1 "(fxlogbit1 index fixnum)" "numeric.html#./numeric:s60") (fxlogbit? "(fxlogbit? index fixnum)" "numeric.html#./numeric:s57") (fxlogior "(fxlogior fixnum ...)" "numeric.html#./numeric:s54") (fxlognot "(fxlognot fixnum)" "numeric.html#./numeric:s56") (fxlogor "(fxlogor fixnum ...)" "numeric.html#./numeric:s54") (fxlogtest "(fxlogtest fixnum1 fixnum2)" "numeric.html#./numeric:s58") (fxlogxor "(fxlogxor fixnum ...)" "numeric.html#./numeric:s55") (fxmodulo "(fxmodulo fixnum1 fixnum2)" "numeric.html#./numeric:s24") (fxnonnegative? "(fxnonnegative? fixnum)" "numeric.html#./numeric:s16") (fxnonpositive? "(fxnonpositive? fixnum)" "numeric.html#./numeric:s16") (fxquotient "(fxquotient fixnum1 fixnum2 ...)" "numeric.html#./numeric:s22") (fxremainder "(fxremainder fixnum1 fixnum2)" "numeric.html#./numeric:s23") (fxsll "(fxsll fixnum count)" "numeric.html#./numeric:s61") (fxsra "(fxsra fixnum count)" "numeric.html#./numeric:s63") (fxsrl "(fxsrl fixnum count)" "numeric.html#./numeric:s62") (fxvector "(fxvector fixnum ...)" "objects.html#./objects:s43") (fxvector->immutable-fxvector "(fxvector->immutable-fxvector fxvector)" "objects.html#./objects:s53") (fxvector->list "(fxvector->list fxvector)" "objects.html#./objects:s49") (fxvector-copy "(fxvector-copy fxvector)" "objects.html#./objects:s51") (fxvector-fill! "(fxvector-fill! fxvector fixnum)" "objects.html#./objects:s48") (fxvector-length "(fxvector-length fxvector)" "objects.html#./objects:s45") (fxvector-ref "(fxvector-ref fxvector n)" "objects.html#./objects:s46") (fxvector-set! "(fxvector-set! fxvector n fixnum)" "objects.html#./objects:s47") (fxvector? "(fxvector? obj)" "objects.html#./objects:s42") (generate-allocation-counts "generate-allocation-counts" "system.html#./system:s239") (generate-covin-files "generate-covin-files" "system.html#./system:s142") (generate-inspector-information "generate-inspector-information" "system.html#./system:s114") (generate-instruction-counts "generate-instruction-counts" "system.html#./system:s240") (generate-interrupt-trap "generate-interrupt-trap" "system.html#./system:s111") (generate-procedure-source-information "generate-procedure-source-information" "system.html#./system:s115") (generate-profile-forms "(generate-profile-forms)" "system.html#./system:s145") (generate-wpo-files "generate-wpo-files" "system.html#./system:s117") (gensym "(gensym)~(gensym pretty-name)~(gensym pretty-name unique-name)" "objects.html#./objects:s92") (gensym->unique-string "(gensym->unique-string gensym)" "objects.html#./objects:s102") (gensym-count "gensym-count" "objects.html#./objects:s100") (gensym-prefix "gensym-prefix" "objects.html#./objects:s100") (gensym? "(gensym? obj)" "objects.html#./objects:s103") (get-bytevector-some! "(get-bytevector-some! binary-input-port bytevector start n)" "io.html#./io:s64") (get-datum/annotations "(get-datum/annotations textual-input-port sfd bfp)" "syntax.html#./syntax:s70") (get-hash-table "(get-hash-table ht k d)" "compat.html#./compat:s3") (get-mode "(get-mode path)~(get-mode path follow?)" "io.html#./io:s151") (get-output-string "(get-output-string string-output-port)" "io.html#./io:s49") (get-process-id "(get-process-id)" "system.html#./system:s259") (get-registry "(get-registry key)" "system.html#./system:s262") (get-source-table! "(get-source-table! textual-input-port source-table)~(get-source-table! textual-input-port source-table combine)" "syntax.html#./syntax:s90") (get-string-some "(get-string-some textual-input-port)" "io.html#./io:s62") (get-string-some! "(get-string-some! textual-input-port string start n)" "io.html#./io:s63") (get-thread-id "(get-thread-id)" "threads.html#./threads:s4") (getenv "(getenv key)" "system.html#./system:s260") (getprop "(getprop symbol key)~(getprop symbol key default)" "objects.html#./objects:s106") (guardian? "(guardian? obj)" "smgmt.html#./smgmt:s31") (hash-table-for-each "(hash-table-for-each ht p)" "compat.html#./compat:s6") (hash-table-map "(hash-table-map ht p)" "compat.html#./compat:s5") (hash-table? "(hash-table? obj)" "compat.html#./compat:s1") (hashtable-cell "(hashtable-cell hashtable key default)" "objects.html#./objects:s115") (hashtable-cells "(hashtable-cells hashtable)~(hashtable-cells hashtable size)" "objects.html#./objects:s119") (hashtable-entries "(hashtable-entries hashtable)~(hashtable-entries hashtable size)" "objects.html#./objects:s118") (hashtable-ephemeron? "(hashtable-ephemeron? obj)" "objects.html#./objects:s123") (hashtable-keys "(hashtable-keys hashtable)~(hashtable-keys hashtable size)" "objects.html#./objects:s116") (hashtable-values "(hashtable-values hashtable)~(hashtable-values hashtable size)" "objects.html#./objects:s117") (hashtable-weak? "(hashtable-weak? obj)" "objects.html#./objects:s122") (heap-reserve-ratio "heap-reserve-ratio" "smgmt.html#./smgmt:s19") (iconv-codec "(iconv-codec code-page)" "io.html#./io:s10") (ieee "ieee" "syntax.html#./syntax:s33") (ieee-environment "(ieee-environment)" "system.html#./system:s32") (immutable-box? "(immutable-box? obj)" "objects.html#./objects:s86") (immutable-bytevector? "(immutable-bytevector? obj)" "objects.html#./objects:s65") (immutable-fxvector? "(immutable-fxvector? obj)" "objects.html#./objects:s52") (immutable-string? "(immutable-string? obj)" "objects.html#./objects:s24") (immutable-vector? "(immutable-vector? obj)" "objects.html#./objects:s34") (implicit-exports "(implicit-exports #t)~(implicit-exports #f)" "libraries.html#./libraries:s19") (import "(import import-spec ...)" "libraries.html#./libraries:s16") (import-notify "import-notify" "libraries.html#./libraries:s29") (import-only "(import-only import-spec ...)" "libraries.html#./libraries:s16") (include "(include path)" "syntax.html#./syntax:s12") (indirect-export "(indirect-export id indirect-id ...)" "libraries.html#./libraries:s18") (initial-bytes-allocated "(initial-bytes-allocated)" "system.html#./system:s224") (input-port-ready? "(input-port-ready? input-port)" "io.html#./io:s67") (inspect "(inspect obj)" "debug.html#./debug:s22") (inspect/object "(inspect/object object)" "debug.html#./debug:s25") (integer-length "(integer-length n)" "numeric.html#./numeric:s71") (interaction-environment "interaction-environment" "system.html#./system:s33") (interactive? "(interactive?)" "system.html#./system:s258") (internal-defines-as-letrec* "internal-defines-as-letrec*" "binding.html#./binding:s15") (interpret "(interpret obj)~(interpret obj env)" "system.html#./system:s44") (invoke-library "(invoke-library libref)" "libraries.html#./libraries:s20") (iota "(iota n)" "objects.html#./objects:s8") (isqrt "(isqrt n)" "numeric.html#./numeric:s70") (keyboard-interrupt-handler "keyboard-interrupt-handler" "system.html#./system:s20") (last-pair "(last-pair list)" "objects.html#./objects:s4") (library "(library name exports imports library-body)" "libraries.html#./libraries:s13") (library-directories "library-directories" "libraries.html#./libraries:s23") (library-exports "(library-exports libref)" "libraries.html#./libraries:s33") (library-extensions "library-extensions" "libraries.html#./libraries:s23") (library-list "(library-list)" "libraries.html#./libraries:s32") (library-object-filename "(library-object-filename libref)" "libraries.html#./libraries:s33") (library-requirements "(library-requirements libref)~(library-requirements libref options)" "libraries.html#./libraries:s33") (library-requirements-options "(library-requirements-options symbol ...)" "libraries.html#./libraries:s34") (library-search-handler "library-search-handler" "libraries.html#./libraries:s30") (library-version "(library-version libref)" "libraries.html#./libraries:s33") (list* "(list* obj ... final-obj)" "objects.html#./objects:s6") (list->fxvector "(list->fxvector list)" "objects.html#./objects:s50") (list-copy "(list-copy list)" "objects.html#./objects:s5") (list-head "(list-head list n)" "objects.html#./objects:s3") (literal-identifier=? "(literal-identifier=? identifier1 identifier2)" "syntax.html#./syntax:s14") (load "(load path)~(load path eval-proc)" "system.html#./system:s45") (load-compiled-from-port "(load-compiled-from-port input-port)" "system.html#./system:s56") (load-library "(load-library path)~(load-library path eval-proc)" "system.html#./system:s47") (load-program "(load-program path)~(load-program path eval-proc)" "system.html#./system:s48") (load-shared-object "(load-shared-object path)" "foreign.html#./foreign:s160") (locate-source "(locate-source sfd pos)~(locate-source sfd pos use-cache?)" "syntax.html#./syntax:s72") (locate-source-object-source "(locate-source-object-source source-object get-start? use-cache?)" "syntax.html#./syntax:s73") (lock-object "(lock-object obj)" "smgmt.html#./smgmt:s36") (locked-object? "(locked-object? obj)" "smgmt.html#./smgmt:s39") (logand "(logand int ...)" "numeric.html#./numeric:s44") (logbit0 "(logbit0 index int)" "numeric.html#./numeric:s50") (logbit1 "(logbit1 index int)" "numeric.html#./numeric:s51") (logbit? "(logbit? index int)" "numeric.html#./numeric:s48") (logior "(logior int ...)" "numeric.html#./numeric:s45") (lognot "(lognot int)" "numeric.html#./numeric:s47") (logor "(logor int ...)" "numeric.html#./numeric:s45") (logtest "(logtest int1 int2)" "numeric.html#./numeric:s49") (logxor "(logxor int ...)" "numeric.html#./numeric:s46") (machine-type "(machine-type)" "system.html#./system:s89") (magnitude-squared "(magnitude-squared num)" "numeric.html#./numeric:s75") (make-annotation "(make-annotation obj source-object stripped-obj)~(make-annotation obj source-object stripped-obj options)" "syntax.html#./syntax:s49") (make-boot-file "(make-boot-file output-filename base-boot-list input-filename ...)" "system.html#./system:s83") (make-boot-header "(make-boot-header output-filename base-boot1 base-boot2...)" "system.html#./system:s86") (make-compile-time-value "(make-compile-time-value obj)" "syntax.html#./syntax:s15") (make-condition "(make-condition)~(make-condition name)" "threads.html#./threads:s12") (make-continuation-condition "(make-continuation-condition continuation)" "system.html#./system:s6") (make-cost-center "(make-cost-center)" "system.html#./system:s241") (make-date "(make-date nsec sec min hour day mon year)~(make-date nsec sec min hour day mon year offset)" "system.html#./system:s211") (make-engine "(make-engine thunk)" "control.html#./control:s16") (make-ephemeron-eq-hashtable "(make-ephemeron-eq-hashtable)~(make-ephemeron-eq-hashtable size)" "objects.html#./objects:s121") (make-ephemeron-eqv-hashtable "(make-ephemeron-eqv-hashtable)~(make-ephemeron-eqv-hashtable size)" "objects.html#./objects:s121") (make-format-condition "(make-format-condition)" "system.html#./system:s4") (make-ftype-pointer "(make-ftype-pointer ftype-name expr)" "foreign.html#./foreign:s143") (make-fxvector "(make-fxvector n)~(make-fxvector n fixnum)" "objects.html#./objects:s44") (make-guardian "(make-guardian)" "smgmt.html#./smgmt:s29") (make-hash-table "(make-hash-table)~(make-hash-table weak?)" "compat.html#./compat:s0") (make-input-port "(make-input-port handler input-buffer)" "io.html#./io:s13") (make-input/output-port "(make-input/output-port handler input-buffer output-buffer)" "io.html#./io:s13") (make-list "(make-list n)~(make-list n obj)" "objects.html#./objects:s7") (make-mutex "(make-mutex)~(make-mutex name)" "threads.html#./threads:s6") (make-object-finder "(make-object-finder pred)~(make-object-finder pred g)~(make-object-finder pred x g)" "debug.html#./debug:s26") (make-output-port "(make-output-port handler output-buffer)" "io.html#./io:s13") (make-parameter "(make-parameter object)~(make-parameter object procedure)" "system.html#./system:s248") (make-record-type "(make-record-type type-name fields)~(make-record-type parent-rtd type-name fields)" "objects.html#./objects:s186") (make-source-condition "(make-source-condition form)" "system.html#./system:s5") (make-source-file-descriptor "(make-source-file-descriptor string binary-input-port)~(make-source-file-descriptor string binary-input-port reset?)" "syntax.html#./syntax:s63") (make-source-object "(make-source-object sfd bfp efp)~(make-source-object sfd bfp efp line column)" "syntax.html#./syntax:s55") (make-source-table "(make-source-table)" "syntax.html#./syntax:s81") (make-sstats "(make-sstats cpu real bytes gc-count gc-cpu gc-real gc-bytes)" "system.html#./system:s231") (make-thread-parameter "(make-thread-parameter object)~(make-thread-parameter object procedure)" "threads.html#./threads:s30") (make-time "(make-time type nsec sec)" "system.html#./system:s203") (make-weak-eq-hashtable "(make-weak-eq-hashtable)~(make-weak-eq-hashtable size)" "objects.html#./objects:s120") (make-weak-eqv-hashtable "(make-weak-eqv-hashtable)~(make-weak-eqv-hashtable size)" "objects.html#./objects:s120") (mark-port-closed! "(mark-port-closed! port)" "io.html#./io:s24") (maximum-memory-bytes "(maximum-memory-bytes)" "system.html#./system:s227") (maybe-compile-file "(maybe-compile-file input-filename)~(maybe-compile-file input-filename output-filename)" "system.html#./system:s71") (maybe-compile-library "(maybe-compile-library input-filename)~(maybe-compile-library input-filename output-filename)" "system.html#./system:s71") (maybe-compile-program "(maybe-compile-program input-filename)~(maybe-compile-program input-filename output-filename)" "system.html#./system:s71") (merge "(merge predicate list1 list2)" "objects.html#./objects:s114") (merge! "(merge! predicate list1 list2)" "objects.html#./objects:s114") (meta "(meta . definition)" "syntax.html#./syntax:s36") (meta-cond "(meta-cond clause1 clause2 ...)" "syntax.html#./syntax:s37") (mkdir "(mkdir path)~(mkdir path mode)" "io.html#./io:s146") (module "(module name interface defn ... init ...)~(module interface defn ... init ...)" "syntax.html#./syntax:s21") (most-negative-fixnum "(most-negative-fixnum)" "numeric.html#./numeric:s14") (most-positive-fixnum "(most-positive-fixnum)" "numeric.html#./numeric:s14") (multibyte->string "(multibyte->string code-page bytevector)" "io.html#./io:s92") (mutable-box? "(mutable-box? obj)" "objects.html#./objects:s86") (mutable-bytevector? "(mutable-bytevector? obj)" "objects.html#./objects:s65") (mutable-fxvector? "(mutable-fxvector? obj)" "objects.html#./objects:s52") (mutable-string? "(mutable-string? obj)" "objects.html#./objects:s24") (mutable-vector? "(mutable-vector? obj)" "objects.html#./objects:s34") (mutex-acquire "(mutex-acquire mutex)~(mutex-acquire mutex block?)" "threads.html#./threads:s8") (mutex-name "(mutex-name mutex)" "threads.html#./threads:s11") (mutex-release "(mutex-release mutex)" "threads.html#./threads:s9") (mutex? "(mutex? obj)" "threads.html#./threads:s7") (new-cafe "(new-cafe)~(new-cafe eval-proc)" "system.html#./system:s167") (nonnegative? "(nonnegative? real)" "numeric.html#./numeric:s73") (nonpositive? "(nonpositive? real)" "numeric.html#./numeric:s72") (number->string "(number->string num)~(number->string num radix)~(number->string num radix precision)" "numeric.html#./numeric:s79") (object-counts "(object-counts)" "system.html#./system:s238") (oblist "(oblist)" "objects.html#./objects:s111") (only "only" "syntax.html#./syntax:s22") (open-fd-input-port "(open-fd-input-port fd)~(open-fd-input-port fd b-mode)~(open-fd-input-port fd b-mode ?transcoder)" "io.html#./io:s60") (open-fd-input/output-port "(open-fd-input/output-port fd)~(open-fd-input/output-port fd b-mode)~(open-fd-input/output-port fd b-mode ?transcoder)" "io.html#./io:s90") (open-fd-output-port "(open-fd-output-port fd)~(open-fd-output-port fd b-mode)~(open-fd-output-port fd b-mode ?transcoder)" "io.html#./io:s80") (open-input-file "(open-input-file path)~(open-input-file path options)" "io.html#./io:s57") (open-input-output-file "(open-input-output-file path)~(open-input-output-file path options)" "io.html#./io:s89") (open-input-string "(open-input-string string)" "io.html#./io:s44") (open-output-file "(open-output-file path)~(open-output-file path options)" "io.html#./io:s75") (open-output-string "(open-output-string)" "io.html#./io:s47") (open-process-ports "(open-process-ports command)~(open-process-ports command b-mode)~(open-process-ports command b-mode ?transcoder)" "foreign.html#./foreign:s5") (open-source-file "(open-source-file sfd)" "syntax.html#./syntax:s71") (optimize-level "optimize-level" "system.html#./system:s104") (ormap "(ormap procedure list1 list2 ...)" "control.html#./control:s7") (parameterize "(parameterize ((param expr) ...) body1 body2 ...)" "system.html#./system:s250") (pariah "(pariah expr1 expr2 ...)" "system.html#./system:s127") (path-absolute? "(path-absolute? path)" "io.html#./io:s154") (path-extension "(path-extension path)" "io.html#./io:s154") (path-first "(path-first path)" "io.html#./io:s154") (path-last "(path-last path)" "io.html#./io:s154") (path-parent "(path-parent path)" "io.html#./io:s154") (path-rest "(path-rest path)" "io.html#./io:s154") (path-root "(path-root path)" "io.html#./io:s154") (petite? "(petite?)" "system.html#./system:s256") (port-bol? "(port-bol? port)" "io.html#./io:s27") (port-closed? "(port-closed? port)" "io.html#./io:s25") (port-file-compressed! "(port-file-compressed! port)" "io.html#./io:s39") (port-file-descriptor "(port-file-descriptor port)" "io.html#./io:s53") (port-handler "(port-handler port)" "io.html#./io:s15") (port-has-port-length? "(port-has-port-length? port)" "io.html#./io:s31") (port-has-port-nonblocking?? "(port-has-port-nonblocking?? port)" "io.html#./io:s33") (port-has-set-port-length!? "(port-has-set-port-length!? port)" "io.html#./io:s32") (port-has-set-port-nonblocking!? "(port-has-set-port-nonblocking!? port)" "io.html#./io:s34") (port-input-buffer "(port-input-buffer input-port)" "io.html#./io:s16") (port-input-count "(port-input-count input-port)" "io.html#./io:s18") (port-input-empty? "(port-input-empty? input-port)" "io.html#./io:s19") (port-input-index "(port-input-index input-port)" "io.html#./io:s16") (port-input-size "(port-input-size input-port)" "io.html#./io:s16") (port-length "(port-length port)" "io.html#./io:s31") (port-name "(port-name port)" "io.html#./io:s29") (port-nonblocking? "(port-nonblocking? port)" "io.html#./io:s33") (port-output-buffer "(port-output-buffer output-port)" "io.html#./io:s20") (port-output-count "(port-output-count output-port)" "io.html#./io:s22") (port-output-full? "(port-output-full? output-port)" "io.html#./io:s23") (port-output-index "(port-output-index output-port)" "io.html#./io:s20") (port-output-size "(port-output-size output-port)" "io.html#./io:s20") (predicate "predicate" "objects.html#./objects:s176") (prefix "prefix" "objects.html#./objects:s176") (pretty-file "(pretty-file ifn ofn)" "io.html#./io:s94") (pretty-format "(pretty-format sym)~(pretty-format sym fmt)" "io.html#./io:s95") (pretty-initial-indent "pretty-initial-indent" "io.html#./io:s100") (pretty-line-length "pretty-line-length" "io.html#./io:s98") (pretty-maximum-lines "pretty-maximum-lines" "io.html#./io:s103") (pretty-one-line-limit "pretty-one-line-limit" "io.html#./io:s98") (pretty-print "(pretty-print obj)~(pretty-print obj textual-output-port)" "io.html#./io:s93") (pretty-standard-indent "pretty-standard-indent" "io.html#./io:s102") (print-brackets "print-brackets" "io.html#./io:s125") (print-char-name "print-char-name" "io.html#./io:s108") (print-extended-identifiers "print-extended-identifiers" "io.html#./io:s127") (print-gensym "print-gensym" "io.html#./io:s120") (print-graph "print-graph" "io.html#./io:s110") (print-length "print-length" "io.html#./io:s114") (print-level "print-level" "io.html#./io:s114") (print-precision "print-precision" "io.html#./io:s130") (print-radix "print-radix" "io.html#./io:s119") (print-record "print-record" "objects.html#./objects:s185") (print-unicode "print-unicode" "io.html#./io:s131") (print-vector-length "print-vector-length" "io.html#./io:s128") (printf "(printf format-string obj ...)" "io.html#./io:s106") (procedure-arity-mask "(procedure-arity-mask proc)" "objects.html#./objects:s200") (process "(process command)" "foreign.html#./foreign:s7") (profile "(profile source-object)" "system.html#./system:s144") (profile-clear "(profile-clear)" "system.html#./system:s146") (profile-clear-database "(profile-clear-database)" "system.html#./system:s166") (profile-dump "(profile-dump)" "system.html#./system:s148") (profile-dump-data "(profile-dump-data path)~(profile-dump-data path dump)" "system.html#./system:s163") (profile-dump-html "(profile-dump-html)~(profile-dump-html prefix)~(profile-dump-html prefix dump)" "system.html#./system:s159") (profile-dump-list "(profile-dump-list)~(profile-dump-list warn?)~(profile-dump-list warn? dump)" "system.html#./system:s162") (profile-line-number-color "(profile-line-number-color)" "system.html#./system:s161") (profile-load-data "(profile-load-data path ...)" "system.html#./system:s164") (profile-palette "(profile-palette)" "system.html#./system:s160") (profile-query-weight "(profile-query-weight obj)" "system.html#./system:s165") (profile-release-counters "(profile-release-counters)" "system.html#./system:s147") (property-list "(property-list symbol)" "objects.html#./objects:s110") (put-bytevector-some "(put-bytevector-some binary-output-port bytevector)~(put-bytevector-some binary-output-port bytevector start)~(put-bytevector-some binary-output-port bytevector start n)" "io.html#./io:s83") (put-hash-table! "(put-hash-table! ht k v)" "compat.html#./compat:s2") (put-registry! "(put-registry! key val)" "system.html#./system:s262") (put-source-table "(put-source-table textual-output-port source-table)" "syntax.html#./syntax:s89") (put-string-some "(put-string-some textual-output-port string)~(put-string-some textual-output-port string start)~(put-string-some textual-output-port string start n)" "io.html#./io:s84") (putenv "(putenv key value)" "system.html#./system:s261") (putprop "(putprop symbol key value)" "objects.html#./objects:s104") (r5rs "r5rs" "syntax.html#./syntax:s29") (r5rs-syntax "r5rs-syntax" "syntax.html#./syntax:s31") (random "(random real)" "numeric.html#./numeric:s64") (random-seed "random-seed" "numeric.html#./numeric:s65") (ratnum? "(ratnum? obj)" "numeric.html#./numeric:s12") (read-token "(read-token)~(read-token textual-input-port)~(read-token textual-input-port sfd bfp)" "io.html#./io:s70") (real-time "(real-time)" "system.html#./system:s222") (rec "(rec var expr)" "binding.html#./binding:s17") (record-case "(record-case expr clause1 clause2 ...)" "control.html#./control:s3") (record-constructor "(record-constructor rcd)~(record-constructor rtd)" "objects.html#./objects:s189") (record-constructor-descriptor? "(record-constructor-descriptor? obj)" "objects.html#./objects:s1") (record-equal-procedure "(record-equal-procedure record1 record2)" "objects.html#./objects:s157") (record-field-accessible? "(record-field-accessible? rtd field-id)" "objects.html#./objects:s191") (record-field-accessor "(record-field-accessor rtd field-id)" "objects.html#./objects:s190") (record-field-mutable? "(record-field-mutable? rtd field-id)" "objects.html#./objects:s193") (record-field-mutator "(record-field-mutator rtd field-id)" "objects.html#./objects:s192") (record-hash-procedure "(record-hash-procedure record)" "objects.html#./objects:s159") (record-reader "(record-reader name)~(record-reader rtd)~(record-reader name rtd)~(record-reader name #f)~(record-reader rtd #f)" "objects.html#./objects:s180") (record-type-descriptor "(record-type-descriptor rec)" "objects.html#./objects:s199") (record-type-equal-procedure "(record-type-equal-procedure rtd equal-proc)~(record-type-equal-procedure rtd)" "objects.html#./objects:s156") (record-type-field-decls "(record-type-field-decls rtd)" "objects.html#./objects:s197") (record-type-field-names "(record-type-field-names rtd)" "objects.html#./objects:s196") (record-type-hash-procedure "(record-type-hash-procedure rtd hash-proc)~(record-type-hash-procedure rtd)" "objects.html#./objects:s158") (record-type-name "(record-type-name rtd)" "objects.html#./objects:s194") (record-type-symbol "(record-type-symbol rtd)" "objects.html#./objects:s195") (record-writer "(record-writer rtd)~(record-writer rtd procedure)" "objects.html#./objects:s181") (record? "(record? obj)~(record? obj rtd)" "objects.html#./objects:s198") (register-signal-handler "(register-signal-handler sig procedure)" "system.html#./system:s28") (release-minimum-generation "release-minimum-generation" "smgmt.html#./smgmt:s18") (remove! "(remove! obj list)" "objects.html#./objects:s10") (remove-foreign-entry "(remove-foreign-entry entry-name)" "foreign.html#./foreign:s162") (remove-hash-table! "(remove-hash-table! ht k)" "compat.html#./compat:s4") (remove-registry! "(remove-registry! key)" "system.html#./system:s262") (remprop "(remprop symbol key)" "objects.html#./objects:s108") (remq! "(remq! obj list)" "objects.html#./objects:s10") (remv! "(remv! obj list)" "objects.html#./objects:s10") (rename "rename" "syntax.html#./syntax:s22") (rename-file "(rename-file old-pathname new-pathname)" "io.html#./io:s149") (require-nongenerative-clause "require-nongenerative-clause" "objects.html#./objects:s142") (reset "(reset)" "system.html#./system:s178") (reset-cost-center! "(reset-cost-center! cost-center)" "system.html#./system:s247") (reset-handler "reset-handler" "system.html#./system:s179") (reset-maximum-memory-bytes! "(reset-maximum-memory-bytes!)" "system.html#./system:s228") (reverse! "(reverse! list)" "objects.html#./objects:s12") (revisit "(revisit path)" "system.html#./system:s61") (revisit-compiled-from-port "(revisit-compiled-from-port input-port)" "system.html#./system:s58") (run-cp0 "run-cp0" "system.html#./system:s120") (s8-list->bytevector "(s8-list->bytevector list)" "objects.html#./objects:s61") (sc-expand "(sc-expand obj)~(sc-expand obj env)" "system.html#./system:s95") (scheme "scheme" "syntax.html#./syntax:s28") (scheme-environment "(scheme-environment)" "system.html#./system:s31") (scheme-program "scheme-program" "system.html#./system:s189") (scheme-script "scheme-script" "system.html#./system:s185") (scheme-start "scheme-start" "system.html#./system:s184") (scheme-version "(scheme-version)" "system.html#./system:s254") (scheme-version-number "(scheme-version-number)" "system.html#./system:s255") (set-binary-port-input-buffer! "(set-binary-port-input-buffer! binary-input-port bytevector)" "io.html#./io:s17") (set-binary-port-input-index! "(set-binary-port-input-index! binary-input-port n)" "io.html#./io:s17") (set-binary-port-input-size! "(set-binary-port-input-size! binary-input-port n)" "io.html#./io:s17") (set-binary-port-output-buffer! "(set-binary-port-output-buffer! binary-output-port bytevector)" "io.html#./io:s21") (set-binary-port-output-index! "(set-binary-port-output-index! output-port n)" "io.html#./io:s21") (set-binary-port-output-size! "(set-binary-port-output-size! output-port n)" "io.html#./io:s21") (set-box! "(set-box! box obj)" "objects.html#./objects:s84") (set-port-bol! "(set-port-bol! output-port obj)" "io.html#./io:s26") (set-port-eof! "(set-port-eof! input-port obj)" "io.html#./io:s28") (set-port-input-buffer! "(set-port-input-buffer! input-port x)" "io.html#./io:s17") (set-port-input-index! "(set-port-input-index! input-port n)" "io.html#./io:s17") (set-port-input-size! "(set-port-input-size! input-port n)" "io.html#./io:s17") (set-port-length! "(set-port-length! port len)" "io.html#./io:s32") (set-port-name! "(set-port-name! port obj)" "io.html#./io:s30") (set-port-nonblocking! "(set-port-nonblocking! port obj)" "io.html#./io:s34") (set-port-output-buffer! "(set-port-output-buffer! output-port x)" "io.html#./io:s21") (set-port-output-index! "(set-port-output-index! output-port n)" "io.html#./io:s21") (set-port-output-size! "(set-port-output-size! output-port n)" "io.html#./io:s21") (set-sstats-bytes! "(set-sstats-bytes! s new-value)" "system.html#./system:s234") (set-sstats-cpu! "(set-sstats-cpu! s new-value)" "system.html#./system:s234") (set-sstats-gc-bytes! "(set-sstats-gc-bytes! s new-value)" "system.html#./system:s234") (set-sstats-gc-count! "(set-sstats-gc-count! s new-value)" "system.html#./system:s234") (set-sstats-gc-cpu! "(set-sstats-gc-cpu! s new-value)" "system.html#./system:s234") (set-sstats-gc-real! "(set-sstats-gc-real! s new-value)" "system.html#./system:s234") (set-sstats-real! "(set-sstats-real! s new-value)" "system.html#./system:s234") (set-textual-port-input-buffer! "(set-textual-port-input-buffer! textual-input-port string)" "io.html#./io:s17") (set-textual-port-input-index! "(set-textual-port-input-index! textual-input-port n)" "io.html#./io:s17") (set-textual-port-input-size! "(set-textual-port-input-size! textual-input-port n)" "io.html#./io:s17") (set-textual-port-output-buffer! "(set-textual-port-output-buffer! textual-output-port string)" "io.html#./io:s21") (set-textual-port-output-index! "(set-textual-port-output-index! textual-output-port n)" "io.html#./io:s21") (set-textual-port-output-size! "(set-textual-port-output-size! textual-output-port n)" "io.html#./io:s21") (set-time-nanosecond! "(set-time-nanosecond! time nsec)" "system.html#./system:s206") (set-time-second! "(set-time-second! time sec)" "system.html#./system:s206") (set-time-type! "(set-time-type! time type)" "system.html#./system:s206") (set-timer "(set-timer n)" "system.html#./system:s22") (set-top-level-value! "(set-top-level-value! symbol obj)~(set-top-level-value! symbol obj env)" "binding.html#./binding:s26") (set-virtual-register! "(set-virtual-register! k x)" "system.html#./system:s252") (sinh "(sinh num)" "numeric.html#./numeric:s76") (sleep "(sleep time)" "system.html#./system:s218") (sort "(sort predicate list)" "objects.html#./objects:s113") (sort! "(sort! predicate list)" "objects.html#./objects:s113") (source-condition-form "(source-condition-form condition)" "system.html#./system:s5") (source-condition? "(source-condition? obj)" "system.html#./system:s5") (source-directories "source-directories" "system.html#./system:s102") (source-file-descriptor "(source-file-descriptor path checksum)" "syntax.html#./syntax:s67") (source-file-descriptor-checksum "(source-file-descriptor-checksum sfd)" "syntax.html#./syntax:s65") (source-file-descriptor-path "(source-file-descriptor-path sfd)" "syntax.html#./syntax:s66") (source-file-descriptor? "(source-file-descriptor? obj)" "syntax.html#./syntax:s64") (source-object-bfp "(source-object-bfp source-object)" "syntax.html#./syntax:s58") (source-object-column "(source-object-column source-object)" "syntax.html#./syntax:s61") (source-object-efp "(source-object-efp source-object)" "syntax.html#./syntax:s59") (source-object-line "(source-object-line source-object)" "syntax.html#./syntax:s60") (source-object-sfd "(source-object-sfd source-object)" "syntax.html#./syntax:s57") (source-object? "(source-object? obj)" "syntax.html#./syntax:s56") (source-table-cell "(source-table-cell source-table source-object default)" "syntax.html#./syntax:s86") (source-table-contains? "(source-table-contains? source-table source-object)" "syntax.html#./syntax:s85") (source-table-delete! "(source-table-delete! source-table source-object)" "syntax.html#./syntax:s87") (source-table-dump "(source-table-dump source-table)" "system.html#./system:s153") (source-table-ref "(source-table-ref source-table source-object default)" "syntax.html#./syntax:s84") (source-table-set! "(source-table-set! source-table source-object obj)" "syntax.html#./syntax:s83") (source-table-size "(source-table-size source-table)" "syntax.html#./syntax:s88") (source-table? "(source-table? obj)" "syntax.html#./syntax:s82") (sstats-bytes "(sstats-bytes s)" "system.html#./system:s233") (sstats-cpu "(sstats-cpu s)" "system.html#./system:s233") (sstats-difference "(sstats-difference s1 s2)" "system.html#./system:s235") (sstats-gc-bytes "(sstats-gc-bytes s)" "system.html#./system:s233") (sstats-gc-count "(sstats-gc-count s)" "system.html#./system:s233") (sstats-gc-cpu "(sstats-gc-cpu s)" "system.html#./system:s233") (sstats-gc-real "(sstats-gc-real s)" "system.html#./system:s233") (sstats-print "(sstats-print s)~(sstats-print s textual-output-port)" "system.html#./system:s236") (sstats-real "(sstats-real s)" "system.html#./system:s233") (sstats? "(sstats? obj)" "system.html#./system:s232") (standard-error-port "(standard-error-port)~(standard-error-port b-mode)~(standard-error-port b-mode ?transcoder)" "io.html#./io:s82") (standard-input-port "(standard-input-port)~(standard-input-port b-mode)~(standard-input-port b-mode ?transcoder)" "io.html#./io:s61") (standard-output-port "(standard-output-port)~(standard-output-port b-mode)~(standard-output-port b-mode ?transcoder)" "io.html#./io:s81") (statistics "(statistics)" "system.html#./system:s230") (string->immutable-string "(string->immutable-string string)" "objects.html#./objects:s25") (string->multibyte "(string->multibyte code-page string)" "io.html#./io:s92") (string->number "(string->number string)~(string->number string radix)" "numeric.html#./numeric:s78") (string-ci<=? "(string-ci<=? string1 string2 string3 ...)" "objects.html#./objects:s20") (string-ci<? "(string-ci<? string1 string2 string3 ...)" "objects.html#./objects:s20") (string-ci=? "(string-ci=? string1 string2 string3 ...)" "objects.html#./objects:s20") (string-ci>=? "(string-ci>=? string1 string2 string3 ...)" "objects.html#./objects:s20") (string-ci>? "(string-ci>? string1 string2 string3 ...)" "objects.html#./objects:s20") (string-copy! "(string-copy! src src-start dst dst-start n)" "objects.html#./objects:s21") (string-truncate! "(string-truncate! string n)" "objects.html#./objects:s23") (string<=? "(string<=? string1 string2 string3 ...)" "objects.html#./objects:s20") (string<? "(string<? string1 string2 string3 ...)" "objects.html#./objects:s20") (string=? "(string=? string1 string2 string3 ...)" "objects.html#./objects:s20") (string>=? "(string>=? string1 string2 string3 ...)" "objects.html#./objects:s20") (string>? "(string>? string1 string2 string3 ...)" "objects.html#./objects:s20") (strip-fasl-file "(strip-fasl-file input-path output-path options)" "system.html#./system:s87") (sub1 "(sub1 num)" "numeric.html#./numeric:s68") (subset-mode "subset-mode" "system.html#./system:s263") (subst "(subst new old tree)" "objects.html#./objects:s11") (subst! "(subst! new old tree)" "objects.html#./objects:s11") (substq "(substq new old tree)" "objects.html#./objects:s11") (substq! "(substq! new old tree)" "objects.html#./objects:s11") (substring-fill! "(substring-fill! string start end char)" "objects.html#./objects:s22") (substv "(substv new old tree)" "objects.html#./objects:s11") (substv! "(substv! new old tree)" "objects.html#./objects:s11") (subtract-duration "(subtract-duration time timed)" "system.html#./system:s209") (subtract-duration! "(subtract-duration! time timed)" "system.html#./system:s209") (suppress-greeting "suppress-greeting" "system.html#./system:s197") (symbol-hashtable-cell "(symbol-hashtable-cell hashtable key default)" "objects.html#./objects:s138") (symbol-hashtable-contains? "(symbol-hashtable-contains? hashtable key)" "objects.html#./objects:s136") (symbol-hashtable-delete! "(symbol-hashtable-delete! hashtable key)" "objects.html#./objects:s139") (symbol-hashtable-ref "(symbol-hashtable-ref hashtable key default)" "objects.html#./objects:s135") (symbol-hashtable-set! "(symbol-hashtable-set! hashtable key value)" "objects.html#./objects:s134") (symbol-hashtable-update! "(symbol-hashtable-update! hashtable key procedure default)" "objects.html#./objects:s137") (symbol-hashtable? "(symbol-hashtable? obj)" "objects.html#./objects:s133") (syntax->annotation "(syntax->annotation obj)" "syntax.html#./syntax:s69") (syntax->list "(syntax->list syntax-object)" "syntax.html#./syntax:s6") (syntax->vector "(syntax->vector syntax-object)" "syntax.html#./syntax:s7") (syntax-error "(syntax-error obj string ...)" "syntax.html#./syntax:s13") (syntax-object->datum "(syntax-object->datum obj)" "syntax.html#./syntax:s8") (syntax-rules "(syntax-rules (literal ...) clause ...)" "syntax.html#./syntax:s4") (system "(system command)" "foreign.html#./foreign:s4") (tanh "(tanh num)" "numeric.html#./numeric:s76") (textual-port-input-buffer "(textual-port-input-buffer textual-input-port)" "io.html#./io:s16") (textual-port-input-count "(textual-port-input-count textual-input-port)" "io.html#./io:s18") (textual-port-input-index "(textual-port-input-index textual-input-port)" "io.html#./io:s16") (textual-port-input-size "(textual-port-input-size textual-input-port)" "io.html#./io:s16") (textual-port-output-buffer "(textual-port-output-buffer output-port)" "io.html#./io:s20") (textual-port-output-count "(textual-port-output-count textual-output-port)" "io.html#./io:s22") (textual-port-output-index "(textual-port-output-index output-port)" "io.html#./io:s20") (textual-port-output-size "(textual-port-output-size output-port)" "io.html#./io:s20") (thread-condition? "(thread-condition? obj)" "threads.html#./threads:s13") (thread? "(thread? obj)" "threads.html#./threads:s3") (threaded? "(threaded?)" "system.html#./system:s257") (time "(time expr)" "system.html#./system:s219") (time-difference "(time-difference time1 time2)" "system.html#./system:s209") (time-difference! "(time-difference! time1 time2)" "system.html#./system:s209") (time-nanosecond "(time-nanosecond time)" "system.html#./system:s205") (time-second "(time-second time)" "system.html#./system:s205") (time-type "(time-type time)" "system.html#./system:s205") (time-utc->date "(time-utc->date time)~(time-utc->date time offset)" "system.html#./system:s216") (time<=? "(time<=? time1 time2)" "system.html#./system:s207") (time<? "(time<? time1 time2)" "system.html#./system:s207") (time=? "(time=? time1 time2)" "system.html#./system:s207") (time>=? "(time>=? time1 time2)" "system.html#./system:s207") (time>? "(time>? time1 time2)" "system.html#./system:s207") (time? "(time? obj)" "system.html#./system:s204") (timer-interrupt-handler "timer-interrupt-handler" "system.html#./system:s24") (top-level-bound? "(top-level-bound? symbol)~(top-level-bound? symbol env)" "binding.html#./binding:s30") (top-level-mutable? "(top-level-mutable? symbol)~(top-level-mutable? symbol env)" "binding.html#./binding:s31") (top-level-program "(top-level-program imports body)" "libraries.html#./libraries:s14") (top-level-syntax "(top-level-syntax symbol)~(top-level-syntax symbol env)" "binding.html#./binding:s34") (top-level-syntax? "(top-level-syntax? symbol)~(top-level-syntax? symbol env)" "binding.html#./binding:s35") (top-level-value "(top-level-value symbol)~(top-level-value symbol env)" "binding.html#./binding:s29") (trace "(trace var1 var2 ...)~(trace)" "debug.html#./debug:s9") (trace-case-lambda "(trace-case-lambda name clause ...)" "debug.html#./debug:s3") (trace-define "(trace-define var expr)~(trace-define (var . idspec) body1 body2 ...)" "debug.html#./debug:s14") (trace-define-syntax "(trace-define-syntax keyword expr)" "debug.html#./debug:s15") (trace-do "(trace-do ((var init update) ...) (test result ...) expr ...)" "debug.html#./debug:s7") (trace-lambda "(trace-lambda name formals body1 body2 ...)" "debug.html#./debug:s0") (trace-let "(trace-let name ((var expr) ...) body1 body2 ...)" "debug.html#./debug:s5") (trace-output-port "trace-output-port" "debug.html#./debug:s11") (trace-print "trace-print" "debug.html#./debug:s12") (transcoder? "(transcoder? obj)" "io.html#./io:s12") (transcript-cafe "(transcript-cafe path)" "system.html#./system:s201") (transcript-off "(transcript-off)" "system.html#./system:s200") (transcript-on "(transcript-on path)" "system.html#./system:s199") (truncate-file "(truncate-file output-port)~(truncate-file output-port pos)" "io.html#./io:s87") (truncate-port "(truncate-port output-port)~(truncate-port output-port pos)" "io.html#./io:s87") (type-descriptor "(type-descriptor name)" "objects.html#./objects:s179") (unbox "(unbox box)" "objects.html#./objects:s83") (undefined-variable-warnings "undefined-variable-warnings" "system.html#./system:s123") (unget-char "(unget-char textual-input-port char)" "io.html#./io:s65") (unget-u8 "(unget-u8 binary-input-port octet)" "io.html#./io:s66") (unlock-object "(unlock-object obj)" "smgmt.html#./smgmt:s38") (unread-char "(unread-char char)~(unread-char char textual-input-port)" "io.html#./io:s65") (unregister-guardian "(unregister-guardian guardian)" "smgmt.html#./smgmt:s32") (untrace "(untrace var1 var2 ...)~(untrace)" "debug.html#./debug:s10") (utf-16-codec "(utf-16-codec)~(utf-16-codec endianness)" "io.html#./io:s9") (utf-16be-codec "(utf-16be-codec)" "io.html#./io:s9") (utf-16le-codec "(utf-16le-codec)" "io.html#./io:s9") (vector->immutable-vector "(vector->immutable-vector vector)" "objects.html#./objects:s35") (vector-cas! "(vector-cas! vector n old-obj new-obj)" "objects.html#./objects:s33") (vector-copy "(vector-copy vector)" "objects.html#./objects:s31") (vector-set-fixnum! "(vector-set-fixnum! vector n fixnum)" "objects.html#./objects:s32") (verify-loadability "(verify-loadability situation input ...)" "system.html#./system:s50") (virtual-register "(virtual-register k)" "system.html#./system:s253") (virtual-register-count "(virtual-register-count)" "system.html#./system:s251") (visit "(visit path)" "system.html#./system:s59") (visit-compiled-from-port "(visit-compiled-from-port input-port)" "system.html#./system:s57") (void "(void)" "objects.html#./objects:s112") (waiter-prompt-and-read "waiter-prompt-and-read" "system.html#./system:s175") (waiter-prompt-string "waiter-prompt-string" "system.html#./system:s174") (waiter-write "waiter-write" "system.html#./system:s177") (warning "(warning who msg irritant ...)" "system.html#./system:s1") (warningf "(warningf who msg irritant ...)" "system.html#./system:s2") (weak-cons "(weak-cons obj1 obj2)" "smgmt.html#./smgmt:s24") (weak-pair? "(weak-pair? obj)" "smgmt.html#./smgmt:s25") (with "(with ((pat expr) ...) template)" "compat.html#./compat:s20") (with-cost-center "(with-cost-center cost-center thunk)~(with-cost-center timed? cost-center thunk)" "system.html#./system:s243") (with-implicit "(with-implicit (id0 id1 ...) body1 body2 ...)" "syntax.html#./syntax:s11") (with-input-from-file "(with-input-from-file path thunk)~(with-input-from-file path thunk options)" "io.html#./io:s59") (with-input-from-string "(with-input-from-string string thunk)" "io.html#./io:s46") (with-interrupts-disabled "(with-interrupts-disabled body1 body2 ...)" "system.html#./system:s27") (with-mutex "(with-mutex mutex body1 body2 ...)" "threads.html#./threads:s10") (with-output-to-file "(with-output-to-file path thunk)~(with-output-to-file path thunk options)" "io.html#./io:s79") (with-output-to-string "(with-output-to-string thunk)" "io.html#./io:s50") (with-profile-tracker "(with-profile-tracker thunk)~(with-profile-tracker preserve-existing? thunk)" "system.html#./system:s150") (with-source-path "(with-source-path who name procedure)" "system.html#./system:s103")))

  (define tspl-data (make-hash tspl-alist))
  (define csug-data (make-hash csug-alist)))
