Universal Android Music Player Sample
=====================================

This sample shows how to implement an audio media app that works
across multiple form factors and provide a consistent user experience
on Android phones, tablets, Android Auto, Android Wear, Android TV and Google Cast devices.


Pre-requisites
--------------

- Android SDK v17

Getting Started
---------------

This sample uses the Gradle build system. To build this project, use the
"gradlew build" command or use "Import Project" in Android Studio.

Screenshots
-----------

![Phone](screenshots/phone.png "On a phone")
![Lock screen](screenshots/phone_lockscreen.png "Lockscreen background and controls")
![Full screen player](screenshots/phone_fullscreen_player.png "A basic full screen activity")
![Cast dialog](screenshots/phone_cast_dialog.png "Casting to Google Cast devices")
![Android Auto](screenshots/android_auto.png "Running on an Android Auto car")
![Android TV](screenshots/android_tv.png "Running on an Android TV")

![Android Wear watch face](screenshots/android_wear_1.png "MediaStyle notifications on an Android Wear watch")
![Android Wear controls](screenshots/android_wear_2.png "Media playback controls on an Android Wear watch")

Support
-------

- Google+ Community: https://plus.google.com/communities/105153134372062985968
- Stack Overflow: http://stackoverflow.com/questions/tagged/android

If you've found an error in this sample, please file an issue:
https://github.com/googlesamples/android-UniversalMusicPlayer/issues

Patches are encouraged, and may be submitted by forking this project and
submitting a pull request through GitHub. Please see CONTRIBUTING.md for more details.

License
-------

Copyright 2014 The Android Open Source Project, Inc.

Licensed to the Apache Software Foundation (ASF) under one or more contributor
license agreements.  See the NOTICE file distributed with this work for
additional information regarding copyright ownership.  The ASF licenses this
file to you under the Apache License, Version 2.0 (the "License"); you may not
use this file except in compliance with the License.  You may obtain a copy of
the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
License for the specific language governing permissions and limitations under
the License.
