package imageseg

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SegmentFurniture invokes the imageseg.SegmentFurniture API synchronously
func (client *Client) SegmentFurniture(request *SegmentFurnitureRequest) (response *SegmentFurnitureResponse, err error) {
	response = CreateSegmentFurnitureResponse()
	err = client.DoAction(request, response)
	return
}

// SegmentFurnitureWithChan invokes the imageseg.SegmentFurniture API asynchronously
func (client *Client) SegmentFurnitureWithChan(request *SegmentFurnitureRequest) (<-chan *SegmentFurnitureResponse, <-chan error) {
	responseChan := make(chan *SegmentFurnitureResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SegmentFurniture(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SegmentFurnitureWithCallback invokes the imageseg.SegmentFurniture API asynchronously
func (client *Client) SegmentFurnitureWithCallback(request *SegmentFurnitureRequest, callback func(response *SegmentFurnitureResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SegmentFurnitureResponse
		var err error
		defer close(result)
		response, err = client.SegmentFurniture(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SegmentFurnitureRequest is the request struct for api SegmentFurniture
type SegmentFurnitureRequest struct {
	*requests.RpcRequest
	ImageURL string `position:"Body" name:"ImageURL"`
}

// SegmentFurnitureResponse is the response struct for api SegmentFurniture
type SegmentFurnitureResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateSegmentFurnitureRequest creates a request to invoke SegmentFurniture API
func CreateSegmentFurnitureRequest() (request *SegmentFurnitureRequest) {
	request = &SegmentFurnitureRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("imageseg", "2019-12-30", "SegmentFurniture", "imageseg", "openAPI")
	request.Method = requests.POST
	return
}

// CreateSegmentFurnitureResponse creates a response to parse from SegmentFurniture response
func CreateSegmentFurnitureResponse() (response *SegmentFurnitureResponse) {
	response = &SegmentFurnitureResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
