package imageprocess

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CalcCACS invokes the imageprocess.CalcCACS API synchronously
func (client *Client) CalcCACS(request *CalcCACSRequest) (response *CalcCACSResponse, err error) {
	response = CreateCalcCACSResponse()
	err = client.DoAction(request, response)
	return
}

// CalcCACSWithChan invokes the imageprocess.CalcCACS API asynchronously
func (client *Client) CalcCACSWithChan(request *CalcCACSRequest) (<-chan *CalcCACSResponse, <-chan error) {
	responseChan := make(chan *CalcCACSResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CalcCACS(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CalcCACSWithCallback invokes the imageprocess.CalcCACS API asynchronously
func (client *Client) CalcCACSWithCallback(request *CalcCACSRequest, callback func(response *CalcCACSResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CalcCACSResponse
		var err error
		defer close(result)
		response, err = client.CalcCACS(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CalcCACSRequest is the request struct for api CalcCACS
type CalcCACSRequest struct {
	*requests.RpcRequest
	DataSourceType string             `position:"Body" name:"DataSourceType"`
	DataFormat     string             `position:"Body" name:"DataFormat"`
	URLList        *[]CalcCACSURLList `position:"Body" name:"URLList"  type:"Repeated"`
	OrgId          string             `position:"Body" name:"OrgId"`
	Async          requests.Boolean   `position:"Body" name:"Async"`
	OrgName        string             `position:"Body" name:"OrgName"`
}

// CalcCACSURLList is a repeated param struct in CalcCACSRequest
type CalcCACSURLList struct {
	URL string `name:"URL"`
}

// CalcCACSResponse is the response struct for api CalcCACS
type CalcCACSResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateCalcCACSRequest creates a request to invoke CalcCACS API
func CreateCalcCACSRequest() (request *CalcCACSRequest) {
	request = &CalcCACSRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("imageprocess", "2020-03-20", "CalcCACS", "imageprocess", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCalcCACSResponse creates a response to parse from CalcCACS response
func CreateCalcCACSResponse() (response *CalcCACSResponse) {
	response = &CalcCACSResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
