package edas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetIstioTestMethod invokes the edas.GetIstioTestMethod API synchronously
func (client *Client) GetIstioTestMethod(request *GetIstioTestMethodRequest) (response *GetIstioTestMethodResponse, err error) {
	response = CreateGetIstioTestMethodResponse()
	err = client.DoAction(request, response)
	return
}

// GetIstioTestMethodWithChan invokes the edas.GetIstioTestMethod API asynchronously
func (client *Client) GetIstioTestMethodWithChan(request *GetIstioTestMethodRequest) (<-chan *GetIstioTestMethodResponse, <-chan error) {
	responseChan := make(chan *GetIstioTestMethodResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetIstioTestMethod(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetIstioTestMethodWithCallback invokes the edas.GetIstioTestMethod API asynchronously
func (client *Client) GetIstioTestMethodWithCallback(request *GetIstioTestMethodRequest, callback func(response *GetIstioTestMethodResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetIstioTestMethodResponse
		var err error
		defer close(result)
		response, err = client.GetIstioTestMethod(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetIstioTestMethodRequest is the request struct for api GetIstioTestMethod
type GetIstioTestMethodRequest struct {
	*requests.RoaRequest
	HttpMethod       string `position:"Query" name:"HttpMethod"`
	AppId            string `position:"Query" name:"AppId"`
	Namespace        string `position:"Query" name:"Namespace"`
	MethodSignature  string `position:"Query" name:"MethodSignature"`
	ServiceName      string `position:"Query" name:"ServiceName"`
	Region           string `position:"Query" name:"Region"`
	RequiredPath     string `position:"Query" name:"RequiredPath"`
	MethodController string `position:"Query" name:"MethodController"`
}

// GetIstioTestMethodResponse is the response struct for api GetIstioTestMethod
type GetIstioTestMethodResponse struct {
	*responses.BaseResponse
	Message        string `json:"Message" xml:"Message"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Code           int    `json:"Code" xml:"Code"`
	Success        bool   `json:"Success" xml:"Success"`
	Data           Data   `json:"Data" xml:"Data"`
}

// CreateGetIstioTestMethodRequest creates a request to invoke GetIstioTestMethod API
func CreateGetIstioTestMethodRequest() (request *GetIstioTestMethodRequest) {
	request = &GetIstioTestMethodRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Edas", "2017-08-01", "GetIstioTestMethod", "/pop/sp/api/mse/test/istio/method", "Edas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetIstioTestMethodResponse creates a response to parse from GetIstioTestMethod response
func CreateGetIstioTestMethodResponse() (response *GetIstioTestMethodResponse) {
	response = &GetIstioTestMethodResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
