package domain

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// TransferInResendMailToken invokes the domain.TransferInResendMailToken API synchronously
func (client *Client) TransferInResendMailToken(request *TransferInResendMailTokenRequest) (response *TransferInResendMailTokenResponse, err error) {
	response = CreateTransferInResendMailTokenResponse()
	err = client.DoAction(request, response)
	return
}

// TransferInResendMailTokenWithChan invokes the domain.TransferInResendMailToken API asynchronously
func (client *Client) TransferInResendMailTokenWithChan(request *TransferInResendMailTokenRequest) (<-chan *TransferInResendMailTokenResponse, <-chan error) {
	responseChan := make(chan *TransferInResendMailTokenResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.TransferInResendMailToken(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// TransferInResendMailTokenWithCallback invokes the domain.TransferInResendMailToken API asynchronously
func (client *Client) TransferInResendMailTokenWithCallback(request *TransferInResendMailTokenRequest, callback func(response *TransferInResendMailTokenResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *TransferInResendMailTokenResponse
		var err error
		defer close(result)
		response, err = client.TransferInResendMailToken(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// TransferInResendMailTokenRequest is the request struct for api TransferInResendMailToken
type TransferInResendMailTokenRequest struct {
	*requests.RpcRequest
	DomainName   string `position:"Query" name:"DomainName"`
	UserClientIp string `position:"Query" name:"UserClientIp"`
	Lang         string `position:"Query" name:"Lang"`
}

// TransferInResendMailTokenResponse is the response struct for api TransferInResendMailToken
type TransferInResendMailTokenResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateTransferInResendMailTokenRequest creates a request to invoke TransferInResendMailToken API
func CreateTransferInResendMailTokenRequest() (request *TransferInResendMailTokenRequest) {
	request = &TransferInResendMailTokenRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Domain", "2018-01-29", "TransferInResendMailToken", "", "")
	request.Method = requests.POST
	return
}

// CreateTransferInResendMailTokenResponse creates a response to parse from TransferInResendMailToken response
func CreateTransferInResendMailTokenResponse() (response *TransferInResendMailTokenResponse) {
	response = &TransferInResendMailTokenResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
