package dm

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescDomain invokes the dm.DescDomain API synchronously
// api document: https://help.aliyun.com/api/dm/descdomain.html
func (client *Client) DescDomain(request *DescDomainRequest) (response *DescDomainResponse, err error) {
	response = CreateDescDomainResponse()
	err = client.DoAction(request, response)
	return
}

// DescDomainWithChan invokes the dm.DescDomain API asynchronously
// api document: https://help.aliyun.com/api/dm/descdomain.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescDomainWithChan(request *DescDomainRequest) (<-chan *DescDomainResponse, <-chan error) {
	responseChan := make(chan *DescDomainResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescDomain(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescDomainWithCallback invokes the dm.DescDomain API asynchronously
// api document: https://help.aliyun.com/api/dm/descdomain.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescDomainWithCallback(request *DescDomainRequest, callback func(response *DescDomainResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescDomainResponse
		var err error
		defer close(result)
		response, err = client.DescDomain(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescDomainRequest is the request struct for api DescDomain
type DescDomainRequest struct {
	*requests.RpcRequest
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	DomainId             requests.Integer `position:"Query" name:"DomainId"`
}

// DescDomainResponse is the response struct for api DescDomain
type DescDomainResponse struct {
	*responses.BaseResponse
	RequestId          string `json:"RequestId" xml:"RequestId"`
	DomainId           string `json:"DomainId" xml:"DomainId"`
	DomainName         string `json:"DomainName" xml:"DomainName"`
	DomainType         string `json:"DomainType" xml:"DomainType"`
	DomainStatus       string `json:"DomainStatus" xml:"DomainStatus"`
	CnameRecord        string `json:"CnameRecord" xml:"CnameRecord"`
	CnameConfirmStatus string `json:"CnameConfirmStatus" xml:"CnameConfirmStatus"`
	SpfAuthStatus      string `json:"SpfAuthStatus" xml:"SpfAuthStatus"`
	MxAuthStatus       string `json:"MxAuthStatus" xml:"MxAuthStatus"`
	DefaultDomain      string `json:"DefaultDomain" xml:"DefaultDomain"`
	CreateTime         string `json:"CreateTime" xml:"CreateTime"`
	CnameAuthStatus    string `json:"CnameAuthStatus" xml:"CnameAuthStatus"`
	IcpStatus          string `json:"IcpStatus" xml:"IcpStatus"`
	SpfRecord          string `json:"SpfRecord" xml:"SpfRecord"`
	MxRecord           string `json:"MxRecord" xml:"MxRecord"`
	TracefRecord       string `json:"TracefRecord" xml:"TracefRecord"`
}

// CreateDescDomainRequest creates a request to invoke DescDomain API
func CreateDescDomainRequest() (request *DescDomainRequest) {
	request = &DescDomainRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dm", "2015-11-23", "DescDomain", "", "")
	return
}

// CreateDescDomainResponse creates a response to parse from DescDomain response
func CreateDescDomainResponse() (response *DescDomainResponse) {
	response = &DescDomainResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
