package ddoscoo

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// EmptySlsLogstore invokes the ddoscoo.EmptySlsLogstore API synchronously
func (client *Client) EmptySlsLogstore(request *EmptySlsLogstoreRequest) (response *EmptySlsLogstoreResponse, err error) {
	response = CreateEmptySlsLogstoreResponse()
	err = client.DoAction(request, response)
	return
}

// EmptySlsLogstoreWithChan invokes the ddoscoo.EmptySlsLogstore API asynchronously
func (client *Client) EmptySlsLogstoreWithChan(request *EmptySlsLogstoreRequest) (<-chan *EmptySlsLogstoreResponse, <-chan error) {
	responseChan := make(chan *EmptySlsLogstoreResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.EmptySlsLogstore(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// EmptySlsLogstoreWithCallback invokes the ddoscoo.EmptySlsLogstore API asynchronously
func (client *Client) EmptySlsLogstoreWithCallback(request *EmptySlsLogstoreRequest, callback func(response *EmptySlsLogstoreResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *EmptySlsLogstoreResponse
		var err error
		defer close(result)
		response, err = client.EmptySlsLogstore(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// EmptySlsLogstoreRequest is the request struct for api EmptySlsLogstore
type EmptySlsLogstoreRequest struct {
	*requests.RpcRequest
	ResourceGroupId string `position:"Query" name:"ResourceGroupId"`
	SourceIp        string `position:"Query" name:"SourceIp"`
	Lang            string `position:"Query" name:"Lang"`
}

// EmptySlsLogstoreResponse is the response struct for api EmptySlsLogstore
type EmptySlsLogstoreResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateEmptySlsLogstoreRequest creates a request to invoke EmptySlsLogstore API
func CreateEmptySlsLogstoreRequest() (request *EmptySlsLogstoreRequest) {
	request = &EmptySlsLogstoreRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ddoscoo", "2017-12-28", "EmptySlsLogstore", "", "")
	request.Method = requests.POST
	return
}

// CreateEmptySlsLogstoreResponse creates a response to parse from EmptySlsLogstore response
func CreateEmptySlsLogstoreResponse() (response *EmptySlsLogstoreResponse) {
	response = &EmptySlsLogstoreResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
