package ddosbgp

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribePackPaidTraffic invokes the ddosbgp.DescribePackPaidTraffic API synchronously
// api document: https://help.aliyun.com/api/ddosbgp/describepackpaidtraffic.html
func (client *Client) DescribePackPaidTraffic(request *DescribePackPaidTrafficRequest) (response *DescribePackPaidTrafficResponse, err error) {
	response = CreateDescribePackPaidTrafficResponse()
	err = client.DoAction(request, response)
	return
}

// DescribePackPaidTrafficWithChan invokes the ddosbgp.DescribePackPaidTraffic API asynchronously
// api document: https://help.aliyun.com/api/ddosbgp/describepackpaidtraffic.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribePackPaidTrafficWithChan(request *DescribePackPaidTrafficRequest) (<-chan *DescribePackPaidTrafficResponse, <-chan error) {
	responseChan := make(chan *DescribePackPaidTrafficResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribePackPaidTraffic(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribePackPaidTrafficWithCallback invokes the ddosbgp.DescribePackPaidTraffic API asynchronously
// api document: https://help.aliyun.com/api/ddosbgp/describepackpaidtraffic.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribePackPaidTrafficWithCallback(request *DescribePackPaidTrafficRequest, callback func(response *DescribePackPaidTrafficResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribePackPaidTrafficResponse
		var err error
		defer close(result)
		response, err = client.DescribePackPaidTraffic(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribePackPaidTrafficRequest is the request struct for api DescribePackPaidTraffic
type DescribePackPaidTrafficRequest struct {
	*requests.RpcRequest
	StartTime       requests.Integer `position:"Query" name:"StartTime"`
	ResourceGroupId string           `position:"Query" name:"ResourceGroupId"`
	SourceIp        string           `position:"Query" name:"SourceIp"`
	PageSize        requests.Integer `position:"Query" name:"PageSize"`
	EndTime         requests.Integer `position:"Query" name:"EndTime"`
	CurrentPage     requests.Integer `position:"Query" name:"CurrentPage"`
	InstanceId      string           `position:"Query" name:"InstanceId"`
}

// DescribePackPaidTrafficResponse is the response struct for api DescribePackPaidTraffic
type DescribePackPaidTrafficResponse struct {
	*responses.BaseResponse
	RequestId        string            `json:"RequestId" xml:"RequestId"`
	TotalCount       int               `json:"TotalCount" xml:"TotalCount"`
	PackPaidTraffics []PackPaidTraffic `json:"PackPaidTraffics" xml:"PackPaidTraffics"`
}

// CreateDescribePackPaidTrafficRequest creates a request to invoke DescribePackPaidTraffic API
func CreateDescribePackPaidTrafficRequest() (request *DescribePackPaidTrafficRequest) {
	request = &DescribePackPaidTrafficRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ddosbgp", "2018-07-20", "DescribePackPaidTraffic", "ddosbgp", "openAPI")
	return
}

// CreateDescribePackPaidTrafficResponse creates a response to parse from DescribePackPaidTraffic response
func CreateDescribePackPaidTrafficResponse() (response *DescribePackPaidTrafficResponse) {
	response = &DescribePackPaidTrafficResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
