package cms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// InstallMonitoringAgent invokes the cms.InstallMonitoringAgent API synchronously
func (client *Client) InstallMonitoringAgent(request *InstallMonitoringAgentRequest) (response *InstallMonitoringAgentResponse, err error) {
	response = CreateInstallMonitoringAgentResponse()
	err = client.DoAction(request, response)
	return
}

// InstallMonitoringAgentWithChan invokes the cms.InstallMonitoringAgent API asynchronously
func (client *Client) InstallMonitoringAgentWithChan(request *InstallMonitoringAgentRequest) (<-chan *InstallMonitoringAgentResponse, <-chan error) {
	responseChan := make(chan *InstallMonitoringAgentResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.InstallMonitoringAgent(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// InstallMonitoringAgentWithCallback invokes the cms.InstallMonitoringAgent API asynchronously
func (client *Client) InstallMonitoringAgentWithCallback(request *InstallMonitoringAgentRequest, callback func(response *InstallMonitoringAgentResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *InstallMonitoringAgentResponse
		var err error
		defer close(result)
		response, err = client.InstallMonitoringAgent(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// InstallMonitoringAgentRequest is the request struct for api InstallMonitoringAgent
type InstallMonitoringAgentRequest struct {
	*requests.RpcRequest
	InstanceIds    *[]string        `position:"Query" name:"InstanceIds"  type:"Repeated"`
	Force          requests.Boolean `position:"Query" name:"Force"`
	InstallCommand string           `position:"Query" name:"InstallCommand"`
}

// InstallMonitoringAgentResponse is the response struct for api InstallMonitoringAgent
type InstallMonitoringAgentResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateInstallMonitoringAgentRequest creates a request to invoke InstallMonitoringAgent API
func CreateInstallMonitoringAgentRequest() (request *InstallMonitoringAgentRequest) {
	request = &InstallMonitoringAgentRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cms", "2019-01-01", "InstallMonitoringAgent", "Cms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateInstallMonitoringAgentResponse creates a response to parse from InstallMonitoringAgent response
func CreateInstallMonitoringAgentResponse() (response *InstallMonitoringAgentResponse) {
	response = &InstallMonitoringAgentResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
