package cloudwf

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ShopOverview invokes the cloudwf.ShopOverview API synchronously
// api document: https://help.aliyun.com/api/cloudwf/shopoverview.html
func (client *Client) ShopOverview(request *ShopOverviewRequest) (response *ShopOverviewResponse, err error) {
	response = CreateShopOverviewResponse()
	err = client.DoAction(request, response)
	return
}

// ShopOverviewWithChan invokes the cloudwf.ShopOverview API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/shopoverview.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ShopOverviewWithChan(request *ShopOverviewRequest) (<-chan *ShopOverviewResponse, <-chan error) {
	responseChan := make(chan *ShopOverviewResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ShopOverview(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ShopOverviewWithCallback invokes the cloudwf.ShopOverview API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/shopoverview.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ShopOverviewWithCallback(request *ShopOverviewRequest, callback func(response *ShopOverviewResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ShopOverviewResponse
		var err error
		defer close(result)
		response, err = client.ShopOverview(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ShopOverviewRequest is the request struct for api ShopOverview
type ShopOverviewRequest struct {
	*requests.RpcRequest
	Gsid requests.Integer `position:"Query" name:"Gsid"`
}

// ShopOverviewResponse is the response struct for api ShopOverview
type ShopOverviewResponse struct {
	*responses.BaseResponse
	Success   bool   `json:"Success" xml:"Success"`
	Data      string `json:"Data" xml:"Data"`
	ErrorCode int    `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMsg  string `json:"ErrorMsg" xml:"ErrorMsg"`
}

// CreateShopOverviewRequest creates a request to invoke ShopOverview API
func CreateShopOverviewRequest() (request *ShopOverviewRequest) {
	request = &ShopOverviewRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudwf", "2017-03-28", "ShopOverview", "cloudwf", "openAPI")
	return
}

// CreateShopOverviewResponse creates a response to parse from ShopOverview response
func CreateShopOverviewResponse() (response *ShopOverviewResponse) {
	response = &ShopOverviewResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
