package cloudgameapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryGame invokes the cloudgameapi.QueryGame API synchronously
func (client *Client) QueryGame(request *QueryGameRequest) (response *QueryGameResponse, err error) {
	response = CreateQueryGameResponse()
	err = client.DoAction(request, response)
	return
}

// QueryGameWithChan invokes the cloudgameapi.QueryGame API asynchronously
func (client *Client) QueryGameWithChan(request *QueryGameRequest) (<-chan *QueryGameResponse, <-chan error) {
	responseChan := make(chan *QueryGameResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryGame(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryGameWithCallback invokes the cloudgameapi.QueryGame API asynchronously
func (client *Client) QueryGameWithCallback(request *QueryGameRequest, callback func(response *QueryGameResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryGameResponse
		var err error
		defer close(result)
		response, err = client.QueryGame(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryGameRequest is the request struct for api QueryGame
type QueryGameRequest struct {
	*requests.RpcRequest
	PageNo    requests.Integer `position:"Query" name:"PageNo"`
	PageSize  requests.Integer `position:"Query" name:"PageSize"`
	TenantId  requests.Integer `position:"Query" name:"TenantId"`
	ProjectId requests.Integer `position:"Query" name:"ProjectId"`
}

// QueryGameResponse is the response struct for api QueryGame
type QueryGameResponse struct {
	*responses.BaseResponse
	RequestId  string  `json:"RequestId" xml:"RequestId"`
	PageNumber int     `json:"PageNumber" xml:"PageNumber"`
	PageSize   int     `json:"PageSize" xml:"PageSize"`
	TotalCount int     `json:"TotalCount" xml:"TotalCount"`
	Data       []Items `json:"Data" xml:"Data"`
}

// CreateQueryGameRequest creates a request to invoke QueryGame API
func CreateQueryGameRequest() (request *QueryGameRequest) {
	request = &QueryGameRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudGameAPI", "2020-07-28", "QueryGame", "", "")
	request.Method = requests.POST
	return
}

// CreateQueryGameResponse creates a response to parse from QueryGame response
func CreateQueryGameResponse() (response *QueryGameResponse) {
	response = &QueryGameResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
