package cdrs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListCityMapPersonFlow invokes the cdrs.ListCityMapPersonFlow API synchronously
func (client *Client) ListCityMapPersonFlow(request *ListCityMapPersonFlowRequest) (response *ListCityMapPersonFlowResponse, err error) {
	response = CreateListCityMapPersonFlowResponse()
	err = client.DoAction(request, response)
	return
}

// ListCityMapPersonFlowWithChan invokes the cdrs.ListCityMapPersonFlow API asynchronously
func (client *Client) ListCityMapPersonFlowWithChan(request *ListCityMapPersonFlowRequest) (<-chan *ListCityMapPersonFlowResponse, <-chan error) {
	responseChan := make(chan *ListCityMapPersonFlowResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListCityMapPersonFlow(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListCityMapPersonFlowWithCallback invokes the cdrs.ListCityMapPersonFlow API asynchronously
func (client *Client) ListCityMapPersonFlowWithCallback(request *ListCityMapPersonFlowRequest, callback func(response *ListCityMapPersonFlowResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListCityMapPersonFlowResponse
		var err error
		defer close(result)
		response, err = client.ListCityMapPersonFlow(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListCityMapPersonFlowRequest is the request struct for api ListCityMapPersonFlow
type ListCityMapPersonFlowRequest struct {
	*requests.RpcRequest
	EndTime                string                 `position:"Body" name:"EndTime"`
	Range                  string                 `position:"Body" name:"Range"`
	StartTime              string                 `position:"Body" name:"StartTime"`
	OriginDataSourceIdList map[string]interface{} `position:"Body" name:"OriginDataSourceIdList"`
	PageNumber             requests.Integer       `position:"Body" name:"PageNumber"`
	TargetDataSourceIdList string                 `position:"Body" name:"TargetDataSourceIdList"`
	PageSize               requests.Integer       `position:"Body" name:"PageSize"`
}

// ListCityMapPersonFlowResponse is the response struct for api ListCityMapPersonFlow
type ListCityMapPersonFlowResponse struct {
	*responses.BaseResponse
	Code       string  `json:"Code" xml:"Code"`
	Message    string  `json:"Message" xml:"Message"`
	RequestId  string  `json:"RequestId" xml:"RequestId"`
	PageNumber int64   `json:"PageNumber" xml:"PageNumber"`
	PageSize   int64   `json:"PageSize" xml:"PageSize"`
	TotalCount int64   `json:"TotalCount" xml:"TotalCount"`
	Data       []Datas `json:"Data" xml:"Data"`
}

// CreateListCityMapPersonFlowRequest creates a request to invoke ListCityMapPersonFlow API
func CreateListCityMapPersonFlowRequest() (request *ListCityMapPersonFlowRequest) {
	request = &ListCityMapPersonFlowRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CDRS", "2020-11-01", "ListCityMapPersonFlow", "", "")
	request.Method = requests.POST
	return
}

// CreateListCityMapPersonFlowResponse creates a response to parse from ListCityMapPersonFlow response
func CreateListCityMapPersonFlowResponse() (response *ListCityMapPersonFlowResponse) {
	response = &ListCityMapPersonFlowResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
