package baas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// FreezeAntChainAccount invokes the baas.FreezeAntChainAccount API synchronously
// api document: https://help.aliyun.com/api/baas/freezeantchainaccount.html
func (client *Client) FreezeAntChainAccount(request *FreezeAntChainAccountRequest) (response *FreezeAntChainAccountResponse, err error) {
	response = CreateFreezeAntChainAccountResponse()
	err = client.DoAction(request, response)
	return
}

// FreezeAntChainAccountWithChan invokes the baas.FreezeAntChainAccount API asynchronously
// api document: https://help.aliyun.com/api/baas/freezeantchainaccount.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) FreezeAntChainAccountWithChan(request *FreezeAntChainAccountRequest) (<-chan *FreezeAntChainAccountResponse, <-chan error) {
	responseChan := make(chan *FreezeAntChainAccountResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.FreezeAntChainAccount(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// FreezeAntChainAccountWithCallback invokes the baas.FreezeAntChainAccount API asynchronously
// api document: https://help.aliyun.com/api/baas/freezeantchainaccount.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) FreezeAntChainAccountWithCallback(request *FreezeAntChainAccountRequest, callback func(response *FreezeAntChainAccountResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *FreezeAntChainAccountResponse
		var err error
		defer close(result)
		response, err = client.FreezeAntChainAccount(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// FreezeAntChainAccountRequest is the request struct for api FreezeAntChainAccount
type FreezeAntChainAccountRequest struct {
	*requests.RpcRequest
	AntChainId string `position:"Body" name:"AntChainId"`
	Account    string `position:"Body" name:"Account"`
}

// FreezeAntChainAccountResponse is the response struct for api FreezeAntChainAccount
type FreezeAntChainAccountResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Result    string `json:"Result" xml:"Result"`
}

// CreateFreezeAntChainAccountRequest creates a request to invoke FreezeAntChainAccount API
func CreateFreezeAntChainAccountRequest() (request *FreezeAntChainAccountRequest) {
	request = &FreezeAntChainAccountRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Baas", "2018-12-21", "FreezeAntChainAccount", "baas", "openAPI")
	return
}

// CreateFreezeAntChainAccountResponse creates a response to parse from FreezeAntChainAccount response
func CreateFreezeAntChainAccountResponse() (response *FreezeAntChainAccountResponse) {
	response = &FreezeAntChainAccountResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
