package alikafka

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateAllowedIp invokes the alikafka.UpdateAllowedIp API synchronously
func (client *Client) UpdateAllowedIp(request *UpdateAllowedIpRequest) (response *UpdateAllowedIpResponse, err error) {
	response = CreateUpdateAllowedIpResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateAllowedIpWithChan invokes the alikafka.UpdateAllowedIp API asynchronously
func (client *Client) UpdateAllowedIpWithChan(request *UpdateAllowedIpRequest) (<-chan *UpdateAllowedIpResponse, <-chan error) {
	responseChan := make(chan *UpdateAllowedIpResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateAllowedIp(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateAllowedIpWithCallback invokes the alikafka.UpdateAllowedIp API asynchronously
func (client *Client) UpdateAllowedIpWithCallback(request *UpdateAllowedIpRequest, callback func(response *UpdateAllowedIpResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateAllowedIpResponse
		var err error
		defer close(result)
		response, err = client.UpdateAllowedIp(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateAllowedIpRequest is the request struct for api UpdateAllowedIp
type UpdateAllowedIpRequest struct {
	*requests.RpcRequest
	PortRange       string `position:"Query" name:"PortRange"`
	AllowedListIp   string `position:"Query" name:"AllowedListIp"`
	UpdateType      string `position:"Query" name:"UpdateType"`
	AllowedListType string `position:"Query" name:"AllowedListType"`
	InstanceId      string `position:"Query" name:"InstanceId"`
}

// UpdateAllowedIpResponse is the response struct for api UpdateAllowedIp
type UpdateAllowedIpResponse struct {
	*responses.BaseResponse
	Success   bool   `json:"Success" xml:"Success"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      int    `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
}

// CreateUpdateAllowedIpRequest creates a request to invoke UpdateAllowedIp API
func CreateUpdateAllowedIpRequest() (request *UpdateAllowedIpRequest) {
	request = &UpdateAllowedIpRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("alikafka", "2019-09-16", "UpdateAllowedIp", "alikafka", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateAllowedIpResponse creates a response to parse from UpdateAllowedIp response
func CreateUpdateAllowedIpResponse() (response *UpdateAllowedIpResponse) {
	response = &UpdateAllowedIpResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
