package aegis

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeTopRiskyAssets invokes the aegis.DescribeTopRiskyAssets API synchronously
// api document: https://help.aliyun.com/api/aegis/describetopriskyassets.html
func (client *Client) DescribeTopRiskyAssets(request *DescribeTopRiskyAssetsRequest) (response *DescribeTopRiskyAssetsResponse, err error) {
	response = CreateDescribeTopRiskyAssetsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeTopRiskyAssetsWithChan invokes the aegis.DescribeTopRiskyAssets API asynchronously
// api document: https://help.aliyun.com/api/aegis/describetopriskyassets.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeTopRiskyAssetsWithChan(request *DescribeTopRiskyAssetsRequest) (<-chan *DescribeTopRiskyAssetsResponse, <-chan error) {
	responseChan := make(chan *DescribeTopRiskyAssetsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeTopRiskyAssets(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeTopRiskyAssetsWithCallback invokes the aegis.DescribeTopRiskyAssets API asynchronously
// api document: https://help.aliyun.com/api/aegis/describetopriskyassets.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeTopRiskyAssetsWithCallback(request *DescribeTopRiskyAssetsRequest, callback func(response *DescribeTopRiskyAssetsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeTopRiskyAssetsResponse
		var err error
		defer close(result)
		response, err = client.DescribeTopRiskyAssets(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeTopRiskyAssetsRequest is the request struct for api DescribeTopRiskyAssets
type DescribeTopRiskyAssetsRequest struct {
	*requests.RpcRequest
	SourceIp string           `position:"Query" name:"SourceIp"`
	PageSize requests.Integer `position:"Query" name:"PageSize"`
}

// DescribeTopRiskyAssetsResponse is the response struct for api DescribeTopRiskyAssets
type DescribeTopRiskyAssetsResponse struct {
	*responses.BaseResponse
	RequestId      string          `json:"RequestId" xml:"RequestId"`
	TotalCount     int             `json:"TotalCount" xml:"TotalCount"`
	TopRiskyAssets []TopRiskyAsset `json:"TopRiskyAssets" xml:"TopRiskyAssets"`
}

// CreateDescribeTopRiskyAssetsRequest creates a request to invoke DescribeTopRiskyAssets API
func CreateDescribeTopRiskyAssetsRequest() (request *DescribeTopRiskyAssetsRequest) {
	request = &DescribeTopRiskyAssetsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("aegis", "2016-11-11", "DescribeTopRiskyAssets", "vipaegis", "openAPI")
	return
}

// CreateDescribeTopRiskyAssetsResponse creates a response to parse from DescribeTopRiskyAssets response
func CreateDescribeTopRiskyAssetsResponse() (response *DescribeTopRiskyAssetsResponse) {
	response = &DescribeTopRiskyAssetsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
