package actiontrail

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeTrails invokes the actiontrail.DescribeTrails API synchronously
func (client *Client) DescribeTrails(request *DescribeTrailsRequest) (response *DescribeTrailsResponse, err error) {
	response = CreateDescribeTrailsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeTrailsWithChan invokes the actiontrail.DescribeTrails API asynchronously
func (client *Client) DescribeTrailsWithChan(request *DescribeTrailsRequest) (<-chan *DescribeTrailsResponse, <-chan error) {
	responseChan := make(chan *DescribeTrailsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeTrails(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeTrailsWithCallback invokes the actiontrail.DescribeTrails API asynchronously
func (client *Client) DescribeTrailsWithCallback(request *DescribeTrailsRequest, callback func(response *DescribeTrailsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeTrailsResponse
		var err error
		defer close(result)
		response, err = client.DescribeTrails(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeTrailsRequest is the request struct for api DescribeTrails
type DescribeTrailsRequest struct {
	*requests.RpcRequest
	IncludeOrganizationTrail requests.Boolean `position:"Query" name:"IncludeOrganizationTrail"`
	IncludeShadowTrails      requests.Boolean `position:"Query" name:"IncludeShadowTrails"`
	NameList                 string           `position:"Query" name:"NameList"`
}

// DescribeTrailsResponse is the response struct for api DescribeTrails
type DescribeTrailsResponse struct {
	*responses.BaseResponse
	RequestId string  `json:"RequestId" xml:"RequestId"`
	TrailList []Trail `json:"TrailList" xml:"TrailList"`
}

// CreateDescribeTrailsRequest creates a request to invoke DescribeTrails API
func CreateDescribeTrailsRequest() (request *DescribeTrailsRequest) {
	request = &DescribeTrailsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Actiontrail", "2020-07-06", "DescribeTrails", "actiontrail", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeTrailsResponse creates a response to parse from DescribeTrails response
func CreateDescribeTrailsResponse() (response *DescribeTrailsResponse) {
	response = &DescribeTrailsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
