//go:build !ignore_autogenerated
// +build !ignore_autogenerated

/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by conversion-gen. DO NOT EDIT.

package v1

import (
	unsafe "unsafe"

	conversion "k8s.io/apimachinery/pkg/conversion"
	runtime "k8s.io/apimachinery/pkg/runtime"
	core "k8s.io/code-generator/examples/apiserver/apis/core"
)

func init() {
	localSchemeBuilder.Register(RegisterConversions)
}

// RegisterConversions adds conversion functions to the given scheme.
// Public to allow building arbitrary schemes.
func RegisterConversions(s *runtime.Scheme) error {
	if err := s.AddGeneratedConversionFunc((*TestType)(nil), (*core.TestType)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_TestType_To_core_TestType(a.(*TestType), b.(*core.TestType), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*core.TestType)(nil), (*TestType)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_core_TestType_To_v1_TestType(a.(*core.TestType), b.(*TestType), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*TestTypeList)(nil), (*core.TestTypeList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_TestTypeList_To_core_TestTypeList(a.(*TestTypeList), b.(*core.TestTypeList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*core.TestTypeList)(nil), (*TestTypeList)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_core_TestTypeList_To_v1_TestTypeList(a.(*core.TestTypeList), b.(*TestTypeList), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*TestTypeStatus)(nil), (*core.TestTypeStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_v1_TestTypeStatus_To_core_TestTypeStatus(a.(*TestTypeStatus), b.(*core.TestTypeStatus), scope)
	}); err != nil {
		return err
	}
	if err := s.AddGeneratedConversionFunc((*core.TestTypeStatus)(nil), (*TestTypeStatus)(nil), func(a, b interface{}, scope conversion.Scope) error {
		return Convert_core_TestTypeStatus_To_v1_TestTypeStatus(a.(*core.TestTypeStatus), b.(*TestTypeStatus), scope)
	}); err != nil {
		return err
	}
	return nil
}

func autoConvert_v1_TestType_To_core_TestType(in *TestType, out *core.TestType, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_v1_TestTypeStatus_To_core_TestTypeStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_v1_TestType_To_core_TestType is an autogenerated conversion function.
func Convert_v1_TestType_To_core_TestType(in *TestType, out *core.TestType, s conversion.Scope) error {
	return autoConvert_v1_TestType_To_core_TestType(in, out, s)
}

func autoConvert_core_TestType_To_v1_TestType(in *core.TestType, out *TestType, s conversion.Scope) error {
	out.ObjectMeta = in.ObjectMeta
	if err := Convert_core_TestTypeStatus_To_v1_TestTypeStatus(&in.Status, &out.Status, s); err != nil {
		return err
	}
	return nil
}

// Convert_core_TestType_To_v1_TestType is an autogenerated conversion function.
func Convert_core_TestType_To_v1_TestType(in *core.TestType, out *TestType, s conversion.Scope) error {
	return autoConvert_core_TestType_To_v1_TestType(in, out, s)
}

func autoConvert_v1_TestTypeList_To_core_TestTypeList(in *TestTypeList, out *core.TestTypeList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	out.Items = *(*[]core.TestType)(unsafe.Pointer(&in.Items))
	return nil
}

// Convert_v1_TestTypeList_To_core_TestTypeList is an autogenerated conversion function.
func Convert_v1_TestTypeList_To_core_TestTypeList(in *TestTypeList, out *core.TestTypeList, s conversion.Scope) error {
	return autoConvert_v1_TestTypeList_To_core_TestTypeList(in, out, s)
}

func autoConvert_core_TestTypeList_To_v1_TestTypeList(in *core.TestTypeList, out *TestTypeList, s conversion.Scope) error {
	out.ListMeta = in.ListMeta
	out.Items = *(*[]TestType)(unsafe.Pointer(&in.Items))
	return nil
}

// Convert_core_TestTypeList_To_v1_TestTypeList is an autogenerated conversion function.
func Convert_core_TestTypeList_To_v1_TestTypeList(in *core.TestTypeList, out *TestTypeList, s conversion.Scope) error {
	return autoConvert_core_TestTypeList_To_v1_TestTypeList(in, out, s)
}

func autoConvert_v1_TestTypeStatus_To_core_TestTypeStatus(in *TestTypeStatus, out *core.TestTypeStatus, s conversion.Scope) error {
	out.Blah = in.Blah
	return nil
}

// Convert_v1_TestTypeStatus_To_core_TestTypeStatus is an autogenerated conversion function.
func Convert_v1_TestTypeStatus_To_core_TestTypeStatus(in *TestTypeStatus, out *core.TestTypeStatus, s conversion.Scope) error {
	return autoConvert_v1_TestTypeStatus_To_core_TestTypeStatus(in, out, s)
}

func autoConvert_core_TestTypeStatus_To_v1_TestTypeStatus(in *core.TestTypeStatus, out *TestTypeStatus, s conversion.Scope) error {
	out.Blah = in.Blah
	return nil
}

// Convert_core_TestTypeStatus_To_v1_TestTypeStatus is an autogenerated conversion function.
func Convert_core_TestTypeStatus_To_v1_TestTypeStatus(in *core.TestTypeStatus, out *TestTypeStatus, s conversion.Scope) error {
	return autoConvert_core_TestTypeStatus_To_v1_TestTypeStatus(in, out, s)
}
