/* $Id: tiff.c,v 1.1.1.1 2003/01/30 12:22:27 hito Exp $ */
/* To do: */
/* o Need code to handle tiff with different orientations */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <setjmp.h>
#include <stdarg.h>
#include <unistd.h>
#include <tiffio.h>
#include "stimg.h"

/* This is a wrapper data structure for TIFFRGBAImage, so that data can be */
/* passed into the callbacks. More elegent, I think, than a bunch of globals */

struct TIFFRGBAImage_Extra
{
	TIFFRGBAImage		rgba;
	tileContigRoutine	put_contig;
	tileSeparateRoutine	put_separate;
	STIMG		*image;
	char			   	pper;
	uint32				num_pixels;
	uint32				py;
};

typedef struct TIFFRGBAImage_Extra TIFFRGBAImage_Extra;

static	void put_contig_and_raster(TIFFRGBAImage*, uint32*,
    uint32, uint32, uint32, uint32, int32, int32, unsigned char*);
static	void put_separate_and_raster(TIFFRGBAImage*, uint32*,
    uint32, uint32, uint32, uint32, int32, int32,
    unsigned char*, unsigned char*, unsigned char*, unsigned char*);
static void raster(TIFFRGBAImage_Extra* img, uint32* raster,
    uint32 x, uint32 y, uint32 w, uint32 h);
STIMG *load_tiff (char *filename, int check);

static void
put_contig_and_raster(TIFFRGBAImage* img, uint32* rast,
    uint32 x, uint32 y, uint32 w, uint32 h,
    int32 fromskew, int32 toskew,
    unsigned char* cp)
{
    (*(((TIFFRGBAImage_Extra *)img)->put_contig))(img, rast, x, y, w, h,
						  fromskew, toskew, cp);
    raster((TIFFRGBAImage_Extra *) img, rast, x, y, w, h);
}

static void
put_separate_and_raster(TIFFRGBAImage* img, uint32* rast,
    uint32 x, uint32 y, uint32 w, uint32 h,
    int32 fromskew, int32 toskew,
    unsigned char* r, unsigned char* g, unsigned char* b, unsigned char* a)
{
    (*(((TIFFRGBAImage_Extra *)img)->put_separate))
		(img, rast, x, y, w, h, fromskew, toskew, r, g, b, a);
    raster((TIFFRGBAImage_Extra *) img, rast, x, y, w, h);
}

/* needs orientation code */

static void
raster(TIFFRGBAImage_Extra *img, uint32* rast,
       uint32 x, uint32 y, uint32 w, uint32 h)
{
   uint32		image_width, image_height;
   uint32	   	*pixel, pixel_value;
   int			i, j, dy, rast_offset, alpha;
   unsigned char *buffer_pixel, *buffer = stimg_get_data(img->image);
   
   image_width = stimg_get_width(img->image);
   image_height = stimg_get_height(img->image);
   alpha = stimg_get_has_alpha(img->image);
   
   dy = h > y ? -1 : y - h; 
   
   /* rast seems to point to the beginning of the last strip processed */
   /* so you need use negative offsets. Bizzare. Someone please check this */
   /* I don't understand why, but that seems to be what's going on. */
   /* libtiff needs better docs! */
   
   for (i = y, rast_offset = 0; i > dy; i--, rast_offset--)
     {
	pixel = rast + (rast_offset * image_width);
	buffer_pixel = buffer + ((((image_height - 1) - i) * image_width) + x) * (3 + alpha);
	
	for (j = 0; j < w; j++)
	  {
	     pixel_value = (*(pixel++));
	     (*(buffer_pixel++)) = TIFFGetR(pixel_value);
	     (*(buffer_pixel++)) = TIFFGetG(pixel_value);
	     (*(buffer_pixel++)) = TIFFGetB(pixel_value);
	     if (alpha)
	       (*(buffer_pixel++)) = TIFFGetA(pixel_value);
	  }
     }
   

}


STIMG * 
load_tiff (char *filename, int check)
{
   TIFF *tif = NULL;
   FILE *file;
   int fd;
   uint16 magic_number;
   TIFFRGBAImage_Extra	rgba_image;
   uint32 *rast = NULL;
   uint32 width, height, num_pixels;
   STIMG *im;
   
   if (filename == NULL)
      return NULL;
   
   file = fopen(filename, "rb");
   
   if (!file)
      return NULL;
   
   fread(&magic_number, sizeof(uint16), 1, file);
   /* Apparently rewind(f) isn't sufficient */
   fseek(file, (long)0, SEEK_SET);
   
   /* Checks if actually tiff file */
   if ((magic_number != TIFF_BIGENDIAN) && (magic_number != TIFF_LITTLEENDIAN)) {
     fclose(file);
     return NULL;
   }
   
   fd = fileno(file);
   fd = dup(fd);
   lseek(fd, (long)0, SEEK_SET);
   fclose(file);
   
   tif = TIFFFdOpen(fd, filename, "r");
   
   if (!tif)
      return NULL;
   
   if ((!TIFFRGBAImageOK(tif, "Cannot be processed by libtiff")) ||
       (!TIFFRGBAImageBegin((TIFFRGBAImage *) &rgba_image, tif, 0, "Error reading tiff"))) {
	TIFFClose(tif);
	return NULL;
   }

   width = rgba_image.rgba.width;
   height = rgba_image.rgba.height;
   rgba_image.num_pixels = num_pixels = width * height;
   rgba_image.pper = rgba_image.py = 0;

   im = stimg_new(width, height, rgba_image.rgba.alpha != EXTRASAMPLE_UNSPECIFIED);
   if (im == NULL || check) {
	TIFFClose(tif);
	return im;
   }     
   rgba_image.image = im;

   rast = (uint32 *) _TIFFmalloc(sizeof(uint32) * num_pixels);
	
   if (!rast)	/* Error checking */ {
     fprintf(stderr, "imlib2-tiffloader: Out of memory\n");
	     
     if (!rast)
       _TIFFfree(rast);

     stimg_delete(im);
	     
     TIFFRGBAImageEnd((TIFFRGBAImage *) &rgba_image);
     TIFFClose(tif);
	     
     return NULL;
   }
	
   if (rgba_image.rgba.put.any == NULL) {
     fprintf(stderr, "imlib2-tiffloader: No put function");
	     
     _TIFFfree(rast);
     stimg_delete(im);
     TIFFRGBAImageEnd((TIFFRGBAImage *) &rgba_image);
     TIFFClose(tif);
	     
     return NULL;
   } else {
     if (rgba_image.rgba.isContig) {
       rgba_image.put_contig = rgba_image.rgba.put.contig;
       rgba_image.rgba.put.contig = put_contig_and_raster;
     } else {
       rgba_image.put_separate = rgba_image.rgba.put.separate;
       rgba_image.rgba.put.separate = put_separate_and_raster;
     }
   }
	
   if (!TIFFRGBAImageGet((TIFFRGBAImage *) &rgba_image, rast, width, height)) {
     _TIFFfree(rast);
     stimg_delete(im);
     TIFFRGBAImageEnd((TIFFRGBAImage *) &rgba_image);
     TIFFClose(tif);
	     
     return NULL;
   }
	
   _TIFFfree(rast);
   
   TIFFRGBAImageEnd((TIFFRGBAImage *) &rgba_image);
   TIFFClose(tif);
   
   return im;
}

STIMG_ANIMATION *
load_animation_tiff(char *file, int check)
{
  STIMG_ANIMATION *animation;
  STIMG *image;

  image = load_tiff(file, check);
  if (image == NULL)
    return NULL;

  animation = stimg_animation_new();
  if (animation == NULL) {
    stimg_delete(image);
    return NULL;
  }

  stimg_animation_add_frame(animation, image, 0, 0, 0, 0);
  return animation;
}

