/*
    SPDX-FileCopyrightText: 2011 Alex Richardson <alex.richardson@gmx.de>
    SPDX-FileCopyrightText: 2016 Aaron Bishop <erroneous@gmail.com>

    SPDX-License-Identifier: LGPL-2.1-only OR LGPL-3.0-only OR LicenseRef-KDE-Accepted-LGPL
*/

#ifndef KASTEN_EBCDICSTRINGDATA_HPP
#define KASTEN_EBCDICSTRINGDATA_HPP

// lib
#include "stringdata.hpp"
// Std
#include <memory>
#include <vector>

namespace Okteta {
class CharCodec;
}

class EbcdicStringData : public StringData
{
public:
    explicit EbcdicStringData(StringDataInformation* parent);
    ~EbcdicStringData() override;

public: // StringData API
    [[nodiscard]]
    QString typeName() const override;
    [[nodiscard]]
    QString charType() const override;
    [[nodiscard]]
    QString stringValue(int row) const override;
    [[nodiscard]]
    QString completeString() const override;
    [[nodiscard]]
    uint count() const override;
    [[nodiscard]]
    BitCount32 size() const override;
    [[nodiscard]]
    BitCount32 sizeAt(uint i) const override;
    [[nodiscard]]
    qint64 read(const Okteta::AbstractByteArrayModel* input, Okteta::Address address, BitCount64 bitsRemaining) override;

private:
    std::vector<quint8> mData;
    const std::unique_ptr<const Okteta::CharCodec> mCodec;
};

#endif // KASTEN_EBCDICSTRINGDATA_HPP
