/***************************************************************************
 *                                                                         *
 *                  (begin: Feb 20 2003)                                   *
 *                                                                         *
 *   Parallel IQPNNI - Important Quartet Puzzle with NNI                   *
 *                                                                         *
 *   Copyright (C) 2005 by Le Sy Vinh, Bui Quang Minh, Arndt von Haeseler  *
 *   Copyright (C) 2003-2004 by Le Sy Vinh, Arndt von Haeseler             *
 *   {vinh,minh}@cs.uni-duesseldorf.de                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <iostream>
#include "ptnls.h"
#include "vec.h"
#include "ali.h"
#include "constant.h"

/*
Vec<Ptn> PtnLs::items_;
int PtnLs::nPtn_;
int PtnLs::nSeq_;
int PtnLs::weightArr_[MAX_NUM_PTN];
int PtnLs::siteArr_[MAX_NUM_PTN];

extern int nto[256];
*/

PtnLs ptnlist;

//the constructor
PtnLs::PtnLs () {}

//this function is used for constructing this class
void PtnLs::doConstructor () {}


//--------------------------------------------------------------------
//set the number of sequences
void PtnLs::setNSeq (int nSeq) {
	nSeq_ = nSeq;
}

//--------------------------------------------------------------------
//get the number of sequences
int PtnLs::getNSeq () {
	return nSeq_;
}

//get the number of patterns
int PtnLs::getNPtn () {
	return nPtn_;
}

double PtnLs::computeUnconstrainedLogL() {
	int nptn = getNPtn();
	double logl = 0.0;
	int nsite = 0, i;
	for (i = 0; i < nptn; i++) nsite += getWeight(i);

	double lognsite = log(nsite);
	for (i = 0; i < nptn; i++)
		logl += (log(getWeight(i)) - lognsite) * getWeight(i);
	return logl;
}

//--------------------------------------------------------------------
//verything is inited here
void PtnLs::init () {}

//--------------------------------------------------------------------
//clean all content of this pattern
void PtnLs::clean () {
	items_.clean ();
}

//--------------------------------------------------------------------
/*
create the order site list of all sites of this alignment
such that Ptn (orderSiteNoLs[0]) < Ptn (orderSiteNoLs[1]) <...
*/
void PtnLs::createOrderSite (Vec<int> *orderSiteNoLs) {
	Vec<int> *oriOrderSiteNoLs_;
	oriOrderSiteNoLs_ = orderSiteNoLs;

	int nSite_ = alignment.getNSite ();

	orderSiteNoLs->set (nSite_, nSite_);
	int countSite_;
	for (countSite_ = 0; countSite_ < nSite_; countSite_ ++)
		(*orderSiteNoLs)[countSite_] = countSite_;


	Vec<int> *newOrderPtnNoLs_;
	newOrderPtnNoLs_ = new Vec<int>;
	newOrderPtnNoLs_->set (nSite_, nSite_);

	Vec<int> nStateLs_ (NUM_CAN_STATE, NUM_CAN_STATE);
	Vec<int> posLs_ (NUM_CAN_STATE, NUM_CAN_STATE);

	int stateNo_, seqNo_, siteNo_;
	int pos_;
	Seq *seq_;
	for (seqNo_ = 0; seqNo_ < nSeq_; seqNo_ ++) {
		seq_ = &alignment.getSeq (seqNo_);
		//create nStateLs_,  nStateLs_['A'] = number of 'A' in this seq
		for (stateNo_ = 0; stateNo_ < NUM_CAN_STATE; stateNo_++)
			nStateLs_[stateNo_] = 0;

		for (siteNo_ = 0; siteNo_ < nSite_; siteNo_ ++) {
			stateNo_ = (*seq_)[siteNo_];
			//cout << stateNo_ << " ";
			nStateLs_[ stateNo_ ] ++;
		}

		//create the position list
		posLs_[0] = 0;
		for (stateNo_ = 1; stateNo_ < NUM_CAN_STATE; stateNo_++)
			posLs_[stateNo_] = posLs_[stateNo_ - 1] + nStateLs_[stateNo_ - 1];

		//sort the ptnNoLs according to this sequences
		for (countSite_ = 0; countSite_ < nSite_; countSite_ ++) {
			siteNo_ = (*orderSiteNoLs)[countSite_];
			stateNo_ = (*seq_)[siteNo_];
			pos_ = posLs_[stateNo_];
			(*newOrderPtnNoLs_)[ pos_ ] = siteNo_;
			posLs_[stateNo_] ++;
		}

		Vec<int> *tmpOrderSiteNoLs_;
		tmpOrderSiteNoLs_ = orderSiteNoLs;
		orderSiteNoLs  = newOrderPtnNoLs_;
		newOrderPtnNoLs_ = tmpOrderSiteNoLs_;
	}

	if (orderSiteNoLs != oriOrderSiteNoLs_)
		(*oriOrderSiteNoLs_) = (*orderSiteNoLs);

	//release the memory of newOrderPtnNoLs_
	if (orderSiteNoLs == oriOrderSiteNoLs_)
		newOrderPtnNoLs_->release ();
	else
		orderSiteNoLs->release ();
}


//--------------------------------------------------------------------
/* create the ptn list for this alignment
all sequences of this alignment are taken into account */
void PtnLs::create () {
	Vec<int> orderSiteNoLs_;
	int nSite_ = alignment.getNSite ();
	nSeq_ = alignment.getNSeq ();

	createOrderSite (&orderSiteNoLs_);

	items_.set (nSite_, 0);
	int firstSiteNo_ = orderSiteNoLs_[0];
	Ptn tmpPtn_;
	alignment.getPtn ( firstSiteNo_, tmpPtn_ );
	tmpPtn_.setSite (firstSiteNo_);
	tmpPtn_.setWeight (1);

	items_ += tmpPtn_;
	nPtn_ = 1;

	alignment.setPtn(firstSiteNo_, 0);
	
	int countSite_, siteNo_;
	for (countSite_ = 1; countSite_ < nSite_; countSite_ ++) {
		siteNo_ = orderSiteNoLs_[countSite_];

		tmpPtn_.clean ();
		alignment.getPtn ( siteNo_, tmpPtn_ );
		tmpPtn_.setSite (siteNo_);
		tmpPtn_.setWeight (1);

		if (items_[nPtn_ - 1] == tmpPtn_)
			items_[nPtn_ - 1].addWeight (1);
		else {
			items_ += tmpPtn_;
			nPtn_++;
		} // end of if

		alignment.setPtn (siteNo_, nPtn_ - 1);
	} //end of for

	// BQM 2006-09-08
	weightArr_.set(nPtn_, nPtn_);
	siteArr_.set(nPtn_, nPtn_);

	for (int countPtn_ = 0; countPtn_ < nPtn_; countPtn_ ++) {
		weightArr_[countPtn_] = items_[countPtn_].getWeight ();
		siteArr_[countPtn_] = items_[countPtn_].getSite ();
		items_[countPtn_].computeConst();
	}
	

} //end of function



//--------------------------------------------------------------------
//return items_[index]
Ptn &PtnLs::getPtn (const int index) {
	return items_[index];
}

//--------------------------------------------------------------------
//return items_[index]
Ptn *PtnLs::getPtnPoi (const int index) {
	return &items_[index];
}


//--------------------------------------------------------------------
//release all meory of this class
void PtnLs::release () {
	int realLimit_ = items_.getLimit ();
	items_.setSize ( realLimit_ );
	for (int count_ = 0; count_ < realLimit_ ; count_ ++)
		items_[count_].release ();
	items_.release ();
}


//--------------------------------------------------------------------
//the destructor
PtnLs::~PtnLs() {
	release ();
//	std::cout << "this is the destructor of PtnLs class " << endl;
}

