/***************************************************************************
 *                                                                         *
 *                  (begin: Feb 20 2003)                                   *
 *                                                                         *
 *   Parallel IQPNNI - Important Quartet Puzzle with NNI                   *
 *                                                                         *
 *   Copyright (C) 2005 by Le Sy Vinh, Bui Quang Minh, Arndt von Haeseler  *
 *   Copyright (C) 2003-2004 by Le Sy Vinh, Arndt von Haeseler             *
 *   {vinh,minh}@cs.uni-duesseldorf.de                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

/***************************************************************************
                          librarr.h  -  description
                             -------------------
    begin                : Thu Apr 24 2003
    copyright            : (C) 2003 by 
    email                : vinh@cs.uni-duesseldorf.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef LIBRARR_H
#define LIBRARR_H
#include "vec.h"
#include "libr.h"
#include "brarr.h"

//this is a collection of liBr of the optUrTree
class LiBrArr {
public:
	//the constructor function
	LiBrArr ();

	//all things are inited here
	void init ();

	//return maximum number of branches in this class
	int getMaxNBr ();

	//copy all information of brArr into this llhBrArr
	void copyBase (BrArr<double> &brArr);

	//return items_[index]
	LiBr &operator[] (const int index);

	//return the current number of liBrs of this array
	int getCurNBr ();

	//release all memmory for this class
	void release ();

	//the destructor function
	virtual ~LiBrArr ();


	/**************************************************************/
private :
	//the current number of likelihood branchs of this class
	int curNBr_;

	//the maximum number of likelihood branchs of this class
	int maxNBr_;

	Vec<LiBr> items_;
}
; //end of class

#endif
