/***************************************************************************
 *                                                                         *
 *   innd.h         (begin: Feb 20 2003)                                   *
 *                                                                         *
 *   Parallel IQPNNI - Important Quartet Puzzle with NNI                   *
 *                                                                         *
 *   Copyright (C) 2005 by Le Sy Vinh, Bui Quang Minh, Arndt von Haeseler  *
 *   Copyright (C) 2003-2004 by Le Sy Vinh, Arndt von Haeseler             *
 *   {vinh,minh}@cs.uni-duesseldorf.de                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef IND_H
#define IND_H

/** 
        the InNd class contains all necessary information
        and methods for an in node being specified more
*/
#include "vec.h"

class InNd {
public :

/** 
        constructor function
*/      
	InNd ();

/** 
        clean all content of this internal node
*/
	void clean ();

/**     
        set the indentical number for this in node
        @param Id the indentical number
*/
	void setId (const int Id);

/**     
        check if this is an external node or not
        @param Id the indentical number of node
        @return 1 if is external node, 0 if is internal node
*/
	int isExNd (int ndNo);


	int getSibNd (int sibNdNo);

/**
        set the maximum number of external nodes
        @param maxNExNd the maximum number of external nodes
*/
	void setMaxNExNd (const int maxNExNd);

/**
        get the maximum number of external nodes
        @return the maximum number of external nodes
*/
	int getMaxNExNd ();

/**
        get the indentical number of the node
*/
	int getId ();

/**
        @return the child node no list of this internal node
*/
	Vec<int> &getChiNd ();

/**
        all things is inited here
*/
	void init ();

/**
        add one neighbour node of this node
        @param neiNdNo indentical number of neighbour node
*/
	void addNeiNd (int neiNdNo);

/**
        add three neighbour nodes for this node
        @param neiNdNo0 indentical number of neighbour node 1
        @param neiNdNo1 indentical number of neighbour node 2
        @param neiNdNo2 indentical number of neighbour node 3
*/
	void addNeiNd (int neiNdNo0, int neiNdNo1, int neiNdNo2);

/**
        add a branch contract this node and one of it's neighbour node
        @param brNo indentical number of branch
*/
	void addBr (int brNo);

/**
        add three branches contact this node and one of it's neighbour node
        @param brNo0 indentical number of branch 1
        @param brNo1 indentical number of branch 2
        @param brNo2 indentical number of branch 3
*/
	void addBr (int brNo0, int brNo1, int brNo2);

	//return the NeiNdLs_
	Vec<int> &getNeiNd ();

	//return the brNoLs_
	Vec<int> &getBr ();

	//return brNoLs_[index];
	int getBr (int index);

/**     
        change one neighbour node of this node
        @param oldNeiNdNo the identical of old neighbour node
        @param newNeiNdNo the identical of new neighbour node
*/
	void changeNeiNd (const int oldNeiNdNo, const int newNeiNdNo);

/**
        change a branch of this node
        @param oldBrNo the identical of old branch
        @param newBrNo the identical of new branch

*/
	void changeBr (const int oldBrNo, const int newBrNo);

/**
        copy an internal node into this internal node
        @param inNd the internal node
*/
	void copy (InNd &inNd);

	//overload operator =. Thus,copy an in node into this in node
	void operator = (InNd & inNd);

	//return neiNdNoLs_[index];
	int getNeiNd (int index);

	//return the neighbor node no list satisfying neiNdNoLs[0] < neiNdNoLs[1] ...
	void getOrderNeiNd (Vec<int> &orderNeiNdNoLs);

	//return the internal node no list satisfying smallNeiNdNo < middleNeiNdNo < greatNeiNdNo
	void getOrderNeiNd (int &smallNeiNdNo, int &middleNeiNdNo, int &greatNeiNdNo);

	/**
		get 2 remain neighbor nodes, and 2 remain branches no of this internal node
	@param existNeiNdNo one neighbour of this node
	@param	remNeiNdNo1 (OUT) the 1st remain neighbour of this node
	@param	remBrNo1 (OUT) the branch between this node and node remNeiNdNo1
	@param	remNeiNdNo2 (OUT) the 2nd remain neighbour of this node
	@param	remBrNo2 (OUT) the branch between this node and node remNeiNdNo2
*/
	void get2RemNeiNdBr (const int existNeiNdNo, int &remNeiNdNo1, int &remBrNo1, int &remNeiNdNo2, int &remBrNo2);

	//get 2 remain branch no of this internal node
	void get2RemBr (const int existBrNo, int &remBrNo1, int &remBrNo2);

	//get 2 remain neighbor nodes no of this internal node
	void get2RemNeiNd (const int existNeiNdNo, int &remNeiNdNo1, int &remNeiNdNo2);

	/*
	order the neighbor node and branch list of this liInNd. 
	The first neighbor is the parent arccording to artInRoot and artExRoot
	*/
	void orderNeiNd (const int parNdNo);

	int findComBr (int neiNdNo);

	/*this function set the memory for this class. This function
	need argument maxNExNd for direction array
	*/
	void setLimit (int maxNExNd);

/**     
        release all memmory for this class
*/
	void release ();

/**     
        destructor function for all releasing before deleting object
*/
	~InNd ();

	/********************************************************************************
	********************************************************************************
	********************************************************************************
	********************************************************************************/
protected :
/**
        the identical number of this node
*/
	int id_;

/**
        the list of idenfitication of neighbour nodes of this node,
*/
	Vec<int> neiNdNoLs_;

/**
        the list no of bres contacting to this node
*/
	Vec<int> brNoLs_;

/**
        the maximum number of external nodes
*/
	int maxNExNd_;


	/********************************************************************************
	********************************************************************************
	********************************************************************************
	********************************************************************************/
private :
};
#endif

