// Protocol Buffers - Google's data interchange format
// Copyright 2008 Google Inc.  All rights reserved.
//
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file or at
// https://developers.google.com/open-source/licenses/bsd
//
// Test schema for proto2 messages.  This test schema is used by:
//
// - conformance tests
//

// LINT: ALLOW_GROUPS

// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/protobuf/test_messages_proto2.proto

package conformance

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"
)

type ForeignEnumProto2 int32

const (
	ForeignEnumProto2_FOREIGN_FOO ForeignEnumProto2 = 0
	ForeignEnumProto2_FOREIGN_BAR ForeignEnumProto2 = 1
	ForeignEnumProto2_FOREIGN_BAZ ForeignEnumProto2 = 2
)

// Enum value maps for ForeignEnumProto2.
var (
	ForeignEnumProto2_name = map[int32]string{
		0: "FOREIGN_FOO",
		1: "FOREIGN_BAR",
		2: "FOREIGN_BAZ",
	}
	ForeignEnumProto2_value = map[string]int32{
		"FOREIGN_FOO": 0,
		"FOREIGN_BAR": 1,
		"FOREIGN_BAZ": 2,
	}
)

func (x ForeignEnumProto2) Enum() *ForeignEnumProto2 {
	p := new(ForeignEnumProto2)
	*p = x
	return p
}

func (x ForeignEnumProto2) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ForeignEnumProto2) Descriptor() protoreflect.EnumDescriptor {
	return file_google_protobuf_test_messages_proto2_proto_enumTypes[0].Descriptor()
}

func (ForeignEnumProto2) Type() protoreflect.EnumType {
	return &file_google_protobuf_test_messages_proto2_proto_enumTypes[0]
}

func (x ForeignEnumProto2) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Do not use.
func (x *ForeignEnumProto2) UnmarshalJSON(b []byte) error {
	num, err := protoimpl.X.UnmarshalJSONEnum(x.Descriptor(), b)
	if err != nil {
		return err
	}
	*x = ForeignEnumProto2(num)
	return nil
}

// Deprecated: Use ForeignEnumProto2.Descriptor instead.
func (ForeignEnumProto2) EnumDescriptor() ([]byte, []int) {
	return file_google_protobuf_test_messages_proto2_proto_rawDescGZIP(), []int{0}
}

type TestAllTypesProto2_NestedEnum int32

const (
	TestAllTypesProto2_FOO TestAllTypesProto2_NestedEnum = 0
	TestAllTypesProto2_BAR TestAllTypesProto2_NestedEnum = 1
	TestAllTypesProto2_BAZ TestAllTypesProto2_NestedEnum = 2
	TestAllTypesProto2_NEG TestAllTypesProto2_NestedEnum = -1 // Intentionally negative.
)

// Enum value maps for TestAllTypesProto2_NestedEnum.
var (
	TestAllTypesProto2_NestedEnum_name = map[int32]string{
		0:  "FOO",
		1:  "BAR",
		2:  "BAZ",
		-1: "NEG",
	}
	TestAllTypesProto2_NestedEnum_value = map[string]int32{
		"FOO": 0,
		"BAR": 1,
		"BAZ": 2,
		"NEG": -1,
	}
)

func (x TestAllTypesProto2_NestedEnum) Enum() *TestAllTypesProto2_NestedEnum {
	p := new(TestAllTypesProto2_NestedEnum)
	*p = x
	return p
}

func (x TestAllTypesProto2_NestedEnum) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (TestAllTypesProto2_NestedEnum) Descriptor() protoreflect.EnumDescriptor {
	return file_google_protobuf_test_messages_proto2_proto_enumTypes[1].Descriptor()
}

func (TestAllTypesProto2_NestedEnum) Type() protoreflect.EnumType {
	return &file_google_protobuf_test_messages_proto2_proto_enumTypes[1]
}

func (x TestAllTypesProto2_NestedEnum) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Do not use.
func (x *TestAllTypesProto2_NestedEnum) UnmarshalJSON(b []byte) error {
	num, err := protoimpl.X.UnmarshalJSONEnum(x.Descriptor(), b)
	if err != nil {
		return err
	}
	*x = TestAllTypesProto2_NestedEnum(num)
	return nil
}

// Deprecated: Use TestAllTypesProto2_NestedEnum.Descriptor instead.
func (TestAllTypesProto2_NestedEnum) EnumDescriptor() ([]byte, []int) {
	return file_google_protobuf_test_messages_proto2_proto_rawDescGZIP(), []int{0, 0}
}

type EnumOnlyProto2_Bool int32

const (
	EnumOnlyProto2_kFalse EnumOnlyProto2_Bool = 0
	EnumOnlyProto2_kTrue  EnumOnlyProto2_Bool = 1
)

// Enum value maps for EnumOnlyProto2_Bool.
var (
	EnumOnlyProto2_Bool_name = map[int32]string{
		0: "kFalse",
		1: "kTrue",
	}
	EnumOnlyProto2_Bool_value = map[string]int32{
		"kFalse": 0,
		"kTrue":  1,
	}
)

func (x EnumOnlyProto2_Bool) Enum() *EnumOnlyProto2_Bool {
	p := new(EnumOnlyProto2_Bool)
	*p = x
	return p
}

func (x EnumOnlyProto2_Bool) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (EnumOnlyProto2_Bool) Descriptor() protoreflect.EnumDescriptor {
	return file_google_protobuf_test_messages_proto2_proto_enumTypes[2].Descriptor()
}

func (EnumOnlyProto2_Bool) Type() protoreflect.EnumType {
	return &file_google_protobuf_test_messages_proto2_proto_enumTypes[2]
}

func (x EnumOnlyProto2_Bool) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Do not use.
func (x *EnumOnlyProto2_Bool) UnmarshalJSON(b []byte) error {
	num, err := protoimpl.X.UnmarshalJSONEnum(x.Descriptor(), b)
	if err != nil {
		return err
	}
	*x = EnumOnlyProto2_Bool(num)
	return nil
}

// Deprecated: Use EnumOnlyProto2_Bool.Descriptor instead.
func (EnumOnlyProto2_Bool) EnumDescriptor() ([]byte, []int) {
	return file_google_protobuf_test_messages_proto2_proto_rawDescGZIP(), []int{5, 0}
}

type TestAllRequiredTypesProto2_NestedEnum int32

const (
	TestAllRequiredTypesProto2_FOO TestAllRequiredTypesProto2_NestedEnum = 0
	TestAllRequiredTypesProto2_BAR TestAllRequiredTypesProto2_NestedEnum = 1
	TestAllRequiredTypesProto2_BAZ TestAllRequiredTypesProto2_NestedEnum = 2
	TestAllRequiredTypesProto2_NEG TestAllRequiredTypesProto2_NestedEnum = -1 // Intentionally negative.
)

// Enum value maps for TestAllRequiredTypesProto2_NestedEnum.
var (
	TestAllRequiredTypesProto2_NestedEnum_name = map[int32]string{
		0:  "FOO",
		1:  "BAR",
		2:  "BAZ",
		-1: "NEG",
	}
	TestAllRequiredTypesProto2_NestedEnum_value = map[string]int32{
		"FOO": 0,
		"BAR": 1,
		"BAZ": 2,
		"NEG": -1,
	}
)

func (x TestAllRequiredTypesProto2_NestedEnum) Enum() *TestAllRequiredTypesProto2_NestedEnum {
	p := new(TestAllRequiredTypesProto2_NestedEnum)
	*p = x
	return p
}

func (x TestAllRequiredTypesProto2_NestedEnum) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (TestAllRequiredTypesProto2_NestedEnum) Descriptor() protoreflect.EnumDescriptor {
	return file_google_protobuf_test_messages_proto2_proto_enumTypes[3].Descriptor()
}

func (TestAllRequiredTypesProto2_NestedEnum) Type() protoreflect.EnumType {
	return &file_google_protobuf_test_messages_proto2_proto_enumTypes[3]
}

func (x TestAllRequiredTypesProto2_NestedEnum) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Do not use.
func (x *TestAllRequiredTypesProto2_NestedEnum) UnmarshalJSON(b []byte) error {
	num, err := protoimpl.X.UnmarshalJSONEnum(x.Descriptor(), b)
	if err != nil {
		return err
	}
	*x = TestAllRequiredTypesProto2_NestedEnum(num)
	return nil
}

// Deprecated: Use TestAllRequiredTypesProto2_NestedEnum.Descriptor instead.
func (TestAllRequiredTypesProto2_NestedEnum) EnumDescriptor() ([]byte, []int) {
	return file_google_protobuf_test_messages_proto2_proto_rawDescGZIP(), []int{8, 0}
}

// This proto includes every type of field in both singular and repeated
// forms.
//
// Also, crucially, all messages and enums in this file are eventually
// submessages of this message.  So for example, a fuzz test of TestAllTypes
// could trigger bugs that occur in any message type in this file.  We verify
// this stays true in a unit test.
type TestAllTypesProto2 struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Singular
	OptionalInt32          *int32                            `protobuf:"varint,1,opt,name=optional_int32,json=optionalInt32" json:"optional_int32,omitempty"`
	OptionalInt64          *int64                            `protobuf:"varint,2,opt,name=optional_int64,json=optionalInt64" json:"optional_int64,omitempty"`
	OptionalUint32         *uint32                           `protobuf:"varint,3,opt,name=optional_uint32,json=optionalUint32" json:"optional_uint32,omitempty"`
	OptionalUint64         *uint64                           `protobuf:"varint,4,opt,name=optional_uint64,json=optionalUint64" json:"optional_uint64,omitempty"`
	OptionalSint32         *int32                            `protobuf:"zigzag32,5,opt,name=optional_sint32,json=optionalSint32" json:"optional_sint32,omitempty"`
	OptionalSint64         *int64                            `protobuf:"zigzag64,6,opt,name=optional_sint64,json=optionalSint64" json:"optional_sint64,omitempty"`
	OptionalFixed32        *uint32                           `protobuf:"fixed32,7,opt,name=optional_fixed32,json=optionalFixed32" json:"optional_fixed32,omitempty"`
	OptionalFixed64        *uint64                           `protobuf:"fixed64,8,opt,name=optional_fixed64,json=optionalFixed64" json:"optional_fixed64,omitempty"`
	OptionalSfixed32       *int32                            `protobuf:"fixed32,9,opt,name=optional_sfixed32,json=optionalSfixed32" json:"optional_sfixed32,omitempty"`
	OptionalSfixed64       *int64                            `protobuf:"fixed64,10,opt,name=optional_sfixed64,json=optionalSfixed64" json:"optional_sfixed64,omitempty"`
	OptionalFloat          *float32                          `protobuf:"fixed32,11,opt,name=optional_float,json=optionalFloat" json:"optional_float,omitempty"`
	OptionalDouble         *float64                          `protobuf:"fixed64,12,opt,name=optional_double,json=optionalDouble" json:"optional_double,omitempty"`
	OptionalBool           *bool                             `protobuf:"varint,13,opt,name=optional_bool,json=optionalBool" json:"optional_bool,omitempty"`
	OptionalString         *string                           `protobuf:"bytes,14,opt,name=optional_string,json=optionalString" json:"optional_string,omitempty"`
	OptionalBytes          []byte                            `protobuf:"bytes,15,opt,name=optional_bytes,json=optionalBytes" json:"optional_bytes,omitempty"`
	OptionalNestedMessage  *TestAllTypesProto2_NestedMessage `protobuf:"bytes,18,opt,name=optional_nested_message,json=optionalNestedMessage" json:"optional_nested_message,omitempty"`
	OptionalForeignMessage *ForeignMessageProto2             `protobuf:"bytes,19,opt,name=optional_foreign_message,json=optionalForeignMessage" json:"optional_foreign_message,omitempty"`
	OptionalNestedEnum     *TestAllTypesProto2_NestedEnum    `protobuf:"varint,21,opt,name=optional_nested_enum,json=optionalNestedEnum,enum=protobuf_test_messages.proto2.TestAllTypesProto2_NestedEnum" json:"optional_nested_enum,omitempty"`
	OptionalForeignEnum    *ForeignEnumProto2                `protobuf:"varint,22,opt,name=optional_foreign_enum,json=optionalForeignEnum,enum=protobuf_test_messages.proto2.ForeignEnumProto2" json:"optional_foreign_enum,omitempty"`
	OptionalStringPiece    *string                           `protobuf:"bytes,24,opt,name=optional_string_piece,json=optionalStringPiece" json:"optional_string_piece,omitempty"`
	OptionalCord           *string                           `protobuf:"bytes,25,opt,name=optional_cord,json=optionalCord" json:"optional_cord,omitempty"`
	RecursiveMessage       *TestAllTypesProto2               `protobuf:"bytes,27,opt,name=recursive_message,json=recursiveMessage" json:"recursive_message,omitempty"`
	// Repeated
	RepeatedInt32          []int32                             `protobuf:"varint,31,rep,name=repeated_int32,json=repeatedInt32" json:"repeated_int32,omitempty"`
	RepeatedInt64          []int64                             `protobuf:"varint,32,rep,name=repeated_int64,json=repeatedInt64" json:"repeated_int64,omitempty"`
	RepeatedUint32         []uint32                            `protobuf:"varint,33,rep,name=repeated_uint32,json=repeatedUint32" json:"repeated_uint32,omitempty"`
	RepeatedUint64         []uint64                            `protobuf:"varint,34,rep,name=repeated_uint64,json=repeatedUint64" json:"repeated_uint64,omitempty"`
	RepeatedSint32         []int32                             `protobuf:"zigzag32,35,rep,name=repeated_sint32,json=repeatedSint32" json:"repeated_sint32,omitempty"`
	RepeatedSint64         []int64                             `protobuf:"zigzag64,36,rep,name=repeated_sint64,json=repeatedSint64" json:"repeated_sint64,omitempty"`
	RepeatedFixed32        []uint32                            `protobuf:"fixed32,37,rep,name=repeated_fixed32,json=repeatedFixed32" json:"repeated_fixed32,omitempty"`
	RepeatedFixed64        []uint64                            `protobuf:"fixed64,38,rep,name=repeated_fixed64,json=repeatedFixed64" json:"repeated_fixed64,omitempty"`
	RepeatedSfixed32       []int32                             `protobuf:"fixed32,39,rep,name=repeated_sfixed32,json=repeatedSfixed32" json:"repeated_sfixed32,omitempty"`
	RepeatedSfixed64       []int64                             `protobuf:"fixed64,40,rep,name=repeated_sfixed64,json=repeatedSfixed64" json:"repeated_sfixed64,omitempty"`
	RepeatedFloat          []float32                           `protobuf:"fixed32,41,rep,name=repeated_float,json=repeatedFloat" json:"repeated_float,omitempty"`
	RepeatedDouble         []float64                           `protobuf:"fixed64,42,rep,name=repeated_double,json=repeatedDouble" json:"repeated_double,omitempty"`
	RepeatedBool           []bool                              `protobuf:"varint,43,rep,name=repeated_bool,json=repeatedBool" json:"repeated_bool,omitempty"`
	RepeatedString         []string                            `protobuf:"bytes,44,rep,name=repeated_string,json=repeatedString" json:"repeated_string,omitempty"`
	RepeatedBytes          [][]byte                            `protobuf:"bytes,45,rep,name=repeated_bytes,json=repeatedBytes" json:"repeated_bytes,omitempty"`
	RepeatedNestedMessage  []*TestAllTypesProto2_NestedMessage `protobuf:"bytes,48,rep,name=repeated_nested_message,json=repeatedNestedMessage" json:"repeated_nested_message,omitempty"`
	RepeatedForeignMessage []*ForeignMessageProto2             `protobuf:"bytes,49,rep,name=repeated_foreign_message,json=repeatedForeignMessage" json:"repeated_foreign_message,omitempty"`
	RepeatedNestedEnum     []TestAllTypesProto2_NestedEnum     `protobuf:"varint,51,rep,name=repeated_nested_enum,json=repeatedNestedEnum,enum=protobuf_test_messages.proto2.TestAllTypesProto2_NestedEnum" json:"repeated_nested_enum,omitempty"`
	RepeatedForeignEnum    []ForeignEnumProto2                 `protobuf:"varint,52,rep,name=repeated_foreign_enum,json=repeatedForeignEnum,enum=protobuf_test_messages.proto2.ForeignEnumProto2" json:"repeated_foreign_enum,omitempty"`
	RepeatedStringPiece    []string                            `protobuf:"bytes,54,rep,name=repeated_string_piece,json=repeatedStringPiece" json:"repeated_string_piece,omitempty"`
	RepeatedCord           []string                            `protobuf:"bytes,55,rep,name=repeated_cord,json=repeatedCord" json:"repeated_cord,omitempty"`
	// Packed
	PackedInt32      []int32                         `protobuf:"varint,75,rep,packed,name=packed_int32,json=packedInt32" json:"packed_int32,omitempty"`
	PackedInt64      []int64                         `protobuf:"varint,76,rep,packed,name=packed_int64,json=packedInt64" json:"packed_int64,omitempty"`
	PackedUint32     []uint32                        `protobuf:"varint,77,rep,packed,name=packed_uint32,json=packedUint32" json:"packed_uint32,omitempty"`
	PackedUint64     []uint64                        `protobuf:"varint,78,rep,packed,name=packed_uint64,json=packedUint64" json:"packed_uint64,omitempty"`
	PackedSint32     []int32                         `protobuf:"zigzag32,79,rep,packed,name=packed_sint32,json=packedSint32" json:"packed_sint32,omitempty"`
	PackedSint64     []int64                         `protobuf:"zigzag64,80,rep,packed,name=packed_sint64,json=packedSint64" json:"packed_sint64,omitempty"`
	PackedFixed32    []uint32                        `protobuf:"fixed32,81,rep,packed,name=packed_fixed32,json=packedFixed32" json:"packed_fixed32,omitempty"`
	PackedFixed64    []uint64                        `protobuf:"fixed64,82,rep,packed,name=packed_fixed64,json=packedFixed64" json:"packed_fixed64,omitempty"`
	PackedSfixed32   []int32                         `protobuf:"fixed32,83,rep,packed,name=packed_sfixed32,json=packedSfixed32" json:"packed_sfixed32,omitempty"`
	PackedSfixed64   []int64                         `protobuf:"fixed64,84,rep,packed,name=packed_sfixed64,json=packedSfixed64" json:"packed_sfixed64,omitempty"`
	PackedFloat      []float32                       `protobuf:"fixed32,85,rep,packed,name=packed_float,json=packedFloat" json:"packed_float,omitempty"`
	PackedDouble     []float64                       `protobuf:"fixed64,86,rep,packed,name=packed_double,json=packedDouble" json:"packed_double,omitempty"`
	PackedBool       []bool                          `protobuf:"varint,87,rep,packed,name=packed_bool,json=packedBool" json:"packed_bool,omitempty"`
	PackedNestedEnum []TestAllTypesProto2_NestedEnum `protobuf:"varint,88,rep,packed,name=packed_nested_enum,json=packedNestedEnum,enum=protobuf_test_messages.proto2.TestAllTypesProto2_NestedEnum" json:"packed_nested_enum,omitempty"`
	// Unpacked
	UnpackedInt32      []int32                         `protobuf:"varint,89,rep,name=unpacked_int32,json=unpackedInt32" json:"unpacked_int32,omitempty"`
	UnpackedInt64      []int64                         `protobuf:"varint,90,rep,name=unpacked_int64,json=unpackedInt64" json:"unpacked_int64,omitempty"`
	UnpackedUint32     []uint32                        `protobuf:"varint,91,rep,name=unpacked_uint32,json=unpackedUint32" json:"unpacked_uint32,omitempty"`
	UnpackedUint64     []uint64                        `protobuf:"varint,92,rep,name=unpacked_uint64,json=unpackedUint64" json:"unpacked_uint64,omitempty"`
	UnpackedSint32     []int32                         `protobuf:"zigzag32,93,rep,name=unpacked_sint32,json=unpackedSint32" json:"unpacked_sint32,omitempty"`
	UnpackedSint64     []int64                         `protobuf:"zigzag64,94,rep,name=unpacked_sint64,json=unpackedSint64" json:"unpacked_sint64,omitempty"`
	UnpackedFixed32    []uint32                        `protobuf:"fixed32,95,rep,name=unpacked_fixed32,json=unpackedFixed32" json:"unpacked_fixed32,omitempty"`
	UnpackedFixed64    []uint64                        `protobuf:"fixed64,96,rep,name=unpacked_fixed64,json=unpackedFixed64" json:"unpacked_fixed64,omitempty"`
	UnpackedSfixed32   []int32                         `protobuf:"fixed32,97,rep,name=unpacked_sfixed32,json=unpackedSfixed32" json:"unpacked_sfixed32,omitempty"`
	UnpackedSfixed64   []int64                         `protobuf:"fixed64,98,rep,name=unpacked_sfixed64,json=unpackedSfixed64" json:"unpacked_sfixed64,omitempty"`
	UnpackedFloat      []float32                       `protobuf:"fixed32,99,rep,name=unpacked_float,json=unpackedFloat" json:"unpacked_float,omitempty"`
	UnpackedDouble     []float64                       `protobuf:"fixed64,100,rep,name=unpacked_double,json=unpackedDouble" json:"unpacked_double,omitempty"`
	UnpackedBool       []bool                          `protobuf:"varint,101,rep,name=unpacked_bool,json=unpackedBool" json:"unpacked_bool,omitempty"`
	UnpackedNestedEnum []TestAllTypesProto2_NestedEnum `protobuf:"varint,102,rep,name=unpacked_nested_enum,json=unpackedNestedEnum,enum=protobuf_test_messages.proto2.TestAllTypesProto2_NestedEnum" json:"unpacked_nested_enum,omitempty"`
	// Map
	MapInt32Int32           map[int32]int32                              `protobuf:"bytes,56,rep,name=map_int32_int32,json=mapInt32Int32" json:"map_int32_int32,omitempty" protobuf_key:"varint,1,opt,name=key" protobuf_val:"varint,2,opt,name=value"`
	MapInt64Int64           map[int64]int64                              `protobuf:"bytes,57,rep,name=map_int64_int64,json=mapInt64Int64" json:"map_int64_int64,omitempty" protobuf_key:"varint,1,opt,name=key" protobuf_val:"varint,2,opt,name=value"`
	MapUint32Uint32         map[uint32]uint32                            `protobuf:"bytes,58,rep,name=map_uint32_uint32,json=mapUint32Uint32" json:"map_uint32_uint32,omitempty" protobuf_key:"varint,1,opt,name=key" protobuf_val:"varint,2,opt,name=value"`
	MapUint64Uint64         map[uint64]uint64                            `protobuf:"bytes,59,rep,name=map_uint64_uint64,json=mapUint64Uint64" json:"map_uint64_uint64,omitempty" protobuf_key:"varint,1,opt,name=key" protobuf_val:"varint,2,opt,name=value"`
	MapSint32Sint32         map[int32]int32                              `protobuf:"bytes,60,rep,name=map_sint32_sint32,json=mapSint32Sint32" json:"map_sint32_sint32,omitempty" protobuf_key:"zigzag32,1,opt,name=key" protobuf_val:"zigzag32,2,opt,name=value"`
	MapSint64Sint64         map[int64]int64                              `protobuf:"bytes,61,rep,name=map_sint64_sint64,json=mapSint64Sint64" json:"map_sint64_sint64,omitempty" protobuf_key:"zigzag64,1,opt,name=key" protobuf_val:"zigzag64,2,opt,name=value"`
	MapFixed32Fixed32       map[uint32]uint32                            `protobuf:"bytes,62,rep,name=map_fixed32_fixed32,json=mapFixed32Fixed32" json:"map_fixed32_fixed32,omitempty" protobuf_key:"fixed32,1,opt,name=key" protobuf_val:"fixed32,2,opt,name=value"`
	MapFixed64Fixed64       map[uint64]uint64                            `protobuf:"bytes,63,rep,name=map_fixed64_fixed64,json=mapFixed64Fixed64" json:"map_fixed64_fixed64,omitempty" protobuf_key:"fixed64,1,opt,name=key" protobuf_val:"fixed64,2,opt,name=value"`
	MapSfixed32Sfixed32     map[int32]int32                              `protobuf:"bytes,64,rep,name=map_sfixed32_sfixed32,json=mapSfixed32Sfixed32" json:"map_sfixed32_sfixed32,omitempty" protobuf_key:"fixed32,1,opt,name=key" protobuf_val:"fixed32,2,opt,name=value"`
	MapSfixed64Sfixed64     map[int64]int64                              `protobuf:"bytes,65,rep,name=map_sfixed64_sfixed64,json=mapSfixed64Sfixed64" json:"map_sfixed64_sfixed64,omitempty" protobuf_key:"fixed64,1,opt,name=key" protobuf_val:"fixed64,2,opt,name=value"`
	MapInt32Bool            map[int32]bool                               `protobuf:"bytes,104,rep,name=map_int32_bool,json=mapInt32Bool" json:"map_int32_bool,omitempty" protobuf_key:"varint,1,opt,name=key" protobuf_val:"varint,2,opt,name=value"`
	MapInt32Float           map[int32]float32                            `protobuf:"bytes,66,rep,name=map_int32_float,json=mapInt32Float" json:"map_int32_float,omitempty" protobuf_key:"varint,1,opt,name=key" protobuf_val:"fixed32,2,opt,name=value"`
	MapInt32Double          map[int32]float64                            `protobuf:"bytes,67,rep,name=map_int32_double,json=mapInt32Double" json:"map_int32_double,omitempty" protobuf_key:"varint,1,opt,name=key" protobuf_val:"fixed64,2,opt,name=value"`
	MapInt32NestedMessage   map[int32]*TestAllTypesProto2_NestedMessage  `protobuf:"bytes,103,rep,name=map_int32_nested_message,json=mapInt32NestedMessage" json:"map_int32_nested_message,omitempty" protobuf_key:"varint,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	MapBoolBool             map[bool]bool                                `protobuf:"bytes,68,rep,name=map_bool_bool,json=mapBoolBool" json:"map_bool_bool,omitempty" protobuf_key:"varint,1,opt,name=key" protobuf_val:"varint,2,opt,name=value"`
	MapStringString         map[string]string                            `protobuf:"bytes,69,rep,name=map_string_string,json=mapStringString" json:"map_string_string,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	MapStringBytes          map[string][]byte                            `protobuf:"bytes,70,rep,name=map_string_bytes,json=mapStringBytes" json:"map_string_bytes,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	MapStringNestedMessage  map[string]*TestAllTypesProto2_NestedMessage `protobuf:"bytes,71,rep,name=map_string_nested_message,json=mapStringNestedMessage" json:"map_string_nested_message,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	MapStringForeignMessage map[string]*ForeignMessageProto2             `protobuf:"bytes,72,rep,name=map_string_foreign_message,json=mapStringForeignMessage" json:"map_string_foreign_message,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	MapStringNestedEnum     map[string]TestAllTypesProto2_NestedEnum     `protobuf:"bytes,73,rep,name=map_string_nested_enum,json=mapStringNestedEnum" json:"map_string_nested_enum,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"varint,2,opt,name=value,enum=protobuf_test_messages.proto2.TestAllTypesProto2_NestedEnum"`
	MapStringForeignEnum    map[string]ForeignEnumProto2                 `protobuf:"bytes,74,rep,name=map_string_foreign_enum,json=mapStringForeignEnum" json:"map_string_foreign_enum,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"varint,2,opt,name=value,enum=protobuf_test_messages.proto2.ForeignEnumProto2"`
	// Types that are valid to be assigned to OneofField:
	//
	//	*TestAllTypesProto2_OneofUint32
	//	*TestAllTypesProto2_OneofNestedMessage
	//	*TestAllTypesProto2_OneofString
	//	*TestAllTypesProto2_OneofBytes
	//	*TestAllTypesProto2_OneofBool
	//	*TestAllTypesProto2_OneofUint64
	//	*TestAllTypesProto2_OneofFloat
	//	*TestAllTypesProto2_OneofDouble
	//	*TestAllTypesProto2_OneofEnum
	OneofField          isTestAllTypesProto2_OneofField         `protobuf_oneof:"oneof_field"`
	Data                *TestAllTypesProto2_Data                `protobuf:"group,201,opt,name=Data,json=data" json:"data,omitempty"`
	Multiwordgroupfield *TestAllTypesProto2_MultiWordGroupField `protobuf:"group,204,opt,name=MultiWordGroupField,json=multiwordgroupfield" json:"multiwordgroupfield,omitempty"`
	// default values
	DefaultInt32    *int32   `protobuf:"varint,241,opt,name=default_int32,json=defaultInt32,def=-123456789" json:"default_int32,omitempty"`
	DefaultInt64    *int64   `protobuf:"varint,242,opt,name=default_int64,json=defaultInt64,def=-9123456789123456789" json:"default_int64,omitempty"`
	DefaultUint32   *uint32  `protobuf:"varint,243,opt,name=default_uint32,json=defaultUint32,def=2123456789" json:"default_uint32,omitempty"`
	DefaultUint64   *uint64  `protobuf:"varint,244,opt,name=default_uint64,json=defaultUint64,def=10123456789123456789" json:"default_uint64,omitempty"`
	DefaultSint32   *int32   `protobuf:"zigzag32,245,opt,name=default_sint32,json=defaultSint32,def=-123456789" json:"default_sint32,omitempty"`
	DefaultSint64   *int64   `protobuf:"zigzag64,246,opt,name=default_sint64,json=defaultSint64,def=-9123456789123456789" json:"default_sint64,omitempty"`
	DefaultFixed32  *uint32  `protobuf:"fixed32,247,opt,name=default_fixed32,json=defaultFixed32,def=2123456789" json:"default_fixed32,omitempty"`
	DefaultFixed64  *uint64  `protobuf:"fixed64,248,opt,name=default_fixed64,json=defaultFixed64,def=10123456789123456789" json:"default_fixed64,omitempty"`
	DefaultSfixed32 *int32   `protobuf:"fixed32,249,opt,name=default_sfixed32,json=defaultSfixed32,def=-123456789" json:"default_sfixed32,omitempty"`
	DefaultSfixed64 *int64   `protobuf:"fixed64,250,opt,name=default_sfixed64,json=defaultSfixed64,def=-9123456789123456789" json:"default_sfixed64,omitempty"`
	DefaultFloat    *float32 `protobuf:"fixed32,251,opt,name=default_float,json=defaultFloat,def=9e+09" json:"default_float,omitempty"`
	DefaultDouble   *float64 `protobuf:"fixed64,252,opt,name=default_double,json=defaultDouble,def=7e+22" json:"default_double,omitempty"`
	DefaultBool     *bool    `protobuf:"varint,253,opt,name=default_bool,json=defaultBool,def=1" json:"default_bool,omitempty"`
	DefaultString   *string  `protobuf:"bytes,254,opt,name=default_string,json=defaultString,def=Rosebud" json:"default_string,omitempty"`
	DefaultBytes    []byte   `protobuf:"bytes,255,opt,name=default_bytes,json=defaultBytes,def=joshua" json:"default_bytes,omitempty"`
	// Test field-name-to-JSON-name convention.
	// (protobuf says names can be any valid C/C++ identifier.)
	Fieldname1        *int32                                `protobuf:"varint,401,opt,name=fieldname1" json:"fieldname1,omitempty"`
	FieldName2        *int32                                `protobuf:"varint,402,opt,name=field_name2,json=fieldName2" json:"field_name2,omitempty"`
	XFieldName3       *int32                                `protobuf:"varint,403,opt,name=_field_name3,json=FieldName3" json:"_field_name3,omitempty"`
	Field_Name4_      *int32                                `protobuf:"varint,404,opt,name=field__name4_,json=fieldName4" json:"field__name4_,omitempty"`
	Field0Name5       *int32                                `protobuf:"varint,405,opt,name=field0name5" json:"field0name5,omitempty"`
	Field_0Name6      *int32                                `protobuf:"varint,406,opt,name=field_0_name6,json=field0Name6" json:"field_0_name6,omitempty"`
	FieldName7        *int32                                `protobuf:"varint,407,opt,name=fieldName7" json:"fieldName7,omitempty"`
	FieldName8        *int32                                `protobuf:"varint,408,opt,name=FieldName8" json:"FieldName8,omitempty"`
	Field_Name9       *int32                                `protobuf:"varint,409,opt,name=field_Name9,json=fieldName9" json:"field_Name9,omitempty"`
	Field_Name10      *int32                                `protobuf:"varint,410,opt,name=Field_Name10,json=FieldName10" json:"Field_Name10,omitempty"`
	FIELD_NAME11      *int32                                `protobuf:"varint,411,opt,name=FIELD_NAME11,json=FIELDNAME11" json:"FIELD_NAME11,omitempty"`
	FIELDName12       *int32                                `protobuf:"varint,412,opt,name=FIELD_name12,json=FIELDName12" json:"FIELD_name12,omitempty"`
	XFieldName13      *int32                                `protobuf:"varint,413,opt,name=__field_name13,json=FieldName13" json:"__field_name13,omitempty"`
	X_FieldName14     *int32                                `protobuf:"varint,414,opt,name=__Field_name14,json=FieldName14" json:"__Field_name14,omitempty"`
	Field_Name15      *int32                                `protobuf:"varint,415,opt,name=field__name15,json=fieldName15" json:"field__name15,omitempty"`
	Field__Name16     *int32                                `protobuf:"varint,416,opt,name=field__Name16,json=fieldName16" json:"field__Name16,omitempty"`
	FieldName17__     *int32                                `protobuf:"varint,417,opt,name=field_name17__,json=fieldName17" json:"field_name17__,omitempty"`
	FieldName18__     *int32                                `protobuf:"varint,418,opt,name=Field_name18__,json=FieldName18" json:"Field_name18__,omitempty"`
	MessageSetCorrect *TestAllTypesProto2_MessageSetCorrect `protobuf:"bytes,500,opt,name=message_set_correct,json=messageSetCorrect" json:"message_set_correct,omitempty"`
	extensionFields   protoimpl.ExtensionFields
	unknownFields     protoimpl.UnknownFields
	sizeCache         protoimpl.SizeCache
}

// Default values for TestAllTypesProto2 fields.
const (
	Default_TestAllTypesProto2_DefaultInt32    = int32(-123456789)
	Default_TestAllTypesProto2_DefaultInt64    = int64(-9123456789123456789)
	Default_TestAllTypesProto2_DefaultUint32   = uint32(2123456789)
	Default_TestAllTypesProto2_DefaultUint64   = uint64(10123456789123456789)
	Default_TestAllTypesProto2_DefaultSint32   = int32(-123456789)
	Default_TestAllTypesProto2_DefaultSint64   = int64(-9123456789123456789)
	Default_TestAllTypesProto2_DefaultFixed32  = uint32(2123456789)
	Default_TestAllTypesProto2_DefaultFixed64  = uint64(10123456789123456789)
	Default_TestAllTypesProto2_DefaultSfixed32 = int32(-123456789)
	Default_TestAllTypesProto2_DefaultSfixed64 = int64(-9123456789123456789)
	Default_TestAllTypesProto2_DefaultFloat    = float32(8.999999488e+09)
	Default_TestAllTypesProto2_DefaultDouble   = float64(7e+22)
	Default_TestAllTypesProto2_DefaultBool     = bool(true)
	Default_TestAllTypesProto2_DefaultString   = string("Rosebud")
)

// Default values for TestAllTypesProto2 fields.
var (
	Default_TestAllTypesProto2_DefaultBytes = []byte("joshua")
)

func (x *TestAllTypesProto2) Reset() {
	*x = TestAllTypesProto2{}
	mi := &file_google_protobuf_test_messages_proto2_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TestAllTypesProto2) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TestAllTypesProto2) ProtoMessage() {}

func (x *TestAllTypesProto2) ProtoReflect() protoreflect.Message {
	mi := &file_google_protobuf_test_messages_proto2_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TestAllTypesProto2.ProtoReflect.Descriptor instead.
func (*TestAllTypesProto2) Descriptor() ([]byte, []int) {
	return file_google_protobuf_test_messages_proto2_proto_rawDescGZIP(), []int{0}
}

func (x *TestAllTypesProto2) GetOptionalInt32() int32 {
	if x != nil && x.OptionalInt32 != nil {
		return *x.OptionalInt32
	}
	return 0
}

func (x *TestAllTypesProto2) GetOptionalInt64() int64 {
	if x != nil && x.OptionalInt64 != nil {
		return *x.OptionalInt64
	}
	return 0
}

func (x *TestAllTypesProto2) GetOptionalUint32() uint32 {
	if x != nil && x.OptionalUint32 != nil {
		return *x.OptionalUint32
	}
	return 0
}

func (x *TestAllTypesProto2) GetOptionalUint64() uint64 {
	if x != nil && x.OptionalUint64 != nil {
		return *x.OptionalUint64
	}
	return 0
}

func (x *TestAllTypesProto2) GetOptionalSint32() int32 {
	if x != nil && x.OptionalSint32 != nil {
		return *x.OptionalSint32
	}
	return 0
}

func (x *TestAllTypesProto2) GetOptionalSint64() int64 {
	if x != nil && x.OptionalSint64 != nil {
		return *x.OptionalSint64
	}
	return 0
}

func (x *TestAllTypesProto2) GetOptionalFixed32() uint32 {
	if x != nil && x.OptionalFixed32 != nil {
		return *x.OptionalFixed32
	}
	return 0
}

func (x *TestAllTypesProto2) GetOptionalFixed64() uint64 {
	if x != nil && x.OptionalFixed64 != nil {
		return *x.OptionalFixed64
	}
	return 0
}

func (x *TestAllTypesProto2) GetOptionalSfixed32() int32 {
	if x != nil && x.OptionalSfixed32 != nil {
		return *x.OptionalSfixed32
	}
	return 0
}

func (x *TestAllTypesProto2) GetOptionalSfixed64() int64 {
	if x != nil && x.OptionalSfixed64 != nil {
		return *x.OptionalSfixed64
	}
	return 0
}

func (x *TestAllTypesProto2) GetOptionalFloat() float32 {
	if x != nil && x.OptionalFloat != nil {
		return *x.OptionalFloat
	}
	return 0
}

func (x *TestAllTypesProto2) GetOptionalDouble() float64 {
	if x != nil && x.OptionalDouble != nil {
		return *x.OptionalDouble
	}
	return 0
}

func (x *TestAllTypesProto2) GetOptionalBool() bool {
	if x != nil && x.OptionalBool != nil {
		return *x.OptionalBool
	}
	return false
}

func (x *TestAllTypesProto2) GetOptionalString() string {
	if x != nil && x.OptionalString != nil {
		return *x.OptionalString
	}
	return ""
}

func (x *TestAllTypesProto2) GetOptionalBytes() []byte {
	if x != nil {
		return x.OptionalBytes
	}
	return nil
}

func (x *TestAllTypesProto2) GetOptionalNestedMessage() *TestAllTypesProto2_NestedMessage {
	if x != nil {
		return x.OptionalNestedMessage
	}
	return nil
}

func (x *TestAllTypesProto2) GetOptionalForeignMessage() *ForeignMessageProto2 {
	if x != nil {
		return x.OptionalForeignMessage
	}
	return nil
}

func (x *TestAllTypesProto2) GetOptionalNestedEnum() TestAllTypesProto2_NestedEnum {
	if x != nil && x.OptionalNestedEnum != nil {
		return *x.OptionalNestedEnum
	}
	return TestAllTypesProto2_FOO
}

func (x *TestAllTypesProto2) GetOptionalForeignEnum() ForeignEnumProto2 {
	if x != nil && x.OptionalForeignEnum != nil {
		return *x.OptionalForeignEnum
	}
	return ForeignEnumProto2_FOREIGN_FOO
}

func (x *TestAllTypesProto2) GetOptionalStringPiece() string {
	if x != nil && x.OptionalStringPiece != nil {
		return *x.OptionalStringPiece
	}
	return ""
}

func (x *TestAllTypesProto2) GetOptionalCord() string {
	if x != nil && x.OptionalCord != nil {
		return *x.OptionalCord
	}
	return ""
}

func (x *TestAllTypesProto2) GetRecursiveMessage() *TestAllTypesProto2 {
	if x != nil {
		return x.RecursiveMessage
	}
	return nil
}

func (x *TestAllTypesProto2) GetRepeatedInt32() []int32 {
	if x != nil {
		return x.RepeatedInt32
	}
	return nil
}

func (x *TestAllTypesProto2) GetRepeatedInt64() []int64 {
	if x != nil {
		return x.RepeatedInt64
	}
	return nil
}

func (x *TestAllTypesProto2) GetRepeatedUint32() []uint32 {
	if x != nil {
		return x.RepeatedUint32
	}
	return nil
}

func (x *TestAllTypesProto2) GetRepeatedUint64() []uint64 {
	if x != nil {
		return x.RepeatedUint64
	}
	return nil
}

func (x *TestAllTypesProto2) GetRepeatedSint32() []int32 {
	if x != nil {
		return x.RepeatedSint32
	}
	return nil
}

func (x *TestAllTypesProto2) GetRepeatedSint64() []int64 {
	if x != nil {
		return x.RepeatedSint64
	}
	return nil
}

func (x *TestAllTypesProto2) GetRepeatedFixed32() []uint32 {
	if x != nil {
		return x.RepeatedFixed32
	}
	return nil
}

func (x *TestAllTypesProto2) GetRepeatedFixed64() []uint64 {
	if x != nil {
		return x.RepeatedFixed64
	}
	return nil
}

func (x *TestAllTypesProto2) GetRepeatedSfixed32() []int32 {
	if x != nil {
		return x.RepeatedSfixed32
	}
	return nil
}

func (x *TestAllTypesProto2) GetRepeatedSfixed64() []int64 {
	if x != nil {
		return x.RepeatedSfixed64
	}
	return nil
}

func (x *TestAllTypesProto2) GetRepeatedFloat() []float32 {
	if x != nil {
		return x.RepeatedFloat
	}
	return nil
}

func (x *TestAllTypesProto2) GetRepeatedDouble() []float64 {
	if x != nil {
		return x.RepeatedDouble
	}
	return nil
}

func (x *TestAllTypesProto2) GetRepeatedBool() []bool {
	if x != nil {
		return x.RepeatedBool
	}
	return nil
}

func (x *TestAllTypesProto2) GetRepeatedString() []string {
	if x != nil {
		return x.RepeatedString
	}
	return nil
}

func (x *TestAllTypesProto2) GetRepeatedBytes() [][]byte {
	if x != nil {
		return x.RepeatedBytes
	}
	return nil
}

func (x *TestAllTypesProto2) GetRepeatedNestedMessage() []*TestAllTypesProto2_NestedMessage {
	if x != nil {
		return x.RepeatedNestedMessage
	}
	return nil
}

func (x *TestAllTypesProto2) GetRepeatedForeignMessage() []*ForeignMessageProto2 {
	if x != nil {
		return x.RepeatedForeignMessage
	}
	return nil
}

func (x *TestAllTypesProto2) GetRepeatedNestedEnum() []TestAllTypesProto2_NestedEnum {
	if x != nil {
		return x.RepeatedNestedEnum
	}
	return nil
}

func (x *TestAllTypesProto2) GetRepeatedForeignEnum() []ForeignEnumProto2 {
	if x != nil {
		return x.RepeatedForeignEnum
	}
	return nil
}

func (x *TestAllTypesProto2) GetRepeatedStringPiece() []string {
	if x != nil {
		return x.RepeatedStringPiece
	}
	return nil
}

func (x *TestAllTypesProto2) GetRepeatedCord() []string {
	if x != nil {
		return x.RepeatedCord
	}
	return nil
}

func (x *TestAllTypesProto2) GetPackedInt32() []int32 {
	if x != nil {
		return x.PackedInt32
	}
	return nil
}

func (x *TestAllTypesProto2) GetPackedInt64() []int64 {
	if x != nil {
		return x.PackedInt64
	}
	return nil
}

func (x *TestAllTypesProto2) GetPackedUint32() []uint32 {
	if x != nil {
		return x.PackedUint32
	}
	return nil
}

func (x *TestAllTypesProto2) GetPackedUint64() []uint64 {
	if x != nil {
		return x.PackedUint64
	}
	return nil
}

func (x *TestAllTypesProto2) GetPackedSint32() []int32 {
	if x != nil {
		return x.PackedSint32
	}
	return nil
}

func (x *TestAllTypesProto2) GetPackedSint64() []int64 {
	if x != nil {
		return x.PackedSint64
	}
	return nil
}

func (x *TestAllTypesProto2) GetPackedFixed32() []uint32 {
	if x != nil {
		return x.PackedFixed32
	}
	return nil
}

func (x *TestAllTypesProto2) GetPackedFixed64() []uint64 {
	if x != nil {
		return x.PackedFixed64
	}
	return nil
}

func (x *TestAllTypesProto2) GetPackedSfixed32() []int32 {
	if x != nil {
		return x.PackedSfixed32
	}
	return nil
}

func (x *TestAllTypesProto2) GetPackedSfixed64() []int64 {
	if x != nil {
		return x.PackedSfixed64
	}
	return nil
}

func (x *TestAllTypesProto2) GetPackedFloat() []float32 {
	if x != nil {
		return x.PackedFloat
	}
	return nil
}

func (x *TestAllTypesProto2) GetPackedDouble() []float64 {
	if x != nil {
		return x.PackedDouble
	}
	return nil
}

func (x *TestAllTypesProto2) GetPackedBool() []bool {
	if x != nil {
		return x.PackedBool
	}
	return nil
}

func (x *TestAllTypesProto2) GetPackedNestedEnum() []TestAllTypesProto2_NestedEnum {
	if x != nil {
		return x.PackedNestedEnum
	}
	return nil
}

func (x *TestAllTypesProto2) GetUnpackedInt32() []int32 {
	if x != nil {
		return x.UnpackedInt32
	}
	return nil
}

func (x *TestAllTypesProto2) GetUnpackedInt64() []int64 {
	if x != nil {
		return x.UnpackedInt64
	}
	return nil
}

func (x *TestAllTypesProto2) GetUnpackedUint32() []uint32 {
	if x != nil {
		return x.UnpackedUint32
	}
	return nil
}

func (x *TestAllTypesProto2) GetUnpackedUint64() []uint64 {
	if x != nil {
		return x.UnpackedUint64
	}
	return nil
}

func (x *TestAllTypesProto2) GetUnpackedSint32() []int32 {
	if x != nil {
		return x.UnpackedSint32
	}
	return nil
}

func (x *TestAllTypesProto2) GetUnpackedSint64() []int64 {
	if x != nil {
		return x.UnpackedSint64
	}
	return nil
}

func (x *TestAllTypesProto2) GetUnpackedFixed32() []uint32 {
	if x != nil {
		return x.UnpackedFixed32
	}
	return nil
}

func (x *TestAllTypesProto2) GetUnpackedFixed64() []uint64 {
	if x != nil {
		return x.UnpackedFixed64
	}
	return nil
}

func (x *TestAllTypesProto2) GetUnpackedSfixed32() []int32 {
	if x != nil {
		return x.UnpackedSfixed32
	}
	return nil
}

func (x *TestAllTypesProto2) GetUnpackedSfixed64() []int64 {
	if x != nil {
		return x.UnpackedSfixed64
	}
	return nil
}

func (x *TestAllTypesProto2) GetUnpackedFloat() []float32 {
	if x != nil {
		return x.UnpackedFloat
	}
	return nil
}

func (x *TestAllTypesProto2) GetUnpackedDouble() []float64 {
	if x != nil {
		return x.UnpackedDouble
	}
	return nil
}

func (x *TestAllTypesProto2) GetUnpackedBool() []bool {
	if x != nil {
		return x.UnpackedBool
	}
	return nil
}

func (x *TestAllTypesProto2) GetUnpackedNestedEnum() []TestAllTypesProto2_NestedEnum {
	if x != nil {
		return x.UnpackedNestedEnum
	}
	return nil
}

func (x *TestAllTypesProto2) GetMapInt32Int32() map[int32]int32 {
	if x != nil {
		return x.MapInt32Int32
	}
	return nil
}

func (x *TestAllTypesProto2) GetMapInt64Int64() map[int64]int64 {
	if x != nil {
		return x.MapInt64Int64
	}
	return nil
}

func (x *TestAllTypesProto2) GetMapUint32Uint32() map[uint32]uint32 {
	if x != nil {
		return x.MapUint32Uint32
	}
	return nil
}

func (x *TestAllTypesProto2) GetMapUint64Uint64() map[uint64]uint64 {
	if x != nil {
		return x.MapUint64Uint64
	}
	return nil
}

func (x *TestAllTypesProto2) GetMapSint32Sint32() map[int32]int32 {
	if x != nil {
		return x.MapSint32Sint32
	}
	return nil
}

func (x *TestAllTypesProto2) GetMapSint64Sint64() map[int64]int64 {
	if x != nil {
		return x.MapSint64Sint64
	}
	return nil
}

func (x *TestAllTypesProto2) GetMapFixed32Fixed32() map[uint32]uint32 {
	if x != nil {
		return x.MapFixed32Fixed32
	}
	return nil
}

func (x *TestAllTypesProto2) GetMapFixed64Fixed64() map[uint64]uint64 {
	if x != nil {
		return x.MapFixed64Fixed64
	}
	return nil
}

func (x *TestAllTypesProto2) GetMapSfixed32Sfixed32() map[int32]int32 {
	if x != nil {
		return x.MapSfixed32Sfixed32
	}
	return nil
}

func (x *TestAllTypesProto2) GetMapSfixed64Sfixed64() map[int64]int64 {
	if x != nil {
		return x.MapSfixed64Sfixed64
	}
	return nil
}

func (x *TestAllTypesProto2) GetMapInt32Bool() map[int32]bool {
	if x != nil {
		return x.MapInt32Bool
	}
	return nil
}

func (x *TestAllTypesProto2) GetMapInt32Float() map[int32]float32 {
	if x != nil {
		return x.MapInt32Float
	}
	return nil
}

func (x *TestAllTypesProto2) GetMapInt32Double() map[int32]float64 {
	if x != nil {
		return x.MapInt32Double
	}
	return nil
}

func (x *TestAllTypesProto2) GetMapInt32NestedMessage() map[int32]*TestAllTypesProto2_NestedMessage {
	if x != nil {
		return x.MapInt32NestedMessage
	}
	return nil
}

func (x *TestAllTypesProto2) GetMapBoolBool() map[bool]bool {
	if x != nil {
		return x.MapBoolBool
	}
	return nil
}

func (x *TestAllTypesProto2) GetMapStringString() map[string]string {
	if x != nil {
		return x.MapStringString
	}
	return nil
}

func (x *TestAllTypesProto2) GetMapStringBytes() map[string][]byte {
	if x != nil {
		return x.MapStringBytes
	}
	return nil
}

func (x *TestAllTypesProto2) GetMapStringNestedMessage() map[string]*TestAllTypesProto2_NestedMessage {
	if x != nil {
		return x.MapStringNestedMessage
	}
	return nil
}

func (x *TestAllTypesProto2) GetMapStringForeignMessage() map[string]*ForeignMessageProto2 {
	if x != nil {
		return x.MapStringForeignMessage
	}
	return nil
}

func (x *TestAllTypesProto2) GetMapStringNestedEnum() map[string]TestAllTypesProto2_NestedEnum {
	if x != nil {
		return x.MapStringNestedEnum
	}
	return nil
}

func (x *TestAllTypesProto2) GetMapStringForeignEnum() map[string]ForeignEnumProto2 {
	if x != nil {
		return x.MapStringForeignEnum
	}
	return nil
}

func (x *TestAllTypesProto2) GetOneofField() isTestAllTypesProto2_OneofField {
	if x != nil {
		return x.OneofField
	}
	return nil
}

func (x *TestAllTypesProto2) GetOneofUint32() uint32 {
	if x != nil {
		if x, ok := x.OneofField.(*TestAllTypesProto2_OneofUint32); ok {
			return x.OneofUint32
		}
	}
	return 0
}

func (x *TestAllTypesProto2) GetOneofNestedMessage() *TestAllTypesProto2_NestedMessage {
	if x != nil {
		if x, ok := x.OneofField.(*TestAllTypesProto2_OneofNestedMessage); ok {
			return x.OneofNestedMessage
		}
	}
	return nil
}

func (x *TestAllTypesProto2) GetOneofString() string {
	if x != nil {
		if x, ok := x.OneofField.(*TestAllTypesProto2_OneofString); ok {
			return x.OneofString
		}
	}
	return ""
}

func (x *TestAllTypesProto2) GetOneofBytes() []byte {
	if x != nil {
		if x, ok := x.OneofField.(*TestAllTypesProto2_OneofBytes); ok {
			return x.OneofBytes
		}
	}
	return nil
}

func (x *TestAllTypesProto2) GetOneofBool() bool {
	if x != nil {
		if x, ok := x.OneofField.(*TestAllTypesProto2_OneofBool); ok {
			return x.OneofBool
		}
	}
	return false
}

func (x *TestAllTypesProto2) GetOneofUint64() uint64 {
	if x != nil {
		if x, ok := x.OneofField.(*TestAllTypesProto2_OneofUint64); ok {
			return x.OneofUint64
		}
	}
	return 0
}

func (x *TestAllTypesProto2) GetOneofFloat() float32 {
	if x != nil {
		if x, ok := x.OneofField.(*TestAllTypesProto2_OneofFloat); ok {
			return x.OneofFloat
		}
	}
	return 0
}

func (x *TestAllTypesProto2) GetOneofDouble() float64 {
	if x != nil {
		if x, ok := x.OneofField.(*TestAllTypesProto2_OneofDouble); ok {
			return x.OneofDouble
		}
	}
	return 0
}

func (x *TestAllTypesProto2) GetOneofEnum() TestAllTypesProto2_NestedEnum {
	if x != nil {
		if x, ok := x.OneofField.(*TestAllTypesProto2_OneofEnum); ok {
			return x.OneofEnum
		}
	}
	return TestAllTypesProto2_FOO
}

func (x *TestAllTypesProto2) GetData() *TestAllTypesProto2_Data {
	if x != nil {
		return x.Data
	}
	return nil
}

func (x *TestAllTypesProto2) GetMultiwordgroupfield() *TestAllTypesProto2_MultiWordGroupField {
	if x != nil {
		return x.Multiwordgroupfield
	}
	return nil
}

func (x *TestAllTypesProto2) GetDefaultInt32() int32 {
	if x != nil && x.DefaultInt32 != nil {
		return *x.DefaultInt32
	}
	return Default_TestAllTypesProto2_DefaultInt32
}

func (x *TestAllTypesProto2) GetDefaultInt64() int64 {
	if x != nil && x.DefaultInt64 != nil {
		return *x.DefaultInt64
	}
	return Default_TestAllTypesProto2_DefaultInt64
}

func (x *TestAllTypesProto2) GetDefaultUint32() uint32 {
	if x != nil && x.DefaultUint32 != nil {
		return *x.DefaultUint32
	}
	return Default_TestAllTypesProto2_DefaultUint32
}

func (x *TestAllTypesProto2) GetDefaultUint64() uint64 {
	if x != nil && x.DefaultUint64 != nil {
		return *x.DefaultUint64
	}
	return Default_TestAllTypesProto2_DefaultUint64
}

func (x *TestAllTypesProto2) GetDefaultSint32() int32 {
	if x != nil && x.DefaultSint32 != nil {
		return *x.DefaultSint32
	}
	return Default_TestAllTypesProto2_DefaultSint32
}

func (x *TestAllTypesProto2) GetDefaultSint64() int64 {
	if x != nil && x.DefaultSint64 != nil {
		return *x.DefaultSint64
	}
	return Default_TestAllTypesProto2_DefaultSint64
}

func (x *TestAllTypesProto2) GetDefaultFixed32() uint32 {
	if x != nil && x.DefaultFixed32 != nil {
		return *x.DefaultFixed32
	}
	return Default_TestAllTypesProto2_DefaultFixed32
}

func (x *TestAllTypesProto2) GetDefaultFixed64() uint64 {
	if x != nil && x.DefaultFixed64 != nil {
		return *x.DefaultFixed64
	}
	return Default_TestAllTypesProto2_DefaultFixed64
}

func (x *TestAllTypesProto2) GetDefaultSfixed32() int32 {
	if x != nil && x.DefaultSfixed32 != nil {
		return *x.DefaultSfixed32
	}
	return Default_TestAllTypesProto2_DefaultSfixed32
}

func (x *TestAllTypesProto2) GetDefaultSfixed64() int64 {
	if x != nil && x.DefaultSfixed64 != nil {
		return *x.DefaultSfixed64
	}
	return Default_TestAllTypesProto2_DefaultSfixed64
}

func (x *TestAllTypesProto2) GetDefaultFloat() float32 {
	if x != nil && x.DefaultFloat != nil {
		return *x.DefaultFloat
	}
	return Default_TestAllTypesProto2_DefaultFloat
}

func (x *TestAllTypesProto2) GetDefaultDouble() float64 {
	if x != nil && x.DefaultDouble != nil {
		return *x.DefaultDouble
	}
	return Default_TestAllTypesProto2_DefaultDouble
}

func (x *TestAllTypesProto2) GetDefaultBool() bool {
	if x != nil && x.DefaultBool != nil {
		return *x.DefaultBool
	}
	return Default_TestAllTypesProto2_DefaultBool
}

func (x *TestAllTypesProto2) GetDefaultString() string {
	if x != nil && x.DefaultString != nil {
		return *x.DefaultString
	}
	return Default_TestAllTypesProto2_DefaultString
}

func (x *TestAllTypesProto2) GetDefaultBytes() []byte {
	if x != nil && x.DefaultBytes != nil {
		return x.DefaultBytes
	}
	return append([]byte(nil), Default_TestAllTypesProto2_DefaultBytes...)
}

func (x *TestAllTypesProto2) GetFieldname1() int32 {
	if x != nil && x.Fieldname1 != nil {
		return *x.Fieldname1
	}
	return 0
}

func (x *TestAllTypesProto2) GetFieldName2() int32 {
	if x != nil && x.FieldName2 != nil {
		return *x.FieldName2
	}
	return 0
}

func (x *TestAllTypesProto2) GetXFieldName3() int32 {
	if x != nil && x.XFieldName3 != nil {
		return *x.XFieldName3
	}
	return 0
}

func (x *TestAllTypesProto2) GetField_Name4_() int32 {
	if x != nil && x.Field_Name4_ != nil {
		return *x.Field_Name4_
	}
	return 0
}

func (x *TestAllTypesProto2) GetField0Name5() int32 {
	if x != nil && x.Field0Name5 != nil {
		return *x.Field0Name5
	}
	return 0
}

func (x *TestAllTypesProto2) GetField_0Name6() int32 {
	if x != nil && x.Field_0Name6 != nil {
		return *x.Field_0Name6
	}
	return 0
}

func (x *TestAllTypesProto2) GetFieldName7() int32 {
	if x != nil && x.FieldName7 != nil {
		return *x.FieldName7
	}
	return 0
}

func (x *TestAllTypesProto2) GetFieldName8() int32 {
	if x != nil && x.FieldName8 != nil {
		return *x.FieldName8
	}
	return 0
}

func (x *TestAllTypesProto2) GetField_Name9() int32 {
	if x != nil && x.Field_Name9 != nil {
		return *x.Field_Name9
	}
	return 0
}

func (x *TestAllTypesProto2) GetField_Name10() int32 {
	if x != nil && x.Field_Name10 != nil {
		return *x.Field_Name10
	}
	return 0
}

func (x *TestAllTypesProto2) GetFIELD_NAME11() int32 {
	if x != nil && x.FIELD_NAME11 != nil {
		return *x.FIELD_NAME11
	}
	return 0
}

func (x *TestAllTypesProto2) GetFIELDName12() int32 {
	if x != nil && x.FIELDName12 != nil {
		return *x.FIELDName12
	}
	return 0
}

func (x *TestAllTypesProto2) GetXFieldName13() int32 {
	if x != nil && x.XFieldName13 != nil {
		return *x.XFieldName13
	}
	return 0
}

func (x *TestAllTypesProto2) GetX_FieldName14() int32 {
	if x != nil && x.X_FieldName14 != nil {
		return *x.X_FieldName14
	}
	return 0
}

func (x *TestAllTypesProto2) GetField_Name15() int32 {
	if x != nil && x.Field_Name15 != nil {
		return *x.Field_Name15
	}
	return 0
}

func (x *TestAllTypesProto2) GetField__Name16() int32 {
	if x != nil && x.Field__Name16 != nil {
		return *x.Field__Name16
	}
	return 0
}

func (x *TestAllTypesProto2) GetFieldName17__() int32 {
	if x != nil && x.FieldName17__ != nil {
		return *x.FieldName17__
	}
	return 0
}

func (x *TestAllTypesProto2) GetFieldName18__() int32 {
	if x != nil && x.FieldName18__ != nil {
		return *x.FieldName18__
	}
	return 0
}

func (x *TestAllTypesProto2) GetMessageSetCorrect() *TestAllTypesProto2_MessageSetCorrect {
	if x != nil {
		return x.MessageSetCorrect
	}
	return nil
}

type isTestAllTypesProto2_OneofField interface {
	isTestAllTypesProto2_OneofField()
}

type TestAllTypesProto2_OneofUint32 struct {
	OneofUint32 uint32 `protobuf:"varint,111,opt,name=oneof_uint32,json=oneofUint32,oneof"`
}

type TestAllTypesProto2_OneofNestedMessage struct {
	OneofNestedMessage *TestAllTypesProto2_NestedMessage `protobuf:"bytes,112,opt,name=oneof_nested_message,json=oneofNestedMessage,oneof"`
}

type TestAllTypesProto2_OneofString struct {
	OneofString string `protobuf:"bytes,113,opt,name=oneof_string,json=oneofString,oneof"`
}

type TestAllTypesProto2_OneofBytes struct {
	OneofBytes []byte `protobuf:"bytes,114,opt,name=oneof_bytes,json=oneofBytes,oneof"`
}

type TestAllTypesProto2_OneofBool struct {
	OneofBool bool `protobuf:"varint,115,opt,name=oneof_bool,json=oneofBool,oneof"`
}

type TestAllTypesProto2_OneofUint64 struct {
	OneofUint64 uint64 `protobuf:"varint,116,opt,name=oneof_uint64,json=oneofUint64,oneof"`
}

type TestAllTypesProto2_OneofFloat struct {
	OneofFloat float32 `protobuf:"fixed32,117,opt,name=oneof_float,json=oneofFloat,oneof"`
}

type TestAllTypesProto2_OneofDouble struct {
	OneofDouble float64 `protobuf:"fixed64,118,opt,name=oneof_double,json=oneofDouble,oneof"`
}

type TestAllTypesProto2_OneofEnum struct {
	OneofEnum TestAllTypesProto2_NestedEnum `protobuf:"varint,119,opt,name=oneof_enum,json=oneofEnum,enum=protobuf_test_messages.proto2.TestAllTypesProto2_NestedEnum,oneof"`
}

func (*TestAllTypesProto2_OneofUint32) isTestAllTypesProto2_OneofField() {}

func (*TestAllTypesProto2_OneofNestedMessage) isTestAllTypesProto2_OneofField() {}

func (*TestAllTypesProto2_OneofString) isTestAllTypesProto2_OneofField() {}

func (*TestAllTypesProto2_OneofBytes) isTestAllTypesProto2_OneofField() {}

func (*TestAllTypesProto2_OneofBool) isTestAllTypesProto2_OneofField() {}

func (*TestAllTypesProto2_OneofUint64) isTestAllTypesProto2_OneofField() {}

func (*TestAllTypesProto2_OneofFloat) isTestAllTypesProto2_OneofField() {}

func (*TestAllTypesProto2_OneofDouble) isTestAllTypesProto2_OneofField() {}

func (*TestAllTypesProto2_OneofEnum) isTestAllTypesProto2_OneofField() {}

type ForeignMessageProto2 struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	C             *int32                 `protobuf:"varint,1,opt,name=c" json:"c,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ForeignMessageProto2) Reset() {
	*x = ForeignMessageProto2{}
	mi := &file_google_protobuf_test_messages_proto2_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ForeignMessageProto2) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ForeignMessageProto2) ProtoMessage() {}

func (x *ForeignMessageProto2) ProtoReflect() protoreflect.Message {
	mi := &file_google_protobuf_test_messages_proto2_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ForeignMessageProto2.ProtoReflect.Descriptor instead.
func (*ForeignMessageProto2) Descriptor() ([]byte, []int) {
	return file_google_protobuf_test_messages_proto2_proto_rawDescGZIP(), []int{1}
}

func (x *ForeignMessageProto2) GetC() int32 {
	if x != nil && x.C != nil {
		return *x.C
	}
	return 0
}

type GroupField struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	GroupInt32    *int32                 `protobuf:"varint,122,opt,name=group_int32,json=groupInt32" json:"group_int32,omitempty"`
	GroupUint32   *uint32                `protobuf:"varint,123,opt,name=group_uint32,json=groupUint32" json:"group_uint32,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *GroupField) Reset() {
	*x = GroupField{}
	mi := &file_google_protobuf_test_messages_proto2_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GroupField) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GroupField) ProtoMessage() {}

func (x *GroupField) ProtoReflect() protoreflect.Message {
	mi := &file_google_protobuf_test_messages_proto2_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GroupField.ProtoReflect.Descriptor instead.
func (*GroupField) Descriptor() ([]byte, []int) {
	return file_google_protobuf_test_messages_proto2_proto_rawDescGZIP(), []int{2}
}

func (x *GroupField) GetGroupInt32() int32 {
	if x != nil && x.GroupInt32 != nil {
		return *x.GroupInt32
	}
	return 0
}

func (x *GroupField) GetGroupUint32() uint32 {
	if x != nil && x.GroupUint32 != nil {
		return *x.GroupUint32
	}
	return 0
}

type UnknownToTestAllTypes struct {
	state          protoimpl.MessageState               `protogen:"open.v1"`
	OptionalInt32  *int32                               `protobuf:"varint,1001,opt,name=optional_int32,json=optionalInt32" json:"optional_int32,omitempty"`
	OptionalString *string                              `protobuf:"bytes,1002,opt,name=optional_string,json=optionalString" json:"optional_string,omitempty"`
	NestedMessage  *ForeignMessageProto2                `protobuf:"bytes,1003,opt,name=nested_message,json=nestedMessage" json:"nested_message,omitempty"`
	Optionalgroup  *UnknownToTestAllTypes_OptionalGroup `protobuf:"group,1004,opt,name=OptionalGroup,json=optionalgroup" json:"optionalgroup,omitempty"`
	OptionalBool   *bool                                `protobuf:"varint,1006,opt,name=optional_bool,json=optionalBool" json:"optional_bool,omitempty"`
	RepeatedInt32  []int32                              `protobuf:"varint,1011,rep,name=repeated_int32,json=repeatedInt32" json:"repeated_int32,omitempty"`
	unknownFields  protoimpl.UnknownFields
	sizeCache      protoimpl.SizeCache
}

func (x *UnknownToTestAllTypes) Reset() {
	*x = UnknownToTestAllTypes{}
	mi := &file_google_protobuf_test_messages_proto2_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UnknownToTestAllTypes) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UnknownToTestAllTypes) ProtoMessage() {}

func (x *UnknownToTestAllTypes) ProtoReflect() protoreflect.Message {
	mi := &file_google_protobuf_test_messages_proto2_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UnknownToTestAllTypes.ProtoReflect.Descriptor instead.
func (*UnknownToTestAllTypes) Descriptor() ([]byte, []int) {
	return file_google_protobuf_test_messages_proto2_proto_rawDescGZIP(), []int{3}
}

func (x *UnknownToTestAllTypes) GetOptionalInt32() int32 {
	if x != nil && x.OptionalInt32 != nil {
		return *x.OptionalInt32
	}
	return 0
}

func (x *UnknownToTestAllTypes) GetOptionalString() string {
	if x != nil && x.OptionalString != nil {
		return *x.OptionalString
	}
	return ""
}

func (x *UnknownToTestAllTypes) GetNestedMessage() *ForeignMessageProto2 {
	if x != nil {
		return x.NestedMessage
	}
	return nil
}

func (x *UnknownToTestAllTypes) GetOptionalgroup() *UnknownToTestAllTypes_OptionalGroup {
	if x != nil {
		return x.Optionalgroup
	}
	return nil
}

func (x *UnknownToTestAllTypes) GetOptionalBool() bool {
	if x != nil && x.OptionalBool != nil {
		return *x.OptionalBool
	}
	return false
}

func (x *UnknownToTestAllTypes) GetRepeatedInt32() []int32 {
	if x != nil {
		return x.RepeatedInt32
	}
	return nil
}

type NullHypothesisProto2 struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *NullHypothesisProto2) Reset() {
	*x = NullHypothesisProto2{}
	mi := &file_google_protobuf_test_messages_proto2_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *NullHypothesisProto2) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NullHypothesisProto2) ProtoMessage() {}

func (x *NullHypothesisProto2) ProtoReflect() protoreflect.Message {
	mi := &file_google_protobuf_test_messages_proto2_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NullHypothesisProto2.ProtoReflect.Descriptor instead.
func (*NullHypothesisProto2) Descriptor() ([]byte, []int) {
	return file_google_protobuf_test_messages_proto2_proto_rawDescGZIP(), []int{4}
}

type EnumOnlyProto2 struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *EnumOnlyProto2) Reset() {
	*x = EnumOnlyProto2{}
	mi := &file_google_protobuf_test_messages_proto2_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *EnumOnlyProto2) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EnumOnlyProto2) ProtoMessage() {}

func (x *EnumOnlyProto2) ProtoReflect() protoreflect.Message {
	mi := &file_google_protobuf_test_messages_proto2_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EnumOnlyProto2.ProtoReflect.Descriptor instead.
func (*EnumOnlyProto2) Descriptor() ([]byte, []int) {
	return file_google_protobuf_test_messages_proto2_proto_rawDescGZIP(), []int{5}
}

type OneStringProto2 struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Data          *string                `protobuf:"bytes,1,opt,name=data" json:"data,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *OneStringProto2) Reset() {
	*x = OneStringProto2{}
	mi := &file_google_protobuf_test_messages_proto2_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OneStringProto2) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OneStringProto2) ProtoMessage() {}

func (x *OneStringProto2) ProtoReflect() protoreflect.Message {
	mi := &file_google_protobuf_test_messages_proto2_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OneStringProto2.ProtoReflect.Descriptor instead.
func (*OneStringProto2) Descriptor() ([]byte, []int) {
	return file_google_protobuf_test_messages_proto2_proto_rawDescGZIP(), []int{6}
}

func (x *OneStringProto2) GetData() string {
	if x != nil && x.Data != nil {
		return *x.Data
	}
	return ""
}

type ProtoWithKeywords struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Inline        *int32                 `protobuf:"varint,1,opt,name=inline" json:"inline,omitempty"`
	Concept       *string                `protobuf:"bytes,2,opt,name=concept" json:"concept,omitempty"`
	Requires      []string               `protobuf:"bytes,3,rep,name=requires" json:"requires,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ProtoWithKeywords) Reset() {
	*x = ProtoWithKeywords{}
	mi := &file_google_protobuf_test_messages_proto2_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ProtoWithKeywords) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProtoWithKeywords) ProtoMessage() {}

func (x *ProtoWithKeywords) ProtoReflect() protoreflect.Message {
	mi := &file_google_protobuf_test_messages_proto2_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProtoWithKeywords.ProtoReflect.Descriptor instead.
func (*ProtoWithKeywords) Descriptor() ([]byte, []int) {
	return file_google_protobuf_test_messages_proto2_proto_rawDescGZIP(), []int{7}
}

func (x *ProtoWithKeywords) GetInline() int32 {
	if x != nil && x.Inline != nil {
		return *x.Inline
	}
	return 0
}

func (x *ProtoWithKeywords) GetConcept() string {
	if x != nil && x.Concept != nil {
		return *x.Concept
	}
	return ""
}

func (x *ProtoWithKeywords) GetRequires() []string {
	if x != nil {
		return x.Requires
	}
	return nil
}

type TestAllRequiredTypesProto2 struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Singular
	RequiredInt32            *int32                                    `protobuf:"varint,1,req,name=required_int32,json=requiredInt32" json:"required_int32,omitempty"`
	RequiredInt64            *int64                                    `protobuf:"varint,2,req,name=required_int64,json=requiredInt64" json:"required_int64,omitempty"`
	RequiredUint32           *uint32                                   `protobuf:"varint,3,req,name=required_uint32,json=requiredUint32" json:"required_uint32,omitempty"`
	RequiredUint64           *uint64                                   `protobuf:"varint,4,req,name=required_uint64,json=requiredUint64" json:"required_uint64,omitempty"`
	RequiredSint32           *int32                                    `protobuf:"zigzag32,5,req,name=required_sint32,json=requiredSint32" json:"required_sint32,omitempty"`
	RequiredSint64           *int64                                    `protobuf:"zigzag64,6,req,name=required_sint64,json=requiredSint64" json:"required_sint64,omitempty"`
	RequiredFixed32          *uint32                                   `protobuf:"fixed32,7,req,name=required_fixed32,json=requiredFixed32" json:"required_fixed32,omitempty"`
	RequiredFixed64          *uint64                                   `protobuf:"fixed64,8,req,name=required_fixed64,json=requiredFixed64" json:"required_fixed64,omitempty"`
	RequiredSfixed32         *int32                                    `protobuf:"fixed32,9,req,name=required_sfixed32,json=requiredSfixed32" json:"required_sfixed32,omitempty"`
	RequiredSfixed64         *int64                                    `protobuf:"fixed64,10,req,name=required_sfixed64,json=requiredSfixed64" json:"required_sfixed64,omitempty"`
	RequiredFloat            *float32                                  `protobuf:"fixed32,11,req,name=required_float,json=requiredFloat" json:"required_float,omitempty"`
	RequiredDouble           *float64                                  `protobuf:"fixed64,12,req,name=required_double,json=requiredDouble" json:"required_double,omitempty"`
	RequiredBool             *bool                                     `protobuf:"varint,13,req,name=required_bool,json=requiredBool" json:"required_bool,omitempty"`
	RequiredString           *string                                   `protobuf:"bytes,14,req,name=required_string,json=requiredString" json:"required_string,omitempty"`
	RequiredBytes            []byte                                    `protobuf:"bytes,15,req,name=required_bytes,json=requiredBytes" json:"required_bytes,omitempty"`
	RequiredNestedMessage    *TestAllRequiredTypesProto2_NestedMessage `protobuf:"bytes,18,req,name=required_nested_message,json=requiredNestedMessage" json:"required_nested_message,omitempty"`
	RequiredForeignMessage   *ForeignMessageProto2                     `protobuf:"bytes,19,req,name=required_foreign_message,json=requiredForeignMessage" json:"required_foreign_message,omitempty"`
	RequiredNestedEnum       *TestAllRequiredTypesProto2_NestedEnum    `protobuf:"varint,21,req,name=required_nested_enum,json=requiredNestedEnum,enum=protobuf_test_messages.proto2.TestAllRequiredTypesProto2_NestedEnum" json:"required_nested_enum,omitempty"`
	RequiredForeignEnum      *ForeignEnumProto2                        `protobuf:"varint,22,req,name=required_foreign_enum,json=requiredForeignEnum,enum=protobuf_test_messages.proto2.ForeignEnumProto2" json:"required_foreign_enum,omitempty"`
	RequiredStringPiece      *string                                   `protobuf:"bytes,24,req,name=required_string_piece,json=requiredStringPiece" json:"required_string_piece,omitempty"`
	RequiredCord             *string                                   `protobuf:"bytes,25,req,name=required_cord,json=requiredCord" json:"required_cord,omitempty"`
	RecursiveMessage         *TestAllRequiredTypesProto2               `protobuf:"bytes,27,req,name=recursive_message,json=recursiveMessage" json:"recursive_message,omitempty"`
	OptionalRecursiveMessage *TestAllRequiredTypesProto2               `protobuf:"bytes,28,opt,name=optional_recursive_message,json=optionalRecursiveMessage" json:"optional_recursive_message,omitempty"`
	Data                     *TestAllRequiredTypesProto2_Data          `protobuf:"group,201,req,name=Data,json=data" json:"data,omitempty"`
	// default values
	DefaultInt32    *int32   `protobuf:"varint,241,req,name=default_int32,json=defaultInt32,def=-123456789" json:"default_int32,omitempty"`
	DefaultInt64    *int64   `protobuf:"varint,242,req,name=default_int64,json=defaultInt64,def=-9123456789123456789" json:"default_int64,omitempty"`
	DefaultUint32   *uint32  `protobuf:"varint,243,req,name=default_uint32,json=defaultUint32,def=2123456789" json:"default_uint32,omitempty"`
	DefaultUint64   *uint64  `protobuf:"varint,244,req,name=default_uint64,json=defaultUint64,def=10123456789123456789" json:"default_uint64,omitempty"`
	DefaultSint32   *int32   `protobuf:"zigzag32,245,req,name=default_sint32,json=defaultSint32,def=-123456789" json:"default_sint32,omitempty"`
	DefaultSint64   *int64   `protobuf:"zigzag64,246,req,name=default_sint64,json=defaultSint64,def=-9123456789123456789" json:"default_sint64,omitempty"`
	DefaultFixed32  *uint32  `protobuf:"fixed32,247,req,name=default_fixed32,json=defaultFixed32,def=2123456789" json:"default_fixed32,omitempty"`
	DefaultFixed64  *uint64  `protobuf:"fixed64,248,req,name=default_fixed64,json=defaultFixed64,def=10123456789123456789" json:"default_fixed64,omitempty"`
	DefaultSfixed32 *int32   `protobuf:"fixed32,249,req,name=default_sfixed32,json=defaultSfixed32,def=-123456789" json:"default_sfixed32,omitempty"`
	DefaultSfixed64 *int64   `protobuf:"fixed64,250,req,name=default_sfixed64,json=defaultSfixed64,def=-9123456789123456789" json:"default_sfixed64,omitempty"`
	DefaultFloat    *float32 `protobuf:"fixed32,251,req,name=default_float,json=defaultFloat,def=9e+09" json:"default_float,omitempty"`
	DefaultDouble   *float64 `protobuf:"fixed64,252,req,name=default_double,json=defaultDouble,def=7e+22" json:"default_double,omitempty"`
	DefaultBool     *bool    `protobuf:"varint,253,req,name=default_bool,json=defaultBool,def=1" json:"default_bool,omitempty"`
	DefaultString   *string  `protobuf:"bytes,254,req,name=default_string,json=defaultString,def=Rosebud" json:"default_string,omitempty"`
	DefaultBytes    []byte   `protobuf:"bytes,255,req,name=default_bytes,json=defaultBytes,def=joshua" json:"default_bytes,omitempty"`
	extensionFields protoimpl.ExtensionFields
	unknownFields   protoimpl.UnknownFields
	sizeCache       protoimpl.SizeCache
}

// Default values for TestAllRequiredTypesProto2 fields.
const (
	Default_TestAllRequiredTypesProto2_DefaultInt32    = int32(-123456789)
	Default_TestAllRequiredTypesProto2_DefaultInt64    = int64(-9123456789123456789)
	Default_TestAllRequiredTypesProto2_DefaultUint32   = uint32(2123456789)
	Default_TestAllRequiredTypesProto2_DefaultUint64   = uint64(10123456789123456789)
	Default_TestAllRequiredTypesProto2_DefaultSint32   = int32(-123456789)
	Default_TestAllRequiredTypesProto2_DefaultSint64   = int64(-9123456789123456789)
	Default_TestAllRequiredTypesProto2_DefaultFixed32  = uint32(2123456789)
	Default_TestAllRequiredTypesProto2_DefaultFixed64  = uint64(10123456789123456789)
	Default_TestAllRequiredTypesProto2_DefaultSfixed32 = int32(-123456789)
	Default_TestAllRequiredTypesProto2_DefaultSfixed64 = int64(-9123456789123456789)
	Default_TestAllRequiredTypesProto2_DefaultFloat    = float32(8.999999488e+09)
	Default_TestAllRequiredTypesProto2_DefaultDouble   = float64(7e+22)
	Default_TestAllRequiredTypesProto2_DefaultBool     = bool(true)
	Default_TestAllRequiredTypesProto2_DefaultString   = string("Rosebud")
)

// Default values for TestAllRequiredTypesProto2 fields.
var (
	Default_TestAllRequiredTypesProto2_DefaultBytes = []byte("joshua")
)

func (x *TestAllRequiredTypesProto2) Reset() {
	*x = TestAllRequiredTypesProto2{}
	mi := &file_google_protobuf_test_messages_proto2_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TestAllRequiredTypesProto2) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TestAllRequiredTypesProto2) ProtoMessage() {}

func (x *TestAllRequiredTypesProto2) ProtoReflect() protoreflect.Message {
	mi := &file_google_protobuf_test_messages_proto2_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TestAllRequiredTypesProto2.ProtoReflect.Descriptor instead.
func (*TestAllRequiredTypesProto2) Descriptor() ([]byte, []int) {
	return file_google_protobuf_test_messages_proto2_proto_rawDescGZIP(), []int{8}
}

func (x *TestAllRequiredTypesProto2) GetRequiredInt32() int32 {
	if x != nil && x.RequiredInt32 != nil {
		return *x.RequiredInt32
	}
	return 0
}

func (x *TestAllRequiredTypesProto2) GetRequiredInt64() int64 {
	if x != nil && x.RequiredInt64 != nil {
		return *x.RequiredInt64
	}
	return 0
}

func (x *TestAllRequiredTypesProto2) GetRequiredUint32() uint32 {
	if x != nil && x.RequiredUint32 != nil {
		return *x.RequiredUint32
	}
	return 0
}

func (x *TestAllRequiredTypesProto2) GetRequiredUint64() uint64 {
	if x != nil && x.RequiredUint64 != nil {
		return *x.RequiredUint64
	}
	return 0
}

func (x *TestAllRequiredTypesProto2) GetRequiredSint32() int32 {
	if x != nil && x.RequiredSint32 != nil {
		return *x.RequiredSint32
	}
	return 0
}

func (x *TestAllRequiredTypesProto2) GetRequiredSint64() int64 {
	if x != nil && x.RequiredSint64 != nil {
		return *x.RequiredSint64
	}
	return 0
}

func (x *TestAllRequiredTypesProto2) GetRequiredFixed32() uint32 {
	if x != nil && x.RequiredFixed32 != nil {
		return *x.RequiredFixed32
	}
	return 0
}

func (x *TestAllRequiredTypesProto2) GetRequiredFixed64() uint64 {
	if x != nil && x.RequiredFixed64 != nil {
		return *x.RequiredFixed64
	}
	return 0
}

func (x *TestAllRequiredTypesProto2) GetRequiredSfixed32() int32 {
	if x != nil && x.RequiredSfixed32 != nil {
		return *x.RequiredSfixed32
	}
	return 0
}

func (x *TestAllRequiredTypesProto2) GetRequiredSfixed64() int64 {
	if x != nil && x.RequiredSfixed64 != nil {
		return *x.RequiredSfixed64
	}
	return 0
}

func (x *TestAllRequiredTypesProto2) GetRequiredFloat() float32 {
	if x != nil && x.RequiredFloat != nil {
		return *x.RequiredFloat
	}
	return 0
}

func (x *TestAllRequiredTypesProto2) GetRequiredDouble() float64 {
	if x != nil && x.RequiredDouble != nil {
		return *x.RequiredDouble
	}
	return 0
}

func (x *TestAllRequiredTypesProto2) GetRequiredBool() bool {
	if x != nil && x.RequiredBool != nil {
		return *x.RequiredBool
	}
	return false
}

func (x *TestAllRequiredTypesProto2) GetRequiredString() string {
	if x != nil && x.RequiredString != nil {
		return *x.RequiredString
	}
	return ""
}

func (x *TestAllRequiredTypesProto2) GetRequiredBytes() []byte {
	if x != nil {
		return x.RequiredBytes
	}
	return nil
}

func (x *TestAllRequiredTypesProto2) GetRequiredNestedMessage() *TestAllRequiredTypesProto2_NestedMessage {
	if x != nil {
		return x.RequiredNestedMessage
	}
	return nil
}

func (x *TestAllRequiredTypesProto2) GetRequiredForeignMessage() *ForeignMessageProto2 {
	if x != nil {
		return x.RequiredForeignMessage
	}
	return nil
}

func (x *TestAllRequiredTypesProto2) GetRequiredNestedEnum() TestAllRequiredTypesProto2_NestedEnum {
	if x != nil && x.RequiredNestedEnum != nil {
		return *x.RequiredNestedEnum
	}
	return TestAllRequiredTypesProto2_FOO
}

func (x *TestAllRequiredTypesProto2) GetRequiredForeignEnum() ForeignEnumProto2 {
	if x != nil && x.RequiredForeignEnum != nil {
		return *x.RequiredForeignEnum
	}
	return ForeignEnumProto2_FOREIGN_FOO
}

func (x *TestAllRequiredTypesProto2) GetRequiredStringPiece() string {
	if x != nil && x.RequiredStringPiece != nil {
		return *x.RequiredStringPiece
	}
	return ""
}

func (x *TestAllRequiredTypesProto2) GetRequiredCord() string {
	if x != nil && x.RequiredCord != nil {
		return *x.RequiredCord
	}
	return ""
}

func (x *TestAllRequiredTypesProto2) GetRecursiveMessage() *TestAllRequiredTypesProto2 {
	if x != nil {
		return x.RecursiveMessage
	}
	return nil
}

func (x *TestAllRequiredTypesProto2) GetOptionalRecursiveMessage() *TestAllRequiredTypesProto2 {
	if x != nil {
		return x.OptionalRecursiveMessage
	}
	return nil
}

func (x *TestAllRequiredTypesProto2) GetData() *TestAllRequiredTypesProto2_Data {
	if x != nil {
		return x.Data
	}
	return nil
}

func (x *TestAllRequiredTypesProto2) GetDefaultInt32() int32 {
	if x != nil && x.DefaultInt32 != nil {
		return *x.DefaultInt32
	}
	return Default_TestAllRequiredTypesProto2_DefaultInt32
}

func (x *TestAllRequiredTypesProto2) GetDefaultInt64() int64 {
	if x != nil && x.DefaultInt64 != nil {
		return *x.DefaultInt64
	}
	return Default_TestAllRequiredTypesProto2_DefaultInt64
}

func (x *TestAllRequiredTypesProto2) GetDefaultUint32() uint32 {
	if x != nil && x.DefaultUint32 != nil {
		return *x.DefaultUint32
	}
	return Default_TestAllRequiredTypesProto2_DefaultUint32
}

func (x *TestAllRequiredTypesProto2) GetDefaultUint64() uint64 {
	if x != nil && x.DefaultUint64 != nil {
		return *x.DefaultUint64
	}
	return Default_TestAllRequiredTypesProto2_DefaultUint64
}

func (x *TestAllRequiredTypesProto2) GetDefaultSint32() int32 {
	if x != nil && x.DefaultSint32 != nil {
		return *x.DefaultSint32
	}
	return Default_TestAllRequiredTypesProto2_DefaultSint32
}

func (x *TestAllRequiredTypesProto2) GetDefaultSint64() int64 {
	if x != nil && x.DefaultSint64 != nil {
		return *x.DefaultSint64
	}
	return Default_TestAllRequiredTypesProto2_DefaultSint64
}

func (x *TestAllRequiredTypesProto2) GetDefaultFixed32() uint32 {
	if x != nil && x.DefaultFixed32 != nil {
		return *x.DefaultFixed32
	}
	return Default_TestAllRequiredTypesProto2_DefaultFixed32
}

func (x *TestAllRequiredTypesProto2) GetDefaultFixed64() uint64 {
	if x != nil && x.DefaultFixed64 != nil {
		return *x.DefaultFixed64
	}
	return Default_TestAllRequiredTypesProto2_DefaultFixed64
}

func (x *TestAllRequiredTypesProto2) GetDefaultSfixed32() int32 {
	if x != nil && x.DefaultSfixed32 != nil {
		return *x.DefaultSfixed32
	}
	return Default_TestAllRequiredTypesProto2_DefaultSfixed32
}

func (x *TestAllRequiredTypesProto2) GetDefaultSfixed64() int64 {
	if x != nil && x.DefaultSfixed64 != nil {
		return *x.DefaultSfixed64
	}
	return Default_TestAllRequiredTypesProto2_DefaultSfixed64
}

func (x *TestAllRequiredTypesProto2) GetDefaultFloat() float32 {
	if x != nil && x.DefaultFloat != nil {
		return *x.DefaultFloat
	}
	return Default_TestAllRequiredTypesProto2_DefaultFloat
}

func (x *TestAllRequiredTypesProto2) GetDefaultDouble() float64 {
	if x != nil && x.DefaultDouble != nil {
		return *x.DefaultDouble
	}
	return Default_TestAllRequiredTypesProto2_DefaultDouble
}

func (x *TestAllRequiredTypesProto2) GetDefaultBool() bool {
	if x != nil && x.DefaultBool != nil {
		return *x.DefaultBool
	}
	return Default_TestAllRequiredTypesProto2_DefaultBool
}

func (x *TestAllRequiredTypesProto2) GetDefaultString() string {
	if x != nil && x.DefaultString != nil {
		return *x.DefaultString
	}
	return Default_TestAllRequiredTypesProto2_DefaultString
}

func (x *TestAllRequiredTypesProto2) GetDefaultBytes() []byte {
	if x != nil && x.DefaultBytes != nil {
		return x.DefaultBytes
	}
	return append([]byte(nil), Default_TestAllRequiredTypesProto2_DefaultBytes...)
}

type TestLargeOneof struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Types that are valid to be assigned to LargeOneof:
	//
	//	*TestLargeOneof_A1_
	//	*TestLargeOneof_A2_
	//	*TestLargeOneof_A3_
	//	*TestLargeOneof_A4_
	//	*TestLargeOneof_A5_
	LargeOneof    isTestLargeOneof_LargeOneof `protobuf_oneof:"large_oneof"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *TestLargeOneof) Reset() {
	*x = TestLargeOneof{}
	mi := &file_google_protobuf_test_messages_proto2_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TestLargeOneof) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TestLargeOneof) ProtoMessage() {}

func (x *TestLargeOneof) ProtoReflect() protoreflect.Message {
	mi := &file_google_protobuf_test_messages_proto2_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TestLargeOneof.ProtoReflect.Descriptor instead.
func (*TestLargeOneof) Descriptor() ([]byte, []int) {
	return file_google_protobuf_test_messages_proto2_proto_rawDescGZIP(), []int{9}
}

func (x *TestLargeOneof) GetLargeOneof() isTestLargeOneof_LargeOneof {
	if x != nil {
		return x.LargeOneof
	}
	return nil
}

func (x *TestLargeOneof) GetA1() *TestLargeOneof_A1 {
	if x != nil {
		if x, ok := x.LargeOneof.(*TestLargeOneof_A1_); ok {
			return x.A1
		}
	}
	return nil
}

func (x *TestLargeOneof) GetA2() *TestLargeOneof_A2 {
	if x != nil {
		if x, ok := x.LargeOneof.(*TestLargeOneof_A2_); ok {
			return x.A2
		}
	}
	return nil
}

func (x *TestLargeOneof) GetA3() *TestLargeOneof_A3 {
	if x != nil {
		if x, ok := x.LargeOneof.(*TestLargeOneof_A3_); ok {
			return x.A3
		}
	}
	return nil
}

func (x *TestLargeOneof) GetA4() *TestLargeOneof_A4 {
	if x != nil {
		if x, ok := x.LargeOneof.(*TestLargeOneof_A4_); ok {
			return x.A4
		}
	}
	return nil
}

func (x *TestLargeOneof) GetA5() *TestLargeOneof_A5 {
	if x != nil {
		if x, ok := x.LargeOneof.(*TestLargeOneof_A5_); ok {
			return x.A5
		}
	}
	return nil
}

type isTestLargeOneof_LargeOneof interface {
	isTestLargeOneof_LargeOneof()
}

type TestLargeOneof_A1_ struct {
	A1 *TestLargeOneof_A1 `protobuf:"bytes,1,opt,name=a1,oneof"`
}

type TestLargeOneof_A2_ struct {
	A2 *TestLargeOneof_A2 `protobuf:"bytes,2,opt,name=a2,oneof"`
}

type TestLargeOneof_A3_ struct {
	A3 *TestLargeOneof_A3 `protobuf:"bytes,3,opt,name=a3,oneof"`
}

type TestLargeOneof_A4_ struct {
	A4 *TestLargeOneof_A4 `protobuf:"bytes,4,opt,name=a4,oneof"`
}

type TestLargeOneof_A5_ struct {
	A5 *TestLargeOneof_A5 `protobuf:"bytes,5,opt,name=a5,oneof"`
}

func (*TestLargeOneof_A1_) isTestLargeOneof_LargeOneof() {}

func (*TestLargeOneof_A2_) isTestLargeOneof_LargeOneof() {}

func (*TestLargeOneof_A3_) isTestLargeOneof_LargeOneof() {}

func (*TestLargeOneof_A4_) isTestLargeOneof_LargeOneof() {}

func (*TestLargeOneof_A5_) isTestLargeOneof_LargeOneof() {}

type TestAllTypesProto2_NestedMessage struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	A             *int32                 `protobuf:"varint,1,opt,name=a" json:"a,omitempty"`
	Corecursive   *TestAllTypesProto2    `protobuf:"bytes,2,opt,name=corecursive" json:"corecursive,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *TestAllTypesProto2_NestedMessage) Reset() {
	*x = TestAllTypesProto2_NestedMessage{}
	mi := &file_google_protobuf_test_messages_proto2_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TestAllTypesProto2_NestedMessage) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TestAllTypesProto2_NestedMessage) ProtoMessage() {}

func (x *TestAllTypesProto2_NestedMessage) ProtoReflect() protoreflect.Message {
	mi := &file_google_protobuf_test_messages_proto2_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TestAllTypesProto2_NestedMessage.ProtoReflect.Descriptor instead.
func (*TestAllTypesProto2_NestedMessage) Descriptor() ([]byte, []int) {
	return file_google_protobuf_test_messages_proto2_proto_rawDescGZIP(), []int{0, 0}
}

func (x *TestAllTypesProto2_NestedMessage) GetA() int32 {
	if x != nil && x.A != nil {
		return *x.A
	}
	return 0
}

func (x *TestAllTypesProto2_NestedMessage) GetCorecursive() *TestAllTypesProto2 {
	if x != nil {
		return x.Corecursive
	}
	return nil
}

// groups
type TestAllTypesProto2_Data struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	GroupInt32    *int32                 `protobuf:"varint,202,opt,name=group_int32,json=groupInt32" json:"group_int32,omitempty"`
	GroupUint32   *uint32                `protobuf:"varint,203,opt,name=group_uint32,json=groupUint32" json:"group_uint32,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *TestAllTypesProto2_Data) Reset() {
	*x = TestAllTypesProto2_Data{}
	mi := &file_google_protobuf_test_messages_proto2_proto_msgTypes[32]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TestAllTypesProto2_Data) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TestAllTypesProto2_Data) ProtoMessage() {}

func (x *TestAllTypesProto2_Data) ProtoReflect() protoreflect.Message {
	mi := &file_google_protobuf_test_messages_proto2_proto_msgTypes[32]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TestAllTypesProto2_Data.ProtoReflect.Descriptor instead.
func (*TestAllTypesProto2_Data) Descriptor() ([]byte, []int) {
	return file_google_protobuf_test_messages_proto2_proto_rawDescGZIP(), []int{0, 22}
}

func (x *TestAllTypesProto2_Data) GetGroupInt32() int32 {
	if x != nil && x.GroupInt32 != nil {
		return *x.GroupInt32
	}
	return 0
}

func (x *TestAllTypesProto2_Data) GetGroupUint32() uint32 {
	if x != nil && x.GroupUint32 != nil {
		return *x.GroupUint32
	}
	return 0
}

type TestAllTypesProto2_MultiWordGroupField struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	GroupInt32    *int32                 `protobuf:"varint,205,opt,name=group_int32,json=groupInt32" json:"group_int32,omitempty"`
	GroupUint32   *uint32                `protobuf:"varint,206,opt,name=group_uint32,json=groupUint32" json:"group_uint32,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *TestAllTypesProto2_MultiWordGroupField) Reset() {
	*x = TestAllTypesProto2_MultiWordGroupField{}
	mi := &file_google_protobuf_test_messages_proto2_proto_msgTypes[33]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TestAllTypesProto2_MultiWordGroupField) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TestAllTypesProto2_MultiWordGroupField) ProtoMessage() {}

func (x *TestAllTypesProto2_MultiWordGroupField) ProtoReflect() protoreflect.Message {
	mi := &file_google_protobuf_test_messages_proto2_proto_msgTypes[33]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TestAllTypesProto2_MultiWordGroupField.ProtoReflect.Descriptor instead.
func (*TestAllTypesProto2_MultiWordGroupField) Descriptor() ([]byte, []int) {
	return file_google_protobuf_test_messages_proto2_proto_rawDescGZIP(), []int{0, 23}
}

func (x *TestAllTypesProto2_MultiWordGroupField) GetGroupInt32() int32 {
	if x != nil && x.GroupInt32 != nil {
		return *x.GroupInt32
	}
	return 0
}

func (x *TestAllTypesProto2_MultiWordGroupField) GetGroupUint32() uint32 {
	if x != nil && x.GroupUint32 != nil {
		return *x.GroupUint32
	}
	return 0
}

// message_set test case.
type TestAllTypesProto2_MessageSetCorrect struct {
	state           protoimpl.MessageState `protogen:"open.v1"`
	extensionFields protoimpl.ExtensionFields
	unknownFields   protoimpl.UnknownFields
	sizeCache       protoimpl.SizeCache
}

func (x *TestAllTypesProto2_MessageSetCorrect) Reset() {
	*x = TestAllTypesProto2_MessageSetCorrect{}
	mi := &file_google_protobuf_test_messages_proto2_proto_msgTypes[34]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TestAllTypesProto2_MessageSetCorrect) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TestAllTypesProto2_MessageSetCorrect) ProtoMessage() {}

func (x *TestAllTypesProto2_MessageSetCorrect) ProtoReflect() protoreflect.Message {
	mi := &file_google_protobuf_test_messages_proto2_proto_msgTypes[34]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TestAllTypesProto2_MessageSetCorrect.ProtoReflect.Descriptor instead.
func (*TestAllTypesProto2_MessageSetCorrect) Descriptor() ([]byte, []int) {
	return file_google_protobuf_test_messages_proto2_proto_rawDescGZIP(), []int{0, 24}
}

type TestAllTypesProto2_MessageSetCorrectExtension1 struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Str           *string                `protobuf:"bytes,25,opt,name=str" json:"str,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *TestAllTypesProto2_MessageSetCorrectExtension1) Reset() {
	*x = TestAllTypesProto2_MessageSetCorrectExtension1{}
	mi := &file_google_protobuf_test_messages_proto2_proto_msgTypes[35]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TestAllTypesProto2_MessageSetCorrectExtension1) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TestAllTypesProto2_MessageSetCorrectExtension1) ProtoMessage() {}

func (x *TestAllTypesProto2_MessageSetCorrectExtension1) ProtoReflect() protoreflect.Message {
	mi := &file_google_protobuf_test_messages_proto2_proto_msgTypes[35]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TestAllTypesProto2_MessageSetCorrectExtension1.ProtoReflect.Descriptor instead.
func (*TestAllTypesProto2_MessageSetCorrectExtension1) Descriptor() ([]byte, []int) {
	return file_google_protobuf_test_messages_proto2_proto_rawDescGZIP(), []int{0, 25}
}

func (x *TestAllTypesProto2_MessageSetCorrectExtension1) GetStr() string {
	if x != nil && x.Str != nil {
		return *x.Str
	}
	return ""
}

type TestAllTypesProto2_MessageSetCorrectExtension2 struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	I             *int32                 `protobuf:"varint,9,opt,name=i" json:"i,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *TestAllTypesProto2_MessageSetCorrectExtension2) Reset() {
	*x = TestAllTypesProto2_MessageSetCorrectExtension2{}
	mi := &file_google_protobuf_test_messages_proto2_proto_msgTypes[36]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TestAllTypesProto2_MessageSetCorrectExtension2) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TestAllTypesProto2_MessageSetCorrectExtension2) ProtoMessage() {}

func (x *TestAllTypesProto2_MessageSetCorrectExtension2) ProtoReflect() protoreflect.Message {
	mi := &file_google_protobuf_test_messages_proto2_proto_msgTypes[36]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TestAllTypesProto2_MessageSetCorrectExtension2.ProtoReflect.Descriptor instead.
func (*TestAllTypesProto2_MessageSetCorrectExtension2) Descriptor() ([]byte, []int) {
	return file_google_protobuf_test_messages_proto2_proto_rawDescGZIP(), []int{0, 26}
}

func (x *TestAllTypesProto2_MessageSetCorrectExtension2) GetI() int32 {
	if x != nil && x.I != nil {
		return *x.I
	}
	return 0
}

type TestAllTypesProto2_ExtensionWithOneof struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Types that are valid to be assigned to OneofField:
	//
	//	*TestAllTypesProto2_ExtensionWithOneof_A
	//	*TestAllTypesProto2_ExtensionWithOneof_B
	OneofField    isTestAllTypesProto2_ExtensionWithOneof_OneofField `protobuf_oneof:"oneof_field"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *TestAllTypesProto2_ExtensionWithOneof) Reset() {
	*x = TestAllTypesProto2_ExtensionWithOneof{}
	mi := &file_google_protobuf_test_messages_proto2_proto_msgTypes[37]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TestAllTypesProto2_ExtensionWithOneof) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TestAllTypesProto2_ExtensionWithOneof) ProtoMessage() {}

func (x *TestAllTypesProto2_ExtensionWithOneof) ProtoReflect() protoreflect.Message {
	mi := &file_google_protobuf_test_messages_proto2_proto_msgTypes[37]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TestAllTypesProto2_ExtensionWithOneof.ProtoReflect.Descriptor instead.
func (*TestAllTypesProto2_ExtensionWithOneof) Descriptor() ([]byte, []int) {
	return file_google_protobuf_test_messages_proto2_proto_rawDescGZIP(), []int{0, 27}
}

func (x *TestAllTypesProto2_ExtensionWithOneof) GetOneofField() isTestAllTypesProto2_ExtensionWithOneof_OneofField {
	if x != nil {
		return x.OneofField
	}
	return nil
}

func (x *TestAllTypesProto2_ExtensionWithOneof) GetA() int32 {
	if x != nil {
		if x, ok := x.OneofField.(*TestAllTypesProto2_ExtensionWithOneof_A); ok {
			return x.A
		}
	}
	return 0
}

func (x *TestAllTypesProto2_ExtensionWithOneof) GetB() int32 {
	if x != nil {
		if x, ok := x.OneofField.(*TestAllTypesProto2_ExtensionWithOneof_B); ok {
			return x.B
		}
	}
	return 0
}

type isTestAllTypesProto2_ExtensionWithOneof_OneofField interface {
	isTestAllTypesProto2_ExtensionWithOneof_OneofField()
}

type TestAllTypesProto2_ExtensionWithOneof_A struct {
	A int32 `protobuf:"varint,1,opt,name=a,oneof"`
}

type TestAllTypesProto2_ExtensionWithOneof_B struct {
	B int32 `protobuf:"varint,2,opt,name=b,oneof"`
}

func (*TestAllTypesProto2_ExtensionWithOneof_A) isTestAllTypesProto2_ExtensionWithOneof_OneofField() {
}

func (*TestAllTypesProto2_ExtensionWithOneof_B) isTestAllTypesProto2_ExtensionWithOneof_OneofField() {
}

type UnknownToTestAllTypes_OptionalGroup struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	A             *int32                 `protobuf:"varint,1,opt,name=a" json:"a,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *UnknownToTestAllTypes_OptionalGroup) Reset() {
	*x = UnknownToTestAllTypes_OptionalGroup{}
	mi := &file_google_protobuf_test_messages_proto2_proto_msgTypes[38]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UnknownToTestAllTypes_OptionalGroup) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UnknownToTestAllTypes_OptionalGroup) ProtoMessage() {}

func (x *UnknownToTestAllTypes_OptionalGroup) ProtoReflect() protoreflect.Message {
	mi := &file_google_protobuf_test_messages_proto2_proto_msgTypes[38]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UnknownToTestAllTypes_OptionalGroup.ProtoReflect.Descriptor instead.
func (*UnknownToTestAllTypes_OptionalGroup) Descriptor() ([]byte, []int) {
	return file_google_protobuf_test_messages_proto2_proto_rawDescGZIP(), []int{3, 0}
}

func (x *UnknownToTestAllTypes_OptionalGroup) GetA() int32 {
	if x != nil && x.A != nil {
		return *x.A
	}
	return 0
}

type TestAllRequiredTypesProto2_NestedMessage struct {
	state               protoimpl.MessageState      `protogen:"open.v1"`
	A                   *int32                      `protobuf:"varint,1,req,name=a" json:"a,omitempty"`
	Corecursive         *TestAllRequiredTypesProto2 `protobuf:"bytes,2,req,name=corecursive" json:"corecursive,omitempty"`
	OptionalCorecursive *TestAllRequiredTypesProto2 `protobuf:"bytes,3,opt,name=optional_corecursive,json=optionalCorecursive" json:"optional_corecursive,omitempty"`
	unknownFields       protoimpl.UnknownFields
	sizeCache           protoimpl.SizeCache
}

func (x *TestAllRequiredTypesProto2_NestedMessage) Reset() {
	*x = TestAllRequiredTypesProto2_NestedMessage{}
	mi := &file_google_protobuf_test_messages_proto2_proto_msgTypes[39]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TestAllRequiredTypesProto2_NestedMessage) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TestAllRequiredTypesProto2_NestedMessage) ProtoMessage() {}

func (x *TestAllRequiredTypesProto2_NestedMessage) ProtoReflect() protoreflect.Message {
	mi := &file_google_protobuf_test_messages_proto2_proto_msgTypes[39]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TestAllRequiredTypesProto2_NestedMessage.ProtoReflect.Descriptor instead.
func (*TestAllRequiredTypesProto2_NestedMessage) Descriptor() ([]byte, []int) {
	return file_google_protobuf_test_messages_proto2_proto_rawDescGZIP(), []int{8, 0}
}

func (x *TestAllRequiredTypesProto2_NestedMessage) GetA() int32 {
	if x != nil && x.A != nil {
		return *x.A
	}
	return 0
}

func (x *TestAllRequiredTypesProto2_NestedMessage) GetCorecursive() *TestAllRequiredTypesProto2 {
	if x != nil {
		return x.Corecursive
	}
	return nil
}

func (x *TestAllRequiredTypesProto2_NestedMessage) GetOptionalCorecursive() *TestAllRequiredTypesProto2 {
	if x != nil {
		return x.OptionalCorecursive
	}
	return nil
}

// groups
type TestAllRequiredTypesProto2_Data struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	GroupInt32    *int32                 `protobuf:"varint,202,req,name=group_int32,json=groupInt32" json:"group_int32,omitempty"`
	GroupUint32   *uint32                `protobuf:"varint,203,req,name=group_uint32,json=groupUint32" json:"group_uint32,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *TestAllRequiredTypesProto2_Data) Reset() {
	*x = TestAllRequiredTypesProto2_Data{}
	mi := &file_google_protobuf_test_messages_proto2_proto_msgTypes[40]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TestAllRequiredTypesProto2_Data) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TestAllRequiredTypesProto2_Data) ProtoMessage() {}

func (x *TestAllRequiredTypesProto2_Data) ProtoReflect() protoreflect.Message {
	mi := &file_google_protobuf_test_messages_proto2_proto_msgTypes[40]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TestAllRequiredTypesProto2_Data.ProtoReflect.Descriptor instead.
func (*TestAllRequiredTypesProto2_Data) Descriptor() ([]byte, []int) {
	return file_google_protobuf_test_messages_proto2_proto_rawDescGZIP(), []int{8, 1}
}

func (x *TestAllRequiredTypesProto2_Data) GetGroupInt32() int32 {
	if x != nil && x.GroupInt32 != nil {
		return *x.GroupInt32
	}
	return 0
}

func (x *TestAllRequiredTypesProto2_Data) GetGroupUint32() uint32 {
	if x != nil && x.GroupUint32 != nil {
		return *x.GroupUint32
	}
	return 0
}

// message_set test case.
type TestAllRequiredTypesProto2_MessageSetCorrect struct {
	state           protoimpl.MessageState `protogen:"open.v1"`
	extensionFields protoimpl.ExtensionFields
	unknownFields   protoimpl.UnknownFields
	sizeCache       protoimpl.SizeCache
}

func (x *TestAllRequiredTypesProto2_MessageSetCorrect) Reset() {
	*x = TestAllRequiredTypesProto2_MessageSetCorrect{}
	mi := &file_google_protobuf_test_messages_proto2_proto_msgTypes[41]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TestAllRequiredTypesProto2_MessageSetCorrect) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TestAllRequiredTypesProto2_MessageSetCorrect) ProtoMessage() {}

func (x *TestAllRequiredTypesProto2_MessageSetCorrect) ProtoReflect() protoreflect.Message {
	mi := &file_google_protobuf_test_messages_proto2_proto_msgTypes[41]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TestAllRequiredTypesProto2_MessageSetCorrect.ProtoReflect.Descriptor instead.
func (*TestAllRequiredTypesProto2_MessageSetCorrect) Descriptor() ([]byte, []int) {
	return file_google_protobuf_test_messages_proto2_proto_rawDescGZIP(), []int{8, 2}
}

type TestAllRequiredTypesProto2_MessageSetCorrectExtension1 struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Str           *string                `protobuf:"bytes,25,req,name=str" json:"str,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *TestAllRequiredTypesProto2_MessageSetCorrectExtension1) Reset() {
	*x = TestAllRequiredTypesProto2_MessageSetCorrectExtension1{}
	mi := &file_google_protobuf_test_messages_proto2_proto_msgTypes[42]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TestAllRequiredTypesProto2_MessageSetCorrectExtension1) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TestAllRequiredTypesProto2_MessageSetCorrectExtension1) ProtoMessage() {}

func (x *TestAllRequiredTypesProto2_MessageSetCorrectExtension1) ProtoReflect() protoreflect.Message {
	mi := &file_google_protobuf_test_messages_proto2_proto_msgTypes[42]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TestAllRequiredTypesProto2_MessageSetCorrectExtension1.ProtoReflect.Descriptor instead.
func (*TestAllRequiredTypesProto2_MessageSetCorrectExtension1) Descriptor() ([]byte, []int) {
	return file_google_protobuf_test_messages_proto2_proto_rawDescGZIP(), []int{8, 3}
}

func (x *TestAllRequiredTypesProto2_MessageSetCorrectExtension1) GetStr() string {
	if x != nil && x.Str != nil {
		return *x.Str
	}
	return ""
}

type TestAllRequiredTypesProto2_MessageSetCorrectExtension2 struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	I             *int32                 `protobuf:"varint,9,req,name=i" json:"i,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *TestAllRequiredTypesProto2_MessageSetCorrectExtension2) Reset() {
	*x = TestAllRequiredTypesProto2_MessageSetCorrectExtension2{}
	mi := &file_google_protobuf_test_messages_proto2_proto_msgTypes[43]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TestAllRequiredTypesProto2_MessageSetCorrectExtension2) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TestAllRequiredTypesProto2_MessageSetCorrectExtension2) ProtoMessage() {}

func (x *TestAllRequiredTypesProto2_MessageSetCorrectExtension2) ProtoReflect() protoreflect.Message {
	mi := &file_google_protobuf_test_messages_proto2_proto_msgTypes[43]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TestAllRequiredTypesProto2_MessageSetCorrectExtension2.ProtoReflect.Descriptor instead.
func (*TestAllRequiredTypesProto2_MessageSetCorrectExtension2) Descriptor() ([]byte, []int) {
	return file_google_protobuf_test_messages_proto2_proto_rawDescGZIP(), []int{8, 4}
}

func (x *TestAllRequiredTypesProto2_MessageSetCorrectExtension2) GetI() int32 {
	if x != nil && x.I != nil {
		return *x.I
	}
	return 0
}

type TestLargeOneof_A1 struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *TestLargeOneof_A1) Reset() {
	*x = TestLargeOneof_A1{}
	mi := &file_google_protobuf_test_messages_proto2_proto_msgTypes[44]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TestLargeOneof_A1) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TestLargeOneof_A1) ProtoMessage() {}

func (x *TestLargeOneof_A1) ProtoReflect() protoreflect.Message {
	mi := &file_google_protobuf_test_messages_proto2_proto_msgTypes[44]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TestLargeOneof_A1.ProtoReflect.Descriptor instead.
func (*TestLargeOneof_A1) Descriptor() ([]byte, []int) {
	return file_google_protobuf_test_messages_proto2_proto_rawDescGZIP(), []int{9, 0}
}

type TestLargeOneof_A2 struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *TestLargeOneof_A2) Reset() {
	*x = TestLargeOneof_A2{}
	mi := &file_google_protobuf_test_messages_proto2_proto_msgTypes[45]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TestLargeOneof_A2) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TestLargeOneof_A2) ProtoMessage() {}

func (x *TestLargeOneof_A2) ProtoReflect() protoreflect.Message {
	mi := &file_google_protobuf_test_messages_proto2_proto_msgTypes[45]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TestLargeOneof_A2.ProtoReflect.Descriptor instead.
func (*TestLargeOneof_A2) Descriptor() ([]byte, []int) {
	return file_google_protobuf_test_messages_proto2_proto_rawDescGZIP(), []int{9, 1}
}

type TestLargeOneof_A3 struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *TestLargeOneof_A3) Reset() {
	*x = TestLargeOneof_A3{}
	mi := &file_google_protobuf_test_messages_proto2_proto_msgTypes[46]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TestLargeOneof_A3) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TestLargeOneof_A3) ProtoMessage() {}

func (x *TestLargeOneof_A3) ProtoReflect() protoreflect.Message {
	mi := &file_google_protobuf_test_messages_proto2_proto_msgTypes[46]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TestLargeOneof_A3.ProtoReflect.Descriptor instead.
func (*TestLargeOneof_A3) Descriptor() ([]byte, []int) {
	return file_google_protobuf_test_messages_proto2_proto_rawDescGZIP(), []int{9, 2}
}

type TestLargeOneof_A4 struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *TestLargeOneof_A4) Reset() {
	*x = TestLargeOneof_A4{}
	mi := &file_google_protobuf_test_messages_proto2_proto_msgTypes[47]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TestLargeOneof_A4) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TestLargeOneof_A4) ProtoMessage() {}

func (x *TestLargeOneof_A4) ProtoReflect() protoreflect.Message {
	mi := &file_google_protobuf_test_messages_proto2_proto_msgTypes[47]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TestLargeOneof_A4.ProtoReflect.Descriptor instead.
func (*TestLargeOneof_A4) Descriptor() ([]byte, []int) {
	return file_google_protobuf_test_messages_proto2_proto_rawDescGZIP(), []int{9, 3}
}

type TestLargeOneof_A5 struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *TestLargeOneof_A5) Reset() {
	*x = TestLargeOneof_A5{}
	mi := &file_google_protobuf_test_messages_proto2_proto_msgTypes[48]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TestLargeOneof_A5) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TestLargeOneof_A5) ProtoMessage() {}

func (x *TestLargeOneof_A5) ProtoReflect() protoreflect.Message {
	mi := &file_google_protobuf_test_messages_proto2_proto_msgTypes[48]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TestLargeOneof_A5.ProtoReflect.Descriptor instead.
func (*TestLargeOneof_A5) Descriptor() ([]byte, []int) {
	return file_google_protobuf_test_messages_proto2_proto_rawDescGZIP(), []int{9, 4}
}

var file_google_protobuf_test_messages_proto2_proto_extTypes = []protoimpl.ExtensionInfo{
	{
		ExtendedType:  (*TestAllTypesProto2)(nil),
		ExtensionType: (*int32)(nil),
		Field:         120,
		Name:          "protobuf_test_messages.proto2.extension_int32",
		Tag:           "varint,120,opt,name=extension_int32",
		Filename:      "google/protobuf/test_messages_proto2.proto",
	},
	{
		ExtendedType:  (*TestAllTypesProto2)(nil),
		ExtensionType: (*GroupField)(nil),
		Field:         121,
		Name:          "protobuf_test_messages.proto2.groupfield",
		Tag:           "group,121,opt,name=GroupField",
		Filename:      "google/protobuf/test_messages_proto2.proto",
	},
	{
		ExtendedType:  (*TestAllTypesProto2_MessageSetCorrect)(nil),
		ExtensionType: (*TestAllTypesProto2_MessageSetCorrectExtension1)(nil),
		Field:         1547769,
		Name:          "protobuf_test_messages.proto2.TestAllTypesProto2.MessageSetCorrectExtension1.message_set_extension",
		Tag:           "bytes,1547769,opt,name=message_set_extension",
		Filename:      "google/protobuf/test_messages_proto2.proto",
	},
	{
		ExtendedType:  (*TestAllTypesProto2_MessageSetCorrect)(nil),
		ExtensionType: (*TestAllTypesProto2_MessageSetCorrectExtension2)(nil),
		Field:         4135312,
		Name:          "protobuf_test_messages.proto2.TestAllTypesProto2.MessageSetCorrectExtension2.message_set_extension",
		Tag:           "bytes,4135312,opt,name=message_set_extension",
		Filename:      "google/protobuf/test_messages_proto2.proto",
	},
	{
		ExtendedType:  (*TestAllTypesProto2_MessageSetCorrect)(nil),
		ExtensionType: (*TestAllTypesProto2_ExtensionWithOneof)(nil),
		Field:         123456789,
		Name:          "protobuf_test_messages.proto2.TestAllTypesProto2.ExtensionWithOneof.extension_with_oneof",
		Tag:           "bytes,123456789,opt,name=extension_with_oneof",
		Filename:      "google/protobuf/test_messages_proto2.proto",
	},
	{
		ExtendedType:  (*TestAllRequiredTypesProto2_MessageSetCorrect)(nil),
		ExtensionType: (*TestAllRequiredTypesProto2_MessageSetCorrectExtension1)(nil),
		Field:         1547769,
		Name:          "protobuf_test_messages.proto2.TestAllRequiredTypesProto2.MessageSetCorrectExtension1.message_set_extension",
		Tag:           "bytes,1547769,opt,name=message_set_extension",
		Filename:      "google/protobuf/test_messages_proto2.proto",
	},
	{
		ExtendedType:  (*TestAllRequiredTypesProto2_MessageSetCorrect)(nil),
		ExtensionType: (*TestAllRequiredTypesProto2_MessageSetCorrectExtension2)(nil),
		Field:         4135312,
		Name:          "protobuf_test_messages.proto2.TestAllRequiredTypesProto2.MessageSetCorrectExtension2.message_set_extension",
		Tag:           "bytes,4135312,opt,name=message_set_extension",
		Filename:      "google/protobuf/test_messages_proto2.proto",
	},
}

// Extension fields to TestAllTypesProto2.
var (
	// optional int32 extension_int32 = 120;
	E_ExtensionInt32 = &file_google_protobuf_test_messages_proto2_proto_extTypes[0]
	// optional protobuf_test_messages.proto2.GroupField groupfield = 121;
	E_Groupfield = &file_google_protobuf_test_messages_proto2_proto_extTypes[1]
)

// Extension fields to TestAllTypesProto2_MessageSetCorrect.
var (
	// optional protobuf_test_messages.proto2.TestAllTypesProto2.MessageSetCorrectExtension1 message_set_extension = 1547769;
	E_TestAllTypesProto2_MessageSetCorrectExtension1_MessageSetExtension = &file_google_protobuf_test_messages_proto2_proto_extTypes[2]
	// optional protobuf_test_messages.proto2.TestAllTypesProto2.MessageSetCorrectExtension2 message_set_extension = 4135312;
	E_TestAllTypesProto2_MessageSetCorrectExtension2_MessageSetExtension = &file_google_protobuf_test_messages_proto2_proto_extTypes[3]
	// optional protobuf_test_messages.proto2.TestAllTypesProto2.ExtensionWithOneof extension_with_oneof = 123456789;
	E_TestAllTypesProto2_ExtensionWithOneof_ExtensionWithOneof = &file_google_protobuf_test_messages_proto2_proto_extTypes[4]
)

// Extension fields to TestAllRequiredTypesProto2_MessageSetCorrect.
var (
	// optional protobuf_test_messages.proto2.TestAllRequiredTypesProto2.MessageSetCorrectExtension1 message_set_extension = 1547769;
	E_TestAllRequiredTypesProto2_MessageSetCorrectExtension1_MessageSetExtension = &file_google_protobuf_test_messages_proto2_proto_extTypes[5]
	// optional protobuf_test_messages.proto2.TestAllRequiredTypesProto2.MessageSetCorrectExtension2 message_set_extension = 4135312;
	E_TestAllRequiredTypesProto2_MessageSetCorrectExtension2_MessageSetExtension = &file_google_protobuf_test_messages_proto2_proto_extTypes[6]
)

var File_google_protobuf_test_messages_proto2_proto protoreflect.FileDescriptor

const file_google_protobuf_test_messages_proto2_proto_rawDesc = "" +
	"\n" +
	"*google/protobuf/test_messages_proto2.proto\x12\x1dprotobuf_test_messages.proto2\"\xe7Y\n" +
	"\x12TestAllTypesProto2\x12%\n" +
	"\x0eoptional_int32\x18\x01 \x01(\x05R\roptionalInt32\x12%\n" +
	"\x0eoptional_int64\x18\x02 \x01(\x03R\roptionalInt64\x12'\n" +
	"\x0foptional_uint32\x18\x03 \x01(\rR\x0eoptionalUint32\x12'\n" +
	"\x0foptional_uint64\x18\x04 \x01(\x04R\x0eoptionalUint64\x12'\n" +
	"\x0foptional_sint32\x18\x05 \x01(\x11R\x0eoptionalSint32\x12'\n" +
	"\x0foptional_sint64\x18\x06 \x01(\x12R\x0eoptionalSint64\x12)\n" +
	"\x10optional_fixed32\x18\a \x01(\aR\x0foptionalFixed32\x12)\n" +
	"\x10optional_fixed64\x18\b \x01(\x06R\x0foptionalFixed64\x12+\n" +
	"\x11optional_sfixed32\x18\t \x01(\x0fR\x10optionalSfixed32\x12+\n" +
	"\x11optional_sfixed64\x18\n" +
	" \x01(\x10R\x10optionalSfixed64\x12%\n" +
	"\x0eoptional_float\x18\v \x01(\x02R\roptionalFloat\x12'\n" +
	"\x0foptional_double\x18\f \x01(\x01R\x0eoptionalDouble\x12#\n" +
	"\roptional_bool\x18\r \x01(\bR\foptionalBool\x12'\n" +
	"\x0foptional_string\x18\x0e \x01(\tR\x0eoptionalString\x12%\n" +
	"\x0eoptional_bytes\x18\x0f \x01(\fR\roptionalBytes\x12w\n" +
	"\x17optional_nested_message\x18\x12 \x01(\v2?.protobuf_test_messages.proto2.TestAllTypesProto2.NestedMessageR\x15optionalNestedMessage\x12m\n" +
	"\x18optional_foreign_message\x18\x13 \x01(\v23.protobuf_test_messages.proto2.ForeignMessageProto2R\x16optionalForeignMessage\x12n\n" +
	"\x14optional_nested_enum\x18\x15 \x01(\x0e2<.protobuf_test_messages.proto2.TestAllTypesProto2.NestedEnumR\x12optionalNestedEnum\x12d\n" +
	"\x15optional_foreign_enum\x18\x16 \x01(\x0e20.protobuf_test_messages.proto2.ForeignEnumProto2R\x13optionalForeignEnum\x126\n" +
	"\x15optional_string_piece\x18\x18 \x01(\tB\x02\b\x02R\x13optionalStringPiece\x12'\n" +
	"\roptional_cord\x18\x19 \x01(\tB\x02\b\x01R\foptionalCord\x12^\n" +
	"\x11recursive_message\x18\x1b \x01(\v21.protobuf_test_messages.proto2.TestAllTypesProto2R\x10recursiveMessage\x12%\n" +
	"\x0erepeated_int32\x18\x1f \x03(\x05R\rrepeatedInt32\x12%\n" +
	"\x0erepeated_int64\x18  \x03(\x03R\rrepeatedInt64\x12'\n" +
	"\x0frepeated_uint32\x18! \x03(\rR\x0erepeatedUint32\x12'\n" +
	"\x0frepeated_uint64\x18\" \x03(\x04R\x0erepeatedUint64\x12'\n" +
	"\x0frepeated_sint32\x18# \x03(\x11R\x0erepeatedSint32\x12'\n" +
	"\x0frepeated_sint64\x18$ \x03(\x12R\x0erepeatedSint64\x12)\n" +
	"\x10repeated_fixed32\x18% \x03(\aR\x0frepeatedFixed32\x12)\n" +
	"\x10repeated_fixed64\x18& \x03(\x06R\x0frepeatedFixed64\x12+\n" +
	"\x11repeated_sfixed32\x18' \x03(\x0fR\x10repeatedSfixed32\x12+\n" +
	"\x11repeated_sfixed64\x18( \x03(\x10R\x10repeatedSfixed64\x12%\n" +
	"\x0erepeated_float\x18) \x03(\x02R\rrepeatedFloat\x12'\n" +
	"\x0frepeated_double\x18* \x03(\x01R\x0erepeatedDouble\x12#\n" +
	"\rrepeated_bool\x18+ \x03(\bR\frepeatedBool\x12'\n" +
	"\x0frepeated_string\x18, \x03(\tR\x0erepeatedString\x12%\n" +
	"\x0erepeated_bytes\x18- \x03(\fR\rrepeatedBytes\x12w\n" +
	"\x17repeated_nested_message\x180 \x03(\v2?.protobuf_test_messages.proto2.TestAllTypesProto2.NestedMessageR\x15repeatedNestedMessage\x12m\n" +
	"\x18repeated_foreign_message\x181 \x03(\v23.protobuf_test_messages.proto2.ForeignMessageProto2R\x16repeatedForeignMessage\x12n\n" +
	"\x14repeated_nested_enum\x183 \x03(\x0e2<.protobuf_test_messages.proto2.TestAllTypesProto2.NestedEnumR\x12repeatedNestedEnum\x12d\n" +
	"\x15repeated_foreign_enum\x184 \x03(\x0e20.protobuf_test_messages.proto2.ForeignEnumProto2R\x13repeatedForeignEnum\x126\n" +
	"\x15repeated_string_piece\x186 \x03(\tB\x02\b\x02R\x13repeatedStringPiece\x12'\n" +
	"\rrepeated_cord\x187 \x03(\tB\x02\b\x01R\frepeatedCord\x12%\n" +
	"\fpacked_int32\x18K \x03(\x05B\x02\x10\x01R\vpackedInt32\x12%\n" +
	"\fpacked_int64\x18L \x03(\x03B\x02\x10\x01R\vpackedInt64\x12'\n" +
	"\rpacked_uint32\x18M \x03(\rB\x02\x10\x01R\fpackedUint32\x12'\n" +
	"\rpacked_uint64\x18N \x03(\x04B\x02\x10\x01R\fpackedUint64\x12'\n" +
	"\rpacked_sint32\x18O \x03(\x11B\x02\x10\x01R\fpackedSint32\x12'\n" +
	"\rpacked_sint64\x18P \x03(\x12B\x02\x10\x01R\fpackedSint64\x12)\n" +
	"\x0epacked_fixed32\x18Q \x03(\aB\x02\x10\x01R\rpackedFixed32\x12)\n" +
	"\x0epacked_fixed64\x18R \x03(\x06B\x02\x10\x01R\rpackedFixed64\x12+\n" +
	"\x0fpacked_sfixed32\x18S \x03(\x0fB\x02\x10\x01R\x0epackedSfixed32\x12+\n" +
	"\x0fpacked_sfixed64\x18T \x03(\x10B\x02\x10\x01R\x0epackedSfixed64\x12%\n" +
	"\fpacked_float\x18U \x03(\x02B\x02\x10\x01R\vpackedFloat\x12'\n" +
	"\rpacked_double\x18V \x03(\x01B\x02\x10\x01R\fpackedDouble\x12#\n" +
	"\vpacked_bool\x18W \x03(\bB\x02\x10\x01R\n" +
	"packedBool\x12n\n" +
	"\x12packed_nested_enum\x18X \x03(\x0e2<.protobuf_test_messages.proto2.TestAllTypesProto2.NestedEnumB\x02\x10\x01R\x10packedNestedEnum\x12)\n" +
	"\x0eunpacked_int32\x18Y \x03(\x05B\x02\x10\x00R\runpackedInt32\x12)\n" +
	"\x0eunpacked_int64\x18Z \x03(\x03B\x02\x10\x00R\runpackedInt64\x12+\n" +
	"\x0funpacked_uint32\x18[ \x03(\rB\x02\x10\x00R\x0eunpackedUint32\x12+\n" +
	"\x0funpacked_uint64\x18\\ \x03(\x04B\x02\x10\x00R\x0eunpackedUint64\x12+\n" +
	"\x0funpacked_sint32\x18] \x03(\x11B\x02\x10\x00R\x0eunpackedSint32\x12+\n" +
	"\x0funpacked_sint64\x18^ \x03(\x12B\x02\x10\x00R\x0eunpackedSint64\x12-\n" +
	"\x10unpacked_fixed32\x18_ \x03(\aB\x02\x10\x00R\x0funpackedFixed32\x12-\n" +
	"\x10unpacked_fixed64\x18` \x03(\x06B\x02\x10\x00R\x0funpackedFixed64\x12/\n" +
	"\x11unpacked_sfixed32\x18a \x03(\x0fB\x02\x10\x00R\x10unpackedSfixed32\x12/\n" +
	"\x11unpacked_sfixed64\x18b \x03(\x10B\x02\x10\x00R\x10unpackedSfixed64\x12)\n" +
	"\x0eunpacked_float\x18c \x03(\x02B\x02\x10\x00R\runpackedFloat\x12+\n" +
	"\x0funpacked_double\x18d \x03(\x01B\x02\x10\x00R\x0eunpackedDouble\x12'\n" +
	"\runpacked_bool\x18e \x03(\bB\x02\x10\x00R\funpackedBool\x12r\n" +
	"\x14unpacked_nested_enum\x18f \x03(\x0e2<.protobuf_test_messages.proto2.TestAllTypesProto2.NestedEnumB\x02\x10\x00R\x12unpackedNestedEnum\x12l\n" +
	"\x0fmap_int32_int32\x188 \x03(\v2D.protobuf_test_messages.proto2.TestAllTypesProto2.MapInt32Int32EntryR\rmapInt32Int32\x12l\n" +
	"\x0fmap_int64_int64\x189 \x03(\v2D.protobuf_test_messages.proto2.TestAllTypesProto2.MapInt64Int64EntryR\rmapInt64Int64\x12r\n" +
	"\x11map_uint32_uint32\x18: \x03(\v2F.protobuf_test_messages.proto2.TestAllTypesProto2.MapUint32Uint32EntryR\x0fmapUint32Uint32\x12r\n" +
	"\x11map_uint64_uint64\x18; \x03(\v2F.protobuf_test_messages.proto2.TestAllTypesProto2.MapUint64Uint64EntryR\x0fmapUint64Uint64\x12r\n" +
	"\x11map_sint32_sint32\x18< \x03(\v2F.protobuf_test_messages.proto2.TestAllTypesProto2.MapSint32Sint32EntryR\x0fmapSint32Sint32\x12r\n" +
	"\x11map_sint64_sint64\x18= \x03(\v2F.protobuf_test_messages.proto2.TestAllTypesProto2.MapSint64Sint64EntryR\x0fmapSint64Sint64\x12x\n" +
	"\x13map_fixed32_fixed32\x18> \x03(\v2H.protobuf_test_messages.proto2.TestAllTypesProto2.MapFixed32Fixed32EntryR\x11mapFixed32Fixed32\x12x\n" +
	"\x13map_fixed64_fixed64\x18? \x03(\v2H.protobuf_test_messages.proto2.TestAllTypesProto2.MapFixed64Fixed64EntryR\x11mapFixed64Fixed64\x12~\n" +
	"\x15map_sfixed32_sfixed32\x18@ \x03(\v2J.protobuf_test_messages.proto2.TestAllTypesProto2.MapSfixed32Sfixed32EntryR\x13mapSfixed32Sfixed32\x12~\n" +
	"\x15map_sfixed64_sfixed64\x18A \x03(\v2J.protobuf_test_messages.proto2.TestAllTypesProto2.MapSfixed64Sfixed64EntryR\x13mapSfixed64Sfixed64\x12i\n" +
	"\x0emap_int32_bool\x18h \x03(\v2C.protobuf_test_messages.proto2.TestAllTypesProto2.MapInt32BoolEntryR\fmapInt32Bool\x12l\n" +
	"\x0fmap_int32_float\x18B \x03(\v2D.protobuf_test_messages.proto2.TestAllTypesProto2.MapInt32FloatEntryR\rmapInt32Float\x12o\n" +
	"\x10map_int32_double\x18C \x03(\v2E.protobuf_test_messages.proto2.TestAllTypesProto2.MapInt32DoubleEntryR\x0emapInt32Double\x12\x85\x01\n" +
	"\x18map_int32_nested_message\x18g \x03(\v2L.protobuf_test_messages.proto2.TestAllTypesProto2.MapInt32NestedMessageEntryR\x15mapInt32NestedMessage\x12f\n" +
	"\rmap_bool_bool\x18D \x03(\v2B.protobuf_test_messages.proto2.TestAllTypesProto2.MapBoolBoolEntryR\vmapBoolBool\x12r\n" +
	"\x11map_string_string\x18E \x03(\v2F.protobuf_test_messages.proto2.TestAllTypesProto2.MapStringStringEntryR\x0fmapStringString\x12o\n" +
	"\x10map_string_bytes\x18F \x03(\v2E.protobuf_test_messages.proto2.TestAllTypesProto2.MapStringBytesEntryR\x0emapStringBytes\x12\x88\x01\n" +
	"\x19map_string_nested_message\x18G \x03(\v2M.protobuf_test_messages.proto2.TestAllTypesProto2.MapStringNestedMessageEntryR\x16mapStringNestedMessage\x12\x8b\x01\n" +
	"\x1amap_string_foreign_message\x18H \x03(\v2N.protobuf_test_messages.proto2.TestAllTypesProto2.MapStringForeignMessageEntryR\x17mapStringForeignMessage\x12\x7f\n" +
	"\x16map_string_nested_enum\x18I \x03(\v2J.protobuf_test_messages.proto2.TestAllTypesProto2.MapStringNestedEnumEntryR\x13mapStringNestedEnum\x12\x82\x01\n" +
	"\x17map_string_foreign_enum\x18J \x03(\v2K.protobuf_test_messages.proto2.TestAllTypesProto2.MapStringForeignEnumEntryR\x14mapStringForeignEnum\x12#\n" +
	"\foneof_uint32\x18o \x01(\rH\x00R\voneofUint32\x12s\n" +
	"\x14oneof_nested_message\x18p \x01(\v2?.protobuf_test_messages.proto2.TestAllTypesProto2.NestedMessageH\x00R\x12oneofNestedMessage\x12#\n" +
	"\foneof_string\x18q \x01(\tH\x00R\voneofString\x12!\n" +
	"\voneof_bytes\x18r \x01(\fH\x00R\n" +
	"oneofBytes\x12\x1f\n" +
	"\n" +
	"oneof_bool\x18s \x01(\bH\x00R\toneofBool\x12#\n" +
	"\foneof_uint64\x18t \x01(\x04H\x00R\voneofUint64\x12!\n" +
	"\voneof_float\x18u \x01(\x02H\x00R\n" +
	"oneofFloat\x12#\n" +
	"\foneof_double\x18v \x01(\x01H\x00R\voneofDouble\x12]\n" +
	"\n" +
	"oneof_enum\x18w \x01(\x0e2<.protobuf_test_messages.proto2.TestAllTypesProto2.NestedEnumH\x00R\toneofEnum\x12K\n" +
	"\x04data\x18\xc9\x01 \x01(\n" +
	"26.protobuf_test_messages.proto2.TestAllTypesProto2.DataR\x04data\x12x\n" +
	"\x13multiwordgroupfield\x18\xcc\x01 \x01(\n" +
	"2E.protobuf_test_messages.proto2.TestAllTypesProto2.MultiWordGroupFieldR\x13multiwordgroupfield\x120\n" +
	"\rdefault_int32\x18\xf1\x01 \x01(\x05:\n" +
	"-123456789R\fdefaultInt32\x12:\n" +
	"\rdefault_int64\x18\xf2\x01 \x01(\x03:\x14-9123456789123456789R\fdefaultInt64\x122\n" +
	"\x0edefault_uint32\x18\xf3\x01 \x01(\r:\n" +
	"2123456789R\rdefaultUint32\x12<\n" +
	"\x0edefault_uint64\x18\xf4\x01 \x01(\x04:\x1410123456789123456789R\rdefaultUint64\x122\n" +
	"\x0edefault_sint32\x18\xf5\x01 \x01(\x11:\n" +
	"-123456789R\rdefaultSint32\x12<\n" +
	"\x0edefault_sint64\x18\xf6\x01 \x01(\x12:\x14-9123456789123456789R\rdefaultSint64\x124\n" +
	"\x0fdefault_fixed32\x18\xf7\x01 \x01(\a:\n" +
	"2123456789R\x0edefaultFixed32\x12>\n" +
	"\x0fdefault_fixed64\x18\xf8\x01 \x01(\x06:\x1410123456789123456789R\x0edefaultFixed64\x126\n" +
	"\x10default_sfixed32\x18\xf9\x01 \x01(\x0f:\n" +
	"-123456789R\x0fdefaultSfixed32\x12@\n" +
	"\x10default_sfixed64\x18\xfa\x01 \x01(\x10:\x14-9123456789123456789R\x0fdefaultSfixed64\x12+\n" +
	"\rdefault_float\x18\xfb\x01 \x01(\x02:\x059e+09R\fdefaultFloat\x12-\n" +
	"\x0edefault_double\x18\xfc\x01 \x01(\x01:\x057e+22R\rdefaultDouble\x12(\n" +
	"\fdefault_bool\x18\xfd\x01 \x01(\b:\x04trueR\vdefaultBool\x12/\n" +
	"\x0edefault_string\x18\xfe\x01 \x01(\t:\aRosebudR\rdefaultString\x12,\n" +
	"\rdefault_bytes\x18\xff\x01 \x01(\f:\x06joshuaR\fdefaultBytes\x12\x1f\n" +
	"\n" +
	"fieldname1\x18\x91\x03 \x01(\x05R\n" +
	"fieldname1\x12 \n" +
	"\vfield_name2\x18\x92\x03 \x01(\x05R\n" +
	"fieldName2\x12!\n" +
	"\f_field_name3\x18\x93\x03 \x01(\x05R\n" +
	"FieldName3\x12\"\n" +
	"\rfield__name4_\x18\x94\x03 \x01(\x05R\n" +
	"fieldName4\x12!\n" +
	"\vfield0name5\x18\x95\x03 \x01(\x05R\vfield0name5\x12#\n" +
	"\rfield_0_name6\x18\x96\x03 \x01(\x05R\vfield0Name6\x12\x1f\n" +
	"\n" +
	"fieldName7\x18\x97\x03 \x01(\x05R\n" +
	"fieldName7\x12\x1f\n" +
	"\n" +
	"FieldName8\x18\x98\x03 \x01(\x05R\n" +
	"FieldName8\x12 \n" +
	"\vfield_Name9\x18\x99\x03 \x01(\x05R\n" +
	"fieldName9\x12\"\n" +
	"\fField_Name10\x18\x9a\x03 \x01(\x05R\vFieldName10\x12\"\n" +
	"\fFIELD_NAME11\x18\x9b\x03 \x01(\x05R\vFIELDNAME11\x12\"\n" +
	"\fFIELD_name12\x18\x9c\x03 \x01(\x05R\vFIELDName12\x12$\n" +
	"\x0e__field_name13\x18\x9d\x03 \x01(\x05R\vFieldName13\x12$\n" +
	"\x0e__Field_name14\x18\x9e\x03 \x01(\x05R\vFieldName14\x12#\n" +
	"\rfield__name15\x18\x9f\x03 \x01(\x05R\vfieldName15\x12#\n" +
	"\rfield__Name16\x18\xa0\x03 \x01(\x05R\vfieldName16\x12$\n" +
	"\x0efield_name17__\x18\xa1\x03 \x01(\x05R\vfieldName17\x12$\n" +
	"\x0eField_name18__\x18\xa2\x03 \x01(\x05R\vFieldName18\x12t\n" +
	"\x13message_set_correct\x18\xf4\x03 \x01(\v2C.protobuf_test_messages.proto2.TestAllTypesProto2.MessageSetCorrectR\x11messageSetCorrect\x1ar\n" +
	"\rNestedMessage\x12\f\n" +
	"\x01a\x18\x01 \x01(\x05R\x01a\x12S\n" +
	"\vcorecursive\x18\x02 \x01(\v21.protobuf_test_messages.proto2.TestAllTypesProto2R\vcorecursive\x1a@\n" +
	"\x12MapInt32Int32Entry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\x05R\x03key\x12\x14\n" +
	"\x05value\x18\x02 \x01(\x05R\x05value:\x028\x01\x1a@\n" +
	"\x12MapInt64Int64Entry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\x03R\x03key\x12\x14\n" +
	"\x05value\x18\x02 \x01(\x03R\x05value:\x028\x01\x1aB\n" +
	"\x14MapUint32Uint32Entry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\rR\x03key\x12\x14\n" +
	"\x05value\x18\x02 \x01(\rR\x05value:\x028\x01\x1aB\n" +
	"\x14MapUint64Uint64Entry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\x04R\x03key\x12\x14\n" +
	"\x05value\x18\x02 \x01(\x04R\x05value:\x028\x01\x1aB\n" +
	"\x14MapSint32Sint32Entry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\x11R\x03key\x12\x14\n" +
	"\x05value\x18\x02 \x01(\x11R\x05value:\x028\x01\x1aB\n" +
	"\x14MapSint64Sint64Entry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\x12R\x03key\x12\x14\n" +
	"\x05value\x18\x02 \x01(\x12R\x05value:\x028\x01\x1aD\n" +
	"\x16MapFixed32Fixed32Entry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\aR\x03key\x12\x14\n" +
	"\x05value\x18\x02 \x01(\aR\x05value:\x028\x01\x1aD\n" +
	"\x16MapFixed64Fixed64Entry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\x06R\x03key\x12\x14\n" +
	"\x05value\x18\x02 \x01(\x06R\x05value:\x028\x01\x1aF\n" +
	"\x18MapSfixed32Sfixed32Entry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\x0fR\x03key\x12\x14\n" +
	"\x05value\x18\x02 \x01(\x0fR\x05value:\x028\x01\x1aF\n" +
	"\x18MapSfixed64Sfixed64Entry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\x10R\x03key\x12\x14\n" +
	"\x05value\x18\x02 \x01(\x10R\x05value:\x028\x01\x1a?\n" +
	"\x11MapInt32BoolEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\x05R\x03key\x12\x14\n" +
	"\x05value\x18\x02 \x01(\bR\x05value:\x028\x01\x1a@\n" +
	"\x12MapInt32FloatEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\x05R\x03key\x12\x14\n" +
	"\x05value\x18\x02 \x01(\x02R\x05value:\x028\x01\x1aA\n" +
	"\x13MapInt32DoubleEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\x05R\x03key\x12\x14\n" +
	"\x05value\x18\x02 \x01(\x01R\x05value:\x028\x01\x1a\x89\x01\n" +
	"\x1aMapInt32NestedMessageEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\x05R\x03key\x12U\n" +
	"\x05value\x18\x02 \x01(\v2?.protobuf_test_messages.proto2.TestAllTypesProto2.NestedMessageR\x05value:\x028\x01\x1a>\n" +
	"\x10MapBoolBoolEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\bR\x03key\x12\x14\n" +
	"\x05value\x18\x02 \x01(\bR\x05value:\x028\x01\x1aB\n" +
	"\x14MapStringStringEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12\x14\n" +
	"\x05value\x18\x02 \x01(\tR\x05value:\x028\x01\x1aA\n" +
	"\x13MapStringBytesEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12\x14\n" +
	"\x05value\x18\x02 \x01(\fR\x05value:\x028\x01\x1a\x8a\x01\n" +
	"\x1bMapStringNestedMessageEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12U\n" +
	"\x05value\x18\x02 \x01(\v2?.protobuf_test_messages.proto2.TestAllTypesProto2.NestedMessageR\x05value:\x028\x01\x1a\x7f\n" +
	"\x1cMapStringForeignMessageEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12I\n" +
	"\x05value\x18\x02 \x01(\v23.protobuf_test_messages.proto2.ForeignMessageProto2R\x05value:\x028\x01\x1a\x84\x01\n" +
	"\x18MapStringNestedEnumEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12R\n" +
	"\x05value\x18\x02 \x01(\x0e2<.protobuf_test_messages.proto2.TestAllTypesProto2.NestedEnumR\x05value:\x028\x01\x1ay\n" +
	"\x19MapStringForeignEnumEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12F\n" +
	"\x05value\x18\x02 \x01(\x0e20.protobuf_test_messages.proto2.ForeignEnumProto2R\x05value:\x028\x01\x1aL\n" +
	"\x04Data\x12 \n" +
	"\vgroup_int32\x18\xca\x01 \x01(\x05R\n" +
	"groupInt32\x12\"\n" +
	"\fgroup_uint32\x18\xcb\x01 \x01(\rR\vgroupUint32\x1a[\n" +
	"\x13MultiWordGroupField\x12 \n" +
	"\vgroup_int32\x18\xcd\x01 \x01(\x05R\n" +
	"groupInt32\x12\"\n" +
	"\fgroup_uint32\x18\xce\x01 \x01(\rR\vgroupUint32\x1a!\n" +
	"\x11MessageSetCorrect*\b\b\x04\x10\xff\xff\xff\xff\a:\x02\b\x01\x1a\xfa\x01\n" +
	"\x1bMessageSetCorrectExtension1\x12\x10\n" +
	"\x03str\x18\x19 \x01(\tR\x03str2\xc8\x01\n" +
	"\x15message_set_extension\x12C.protobuf_test_messages.proto2.TestAllTypesProto2.MessageSetCorrect\x18\xf9\xbb^ \x01(\v2M.protobuf_test_messages.proto2.TestAllTypesProto2.MessageSetCorrectExtension1R\x13messageSetExtension\x1a\xf7\x01\n" +
	"\x1bMessageSetCorrectExtension2\x12\f\n" +
	"\x01i\x18\t \x01(\x05R\x01i2\xc9\x01\n" +
	"\x15message_set_extension\x12C.protobuf_test_messages.proto2.TestAllTypesProto2.MessageSetCorrect\x18\x90\xb3\xfc\x01 \x01(\v2M.protobuf_test_messages.proto2.TestAllTypesProto2.MessageSetCorrectExtension2R\x13messageSetExtension\x1a\x84\x02\n" +
	"\x12ExtensionWithOneof\x12\x0e\n" +
	"\x01a\x18\x01 \x01(\x05H\x00R\x01a\x12\x0e\n" +
	"\x01b\x18\x02 \x01(\x05H\x00R\x01b2\xbe\x01\n" +
	"\x14extension_with_oneof\x12C.protobuf_test_messages.proto2.TestAllTypesProto2.MessageSetCorrect\x18\x95\x9a\xef: \x01(\v2D.protobuf_test_messages.proto2.TestAllTypesProto2.ExtensionWithOneofR\x12extensionWithOneofB\r\n" +
	"\voneof_field\"9\n" +
	"\n" +
	"NestedEnum\x12\a\n" +
	"\x03FOO\x10\x00\x12\a\n" +
	"\x03BAR\x10\x01\x12\a\n" +
	"\x03BAZ\x10\x02\x12\x10\n" +
	"\x03NEG\x10\xff\xff\xff\xff\xff\xff\xff\xff\xff\x01*\x05\bx\x10\xc9\x01B\r\n" +
	"\voneof_fieldJ\x06\b\xe8\a\x10\x90NJ\b\b\xbf\x84=\x10\xc0\x84=R\x0ereserved_field\"$\n" +
	"\x14ForeignMessageProto2\x12\f\n" +
	"\x01c\x18\x01 \x01(\x05R\x01c\"P\n" +
	"\n" +
	"GroupField\x12\x1f\n" +
	"\vgroup_int32\x18z \x01(\x05R\n" +
	"groupInt32\x12!\n" +
	"\fgroup_uint32\x18{ \x01(\rR\vgroupUint32\"\x9e\x03\n" +
	"\x15UnknownToTestAllTypes\x12&\n" +
	"\x0eoptional_int32\x18\xe9\a \x01(\x05R\roptionalInt32\x12(\n" +
	"\x0foptional_string\x18\xea\a \x01(\tR\x0eoptionalString\x12[\n" +
	"\x0enested_message\x18\xeb\a \x01(\v23.protobuf_test_messages.proto2.ForeignMessageProto2R\rnestedMessage\x12i\n" +
	"\roptionalgroup\x18\xec\a \x01(\n" +
	"2B.protobuf_test_messages.proto2.UnknownToTestAllTypes.OptionalGroupR\roptionalgroup\x12$\n" +
	"\roptional_bool\x18\xee\a \x01(\bR\foptionalBool\x12&\n" +
	"\x0erepeated_int32\x18\xf3\a \x03(\x05R\rrepeatedInt32\x1a\x1d\n" +
	"\rOptionalGroup\x12\f\n" +
	"\x01a\x18\x01 \x01(\x05R\x01a\"\x16\n" +
	"\x14NullHypothesisProto2\"/\n" +
	"\x0eEnumOnlyProto2\"\x1d\n" +
	"\x04Bool\x12\n" +
	"\n" +
	"\x06kFalse\x10\x00\x12\t\n" +
	"\x05kTrue\x10\x01\"%\n" +
	"\x0fOneStringProto2\x12\x12\n" +
	"\x04data\x18\x01 \x01(\tR\x04data\"a\n" +
	"\x11ProtoWithKeywords\x12\x16\n" +
	"\x06inline\x18\x01 \x01(\x05R\x06inline\x12\x18\n" +
	"\aconcept\x18\x02 \x01(\tR\aconcept\x12\x1a\n" +
	"\brequires\x18\x03 \x03(\tR\brequires\"\xcc\x19\n" +
	"\x1aTestAllRequiredTypesProto2\x12%\n" +
	"\x0erequired_int32\x18\x01 \x02(\x05R\rrequiredInt32\x12%\n" +
	"\x0erequired_int64\x18\x02 \x02(\x03R\rrequiredInt64\x12'\n" +
	"\x0frequired_uint32\x18\x03 \x02(\rR\x0erequiredUint32\x12'\n" +
	"\x0frequired_uint64\x18\x04 \x02(\x04R\x0erequiredUint64\x12'\n" +
	"\x0frequired_sint32\x18\x05 \x02(\x11R\x0erequiredSint32\x12'\n" +
	"\x0frequired_sint64\x18\x06 \x02(\x12R\x0erequiredSint64\x12)\n" +
	"\x10required_fixed32\x18\a \x02(\aR\x0frequiredFixed32\x12)\n" +
	"\x10required_fixed64\x18\b \x02(\x06R\x0frequiredFixed64\x12+\n" +
	"\x11required_sfixed32\x18\t \x02(\x0fR\x10requiredSfixed32\x12+\n" +
	"\x11required_sfixed64\x18\n" +
	" \x02(\x10R\x10requiredSfixed64\x12%\n" +
	"\x0erequired_float\x18\v \x02(\x02R\rrequiredFloat\x12'\n" +
	"\x0frequired_double\x18\f \x02(\x01R\x0erequiredDouble\x12#\n" +
	"\rrequired_bool\x18\r \x02(\bR\frequiredBool\x12'\n" +
	"\x0frequired_string\x18\x0e \x02(\tR\x0erequiredString\x12%\n" +
	"\x0erequired_bytes\x18\x0f \x02(\fR\rrequiredBytes\x12\x7f\n" +
	"\x17required_nested_message\x18\x12 \x02(\v2G.protobuf_test_messages.proto2.TestAllRequiredTypesProto2.NestedMessageR\x15requiredNestedMessage\x12m\n" +
	"\x18required_foreign_message\x18\x13 \x02(\v23.protobuf_test_messages.proto2.ForeignMessageProto2R\x16requiredForeignMessage\x12v\n" +
	"\x14required_nested_enum\x18\x15 \x02(\x0e2D.protobuf_test_messages.proto2.TestAllRequiredTypesProto2.NestedEnumR\x12requiredNestedEnum\x12d\n" +
	"\x15required_foreign_enum\x18\x16 \x02(\x0e20.protobuf_test_messages.proto2.ForeignEnumProto2R\x13requiredForeignEnum\x126\n" +
	"\x15required_string_piece\x18\x18 \x02(\tB\x02\b\x02R\x13requiredStringPiece\x12'\n" +
	"\rrequired_cord\x18\x19 \x02(\tB\x02\b\x01R\frequiredCord\x12f\n" +
	"\x11recursive_message\x18\x1b \x02(\v29.protobuf_test_messages.proto2.TestAllRequiredTypesProto2R\x10recursiveMessage\x12w\n" +
	"\x1aoptional_recursive_message\x18\x1c \x01(\v29.protobuf_test_messages.proto2.TestAllRequiredTypesProto2R\x18optionalRecursiveMessage\x12S\n" +
	"\x04data\x18\xc9\x01 \x02(\n" +
	"2>.protobuf_test_messages.proto2.TestAllRequiredTypesProto2.DataR\x04data\x120\n" +
	"\rdefault_int32\x18\xf1\x01 \x02(\x05:\n" +
	"-123456789R\fdefaultInt32\x12:\n" +
	"\rdefault_int64\x18\xf2\x01 \x02(\x03:\x14-9123456789123456789R\fdefaultInt64\x122\n" +
	"\x0edefault_uint32\x18\xf3\x01 \x02(\r:\n" +
	"2123456789R\rdefaultUint32\x12<\n" +
	"\x0edefault_uint64\x18\xf4\x01 \x02(\x04:\x1410123456789123456789R\rdefaultUint64\x122\n" +
	"\x0edefault_sint32\x18\xf5\x01 \x02(\x11:\n" +
	"-123456789R\rdefaultSint32\x12<\n" +
	"\x0edefault_sint64\x18\xf6\x01 \x02(\x12:\x14-9123456789123456789R\rdefaultSint64\x124\n" +
	"\x0fdefault_fixed32\x18\xf7\x01 \x02(\a:\n" +
	"2123456789R\x0edefaultFixed32\x12>\n" +
	"\x0fdefault_fixed64\x18\xf8\x01 \x02(\x06:\x1410123456789123456789R\x0edefaultFixed64\x126\n" +
	"\x10default_sfixed32\x18\xf9\x01 \x02(\x0f:\n" +
	"-123456789R\x0fdefaultSfixed32\x12@\n" +
	"\x10default_sfixed64\x18\xfa\x01 \x02(\x10:\x14-9123456789123456789R\x0fdefaultSfixed64\x12+\n" +
	"\rdefault_float\x18\xfb\x01 \x02(\x02:\x059e+09R\fdefaultFloat\x12-\n" +
	"\x0edefault_double\x18\xfc\x01 \x02(\x01:\x057e+22R\rdefaultDouble\x12(\n" +
	"\fdefault_bool\x18\xfd\x01 \x02(\b:\x04trueR\vdefaultBool\x12/\n" +
	"\x0edefault_string\x18\xfe\x01 \x02(\t:\aRosebudR\rdefaultString\x12,\n" +
	"\rdefault_bytes\x18\xff\x01 \x02(\f:\x06joshuaR\fdefaultBytes\x1a\xe8\x01\n" +
	"\rNestedMessage\x12\f\n" +
	"\x01a\x18\x01 \x02(\x05R\x01a\x12[\n" +
	"\vcorecursive\x18\x02 \x02(\v29.protobuf_test_messages.proto2.TestAllRequiredTypesProto2R\vcorecursive\x12l\n" +
	"\x14optional_corecursive\x18\x03 \x01(\v29.protobuf_test_messages.proto2.TestAllRequiredTypesProto2R\x13optionalCorecursive\x1aL\n" +
	"\x04Data\x12 \n" +
	"\vgroup_int32\x18\xca\x01 \x02(\x05R\n" +
	"groupInt32\x12\"\n" +
	"\fgroup_uint32\x18\xcb\x01 \x02(\rR\vgroupUint32\x1a!\n" +
	"\x11MessageSetCorrect*\b\b\x04\x10\xff\xff\xff\xff\a:\x02\b\x01\x1a\x8a\x02\n" +
	"\x1bMessageSetCorrectExtension1\x12\x10\n" +
	"\x03str\x18\x19 \x02(\tR\x03str2\xd8\x01\n" +
	"\x15message_set_extension\x12K.protobuf_test_messages.proto2.TestAllRequiredTypesProto2.MessageSetCorrect\x18\xf9\xbb^ \x01(\v2U.protobuf_test_messages.proto2.TestAllRequiredTypesProto2.MessageSetCorrectExtension1R\x13messageSetExtension\x1a\x87\x02\n" +
	"\x1bMessageSetCorrectExtension2\x12\f\n" +
	"\x01i\x18\t \x02(\x05R\x01i2\xd9\x01\n" +
	"\x15message_set_extension\x12K.protobuf_test_messages.proto2.TestAllRequiredTypesProto2.MessageSetCorrect\x18\x90\xb3\xfc\x01 \x01(\v2U.protobuf_test_messages.proto2.TestAllRequiredTypesProto2.MessageSetCorrectExtension2R\x13messageSetExtension\"9\n" +
	"\n" +
	"NestedEnum\x12\a\n" +
	"\x03FOO\x10\x00\x12\a\n" +
	"\x03BAR\x10\x01\x12\a\n" +
	"\x03BAZ\x10\x02\x12\x10\n" +
	"\x03NEG\x10\xff\xff\xff\xff\xff\xff\xff\xff\xff\x01*\x05\bx\x10\xc9\x01J\x06\b\xe8\a\x10\x90N\"\x91\x03\n" +
	"\x0eTestLargeOneof\x12B\n" +
	"\x02a1\x18\x01 \x01(\v20.protobuf_test_messages.proto2.TestLargeOneof.A1H\x00R\x02a1\x12B\n" +
	"\x02a2\x18\x02 \x01(\v20.protobuf_test_messages.proto2.TestLargeOneof.A2H\x00R\x02a2\x12B\n" +
	"\x02a3\x18\x03 \x01(\v20.protobuf_test_messages.proto2.TestLargeOneof.A3H\x00R\x02a3\x12B\n" +
	"\x02a4\x18\x04 \x01(\v20.protobuf_test_messages.proto2.TestLargeOneof.A4H\x00R\x02a4\x12B\n" +
	"\x02a5\x18\x05 \x01(\v20.protobuf_test_messages.proto2.TestLargeOneof.A5H\x00R\x02a5\x1a\x04\n" +
	"\x02A1\x1a\x04\n" +
	"\x02A2\x1a\x04\n" +
	"\x02A3\x1a\x04\n" +
	"\x02A4\x1a\x04\n" +
	"\x02A5B\r\n" +
	"\vlarge_oneof*F\n" +
	"\x11ForeignEnumProto2\x12\x0f\n" +
	"\vFOREIGN_FOO\x10\x00\x12\x0f\n" +
	"\vFOREIGN_BAR\x10\x01\x12\x0f\n" +
	"\vFOREIGN_BAZ\x10\x02:Z\n" +
	"\x0fextension_int32\x121.protobuf_test_messages.proto2.TestAllTypesProto2\x18x \x01(\x05R\x0eextensionInt32:|\n" +
	"\n" +
	"groupfield\x121.protobuf_test_messages.proto2.TestAllTypesProto2\x18y \x01(\n" +
	"2).protobuf_test_messages.proto2.GroupFieldR\n" +
	"groupfieldB8\n" +
	"(com.google.protobuf_test_messages.proto2H\x01\xf8\x01\x01\xa2\x02\x06Proto2"

var (
	file_google_protobuf_test_messages_proto2_proto_rawDescOnce sync.Once
	file_google_protobuf_test_messages_proto2_proto_rawDescData []byte
)

func file_google_protobuf_test_messages_proto2_proto_rawDescGZIP() []byte {
	file_google_protobuf_test_messages_proto2_proto_rawDescOnce.Do(func() {
		file_google_protobuf_test_messages_proto2_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_google_protobuf_test_messages_proto2_proto_rawDesc), len(file_google_protobuf_test_messages_proto2_proto_rawDesc)))
	})
	return file_google_protobuf_test_messages_proto2_proto_rawDescData
}

var file_google_protobuf_test_messages_proto2_proto_enumTypes = make([]protoimpl.EnumInfo, 4)
var file_google_protobuf_test_messages_proto2_proto_msgTypes = make([]protoimpl.MessageInfo, 49)
var file_google_protobuf_test_messages_proto2_proto_goTypes = []any{
	(ForeignEnumProto2)(0),                     // 0: protobuf_test_messages.proto2.ForeignEnumProto2
	(TestAllTypesProto2_NestedEnum)(0),         // 1: protobuf_test_messages.proto2.TestAllTypesProto2.NestedEnum
	(EnumOnlyProto2_Bool)(0),                   // 2: protobuf_test_messages.proto2.EnumOnlyProto2.Bool
	(TestAllRequiredTypesProto2_NestedEnum)(0), // 3: protobuf_test_messages.proto2.TestAllRequiredTypesProto2.NestedEnum
	(*TestAllTypesProto2)(nil),                 // 4: protobuf_test_messages.proto2.TestAllTypesProto2
	(*ForeignMessageProto2)(nil),               // 5: protobuf_test_messages.proto2.ForeignMessageProto2
	(*GroupField)(nil),                         // 6: protobuf_test_messages.proto2.GroupField
	(*UnknownToTestAllTypes)(nil),              // 7: protobuf_test_messages.proto2.UnknownToTestAllTypes
	(*NullHypothesisProto2)(nil),               // 8: protobuf_test_messages.proto2.NullHypothesisProto2
	(*EnumOnlyProto2)(nil),                     // 9: protobuf_test_messages.proto2.EnumOnlyProto2
	(*OneStringProto2)(nil),                    // 10: protobuf_test_messages.proto2.OneStringProto2
	(*ProtoWithKeywords)(nil),                  // 11: protobuf_test_messages.proto2.ProtoWithKeywords
	(*TestAllRequiredTypesProto2)(nil),         // 12: protobuf_test_messages.proto2.TestAllRequiredTypesProto2
	(*TestLargeOneof)(nil),                     // 13: protobuf_test_messages.proto2.TestLargeOneof
	(*TestAllTypesProto2_NestedMessage)(nil),   // 14: protobuf_test_messages.proto2.TestAllTypesProto2.NestedMessage
	nil,                                        // 15: protobuf_test_messages.proto2.TestAllTypesProto2.MapInt32Int32Entry
	nil,                                        // 16: protobuf_test_messages.proto2.TestAllTypesProto2.MapInt64Int64Entry
	nil,                                        // 17: protobuf_test_messages.proto2.TestAllTypesProto2.MapUint32Uint32Entry
	nil,                                        // 18: protobuf_test_messages.proto2.TestAllTypesProto2.MapUint64Uint64Entry
	nil,                                        // 19: protobuf_test_messages.proto2.TestAllTypesProto2.MapSint32Sint32Entry
	nil,                                        // 20: protobuf_test_messages.proto2.TestAllTypesProto2.MapSint64Sint64Entry
	nil,                                        // 21: protobuf_test_messages.proto2.TestAllTypesProto2.MapFixed32Fixed32Entry
	nil,                                        // 22: protobuf_test_messages.proto2.TestAllTypesProto2.MapFixed64Fixed64Entry
	nil,                                        // 23: protobuf_test_messages.proto2.TestAllTypesProto2.MapSfixed32Sfixed32Entry
	nil,                                        // 24: protobuf_test_messages.proto2.TestAllTypesProto2.MapSfixed64Sfixed64Entry
	nil,                                        // 25: protobuf_test_messages.proto2.TestAllTypesProto2.MapInt32BoolEntry
	nil,                                        // 26: protobuf_test_messages.proto2.TestAllTypesProto2.MapInt32FloatEntry
	nil,                                        // 27: protobuf_test_messages.proto2.TestAllTypesProto2.MapInt32DoubleEntry
	nil,                                        // 28: protobuf_test_messages.proto2.TestAllTypesProto2.MapInt32NestedMessageEntry
	nil,                                        // 29: protobuf_test_messages.proto2.TestAllTypesProto2.MapBoolBoolEntry
	nil,                                        // 30: protobuf_test_messages.proto2.TestAllTypesProto2.MapStringStringEntry
	nil,                                        // 31: protobuf_test_messages.proto2.TestAllTypesProto2.MapStringBytesEntry
	nil,                                        // 32: protobuf_test_messages.proto2.TestAllTypesProto2.MapStringNestedMessageEntry
	nil,                                        // 33: protobuf_test_messages.proto2.TestAllTypesProto2.MapStringForeignMessageEntry
	nil,                                        // 34: protobuf_test_messages.proto2.TestAllTypesProto2.MapStringNestedEnumEntry
	nil,                                        // 35: protobuf_test_messages.proto2.TestAllTypesProto2.MapStringForeignEnumEntry
	(*TestAllTypesProto2_Data)(nil),            // 36: protobuf_test_messages.proto2.TestAllTypesProto2.Data
	(*TestAllTypesProto2_MultiWordGroupField)(nil),                 // 37: protobuf_test_messages.proto2.TestAllTypesProto2.MultiWordGroupField
	(*TestAllTypesProto2_MessageSetCorrect)(nil),                   // 38: protobuf_test_messages.proto2.TestAllTypesProto2.MessageSetCorrect
	(*TestAllTypesProto2_MessageSetCorrectExtension1)(nil),         // 39: protobuf_test_messages.proto2.TestAllTypesProto2.MessageSetCorrectExtension1
	(*TestAllTypesProto2_MessageSetCorrectExtension2)(nil),         // 40: protobuf_test_messages.proto2.TestAllTypesProto2.MessageSetCorrectExtension2
	(*TestAllTypesProto2_ExtensionWithOneof)(nil),                  // 41: protobuf_test_messages.proto2.TestAllTypesProto2.ExtensionWithOneof
	(*UnknownToTestAllTypes_OptionalGroup)(nil),                    // 42: protobuf_test_messages.proto2.UnknownToTestAllTypes.OptionalGroup
	(*TestAllRequiredTypesProto2_NestedMessage)(nil),               // 43: protobuf_test_messages.proto2.TestAllRequiredTypesProto2.NestedMessage
	(*TestAllRequiredTypesProto2_Data)(nil),                        // 44: protobuf_test_messages.proto2.TestAllRequiredTypesProto2.Data
	(*TestAllRequiredTypesProto2_MessageSetCorrect)(nil),           // 45: protobuf_test_messages.proto2.TestAllRequiredTypesProto2.MessageSetCorrect
	(*TestAllRequiredTypesProto2_MessageSetCorrectExtension1)(nil), // 46: protobuf_test_messages.proto2.TestAllRequiredTypesProto2.MessageSetCorrectExtension1
	(*TestAllRequiredTypesProto2_MessageSetCorrectExtension2)(nil), // 47: protobuf_test_messages.proto2.TestAllRequiredTypesProto2.MessageSetCorrectExtension2
	(*TestLargeOneof_A1)(nil),                                      // 48: protobuf_test_messages.proto2.TestLargeOneof.A1
	(*TestLargeOneof_A2)(nil),                                      // 49: protobuf_test_messages.proto2.TestLargeOneof.A2
	(*TestLargeOneof_A3)(nil),                                      // 50: protobuf_test_messages.proto2.TestLargeOneof.A3
	(*TestLargeOneof_A4)(nil),                                      // 51: protobuf_test_messages.proto2.TestLargeOneof.A4
	(*TestLargeOneof_A5)(nil),                                      // 52: protobuf_test_messages.proto2.TestLargeOneof.A5
}
var file_google_protobuf_test_messages_proto2_proto_depIdxs = []int32{
	14, // 0: protobuf_test_messages.proto2.TestAllTypesProto2.optional_nested_message:type_name -> protobuf_test_messages.proto2.TestAllTypesProto2.NestedMessage
	5,  // 1: protobuf_test_messages.proto2.TestAllTypesProto2.optional_foreign_message:type_name -> protobuf_test_messages.proto2.ForeignMessageProto2
	1,  // 2: protobuf_test_messages.proto2.TestAllTypesProto2.optional_nested_enum:type_name -> protobuf_test_messages.proto2.TestAllTypesProto2.NestedEnum
	0,  // 3: protobuf_test_messages.proto2.TestAllTypesProto2.optional_foreign_enum:type_name -> protobuf_test_messages.proto2.ForeignEnumProto2
	4,  // 4: protobuf_test_messages.proto2.TestAllTypesProto2.recursive_message:type_name -> protobuf_test_messages.proto2.TestAllTypesProto2
	14, // 5: protobuf_test_messages.proto2.TestAllTypesProto2.repeated_nested_message:type_name -> protobuf_test_messages.proto2.TestAllTypesProto2.NestedMessage
	5,  // 6: protobuf_test_messages.proto2.TestAllTypesProto2.repeated_foreign_message:type_name -> protobuf_test_messages.proto2.ForeignMessageProto2
	1,  // 7: protobuf_test_messages.proto2.TestAllTypesProto2.repeated_nested_enum:type_name -> protobuf_test_messages.proto2.TestAllTypesProto2.NestedEnum
	0,  // 8: protobuf_test_messages.proto2.TestAllTypesProto2.repeated_foreign_enum:type_name -> protobuf_test_messages.proto2.ForeignEnumProto2
	1,  // 9: protobuf_test_messages.proto2.TestAllTypesProto2.packed_nested_enum:type_name -> protobuf_test_messages.proto2.TestAllTypesProto2.NestedEnum
	1,  // 10: protobuf_test_messages.proto2.TestAllTypesProto2.unpacked_nested_enum:type_name -> protobuf_test_messages.proto2.TestAllTypesProto2.NestedEnum
	15, // 11: protobuf_test_messages.proto2.TestAllTypesProto2.map_int32_int32:type_name -> protobuf_test_messages.proto2.TestAllTypesProto2.MapInt32Int32Entry
	16, // 12: protobuf_test_messages.proto2.TestAllTypesProto2.map_int64_int64:type_name -> protobuf_test_messages.proto2.TestAllTypesProto2.MapInt64Int64Entry
	17, // 13: protobuf_test_messages.proto2.TestAllTypesProto2.map_uint32_uint32:type_name -> protobuf_test_messages.proto2.TestAllTypesProto2.MapUint32Uint32Entry
	18, // 14: protobuf_test_messages.proto2.TestAllTypesProto2.map_uint64_uint64:type_name -> protobuf_test_messages.proto2.TestAllTypesProto2.MapUint64Uint64Entry
	19, // 15: protobuf_test_messages.proto2.TestAllTypesProto2.map_sint32_sint32:type_name -> protobuf_test_messages.proto2.TestAllTypesProto2.MapSint32Sint32Entry
	20, // 16: protobuf_test_messages.proto2.TestAllTypesProto2.map_sint64_sint64:type_name -> protobuf_test_messages.proto2.TestAllTypesProto2.MapSint64Sint64Entry
	21, // 17: protobuf_test_messages.proto2.TestAllTypesProto2.map_fixed32_fixed32:type_name -> protobuf_test_messages.proto2.TestAllTypesProto2.MapFixed32Fixed32Entry
	22, // 18: protobuf_test_messages.proto2.TestAllTypesProto2.map_fixed64_fixed64:type_name -> protobuf_test_messages.proto2.TestAllTypesProto2.MapFixed64Fixed64Entry
	23, // 19: protobuf_test_messages.proto2.TestAllTypesProto2.map_sfixed32_sfixed32:type_name -> protobuf_test_messages.proto2.TestAllTypesProto2.MapSfixed32Sfixed32Entry
	24, // 20: protobuf_test_messages.proto2.TestAllTypesProto2.map_sfixed64_sfixed64:type_name -> protobuf_test_messages.proto2.TestAllTypesProto2.MapSfixed64Sfixed64Entry
	25, // 21: protobuf_test_messages.proto2.TestAllTypesProto2.map_int32_bool:type_name -> protobuf_test_messages.proto2.TestAllTypesProto2.MapInt32BoolEntry
	26, // 22: protobuf_test_messages.proto2.TestAllTypesProto2.map_int32_float:type_name -> protobuf_test_messages.proto2.TestAllTypesProto2.MapInt32FloatEntry
	27, // 23: protobuf_test_messages.proto2.TestAllTypesProto2.map_int32_double:type_name -> protobuf_test_messages.proto2.TestAllTypesProto2.MapInt32DoubleEntry
	28, // 24: protobuf_test_messages.proto2.TestAllTypesProto2.map_int32_nested_message:type_name -> protobuf_test_messages.proto2.TestAllTypesProto2.MapInt32NestedMessageEntry
	29, // 25: protobuf_test_messages.proto2.TestAllTypesProto2.map_bool_bool:type_name -> protobuf_test_messages.proto2.TestAllTypesProto2.MapBoolBoolEntry
	30, // 26: protobuf_test_messages.proto2.TestAllTypesProto2.map_string_string:type_name -> protobuf_test_messages.proto2.TestAllTypesProto2.MapStringStringEntry
	31, // 27: protobuf_test_messages.proto2.TestAllTypesProto2.map_string_bytes:type_name -> protobuf_test_messages.proto2.TestAllTypesProto2.MapStringBytesEntry
	32, // 28: protobuf_test_messages.proto2.TestAllTypesProto2.map_string_nested_message:type_name -> protobuf_test_messages.proto2.TestAllTypesProto2.MapStringNestedMessageEntry
	33, // 29: protobuf_test_messages.proto2.TestAllTypesProto2.map_string_foreign_message:type_name -> protobuf_test_messages.proto2.TestAllTypesProto2.MapStringForeignMessageEntry
	34, // 30: protobuf_test_messages.proto2.TestAllTypesProto2.map_string_nested_enum:type_name -> protobuf_test_messages.proto2.TestAllTypesProto2.MapStringNestedEnumEntry
	35, // 31: protobuf_test_messages.proto2.TestAllTypesProto2.map_string_foreign_enum:type_name -> protobuf_test_messages.proto2.TestAllTypesProto2.MapStringForeignEnumEntry
	14, // 32: protobuf_test_messages.proto2.TestAllTypesProto2.oneof_nested_message:type_name -> protobuf_test_messages.proto2.TestAllTypesProto2.NestedMessage
	1,  // 33: protobuf_test_messages.proto2.TestAllTypesProto2.oneof_enum:type_name -> protobuf_test_messages.proto2.TestAllTypesProto2.NestedEnum
	36, // 34: protobuf_test_messages.proto2.TestAllTypesProto2.data:type_name -> protobuf_test_messages.proto2.TestAllTypesProto2.Data
	37, // 35: protobuf_test_messages.proto2.TestAllTypesProto2.multiwordgroupfield:type_name -> protobuf_test_messages.proto2.TestAllTypesProto2.MultiWordGroupField
	38, // 36: protobuf_test_messages.proto2.TestAllTypesProto2.message_set_correct:type_name -> protobuf_test_messages.proto2.TestAllTypesProto2.MessageSetCorrect
	5,  // 37: protobuf_test_messages.proto2.UnknownToTestAllTypes.nested_message:type_name -> protobuf_test_messages.proto2.ForeignMessageProto2
	42, // 38: protobuf_test_messages.proto2.UnknownToTestAllTypes.optionalgroup:type_name -> protobuf_test_messages.proto2.UnknownToTestAllTypes.OptionalGroup
	43, // 39: protobuf_test_messages.proto2.TestAllRequiredTypesProto2.required_nested_message:type_name -> protobuf_test_messages.proto2.TestAllRequiredTypesProto2.NestedMessage
	5,  // 40: protobuf_test_messages.proto2.TestAllRequiredTypesProto2.required_foreign_message:type_name -> protobuf_test_messages.proto2.ForeignMessageProto2
	3,  // 41: protobuf_test_messages.proto2.TestAllRequiredTypesProto2.required_nested_enum:type_name -> protobuf_test_messages.proto2.TestAllRequiredTypesProto2.NestedEnum
	0,  // 42: protobuf_test_messages.proto2.TestAllRequiredTypesProto2.required_foreign_enum:type_name -> protobuf_test_messages.proto2.ForeignEnumProto2
	12, // 43: protobuf_test_messages.proto2.TestAllRequiredTypesProto2.recursive_message:type_name -> protobuf_test_messages.proto2.TestAllRequiredTypesProto2
	12, // 44: protobuf_test_messages.proto2.TestAllRequiredTypesProto2.optional_recursive_message:type_name -> protobuf_test_messages.proto2.TestAllRequiredTypesProto2
	44, // 45: protobuf_test_messages.proto2.TestAllRequiredTypesProto2.data:type_name -> protobuf_test_messages.proto2.TestAllRequiredTypesProto2.Data
	48, // 46: protobuf_test_messages.proto2.TestLargeOneof.a1:type_name -> protobuf_test_messages.proto2.TestLargeOneof.A1
	49, // 47: protobuf_test_messages.proto2.TestLargeOneof.a2:type_name -> protobuf_test_messages.proto2.TestLargeOneof.A2
	50, // 48: protobuf_test_messages.proto2.TestLargeOneof.a3:type_name -> protobuf_test_messages.proto2.TestLargeOneof.A3
	51, // 49: protobuf_test_messages.proto2.TestLargeOneof.a4:type_name -> protobuf_test_messages.proto2.TestLargeOneof.A4
	52, // 50: protobuf_test_messages.proto2.TestLargeOneof.a5:type_name -> protobuf_test_messages.proto2.TestLargeOneof.A5
	4,  // 51: protobuf_test_messages.proto2.TestAllTypesProto2.NestedMessage.corecursive:type_name -> protobuf_test_messages.proto2.TestAllTypesProto2
	14, // 52: protobuf_test_messages.proto2.TestAllTypesProto2.MapInt32NestedMessageEntry.value:type_name -> protobuf_test_messages.proto2.TestAllTypesProto2.NestedMessage
	14, // 53: protobuf_test_messages.proto2.TestAllTypesProto2.MapStringNestedMessageEntry.value:type_name -> protobuf_test_messages.proto2.TestAllTypesProto2.NestedMessage
	5,  // 54: protobuf_test_messages.proto2.TestAllTypesProto2.MapStringForeignMessageEntry.value:type_name -> protobuf_test_messages.proto2.ForeignMessageProto2
	1,  // 55: protobuf_test_messages.proto2.TestAllTypesProto2.MapStringNestedEnumEntry.value:type_name -> protobuf_test_messages.proto2.TestAllTypesProto2.NestedEnum
	0,  // 56: protobuf_test_messages.proto2.TestAllTypesProto2.MapStringForeignEnumEntry.value:type_name -> protobuf_test_messages.proto2.ForeignEnumProto2
	12, // 57: protobuf_test_messages.proto2.TestAllRequiredTypesProto2.NestedMessage.corecursive:type_name -> protobuf_test_messages.proto2.TestAllRequiredTypesProto2
	12, // 58: protobuf_test_messages.proto2.TestAllRequiredTypesProto2.NestedMessage.optional_corecursive:type_name -> protobuf_test_messages.proto2.TestAllRequiredTypesProto2
	4,  // 59: protobuf_test_messages.proto2.extension_int32:extendee -> protobuf_test_messages.proto2.TestAllTypesProto2
	4,  // 60: protobuf_test_messages.proto2.groupfield:extendee -> protobuf_test_messages.proto2.TestAllTypesProto2
	38, // 61: protobuf_test_messages.proto2.TestAllTypesProto2.MessageSetCorrectExtension1.message_set_extension:extendee -> protobuf_test_messages.proto2.TestAllTypesProto2.MessageSetCorrect
	38, // 62: protobuf_test_messages.proto2.TestAllTypesProto2.MessageSetCorrectExtension2.message_set_extension:extendee -> protobuf_test_messages.proto2.TestAllTypesProto2.MessageSetCorrect
	38, // 63: protobuf_test_messages.proto2.TestAllTypesProto2.ExtensionWithOneof.extension_with_oneof:extendee -> protobuf_test_messages.proto2.TestAllTypesProto2.MessageSetCorrect
	45, // 64: protobuf_test_messages.proto2.TestAllRequiredTypesProto2.MessageSetCorrectExtension1.message_set_extension:extendee -> protobuf_test_messages.proto2.TestAllRequiredTypesProto2.MessageSetCorrect
	45, // 65: protobuf_test_messages.proto2.TestAllRequiredTypesProto2.MessageSetCorrectExtension2.message_set_extension:extendee -> protobuf_test_messages.proto2.TestAllRequiredTypesProto2.MessageSetCorrect
	6,  // 66: protobuf_test_messages.proto2.groupfield:type_name -> protobuf_test_messages.proto2.GroupField
	39, // 67: protobuf_test_messages.proto2.TestAllTypesProto2.MessageSetCorrectExtension1.message_set_extension:type_name -> protobuf_test_messages.proto2.TestAllTypesProto2.MessageSetCorrectExtension1
	40, // 68: protobuf_test_messages.proto2.TestAllTypesProto2.MessageSetCorrectExtension2.message_set_extension:type_name -> protobuf_test_messages.proto2.TestAllTypesProto2.MessageSetCorrectExtension2
	41, // 69: protobuf_test_messages.proto2.TestAllTypesProto2.ExtensionWithOneof.extension_with_oneof:type_name -> protobuf_test_messages.proto2.TestAllTypesProto2.ExtensionWithOneof
	46, // 70: protobuf_test_messages.proto2.TestAllRequiredTypesProto2.MessageSetCorrectExtension1.message_set_extension:type_name -> protobuf_test_messages.proto2.TestAllRequiredTypesProto2.MessageSetCorrectExtension1
	47, // 71: protobuf_test_messages.proto2.TestAllRequiredTypesProto2.MessageSetCorrectExtension2.message_set_extension:type_name -> protobuf_test_messages.proto2.TestAllRequiredTypesProto2.MessageSetCorrectExtension2
	72, // [72:72] is the sub-list for method output_type
	72, // [72:72] is the sub-list for method input_type
	66, // [66:72] is the sub-list for extension type_name
	59, // [59:66] is the sub-list for extension extendee
	0,  // [0:59] is the sub-list for field type_name
}

func init() { file_google_protobuf_test_messages_proto2_proto_init() }
func file_google_protobuf_test_messages_proto2_proto_init() {
	if File_google_protobuf_test_messages_proto2_proto != nil {
		return
	}
	file_google_protobuf_test_messages_proto2_proto_msgTypes[0].OneofWrappers = []any{
		(*TestAllTypesProto2_OneofUint32)(nil),
		(*TestAllTypesProto2_OneofNestedMessage)(nil),
		(*TestAllTypesProto2_OneofString)(nil),
		(*TestAllTypesProto2_OneofBytes)(nil),
		(*TestAllTypesProto2_OneofBool)(nil),
		(*TestAllTypesProto2_OneofUint64)(nil),
		(*TestAllTypesProto2_OneofFloat)(nil),
		(*TestAllTypesProto2_OneofDouble)(nil),
		(*TestAllTypesProto2_OneofEnum)(nil),
	}
	file_google_protobuf_test_messages_proto2_proto_msgTypes[9].OneofWrappers = []any{
		(*TestLargeOneof_A1_)(nil),
		(*TestLargeOneof_A2_)(nil),
		(*TestLargeOneof_A3_)(nil),
		(*TestLargeOneof_A4_)(nil),
		(*TestLargeOneof_A5_)(nil),
	}
	file_google_protobuf_test_messages_proto2_proto_msgTypes[37].OneofWrappers = []any{
		(*TestAllTypesProto2_ExtensionWithOneof_A)(nil),
		(*TestAllTypesProto2_ExtensionWithOneof_B)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_google_protobuf_test_messages_proto2_proto_rawDesc), len(file_google_protobuf_test_messages_proto2_proto_rawDesc)),
			NumEnums:      4,
			NumMessages:   49,
			NumExtensions: 7,
			NumServices:   0,
		},
		GoTypes:           file_google_protobuf_test_messages_proto2_proto_goTypes,
		DependencyIndexes: file_google_protobuf_test_messages_proto2_proto_depIdxs,
		EnumInfos:         file_google_protobuf_test_messages_proto2_proto_enumTypes,
		MessageInfos:      file_google_protobuf_test_messages_proto2_proto_msgTypes,
		ExtensionInfos:    file_google_protobuf_test_messages_proto2_proto_extTypes,
	}.Build()
	File_google_protobuf_test_messages_proto2_proto = out.File
	file_google_protobuf_test_messages_proto2_proto_goTypes = nil
	file_google_protobuf_test_messages_proto2_proto_depIdxs = nil
}
