/* Copyright JS Foundation and other contributors, http://js.foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* This file is automatically generated by the gen-strings.py script
 * from ecma-error-messages.ini. Do not edit! */

#if JERRY_BUILTIN_REGEXP
ECMA_ERROR_DEF (ECMA_ERR_INVALID_GROUP, "Invalid group")
ECMA_ERROR_DEF (ECMA_ERR_INVALID_ESCAPE, "Invalid escape")
#endif /* JERRY_BUILTIN_REGEXP */
#if JERRY_BUILTIN_ATOMICS || JERRY_BUILTIN_TYPEDARRAY
ECMA_ERROR_DEF (ECMA_ERR_INVALID_LENGTH, "Invalid length")
#endif /* JERRY_BUILTIN_ATOMICS \
|| JERRY_BUILTIN_TYPEDARRAY */
#if JERRY_BUILTIN_TYPEDARRAY
ECMA_ERROR_DEF (ECMA_ERR_INVALID_OFFSET, "Invalid offset")
#endif /* JERRY_BUILTIN_TYPEDARRAY */
ECMA_ERROR_DEF (ECMA_ERR_OBJECT_EXPECTED, "Object expected")
#if JERRY_BUILTIN_ANNEXB && JERRY_BUILTIN_REGEXP
ECMA_ERROR_DEF (ECMA_ERR_INVALID_ARGUMENT, "Invalid argument")
#endif /* JERRY_BUILTIN_ANNEXB && JERRY_BUILTIN_REGEXP */
ECMA_ERROR_DEF (ECMA_ERR_INVALID_ENCODING, "Invalid encoding")
#if JERRY_BUILTIN_REGEXP
ECMA_ERROR_DEF (ECMA_ERR_NOTHING_TO_REPEAT, "Nothing to repeat")
#endif /* JERRY_BUILTIN_REGEXP */
ECMA_ERROR_DEF (ECMA_ERR_EXPECTED_AN_OBJECT, "Expected an object")
ECMA_ERROR_DEF (ECMA_ERR_INVALID_CAPABILITY, "Invalid capability")
#if JERRY_BUILTIN_STRING
ECMA_ERROR_DEF (ECMA_ERR_INVALID_CODE_POINT, "Invalid code point")
#endif /* JERRY_BUILTIN_STRING */
#if JERRY_BUILTIN_REGEXP
ECMA_ERROR_DEF (ECMA_ERR_INVALID_QUANTIFIER, "Invalid quantifier")
#endif /* JERRY_BUILTIN_REGEXP */
#if JERRY_BUILTIN_TYPEDARRAY
ECMA_ERROR_DEF (ECMA_ERR_NO_SOURCE_ARGUMENT, "No source argument")
#endif /* JERRY_BUILTIN_TYPEDARRAY */
#if JERRY_BUILTIN_REGEXP
ECMA_ERROR_DEF (ECMA_ERR_UNTERMINATED_GROUP, "Unterminated group")
#endif /* JERRY_BUILTIN_REGEXP */
ECMA_ERROR_DEF (ECMA_ERR_EXPECTED_A_FUNCTION, "Expected a function")
#if JERRY_BUILTIN_JSON
ECMA_ERROR_DEF (ECMA_ERR_INVALID_JSON_FORMAT, "Invalid JSON format")
#endif /* JERRY_BUILTIN_JSON */
ECMA_ERROR_DEF (ECMA_ERR_INVALID_UTF8_STRING, "Invalid UTF8 string")
#if JERRY_BUILTIN_STRING
ECMA_ERROR_DEF (ECMA_ERR_INVALID_COUNT_VALUE, "Invalid count value")
#endif /* JERRY_BUILTIN_STRING */
#if !(JERRY_BUILTIN_REALMS)
ECMA_ERROR_DEF (ECMA_ERR_REALMS_ARE_DISABLED, "Realms are disabled")
#endif /* !(JERRY_BUILTIN_REALMS) */
ECMA_ERROR_DEF (ECMA_ERR_UNDEFINED_REFERENCE, "Undefined reference")
ECMA_ERROR_DEF (ECMA_ERR_INVALID_ARRAY_LENGTH, "Invalid Array length")
#if JERRY_BUILTIN_REGEXP
ECMA_ERROR_DEF (ECMA_ERR_INVALID_REGEXP_FLAGS, "Invalid RegExp flags")
#endif /* JERRY_BUILTIN_REGEXP */
#if JERRY_BUILTIN_JSON
ECMA_ERROR_DEF (ECMA_ERR_JSON_STRINGIFY_ERROR, "JSON stringify error")
#endif /* JERRY_BUILTIN_JSON */
#if JERRY_BUILTIN_REGEXP
ECMA_ERROR_DEF (ECMA_ERR_STACK_LIMIT_EXCEEDED, "Stack limit exceeded")
#endif /* JERRY_BUILTIN_REGEXP */
#if JERRY_BUILTIN_WEAKREF
ECMA_ERROR_DEF (ECMA_ERR_TARGET_IS_NOT_OBJECT, "Target is not Object")
#endif /* JERRY_BUILTIN_WEAKREF */
#if JERRY_BUILTIN_BIGINT
ECMA_ERROR_DEF (ECMA_ERR_BIGINT_VALUE_EXCPECTED, "BigInt value expected")
#endif /* JERRY_BUILTIN_BIGINT */
ECMA_ERROR_DEF (ECMA_ERR_BINDING_CANNOT_SET, "Binding cannot be set")
#if JERRY_BUILTIN_STRING
ECMA_ERROR_DEF (ECMA_ERR_INVALID_STRING_, "Invalid string length")
#endif /* JERRY_BUILTIN_STRING */
#if JERRY_BUILTIN_CONTAINER
ECMA_ERROR_DEF (ECMA_ERR_KEY_MUST_BE_AN_OBJECT, "Key must be an object")
#endif /* JERRY_BUILTIN_CONTAINER */
#if JERRY_BUILTIN_ARRAY
ECMA_ERROR_DEF (ECMA_ERR_MISSING_ARRAY_ELEMENT, "Missing Array element")
#endif /* JERRY_BUILTIN_ARRAY */
#if JERRY_BUILTIN_WEAKREF
ECMA_ERROR_DEF (ECMA_ERR_TARGET_IS_NOT_WEAKREF, "Target is not weakRef")
#endif /* JERRY_BUILTIN_WEAKREF */
#if JERRY_BUILTIN_PROXY
ECMA_ERROR_DEF (ECMA_ERR_TARGET_NOT_EXTENSIBLE, "Target not extensible")
#endif /* JERRY_BUILTIN_PROXY */
#if JERRY_BUILTIN_ANNEXB
ECMA_ERROR_DEF (ECMA_ERR_GETTER_IS_NOT_CALLABLE, "Getter is not callable")
#endif /* JERRY_BUILTIN_ANNEXB */
#if JERRY_BUILTIN_PROXY
ECMA_ERROR_DEF (ECMA_ERR_HANDLER_CANNOT_BE_NULL, "Handler cannot be null")
#endif /* JERRY_BUILTIN_PROXY */
ECMA_ERROR_DEF (ECMA_ERR_INVALID_UTF8_CHARACTER, "Invalid UTF8 character")
ECMA_ERROR_DEF (ECMA_ERR_INVALID_UTF8_CODEPOINT, "Invalid UTF8 codepoint")
#if JERRY_BUILTIN_CONTAINER
ECMA_ERROR_DEF (ECMA_ERR_INVALID_CONTAINER_TYPE, "Invalid container type")
#endif /* JERRY_BUILTIN_CONTAINER */
#if JERRY_BUILTIN_TYPEDARRAY
ECMA_ERROR_DEF (ECMA_ERR_INVALID_RANGE_OF_INDEX, "Invalid range of index")
#endif /* JERRY_BUILTIN_TYPEDARRAY */
#if !(JERRY_BUILTIN_PROXY)
ECMA_ERROR_DEF (ECMA_ERR_PROXY_IS_NOT_SUPPORTED, "Proxy is not supported")
#endif /* !(JERRY_BUILTIN_PROXY) */
#if !(JERRY_BUILTIN_REALMS)
ECMA_ERROR_DEF (ECMA_ERR_REALM_IS_NOT_AVAILABLE, "Realm is not available")
#endif /* !(JERRY_BUILTIN_REALMS) */
#if JERRY_BUILTIN_BIGINT
ECMA_ERROR_DEF (ECMA_ERR_BIGINT_ZERO_DIVISION, "BigInt division by zero")
#endif /* JERRY_BUILTIN_BIGINT */
ECMA_ERROR_DEF (ECMA_ERR_EXPECTED_AN_ARRAYBUFFER, "Expected an ArrayBuffer")
#if JERRY_BUILTIN_REGEXP
ECMA_ERROR_DEF (ECMA_ERR_INVALID_CHARACTER_CLASS, "Invalid character class")
ECMA_ERROR_DEF (ECMA_ERR_INVALID_ESCAPE_SEQUENCE, "Invalid escape sequence")
#endif /* JERRY_BUILTIN_REGEXP */
#if JERRY_SNAPSHOT_EXEC
ECMA_ERROR_DEF (ECMA_ERR_INVALID_SNAPSHOT_FORMAT, "Invalid snapshot format")
#endif /* JERRY_SNAPSHOT_EXEC */
#if JERRY_BUILTIN_JSON
ECMA_ERROR_DEF (ECMA_ERR_JSON_STRING_PARSE_ERROR, "JSON string parse error")
#endif /* JERRY_BUILTIN_JSON */
#if JERRY_BUILTIN_REGEXP
ECMA_ERROR_DEF (ECMA_ERR_LONE_QUANTIFIER_BRACKET, "Lone quantifier bracket")
#endif /* JERRY_BUILTIN_REGEXP */
#if JERRY_BUILTIN_PROXY
ECMA_ERROR_DEF (ECMA_ERR_OBJECT_CANNOT_BE_FROZEN, "Object cannot be frozen")
ECMA_ERROR_DEF (ECMA_ERR_OBJECT_CANNOT_BE_SEALED, "Object cannot be sealed")
#endif /* JERRY_BUILTIN_PROXY */
#if !(JERRY_BUILTIN_REGEXP)
ECMA_ERROR_DEF (ECMA_ERR_REGEXP_IS_NOT_SUPPORTED, "RegExp is not supported")
#endif /* !(JERRY_BUILTIN_REGEXP) */
#if JERRY_BUILTIN_REGEXP
ECMA_ERROR_DEF (ECMA_ERR_UNMATCHED_CLOSE_BRACKET, "Unmatched close bracket")
#endif /* JERRY_BUILTIN_REGEXP */
#if JERRY_MODULE_SYSTEM
ECMA_ERROR_DEF (ECMA_ERR_NOT_MODULE, "Argument is not a module")
#endif /* JERRY_MODULE_SYSTEM */
ECMA_ERROR_DEF (ECMA_ERR_SET_PROTOTYPE, "Cannot set [[Prototype]]")
#if JERRY_BUILTIN_ARRAY
ECMA_ERROR_DEF (ECMA_ERR_INVALID_NEW_ARRAY_LENGTH, "Invalid new Array length")
#endif /* JERRY_BUILTIN_ARRAY */
ECMA_ERROR_DEF (ECMA_ERR_ITERATOR_IS_NOT_CALLABLE, "Iterator is not callable")
#if !(JERRY_BUILTIN_JSON)
ECMA_ERROR_DEF (ECMA_ERR_JSON_NOT_SUPPORTED, "JSON support is disabled")
#endif /* !(JERRY_BUILTIN_JSON) */
#if JERRY_MODULE_SYSTEM
ECMA_ERROR_DEF (ECMA_ERR_MODULE_IS_IN_ERROR_STATE, "Module is in error state")
#endif /* JERRY_MODULE_SYSTEM */
ECMA_ERROR_DEF (ECMA_ERR_REJECT_MUST_BE_UNDEFINED, "Reject must be undefined")
#if JERRY_MODULE_SYSTEM
ECMA_ERROR_DEF (ECMA_ERR_REQUEST_IS_NOT_AVAILABLE, "Request is not available")
#endif /* JERRY_MODULE_SYSTEM */
ECMA_ERROR_DEF (ECMA_ERR_ARGUMENT_IS_NOT_AN_OBJECT, "Argument is not an object")
#if JERRY_BUILTIN_ATOMICS
ECMA_ERROR_DEF (ECMA_ERR_ARGUMENT_NOT_SUPPORTED, "Argument is not supported")
#endif /* JERRY_BUILTIN_ATOMICS */
#if JERRY_BUILTIN_STRING
ECMA_ERROR_DEF (ECMA_ERR_INVALID_CODE_POINT_ERROR, "Error: Invalid code point")
#endif /* JERRY_BUILTIN_STRING */
#if JERRY_BUILTIN_TYPEDARRAY
ECMA_ERROR_DEF (ECMA_ERR_INVALID_TYPEDARRAY_LENGTH, "Invalid TypedArray length")
#endif /* JERRY_BUILTIN_TYPEDARRAY */
ECMA_ERROR_DEF (ECMA_ERR_INVALID_HEXADECIMAL_VALUE, "Invalid hexadecimal value")
ECMA_ERROR_DEF (ECMA_ERR_ITERATOR_IS_NOT_AN_OBJECT, "Iterator is not an object")
ECMA_ERROR_DEF (ECMA_ERR_RESOLVE_MUST_BE_UNDEFINED, "Resolve must be undefined")
#if JERRY_SNAPSHOT_SAVE
ECMA_ERROR_DEF (ECMA_ERR_SNAPSHOT_BUFFER_SMALL, "Snapshot buffer too small")
#endif /* JERRY_SNAPSHOT_SAVE */
#if JERRY_BUILTIN_JSON
ECMA_ERROR_DEF (ECMA_ERR_THE_STRUCTURE_IS_CYCLICAL, "The structure is cyclical")
#endif /* JERRY_BUILTIN_JSON */
#if JERRY_BUILTIN_REGEXP
ECMA_ERROR_DEF (ECMA_ERR_UNEXPECTED_END_OF_PATTERN, "Unexpected end of pattern")
#endif /* JERRY_BUILTIN_REGEXP */
#if JERRY_SNAPSHOT_SAVE
ECMA_ERROR_DEF (ECMA_ERR_SNAPSHOT_UNSUPPORTED_COMPILED_CODE, "Unsupported compiled code")
#endif /* JERRY_SNAPSHOT_SAVE */
#if !(JERRY_BUILTIN_BIGINT)
ECMA_ERROR_DEF (ECMA_ERR_BIGINT_NOT_SUPPORTED, "BigInt support is disabled")
#endif /* !(JERRY_BUILTIN_BIGINT) */
#if JERRY_BUILTIN_DATAVIEW
ECMA_ERROR_DEF (ECMA_ERR_EXPECTED_A_DATAVIEW_OBJECT, "Expected a DataView object")
#endif /* JERRY_BUILTIN_DATAVIEW */
ECMA_ERROR_DEF (ECMA_ERR_EXPECTED_A_FUNCTION_OBJECT, "Expected a function object")
#if JERRY_BUILTIN_TYPEDARRAY
ECMA_ERROR_DEF (ECMA_ERR_INVALID_ARRAYBUFFER_LENGTH, "Invalid ArrayBuffer length")
#endif /* JERRY_BUILTIN_TYPEDARRAY */
#if !(JERRY_MODULE_SYSTEM)
ECMA_ERROR_DEF (ECMA_ERR_MODULE_NOT_SUPPORTED, "Module support is disabled")
#endif /* !(JERRY_MODULE_SYSTEM) */
#if JERRY_BUILTIN_TYPEDARRAY
ECMA_ERROR_DEF (ECMA_ERR_OBJECT_IS_NOT_A_TYPEDARRAY, "Object is not a TypedArray")
#endif /* JERRY_BUILTIN_TYPEDARRAY */
ECMA_ERROR_DEF (ECMA_ERR_RECEIVER_MUST_BE_AN_OBJECT, "Receiver must be an object")
#if JERRY_BUILTIN_BIGINT && JERRY_BUILTIN_JSON
ECMA_ERROR_DEF (ECMA_ERR_BIGINT_SERIALIZED, "BigInt cannot be serialized")
#endif /* JERRY_BUILTIN_BIGINT && JERRY_BUILTIN_JSON */
#if JERRY_BUILTIN_CONTAINER
ECMA_ERROR_DEF (ECMA_ERR_CONTAINER_IS_NOT_AN_OBJECT, "Container is not an object.")
#endif /* JERRY_BUILTIN_CONTAINER */
#if JERRY_BUILTIN_REGEXP
ECMA_ERROR_DEF (ECMA_ERR_INVALID_HEX_ESCAPE_SEQUENCE, "Invalid hex escape sequence")
#endif /* JERRY_BUILTIN_REGEXP */
ECMA_ERROR_DEF (ECMA_ERR_INVALID_SPECIES_CONSTRUCTOR, "Invalid species constructor")
ECMA_ERROR_DEF (ECMA_ERR_PROXY_TRAP_RETURNED_FALSISH, "Proxy trap returned falsish")
#if JERRY_BUILTIN_REGEXP
ECMA_ERROR_DEF (ECMA_ERR_MIN_GREATER_THAN_MAX, "Quantifier error: min > max")
#endif /* JERRY_BUILTIN_REGEXP */
ECMA_ERROR_DEF (ECMA_ERR_SYMBOL_IS_NOT_A_CONSTRUCTOR, "Symbol is not a constructor")
#if JERRY_BUILTIN_REFLECT
ECMA_ERROR_DEF (ECMA_ERR_TARGET_IS_NOT_A_CONSTRUCTOR, "Target is not a constructor")
#endif /* JERRY_BUILTIN_REFLECT */
ECMA_ERROR_DEF (ECMA_ERR_ACCESSOR_WRITABLE, "Accessors cannot be writable")
#if !(JERRY_BUILTIN_DATAVIEW)
ECMA_ERROR_DEF (ECMA_ERR_DATA_VIEW_NOT_SUPPORTED, "DataView support is disabled")
#endif /* !(JERRY_BUILTIN_DATAVIEW) */
#if JERRY_BUILTIN_DATE
ECMA_ERROR_DEF (ECMA_ERR_DATE_MUST_BE_A_FINITE_NUMBER, "Date must be a finite number")
#endif /* JERRY_BUILTIN_DATE */
ECMA_ERROR_DEF (ECMA_ERR_LOCAL_VARIABLE_IS_REDECLARED, "Local variable is redeclared")
ECMA_ERROR_DEF (ECMA_ERR_UNSUPPORTED_BINARY_OPERATION, "Unsupported binary operation")
#if JERRY_BUILTIN_REGEXP
ECMA_ERROR_DEF (ECMA_ERR_UNTERMINATED_CHARACTER_CLASS, "Unterminated character class")
#endif /* JERRY_BUILTIN_REGEXP */
ECMA_ERROR_DEF (ECMA_ERR_ARRAYBUFFER_IS_DETACHED, "ArrayBuffer has been detached")
ECMA_ERROR_DEF (ECMA_ERR_CONSTRUCTOR_NOT_AN_OBJECT, "Constructor must be an object")
#if !(JERRY_BUILTIN_CONTAINER)
ECMA_ERROR_DEF (ECMA_ERR_CONTAINER_NOT_SUPPORTED, "Container support is disabled")
#endif /* !(JERRY_BUILTIN_CONTAINER) */
#if JERRY_BUILTIN_REALMS
ECMA_ERROR_DEF (ECMA_ERR_FIRST_ARGUMENT_IS_NOT_A_REALM, "First argument is not a realm")
#endif /* JERRY_BUILTIN_REALMS */
#if JERRY_BUILTIN_BIGINT && JERRY_BUILTIN_TYPEDARRAY
ECMA_ERROR_DEF (ECMA_ERR_INCOMPATIBLE_TYPEDARRAY_TYPES, "Incompatible TypedArray types")
#endif /* JERRY_BUILTIN_BIGINT && JERRY_BUILTIN_TYPEDARRAY */
#if JERRY_BUILTIN_TYPEDARRAY
ECMA_ERROR_DEF (ECMA_ERR_INCORRECT_TYPE_FOR_TYPEDARRAY, "Incorrect type for TypedArray")
#endif /* JERRY_BUILTIN_TYPEDARRAY */
ECMA_ERROR_DEF (ECMA_ERR_INVALID_OR_OUT_OF_RANGE_INDEX, "Invalid or out-of-range index")
#if JERRY_SNAPSHOT_SAVE
ECMA_ERROR_DEF (ECMA_ERR_MAXIMUM_SNAPSHOT_SIZE, "Maximum snapshot size reached")
#endif /* JERRY_SNAPSHOT_SAVE */
#if JERRY_MODULE_SYSTEM
ECMA_ERROR_DEF (ECMA_ERR_MODULE_CANNOT_BE_INSTANTIATED, "Module cannot be instantiated")
#endif /* JERRY_MODULE_SYSTEM */
ECMA_ERROR_DEF (ECMA_ERR_SPECIES_MUST_BE_A_CONSTRUCTOR, "Species must be a constructor")
ECMA_ERROR_DEF (ECMA_ERR_ARGUMENT_IS_NOT_A_PROXY, "Argument is not a Proxy object")
#if JERRY_BUILTIN_ATOMICS || JERRY_BUILTIN_TYPEDARRAY
ECMA_ERROR_DEF (ECMA_ERR_ARGUMENT_NOT_ARRAY_BUFFER, "Argument is not an ArrayBuffer")
#endif /* JERRY_BUILTIN_ATOMICS \
|| JERRY_BUILTIN_TYPEDARRAY */
#if JERRY_BUILTIN_CONTAINER
ECMA_ERROR_DEF (ECMA_ERR_CONSTRUCTOR_MAP_REQUIRES_NEW, "Constructor Map requires 'new'")
ECMA_ERROR_DEF (ECMA_ERR_CONSTRUCTOR_SET_REQUIRES_NEW, "Constructor Set requires 'new'")
#endif /* JERRY_BUILTIN_CONTAINER */
#if JERRY_MODULE_SYSTEM
ECMA_ERROR_DEF (ECMA_ERR_MODULE_MUST_BE_IN_LINKED_STATE, "Module must be in linked state")
ECMA_ERROR_DEF (ECMA_ERR_UNKNOWN_EXPORT, "Native module export not found")
#endif /* JERRY_MODULE_SYSTEM */
ECMA_ERROR_DEF (ECMA_ERR_PASSED_ARGUMENT_IS_NOT_A_REALM, "Passed argument is not a realm")
ECMA_ERROR_DEF (ECMA_ERR_PRIVATE_METHOD_IS_NOT_WRITABLE, "Private method is not writable")
#if JERRY_BUILTIN_BIGINT || JERRY_BUILTIN_NUMBER
ECMA_ERROR_DEF (ECMA_ERR_RADIX_IS_OUT_OF_RANGE, "Radix must be between 2 and 36")
#endif /* JERRY_BUILTIN_BIGINT \
|| JERRY_BUILTIN_NUMBER */
#if !(JERRY_SNAPSHOT_EXEC)
ECMA_ERROR_DEF (ECMA_ERR_SNAPSHOT_EXEC_DISABLED, "Snapshot execution is disabled")
#endif /* !(JERRY_SNAPSHOT_EXEC) */
#if !(JERRY_BUILTIN_TYPEDARRAY)
ECMA_ERROR_DEF (ECMA_ERR_TYPED_ARRAY_NOT_SUPPORTED, "TypedArray support is disabled")
#endif /* !(JERRY_BUILTIN_TYPEDARRAY) */
ECMA_ERROR_DEF (ECMA_ERR_UNICODE_SURROGATE_PAIR_MISSING, "Unicode surrogate pair missing")
#if JERRY_BUILTIN_REGEXP
ECMA_ERROR_DEF (ECMA_ERR_INVALID_CONTROL_ESCAPE_SEQUENCE, "Invalid control escape sequence")
ECMA_ERROR_DEF (ECMA_ERR_INVALID_UNICODE_ESCAPE_SEQUENCE, "Invalid unicode escape sequence")
#endif /* JERRY_BUILTIN_REGEXP */
ECMA_ERROR_DEF (ECMA_ERR_ITERATOR_NEXT_IS_NOT_CALLABLE, "Iterator 'next' is not callable")
ECMA_ERROR_DEF (ECMA_ERR_ITERATOR_VALUE_IS_NOT_AN_OBJECT, "Iterator value is not an object")
ECMA_ERROR_DEF (ECMA_ERR_RESOLVE_METHOD_MUST_BE_CALLABLE, "Resolve method must be callable")
#if !(JERRY_SNAPSHOT_SAVE)
ECMA_ERROR_DEF (ECMA_ERR_SNAPSHOT_SAVE_DISABLED, "Snapshot generation is disabled")
#endif /* !(JERRY_SNAPSHOT_SAVE) */
#if !(JERRY_PARSER)
ECMA_ERROR_DEF (ECMA_ERR_PARSER_NOT_SUPPORTED, "Source code parsing is disabled")
#endif /* !(JERRY_PARSER) */
#if JERRY_BUILTIN_PROXY
ECMA_ERROR_DEF (ECMA_ERR_TRAP_MUST_RETURN_WITH_AN_OBJECT, "Trap must return with an object")
#endif /* JERRY_BUILTIN_PROXY */
#if JERRY_BUILTIN_CONTAINER
ECMA_ERROR_DEF (ECMA_ERR_UNSUPPORTED_CONTAINER_OPERATION, "Unsupported container operation")
#endif /* JERRY_BUILTIN_CONTAINER */
ECMA_ERROR_DEF (ECMA_ERR_METHOD_RETURN_IS_NOT_CALLABLE, "method 'return' is not callable")
ECMA_ERROR_DEF (ECMA_ERR_ARGUMENT_THIS_NOT_PROMISE, "Argument 'this' is not a Promise")
ECMA_ERROR_DEF (ECMA_ERR_ARGUMENT_THIS_NOT_OBJECT, "Argument 'this' is not an object")
ECMA_ERROR_DEF (ECMA_ERR_ARGUMENT_THIS_NOT_SYMBOL, "Argument 'this' must be a Symbol")
#if JERRY_MODULE_SYSTEM
ECMA_ERROR_DEF (ECMA_ERR_CALLBACK_RESULT_NOT_MODULE, "Callback result must be a module")
#endif /* JERRY_MODULE_SYSTEM */
ECMA_ERROR_DEF (ECMA_ERR_CLASS_CONSTRUCTOR_REQUIRES_NEW, "Class constructor requires 'new'")
#if JERRY_BUILTIN_ARRAY
ECMA_ERROR_DEF (ECMA_ERR_COMPARE_FUNC_NOT_CALLABLE, "Compare function is not callable")
#endif /* JERRY_BUILTIN_ARRAY */
#if JERRY_BUILTIN_PROXY
ECMA_ERROR_DEF (ECMA_ERR_CONSTRUCTOR_PROXY_REQUIRES_NEW, "Constructor Proxy requires 'new'")
#endif /* JERRY_BUILTIN_PROXY */
ECMA_ERROR_DEF (ECMA_ERR_EXPECTED_A_CONFIGURABLE_PROPERTY, "Expected a configurable property")
ECMA_ERROR_DEF (ECMA_ERR_FIRST_PARAMETER_MUST_BE_CALLABLE, "First parameter must be callable")
#if JERRY_BUILTIN_CONTAINER
ECMA_ERROR_DEF (ECMA_ERR_FUNCTION_ADD_ORSET_IS_NOT_CALLABLE, "Function add/set is not callable")
#endif /* JERRY_BUILTIN_CONTAINER */
ECMA_ERROR_DEF (ECMA_ERR_ITERATOR_RESULT_IS_NOT_AN_OBJECT, "Iterator result is not an object")
#if (JERRY_STACK_LIMIT != 0)
ECMA_ERROR_DEF (ECMA_ERR_MAXIMUM_CALL_STACK_SIZE_EXCEEDED, "Maximum call stack size exceeded")
#endif /* (JERRY_STACK_LIMIT != 0) */
ECMA_ERROR_DEF (ECMA_ERR_MAXIMUM_STRING_LENGTH_IS_REACHED, "Maximum string length is reached")
#if JERRY_MODULE_SYSTEM
ECMA_ERROR_DEF (ECMA_ERR_MODULE_MUST_BE_IN_UNLINKED_STATE, "Module must be in unlinked state")
#endif /* JERRY_MODULE_SYSTEM */
#if JERRY_SNAPSHOT_EXEC
ECMA_ERROR_DEF (ECMA_ERR_STATIC_SNAPSHOTS_ARE_NOT_ENABLED, "Static snapshots are not enabled")
#endif /* JERRY_SNAPSHOT_EXEC */
#if JERRY_BUILTIN_WEAKREF
ECMA_ERROR_DEF (ECMA_ERR_WEAKREF_TARGET_MUST_BE_AN_OBJECT, "WeakRef target must be an object")
#endif /* JERRY_BUILTIN_WEAKREF */
ECMA_ERROR_DEF (ECMA_ERR_ARGUMENT_THIS_NOT_FUNCTION, "Argument 'this' is not a function")
#if JERRY_BUILTIN_ARRAY || JERRY_BUILTIN_CONTAINER || JERRY_BUILTIN_TYPEDARRAY
ECMA_ERROR_DEF (ECMA_ERR_CALLBACK_IS_NOT_CALLABLE, "Callback function is not callable")
#endif /* JERRY_BUILTIN_ARRAY \
|| JERRY_BUILTIN_CONTAINER    \
|| JERRY_BUILTIN_TYPEDARRAY */
#if JERRY_BUILTIN_TYPEDARRAY
ECMA_ERROR_DEF (ECMA_ERR_INITIAL_VALUE_CANNOT_BE_UNDEFINED, "Initial value cannot be undefined")
#endif /* JERRY_BUILTIN_TYPEDARRAY */
#if JERRY_BUILTIN_SHAREDARRAYBUFFER
ECMA_ERROR_DEF (ECMA_ERR_INVALID_SHARED_ARRAYBUFFER_LENGTH, "Invalid Shared ArrayBuffer length")
#endif /* JERRY_BUILTIN_SHAREDARRAYBUFFER */
ECMA_ERROR_DEF (ECMA_ERR_INVALID_TYPE_FOR_CONSTRUCTOR_CALL, "Invalid type for constructor call")
ECMA_ERROR_DEF (ECMA_ERR_ITERATOR_THROW_IS_NOT_AVAILABLE, "Iterator 'throw' is not available")
#if JERRY_MODULE_SYSTEM
ECMA_ERROR_DEF (ECMA_ERR_NAMESPACE_OBJECT_IS_NOT_AVAILABLE, "Namespace object is not available")
#endif /* JERRY_MODULE_SYSTEM */
#if JERRY_BUILTIN_PROXY
ECMA_ERROR_DEF (ECMA_ERR_PROXY_TARGET_IS_NOT_A_CONSTRUCTOR, "Proxy target is not a constructor")
#endif /* JERRY_BUILTIN_PROXY */
#if JERRY_BUILTIN_REALMS
ECMA_ERROR_DEF (ECMA_ERR_SECOND_ARGUMENT_MUST_BE_AN_OBJECT, "Second argument must be an object")
#endif /* JERRY_BUILTIN_REALMS */
#if JERRY_BUILTIN_DATAVIEW
ECMA_ERROR_DEF (ECMA_ERR_ARGUMENT_BUFFER_NOT_OBJECT, "Argument 'buffer' is not an object")
#endif /* JERRY_BUILTIN_DATAVIEW */
ECMA_ERROR_DEF (ECMA_ERR_ARGUMENT_THIS_NOT_ITERATOR, "Argument 'this' is not an iterator")
ECMA_ERROR_DEF (ECMA_ERR_VALUE_MSG, "Argument cannot be marked as error")
ECMA_ERROR_DEF (ECMA_ERR_CONSTRUCTOR_PROMISE_REQUIRES_NEW, "Constructor Promise requires 'new'")
#if JERRY_BUILTIN_CONTAINER
ECMA_ERROR_DEF (ECMA_ERR_CONSTRUCTOR_WEAKMAP_REQUIRES_NEW, "Constructor WeakMap requires 'new'")
ECMA_ERROR_DEF (ECMA_ERR_CONSTRUCTOR_WEAKSET_REQUIRES_NEW, "Constructor WeakSet requires 'new'")
#endif /* JERRY_BUILTIN_CONTAINER */
#if JERRY_DEBUGGER
ECMA_ERROR_DEF (ECMA_ERR_INVALID_SCOPE_CHAIN_INDEX_FOR_EVAL, "Invalid scope chain index for eval")
#endif /* JERRY_DEBUGGER */
#if JERRY_BUILTIN_TYPEDARRAY
ECMA_ERROR_DEF (ECMA_ERR_MAXIMUM_TYPEDARRAY_SIZE_IS_REACHED, "Maximum TypedArray size is reached")
#endif /* JERRY_BUILTIN_TYPEDARRAY */
ECMA_ERROR_DEF (ECMA_ERR_THE_GIVEN_ARGUMENT_IS_NOT_A_SYMBOL, "The given argument is not a Symbol")
ECMA_ERROR_DEF (ECMA_ERR_PARAMETER_REJECT_MUST_BE_CALLABLE, "'reject' parameter must be callable")
#if JERRY_BUILTIN_ATOMICS || JERRY_BUILTIN_TYPEDARRAY
ECMA_ERROR_DEF (ECMA_ERR_ARGUMENT_THIS_NOT_TYPED_ARRAY, "Argument 'this' is not a TypedArray")
#endif /* JERRY_BUILTIN_ATOMICS \
|| JERRY_BUILTIN_TYPEDARRAY */
#if JERRY_SNAPSHOT_SAVE
ECMA_ERROR_DEF (ECMA_ERR_CANNOT_ALLOCATE_MEMORY_LITERALS, "Cannot allocate memory for literals")
#endif /* JERRY_SNAPSHOT_SAVE */
ECMA_ERROR_DEF (ECMA_ERR_INVOKE_NULLABLE_SUPER_METHOD, "Cannot invoke nullable super method")
#if JERRY_BUILTIN_DATAVIEW
ECMA_ERROR_DEF (ECMA_ERR_CONSTRUCTOR_DATAVIEW_REQUIRES_NEW, "Constructor DataView requires 'new'")
#endif /* JERRY_BUILTIN_DATAVIEW */
#if JERRY_BUILTIN_WEAKREF
ECMA_ERROR_DEF (ECMA_ERR_CONSTRUCTOR_WEAKREF_REQUIRES_NEW, "Constructor WeakRef requires 'new'.")
#endif /* JERRY_BUILTIN_WEAKREF */
ECMA_ERROR_DEF (ECMA_ERR_SUPER_BINDING_MUST_BE_A_CONSTRUCTOR, "Super binding must be a constructor")
#if JERRY_BUILTIN_BIGINT
ECMA_ERROR_DEF (ECMA_ERR_VALUE_CANNOT_BE_CONVERTED_TO_BIGINT, "Value cannot be converted to BigInt")
#endif /* JERRY_BUILTIN_BIGINT */
ECMA_ERROR_DEF (ECMA_ERR_PARAMETER_RESOLVE_MUST_BE_CALLABLE, "'resolve' parameter must be callable")
#if JERRY_BUILTIN_DATE
ECMA_ERROR_DEF (ECMA_ERR_ARGUMENT_THIS_NOT_DATE_OBJECT, "Argument 'this' is not a Date object")
#endif /* JERRY_BUILTIN_DATE */
#if JERRY_BUILTIN_TYPEDARRAY
ECMA_ERROR_DEF (ECMA_ERR_ARGUMENT_THIS_NOT_CONSTRUCTOR, "Argument 'this' is not a constructor")
#endif /* JERRY_BUILTIN_TYPEDARRAY */
#if JERRY_BUILTIN_BIGINT
ECMA_ERROR_DEF (ECMA_ERR_BIGINT_FUNCTION_NOT_CONSTRUCTOR, "BigInt function is not a constructor")
#endif /* JERRY_BUILTIN_BIGINT */
#if JERRY_BUILTIN_TYPEDARRAY
ECMA_ERROR_DEF (ECMA_ERR_CONSTRUCTED_OBJECT_IS_NOT_TYPEDARRAY, "Constructed object is not TypedArray")
ECMA_ERROR_DEF (ECMA_ERR_CONSTRUCTOR_INT8_ARRAY_REQUIRES_NEW, "Constructor Int8Array requires 'new'")
#endif /* JERRY_BUILTIN_TYPEDARRAY */
#if JERRY_BUILTIN_CONTAINER
ECMA_ERROR_DEF (ECMA_ERR_CONTAINER_IS_NOT_A_CONTAINER_OBJECT, "Container is not a container object.")
#endif /* JERRY_BUILTIN_CONTAINER */
#if JERRY_BUILTIN_DATE
ECMA_ERROR_DEF (ECMA_ERR_INVALID_ARGUMENT_TYPE_IN_TOPRIMITIVE, "Invalid argument type in toPrimitive")
#endif /* JERRY_BUILTIN_DATE */
#if JERRY_ERROR_MESSAGES
ECMA_ERROR_DEF (ECMA_ERR_METHODS_INVOKE_WITH_NEW, "Methods cannot be invoked with 'new'")
#endif /* JERRY_ERROR_MESSAGES */
#if JERRY_MODULE_SYSTEM
ECMA_ERROR_DEF (ECMA_ERR_MODULE_EXPORTS_MUST_BE_STRING_VALUES, "Module exports must be string values")
#endif /* JERRY_MODULE_SYSTEM */
ECMA_ERROR_DEF (ECMA_ERR_PROTOTYPE_IS_NEITHER_OBJECT_NOR_NULL, "Prototype is neither object nor null")
#if JERRY_BUILTIN_TYPEDARRAY
ECMA_ERROR_DEF (ECMA_ERR_THE_MAPFN_ARGUMENT_IS_NOT_CALLABLE, "The 'mapfn' argument is not callable")
#endif /* JERRY_BUILTIN_TYPEDARRAY */
#if JERRY_BUILTIN_PROXY
ECMA_ERROR_DEF (ECMA_ERR_THE_TWO_DESCRIPTORS_ARE_INCOMPATIBLE, "The two descriptors are incompatible")
#endif /* JERRY_BUILTIN_PROXY */
ECMA_ERROR_DEF (ECMA_ERR_WRONG_ARGS_MSG, "This type of argument is not allowed")
#if JERRY_BUILTIN_CONTAINER
ECMA_ERROR_DEF (ECMA_ERR_CONTAINER_NEEDED, "Value is not a Container or Iterator")
#endif /* JERRY_BUILTIN_CONTAINER */
#if JERRY_BUILTIN_REGEXP
ECMA_ERROR_DEF (ECMA_ERR_ARGUMENT_THIS_NOT_REG_EXP, "Argument 'this' is not a valid RegExp")
#endif /* JERRY_BUILTIN_REGEXP */
#if JERRY_BUILTIN_TYPEDARRAY
ECMA_ERROR_DEF (ECMA_ERR_ARRAY_BUFFER_DETACHED, "ArrayBuffer has already been detached")
#endif /* JERRY_BUILTIN_TYPEDARRAY */
ECMA_ERROR_DEF (ECMA_ERR_BULTIN_ROUTINES_HAVE_NO_CONSTRUCTOR, "Built-in routines have no constructor")
#if JERRY_BUILTIN_TYPEDARRAY
ECMA_ERROR_DEF (ECMA_ERR_CONSTRUCTOR_INT16_ARRAY_REQUIRES_NEW, "Constructor Int16Array requires 'new'")
ECMA_ERROR_DEF (ECMA_ERR_CONSTRUCTOR_INT32_ARRAY_REQUIRES_NEW, "Constructor Int32Array requires 'new'")
ECMA_ERROR_DEF (ECMA_ERR_CONSTRUCTOR_UINT8_ARRAY_REQUIRES_NEW, "Constructor Uint8Array requires 'new'")
#endif /* JERRY_BUILTIN_TYPEDARRAY */
#if JERRY_SNAPSHOT_EXEC
ECMA_ERROR_DEF (ECMA_ERR_FUNCTION_INDEX_IS_HIGHER_THAN_MAXIMUM, "Function index is higher than maximum")
#endif /* JERRY_SNAPSHOT_EXEC */
#if JERRY_BUILTIN_REGEXP
ECMA_ERROR_DEF (ECMA_ERR_RANGE_OUT_OF_ORDER_IN_CHARACTER_CLASS, "Range out of order in character class")
#endif /* JERRY_BUILTIN_REGEXP */
ECMA_ERROR_DEF (ECMA_ERR_RESULT_OF_DEFAULTVALUE_IS_INVALID, "Result of [[DefaultValue]] is invalid")
ECMA_ERROR_DEF (ECMA_ERR_RIGHT_VALUE_OF_IN_MUST_BE_AN_OBJECT, "Right value of 'in' must be an object")
#if !(JERRY_BUILTIN_SHAREDARRAYBUFFER)
ECMA_ERROR_DEF (ECMA_ERR_SHARED_ARRAYBUFFER_NOT_SUPPORTED, "SharedArrayBuffer support is disabled")
#endif /* !(JERRY_BUILTIN_SHAREDARRAYBUFFER) */
#if JERRY_BUILTIN_PROXY
ECMA_ERROR_DEF (ECMA_ERR_TRAP_RETURNED_NEITHER_OBJECT_NOR_NULL, "Trap returned neither object nor null")
ECMA_ERROR_DEF (ECMA_ERR_TRAP_WITH_DUPLICATED_ENTRIES, "Trap returned with duplicated entries")
#endif /* JERRY_BUILTIN_PROXY */
#if JERRY_BUILTIN_BIGINT
ECMA_ERROR_DEF (ECMA_ERR_UNARY_PLUS_IS_NOT_ALLOWED_FOR_BIGINTS, "Unary plus is not allowed for BigInts")
#endif /* JERRY_BUILTIN_BIGINT */
#if JERRY_BUILTIN_REGEXP
ECMA_ERROR_DEF (ECMA_ERR_ARGUMENT_IS_NOT_AN_REGEXP, "Argument 'this' is not a RegExp object")
#endif /* JERRY_BUILTIN_REGEXP */
#if JERRY_BUILTIN_TYPEDARRAY
ECMA_ERROR_DEF (ECMA_ERR_ALLOCATE_ARRAY_BUFFER, "Cannot allocate memory for ArrayBuffer")
#endif /* JERRY_BUILTIN_TYPEDARRAY */
ECMA_ERROR_DEF (ECMA_ERR_CONSTANT_BINDINGS_CANNOT_BE_REASSIGNED, "Constant bindings cannot be reassigned")
#if JERRY_BUILTIN_TYPEDARRAY
ECMA_ERROR_DEF (ECMA_ERR_CONSTRUCTOR_ARRAYBUFFER_REQUIRES_NEW, "Constructor ArrayBuffer requires 'new'")
ECMA_ERROR_DEF (ECMA_ERR_CONSTRUCTOR_UINT16_ARRAY_REQUIRES_NEW, "Constructor Uint16Array requires 'new'")
ECMA_ERROR_DEF (ECMA_ERR_CONSTRUCTOR_UINT32_ARRAY_REQUIRES_NEW, "Constructor Uint32Array requires 'new'")
#endif /* JERRY_BUILTIN_TYPEDARRAY */
ECMA_ERROR_DEF (ECMA_ERR_GENERATOR_IS_CURRENTLY_UNDER_EXECUTION, "Generator is currently under execution")
ECMA_ERROR_DEF (ECMA_ERR_ITERATOR_RETURN_RESULT_IS_NOT_OBJECT, "Iterator 'return' result is not object")
ECMA_ERROR_DEF (ECMA_ERR_SEARCH_STRING_CANNOT_BE_OF_TYPE_REGEXP, "Search string can't be of type: RegExp")
ECMA_ERROR_DEF (ECMA_ERR_VALUE_RECEIVED_BY_YIELD_IS_NOT_OBJECT, "Value received by yield* is not object")
#if JERRY_BUILTIN_BOOLEAN
ECMA_ERROR_DEF (ECMA_ERR_ARGUMENT_THIS_NOT_BOOLEAN_OBJECT, "Argument 'this' is not a Boolean object")
#endif /* JERRY_BUILTIN_BOOLEAN */
ECMA_ERROR_DEF (ECMA_ERR_CANNOT_DECLARE_SAME_PRIVATE_FIELD_TWICE, "Cannot declare same private field twice")
#if JERRY_BUILTIN_TYPEDARRAY
ECMA_ERROR_DEF (ECMA_ERR_CONSTRUCTOR_FLOAT32_ARRAY_REQUIRES_NEW, "Constructor Float32Array requires 'new'")
#endif /* JERRY_BUILTIN_TYPEDARRAY */
#if JERRY_BUILTIN_TYPEDARRAY && JERRY_NUMBER_TYPE_FLOAT64
ECMA_ERROR_DEF (ECMA_ERR_CONSTRUCTOR_FLOAT64_ARRAY_REQUIRES_NEW, "Constructor Float64Array requires 'new'")
#endif /* JERRY_BUILTIN_TYPEDARRAY && JERRY_NUMBER_TYPE_FLOAT64 */
ECMA_ERROR_DEF (ECMA_ERR_FUNCTION_PROTOTYPE_NOT_A_CONSTRUCTOR, "Function.prototype is not a constructor")
#if JERRY_MODULE_SYSTEM
ECMA_ERROR_DEF (ECMA_ERR_IMPORTED_BINDING_SHADOWS_LOCAL_VARIABLE, "Imported binding shadows local variable")
#endif /* JERRY_MODULE_SYSTEM */
#if JERRY_BUILTIN_PROXY
ECMA_ERROR_DEF (ECMA_ERR_PROTOTYPE_FROM_REVOKED_PROXY_IS_INVALID, "Prototype from revoked Proxy is invalid")
#endif /* JERRY_BUILTIN_PROXY */
#if JERRY_BUILTIN_REGEXP && JERRY_BUILTIN_STRING
ECMA_ERROR_DEF (ECMA_ERR_REGEXP_ARGUMENT_SHOULD_HAVE_GLOBAL_FLAG, "RegExp argument should have global flag")
#endif /* JERRY_BUILTIN_REGEXP && JERRY_BUILTIN_STRING */
#if JERRY_BUILTIN_PROXY
ECMA_ERROR_DEF (ECMA_ERR_TRAP_IS_NEITHER_AN_OBJECT_NOR_UNDEFINED, "Trap is neither an object nor undefined")
#endif /* JERRY_BUILTIN_PROXY */
ECMA_ERROR_DEF (ECMA_ERR_PROMISE_RESOLVE_ITSELF, "A promise cannot be resolved with itself")
#if JERRY_BUILTIN_BIGINT && JERRY_BUILTIN_TYPEDARRAY
ECMA_ERROR_DEF (ECMA_ERR_CONSTRUCTOR_BIGINT64_ARRAY_REQUIRES_NEW, "Constructor BigInt64Array requires 'new'")
#endif /* JERRY_BUILTIN_BIGINT && JERRY_BUILTIN_TYPEDARRAY */
#if JERRY_MODULE_SYSTEM
ECMA_ERROR_DEF (ECMA_ERR_MODULE_EXPORTS_MUST_BE_VALID_IDENTIFIERS, "Module exports must be valid identifiers")
#endif /* JERRY_MODULE_SYSTEM */
ECMA_ERROR_DEF (ECMA_ERR_ARGUMENT_THIS_NOT_GENERATOR_OBJECT, "Argument 'this' is not a generator object")
ECMA_ERROR_DEF (ECMA_ERR_ARGUMENT_CANNOT_CONVERT_TO_OBJECT, "Argument cannot be converted to an object")
#if JERRY_BUILTIN_BIGINT
ECMA_ERROR_DEF (ECMA_ERR_ALLOCATE_BIGINT_VALUE, "Cannot allocate memory for a BigInt value")
ECMA_ERROR_DEF (ECMA_ERR_CONVERT_BIGINT_TO_NUMBER, "Cannot convert a BigInt value to a number")
#endif /* JERRY_BUILTIN_BIGINT */
ECMA_ERROR_DEF (ECMA_ERR_CONVERT_SYMBOL_TO_NUMBER, "Cannot convert a Symbol value to a number")
ECMA_ERROR_DEF (ECMA_ERR_CONVERT_SYMBOL_TO_STRING, "Cannot convert a Symbol value to a string")
#if JERRY_BUILTIN_BIGINT && JERRY_BUILTIN_TYPEDARRAY
ECMA_ERROR_DEF (ECMA_ERR_CONSTRUCTOR_BIG_UINT64_ARRAY_REQUIRES_NEW, "Constructor BigUInt64Array requires 'new'")
#endif /* JERRY_BUILTIN_BIGINT && JERRY_BUILTIN_TYPEDARRAY */
#if JERRY_BUILTIN_NUMBER
ECMA_ERROR_DEF (ECMA_ERR_FRACTION_DIGITS_OUT_OF_RANGE, "Fraction digits must be between 0 and 100")
#endif /* JERRY_BUILTIN_NUMBER */
#if JERRY_BUILTIN_TYPEDARRAY
ECMA_ERROR_DEF (ECMA_ERR_RETURN_VALUE_IS_NOT_AN_ARRAYBUFFER_OBJECT, "Return value is not an ArrayBuffer object")
#endif /* JERRY_BUILTIN_TYPEDARRAY */
ECMA_ERROR_DEF (ECMA_ERR_SUPER_CONSTRUCTOR_MAY_ONLY_BE_CALLED_ONCE, "Super constructor may only be called once")
ECMA_ERROR_DEF (ECMA_ERR_BINDING_NOT_EXIST_OR_UNINITIALIZED, "Binding does not exist or is uninitialised")
#if JERRY_BUILTIN_ARRAY
ECMA_ERROR_DEF (ECMA_ERR_CANNOT_CONVERT_TO_OBJECT, "Cannot convert undefined or null to object")
#endif /* JERRY_BUILTIN_ARRAY */
#if JERRY_BUILTIN_NUMBER
ECMA_ERROR_DEF (ECMA_ERR_PRECISION_DIGITS_MUST_BE_BETWEEN_IN_RANGE, "Precision digits must be between 1 and 100")
#endif /* JERRY_BUILTIN_NUMBER */
ECMA_ERROR_DEF (ECMA_ERR_PRIVATE_FIELD_WAS_DEFINED_WITHOUT_A_GETTER, "Private field was defined without a getter")
ECMA_ERROR_DEF (ECMA_ERR_PRIVATE_FIELD_WAS_DEFINED_WITHOUT_A_SETTER, "Private field was defined without a setter")
ECMA_ERROR_DEF (ECMA_ERR_PROPERTY_NAME_IS_NEITHER_SYMBOL_NOR_STRING, "Property name is neither Symbol nor string")
#if JERRY_BUILTIN_BIGINT
ECMA_ERROR_DEF (ECMA_ERR_STRING_CANNOT_BE_CONVERTED_TO_BIGINT_VALUE, "String cannot be converted to BigInt value")
#endif /* JERRY_BUILTIN_BIGINT */
#if JERRY_BUILTIN_CONTAINER
ECMA_ERROR_DEF (ECMA_ERR_INCORRECT_TYPE_CALL, "Operator called on incorrect container type")
#endif /* JERRY_BUILTIN_CONTAINER */
#if JERRY_BUILTIN_ARRAY
ECMA_ERROR_DEF (ECMA_ERR_REDUCE_OF_EMPTY_ARRAY_WITH_NO_INITIAL_VALUE, "Reduce of empty Array with no initial value")
#endif /* JERRY_BUILTIN_ARRAY */
#if JERRY_BUILTIN_REGEXP
ECMA_ERROR_DEF (ECMA_ERR_ARGUMENT_THIS_NOT_REG_EXP_OBJECT, "Argument 'this' is not a valid RegExp object")
#endif /* JERRY_BUILTIN_REGEXP */
#if JERRY_BUILTIN_TYPEDARRAY
ECMA_ERROR_DEF (ECMA_ERR_ARGUMENT_THIS_NOT_ARRAY_BUFFER_OBJECT, "Argument 'this' is not an ArrayBuffer object")
#endif /* JERRY_BUILTIN_TYPEDARRAY */
#if JERRY_ERROR_MESSAGES
ECMA_ERROR_DEF (ECMA_ERR_ARROW_FUNCTIONS_INVOKE_WITH_NEW, "Arrow functions cannot be invoked with 'new'")
ECMA_ERROR_DEF (ECMA_ERR_ASYNC_FUNCTIONS_INVOKE_WITH_NEW, "Async functions cannot be invoked with 'new'")
#endif /* JERRY_ERROR_MESSAGES */
#if JERRY_BUILTIN_PROXY
ECMA_ERROR_DEF (ECMA_ERR_SET_EXTENSIBLE_PROPERTY, "Cannot set [[Extensible]] property of object")
#endif /* JERRY_BUILTIN_PROXY */
#if JERRY_BUILTIN_SHAREDARRAYBUFFER
ECMA_ERROR_DEF (ECMA_ERR_CONSTRUCTOR_SHAREDARRAYBUFFER_REQUIRES_NEW, "Constructor SharedArrayBuffer requires 'new'")
#endif /* JERRY_BUILTIN_SHAREDARRAYBUFFER */
#if JERRY_BUILTIN_TYPEDARRAY
ECMA_ERROR_DEF (ECMA_ERR_CONSTRUCTOR_UINT8_CLAMPED_ARRAY_REQUIRES_NEW, "Constructor Uint8ClampedArray requires 'new'")
#endif /* JERRY_BUILTIN_TYPEDARRAY */
#if JERRY_BUILTIN_BIGINT
ECMA_ERROR_DEF (ECMA_ERR_NEGATIVE_EXPONENT_IS_NOT_ALLOWED_FOR_BIGINTS, "Negative exponent is not allowed for BigInts")
#endif /* JERRY_BUILTIN_BIGINT */
ECMA_ERROR_DEF (ECMA_ERR_PROMISE_ALL_REMAINING_ELEMENTS_LIMIT_REACHED, "Promise.all remaining elements limit reached")
ECMA_ERROR_DEF (ECMA_ERR_VALUE_RECEIVED_BY_FOR_ASYNC_OF_IS_NOT_OBJECT, "Value received by for-async-of is not object")
#if JERRY_BUILTIN_BIGINT
ECMA_ERROR_DEF (ECMA_ERR_INFINITY_OR_NAN_CANNOT_BE_CONVERTED_TO_BIGINT, "Infinity or NaN cannot be converted to BigInt")
#endif /* JERRY_BUILTIN_BIGINT */
ECMA_ERROR_DEF (ECMA_ERR_OPERATOR_DELETE_RETURNED_FALSE_IN_STRICT_MODE, "Operator delete returned false in strict mode")
ECMA_ERROR_DEF (ECMA_ERR_PROPERTY_PROTOTYPE_IS_NOT_AN_OBJECT, "Property 'prototype' is not an object or null")
#if JERRY_BUILTIN_PROXY
ECMA_ERROR_DEF (ECMA_ERR_PROXY_HANDLER_IS_NULL_FOR_ISARRAY_OPERATION, "Proxy handler is null for 'isArray' operation")
#endif /* JERRY_BUILTIN_PROXY */
#if JERRY_SNAPSHOT_SAVE
ECMA_ERROR_DEF (ECMA_ERR_REGULAR_EXPRESSION_NOT_SUPPORTED, "Regular expression literals are not supported")
#endif /* JERRY_SNAPSHOT_SAVE */
ECMA_ERROR_DEF (ECMA_ERR_RIGHT_VALUE_OF_INSTANCEOF_MUST_BE_AN_OBJECT, "Right value of 'instanceof' must be an object")
#if JERRY_SNAPSHOT_EXEC
ECMA_ERROR_DEF (ECMA_ERR_STATIC_SNAPSHOTS_CANNOT_BE_COPIED_INTO_MEMORY, "Static snapshots cannot be copied into memory")
#endif /* JERRY_SNAPSHOT_EXEC */
#if JERRY_SNAPSHOT_SAVE
ECMA_ERROR_DEF (ECMA_ERR_TAGGED_TEMPLATE_LITERALS, "Unsupported feature: tagged template literals")
ECMA_ERROR_DEF (ECMA_ERR_SNAPSHOT_FLAG_NOT_SUPPORTED, "Unsupported generate snapshot flags specified")
#endif /* JERRY_SNAPSHOT_SAVE */
#if JERRY_SNAPSHOT_EXEC
ECMA_ERROR_DEF (ECMA_ERR_UNSUPPORTED_SNAPSHOT_EXEC_FLAGS_ARE_SPECIFIED, "Unsupported snapshot exec flags are specified")
#endif /* JERRY_SNAPSHOT_EXEC */
ECMA_ERROR_DEF (ECMA_ERR_VALUE_FOR_CLASS_HERITAGE_IS_NOT_A_CONSTRUCTOR, "Value for class heritage is not a constructor")
ECMA_ERROR_DEF (ECMA_ERR_TOO_MANY_ARGUMENTS_DECLARED_FOR_FUNCTION_APPLY,
                "Too many arguments declared for Function.apply")
#if JERRY_ERROR_MESSAGES
ECMA_ERROR_DEF (ECMA_ERR_ACCESSOR_FUNCTIONS_INVOKE_WITH_NEW, "Accessor functions cannot be invoked with 'new'")
#endif /* JERRY_ERROR_MESSAGES */
#if JERRY_MODULE_SYSTEM
ECMA_ERROR_DEF (ECMA_ERR_LINK_TO_MODULE_IN_ERROR_STATE, "Cannot link to a module which is in error state")
#endif /* JERRY_MODULE_SYSTEM */
#if JERRY_BUILTIN_BIGINT
ECMA_ERROR_DEF (ECMA_ERR_ONLY_INTEGER_NUMBERS_CAN_BE_CONVERTED_TO_BIGINT,
                "Only integer numbers can be converted to BigInt")
#endif /* JERRY_BUILTIN_BIGINT */
#if JERRY_BUILTIN_TYPEDARRAY
ECMA_ERROR_DEF (ECMA_ERR_TYPEDARRAY_INTRINSTIC_DIRECTLY_CALLED, "TypedArray intrinstic cannot be directly called")
#endif /* JERRY_BUILTIN_TYPEDARRAY */
#if JERRY_BUILTIN_BIGINT
ECMA_ERROR_DEF (ECMA_ERR_UNSIGNED_RIGHT_SHIFT_IS_NOT_ALLOWED_FOR_BIGINTS,
                "Unsigned right shift is not allowed for BigInts")
#endif /* JERRY_BUILTIN_BIGINT */
ECMA_ERROR_DEF (ECMA_ERR_ARGUMENT_THIS_NOT_ASYNC_GENERATOR, "Argument 'this' is not an async generator object")
ECMA_ERROR_DEF (ECMA_ERR_CLASS_EXTENDS_NOT_CONSTRUCTOR, "Class extends value is not a constructor or null")
#if JERRY_ERROR_MESSAGES
ECMA_ERROR_DEF (ECMA_ERR_GENERATOR_FUNCTIONS_INVOKE_WITH_NEW, "Generator functions cannot be invoked with 'new'")
#endif /* JERRY_ERROR_MESSAGES */
#if JERRY_BUILTIN_REGEXP
ECMA_ERROR_DEF (ECMA_ERR_RETURN_VALUE_OF_EXEC_MUST_BE_AN_OBJECT_OR_NULL,
                "Return value of 'exec' must be an object or null")
#endif /* JERRY_BUILTIN_REGEXP */
#if JERRY_BUILTIN_DATAVIEW
ECMA_ERROR_DEF (ECMA_ERR_START_OFFSET_IS_OUTSIDE_THE_BOUNDS_OF_THE_BUFFER,
                "Start offset is outside the bounds of the buffer")
#endif /* JERRY_BUILTIN_DATAVIEW */
#if JERRY_BUILTIN_SHAREDARRAYBUFFER
ECMA_ERROR_DEF (ECMA_ERR_ARGUMENT_THIS_NOT_SHARED_ARRAY_BUFFER, "Argument 'this' is not a SharedArrayBuffer object")
#endif /* JERRY_BUILTIN_SHAREDARRAYBUFFER */
ECMA_ERROR_DEF (ECMA_ERR_CLASS_CONSTRUCTOR_NEW, "Class constructor cannot be invoked without 'new'")
#if JERRY_BUILTIN_PROXY
ECMA_ERROR_DEF (ECMA_ERR_INCORRECT_RETURN_PROXY_GET_TRAP, "Incorrect value is returned by a Proxy 'get' trap")
ECMA_ERROR_DEF (ECMA_ERR_INCORRECT_RETURN_PROXY_SET_TRAP, "Incorrect value is returned by a Proxy 'set' trap")
#endif /* JERRY_BUILTIN_PROXY */
ECMA_ERROR_DEF (ECMA_ERR_CLASS_IS_NON_CONFIGURABLE, "Prototype property of a class is non-configurable")
#if JERRY_BUILTIN_ARRAY
ECMA_ERROR_DEF (ECMA_ERR_PUSHING_TOO_HIGH_ELEMENT, "Pushing element over 2**53-1 length is disallowed")
#endif /* JERRY_BUILTIN_ARRAY */
ECMA_ERROR_DEF (ECMA_ERR_THE_REQUESTED_PROPERTY_UPDATE_CANNOT_BE_PERFORMED,
                "The requested property update cannot be performed")
#if JERRY_BUILTIN_PROXY
ECMA_ERROR_DEF (ECMA_ERR_TRAP_RESULT_NOT_INCLUDE_ALL_CONFIGURABLE_KEYS,
                "Trap result did not include all configurable keys")
ECMA_ERROR_DEF (ECMA_ERR_TRAP_TRUISH_TARGET_NOT_EXTENSIBLE, "Trap returned truish for target is not extensible")
#endif /* JERRY_BUILTIN_PROXY */
#if JERRY_BUILTIN_NUMBER
ECMA_ERROR_DEF (ECMA_ERR_ARGUMENT_THIS_NOT_NUMBER, "Argument 'this' is not a number or a Number object")
#endif /* JERRY_BUILTIN_NUMBER */
#if JERRY_BUILTIN_STRING
ECMA_ERROR_DEF (ECMA_ERR_ARGUMENT_THIS_NOT_STRING_OBJECT, "Argument 'this' is not a string or a String object")
#endif /* JERRY_BUILTIN_STRING */
#if JERRY_BUILTIN_SHAREDARRAYBUFFER
ECMA_ERROR_DEF (ECMA_ERR_ARGUMENT_THIS_NOT_SHARED_ARRAY_BUFFER_OBJECT,
                "Argument 'this' is not an SharedArrayBuffer object")
#endif /* JERRY_BUILTIN_SHAREDARRAYBUFFER */
#if JERRY_ERROR_MESSAGES
ECMA_ERROR_DEF (ECMA_ERR_ASYNC_ARROW_FUNCTIONS_INVOKE_WITH_NEW, "Async arrow functions cannot be invoked with 'new'")
#endif /* JERRY_ERROR_MESSAGES */
#if JERRY_BUILTIN_ARRAY
ECMA_ERROR_DEF (ECMA_ERR_UNSHIFT_TOO_HIGH, "Unshift elements over 2**53-1 length is disallowed")
#endif /* JERRY_BUILTIN_ARRAY */
#if JERRY_BUILTIN_PROXY
ECMA_ERROR_DEF (ECMA_ERR_TRAP_RESULT_NOT_INCLUDE_ALL_NON_CONFIGURABLE_KEYS,
                "Trap result did not include all non-configurable keys")
#endif /* JERRY_BUILTIN_PROXY */
#if JERRY_ERROR_MESSAGES
ECMA_ERROR_DEF (ECMA_ERR_ASYNC_GENERATOR_FUNCTIONS_INVOKE_WITH_NEW,
                "Async generator functions cannot be invoked with 'new'")
#endif /* JERRY_ERROR_MESSAGES */
#if JERRY_BUILTIN_REFLECT
ECMA_ERROR_DEF (ECMA_ERR_REFLECT_EXPECTS_AN_OBJECT_AS_SECOND_ARGUMENT,
                "Reflect.construct expects an object as second argument")
#endif /* JERRY_BUILTIN_REFLECT */
#if JERRY_ERROR_MESSAGES
ECMA_ERROR_DEF (ECMA_ERR_SCRIPT_GLOBAL_FUNCTIONS_INVOKE_WITH_NEW,
                "Script (global) functions cannot be invoked with 'new'")
#endif /* JERRY_ERROR_MESSAGES */
#if JERRY_BUILTIN_PROXY
ECMA_ERROR_DEF (ECMA_ERR_CANNOT_CREATE_PROXY, "Cannot create Proxy with a non-object target or handler")
#endif /* JERRY_BUILTIN_PROXY */
ECMA_ERROR_DEF (ECMA_ERR_DERIVED_CTOR_RETURN_NOR_OBJECT_OR_UNDEFINED,
                "Derived constructors may only return object or undefined")
#if JERRY_SNAPSHOT_EXEC
ECMA_ERROR_DEF (ECMA_ERR_INVALID_SNAPSHOT_VERSION_OR_FEATURES,
                "Invalid snapshot version or unsupported features present")
#endif /* JERRY_SNAPSHOT_EXEC */
#if JERRY_BUILTIN_TYPEDARRAY
ECMA_ERROR_DEF (ECMA_ERR_TYPEDARRAY_SMALLER_THAN_FILTER_CALL_RESULT,
                "Constructed TypedArray is smaller than filter call result")
ECMA_ERROR_DEF (ECMA_ERR_DERIVED_ARRAY_BUFFER_CTOR_BUFFER_TOO_SMALL,
                "Derived ArrayBuffer constructor created a too small buffer")
#endif /* JERRY_BUILTIN_TYPEDARRAY */
#if JERRY_BUILTIN_PROXY
ECMA_ERROR_DEF (ECMA_ERR_TRAP_RESULT_NOT_REFLECT_TARGET_EXTENSIBILITY,
                "Trap result does not reflect extensibility of Proxy target")
ECMA_ERROR_DEF (ECMA_ERR_TRAP_EXTRA_KEYS_FOR_A_NON_EXTENSIBLE_TARGET,
                "Trap returned extra keys for a non-extensible Proxy target")
#endif /* JERRY_BUILTIN_PROXY */
#if JERRY_BUILTIN_TYPEDARRAY
ECMA_ERROR_DEF (ECMA_ERR_ARRAY_BUFFER_RETURNED_THIS_FROM_CONSTRUCTOR,
                "ArrayBuffer subclass returned this from species constructor")
#endif /* JERRY_BUILTIN_TYPEDARRAY */
#if JERRY_BUILTIN_DATAVIEW
ECMA_ERROR_DEF (ECMA_ERR_ARGUMENT_BUFFER_NOT_ARRAY_OR_SHARED_BUFFER,
                "Argument 'buffer' is not an ArrayBuffer or SharedArrayBuffer")
#endif /* JERRY_BUILTIN_DATAVIEW */
#if JERRY_BUILTIN_PROXY
ECMA_ERROR_DEF (ECMA_ERR_TRAP_RESULT_NOT_REFLECT_TARGET_INEXTENSIBILITY,
                "Trap result does not reflect inextensibility of Proxy target")
#endif /* JERRY_BUILTIN_PROXY */
#if JERRY_BUILTIN_TYPEDARRAY
ECMA_ERROR_DEF (ECMA_ERR_TYPEDARRAY_INTRINSTIC_CALLED_BY_NEW_EXPRESSION,
                "TypedArray intrinstic cannot be called by a 'new' expression")
#endif /* JERRY_BUILTIN_TYPEDARRAY */
#if JERRY_BUILTIN_BIGINT && JERRY_BUILTIN_TYPEDARRAY
ECMA_ERROR_DEF (ECMA_ERR_CONTENTTYPE_RETURNED_TYPEDARRAY_NOT_MATCH_SOURCE,
                "TypedArray returned by [[ContentType]] does not match source")
#endif /* JERRY_BUILTIN_BIGINT && JERRY_BUILTIN_TYPEDARRAY */
#if JERRY_BUILTIN_BIGINT
ECMA_ERROR_DEF (ECMA_ERR_ALLOCATE_BIGINT_STRING, "Cannot allocate memory for a string representation of a BigInt value")
#endif /* JERRY_BUILTIN_BIGINT */
#if JERRY_BUILTIN_PROXY
ECMA_ERROR_DEF (ECMA_ERR_TARGET_NOT_EXTENSIBLE_DIFFERENT_PROTOTYPE_RETURNED,
                "Target object is non-extensible and trap returned different prototype")
ECMA_ERROR_DEF (ECMA_ERR_TRAP_TRUISH_ADDING_PROPERTY_NON_EXTENSIBLE_TARGET,
                "Trap returned truish for adding property to the non-extensible target")
#endif /* JERRY_BUILTIN_PROXY */
ECMA_ERROR_DEF (ECMA_ERR_CANNOT_READ_PRIVATE_MEMBER_TO_AN_OBJECT_WHOSE_CLASS_DID_NOT_DECLARE_IT,
                "Cannot read private member to an object whose class did not declare it")
#if JERRY_BUILTIN_PROXY
ECMA_ERROR_DEF (ECMA_ERR_GIVEN_PROPERTY_IS_A_NON_CONFIGURABLE,
                "Given property is a non-configurable data property on the proxy target")
#endif /* JERRY_BUILTIN_PROXY */
ECMA_ERROR_DEF (ECMA_ERR_CANNOT_WRITE_PRIVATE_MEMBER_TO_AN_OBJECT_WHOSE_CLASS_DID_NOT_DECLARE_IT,
                "Cannot write private member to an object whose class did not declare it")
#if JERRY_BUILTIN_PROXY
ECMA_ERROR_DEF (ECMA_ERR_TRAP_FALSISH_PROPERTY_TARGET_NOT_EXTENSIBLE,
                "Trap returned falsish for property but the proxy target is not extensible")
ECMA_ERROR_DEF (ECMA_ERR_PROXY_PROPERTY_NOT_CONFIGURABLE_NOT_HAVE_GETTER,
                "Property of a Proxy is non-configurable and does not have a getter function")
ECMA_ERROR_DEF (ECMA_ERR_TARGET_PROPERTY_CONFIGURE_ACCESSOR_WITHOUT_SETTER,
                "The property of a Proxy target is a non configurable accessor without a setter")
#endif /* JERRY_BUILTIN_PROXY */
ECMA_ERROR_DEF (ECMA_ERR_LET_CONST_NOT_INITIALIZED,
                "Variables declared by let/const must be initialized before reading their value")
#if JERRY_BUILTIN_PROXY
ECMA_ERROR_DEF (ECMA_ERR_TRAP_TRUISH_PROPERTY_NON_CONFIGURABLE,
                "Trap returned truish for property which is non-configurable in the proxy target")
ECMA_ERROR_DEF (ECMA_ERR_TARGET_NOT_EXTENSIBLE_NOT_RETURNED_ITS_PROTOTYPE,
                "Proxy target is non-extensible, but the trap did not return its actual prototype")
ECMA_ERROR_DEF (ECMA_ERR_TRAP_FALSISH_PROPERTY_NON_CONFIGURABLE,
                "Trap returned falsish for property which exists in the proxy target as non-configurable")
#endif /* JERRY_BUILTIN_PROXY */
ECMA_ERROR_DEF (ECMA_ERR_CALL_SUPER_CONSTRUCTOR_DERIVED_CLASS_BEFORE_THIS,
                "Must call super constructor in derived class before accessing 'this' or returning from it")
#if JERRY_BUILTIN_PROXY
ECMA_ERROR_DEF (ECMA_ERR_TRAP_TRUISH_DEFINING_NON_EXISTENT_PROPERTY,
                "Trap returned truish for defining non-configurable property which is non-existent in the target")
ECMA_ERROR_DEF (
  ECMA_ERR_TRAP_TRUISH_ADD_PROPERTY_INCOMPATIBLE_OTHER_PROP,
  "Trap returned truish for adding property that is incompatible with the existing property in the target")
#endif /* JERRY_BUILTIN_PROXY */
ECMA_ERROR_DEF (ECMA_ERR_CANNOT_ACCESS_CALLER_CALLE_ARGUMENTS,
                "'caller', 'callee', and 'arguments' properties may not be accessed on strict mode functions or the "
                "arguments objects for calls to them")
