/*
 * Copyright 2005-2017 Gentoo Foundation
 * Distributed under the terms of the GNU General Public License v2
 *
 * Print out some paths for sourcing into scripts.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <libgen.h>
#include <sys/param.h>
#include <selinux/selinux.h>
#include <selinux/get_default_type.h>

int main(void)
{
	char *pol_path = (char *) calloc((MAXPATHLEN + 1), sizeof(char));

	/* construct policy root path and print */
	strncpy(pol_path, selinux_policy_root(), MAXPATHLEN - sizeof("/selinux/src/policy"));
	printf("policy_root_path=\"%s\"\n", pol_path);

	/* mangle path to be source path, print, and then free */
	if (strncmp(basename(pol_path), "security", strlen("security") + 1) == 0)
		strcat(pol_path, "/selinux/src/policy");
	else
		strcat(pol_path, "/src/policy");

	printf("source_policy_path=\"%s\"\n", pol_path);
	free(pol_path);

	/* remaining paths need no mangling */
	printf("binary_policy_path=\"%s\"\n", selinux_binary_policy_path());
	printf("contexts_path=\"%s\"\n", selinux_contexts_path());
	printf("file_contexts_path=\"%s\"\n", selinux_file_context_path());
	printf("default_type_path=\"%s\"\n", selinux_default_type_path());
	printf("default_context_path=\"%s\"\n", selinux_default_context_path());
	printf("failsafe_context_path=\"%s\"\n", selinux_failsafe_context_path());
	printf("user_contexts_path=\"%s\"\n", selinux_user_contexts_path());
	printf("removable_contexts_path=\"%s\"\n", selinux_removable_context_path());
	printf("media_contexts_path=\"%s\"\n", selinux_media_context_path());

	return 0;
}
