/*
 * Decompiled with CFR 0.152.
 */
package com.ca.commons.jndi;

import com.ca.commons.jndi.JNDIOps;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.NamingException;

public class ConnectionData {
    public String baseDN = "";
    public int version = 3;
    public static final String LDAP = "ldap";
    public static final String DSML = "dsml";
    public String protocol = "ldap";
    public String url;
    public String userDN;
    public char[] pwd;
    public String referralType = "follow";
    public String aliasType = "searching";
    public boolean useSSL;
    public String cacerts;
    public String clientcerts;
    public char[] caKeystorePwd;
    public char[] clientKeystorePwd;
    public String caKeystoreType;
    public String clientKeystoreType;
    public String sslSocketFactory = "com.ca.commons.jndi.JndiSocketFactory";
    public boolean tracing;
    public boolean sslTracing;
    private static final String DEFAULT_CTX = "com.sun.jndi.ldap.LdapCtxFactory";
    private static final String DEFAULT_DSML_CTX = "com.ca.jndiproviders.dsml.DsmlCtxFactory";
    public boolean useGSSAPI;
    public Properties extraProperties;
    public String templateName;
    public boolean readOnly = false;

    public ConnectionData() {
    }

    public ConnectionData(int version, String url, String userDN, char[] pwd, boolean tracing, String referralType, String aliasType, boolean useSSL, String cacerts, String clientcerts, char[] caKeystorePwd, char[] clientKeystorePwd, String caKeystoreType, String clientKeystoreType, boolean useGSSAPI, String templateName, Properties extraProperties) {
        this.version = version;
        this.url = url;
        this.userDN = userDN;
        this.pwd = pwd;
        this.referralType = referralType;
        this.aliasType = aliasType;
        this.useSSL = useSSL;
        this.cacerts = cacerts;
        this.clientcerts = clientcerts;
        this.caKeystorePwd = caKeystorePwd;
        this.clientKeystorePwd = clientKeystorePwd;
        this.caKeystoreType = caKeystoreType;
        this.clientKeystoreType = clientKeystoreType;
        this.tracing = tracing;
        this.sslTracing = tracing;
        this.useGSSAPI = useGSSAPI;
        this.templateName = templateName;
        this.extraProperties = extraProperties;
    }

    public ConnectionData(int version, String url, String userDN, char[] pwd, boolean tracing, String referralType, String aliasType) {
        this.version = version;
        this.url = url;
        this.userDN = userDN;
        this.pwd = pwd;
        this.referralType = referralType;
        this.aliasType = aliasType;
        this.sslTracing = tracing;
    }

    public void setProtocol(String newProtocol) {
        if (newProtocol.equalsIgnoreCase(LDAP)) {
            this.protocol = LDAP;
        } else if (newProtocol.equalsIgnoreCase(DSML)) {
            this.protocol = DSML;
        } else {
            System.err.println("Unknown Protocol " + newProtocol);
        }
    }

    public void clearPasswords() {
        int i;
        if (this.pwd != null) {
            for (i = 0; i < this.pwd.length; ++i) {
                this.pwd[i] = 32;
            }
        }
        if (this.caKeystorePwd != null) {
            for (i = 0; i < this.caKeystorePwd.length; ++i) {
                this.caKeystorePwd[i] = 32;
            }
        }
        if (this.clientKeystorePwd != null) {
            for (i = 0; i < this.clientKeystorePwd.length; ++i) {
                this.clientKeystorePwd[i] = 32;
            }
        }
        this.pwd = null;
        this.caKeystorePwd = null;
        this.clientKeystorePwd = null;
    }

    public void setURL(String host, int port) {
        if (this.protocol == LDAP) {
            this.url = "ldap://" + host + ":" + port;
        } else if (this.protocol == DSML) {
            this.url = "http://" + host + ":" + port;
        }
    }

    public void setURL(String URL2) {
        if (this.protocol == LDAP) {
            this.url = URL2.toLowerCase().startsWith("ldap://") ? URL2 : "ldap://" + URL2;
        } else if (this.protocol == DSML) {
            this.url = URL2.toLowerCase().startsWith("http://") ? URL2 : (URL2.toLowerCase().startsWith("dsml://") ? "http://" + URL2.substring(7) : "http://" + URL2);
        } else if (URL2.toLowerCase().startsWith("ldap:")) {
            this.protocol = LDAP;
            this.url = URL2;
        } else if (URL2.toLowerCase().startsWith("http:")) {
            this.protocol = DSML;
            this.url = URL2;
        } else if (URL2.toLowerCase().startsWith("dsml:")) {
            this.protocol = DSML;
            this.url = "http:" + URL2.substring(5);
        }
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public String getURL() {
        return this.url;
    }

    public String getHost() {
        if (this.url == null) {
            return null;
        }
        int protocolSeparator = this.url.indexOf("://") + 3;
        int portSeparator = this.url.indexOf(":", protocolSeparator);
        return this.url.substring(protocolSeparator, portSeparator);
    }

    public int getPort() {
        if (this.url == null) {
            return -1;
        }
        try {
            int protocolSeparator = this.url.indexOf("://") + 3;
            int portSeparator = this.url.indexOf(":", protocolSeparator) + 1;
            int serverDetails = this.url.indexOf("/", portSeparator);
            String port = serverDetails == -1 ? this.url.substring(portSeparator) : this.url.substring(portSeparator, serverDetails);
            int portNumber = Integer.parseInt(port);
            if (portNumber > 65536 || portNumber <= 0) {
                return -1;
            }
            return portNumber;
        }
        catch (NumberFormatException nfe) {
            return -1;
        }
    }

    public String toString() {
        return new String("baseDN: " + (this.baseDN == null ? "null" : this.baseDN) + "\nversion: " + Integer.toString(this.version) + "\nurl: " + (this.url == null ? "null" : this.url) + "\nuserDN: " + (this.userDN == null ? "null" : this.userDN) + "\npwd: " + (this.pwd == null ? "null" : "***") + "\nreferralType: " + (this.referralType == null ? "null" : this.referralType) + "\naliasType: " + (this.aliasType == null ? "null" : this.aliasType) + "\nuseSSL: " + String.valueOf(this.useSSL) + "\ncacerts: " + (this.cacerts == null ? "null" : this.cacerts) + "\nclientcerts: " + (this.clientcerts == null ? "null" : this.clientcerts) + "\ncaKeystoreType: " + (this.caKeystoreType == null ? "null" : this.caKeystoreType) + "\nclientKeystoreType: " + (this.clientKeystoreType == null ? "null" : this.clientKeystoreType) + "\ncaKeystorePwd; " + (this.caKeystorePwd == null ? "null" : new String(this.caKeystorePwd)) + "\nclientKeystorePwd: " + (this.clientKeystorePwd == null ? "null" : new String(this.clientKeystorePwd)) + "\ntracing: " + String.valueOf(this.tracing) + "\nprotocol: " + (this.protocol == null ? "null" : this.protocol) + "\nsslSocketFactory: " + (this.sslSocketFactory == null ? "null" : this.sslSocketFactory) + "\nuseGSSAPI: " + String.valueOf(this.useGSSAPI));
    }

    public Hashtable getJNDIEnvironment() throws NamingException {
        this.checkData();
        Hashtable<String, String> env = new Hashtable<String, String>();
        if (this.protocol == DSML) {
            env.put("java.naming.factory.initial", DEFAULT_DSML_CTX);
        } else if (this.protocol == LDAP) {
            env.put("java.naming.factory.initial", DEFAULT_CTX);
        }
        JNDIOps.setupBasicProperties(env, this.url, this.tracing, this.referralType, this.aliasType);
        if (this.pwd != null && this.userDN != null) {
            JNDIOps.setupSimpleSecurityProperties(env, this.userDN, this.pwd);
        }
        if (this.useSSL) {
            if (this.tracing) {
                this.sslTracing = true;
            }
            JNDIOps.setupSSLProperties(env, this.cacerts, this.clientcerts, this.caKeystorePwd, this.clientKeystorePwd, this.caKeystoreType, this.clientKeystoreType, this.sslTracing, this.sslSocketFactory);
        }
        if (this.useGSSAPI) {
            env.put("java.naming.security.authentication", "GSSAPI");
            env.put("javax.security.sasl.qop", "auth-conf");
        }
        if (this.extraProperties != null && this.extraProperties.size() > 0) {
            Enumeration<Object> extraKeys = this.extraProperties.keys();
            while (extraKeys.hasMoreElements()) {
                try {
                    String key = (String)extraKeys.nextElement();
                    String value = this.extraProperties.getProperty(key);
                    if (value == null) continue;
                    env.put(key, value);
                }
                catch (ClassCastException classCastException) {}
            }
        }
        return env;
    }

    public void checkData() throws NamingException {
        if (this.url == null) {
            throw new NamingException("URL not specified in openContext()!");
        }
        if (this.version < 2 || this.version > 3) {
            throw new NamingException("Incorrect ldap Version! (was " + this.version + ")");
        }
        if (this.useSSL && this.cacerts == null) {
            throw new NamingException("Cannot use SSL without a trusted CA certificates JKS file.");
        }
        if (this.referralType == null) {
            this.referralType = "follow";
        }
        if (this.aliasType == null) {
            this.aliasType = "finding";
        }
        if ("followthrowignore".indexOf(this.referralType) == -1) {
            throw new NamingException("unknown referral type: " + this.referralType + " (setting to 'follow')");
        }
    }

    public void putExtraProperty(String key, String property) {
        if (this.extraProperties == null) {
            this.extraProperties = new Properties();
        }
        this.extraProperties.put(key, property);
    }
}

