/*
 * Decompiled with CFR 0.152.
 */
package com.pegacat.jxworkbench.reports;

import com.ca.commons.jndi.ConnectionData;
import com.ca.commons.jndi.SchemaOps;
import com.ca.commons.naming.DN;
import com.ca.commons.naming.DXAttribute;
import com.ca.commons.naming.DXAttributes;
import com.ca.directory.jxplorer.BatchJob;
import com.ca.directory.jxplorer.JXConfig;
import com.ca.directory.jxplorer.JXplorer;
import com.ca.directory.jxplorer.JXplorerBrowser;
import com.ca.directory.jxplorer.broker.JNDIDataBroker;
import com.ca.directory.jxplorer.search.SearchModel;
import com.pegacat.jxworkbench.JXWConWin;
import com.pegacat.jxworkbench.reports.JXWReport;
import com.pegacat.jxworkbench.reports.JasperApplication;
import java.io.File;

public class JXWBatchReport
implements BatchJob {
    String password = null;
    String connection = null;
    String dn = null;
    String filter = null;
    String report = null;
    String search = null;
    String input = null;
    String output = null;
    String[] outputFormats = new String[]{"HTML"};
    File inputReportFile = null;
    File outputReportDir = null;
    JNDIDataBroker broker = null;
    JXplorerBrowser fakeBrowser = new JXplorerBrowser();

    public void execute(JXplorer jx, String[] args) {
        try {
            int i = 0;
            while (i < args.length) {
                String key;
                if ((key = args[i++]).charAt(0) != '-') {
                    this.printHelpAndExit("unexpected parameter: '" + key + "'");
                }
                try {
                    switch (key.charAt(1)) {
                        case 'c': {
                            this.connection = args[i++];
                            break;
                        }
                        case 'd': {
                            this.dn = args[i++];
                            break;
                        }
                        case 'f': {
                            this.filter = args[i++];
                            break;
                        }
                        case 'h': {
                            this.printHelpAndExit(null);
                        }
                        case 'p': {
                            this.password = args[i++];
                            break;
                        }
                        case 'r': {
                            break;
                        }
                        case 's': {
                            this.search = args[i++];
                            break;
                        }
                        case 't': {
                            this.report = args[i++];
                        }
                    }
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    this.printHelpAndExit("no value for " + key + " parameter");
                }
            }
            if (this.filter != null && this.search != null) {
                this.printHelpAndExit("Cannot specify both a filter and a predefined search - please choose one");
            }
            if (this.filter == null && this.search == null) {
                this.filter = "(objectClass=*)";
            }
            if (this.report != null && (this.input != null || this.output != null)) {
                this.printHelpAndExit("Cannot specify a predefined report and input or output parameters");
            }
            if (this.connection == null) {
                this.printHelpAndExit("No directory connection provided - cannot run report without a -con parameter");
            }
            if (this.search != null) {
                this.loadSearchTemplate();
            }
            this.broker = this.openLDAPContext();
            this.loadReportTemplate();
            JasperApplication.initJasperProperties();
            JasperApplication dataSourceApp = new JasperApplication(this.broker, this.inputReportFile, this.outputReportDir, this.outputFormats, this.getReportDN());
            dataSourceApp.compile();
            dataSourceApp.runReport();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.printHelpAndExit("Error running report batch program: " + e.getMessage());
        }
        System.exit(0);
    }

    public JNDIDataBroker openLDAPContext() throws Exception {
        JXWConWin connectionUI = new JXWConWin(this.fakeBrowser, null, JXConfig.getProperty((String)"option.ssl.clientcerts"), JXConfig.getProperty((String)"option.ssl.cacerts"), JXConfig.getProperty((String)"option.ldap.referral"), JXConfig.getProperty((String)"option.ldap.searchAliasBehaviour"));
        connectionUI.loadTemplate(this.connection);
        ConnectionData con = connectionUI.getConnectionData(this.password == null ? null : this.password.toCharArray());
        JNDIDataBroker broker = new JNDIDataBroker();
        broker.openConnection(con);
        DXAttribute.setDefaultSchema((SchemaOps)broker.getSchemaOps());
        DXAttributes.setDefaultSchema((SchemaOps)broker.getSchemaOps());
        return broker;
    }

    public void loadSearchTemplate() {
        SearchModel searchModel = new SearchModel();
        this.filter = searchModel.getFilter(this.search);
        if (this.filter == null) {
            this.filter = "(objectClass=*)";
            System.err.println("WARNING: Unable to find Saved Search '" + this.search + "'");
            return;
        }
        this.dn = searchModel.getValue(this.search, "baseDN");
    }

    public void loadReportTemplate() {
        JXWReport reportUI = new JXWReport(this.fakeBrowser);
        reportUI.loadTemplate(this.report);
        this.inputReportFile = reportUI.getReportFile();
        this.outputReportDir = reportUI.getDestinationDirectory();
        this.outputFormats = reportUI.getOutputFormats();
    }

    public DN getReportDN() {
        if (this.dn != null) {
            return new DN(this.dn);
        }
        return null;
    }

    private void printHelpAndExit(String msg) {
        try {
            Thread.sleep(50L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (msg != null) {
            System.out.println("\n" + msg + "\n");
        }
        System.out.println("JXWORKBENCH BATCH REPORT USAGE\nTo run a report, setup a connection, report etc. in JXplorer, then use:\n  -report -con <connection name> -template <report name>\n  or \n  - report -con <connection name> [-pwd <password>]   [{-search <search name> | {[-dn <search base>] -filter <ldap filter>}}] -template <report name>\ne.g.:\n  -report -con my_connection -template my_report\n  -report -con my_con -in users.jasper -search active_users -pwd secret1\nInstead of using a search template, you can include an LDAP filter directly:\n  -report -con my_con -in fnord.jrxml -filter (objectClass=person)\nOnly the first letter of an option is strictly required:\n  -report -c my_con -r new_users -s new_user_searxh \n  -report -c my_con -r all_users -f (objectClass=person) \n  -report -c localhost -r local_users -f (objectClass=person) -d ou=legal,o=pegacat\nnote: quick save connections do not require a password, other save types do.\nnote: batch mode has no UI, *unless* 'viewer' option is set in report template.see http://jxworkbench.com for full documentation.\n");
        System.exit(-1);
    }
}

