# Previewing atmosphere model {#model-preview}

The model generated by `calcmysky` can be previewed using another utility, `showmysky`. You can start it and choose the model directory, or pass the directory as a command-line argument.

The window will show the preview with a toolbox, similar to the screenshot below.

\image html showmysky-screenshot.png "Screenshot of ShowMySky"

## Image window

The image displayed in the main part of the window is the scene projected onto the screen in the [projection chosen](#projection). The top (when zoom, camera pitch and yaw have default values) corresponds to zenith, the bottom to nadir, the sides to the South, and the middle to the North.

Keyboard/mouse actions have the following effects:

 * <kbd>Ctrl</kbd> + drag: move the Sun, affects [Sun azimuth](#sun-azimuth-control) and [Sun elevation](#sun-elevation-control);
 * <kbd>Shift</kbd> + drag: change camera orientation, affects [Camera pitch](#camera-pitch-control) and [Camera yaw](#camera-yaw-control);
 * Right-mouse-button drag: the same as <kbd>Shift</kbd> + drag;
 * Left mouse button click: when Radiance plot is opened, pick a pixel to display its radiance.

## Tools widget controls

### Altitude

This manipulator defines altitude of the camera above the ground.

### <a name="exposure">log<sub>10</sub>(exposure)</a>

This manipulator controls brightness of the scene, similar to the exposure setting of a photo camera. The numeric value is a logarithm of the actual brightness factor.

<span style="background-color: red;">TODO</span>: describe how the radiance in \f$\mathrm{cd/m^2}\f$ gets converted into the final RGB units on the display.

### <a name="sun-elevation-control">Sun elevation</a>

Elevation of the Sun over mathematical horizon.

### <a name="sun-azimuth-control">Sun azimuth</a>

Azimuth of the Sun, zero being North.

### Sun angular radius

Angular radius of the solar disk. In real life it depends on the distance between the Sun and the camera (and thus on time of year).

### Moon elevation

Elevation of the Moon over mathematical horizon. It's used the simulation of solar eclipses.

### Moon azimuth

Azimuth of the Moon, zero being North. It's used in the simulation of solar eclipses.

### Earth-Moon distance

Distance between the centers of the Earth and the Moon. It's used in the simulation of solar eclipses.

### <a name="projection">Projection</a>

This control lets one choose a projection from the following options:

 * Equirectangular — shows all directions in the [equirectangular projection](https://en.wikipedia.org/wiki/Equirectangular_projection).
 * Perspective — the usual [perspective projection](https://en.wikipedia.org/wiki/Perspective_projection), with maximum horizontal field of view being 120° (which can be reduced via the [zoom control](#zoom)). Aspect ratio of the window affects vertical field of view.
 * Fisheye — simulates the view through a [fisheye lens](https://en.wikipedia.org/wiki/Fisheye_lens), with field of view being 360° (it can be reduced via the [zoom control](#zoom)).

### <a name="zoom">Zoom</a>

Zoom in factor. This factor increases the size of the image.

### <a name="camera-pitch-control">Camera pitch</a>

Changes the direction of look or the camera by tilting it up or down. The projection remains the same, so the horizon becomes curved.

### <a name="camera-yaw-control">Camera yaw</a>

Changes the direction of look or the camera by rotating it left or right.

### Dithering method

The scenes rendered contain wide gradients, often between very close colors. The typical 8 bit per color channel quantization appears too limited in such conditions, which results in banding. To fight it, [dithering](https://en.wikipedia.org/wiki/Dither#Digital_photography_and_image_processing) can be used.

ShowMySky previewer supports two dithering methods:

 * No dithering. This method just ignores the problem and lets the graphics system handle it as it can (might be OK for 10-bit monitors).
 * [Ordered dithering](https://en.wikipedia.org/wiki/Ordered_dithering), which is _theoretically_ optimal. In practice it often conflicts with LCD monitors' internal dithering algorithms, making the image even worse than without dithering.
 * Optimized blue noise with triangular remapping. This method is based on Bart Wronski's article ["Dithering part three – real world 2D quantization dithering"](https://bartwronski.com/2016/10/30/dithering-part-three-real-world-2d-quantization-dithering/), with some tweaks (see `dither_BlueTriang` GLSL function defined inside `GLWidget::initializeGL` and the comment at the top of ShowMySky/BlueNoiseTriangleRemapped.hpp).

### Dithering color depth

Dithering algorithm has to make some assumptions about the display device. Often, even the operating system of the computer can't tell what color depth a monitor has. This option lets the user set the correct color depth (or try them and choose the best).

The options are named as R/G/B where R, G, and B are number of bits in corresponding RGB channel. Here's the list of options:

 * 5/6/5 — this is the typical High color display mode;
 * 6/6/6 — this color depth is typical for LCD TN monitors, and sometimes others;
 * 8/8/8 — this should be tried first, unless you have a high-end monitor with support for 10 bit per color channel mode;
 * 10/10/10 — this is the option for high-end monitors with support for 10 bit per color channel mode. On the conventional 8-bit monitors this dithering mode will look as if dithering is disabled.

### Color mode

This control lets one analyze image colors by looking at the following representations them:

 * sRGB — this is the usual mode intended to look as the scene looks to human eyes.
 * Scotopic luminance — displays the night-vision brightness of the scene instead of full colors. This in particular takes into account the [Purkinje effect](https://en.wikipedia.org/wiki/Purkinje_effect).
 * Photopic luminance — this displays the brightness of the scene instead of full colors. This brightness represents sensitivity of human vision in daylight conditions.
 * XYZ chromaticity — normalizes photopic brightness of all pixels to the same value. As it doesn't quite map well to the brightness range of monitor pixels, the [exposure control](#exposure) can be used to brighten or darken the image. In the parts of the image where the brightness of some pixels is too large to represent on the screen, a black-white pattern is drawn.
 * sRGBl chromaticiy (smooth) — this is almost the same as XYZ chromaticity, but in this case the pre-transfer-function sRGB values are normalized instead of the XYZ values.
 * sRGBl chromaticity (bright) — this is like "sRGBl chromaticity (smooth)", but all the pixels are brought to maximum representable brightness for the given chromaticity. [Exposure control](#exposure) has no effect in this mode.
 * Hue — this mode removes all brightness and saturation information from the image. All colors are maximally saturated and bright. [Exposure control](#exposure) has no effect in this mode.

### Gradual color clipping

This option makes the colors too bright to display smoothly saturate in brightness instead of abruptly clamping at maximum value. This makes gradients that change from displayable colors into very bright colors nicer. The plot below shows the comparison of the simple clamping and gradual clipping as brightness of a given color `#fcb55c` increases.

<!--
gnuplot -p -e "set key autotitle columnhead right center;
set yrange [0 to 1.01];
set xlabel 'computed brightness';
set ylabel 'displayed brightness';
set term svg size 600 400;
set output 'gradual-clipping-plot.svg';
set datafile separator ',';
set mouse format '%.15g';
plot '/tmp/data.csv' using 1:2 with lines dashtype 2 linecolor rgb '#ff0000',
                  '' using 1:3 with lines dashtype 2 linecolor rgb '#00ff00',
                  '' using 1:4 with lines dashtype 2 linecolor rgb '#0000ff',
                  '' using 1:5 with lines linecolor rgb '#ff0000',
                  '' using 1:6 with lines linecolor rgb '#00ff00',
                  '' using 1:7 with lines linecolor rgb '#0000ff'"
-->

\image html gradual-clipping-plot.svg "Gradual clipping applied to input color channels of different brightness"

Below are two examples of the same scene, one with gradual color clipping turned off, and another with it turned on.

\image html gradual-color-clipping-off.png "Without gradual color clipping"
\image html gradual-color-clipping-on.png "With gradual color clipping"

### Glare

Real-life optical systems (including human eyes) never map a single cone of view to a single pixel. Instead, each pixel samples the whole field of view of the camera with varying weights, and the direction that it's supposed to display has a sharp peak in the weight function. On the one hand, this leads to starburst effect, blur, and other aberrations. On the other hand, it lets one see the colors of bright sources of light that would otherwise be seen as simply white points.

The _Glare_ checkbox enables a simplistic simulation of glare in the scene, letting one perceive brightness and color of the Sun, whose disk is almost always overexposed. In particular, we can see how the solar disk becomes bluish (which is invisible without glare) during sunrise watched through the ozone layer, as shown below.

\image html sunrise-from-50km.png "Sunrise viewed from 50 km altitude"

### Draw zero-order scattering layer

Zero-order scattering layer contains radiance from the Sun and from the ground. Technically, the ground doesn't emit visible light on its own, it just scatters the sunlight, but the way the simulation is organized puts it into the zero-order layer. Such separation is also useful for applications such as Stellarium, which renders both the Sun and the ground with its own means.

### Draw single scattering layers

Single scattering layers contain radiance from first-order scattering on the constituents of the atmosphere. This radiance is stored in separate textures, and is only controlled by this checkbox if the values haven't been merged into multiple scattering texture (see [<code>phase function type</code> parameter](model-generation.html#phase-function-type) in atmosphere description file).

This option has sub-options corresponding to each separate single scattering layer. This lets one check how much light is scattered by each of these constituents. But note that enabling or disabling these sub-options only affects incoming radiance, it doesn't affect transmittance of the atmosphere. Enabling or disabling these layers is not the same as enabling or disabling a constituent of the atmosphere.

### Draw multiple scattering layer

This layer contains radiance from scattering orders higher than 1, and additionally the first-order scattering by the species whose [phase function](single-multiple-scattering.html#phase-function) was marked as smooth (see [<code>phase function type</code> parameter](model-generation.html#phase-function-type) in atmosphere description file).

### Light pollution luminance

Luminance of the ground that results in light pollution. Set to zero to remove light pollution from the scene.

### <a name="solar-spectrum-control">Solar spectrum</a>

When the model has radiance textures (see [<code>\--radiance</code> option](model-generation.html#radiance-option) for `calcmysky`), this setting lets one replace the solar spectrum with another. The options are:

 * Precomputed (default) — the spectrum that was specified by [<code>solar irradiance at TOA</code>](model-generation.html#solar-irradiance-at-toa) in the atmosphere description file;
 * Flat \f$1\,\mathrm{W/m^2/nm}\f$ — just a constant spectral power density, useful to separate the effect of the atmosphere from the structure of solar spectrum;
 * Black body — choosing this option adds a spinbox that lets one choose the temperature of a black body that will replace the Sun. Default temperature in this spinbox is the effective temperature of the (real-world) solar photosphere.

### Texture filtering

This is a debugging option. Normally all the textures are linearly interpolated when sampling. If this option is disabled, zero-order interpolation is used.

### Compute single scattering on the fly

Compute first-order scattering radiance of each pixel on the fly instead of using precomputed textures. Increases quality, but reduces performance.

### Precompute double(-only) scattering on the fly

This option is only used with eclipse shaders. It's only available when double scattering textures are available (see [<code>\--no-eds-tex</code> option](model-generation.html#no-eds-tex-option) for `calcmysky`).

When this option is enabled, double scattering is computed on the fly instead of using precomputed textures. If the textures are not available, it's always enabled.

### Use eclipse-mode shaders

Normal sky, when the Moon doesn't block the Sun, can be rendered using much more performant shaders and with higher quality (i.e. including third- and higher-order scattering radiance). But when the Moon does block the Sun, we have to resort to a more general model, which takes into account relative positions of the Sun and the Moon and simulates solar eclipse. This model only supports first- and second-order scattering, because it's a very expensive computation.

This option lets one use the shaders that can simulate eclipse instead of the default ones that work with normal sky.

### Pseudo-mirror sky in the ground

Some applications like [Stellarium](https://stellarium.org/) (for which this project was initially created) don't want to display ground in any way, and instead they show the sky colors there.

This option enables a kind of mirror image of the sky instead of the ground (it isn't physically a simulation of a mirror).

### Reload shaders

This is a debugging command. It reloads all textures in the current model. Useful with [<code>\--no-save-tex</code> option](model-generation.html#no-save-tex-option) of `calcmysky`.

### <a name="show-radiance-plot-control">Show radiance plot</a>

When the model has radiance textures (see [<code>\--radiance</code> option](model-generation.html#radiance-option) for `calcmysky`), this command opens (or brings to the front) the window that shows a plot of spectral radiance.

This window lets one examine simulated spectral radiance of any pixel in the scene. Just click the interesting pixel after opening the _Spectral radiance_ window to see the spectral radiance.

In addition, luminance computed from this spectrum is displayed in the top-right corner of the Spectral radiance window.

### Window decoration and status bar

Sometimes it's useful to have a bare window, without any controls, just an image. For example, when comparing the rendering with a photograph. Tools widget can be simply undocked, while status bar and window decoration (i.e. borders and title bar) need some way to be hidden. This option lets the user hide this GUI frame.
