package util

import (
	"fmt"
	"testing"

	"github.com/stretchr/testify/assert"
)

func TestMarkdownCodify(t *testing.T) {
	assert.Equal(t, "`mystring`", MarkdownCodify("mystring"))
}

func TestInSlice(t *testing.T) {
	tests := []struct {
		s         string
		sl        []string
		assertion assert.BoolAssertionFunc
	}{
		{"foo", []string{"foo", "bar"}, assert.True},
		{"bar", []string{"foo", "baz"}, assert.False},
		{"", []string{"", "baz"}, assert.True},
		{"", []string{"foo", "baz"}, assert.False},
		{"baz", []string{}, assert.False},
	}
	for i, tt := range tests {
		t.Run(fmt.Sprintf("%s-%d", tt.s, i), func(t *testing.T) {
			tt.assertion(t, InSlice(tt.s, tt.sl))
		})
	}
}

func TestContainsAlphanumeric(t *testing.T) {
	tests := []struct {
		s         string
		assertion assert.BoolAssertionFunc
	}{
		{"foo", assert.True},
		{"bar123", assert.True},
		{"", assert.False},
		{" ", assert.False},
		{"123", assert.True},
		{"<-- -->", assert.False},
		{"#", assert.False},
		{"      //", assert.False},
	}
	for i, tt := range tests {
		t.Run(fmt.Sprintf("%s-%d", tt.s, i), func(t *testing.T) {
			tt.assertion(t, ContainsAlphanumeric(tt.s))
		})
	}
}

func TestFilterEmptyStrings(t *testing.T) {
	tests := []struct {
		s      []string
		actual []string
	}{
		{[]string{"foo", "bar"}, []string{"foo", "bar"}},
		{[]string{"foo", "", "bar"}, []string{"foo", "bar"}},
		{[]string{"", "bar"}, []string{"bar"}},
	}
	for i, tt := range tests {
		t.Run(fmt.Sprintf("%s-%d", tt.s, i), func(t *testing.T) {
			assert.ElementsMatch(t, FilterEmptyStrings(tt.s), tt.actual)
		})
	}
}
