// Code generated by protoc-gen-go. DO NOT EDIT.
// source: interop/grpc_testing/test.proto

package grpc_testing

import (
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// The type of payload that should be returned.
type PayloadType int32

const (
	// Compressable text format.
	PayloadType_COMPRESSABLE PayloadType = 0
	// Uncompressable binary format.
	PayloadType_UNCOMPRESSABLE PayloadType = 1
	// Randomly chosen from all other formats defined in this enum.
	PayloadType_RANDOM PayloadType = 2
)

var PayloadType_name = map[int32]string{
	0: "COMPRESSABLE",
	1: "UNCOMPRESSABLE",
	2: "RANDOM",
}

var PayloadType_value = map[string]int32{
	"COMPRESSABLE":   0,
	"UNCOMPRESSABLE": 1,
	"RANDOM":         2,
}

func (x PayloadType) String() string {
	return proto.EnumName(PayloadType_name, int32(x))
}

func (PayloadType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_534063719f48d90d, []int{0}
}

// The type of route that a client took to reach a server w.r.t. gRPCLB.
// The server must fill in "fallback" if it detects that the RPC reached
// the server via the "gRPCLB fallback" path, and "backend" if it detects
// that the RPC reached the server via "gRPCLB backend" path (i.e. if it got
// the address of this server from the gRPCLB server BalanceLoad RPC). Exactly
// how this detection is done is context and server dependant.
type GrpclbRouteType int32

const (
	// Server didn't detect the route that a client took to reach it.
	GrpclbRouteType_GRPCLB_ROUTE_TYPE_UNKNOWN GrpclbRouteType = 0
	// Indicates that a client reached a server via gRPCLB fallback.
	GrpclbRouteType_GRPCLB_ROUTE_TYPE_FALLBACK GrpclbRouteType = 1
	// Indicates that a client reached a server as a gRPCLB-given backend.
	GrpclbRouteType_GRPCLB_ROUTE_TYPE_BACKEND GrpclbRouteType = 2
)

var GrpclbRouteType_name = map[int32]string{
	0: "GRPCLB_ROUTE_TYPE_UNKNOWN",
	1: "GRPCLB_ROUTE_TYPE_FALLBACK",
	2: "GRPCLB_ROUTE_TYPE_BACKEND",
}

var GrpclbRouteType_value = map[string]int32{
	"GRPCLB_ROUTE_TYPE_UNKNOWN":  0,
	"GRPCLB_ROUTE_TYPE_FALLBACK": 1,
	"GRPCLB_ROUTE_TYPE_BACKEND":  2,
}

func (x GrpclbRouteType) String() string {
	return proto.EnumName(GrpclbRouteType_name, int32(x))
}

func (GrpclbRouteType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_534063719f48d90d, []int{1}
}

type Empty struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Empty) Reset()         { *m = Empty{} }
func (m *Empty) String() string { return proto.CompactTextString(m) }
func (*Empty) ProtoMessage()    {}
func (*Empty) Descriptor() ([]byte, []int) {
	return fileDescriptor_534063719f48d90d, []int{0}
}

func (m *Empty) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Empty.Unmarshal(m, b)
}
func (m *Empty) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Empty.Marshal(b, m, deterministic)
}
func (m *Empty) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Empty.Merge(m, src)
}
func (m *Empty) XXX_Size() int {
	return xxx_messageInfo_Empty.Size(m)
}
func (m *Empty) XXX_DiscardUnknown() {
	xxx_messageInfo_Empty.DiscardUnknown(m)
}

var xxx_messageInfo_Empty proto.InternalMessageInfo

// A block of data, to simply increase gRPC message size.
type Payload struct {
	// The type of data in body.
	Type PayloadType `protobuf:"varint,1,opt,name=type,proto3,enum=grpc.testing.PayloadType" json:"type,omitempty"`
	// Primary contents of payload.
	Body                 []byte   `protobuf:"bytes,2,opt,name=body,proto3" json:"body,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Payload) Reset()         { *m = Payload{} }
func (m *Payload) String() string { return proto.CompactTextString(m) }
func (*Payload) ProtoMessage()    {}
func (*Payload) Descriptor() ([]byte, []int) {
	return fileDescriptor_534063719f48d90d, []int{1}
}

func (m *Payload) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Payload.Unmarshal(m, b)
}
func (m *Payload) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Payload.Marshal(b, m, deterministic)
}
func (m *Payload) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Payload.Merge(m, src)
}
func (m *Payload) XXX_Size() int {
	return xxx_messageInfo_Payload.Size(m)
}
func (m *Payload) XXX_DiscardUnknown() {
	xxx_messageInfo_Payload.DiscardUnknown(m)
}

var xxx_messageInfo_Payload proto.InternalMessageInfo

func (m *Payload) GetType() PayloadType {
	if m != nil {
		return m.Type
	}
	return PayloadType_COMPRESSABLE
}

func (m *Payload) GetBody() []byte {
	if m != nil {
		return m.Body
	}
	return nil
}

// A protobuf representation for grpc status. This is used by test
// clients to specify a status that the server should attempt to return.
type EchoStatus struct {
	Code                 int32    `protobuf:"varint,1,opt,name=code,proto3" json:"code,omitempty"`
	Message              string   `protobuf:"bytes,2,opt,name=message,proto3" json:"message,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *EchoStatus) Reset()         { *m = EchoStatus{} }
func (m *EchoStatus) String() string { return proto.CompactTextString(m) }
func (*EchoStatus) ProtoMessage()    {}
func (*EchoStatus) Descriptor() ([]byte, []int) {
	return fileDescriptor_534063719f48d90d, []int{2}
}

func (m *EchoStatus) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_EchoStatus.Unmarshal(m, b)
}
func (m *EchoStatus) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_EchoStatus.Marshal(b, m, deterministic)
}
func (m *EchoStatus) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EchoStatus.Merge(m, src)
}
func (m *EchoStatus) XXX_Size() int {
	return xxx_messageInfo_EchoStatus.Size(m)
}
func (m *EchoStatus) XXX_DiscardUnknown() {
	xxx_messageInfo_EchoStatus.DiscardUnknown(m)
}

var xxx_messageInfo_EchoStatus proto.InternalMessageInfo

func (m *EchoStatus) GetCode() int32 {
	if m != nil {
		return m.Code
	}
	return 0
}

func (m *EchoStatus) GetMessage() string {
	if m != nil {
		return m.Message
	}
	return ""
}

// Unary request.
type SimpleRequest struct {
	// Desired payload type in the response from the server.
	// If response_type is RANDOM, server randomly chooses one from other formats.
	ResponseType PayloadType `protobuf:"varint,1,opt,name=response_type,json=responseType,proto3,enum=grpc.testing.PayloadType" json:"response_type,omitempty"`
	// Desired payload size in the response from the server.
	// If response_type is COMPRESSABLE, this denotes the size before compression.
	ResponseSize int32 `protobuf:"varint,2,opt,name=response_size,json=responseSize,proto3" json:"response_size,omitempty"`
	// Optional input payload sent along with the request.
	Payload *Payload `protobuf:"bytes,3,opt,name=payload,proto3" json:"payload,omitempty"`
	// Whether SimpleResponse should include username.
	FillUsername bool `protobuf:"varint,4,opt,name=fill_username,json=fillUsername,proto3" json:"fill_username,omitempty"`
	// Whether SimpleResponse should include OAuth scope.
	FillOauthScope bool `protobuf:"varint,5,opt,name=fill_oauth_scope,json=fillOauthScope,proto3" json:"fill_oauth_scope,omitempty"`
	// Whether server should return a given status
	ResponseStatus *EchoStatus `protobuf:"bytes,7,opt,name=response_status,json=responseStatus,proto3" json:"response_status,omitempty"`
	// Whether SimpleResponse should include server_id.
	FillServerId bool `protobuf:"varint,9,opt,name=fill_server_id,json=fillServerId,proto3" json:"fill_server_id,omitempty"`
	// Whether SimpleResponse should include grpclb_route_type.
	FillGrpclbRouteType  bool     `protobuf:"varint,10,opt,name=fill_grpclb_route_type,json=fillGrpclbRouteType,proto3" json:"fill_grpclb_route_type,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SimpleRequest) Reset()         { *m = SimpleRequest{} }
func (m *SimpleRequest) String() string { return proto.CompactTextString(m) }
func (*SimpleRequest) ProtoMessage()    {}
func (*SimpleRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_534063719f48d90d, []int{3}
}

func (m *SimpleRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SimpleRequest.Unmarshal(m, b)
}
func (m *SimpleRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SimpleRequest.Marshal(b, m, deterministic)
}
func (m *SimpleRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SimpleRequest.Merge(m, src)
}
func (m *SimpleRequest) XXX_Size() int {
	return xxx_messageInfo_SimpleRequest.Size(m)
}
func (m *SimpleRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SimpleRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SimpleRequest proto.InternalMessageInfo

func (m *SimpleRequest) GetResponseType() PayloadType {
	if m != nil {
		return m.ResponseType
	}
	return PayloadType_COMPRESSABLE
}

func (m *SimpleRequest) GetResponseSize() int32 {
	if m != nil {
		return m.ResponseSize
	}
	return 0
}

func (m *SimpleRequest) GetPayload() *Payload {
	if m != nil {
		return m.Payload
	}
	return nil
}

func (m *SimpleRequest) GetFillUsername() bool {
	if m != nil {
		return m.FillUsername
	}
	return false
}

func (m *SimpleRequest) GetFillOauthScope() bool {
	if m != nil {
		return m.FillOauthScope
	}
	return false
}

func (m *SimpleRequest) GetResponseStatus() *EchoStatus {
	if m != nil {
		return m.ResponseStatus
	}
	return nil
}

func (m *SimpleRequest) GetFillServerId() bool {
	if m != nil {
		return m.FillServerId
	}
	return false
}

func (m *SimpleRequest) GetFillGrpclbRouteType() bool {
	if m != nil {
		return m.FillGrpclbRouteType
	}
	return false
}

// Unary response, as configured by the request.
type SimpleResponse struct {
	// Payload to increase message size.
	Payload *Payload `protobuf:"bytes,1,opt,name=payload,proto3" json:"payload,omitempty"`
	// The user the request came from, for verifying authentication was
	// successful when the client expected it.
	Username string `protobuf:"bytes,2,opt,name=username,proto3" json:"username,omitempty"`
	// OAuth scope.
	OauthScope string `protobuf:"bytes,3,opt,name=oauth_scope,json=oauthScope,proto3" json:"oauth_scope,omitempty"`
	// Server ID. This must be unique among different server instances,
	// but the same across all RPC's made to a particular server instance.
	ServerId string `protobuf:"bytes,4,opt,name=server_id,json=serverId,proto3" json:"server_id,omitempty"`
	// gRPCLB Path.
	GrpclbRouteType GrpclbRouteType `protobuf:"varint,5,opt,name=grpclb_route_type,json=grpclbRouteType,proto3,enum=grpc.testing.GrpclbRouteType" json:"grpclb_route_type,omitempty"`
	// Server hostname.
	Hostname             string   `protobuf:"bytes,6,opt,name=hostname,proto3" json:"hostname,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SimpleResponse) Reset()         { *m = SimpleResponse{} }
func (m *SimpleResponse) String() string { return proto.CompactTextString(m) }
func (*SimpleResponse) ProtoMessage()    {}
func (*SimpleResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_534063719f48d90d, []int{4}
}

func (m *SimpleResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SimpleResponse.Unmarshal(m, b)
}
func (m *SimpleResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SimpleResponse.Marshal(b, m, deterministic)
}
func (m *SimpleResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SimpleResponse.Merge(m, src)
}
func (m *SimpleResponse) XXX_Size() int {
	return xxx_messageInfo_SimpleResponse.Size(m)
}
func (m *SimpleResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SimpleResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SimpleResponse proto.InternalMessageInfo

func (m *SimpleResponse) GetPayload() *Payload {
	if m != nil {
		return m.Payload
	}
	return nil
}

func (m *SimpleResponse) GetUsername() string {
	if m != nil {
		return m.Username
	}
	return ""
}

func (m *SimpleResponse) GetOauthScope() string {
	if m != nil {
		return m.OauthScope
	}
	return ""
}

func (m *SimpleResponse) GetServerId() string {
	if m != nil {
		return m.ServerId
	}
	return ""
}

func (m *SimpleResponse) GetGrpclbRouteType() GrpclbRouteType {
	if m != nil {
		return m.GrpclbRouteType
	}
	return GrpclbRouteType_GRPCLB_ROUTE_TYPE_UNKNOWN
}

func (m *SimpleResponse) GetHostname() string {
	if m != nil {
		return m.Hostname
	}
	return ""
}

// Client-streaming request.
type StreamingInputCallRequest struct {
	// Optional input payload sent along with the request.
	Payload              *Payload `protobuf:"bytes,1,opt,name=payload,proto3" json:"payload,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StreamingInputCallRequest) Reset()         { *m = StreamingInputCallRequest{} }
func (m *StreamingInputCallRequest) String() string { return proto.CompactTextString(m) }
func (*StreamingInputCallRequest) ProtoMessage()    {}
func (*StreamingInputCallRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_534063719f48d90d, []int{5}
}

func (m *StreamingInputCallRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StreamingInputCallRequest.Unmarshal(m, b)
}
func (m *StreamingInputCallRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StreamingInputCallRequest.Marshal(b, m, deterministic)
}
func (m *StreamingInputCallRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StreamingInputCallRequest.Merge(m, src)
}
func (m *StreamingInputCallRequest) XXX_Size() int {
	return xxx_messageInfo_StreamingInputCallRequest.Size(m)
}
func (m *StreamingInputCallRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_StreamingInputCallRequest.DiscardUnknown(m)
}

var xxx_messageInfo_StreamingInputCallRequest proto.InternalMessageInfo

func (m *StreamingInputCallRequest) GetPayload() *Payload {
	if m != nil {
		return m.Payload
	}
	return nil
}

// Client-streaming response.
type StreamingInputCallResponse struct {
	// Aggregated size of payloads received from the client.
	AggregatedPayloadSize int32    `protobuf:"varint,1,opt,name=aggregated_payload_size,json=aggregatedPayloadSize,proto3" json:"aggregated_payload_size,omitempty"`
	XXX_NoUnkeyedLiteral  struct{} `json:"-"`
	XXX_unrecognized      []byte   `json:"-"`
	XXX_sizecache         int32    `json:"-"`
}

func (m *StreamingInputCallResponse) Reset()         { *m = StreamingInputCallResponse{} }
func (m *StreamingInputCallResponse) String() string { return proto.CompactTextString(m) }
func (*StreamingInputCallResponse) ProtoMessage()    {}
func (*StreamingInputCallResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_534063719f48d90d, []int{6}
}

func (m *StreamingInputCallResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StreamingInputCallResponse.Unmarshal(m, b)
}
func (m *StreamingInputCallResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StreamingInputCallResponse.Marshal(b, m, deterministic)
}
func (m *StreamingInputCallResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StreamingInputCallResponse.Merge(m, src)
}
func (m *StreamingInputCallResponse) XXX_Size() int {
	return xxx_messageInfo_StreamingInputCallResponse.Size(m)
}
func (m *StreamingInputCallResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_StreamingInputCallResponse.DiscardUnknown(m)
}

var xxx_messageInfo_StreamingInputCallResponse proto.InternalMessageInfo

func (m *StreamingInputCallResponse) GetAggregatedPayloadSize() int32 {
	if m != nil {
		return m.AggregatedPayloadSize
	}
	return 0
}

// Configuration for a particular response.
type ResponseParameters struct {
	// Desired payload sizes in responses from the server.
	// If response_type is COMPRESSABLE, this denotes the size before compression.
	Size int32 `protobuf:"varint,1,opt,name=size,proto3" json:"size,omitempty"`
	// Desired interval between consecutive responses in the response stream in
	// microseconds.
	IntervalUs           int32    `protobuf:"varint,2,opt,name=interval_us,json=intervalUs,proto3" json:"interval_us,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ResponseParameters) Reset()         { *m = ResponseParameters{} }
func (m *ResponseParameters) String() string { return proto.CompactTextString(m) }
func (*ResponseParameters) ProtoMessage()    {}
func (*ResponseParameters) Descriptor() ([]byte, []int) {
	return fileDescriptor_534063719f48d90d, []int{7}
}

func (m *ResponseParameters) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ResponseParameters.Unmarshal(m, b)
}
func (m *ResponseParameters) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ResponseParameters.Marshal(b, m, deterministic)
}
func (m *ResponseParameters) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ResponseParameters.Merge(m, src)
}
func (m *ResponseParameters) XXX_Size() int {
	return xxx_messageInfo_ResponseParameters.Size(m)
}
func (m *ResponseParameters) XXX_DiscardUnknown() {
	xxx_messageInfo_ResponseParameters.DiscardUnknown(m)
}

var xxx_messageInfo_ResponseParameters proto.InternalMessageInfo

func (m *ResponseParameters) GetSize() int32 {
	if m != nil {
		return m.Size
	}
	return 0
}

func (m *ResponseParameters) GetIntervalUs() int32 {
	if m != nil {
		return m.IntervalUs
	}
	return 0
}

// Server-streaming request.
type StreamingOutputCallRequest struct {
	// Desired payload type in the response from the server.
	// If response_type is RANDOM, the payload from each response in the stream
	// might be of different types. This is to simulate a mixed type of payload
	// stream.
	ResponseType PayloadType `protobuf:"varint,1,opt,name=response_type,json=responseType,proto3,enum=grpc.testing.PayloadType" json:"response_type,omitempty"`
	// Configuration for each expected response message.
	ResponseParameters []*ResponseParameters `protobuf:"bytes,2,rep,name=response_parameters,json=responseParameters,proto3" json:"response_parameters,omitempty"`
	// Optional input payload sent along with the request.
	Payload *Payload `protobuf:"bytes,3,opt,name=payload,proto3" json:"payload,omitempty"`
	// Whether server should return a given status
	ResponseStatus       *EchoStatus `protobuf:"bytes,7,opt,name=response_status,json=responseStatus,proto3" json:"response_status,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *StreamingOutputCallRequest) Reset()         { *m = StreamingOutputCallRequest{} }
func (m *StreamingOutputCallRequest) String() string { return proto.CompactTextString(m) }
func (*StreamingOutputCallRequest) ProtoMessage()    {}
func (*StreamingOutputCallRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_534063719f48d90d, []int{8}
}

func (m *StreamingOutputCallRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StreamingOutputCallRequest.Unmarshal(m, b)
}
func (m *StreamingOutputCallRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StreamingOutputCallRequest.Marshal(b, m, deterministic)
}
func (m *StreamingOutputCallRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StreamingOutputCallRequest.Merge(m, src)
}
func (m *StreamingOutputCallRequest) XXX_Size() int {
	return xxx_messageInfo_StreamingOutputCallRequest.Size(m)
}
func (m *StreamingOutputCallRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_StreamingOutputCallRequest.DiscardUnknown(m)
}

var xxx_messageInfo_StreamingOutputCallRequest proto.InternalMessageInfo

func (m *StreamingOutputCallRequest) GetResponseType() PayloadType {
	if m != nil {
		return m.ResponseType
	}
	return PayloadType_COMPRESSABLE
}

func (m *StreamingOutputCallRequest) GetResponseParameters() []*ResponseParameters {
	if m != nil {
		return m.ResponseParameters
	}
	return nil
}

func (m *StreamingOutputCallRequest) GetPayload() *Payload {
	if m != nil {
		return m.Payload
	}
	return nil
}

func (m *StreamingOutputCallRequest) GetResponseStatus() *EchoStatus {
	if m != nil {
		return m.ResponseStatus
	}
	return nil
}

// Server-streaming response, as configured by the request and parameters.
type StreamingOutputCallResponse struct {
	// Payload to increase response size.
	Payload              *Payload `protobuf:"bytes,1,opt,name=payload,proto3" json:"payload,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StreamingOutputCallResponse) Reset()         { *m = StreamingOutputCallResponse{} }
func (m *StreamingOutputCallResponse) String() string { return proto.CompactTextString(m) }
func (*StreamingOutputCallResponse) ProtoMessage()    {}
func (*StreamingOutputCallResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_534063719f48d90d, []int{9}
}

func (m *StreamingOutputCallResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StreamingOutputCallResponse.Unmarshal(m, b)
}
func (m *StreamingOutputCallResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StreamingOutputCallResponse.Marshal(b, m, deterministic)
}
func (m *StreamingOutputCallResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StreamingOutputCallResponse.Merge(m, src)
}
func (m *StreamingOutputCallResponse) XXX_Size() int {
	return xxx_messageInfo_StreamingOutputCallResponse.Size(m)
}
func (m *StreamingOutputCallResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_StreamingOutputCallResponse.DiscardUnknown(m)
}

var xxx_messageInfo_StreamingOutputCallResponse proto.InternalMessageInfo

func (m *StreamingOutputCallResponse) GetPayload() *Payload {
	if m != nil {
		return m.Payload
	}
	return nil
}

type LoadBalancerStatsRequest struct {
	// Request stats for the next num_rpcs sent by client.
	NumRpcs int32 `protobuf:"varint,1,opt,name=num_rpcs,json=numRpcs,proto3" json:"num_rpcs,omitempty"`
	// If num_rpcs have not completed within timeout_sec, return partial results.
	TimeoutSec           int32    `protobuf:"varint,2,opt,name=timeout_sec,json=timeoutSec,proto3" json:"timeout_sec,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *LoadBalancerStatsRequest) Reset()         { *m = LoadBalancerStatsRequest{} }
func (m *LoadBalancerStatsRequest) String() string { return proto.CompactTextString(m) }
func (*LoadBalancerStatsRequest) ProtoMessage()    {}
func (*LoadBalancerStatsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_534063719f48d90d, []int{10}
}

func (m *LoadBalancerStatsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LoadBalancerStatsRequest.Unmarshal(m, b)
}
func (m *LoadBalancerStatsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LoadBalancerStatsRequest.Marshal(b, m, deterministic)
}
func (m *LoadBalancerStatsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LoadBalancerStatsRequest.Merge(m, src)
}
func (m *LoadBalancerStatsRequest) XXX_Size() int {
	return xxx_messageInfo_LoadBalancerStatsRequest.Size(m)
}
func (m *LoadBalancerStatsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_LoadBalancerStatsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_LoadBalancerStatsRequest proto.InternalMessageInfo

func (m *LoadBalancerStatsRequest) GetNumRpcs() int32 {
	if m != nil {
		return m.NumRpcs
	}
	return 0
}

func (m *LoadBalancerStatsRequest) GetTimeoutSec() int32 {
	if m != nil {
		return m.TimeoutSec
	}
	return 0
}

type LoadBalancerStatsResponse struct {
	// The number of completed RPCs for each peer.
	RpcsByPeer map[string]int32 `protobuf:"bytes,1,rep,name=rpcs_by_peer,json=rpcsByPeer,proto3" json:"rpcs_by_peer,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3"`
	// The number of RPCs that failed to record a remote peer.
	NumFailures          int32    `protobuf:"varint,2,opt,name=num_failures,json=numFailures,proto3" json:"num_failures,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *LoadBalancerStatsResponse) Reset()         { *m = LoadBalancerStatsResponse{} }
func (m *LoadBalancerStatsResponse) String() string { return proto.CompactTextString(m) }
func (*LoadBalancerStatsResponse) ProtoMessage()    {}
func (*LoadBalancerStatsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_534063719f48d90d, []int{11}
}

func (m *LoadBalancerStatsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LoadBalancerStatsResponse.Unmarshal(m, b)
}
func (m *LoadBalancerStatsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LoadBalancerStatsResponse.Marshal(b, m, deterministic)
}
func (m *LoadBalancerStatsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LoadBalancerStatsResponse.Merge(m, src)
}
func (m *LoadBalancerStatsResponse) XXX_Size() int {
	return xxx_messageInfo_LoadBalancerStatsResponse.Size(m)
}
func (m *LoadBalancerStatsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_LoadBalancerStatsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_LoadBalancerStatsResponse proto.InternalMessageInfo

func (m *LoadBalancerStatsResponse) GetRpcsByPeer() map[string]int32 {
	if m != nil {
		return m.RpcsByPeer
	}
	return nil
}

func (m *LoadBalancerStatsResponse) GetNumFailures() int32 {
	if m != nil {
		return m.NumFailures
	}
	return 0
}

func init() {
	proto.RegisterEnum("grpc.testing.PayloadType", PayloadType_name, PayloadType_value)
	proto.RegisterEnum("grpc.testing.GrpclbRouteType", GrpclbRouteType_name, GrpclbRouteType_value)
	proto.RegisterType((*Empty)(nil), "grpc.testing.Empty")
	proto.RegisterType((*Payload)(nil), "grpc.testing.Payload")
	proto.RegisterType((*EchoStatus)(nil), "grpc.testing.EchoStatus")
	proto.RegisterType((*SimpleRequest)(nil), "grpc.testing.SimpleRequest")
	proto.RegisterType((*SimpleResponse)(nil), "grpc.testing.SimpleResponse")
	proto.RegisterType((*StreamingInputCallRequest)(nil), "grpc.testing.StreamingInputCallRequest")
	proto.RegisterType((*StreamingInputCallResponse)(nil), "grpc.testing.StreamingInputCallResponse")
	proto.RegisterType((*ResponseParameters)(nil), "grpc.testing.ResponseParameters")
	proto.RegisterType((*StreamingOutputCallRequest)(nil), "grpc.testing.StreamingOutputCallRequest")
	proto.RegisterType((*StreamingOutputCallResponse)(nil), "grpc.testing.StreamingOutputCallResponse")
	proto.RegisterType((*LoadBalancerStatsRequest)(nil), "grpc.testing.LoadBalancerStatsRequest")
	proto.RegisterType((*LoadBalancerStatsResponse)(nil), "grpc.testing.LoadBalancerStatsResponse")
	proto.RegisterMapType((map[string]int32)(nil), "grpc.testing.LoadBalancerStatsResponse.RpcsByPeerEntry")
}

func init() { proto.RegisterFile("interop/grpc_testing/test.proto", fileDescriptor_534063719f48d90d) }

var fileDescriptor_534063719f48d90d = []byte{
	// 1019 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xbc, 0x56, 0xfd, 0x6e, 0x1b, 0x45,
	0x10, 0xcf, 0x39, 0x71, 0x1c, 0x8f, 0x5d, 0xc7, 0xdd, 0xb4, 0x70, 0x71, 0x28, 0x35, 0x07, 0xa2,
	0xa6, 0xa8, 0x0e, 0x72, 0xc5, 0x87, 0x2a, 0x15, 0x14, 0x27, 0x4e, 0x88, 0xea, 0xda, 0xe6, 0x1c,
	0x83, 0xca, 0x3f, 0xa7, 0xcd, 0x79, 0x72, 0x39, 0x71, 0x5f, 0xec, 0xed, 0x45, 0xb8, 0xff, 0x20,
	0xf1, 0x08, 0xbc, 0x02, 0x8f, 0xc1, 0x8b, 0xf0, 0x38, 0x68, 0xf7, 0xee, 0xfc, 0x79, 0x51, 0x13,
	0x2a, 0xfa, 0x97, 0x77, 0xe7, 0xe3, 0x37, 0x33, 0xbf, 0x99, 0x1d, 0x1f, 0x3c, 0xb4, 0x3d, 0x8e,
	0xcc, 0x0f, 0xf6, 0x2d, 0x16, 0x98, 0x06, 0xc7, 0x90, 0xdb, 0x9e, 0xb5, 0x2f, 0x7e, 0x9b, 0x01,
	0xf3, 0xb9, 0x4f, 0xca, 0x42, 0xd1, 0x4c, 0x14, 0x5a, 0x01, 0xf2, 0x1d, 0x37, 0xe0, 0x13, 0xad,
	0x0b, 0x85, 0x01, 0x9d, 0x38, 0x3e, 0x1d, 0x93, 0x27, 0xb0, 0xc1, 0x27, 0x01, 0xaa, 0x4a, 0x5d,
	0x69, 0x54, 0x5a, 0xbb, 0xcd, 0x79, 0x87, 0x66, 0x62, 0x74, 0x36, 0x09, 0x50, 0x97, 0x66, 0x84,
	0xc0, 0xc6, 0xb9, 0x3f, 0x9e, 0xa8, 0xb9, 0xba, 0xd2, 0x28, 0xeb, 0xf2, 0xac, 0x3d, 0x03, 0xe8,
	0x98, 0x97, 0xfe, 0x90, 0x53, 0x1e, 0x85, 0xc2, 0xc2, 0xf4, 0xc7, 0x31, 0x60, 0x5e, 0x97, 0x67,
	0xa2, 0x42, 0xc1, 0xc5, 0x30, 0xa4, 0x16, 0x4a, 0xc7, 0xa2, 0x9e, 0x5e, 0xb5, 0x3f, 0xd7, 0xe1,
	0xce, 0xd0, 0x76, 0x03, 0x07, 0x75, 0xfc, 0x35, 0xc2, 0x90, 0x93, 0x6f, 0xe1, 0x0e, 0xc3, 0x30,
	0xf0, 0xbd, 0x10, 0x8d, 0x9b, 0x65, 0x56, 0x4e, 0xed, 0xc5, 0x8d, 0x7c, 0x3c, 0xe7, 0x1f, 0xda,
	0xaf, 0xe3, 0x88, 0xf9, 0x99, 0xd1, 0xd0, 0x7e, 0x8d, 0x64, 0x1f, 0x0a, 0x41, 0x8c, 0xa0, 0xae,
	0xd7, 0x95, 0x46, 0xa9, 0x75, 0x3f, 0x13, 0x5e, 0x4f, 0xad, 0x04, 0xea, 0x85, 0xed, 0x38, 0x46,
	0x14, 0x22, 0xf3, 0xa8, 0x8b, 0xea, 0x46, 0x5d, 0x69, 0x6c, 0xe9, 0x65, 0x21, 0x1c, 0x25, 0x32,
	0xd2, 0x80, 0xaa, 0x34, 0xf2, 0x69, 0xc4, 0x2f, 0x8d, 0xd0, 0xf4, 0x03, 0x54, 0xf3, 0xd2, 0xae,
	0x22, 0xe4, 0x7d, 0x21, 0x1e, 0x0a, 0x29, 0x39, 0x80, 0xed, 0x59, 0x92, 0x92, 0x37, 0xb5, 0x20,
	0xf3, 0x50, 0x17, 0xf3, 0x98, 0xf1, 0xaa, 0x57, 0xa6, 0x05, 0xc4, 0x3c, 0x7f, 0x02, 0x12, 0xd4,
	0x08, 0x91, 0x5d, 0x21, 0x33, 0xec, 0xb1, 0x5a, 0x9c, 0xa5, 0x34, 0x94, 0xc2, 0xd3, 0x31, 0x79,
	0x0a, 0xef, 0x49, 0x2b, 0x81, 0xea, 0x9c, 0x1b, 0xcc, 0x8f, 0x78, 0x42, 0x2b, 0x48, 0xeb, 0x1d,
	0xa1, 0x3d, 0x91, 0x4a, 0x5d, 0xe8, 0x04, 0x85, 0xda, 0x1f, 0x39, 0xa8, 0xa4, 0x4d, 0x89, 0x63,
	0xce, 0x13, 0xa6, 0xdc, 0x88, 0xb0, 0x1a, 0x6c, 0x4d, 0xb9, 0x8a, 0x7b, 0x3e, 0xbd, 0x93, 0x87,
	0x50, 0x9a, 0xa7, 0x68, 0x5d, 0xaa, 0xc1, 0x9f, 0xd1, 0xb3, 0x07, 0xc5, 0x59, 0x59, 0x1b, 0xb1,
	0x77, 0x98, 0x96, 0x74, 0x0a, 0x77, 0x57, 0xab, 0xc9, 0xcb, 0x21, 0x79, 0xb0, 0x98, 0xd4, 0x52,
	0x5d, 0xfa, 0xb6, 0xb5, 0x28, 0x10, 0x49, 0x5e, 0xfa, 0x21, 0x97, 0x49, 0x6e, 0xc6, 0x61, 0xd2,
	0xbb, 0xd6, 0x85, 0xdd, 0x21, 0x67, 0x48, 0x5d, 0xdb, 0xb3, 0x4e, 0xbd, 0x20, 0xe2, 0x87, 0xd4,
	0x71, 0xd2, 0x21, 0xbd, 0x2d, 0x1d, 0xda, 0x19, 0xd4, 0xb2, 0xd0, 0x12, 0x76, 0xbf, 0x82, 0xf7,
	0xa9, 0x65, 0x31, 0xb4, 0x28, 0xc7, 0xb1, 0x91, 0xf8, 0xc4, 0xd3, 0x1b, 0x3f, 0xa3, 0xfb, 0x33,
	0x75, 0x02, 0x2d, 0xc6, 0x58, 0x3b, 0x05, 0x92, 0x62, 0x0c, 0x28, 0xa3, 0x2e, 0x72, 0x64, 0xf2,
	0x05, 0xce, 0xb9, 0xca, 0xb3, 0xa0, 0x5c, 0xee, 0x8a, 0x2b, 0x2a, 0x66, 0x38, 0x79, 0x13, 0x90,
	0x8a, 0x46, 0xa1, 0xf6, 0x57, 0x6e, 0x2e, 0xc3, 0x7e, 0xc4, 0x97, 0x0a, 0x7e, 0xdb, 0x57, 0xf9,
	0x03, 0xec, 0x4c, 0xfd, 0x83, 0x69, 0xaa, 0x6a, 0xae, 0xbe, 0xde, 0x28, 0xb5, 0xea, 0x8b, 0x28,
	0xab, 0x25, 0xe9, 0x84, 0xad, 0x96, 0x79, 0xeb, 0x37, 0xfc, 0xf6, 0x8f, 0x4e, 0xeb, 0xc1, 0x5e,
	0x26, 0x49, 0xff, 0xf1, 0x95, 0x68, 0x3f, 0x82, 0xda, 0xf5, 0xe9, 0xb8, 0x4d, 0x1d, 0xea, 0x99,
	0xc8, 0x44, 0x94, 0x30, 0xa5, 0x7c, 0x17, 0xb6, 0xbc, 0xc8, 0x35, 0x58, 0x60, 0x86, 0x49, 0x2b,
	0x0b, 0x5e, 0xe4, 0xea, 0x81, 0x19, 0x8a, 0x6e, 0x72, 0xdb, 0x45, 0x3f, 0xe2, 0x46, 0x88, 0x66,
	0xda, 0xcd, 0x44, 0x34, 0x44, 0x53, 0xfb, 0x47, 0x81, 0xdd, 0x0c, 0xe0, 0x24, 0xcd, 0x57, 0x50,
	0x16, 0xa8, 0xc6, 0xf9, 0xc4, 0x08, 0x10, 0x99, 0xaa, 0xc8, 0x2e, 0x7c, 0xbd, 0x98, 0xeb, 0xb5,
	0xee, 0x4d, 0x91, 0x42, 0x7b, 0x32, 0x40, 0x64, 0x1d, 0x8f, 0xb3, 0x89, 0x0e, 0x6c, 0x2a, 0x20,
	0x1f, 0x41, 0x59, 0x24, 0x7d, 0x41, 0x6d, 0x27, 0x62, 0x98, 0x0e, 0x5a, 0xc9, 0x8b, 0xdc, 0xe3,
	0x44, 0x54, 0x7b, 0x0e, 0xdb, 0x4b, 0x08, 0xa4, 0x0a, 0xeb, 0xbf, 0xe0, 0x44, 0x56, 0x59, 0xd4,
	0xc5, 0x91, 0xdc, 0x83, 0xfc, 0x15, 0x75, 0xa2, 0x74, 0x7b, 0xc7, 0x97, 0x67, 0xb9, 0x6f, 0x94,
	0xc7, 0xdf, 0x41, 0x69, 0x6e, 0xcc, 0x48, 0x15, 0xca, 0x87, 0xfd, 0x97, 0x03, 0xbd, 0x33, 0x1c,
	0x1e, 0xb4, 0xbb, 0x9d, 0xea, 0x1a, 0x21, 0x50, 0x19, 0xf5, 0x16, 0x64, 0x0a, 0x01, 0xd8, 0xd4,
	0x0f, 0x7a, 0x47, 0xfd, 0x97, 0xd5, 0xdc, 0x63, 0x1f, 0xb6, 0x97, 0x16, 0x03, 0x79, 0x00, 0xbb,
	0x27, 0xfa, 0xe0, 0xb0, 0xdb, 0x36, 0xf4, 0xfe, 0xe8, 0xac, 0x63, 0x9c, 0xbd, 0x1a, 0x74, 0x8c,
	0x51, 0xef, 0x45, 0xaf, 0xff, 0x53, 0xaf, 0xba, 0x46, 0x3e, 0x84, 0xda, 0xaa, 0xfa, 0xf8, 0xa0,
	0xdb, 0x6d, 0x1f, 0x1c, 0xbe, 0xa8, 0x2a, 0xd9, 0xee, 0x42, 0xd7, 0xe9, 0x1d, 0x55, 0x73, 0xad,
	0xbf, 0x37, 0xa0, 0x74, 0x86, 0x21, 0x17, 0x4b, 0xd9, 0x36, 0x91, 0x7c, 0x09, 0x45, 0xf9, 0x37,
	0x2c, 0x46, 0x87, 0xec, 0x2c, 0xcd, 0x9e, 0x50, 0xd4, 0xb2, 0x84, 0xe4, 0x18, 0x8a, 0x23, 0x8f,
	0xb2, 0xd8, 0x6d, 0x6f, 0xd1, 0x62, 0xe1, 0x2f, 0xb4, 0xf6, 0x41, 0xb6, 0x32, 0xe9, 0xbe, 0x03,
	0x3b, 0x19, 0x33, 0x4c, 0x1a, 0x4b, 0x4e, 0xd7, 0xee, 0x82, 0xda, 0x67, 0x37, 0xb0, 0x8c, 0x63,
	0x7d, 0xa1, 0x10, 0x1b, 0xc8, 0xea, 0xe2, 0x23, 0x8f, 0xae, 0x81, 0x58, 0x5e, 0xb4, 0xb5, 0xc6,
	0x9b, 0x0d, 0xe3, 0x50, 0x0d, 0x11, 0xaa, 0x72, 0x1c, 0x39, 0xce, 0x51, 0x14, 0x38, 0xf8, 0xdb,
	0xff, 0x56, 0x53, 0x43, 0x91, 0x55, 0x55, 0xbe, 0xa7, 0xce, 0xc5, 0x3b, 0x08, 0xd5, 0x1a, 0xc1,
	0xbd, 0x91, 0x27, 0x3b, 0xe8, 0xa2, 0xc7, 0x71, 0x9c, 0x4e, 0xd1, 0x73, 0xb8, 0xbb, 0x20, 0xbf,
	0xdd, 0x34, 0xb5, 0x7e, 0xcf, 0xd8, 0x3c, 0x29, 0xb4, 0x09, 0x95, 0x13, 0xe4, 0x87, 0x8e, 0x8d,
	0x1e, 0x97, 0x0a, 0xf2, 0xe9, 0x1b, 0x77, 0x43, 0x5c, 0xdb, 0xa3, 0x1b, 0xee, 0x10, 0x6d, 0xad,
	0xfd, 0xe4, 0xe7, 0xcf, 0x2d, 0xdf, 0xb7, 0x1c, 0x6c, 0x5a, 0xbe, 0x43, 0x3d, 0xab, 0xe9, 0x33,
	0x4b, 0x7e, 0xc7, 0xee, 0x67, 0x7d, 0xd4, 0x9e, 0x6f, 0xca, 0x0f, 0xda, 0xa7, 0xff, 0x06, 0x00,
	0x00, 0xff, 0xff, 0xaa, 0x43, 0x4c, 0xeb, 0xf3, 0x0a, 0x00, 0x00,
}
