// Copyright 2020 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.22.0
// 	protoc        v3.11.2
// source: google/cloud/asset/v1p4beta1/asset_service.proto

package asset

import (
	context "context"
	reflect "reflect"
	sync "sync"

	proto "github.com/golang/protobuf/proto"
	duration "github.com/golang/protobuf/ptypes/duration"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	_ "google.golang.org/genproto/googleapis/iam/v1"
	longrunning "google.golang.org/genproto/googleapis/longrunning"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// IAM policy analysis query message.
type IamPolicyAnalysisQuery struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The relative name of the root asset. Only resources and IAM policies within
	// the parent will be analyzed. This can only be an organization number (such
	// as "organizations/123") or a folder number (such as "folders/123").
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. Specifies a resource for analysis. Leaving it empty means ANY.
	ResourceSelector *IamPolicyAnalysisQuery_ResourceSelector `protobuf:"bytes,2,opt,name=resource_selector,json=resourceSelector,proto3" json:"resource_selector,omitempty"`
	// Optional. Specifies an identity for analysis. Leaving it empty means ANY.
	IdentitySelector *IamPolicyAnalysisQuery_IdentitySelector `protobuf:"bytes,3,opt,name=identity_selector,json=identitySelector,proto3" json:"identity_selector,omitempty"`
	// Optional. Specifies roles or permissions for analysis. Leaving it empty
	// means ANY.
	AccessSelector *IamPolicyAnalysisQuery_AccessSelector `protobuf:"bytes,4,opt,name=access_selector,json=accessSelector,proto3" json:"access_selector,omitempty"`
}

func (x *IamPolicyAnalysisQuery) Reset() {
	*x = IamPolicyAnalysisQuery{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1p4beta1_asset_service_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IamPolicyAnalysisQuery) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IamPolicyAnalysisQuery) ProtoMessage() {}

func (x *IamPolicyAnalysisQuery) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1p4beta1_asset_service_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IamPolicyAnalysisQuery.ProtoReflect.Descriptor instead.
func (*IamPolicyAnalysisQuery) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1p4beta1_asset_service_proto_rawDescGZIP(), []int{0}
}

func (x *IamPolicyAnalysisQuery) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *IamPolicyAnalysisQuery) GetResourceSelector() *IamPolicyAnalysisQuery_ResourceSelector {
	if x != nil {
		return x.ResourceSelector
	}
	return nil
}

func (x *IamPolicyAnalysisQuery) GetIdentitySelector() *IamPolicyAnalysisQuery_IdentitySelector {
	if x != nil {
		return x.IdentitySelector
	}
	return nil
}

func (x *IamPolicyAnalysisQuery) GetAccessSelector() *IamPolicyAnalysisQuery_AccessSelector {
	if x != nil {
		return x.AccessSelector
	}
	return nil
}

// A request message for [AssetService.AnalyzeIamPolicy][google.cloud.asset.v1p4beta1.AssetService.AnalyzeIamPolicy].
type AnalyzeIamPolicyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The request query.
	AnalysisQuery *IamPolicyAnalysisQuery `protobuf:"bytes,1,opt,name=analysis_query,json=analysisQuery,proto3" json:"analysis_query,omitempty"`
	// Optional. The request options.
	Options *AnalyzeIamPolicyRequest_Options `protobuf:"bytes,2,opt,name=options,proto3" json:"options,omitempty"`
}

func (x *AnalyzeIamPolicyRequest) Reset() {
	*x = AnalyzeIamPolicyRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1p4beta1_asset_service_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnalyzeIamPolicyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnalyzeIamPolicyRequest) ProtoMessage() {}

func (x *AnalyzeIamPolicyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1p4beta1_asset_service_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnalyzeIamPolicyRequest.ProtoReflect.Descriptor instead.
func (*AnalyzeIamPolicyRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1p4beta1_asset_service_proto_rawDescGZIP(), []int{1}
}

func (x *AnalyzeIamPolicyRequest) GetAnalysisQuery() *IamPolicyAnalysisQuery {
	if x != nil {
		return x.AnalysisQuery
	}
	return nil
}

func (x *AnalyzeIamPolicyRequest) GetOptions() *AnalyzeIamPolicyRequest_Options {
	if x != nil {
		return x.Options
	}
	return nil
}

// A response message for [AssetService.AnalyzeIamPolicy][google.cloud.asset.v1p4beta1.AssetService.AnalyzeIamPolicy].
type AnalyzeIamPolicyResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The main analysis that matches the original request.
	MainAnalysis *AnalyzeIamPolicyResponse_IamPolicyAnalysis `protobuf:"bytes,1,opt,name=main_analysis,json=mainAnalysis,proto3" json:"main_analysis,omitempty"`
	// The service account impersonation analysis if
	// [AnalyzeIamPolicyRequest.analyze_service_account_impersonation][] is
	// enabled.
	ServiceAccountImpersonationAnalysis []*AnalyzeIamPolicyResponse_IamPolicyAnalysis `protobuf:"bytes,2,rep,name=service_account_impersonation_analysis,json=serviceAccountImpersonationAnalysis,proto3" json:"service_account_impersonation_analysis,omitempty"`
	// Represents whether all entries in the [main_analysis][google.cloud.asset.v1p4beta1.AnalyzeIamPolicyResponse.main_analysis] and
	// [service_account_impersonation_analysis][google.cloud.asset.v1p4beta1.AnalyzeIamPolicyResponse.service_account_impersonation_analysis] have been fully explored to
	// answer the query in the request.
	FullyExplored bool `protobuf:"varint,3,opt,name=fully_explored,json=fullyExplored,proto3" json:"fully_explored,omitempty"`
	// A list of non-critical errors happened during the request handling to
	// explain why `fully_explored` is false, or empty if no error happened.
	NonCriticalErrors []*IamPolicyAnalysisResult_AnalysisState `protobuf:"bytes,4,rep,name=non_critical_errors,json=nonCriticalErrors,proto3" json:"non_critical_errors,omitempty"`
}

func (x *AnalyzeIamPolicyResponse) Reset() {
	*x = AnalyzeIamPolicyResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1p4beta1_asset_service_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnalyzeIamPolicyResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnalyzeIamPolicyResponse) ProtoMessage() {}

func (x *AnalyzeIamPolicyResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1p4beta1_asset_service_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnalyzeIamPolicyResponse.ProtoReflect.Descriptor instead.
func (*AnalyzeIamPolicyResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1p4beta1_asset_service_proto_rawDescGZIP(), []int{2}
}

func (x *AnalyzeIamPolicyResponse) GetMainAnalysis() *AnalyzeIamPolicyResponse_IamPolicyAnalysis {
	if x != nil {
		return x.MainAnalysis
	}
	return nil
}

func (x *AnalyzeIamPolicyResponse) GetServiceAccountImpersonationAnalysis() []*AnalyzeIamPolicyResponse_IamPolicyAnalysis {
	if x != nil {
		return x.ServiceAccountImpersonationAnalysis
	}
	return nil
}

func (x *AnalyzeIamPolicyResponse) GetFullyExplored() bool {
	if x != nil {
		return x.FullyExplored
	}
	return false
}

func (x *AnalyzeIamPolicyResponse) GetNonCriticalErrors() []*IamPolicyAnalysisResult_AnalysisState {
	if x != nil {
		return x.NonCriticalErrors
	}
	return nil
}

// Output configuration for export IAM policy analysis destination.
type IamPolicyAnalysisOutputConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// IAM policy analysis export destination.
	//
	// Types that are assignable to Destination:
	//	*IamPolicyAnalysisOutputConfig_GcsDestination_
	Destination isIamPolicyAnalysisOutputConfig_Destination `protobuf_oneof:"destination"`
}

func (x *IamPolicyAnalysisOutputConfig) Reset() {
	*x = IamPolicyAnalysisOutputConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1p4beta1_asset_service_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IamPolicyAnalysisOutputConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IamPolicyAnalysisOutputConfig) ProtoMessage() {}

func (x *IamPolicyAnalysisOutputConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1p4beta1_asset_service_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IamPolicyAnalysisOutputConfig.ProtoReflect.Descriptor instead.
func (*IamPolicyAnalysisOutputConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1p4beta1_asset_service_proto_rawDescGZIP(), []int{3}
}

func (m *IamPolicyAnalysisOutputConfig) GetDestination() isIamPolicyAnalysisOutputConfig_Destination {
	if m != nil {
		return m.Destination
	}
	return nil
}

func (x *IamPolicyAnalysisOutputConfig) GetGcsDestination() *IamPolicyAnalysisOutputConfig_GcsDestination {
	if x, ok := x.GetDestination().(*IamPolicyAnalysisOutputConfig_GcsDestination_); ok {
		return x.GcsDestination
	}
	return nil
}

type isIamPolicyAnalysisOutputConfig_Destination interface {
	isIamPolicyAnalysisOutputConfig_Destination()
}

type IamPolicyAnalysisOutputConfig_GcsDestination_ struct {
	// Destination on Cloud Storage.
	GcsDestination *IamPolicyAnalysisOutputConfig_GcsDestination `protobuf:"bytes,1,opt,name=gcs_destination,json=gcsDestination,proto3,oneof"`
}

func (*IamPolicyAnalysisOutputConfig_GcsDestination_) isIamPolicyAnalysisOutputConfig_Destination() {}

// A request message for [AssetService.ExportIamPolicyAnalysis][google.cloud.asset.v1p4beta1.AssetService.ExportIamPolicyAnalysis].
type ExportIamPolicyAnalysisRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The request query.
	AnalysisQuery *IamPolicyAnalysisQuery `protobuf:"bytes,1,opt,name=analysis_query,json=analysisQuery,proto3" json:"analysis_query,omitempty"`
	// Optional. The request options.
	Options *ExportIamPolicyAnalysisRequest_Options `protobuf:"bytes,2,opt,name=options,proto3" json:"options,omitempty"`
	// Required. Output configuration indicating where the results will be output to.
	OutputConfig *IamPolicyAnalysisOutputConfig `protobuf:"bytes,3,opt,name=output_config,json=outputConfig,proto3" json:"output_config,omitempty"`
}

func (x *ExportIamPolicyAnalysisRequest) Reset() {
	*x = ExportIamPolicyAnalysisRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1p4beta1_asset_service_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExportIamPolicyAnalysisRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExportIamPolicyAnalysisRequest) ProtoMessage() {}

func (x *ExportIamPolicyAnalysisRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1p4beta1_asset_service_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExportIamPolicyAnalysisRequest.ProtoReflect.Descriptor instead.
func (*ExportIamPolicyAnalysisRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1p4beta1_asset_service_proto_rawDescGZIP(), []int{4}
}

func (x *ExportIamPolicyAnalysisRequest) GetAnalysisQuery() *IamPolicyAnalysisQuery {
	if x != nil {
		return x.AnalysisQuery
	}
	return nil
}

func (x *ExportIamPolicyAnalysisRequest) GetOptions() *ExportIamPolicyAnalysisRequest_Options {
	if x != nil {
		return x.Options
	}
	return nil
}

func (x *ExportIamPolicyAnalysisRequest) GetOutputConfig() *IamPolicyAnalysisOutputConfig {
	if x != nil {
		return x.OutputConfig
	}
	return nil
}

// The export IAM policy analysis response. This message is returned by the
// [google.longrunning.Operations.GetOperation][] method in the returned
// [google.longrunning.Operation.response][] field.
type ExportIamPolicyAnalysisResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output configuration indicating where the results were output to.
	OutputConfig *IamPolicyAnalysisOutputConfig `protobuf:"bytes,1,opt,name=output_config,json=outputConfig,proto3" json:"output_config,omitempty"`
}

func (x *ExportIamPolicyAnalysisResponse) Reset() {
	*x = ExportIamPolicyAnalysisResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1p4beta1_asset_service_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExportIamPolicyAnalysisResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExportIamPolicyAnalysisResponse) ProtoMessage() {}

func (x *ExportIamPolicyAnalysisResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1p4beta1_asset_service_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExportIamPolicyAnalysisResponse.ProtoReflect.Descriptor instead.
func (*ExportIamPolicyAnalysisResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1p4beta1_asset_service_proto_rawDescGZIP(), []int{5}
}

func (x *ExportIamPolicyAnalysisResponse) GetOutputConfig() *IamPolicyAnalysisOutputConfig {
	if x != nil {
		return x.OutputConfig
	}
	return nil
}

// Specifies the resource to analyze for access policies, which may be set
// directly on the resource, or on ancestors such as organizations, folders or
// projects. At least one of [ResourceSelector][google.cloud.asset.v1p4beta1.IamPolicyAnalysisQuery.ResourceSelector], [IdentitySelector][google.cloud.asset.v1p4beta1.IamPolicyAnalysisQuery.IdentitySelector] or
// [AccessSelector][google.cloud.asset.v1p4beta1.IamPolicyAnalysisQuery.AccessSelector] must be specified in a request.
type IamPolicyAnalysisQuery_ResourceSelector struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The [full resource
	// name](https://cloud.google.com/apis/design/resource_names#full_resource_name)
	// .
	FullResourceName string `protobuf:"bytes,1,opt,name=full_resource_name,json=fullResourceName,proto3" json:"full_resource_name,omitempty"`
}

func (x *IamPolicyAnalysisQuery_ResourceSelector) Reset() {
	*x = IamPolicyAnalysisQuery_ResourceSelector{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1p4beta1_asset_service_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IamPolicyAnalysisQuery_ResourceSelector) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IamPolicyAnalysisQuery_ResourceSelector) ProtoMessage() {}

func (x *IamPolicyAnalysisQuery_ResourceSelector) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1p4beta1_asset_service_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IamPolicyAnalysisQuery_ResourceSelector.ProtoReflect.Descriptor instead.
func (*IamPolicyAnalysisQuery_ResourceSelector) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1p4beta1_asset_service_proto_rawDescGZIP(), []int{0, 0}
}

func (x *IamPolicyAnalysisQuery_ResourceSelector) GetFullResourceName() string {
	if x != nil {
		return x.FullResourceName
	}
	return ""
}

// Specifies an identity for which to determine resource access, based on
// roles assigned either directly to them or to the groups they belong to,
// directly or indirectly.
type IamPolicyAnalysisQuery_IdentitySelector struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The identity appear in the form of members in
	// [IAM policy
	// binding](https://cloud.google.com/iam/reference/rest/v1/Binding).
	Identity string `protobuf:"bytes,1,opt,name=identity,proto3" json:"identity,omitempty"`
}

func (x *IamPolicyAnalysisQuery_IdentitySelector) Reset() {
	*x = IamPolicyAnalysisQuery_IdentitySelector{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1p4beta1_asset_service_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IamPolicyAnalysisQuery_IdentitySelector) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IamPolicyAnalysisQuery_IdentitySelector) ProtoMessage() {}

func (x *IamPolicyAnalysisQuery_IdentitySelector) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1p4beta1_asset_service_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IamPolicyAnalysisQuery_IdentitySelector.ProtoReflect.Descriptor instead.
func (*IamPolicyAnalysisQuery_IdentitySelector) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1p4beta1_asset_service_proto_rawDescGZIP(), []int{0, 1}
}

func (x *IamPolicyAnalysisQuery_IdentitySelector) GetIdentity() string {
	if x != nil {
		return x.Identity
	}
	return ""
}

// Specifies roles and/or permissions to analyze, to determine both the
// identities possessing them and the resources they control. If multiple
// values are specified, results will include identities and resources
// matching any of them.
type IamPolicyAnalysisQuery_AccessSelector struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The roles to appear in result.
	Roles []string `protobuf:"bytes,1,rep,name=roles,proto3" json:"roles,omitempty"`
	// Optional. The permissions to appear in result.
	Permissions []string `protobuf:"bytes,2,rep,name=permissions,proto3" json:"permissions,omitempty"`
}

func (x *IamPolicyAnalysisQuery_AccessSelector) Reset() {
	*x = IamPolicyAnalysisQuery_AccessSelector{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1p4beta1_asset_service_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IamPolicyAnalysisQuery_AccessSelector) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IamPolicyAnalysisQuery_AccessSelector) ProtoMessage() {}

func (x *IamPolicyAnalysisQuery_AccessSelector) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1p4beta1_asset_service_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IamPolicyAnalysisQuery_AccessSelector.ProtoReflect.Descriptor instead.
func (*IamPolicyAnalysisQuery_AccessSelector) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1p4beta1_asset_service_proto_rawDescGZIP(), []int{0, 2}
}

func (x *IamPolicyAnalysisQuery_AccessSelector) GetRoles() []string {
	if x != nil {
		return x.Roles
	}
	return nil
}

func (x *IamPolicyAnalysisQuery_AccessSelector) GetPermissions() []string {
	if x != nil {
		return x.Permissions
	}
	return nil
}

// Contains request options.
type AnalyzeIamPolicyRequest_Options struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. If true, the identities section of the result will expand any
	// Google groups appearing in an IAM policy binding.
	//
	// If [identity_selector][] is specified, the identity in the result will
	// be determined by the selector, and this flag will have no effect.
	//
	// Default is false.
	ExpandGroups bool `protobuf:"varint,1,opt,name=expand_groups,json=expandGroups,proto3" json:"expand_groups,omitempty"`
	// Optional. If true, the access section of result will expand any roles
	// appearing in IAM policy bindings to include their permissions.
	//
	// If [access_selector][] is specified, the access section of the result
	// will be determined by the selector, and this flag will have no effect.
	//
	// Default is false.
	ExpandRoles bool `protobuf:"varint,2,opt,name=expand_roles,json=expandRoles,proto3" json:"expand_roles,omitempty"`
	// Optional. If true, the resource section of the result will expand any
	// resource attached to an IAM policy to include resources lower in the
	// resource hierarchy.
	//
	// For example, if the request analyzes for which resources user A has
	// permission P, and the results include an IAM policy with P on a GCP
	// folder, the results will also include resources in that folder with
	// permission P.
	//
	// If [resource_selector][] is specified, the resource section of the result
	// will be determined by the selector, and this flag will have no effect.
	// Default is false.
	ExpandResources bool `protobuf:"varint,3,opt,name=expand_resources,json=expandResources,proto3" json:"expand_resources,omitempty"`
	// Optional. If true, the result will output resource edges, starting
	// from the policy attached resource, to any expanded resources.
	// Default is false.
	OutputResourceEdges bool `protobuf:"varint,4,opt,name=output_resource_edges,json=outputResourceEdges,proto3" json:"output_resource_edges,omitempty"`
	// Optional. If true, the result will output group identity edges, starting
	// from the binding's group members, to any expanded identities.
	// Default is false.
	OutputGroupEdges bool `protobuf:"varint,5,opt,name=output_group_edges,json=outputGroupEdges,proto3" json:"output_group_edges,omitempty"`
	// Optional. If true, the response will include access analysis from identities to
	// resources via service account impersonation. This is a very expensive
	// operation, because many derived queries will be executed. We highly
	// recommend you use ExportIamPolicyAnalysis rpc instead.
	//
	// For example, if the request analyzes for which resources user A has
	// permission P, and there's an IAM policy states user A has
	// iam.serviceAccounts.getAccessToken permission to a service account SA,
	// and there's another IAM policy states service account SA has permission P
	// to a GCP folder F, then user A potentially has access to the GCP folder
	// F. And those advanced analysis results will be included in
	// [AnalyzeIamPolicyResponse.service_account_impersonation_analysis][google.cloud.asset.v1p4beta1.AnalyzeIamPolicyResponse.service_account_impersonation_analysis].
	//
	// Another example, if the request analyzes for who has
	// permission P to a GCP folder F, and there's an IAM policy states user A
	// has iam.serviceAccounts.actAs permission to a service account SA, and
	// there's another IAM policy states service account SA has permission P to
	// the GCP folder F, then user A potentially has access to the GCP folder
	// F. And those advanced analysis results will be included in
	// [AnalyzeIamPolicyResponse.service_account_impersonation_analysis][google.cloud.asset.v1p4beta1.AnalyzeIamPolicyResponse.service_account_impersonation_analysis].
	//
	// Default is false.
	AnalyzeServiceAccountImpersonation bool `protobuf:"varint,6,opt,name=analyze_service_account_impersonation,json=analyzeServiceAccountImpersonation,proto3" json:"analyze_service_account_impersonation,omitempty"`
	// Optional. Amount of time executable has to complete.  See JSON representation of
	// [Duration](https://developers.google.com/protocol-buffers/docs/proto3#json).
	//
	// If this field is set with a value less than the RPC deadline, and the
	// execution of your query hasn't finished in the specified
	// execution timeout,  you will get a response with partial result.
	// Otherwise, your query's execution will continue until the RPC deadline.
	// If it's not finished until then, you will get a  DEADLINE_EXCEEDED error.
	//
	// Default is empty.
	ExecutionTimeout *duration.Duration `protobuf:"bytes,7,opt,name=execution_timeout,json=executionTimeout,proto3" json:"execution_timeout,omitempty"`
}

func (x *AnalyzeIamPolicyRequest_Options) Reset() {
	*x = AnalyzeIamPolicyRequest_Options{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1p4beta1_asset_service_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnalyzeIamPolicyRequest_Options) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnalyzeIamPolicyRequest_Options) ProtoMessage() {}

func (x *AnalyzeIamPolicyRequest_Options) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1p4beta1_asset_service_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnalyzeIamPolicyRequest_Options.ProtoReflect.Descriptor instead.
func (*AnalyzeIamPolicyRequest_Options) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1p4beta1_asset_service_proto_rawDescGZIP(), []int{1, 0}
}

func (x *AnalyzeIamPolicyRequest_Options) GetExpandGroups() bool {
	if x != nil {
		return x.ExpandGroups
	}
	return false
}

func (x *AnalyzeIamPolicyRequest_Options) GetExpandRoles() bool {
	if x != nil {
		return x.ExpandRoles
	}
	return false
}

func (x *AnalyzeIamPolicyRequest_Options) GetExpandResources() bool {
	if x != nil {
		return x.ExpandResources
	}
	return false
}

func (x *AnalyzeIamPolicyRequest_Options) GetOutputResourceEdges() bool {
	if x != nil {
		return x.OutputResourceEdges
	}
	return false
}

func (x *AnalyzeIamPolicyRequest_Options) GetOutputGroupEdges() bool {
	if x != nil {
		return x.OutputGroupEdges
	}
	return false
}

func (x *AnalyzeIamPolicyRequest_Options) GetAnalyzeServiceAccountImpersonation() bool {
	if x != nil {
		return x.AnalyzeServiceAccountImpersonation
	}
	return false
}

func (x *AnalyzeIamPolicyRequest_Options) GetExecutionTimeout() *duration.Duration {
	if x != nil {
		return x.ExecutionTimeout
	}
	return nil
}

// An analysis message to group the query and results.
type AnalyzeIamPolicyResponse_IamPolicyAnalysis struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The analysis query.
	AnalysisQuery *IamPolicyAnalysisQuery `protobuf:"bytes,1,opt,name=analysis_query,json=analysisQuery,proto3" json:"analysis_query,omitempty"`
	// A list of [IamPolicyAnalysisResult][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult] that matches the analysis query, or
	// empty if no result is found.
	AnalysisResults []*IamPolicyAnalysisResult `protobuf:"bytes,2,rep,name=analysis_results,json=analysisResults,proto3" json:"analysis_results,omitempty"`
	// Represents whether all entries in the [analysis_results][google.cloud.asset.v1p4beta1.AnalyzeIamPolicyResponse.IamPolicyAnalysis.analysis_results] have been
	// fully explored to answer the query.
	FullyExplored bool `protobuf:"varint,3,opt,name=fully_explored,json=fullyExplored,proto3" json:"fully_explored,omitempty"`
}

func (x *AnalyzeIamPolicyResponse_IamPolicyAnalysis) Reset() {
	*x = AnalyzeIamPolicyResponse_IamPolicyAnalysis{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1p4beta1_asset_service_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AnalyzeIamPolicyResponse_IamPolicyAnalysis) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AnalyzeIamPolicyResponse_IamPolicyAnalysis) ProtoMessage() {}

func (x *AnalyzeIamPolicyResponse_IamPolicyAnalysis) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1p4beta1_asset_service_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AnalyzeIamPolicyResponse_IamPolicyAnalysis.ProtoReflect.Descriptor instead.
func (*AnalyzeIamPolicyResponse_IamPolicyAnalysis) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1p4beta1_asset_service_proto_rawDescGZIP(), []int{2, 0}
}

func (x *AnalyzeIamPolicyResponse_IamPolicyAnalysis) GetAnalysisQuery() *IamPolicyAnalysisQuery {
	if x != nil {
		return x.AnalysisQuery
	}
	return nil
}

func (x *AnalyzeIamPolicyResponse_IamPolicyAnalysis) GetAnalysisResults() []*IamPolicyAnalysisResult {
	if x != nil {
		return x.AnalysisResults
	}
	return nil
}

func (x *AnalyzeIamPolicyResponse_IamPolicyAnalysis) GetFullyExplored() bool {
	if x != nil {
		return x.FullyExplored
	}
	return false
}

// A Cloud Storage location.
type IamPolicyAnalysisOutputConfig_GcsDestination struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The uri of the Cloud Storage object. It's the same uri that is used by
	// gsutil. For example: "gs://bucket_name/object_name". See [Viewing and
	// Editing Object
	// Metadata](https://cloud.google.com/storage/docs/viewing-editing-metadata)
	// for more information.
	Uri string `protobuf:"bytes,1,opt,name=uri,proto3" json:"uri,omitempty"`
}

func (x *IamPolicyAnalysisOutputConfig_GcsDestination) Reset() {
	*x = IamPolicyAnalysisOutputConfig_GcsDestination{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1p4beta1_asset_service_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *IamPolicyAnalysisOutputConfig_GcsDestination) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*IamPolicyAnalysisOutputConfig_GcsDestination) ProtoMessage() {}

func (x *IamPolicyAnalysisOutputConfig_GcsDestination) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1p4beta1_asset_service_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use IamPolicyAnalysisOutputConfig_GcsDestination.ProtoReflect.Descriptor instead.
func (*IamPolicyAnalysisOutputConfig_GcsDestination) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1p4beta1_asset_service_proto_rawDescGZIP(), []int{3, 0}
}

func (x *IamPolicyAnalysisOutputConfig_GcsDestination) GetUri() string {
	if x != nil {
		return x.Uri
	}
	return ""
}

// Contains request options.
type ExportIamPolicyAnalysisRequest_Options struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. If true, the identities section of the result will expand any
	// Google groups appearing in an IAM policy binding.
	//
	// If [identity_selector][] is specified, the identity in the result will
	// be determined by the selector, and this flag will have no effect.
	//
	// Default is false.
	ExpandGroups bool `protobuf:"varint,1,opt,name=expand_groups,json=expandGroups,proto3" json:"expand_groups,omitempty"`
	// Optional. If true, the access section of result will expand any roles
	// appearing in IAM policy bindings to include their permissions.
	//
	// If [access_selector][] is specified, the access section of the result
	// will be determined by the selector, and this flag will have no effect.
	//
	// Default is false.
	ExpandRoles bool `protobuf:"varint,2,opt,name=expand_roles,json=expandRoles,proto3" json:"expand_roles,omitempty"`
	// Optional. If true, the resource section of the result will expand any
	// resource attached to an IAM policy to include resources lower in the
	// resource hierarchy.
	//
	// For example, if the request analyzes for which resources user A has
	// permission P, and the results include an IAM policy with P on a GCP
	// folder, the results will also include resources in that folder with
	// permission P.
	//
	// If [resource_selector][] is specified, the resource section of the result
	// will be determined by the selector, and this flag will have no effect.
	// Default is false.
	ExpandResources bool `protobuf:"varint,3,opt,name=expand_resources,json=expandResources,proto3" json:"expand_resources,omitempty"`
	// Optional. If true, the result will output resource edges, starting
	// from the policy attached resource, to any expanded resources.
	// Default is false.
	OutputResourceEdges bool `protobuf:"varint,4,opt,name=output_resource_edges,json=outputResourceEdges,proto3" json:"output_resource_edges,omitempty"`
	// Optional. If true, the result will output group identity edges, starting
	// from the binding's group members, to any expanded identities.
	// Default is false.
	OutputGroupEdges bool `protobuf:"varint,5,opt,name=output_group_edges,json=outputGroupEdges,proto3" json:"output_group_edges,omitempty"`
	// Optional. If true, the response will include access analysis from identities to
	// resources via service account impersonation. This is a very expensive
	// operation, because many derived queries will be executed.
	//
	// For example, if the request analyzes for which resources user A has
	// permission P, and there's an IAM policy states user A has
	// iam.serviceAccounts.getAccessToken permission to a service account SA,
	// and there's another IAM policy states service account SA has permission P
	// to a GCP folder F, then user A potentially has access to the GCP folder
	// F. And those advanced analysis results will be included in
	// [AnalyzeIamPolicyResponse.service_account_impersonation_analysis][google.cloud.asset.v1p4beta1.AnalyzeIamPolicyResponse.service_account_impersonation_analysis].
	//
	// Another example, if the request analyzes for who has
	// permission P to a GCP folder F, and there's an IAM policy states user A
	// has iam.serviceAccounts.actAs permission to a service account SA, and
	// there's another IAM policy states service account SA has permission P to
	// the GCP folder F, then user A potentially has access to the GCP folder
	// F. And those advanced analysis results will be included in
	// [AnalyzeIamPolicyResponse.service_account_impersonation_analysis][google.cloud.asset.v1p4beta1.AnalyzeIamPolicyResponse.service_account_impersonation_analysis].
	//
	// Default is false.
	AnalyzeServiceAccountImpersonation bool `protobuf:"varint,6,opt,name=analyze_service_account_impersonation,json=analyzeServiceAccountImpersonation,proto3" json:"analyze_service_account_impersonation,omitempty"`
}

func (x *ExportIamPolicyAnalysisRequest_Options) Reset() {
	*x = ExportIamPolicyAnalysisRequest_Options{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_asset_v1p4beta1_asset_service_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExportIamPolicyAnalysisRequest_Options) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExportIamPolicyAnalysisRequest_Options) ProtoMessage() {}

func (x *ExportIamPolicyAnalysisRequest_Options) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_asset_v1p4beta1_asset_service_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExportIamPolicyAnalysisRequest_Options.ProtoReflect.Descriptor instead.
func (*ExportIamPolicyAnalysisRequest_Options) Descriptor() ([]byte, []int) {
	return file_google_cloud_asset_v1p4beta1_asset_service_proto_rawDescGZIP(), []int{4, 0}
}

func (x *ExportIamPolicyAnalysisRequest_Options) GetExpandGroups() bool {
	if x != nil {
		return x.ExpandGroups
	}
	return false
}

func (x *ExportIamPolicyAnalysisRequest_Options) GetExpandRoles() bool {
	if x != nil {
		return x.ExpandRoles
	}
	return false
}

func (x *ExportIamPolicyAnalysisRequest_Options) GetExpandResources() bool {
	if x != nil {
		return x.ExpandResources
	}
	return false
}

func (x *ExportIamPolicyAnalysisRequest_Options) GetOutputResourceEdges() bool {
	if x != nil {
		return x.OutputResourceEdges
	}
	return false
}

func (x *ExportIamPolicyAnalysisRequest_Options) GetOutputGroupEdges() bool {
	if x != nil {
		return x.OutputGroupEdges
	}
	return false
}

func (x *ExportIamPolicyAnalysisRequest_Options) GetAnalyzeServiceAccountImpersonation() bool {
	if x != nil {
		return x.AnalyzeServiceAccountImpersonation
	}
	return false
}

var File_google_cloud_asset_v1p4beta1_asset_service_proto protoreflect.FileDescriptor

var file_google_cloud_asset_v1p4beta1_asset_service_proto_rawDesc = []byte{
	0x0a, 0x30, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61,
	0x73, 0x73, 0x65, 0x74, 0x2f, 0x76, 0x31, 0x70, 0x34, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x61,
	0x73, 0x73, 0x65, 0x74, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x12, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x70, 0x34, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e,
	0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64,
	0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x29, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x73,
	0x73, 0x65, 0x74, 0x2f, 0x76, 0x31, 0x70, 0x34, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x61, 0x73,
	0x73, 0x65, 0x74, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1a, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x69, 0x61, 0x6d, 0x2f, 0x76, 0x31, 0x2f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6c,
	0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64, 0x75, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x22, 0xea, 0x04, 0x0a, 0x16, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x51, 0x75, 0x65, 0x72, 0x79, 0x12,
	0x1b, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x77, 0x0a, 0x11,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x73, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x6f,
	0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x45, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x70,
	0x34, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x51, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x52, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x10, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x53, 0x65, 0x6c,
	0x65, 0x63, 0x74, 0x6f, 0x72, 0x12, 0x77, 0x0a, 0x11, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74,
	0x79, 0x5f, 0x73, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x45, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x70, 0x34, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69,
	0x73, 0x51, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x53,
	0x65, 0x6c, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x10, 0x69, 0x64,
	0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x12, 0x71,
	0x0a, 0x0f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x73, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x6f,
	0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x70,
	0x34, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x51, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x41, 0x63,
	0x63, 0x65, 0x73, 0x73, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x0e, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x6f,
	0x72, 0x1a, 0x45, 0x0a, 0x10, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x53, 0x65, 0x6c,
	0x65, 0x63, 0x74, 0x6f, 0x72, 0x12, 0x31, 0x0a, 0x12, 0x66, 0x75, 0x6c, 0x6c, 0x5f, 0x72, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x10, 0x66, 0x75, 0x6c, 0x6c, 0x52, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x1a, 0x33, 0x0a, 0x10, 0x49, 0x64, 0x65, 0x6e,
	0x74, 0x69, 0x74, 0x79, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x12, 0x1f, 0x0a, 0x08,
	0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x08, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x1a, 0x52, 0x0a,
	0x0e, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x12,
	0x19, 0x0a, 0x05, 0x72, 0x6f, 0x6c, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x05, 0x72, 0x6f, 0x6c, 0x65, 0x73, 0x12, 0x25, 0x0a, 0x0b, 0x70, 0x65,
	0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x70, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e,
	0x73, 0x22, 0xf8, 0x04, 0x0a, 0x17, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x49, 0x61, 0x6d,
	0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x60, 0x0a,
	0x0e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x5f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x70, 0x34, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x41, 0x6e,
	0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x51, 0x75, 0x65, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x0d, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x51, 0x75, 0x65, 0x72, 0x79, 0x12,
	0x5c, 0x0a, 0x07, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x70, 0x34, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x1a, 0x9c, 0x03,
	0x0a, 0x07, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x28, 0x0a, 0x0d, 0x65, 0x78, 0x70,
	0x61, 0x6e, 0x64, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x65, 0x78, 0x70, 0x61, 0x6e, 0x64, 0x47, 0x72, 0x6f,
	0x75, 0x70, 0x73, 0x12, 0x26, 0x0a, 0x0c, 0x65, 0x78, 0x70, 0x61, 0x6e, 0x64, 0x5f, 0x72, 0x6f,
	0x6c, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b,
	0x65, 0x78, 0x70, 0x61, 0x6e, 0x64, 0x52, 0x6f, 0x6c, 0x65, 0x73, 0x12, 0x2e, 0x0a, 0x10, 0x65,
	0x78, 0x70, 0x61, 0x6e, 0x64, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0f, 0x65, 0x78, 0x70, 0x61,
	0x6e, 0x64, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x12, 0x37, 0x0a, 0x15, 0x6f,
	0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x65,
	0x64, 0x67, 0x65, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x13, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x45,
	0x64, 0x67, 0x65, 0x73, 0x12, 0x31, 0x0a, 0x12, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x67,
	0x72, 0x6f, 0x75, 0x70, 0x5f, 0x65, 0x64, 0x67, 0x65, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x10, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x47, 0x72, 0x6f,
	0x75, 0x70, 0x45, 0x64, 0x67, 0x65, 0x73, 0x12, 0x56, 0x0a, 0x25, 0x61, 0x6e, 0x61, 0x6c, 0x79,
	0x7a, 0x65, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x61, 0x63, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x5f, 0x69, 0x6d, 0x70, 0x65, 0x72, 0x73, 0x6f, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x22, 0x61, 0x6e, 0x61,
	0x6c, 0x79, 0x7a, 0x65, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x49, 0x6d, 0x70, 0x65, 0x72, 0x73, 0x6f, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x4b, 0x0a, 0x11, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x6f, 0x75, 0x74, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x10, 0x65, 0x78, 0x65, 0x63,
	0x75, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x22, 0xc1, 0x05, 0x0a,
	0x18, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x6d, 0x0a, 0x0d, 0x6d, 0x61, 0x69,
	0x6e, 0x5f, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x48, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x70, 0x34, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x52, 0x0c, 0x6d, 0x61, 0x69, 0x6e,
	0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x12, 0x9d, 0x01, 0x0a, 0x26, 0x73, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x5f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x69, 0x6d, 0x70,
	0x65, 0x72, 0x73, 0x6f, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x61, 0x6e, 0x61, 0x6c, 0x79,
	0x73, 0x69, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x48, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76,
	0x31, 0x70, 0x34, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65,
	0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x2e, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x41, 0x6e, 0x61, 0x6c, 0x79,
	0x73, 0x69, 0x73, 0x52, 0x23, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x49, 0x6d, 0x70, 0x65, 0x72, 0x73, 0x6f, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x12, 0x25, 0x0a, 0x0e, 0x66, 0x75, 0x6c, 0x6c,
	0x79, 0x5f, 0x65, 0x78, 0x70, 0x6c, 0x6f, 0x72, 0x65, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x0d, 0x66, 0x75, 0x6c, 0x6c, 0x79, 0x45, 0x78, 0x70, 0x6c, 0x6f, 0x72, 0x65, 0x64, 0x12,
	0x73, 0x0a, 0x13, 0x6e, 0x6f, 0x6e, 0x5f, 0x63, 0x72, 0x69, 0x74, 0x69, 0x63, 0x61, 0x6c, 0x5f,
	0x65, 0x72, 0x72, 0x6f, 0x72, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x43, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65,
	0x74, 0x2e, 0x76, 0x31, 0x70, 0x34, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x49, 0x61, 0x6d, 0x50,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x52, 0x65, 0x73,
	0x75, 0x6c, 0x74, 0x2e, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x53, 0x74, 0x61, 0x74,
	0x65, 0x52, 0x11, 0x6e, 0x6f, 0x6e, 0x43, 0x72, 0x69, 0x74, 0x69, 0x63, 0x61, 0x6c, 0x45, 0x72,
	0x72, 0x6f, 0x72, 0x73, 0x1a, 0xf9, 0x01, 0x0a, 0x11, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x12, 0x5b, 0x0a, 0x0e, 0x61, 0x6e,
	0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x5f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x70, 0x34, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x41, 0x6e, 0x61, 0x6c, 0x79,
	0x73, 0x69, 0x73, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x0d, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x73,
	0x69, 0x73, 0x51, 0x75, 0x65, 0x72, 0x79, 0x12, 0x60, 0x0a, 0x10, 0x61, 0x6e, 0x61, 0x6c, 0x79,
	0x73, 0x69, 0x73, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x70, 0x34, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73,
	0x69, 0x73, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x52, 0x0f, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x73,
	0x69, 0x73, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x12, 0x25, 0x0a, 0x0e, 0x66, 0x75, 0x6c,
	0x6c, 0x79, 0x5f, 0x65, 0x78, 0x70, 0x6c, 0x6f, 0x72, 0x65, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x08, 0x52, 0x0d, 0x66, 0x75, 0x6c, 0x6c, 0x79, 0x45, 0x78, 0x70, 0x6c, 0x6f, 0x72, 0x65, 0x64,
	0x22, 0xce, 0x01, 0x0a, 0x1d, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x41, 0x6e,
	0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x12, 0x75, 0x0a, 0x0f, 0x67, 0x63, 0x73, 0x5f, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74,
	0x2e, 0x76, 0x31, 0x70, 0x34, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x49, 0x61, 0x6d, 0x50, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x4f, 0x75, 0x74, 0x70,
	0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x47, 0x63, 0x73, 0x44, 0x65, 0x73, 0x74,
	0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x0e, 0x67, 0x63, 0x73, 0x44, 0x65,
	0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x1a, 0x27, 0x0a, 0x0e, 0x47, 0x63, 0x73,
	0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x15, 0x0a, 0x03, 0x75,
	0x72, 0x69, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x03, 0x75,
	0x72, 0x69, 0x42, 0x0d, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x22, 0xa0, 0x05, 0x0a, 0x1e, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x49, 0x61, 0x6d, 0x50,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x60, 0x0a, 0x0e, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73,
	0x5f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65,
	0x74, 0x2e, 0x76, 0x31, 0x70, 0x34, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x49, 0x61, 0x6d, 0x50,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x51, 0x75, 0x65,
	0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0d, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69,
	0x73, 0x51, 0x75, 0x65, 0x72, 0x79, 0x12, 0x63, 0x0a, 0x07, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x44, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x70,
	0x34, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x49, 0x61, 0x6d,
	0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x07, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x65, 0x0a, 0x0d, 0x6f,
	0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x70, 0x34, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x41, 0x6e, 0x61, 0x6c, 0x79,
	0x73, 0x69, 0x73, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x1a, 0xcf, 0x02, 0x0a, 0x07, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x28,
	0x0a, 0x0d, 0x65, 0x78, 0x70, 0x61, 0x6e, 0x64, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x65, 0x78, 0x70, 0x61,
	0x6e, 0x64, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x12, 0x26, 0x0a, 0x0c, 0x65, 0x78, 0x70, 0x61,
	0x6e, 0x64, 0x5f, 0x72, 0x6f, 0x6c, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x0b, 0x65, 0x78, 0x70, 0x61, 0x6e, 0x64, 0x52, 0x6f, 0x6c, 0x65, 0x73,
	0x12, 0x2e, 0x0a, 0x10, 0x65, 0x78, 0x70, 0x61, 0x6e, 0x64, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x0f, 0x65, 0x78, 0x70, 0x61, 0x6e, 0x64, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73,
	0x12, 0x37, 0x0a, 0x15, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x5f, 0x65, 0x64, 0x67, 0x65, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x13, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x52, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x45, 0x64, 0x67, 0x65, 0x73, 0x12, 0x31, 0x0a, 0x12, 0x6f, 0x75, 0x74,
	0x70, 0x75, 0x74, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x65, 0x64, 0x67, 0x65, 0x73, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x10, 0x6f, 0x75, 0x74, 0x70,
	0x75, 0x74, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x45, 0x64, 0x67, 0x65, 0x73, 0x12, 0x56, 0x0a, 0x25,
	0x61, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f,
	0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x69, 0x6d, 0x70, 0x65, 0x72, 0x73, 0x6f, 0x6e,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x22, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x49, 0x6d, 0x70, 0x65, 0x72, 0x73, 0x6f, 0x6e, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x22, 0x83, 0x01, 0x0a, 0x1f, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x49,
	0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x60, 0x0a, 0x0d, 0x6f, 0x75, 0x74, 0x70,
	0x75, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61,
	0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x70, 0x34, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x49,
	0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73,
	0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0c, 0x6f, 0x75,
	0x74, 0x70, 0x75, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x32, 0xe5, 0x04, 0x0a, 0x0c, 0x41,
	0x73, 0x73, 0x65, 0x74, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0xc2, 0x01, 0x0a, 0x10,
	0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x12, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x70, 0x34, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x70,
	0x34, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x49, 0x61,
	0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22,
	0x3f, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x39, 0x12, 0x37, 0x2f, 0x76, 0x31, 0x70, 0x34, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2f, 0x7b, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x5f, 0x71, 0x75,
	0x65, 0x72, 0x79, 0x2e, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x2a, 0x2f, 0x2a, 0x7d, 0x3a,
	0x61, 0x6e, 0x61, 0x6c, 0x79, 0x7a, 0x65, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x12, 0xc0, 0x02, 0x0a, 0x17, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x12, 0x3c, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65,
	0x74, 0x2e, 0x76, 0x31, 0x70, 0x34, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x45, 0x78, 0x70, 0x6f,
	0x72, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x41, 0x6e, 0x61, 0x6c, 0x79,
	0x73, 0x69, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xc7, 0x01, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x43, 0x22, 0x3e, 0x2f, 0x76, 0x31, 0x70, 0x34, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x7b,
	0x61, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x5f, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x2a, 0x2f, 0x2a, 0x7d, 0x3a, 0x65, 0x78, 0x70, 0x6f, 0x72,
	0x74, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73,
	0x69, 0x73, 0x3a, 0x01, 0x2a, 0xca, 0x41, 0x7b, 0x0a, 0x3c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x70,
	0x34, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x49, 0x61, 0x6d,
	0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x3b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31, 0x70, 0x34, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x4d, 0xca, 0x41, 0x19, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x61, 0x73, 0x73,
	0x65, 0x74, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0xd2, 0x41, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61,
	0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x42, 0xb8, 0x01, 0x0a, 0x20, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2e, 0x76, 0x31,
	0x70, 0x34, 0x62, 0x65, 0x74, 0x61, 0x31, 0x42, 0x11, 0x41, 0x73, 0x73, 0x65, 0x74, 0x53, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x41, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f,
	0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x73, 0x73, 0x65, 0x74, 0x2f,
	0x76, 0x31, 0x70, 0x34, 0x62, 0x65, 0x74, 0x61, 0x31, 0x3b, 0x61, 0x73, 0x73, 0x65, 0x74, 0xaa,
	0x02, 0x1c, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x41,
	0x73, 0x73, 0x65, 0x74, 0x2e, 0x56, 0x31, 0x50, 0x34, 0x42, 0x65, 0x74, 0x61, 0x31, 0xca, 0x02,
	0x1c, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x41, 0x73,
	0x73, 0x65, 0x74, 0x5c, 0x56, 0x31, 0x70, 0x34, 0x62, 0x65, 0x74, 0x61, 0x31, 0x62, 0x06, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_asset_v1p4beta1_asset_service_proto_rawDescOnce sync.Once
	file_google_cloud_asset_v1p4beta1_asset_service_proto_rawDescData = file_google_cloud_asset_v1p4beta1_asset_service_proto_rawDesc
)

func file_google_cloud_asset_v1p4beta1_asset_service_proto_rawDescGZIP() []byte {
	file_google_cloud_asset_v1p4beta1_asset_service_proto_rawDescOnce.Do(func() {
		file_google_cloud_asset_v1p4beta1_asset_service_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_asset_v1p4beta1_asset_service_proto_rawDescData)
	})
	return file_google_cloud_asset_v1p4beta1_asset_service_proto_rawDescData
}

var file_google_cloud_asset_v1p4beta1_asset_service_proto_msgTypes = make([]protoimpl.MessageInfo, 13)
var file_google_cloud_asset_v1p4beta1_asset_service_proto_goTypes = []interface{}{
	(*IamPolicyAnalysisQuery)(nil),                       // 0: google.cloud.asset.v1p4beta1.IamPolicyAnalysisQuery
	(*AnalyzeIamPolicyRequest)(nil),                      // 1: google.cloud.asset.v1p4beta1.AnalyzeIamPolicyRequest
	(*AnalyzeIamPolicyResponse)(nil),                     // 2: google.cloud.asset.v1p4beta1.AnalyzeIamPolicyResponse
	(*IamPolicyAnalysisOutputConfig)(nil),                // 3: google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig
	(*ExportIamPolicyAnalysisRequest)(nil),               // 4: google.cloud.asset.v1p4beta1.ExportIamPolicyAnalysisRequest
	(*ExportIamPolicyAnalysisResponse)(nil),              // 5: google.cloud.asset.v1p4beta1.ExportIamPolicyAnalysisResponse
	(*IamPolicyAnalysisQuery_ResourceSelector)(nil),      // 6: google.cloud.asset.v1p4beta1.IamPolicyAnalysisQuery.ResourceSelector
	(*IamPolicyAnalysisQuery_IdentitySelector)(nil),      // 7: google.cloud.asset.v1p4beta1.IamPolicyAnalysisQuery.IdentitySelector
	(*IamPolicyAnalysisQuery_AccessSelector)(nil),        // 8: google.cloud.asset.v1p4beta1.IamPolicyAnalysisQuery.AccessSelector
	(*AnalyzeIamPolicyRequest_Options)(nil),              // 9: google.cloud.asset.v1p4beta1.AnalyzeIamPolicyRequest.Options
	(*AnalyzeIamPolicyResponse_IamPolicyAnalysis)(nil),   // 10: google.cloud.asset.v1p4beta1.AnalyzeIamPolicyResponse.IamPolicyAnalysis
	(*IamPolicyAnalysisOutputConfig_GcsDestination)(nil), // 11: google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig.GcsDestination
	(*ExportIamPolicyAnalysisRequest_Options)(nil),       // 12: google.cloud.asset.v1p4beta1.ExportIamPolicyAnalysisRequest.Options
	(*IamPolicyAnalysisResult_AnalysisState)(nil),        // 13: google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState
	(*duration.Duration)(nil),                            // 14: google.protobuf.Duration
	(*IamPolicyAnalysisResult)(nil),                      // 15: google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult
	(*longrunning.Operation)(nil),                        // 16: google.longrunning.Operation
}
var file_google_cloud_asset_v1p4beta1_asset_service_proto_depIdxs = []int32{
	6,  // 0: google.cloud.asset.v1p4beta1.IamPolicyAnalysisQuery.resource_selector:type_name -> google.cloud.asset.v1p4beta1.IamPolicyAnalysisQuery.ResourceSelector
	7,  // 1: google.cloud.asset.v1p4beta1.IamPolicyAnalysisQuery.identity_selector:type_name -> google.cloud.asset.v1p4beta1.IamPolicyAnalysisQuery.IdentitySelector
	8,  // 2: google.cloud.asset.v1p4beta1.IamPolicyAnalysisQuery.access_selector:type_name -> google.cloud.asset.v1p4beta1.IamPolicyAnalysisQuery.AccessSelector
	0,  // 3: google.cloud.asset.v1p4beta1.AnalyzeIamPolicyRequest.analysis_query:type_name -> google.cloud.asset.v1p4beta1.IamPolicyAnalysisQuery
	9,  // 4: google.cloud.asset.v1p4beta1.AnalyzeIamPolicyRequest.options:type_name -> google.cloud.asset.v1p4beta1.AnalyzeIamPolicyRequest.Options
	10, // 5: google.cloud.asset.v1p4beta1.AnalyzeIamPolicyResponse.main_analysis:type_name -> google.cloud.asset.v1p4beta1.AnalyzeIamPolicyResponse.IamPolicyAnalysis
	10, // 6: google.cloud.asset.v1p4beta1.AnalyzeIamPolicyResponse.service_account_impersonation_analysis:type_name -> google.cloud.asset.v1p4beta1.AnalyzeIamPolicyResponse.IamPolicyAnalysis
	13, // 7: google.cloud.asset.v1p4beta1.AnalyzeIamPolicyResponse.non_critical_errors:type_name -> google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult.AnalysisState
	11, // 8: google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig.gcs_destination:type_name -> google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig.GcsDestination
	0,  // 9: google.cloud.asset.v1p4beta1.ExportIamPolicyAnalysisRequest.analysis_query:type_name -> google.cloud.asset.v1p4beta1.IamPolicyAnalysisQuery
	12, // 10: google.cloud.asset.v1p4beta1.ExportIamPolicyAnalysisRequest.options:type_name -> google.cloud.asset.v1p4beta1.ExportIamPolicyAnalysisRequest.Options
	3,  // 11: google.cloud.asset.v1p4beta1.ExportIamPolicyAnalysisRequest.output_config:type_name -> google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig
	3,  // 12: google.cloud.asset.v1p4beta1.ExportIamPolicyAnalysisResponse.output_config:type_name -> google.cloud.asset.v1p4beta1.IamPolicyAnalysisOutputConfig
	14, // 13: google.cloud.asset.v1p4beta1.AnalyzeIamPolicyRequest.Options.execution_timeout:type_name -> google.protobuf.Duration
	0,  // 14: google.cloud.asset.v1p4beta1.AnalyzeIamPolicyResponse.IamPolicyAnalysis.analysis_query:type_name -> google.cloud.asset.v1p4beta1.IamPolicyAnalysisQuery
	15, // 15: google.cloud.asset.v1p4beta1.AnalyzeIamPolicyResponse.IamPolicyAnalysis.analysis_results:type_name -> google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult
	1,  // 16: google.cloud.asset.v1p4beta1.AssetService.AnalyzeIamPolicy:input_type -> google.cloud.asset.v1p4beta1.AnalyzeIamPolicyRequest
	4,  // 17: google.cloud.asset.v1p4beta1.AssetService.ExportIamPolicyAnalysis:input_type -> google.cloud.asset.v1p4beta1.ExportIamPolicyAnalysisRequest
	2,  // 18: google.cloud.asset.v1p4beta1.AssetService.AnalyzeIamPolicy:output_type -> google.cloud.asset.v1p4beta1.AnalyzeIamPolicyResponse
	16, // 19: google.cloud.asset.v1p4beta1.AssetService.ExportIamPolicyAnalysis:output_type -> google.longrunning.Operation
	18, // [18:20] is the sub-list for method output_type
	16, // [16:18] is the sub-list for method input_type
	16, // [16:16] is the sub-list for extension type_name
	16, // [16:16] is the sub-list for extension extendee
	0,  // [0:16] is the sub-list for field type_name
}

func init() { file_google_cloud_asset_v1p4beta1_asset_service_proto_init() }
func file_google_cloud_asset_v1p4beta1_asset_service_proto_init() {
	if File_google_cloud_asset_v1p4beta1_asset_service_proto != nil {
		return
	}
	file_google_cloud_asset_v1p4beta1_assets_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_asset_v1p4beta1_asset_service_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IamPolicyAnalysisQuery); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1p4beta1_asset_service_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AnalyzeIamPolicyRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1p4beta1_asset_service_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AnalyzeIamPolicyResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1p4beta1_asset_service_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IamPolicyAnalysisOutputConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1p4beta1_asset_service_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExportIamPolicyAnalysisRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1p4beta1_asset_service_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExportIamPolicyAnalysisResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1p4beta1_asset_service_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IamPolicyAnalysisQuery_ResourceSelector); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1p4beta1_asset_service_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IamPolicyAnalysisQuery_IdentitySelector); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1p4beta1_asset_service_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IamPolicyAnalysisQuery_AccessSelector); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1p4beta1_asset_service_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AnalyzeIamPolicyRequest_Options); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1p4beta1_asset_service_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AnalyzeIamPolicyResponse_IamPolicyAnalysis); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1p4beta1_asset_service_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*IamPolicyAnalysisOutputConfig_GcsDestination); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_asset_v1p4beta1_asset_service_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExportIamPolicyAnalysisRequest_Options); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_asset_v1p4beta1_asset_service_proto_msgTypes[3].OneofWrappers = []interface{}{
		(*IamPolicyAnalysisOutputConfig_GcsDestination_)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_asset_v1p4beta1_asset_service_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   13,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_asset_v1p4beta1_asset_service_proto_goTypes,
		DependencyIndexes: file_google_cloud_asset_v1p4beta1_asset_service_proto_depIdxs,
		MessageInfos:      file_google_cloud_asset_v1p4beta1_asset_service_proto_msgTypes,
	}.Build()
	File_google_cloud_asset_v1p4beta1_asset_service_proto = out.File
	file_google_cloud_asset_v1p4beta1_asset_service_proto_rawDesc = nil
	file_google_cloud_asset_v1p4beta1_asset_service_proto_goTypes = nil
	file_google_cloud_asset_v1p4beta1_asset_service_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// AssetServiceClient is the client API for AssetService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type AssetServiceClient interface {
	// Analyzes IAM policies based on the specified request. Returns
	// a list of [IamPolicyAnalysisResult][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult] matching the request.
	AnalyzeIamPolicy(ctx context.Context, in *AnalyzeIamPolicyRequest, opts ...grpc.CallOption) (*AnalyzeIamPolicyResponse, error)
	// Exports IAM policy analysis based on the specified request. This API
	// implements the [google.longrunning.Operation][google.longrunning.Operation] API allowing you to keep
	// track of the export. The metadata contains the request to help callers to
	// map responses to requests.
	ExportIamPolicyAnalysis(ctx context.Context, in *ExportIamPolicyAnalysisRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
}

type assetServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewAssetServiceClient(cc grpc.ClientConnInterface) AssetServiceClient {
	return &assetServiceClient{cc}
}

func (c *assetServiceClient) AnalyzeIamPolicy(ctx context.Context, in *AnalyzeIamPolicyRequest, opts ...grpc.CallOption) (*AnalyzeIamPolicyResponse, error) {
	out := new(AnalyzeIamPolicyResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.asset.v1p4beta1.AssetService/AnalyzeIamPolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *assetServiceClient) ExportIamPolicyAnalysis(ctx context.Context, in *ExportIamPolicyAnalysisRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.asset.v1p4beta1.AssetService/ExportIamPolicyAnalysis", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// AssetServiceServer is the server API for AssetService service.
type AssetServiceServer interface {
	// Analyzes IAM policies based on the specified request. Returns
	// a list of [IamPolicyAnalysisResult][google.cloud.asset.v1p4beta1.IamPolicyAnalysisResult] matching the request.
	AnalyzeIamPolicy(context.Context, *AnalyzeIamPolicyRequest) (*AnalyzeIamPolicyResponse, error)
	// Exports IAM policy analysis based on the specified request. This API
	// implements the [google.longrunning.Operation][google.longrunning.Operation] API allowing you to keep
	// track of the export. The metadata contains the request to help callers to
	// map responses to requests.
	ExportIamPolicyAnalysis(context.Context, *ExportIamPolicyAnalysisRequest) (*longrunning.Operation, error)
}

// UnimplementedAssetServiceServer can be embedded to have forward compatible implementations.
type UnimplementedAssetServiceServer struct {
}

func (*UnimplementedAssetServiceServer) AnalyzeIamPolicy(context.Context, *AnalyzeIamPolicyRequest) (*AnalyzeIamPolicyResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AnalyzeIamPolicy not implemented")
}
func (*UnimplementedAssetServiceServer) ExportIamPolicyAnalysis(context.Context, *ExportIamPolicyAnalysisRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ExportIamPolicyAnalysis not implemented")
}

func RegisterAssetServiceServer(s *grpc.Server, srv AssetServiceServer) {
	s.RegisterService(&_AssetService_serviceDesc, srv)
}

func _AssetService_AnalyzeIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AnalyzeIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AssetServiceServer).AnalyzeIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.asset.v1p4beta1.AssetService/AnalyzeIamPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AssetServiceServer).AnalyzeIamPolicy(ctx, req.(*AnalyzeIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AssetService_ExportIamPolicyAnalysis_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ExportIamPolicyAnalysisRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AssetServiceServer).ExportIamPolicyAnalysis(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.asset.v1p4beta1.AssetService/ExportIamPolicyAnalysis",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AssetServiceServer).ExportIamPolicyAnalysis(ctx, req.(*ExportIamPolicyAnalysisRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _AssetService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.asset.v1p4beta1.AssetService",
	HandlerType: (*AssetServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "AnalyzeIamPolicy",
			Handler:    _AssetService_AnalyzeIamPolicy_Handler,
		},
		{
			MethodName: "ExportIamPolicyAnalysis",
			Handler:    _AssetService_ExportIamPolicyAnalysis_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/asset/v1p4beta1/asset_service.proto",
}
